/*
 * Decompiled with CFR 0.152.
 */
package com.eg.agent.trace;

import com.eg.agent.Utilities;
import com.eg.agent.trace.utils.DataBaseUtils;
import com.eg.agent.trace.utils.ExceptionUtils;
import com.eg.agent.trace.utils.HtmlTagChecker;
import com.eg.agent.trace.utils.TraceUtils;
import com.eg.jtm.BTMDiscovery;
import com.eg.jtm.BTMLog;
import com.eg.jtm.BTMPojoBoolean;
import com.eg.jtm.BTMSqlBoolean;
import com.eg.jtm.BTMUtils;
import com.eg.jtm.MethodEventProcessor;
import com.eg.jtm.MethodInfo;
import com.eg.jtm.PropsManager;
import com.eg.jtm.RequestIdentifier;
import com.eg.jtm.RumPropsManager;
import com.eg.jtm.UPDManager;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import sun.rmi.transport.Channel;
import sun.rmi.transport.StreamRemoteCall;
import sun.rmi.transport.tcp.TCPEndpoint;

public class RootTracer {
    public static ThreadLocal<BTMPojoBoolean> pojoBlockLocal = new ThreadLocal();
    public static ThreadLocal<BTMSqlBoolean> sqlBlockLocal = new ThreadLocal();

    private RootTracer() {
    }

    public static final void measureMethodBegin(Object object, String string, String string2) {
        try {
            RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
            if (requestIdentifier == null) {
                return;
            }
            if (!requestIdentifier.capturedIcValues()) {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                arrayList.add(object);
                BTMLog.logger.info("[IC_for_APM] Going to set value of type Object; [Measure id = {}] : Value = {}", (Object)string, object);
                TraceUtils.setMeasureValue(arrayList, string, string2, requestIdentifier);
            }
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer] [measureMethodBegin - Object] - {} ", throwable);
        }
    }

    public static final void measureMethodBegin(String string, String string2, String string3) {
        try {
            RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
            if (requestIdentifier == null) {
                return;
            }
            if (!requestIdentifier.capturedIcValues()) {
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(string);
                BTMLog.logger.info("[IC_for_APM] Going to set value of type String; [Measure id = {}] : Value = {}", (Object)string2, (Object)string);
                TraceUtils.setMeasureValue(arrayList, string2, string3, requestIdentifier);
            }
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer] [measureMethodBegin - String] - {} ", throwable);
        }
    }

    public static final void measureMethodBegin(boolean bl, String string, String string2) {
        try {
            RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
            if (requestIdentifier == null) {
                return;
            }
            if (!requestIdentifier.capturedIcValues()) {
                ArrayList<Boolean> arrayList = new ArrayList<Boolean>();
                arrayList.add(bl);
                BTMLog.logger.info("[IC_for_APM] Going to set value of type Boolean; [Measure id = {}] : Value = {}", (Object)string, (Object)bl);
                TraceUtils.setMeasureValue(arrayList, string, string2, requestIdentifier);
            }
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer] [measureMethodBegin - boolean] - {} ", throwable);
        }
    }

    public static final void measureMethodBegin(byte by, String string, String string2) {
        try {
            RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
            if (requestIdentifier == null) {
                return;
            }
            if (!requestIdentifier.capturedIcValues()) {
                ArrayList<Byte> arrayList = new ArrayList<Byte>();
                arrayList.add(by);
                BTMLog.logger.info("[IC_for_APM] Going to set value of type Byte; [Measure id = {}] : Value = {}", (Object)string, (Object)by);
                TraceUtils.setMeasureValue(arrayList, string, string2, requestIdentifier);
            }
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer] [measureMethodBegin - byte] - {} ", throwable);
        }
    }

    public static final void measureMethodBegin(byte[] byArray, String string, String string2) {
        try {
            RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
            if (requestIdentifier == null) {
                return;
            }
            if (!requestIdentifier.capturedIcValues()) {
                ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
                arrayList.add(byArray);
                BTMLog.logger.info("[IC_for_APM] Going to set value of type Byte Array; [Measure id = {}] : Value = {}", (Object)string, (Object)byArray);
                TraceUtils.setMeasureValue(arrayList, string, string2, requestIdentifier);
            }
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer] [measureMethodBegin - byte[]] - {} ", throwable);
        }
    }

    public static final void measureMethodBegin(char c, String string, String string2) {
        try {
            RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
            if (requestIdentifier == null) {
                return;
            }
            if (!requestIdentifier.capturedIcValues()) {
                ArrayList<Character> arrayList = new ArrayList<Character>();
                arrayList.add(Character.valueOf(c));
                BTMLog.logger.info("[IC_for_APM] Going to set value of type Char; [Measure id = {}] : Value = {}", (Object)string, (Object)Character.valueOf(c));
                TraceUtils.setMeasureValue(arrayList, string, string2, requestIdentifier);
            }
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer] [measureMethodBegin - char] - {} ", throwable);
        }
    }

    public static final void measureMethodBegin(int n, String string, String string2) {
        try {
            RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
            if (requestIdentifier == null) {
                return;
            }
            if (!requestIdentifier.capturedIcValues()) {
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                arrayList.add(n);
                BTMLog.logger.info("[IC_for_APM] Going to set value of type Int; [Measure id = {}] : Value = {}", (Object)string, (Object)n);
                TraceUtils.setMeasureValue(arrayList, string, string2, requestIdentifier);
            }
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer] [measureMethodBegin - int] - {} ", throwable);
        }
    }

    public static final void measureMethodBegin(long l, String string, String string2) {
        try {
            RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
            if (requestIdentifier == null) {
                return;
            }
            if (!requestIdentifier.capturedIcValues()) {
                ArrayList<Long> arrayList = new ArrayList<Long>();
                arrayList.add(l);
                BTMLog.logger.info("[IC_for_APM] Going to set value of type Long; [Measure id = {}] : Value = {}", (Object)string, (Object)l);
                TraceUtils.setMeasureValue(arrayList, string, string2, requestIdentifier);
            }
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer] [measureMethodBegin - long] - {} ", throwable);
        }
    }

    public static final void measureMethodBegin(short s, String string, String string2) {
        try {
            RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
            if (requestIdentifier == null) {
                return;
            }
            if (!requestIdentifier.capturedIcValues()) {
                ArrayList<Short> arrayList = new ArrayList<Short>();
                arrayList.add(s);
                BTMLog.logger.info("[IC_for_APM] Going to set value of type Short; [Measure id = {}] : Value = {}", (Object)string, (Object)s);
                TraceUtils.setMeasureValue(arrayList, string, string2, requestIdentifier);
            }
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer] [measureMethodBegin - short] - {} ", throwable);
        }
    }

    public static final void measureMethodBegin(double d, String string, String string2) {
        try {
            RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
            if (requestIdentifier == null) {
                return;
            }
            if (!requestIdentifier.capturedIcValues()) {
                ArrayList<Double> arrayList = new ArrayList<Double>();
                arrayList.add(d);
                BTMLog.logger.info("[IC_for_APM] Going to set value of type Double; [Measure id = {}] : Value = {}", (Object)string, (Object)d);
                TraceUtils.setMeasureValue(arrayList, string, string2, requestIdentifier);
            }
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer] [measureMethodBegin - double] - {} ", throwable);
        }
    }

    public static final void measureMethodBegin(float f, String string, String string2) {
        try {
            RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
            if (requestIdentifier == null) {
                return;
            }
            if (!requestIdentifier.capturedIcValues()) {
                ArrayList<Float> arrayList = new ArrayList<Float>();
                arrayList.add(Float.valueOf(f));
                BTMLog.logger.info("[IC_for_APM] Going to set value of type Float; [Measure id = {}] : Value = {}", (Object)string, (Object)Float.valueOf(f));
                TraceUtils.setMeasureValue(arrayList, string, string2, requestIdentifier);
            }
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer] [measureMethodBegin - float] - {} ", throwable);
        }
    }

    public static final void getOutEnd(Object object, Object object2, String string, String string2, String string3) {
        try {
            RequestIdentifier requestIdentifier;
            if (object != null && (requestIdentifier = MethodEventProcessor.getRequestIdentifier()) != null) {
                requestIdentifier.setWriterObj(object);
                requestIdentifier.setOutputStreamObject(null);
            }
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer][getOutEnd] - {} ", throwable);
        }
    }

    public static final void jspWriterWriteEnd(Object object, String string, String string2, String string3, String string4) {
        try {
            RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
            if (requestIdentifier != null && requestIdentifier.getWriterObj() == object) {
                if (requestIdentifier.getTags().isTagFound()) {
                    return;
                }
                HtmlTagChecker.checkTag(requestIdentifier, string);
            }
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer][jspWriterWriteEnd] - {} ", throwable);
        }
    }

    public static final void getWriterMethodEnd(Object object, String string, String string2, String string3) {
        try {
            RequestIdentifier requestIdentifier;
            if (object != null && (requestIdentifier = MethodEventProcessor.getRequestIdentifier()) != null) {
                requestIdentifier.setWriterObj(object);
                requestIdentifier.setOutputStreamObject(null);
            }
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer][getWriterMethodEnd] - {} ", throwable);
        }
    }

    public static final void intWriterEnd(Object object, int n, String string, String string2, String string3) {
        try {
            RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
            if (requestIdentifier != null && requestIdentifier.getWriterObj() == object) {
                if (requestIdentifier.getTags().isTagFound()) {
                    return;
                }
                if (n == 32 || n == 60 || n == 47 || n == 62) {
                    char c = (char)n;
                    if (requestIdentifier.getTemplateBuilder() == null) {
                        requestIdentifier.createNewTemplateBuilder(String.valueOf(c));
                    } else {
                        requestIdentifier.getTemplateBuilder().append(String.valueOf(c));
                        if (n == 62) {
                            String string4 = requestIdentifier.getTemplateBuilder().toString();
                            HtmlTagChecker.checkTag(requestIdentifier, string4);
                            requestIdentifier.createNewTemplateBuilder("");
                        }
                    }
                }
            }
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer][intWriterEnd] - {} ", throwable);
        }
    }

    public static final void printWriterEnd(Object object, Object object2, String string, String string2, String string3) {
        try {
            RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
            if (requestIdentifier != null && requestIdentifier.getWriterObj() == object) {
                if (requestIdentifier.getTags().isTagFound()) {
                    return;
                }
                String string4 = null;
                string4 = object2 instanceof String ? object2.toString() : new String((char[])object2);
                HtmlTagChecker.checkTag(requestIdentifier, string4);
            }
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer][printWriterEnd] - {} ", throwable);
        }
    }

    public static final void getOutputStreamMethodEnd(Object object, String string, String string2, String string3) {
        try {
            RequestIdentifier requestIdentifier;
            if (object != null && (requestIdentifier = MethodEventProcessor.getRequestIdentifier()) != null) {
                requestIdentifier.setOutputStreamObject(object);
                requestIdentifier.setWriterObj(null);
            }
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer][getOutputStreamMethodEnd] - {} ", throwable);
        }
    }

    public static final void outputStreamWriterEnd(Object object, Object object2, String string, String string2, String string3) {
        try {
            RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
            if (requestIdentifier != null && requestIdentifier.getOutputStreamObject() == object) {
                if (requestIdentifier.getTags().isTagFound()) {
                    return;
                }
                String string4 = null;
                try {
                    byte[] byArray = (byte[])object2;
                    string4 = new String(byArray);
                    HtmlTagChecker.checkTag(requestIdentifier, string4);
                }
                catch (Exception exception) {
                    BTMLog.logger.warn("Exception occurred while converting byte[] to String, So assiging PARSE_ERROR ", exception);
                    requestIdentifier.setTags(HtmlTagChecker.TAGS.PARSE_ERROR);
                    string4 = null;
                }
            }
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer][outputStreamWriterEnd] - {} ", throwable);
        }
    }

    public static final void outputStreamPrintMethodEnd(Object object, String string, String string2, String string3, String string4) {
        try {
            RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
            if (requestIdentifier != null && requestIdentifier.getOutputStreamObject() == object) {
                if (requestIdentifier.getTags().isTagFound()) {
                    return;
                }
                HtmlTagChecker.checkTag(requestIdentifier, string);
            }
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer][outputStreamPrintMethodEnd] - {} ", throwable);
        }
    }

    public static final boolean requestDispatcherMethodBegin(Object object, String string, String string2, String string3) {
        try {
            RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
            if (requestIdentifier != null) {
                requestIdentifier.setRequestForwarded(true);
                return true;
            }
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer][requestDispatcherMethodBegin] - {} ", throwable);
        }
        return false;
    }

    private static HashMap getRequestMap(Object object, Object object2, RequestIdentifier requestIdentifier) {
        HashMap hashMap = new HashMap();
        if (requestIdentifier == null) {
            hashMap = TraceUtils.requestDetails(object, object2);
        }
        return hashMap;
    }

    public static final void initMethodEnd(Object object, Object object2, String string, String string2, String string3) {
        try {
            TraceUtils.containerNameDiscovery(object, object2);
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer][initMethodEnd] - {} ", throwable);
        }
    }

    public static final boolean topComponentMethodBegin(Object object, Object object2, Object object3, String string, String string2, String string3, String string4, String string5) {
        boolean bl = false;
        try {
            if (!PropsManager.isTalkingToAgent()) {
                return false;
            }
            RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
            HashMap hashMap = RootTracer.getRequestMap(object2, object3, requestIdentifier);
            String string6 = null;
            if (hashMap != null && hashMap.containsKey("MATCH")) {
                string6 = (String)hashMap.remove("MATCH");
            }
            bl = MethodEventProcessor.eventStarted(requestIdentifier, hashMap, string5, string, string2, string3, BTMUtils.getTimeStamp(), string6, object3, object2, object);
            if (string4.length() > 0 && bl && RumPropsManager.isRumEnabled()) {
                TraceUtils.autoRumInjectionBegin(object3, string, string4);
            }
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer][topComponentMethodBegin] - {} ", throwable);
        }
        return bl;
    }

    public static final void topComponentMethodEnd(Object object, Object object2, Object object3, String string, String string2, String string3, String string4, boolean bl, int n) {
        try {
            if (bl) {
                RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
                TraceUtils.autoRumInjectionEnd(requestIdentifier, object, object3, string4, string, string2, string3, n);
                MethodEventProcessor.rootEventEnded(requestIdentifier, n == 191, BTMUtils.getTimeStamp(), object3, object2, object);
            }
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer][topComponentMethodEnd] - {} ", throwable);
        }
    }

    public static final boolean responseMethodBegin(Object object, int n, Object object2, String string, String string2, String string3, String string4) {
        try {
            RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
            if (requestIdentifier != null) {
                requestIdentifier.setStatusCode(n);
                if (object2 != null) {
                    requestIdentifier.setStatusMessage(object2.toString());
                }
                BTMLog.logger.debug("[RootTracer - responseMethodBegin] - {} : {} Status Code : {} Status Message : {} : {} : {} : {} : {}", requestIdentifier.getReqGUID(), object, n, object2, string, string2, string3, string4);
            }
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer][responseMethodBegin] - {} ", throwable);
        }
        return false;
    }

    public static final boolean renderMethodBegin(String string, String string2, String string3, String string4) {
        try {
            RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
            if (requestIdentifier == null || requestIdentifier.isPointcutLimitReached()) {
                return false;
            }
            return MethodEventProcessor.eventStarted(requestIdentifier, null, string4, string, string2, string3, BTMUtils.getTimeStamp(), null);
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer][renderMethodBegin] - {} ", throwable);
            return false;
        }
    }

    public static final void methodEnd(String string, String string2, String string3, boolean bl, int n) {
        try {
            if (bl) {
                RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
                MethodEventProcessor.eventEnded(requestIdentifier, n == 191, BTMUtils.getTimeStamp());
            }
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer][methodEnd] - {} ", throwable);
        }
    }

    public static final boolean mailMethodBegin(Object object, String string, String string2, String string3) {
        try {
            RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
            if (requestIdentifier == null || requestIdentifier.isPointcutLimitReached()) {
                return false;
            }
            String string4 = null;
            if (!string2.equals("send")) {
                string4 = TraceUtils.getEmailServerAddress(object);
            }
            if (string4 == null) {
                string4 = "-";
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("method", string2);
            hashMap.put("endPoint", string4);
            return MethodEventProcessor.eventStarted(requestIdentifier, hashMap, "EMAIL", string, string2, string3, BTMUtils.getTimeStamp(), null);
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer][mailMethodBegin] - {} ", throwable);
            return false;
        }
    }

    public static final boolean pojoMethodBegin(String string, String string2, String string3) {
        try {
            BTMPojoBoolean bTMPojoBoolean = pojoBlockLocal.get();
            if (bTMPojoBoolean == null || bTMPojoBoolean.isPojoFlag()) {
                return false;
            }
            RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
            if (requestIdentifier != null) {
                boolean bl = requestIdentifier.onMethodStart(string, string2, string3, BTMUtils.getTimeStamp(), null, "POJO");
                return bl;
            }
            pojoBlockLocal.set(null);
            return false;
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer][pojoMethodBegin] - {} ", throwable);
            return false;
        }
    }

    public static final void pojoMethodEnd(String string, String string2, String string3, boolean bl, int n) {
        try {
            if (bl) {
                RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
                MethodEventProcessor.eventEnded(requestIdentifier, n == 191, BTMUtils.getTimeStamp());
            }
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer][pojoMethodEnd] {} ", throwable);
        }
    }

    public static final boolean threadJoinMethodBegin(String string, String string2, String string3) {
        try {
            RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
            if (requestIdentifier == null || requestIdentifier.isPointcutLimitReached()) {
                return false;
            }
            return MethodEventProcessor.eventStarted(requestIdentifier, null, "THREAD_JOIN", string, string2, string3, BTMUtils.getTimeStamp(), null);
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer][threadJoinMethodBegin] - {} ", throwable);
            return false;
        }
    }

    public static final void threadJoinMethodEnd(String string, String string2, String string3, boolean bl, int n) {
        try {
            if (bl) {
                RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
                if (n == 191) {
                    MethodEventProcessor.eventEnded(requestIdentifier, true, BTMUtils.getTimeStamp());
                } else {
                    MethodEventProcessor.pojoEventEnded(requestIdentifier, false, BTMUtils.getTimeStamp());
                }
            }
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer][threadJoinMethodEnd] - {} ", throwable);
        }
    }

    public static final boolean jdbcConnectionMethodBegin(String string, String string2, String string3) {
        try {
            RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
            if (requestIdentifier == null || requestIdentifier.isPointcutLimitReached()) {
                return false;
            }
            sqlBlockLocal.set(null);
            return MethodEventProcessor.eventStarted(requestIdentifier, null, "JDBC", string, string2, string3, BTMUtils.getTimeStamp(), null);
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer][jdbcConnectionMethodBegin] - {} ", throwable);
            return false;
        }
    }

    private static void setSQLThreadLocal() {
        BTMSqlBoolean bTMSqlBoolean = new BTMSqlBoolean();
        bTMSqlBoolean.setSqlFlag(false);
        sqlBlockLocal.set(bTMSqlBoolean);
    }

    public static final void jdbcConnectionMethodEnd(Object object, String string, String string2, String string3, boolean bl, int n) {
        try {
            if (bl) {
                RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
                if (n == 191) {
                    MethodEventProcessor.eventEnded(requestIdentifier, true, BTMUtils.getTimeStamp());
                } else {
                    RootTracer.updateDBDetails(object);
                    MethodEventProcessor.eventEnded(requestIdentifier, false, BTMUtils.getTimeStamp());
                }
                RootTracer.setSQLThreadLocal();
            }
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer][jdbcConnectionMethodEnd] - {} ", throwable);
        }
    }

    private static void updateDBDetails(Object object) {
        if (object == null) {
            return;
        }
        sqlBlockLocal.set(null);
        try {
            Method method = object.getClass().getMethod("getMetaData", new Class[0]);
            method.setAccessible(true);
            Object object2 = method.invoke(object, TraceUtils.ARGS);
            if (object2 != null) {
                Hashtable<String, String> hashtable;
                Method method2 = object2.getClass().getMethod("getURL", new Class[0]);
                method2.setAccessible(true);
                Object object3 = method2.invoke(object2, TraceUtils.ARGS);
                String string = object3.toString();
                Object v = BTMDiscovery.getDataBaseHT().get(string);
                if (v == null && (hashtable = DataBaseUtils.getDBInfo(object)) != null && hashtable.size() > 0) {
                    BTMDiscovery.getDataBaseHT().put(string, hashtable);
                }
            }
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("Could not find DB information due to the following error {} ", throwable);
        }
        RootTracer.setSQLThreadLocal();
    }

    private static final boolean ldapEventStarted(RequestIdentifier requestIdentifier, String string, String string2, String string3, String string4) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("method", string2 + "[*#*]" + string3);
        hashMap.put("endPoint", string);
        return MethodEventProcessor.eventStarted(requestIdentifier, hashMap, "LDAP", string2, string3, string4, BTMUtils.getTimeStamp(), null);
    }

    public static final boolean ldapPointCutType1MethodBegin(Object object, String string, String string2, String string3) {
        try {
            RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
            if (requestIdentifier == null || requestIdentifier.isPointcutLimitReached()) {
                return false;
            }
            String string4 = TraceUtils.ldapClientURL(object);
            return RootTracer.ldapEventStarted(requestIdentifier, string4, string, string2, string3);
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer][ldapPointCutType1MethodBegin] - {} ", throwable);
            return false;
        }
    }

    public static final boolean ldapPointCutType2MethodBegin(Object object, String string, String string2, String string3) {
        try {
            RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
            if (requestIdentifier == null || requestIdentifier.isPointcutLimitReached()) {
                return false;
            }
            String string4 = object.toString();
            if (string4 == null) {
                string4 = "-";
            }
            return RootTracer.ldapEventStarted(requestIdentifier, string4, string, string2, string3);
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer][ldapPointCutType2MethodBegin] - {} ", throwable);
            return false;
        }
    }

    public static final long ehCachePointCutMethodBegin(String string, String string2, String string3) {
        long l = -1L;
        try {
            RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
            if (requestIdentifier == null || requestIdentifier.isPointcutLimitReached()) {
                return l;
            }
            l = BTMUtils.getTimeStamp();
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer][ehCachePointCutMethodBegin] - {} ", throwable);
        }
        return l;
    }

    public static final void ehCachePointCutMethodEnd(String string, String string2, String string3, long l, int n) {
        if (l > 0L) {
            try {
                RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
                if (requestIdentifier != null) {
                    long l2 = BTMUtils.getTimeStamp() - l;
                    BTMLog.logger.info(" className : {} methodName : {} methodExeTime : {} code : {} ", string, string2, l2, n);
                    requestIdentifier.updateEhCacheDetails(string2, l2);
                }
            }
            catch (Throwable throwable) {
                BTMLog.logger.warn("[RootTracer][ehCachePointCutMethodEnd] - {} ", throwable);
            }
        }
    }

    public static final boolean ldapPointCutType3MethodBegin(Object object, String string, String string2, String string3) {
        try {
            RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
            if (requestIdentifier == null || requestIdentifier.isPointcutLimitReached()) {
                return false;
            }
            String string4 = TraceUtils.ldapNamingEnumerationURL(object);
            return RootTracer.ldapEventStarted(requestIdentifier, string4, string, string2, string3);
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer][ldapPointCutType3MethodBegin] - {} ", throwable);
            return false;
        }
    }

    public static final boolean ldapPointCutType4MethodBegin(Object object, String string, String string2, String string3) {
        try {
            RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
            if (requestIdentifier == null || requestIdentifier.isPointcutLimitReached()) {
                return false;
            }
            String string4 = TraceUtils.initialLdapContextURL(object, requestIdentifier);
            return RootTracer.ldapEventStarted(requestIdentifier, string4, string, string2, string3);
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer][ldapPointCutType4MethodBegin] - {} ", throwable);
            return false;
        }
    }

    public static final boolean customPointCutMethodBegin(String string, String string2, String string3, String string4) {
        try {
            RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
            if (requestIdentifier == null || requestIdentifier.isPointcutLimitReached()) {
                return false;
            }
            return MethodEventProcessor.eventStarted(requestIdentifier, null, string4, string, string2, string3, BTMUtils.getTimeStamp(), null);
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer][customPointCutMethodBegin] - {} ", throwable);
            return false;
        }
    }

    public static final boolean waitForPointCutMethodBegin(String string, String string2, String string3) {
        try {
            RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
            if (requestIdentifier == null || requestIdentifier.isPointcutLimitReached()) {
                return false;
            }
            return MethodEventProcessor.eventStarted(requestIdentifier, null, "WAITFOR", string, string2, string3, BTMUtils.getTimeStamp(), null);
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer][waitForPointCutMethodBegin] - {} ", throwable);
            return false;
        }
    }

    public static final boolean processBuilderPointCutMethodBegin(ProcessBuilder processBuilder, String string, String string2, String string3) {
        try {
            RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
            if (requestIdentifier == null || requestIdentifier.isPointcutLimitReached()) {
                return false;
            }
            boolean bl = requestIdentifier.getCurrentMinfo().getClassName().equals("java/lang/Runtime");
            if (bl) {
                return false;
            }
            StringBuffer stringBuffer = new StringBuffer();
            List<String> list = processBuilder.command();
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    String string4 = list.get(i);
                    stringBuffer.append(string4).append("  ");
                }
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("COMMAND", stringBuffer.toString());
            return MethodEventProcessor.eventStarted(requestIdentifier, hashMap, "RUNTIME", string, string2, string3, BTMUtils.getTimeStamp(), null);
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer][processBuilderPointCutMethodBegin] - {} ", throwable);
            return false;
        }
    }

    public static final boolean runtimePointCutMethodBegin(String[] stringArray, String string, String string2, String string3) {
        try {
            RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
            if (requestIdentifier == null || requestIdentifier.isPointcutLimitReached()) {
                return false;
            }
            StringBuffer stringBuffer = new StringBuffer();
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    stringBuffer.append(stringArray[i]);
                    stringBuffer.append(" ");
                }
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("COMMAND", stringBuffer.toString());
            return MethodEventProcessor.eventStarted(requestIdentifier, hashMap, "RUNTIME", string, string2, string3, BTMUtils.getTimeStamp(), null);
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer][runtimePointCutMethodBegin] - {} ", throwable);
            return false;
        }
    }

    public static final boolean mulePointCutMethodBegin(Object object, Object object2, String string, String string2, String string3) {
        try {
            if (!PropsManager.isTalkingToAgent()) {
                return false;
            }
            RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
            HashMap hashMap = TraceUtils.getMuleRequestDetails(object2);
            if (hashMap == null) {
                return false;
            }
            String string4 = null;
            if (hashMap.containsKey("MATCH")) {
                string4 = (String)hashMap.remove("MATCH");
            }
            return MethodEventProcessor.eventStarted(requestIdentifier, hashMap, "MULE", string, string2, string3, BTMUtils.getTimeStamp(), string4, null, null, null);
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer][mulePointCutMethodBegin] - {} ", throwable);
            return false;
        }
    }

    public static final void mulePointCutMethodEnd(String string, String string2, String string3, boolean bl, int n) {
        try {
            if (bl) {
                RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
                MethodEventProcessor.rootEventEnded(requestIdentifier, n == 191, BTMUtils.getTimeStamp(), null, null, null);
            }
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer][mulePointCutMethodEnd] - {} ", throwable);
        }
    }

    public static final boolean rmiPointCutMethodBegin(Object object, String string, String string2, String string3) {
        try {
            Channel channel;
            TCPEndpoint tCPEndpoint;
            RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
            if (requestIdentifier == null || requestIdentifier.isPointcutLimitReached()) {
                return false;
            }
            boolean bl = object instanceof StreamRemoteCall;
            HashMap<String, String> hashMap = new HashMap<String, String>();
            if (bl && (tCPEndpoint = (TCPEndpoint)(channel = ((StreamRemoteCall)object).getConnection().getChannel()).getEndpoint()) != null) {
                hashMap = new HashMap();
                hashMap.put("host", tCPEndpoint.toString());
                hashMap.put("protocol", "jrmp://");
            }
            return MethodEventProcessor.eventStarted(requestIdentifier, hashMap, "RMI", string, string2, string3, BTMUtils.getTimeStamp(), null);
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer][rmiPointCutMethodBegin] - {} ", throwable);
            return false;
        }
    }

    public static final boolean ejbExitCommonPointCutBegin(String string, String string2, String string3) {
        try {
            RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
            if (requestIdentifier == null || requestIdentifier.isPointcutLimitReached()) {
                return false;
            }
            return MethodEventProcessor.eventStarted(requestIdentifier, null, "EJB", string, string2, string3, BTMUtils.getTimeStamp(), null);
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer][ejbExitCommonPointCutBegin] - {} ", throwable);
            return false;
        }
    }

    public static final boolean ejbExitWebspherePointCutBegin(Object object, Object object2, String string, String string2, String string3) {
        try {
            RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
            if (requestIdentifier == null || requestIdentifier.isPointcutLimitReached()) {
                return false;
            }
            HashMap hashMap = TraceUtils.websphereEjbExitDetails(object, object2, requestIdentifier);
            return MethodEventProcessor.eventStarted(requestIdentifier, hashMap, "EJB_HIDE", string, string2, string3, BTMUtils.getTimeStamp(), null);
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer][ejbExitWebspherePointCutBegin] - {} ", throwable);
            return false;
        }
    }

    public static final boolean ejbExitWeblogicPointCutBegin(Object object, Object object2, String string, String string2, String string3) {
        try {
            RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
            if (requestIdentifier == null || requestIdentifier.isPointcutLimitReached()) {
                return false;
            }
            HashMap hashMap = TraceUtils.weblogicEjbExitDetails(object, object2, requestIdentifier);
            if (hashMap == null || hashMap.size() == 0) {
                return false;
            }
            return MethodEventProcessor.eventStarted(requestIdentifier, hashMap, "EJB_HIDE", string, string2, string3, BTMUtils.getTimeStamp(), null);
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer][ejbExitWeblogicPointCutBegin] - {} ", throwable);
            return false;
        }
    }

    public static final boolean ejbExitJbossPointCutBegin(Object object, Object object2, Object object3, String string, String string2, String string3) {
        try {
            RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
            if (requestIdentifier == null || requestIdentifier.isPointcutLimitReached()) {
                return false;
            }
            HashMap hashMap = TraceUtils.jbossEjbExitDetails(object, object2, object3, requestIdentifier);
            return MethodEventProcessor.eventStarted(requestIdentifier, hashMap, "EJB_HIDE", string, string2, string3, BTMUtils.getTimeStamp(), null);
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer][ejbExitJbossPointCutBegin] - {} ", throwable);
            return false;
        }
    }

    public static final boolean jdbcPrepareCallPreparedStatmentMethodBegin(Object object, String string, String string2, String string3) {
        try {
            RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
            if (requestIdentifier == null || requestIdentifier.isPointcutLimitReached()) {
                return false;
            }
            RootTracer.updateDBDetails(object);
            return MethodEventProcessor.eventStarted(requestIdentifier, null, "JDBC", string, string2, string3, BTMUtils.getTimeStamp(), null);
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer][jdbcPrepareCallPreparedStatmentMethodBegin] - {} ", throwable);
            return false;
        }
    }

    public static final void jdbcPrepareCallPreparedStatmentMethodEnd(Object object, String string, String string2, String string3, String string4, boolean bl, int n) {
        try {
            if (bl) {
                RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
                if (n == 191) {
                    MethodEventProcessor.eventEnded(requestIdentifier, true, BTMUtils.getTimeStamp(), object, string);
                } else {
                    MethodEventProcessor.eventEnded(requestIdentifier, false, BTMUtils.getTimeStamp(), object, string);
                }
            }
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer][jdbcPrepareCallPreparedStatmentMethodEnd] - {} ", throwable);
        }
    }

    public static final boolean jdbcCommitCloseRollbackMethodBegin(Object object, String string, String string2, String string3) {
        try {
            RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
            if (requestIdentifier == null || requestIdentifier.isPointcutLimitReached()) {
                return false;
            }
            if (string2 != null && !string2.equals("close")) {
                RootTracer.updateDBDetails(object);
            }
            return MethodEventProcessor.eventStarted(requestIdentifier, null, "JDBC", string, string2, string3, BTMUtils.getTimeStamp(), null);
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer][jdbcCommitCloseRollbackMethodBegin] - {} ", throwable);
            return false;
        }
    }

    public static final boolean jdbcCloseMethodBegin(Object object, String string, String string2, String string3) {
        try {
            RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
            if (requestIdentifier == null) {
                return false;
            }
            requestIdentifier.removePrepareOrCallableStmtQuery(object);
            if (requestIdentifier.isPointcutLimitReached()) {
                return false;
            }
            return MethodEventProcessor.eventStarted(requestIdentifier, null, "JDBC", string, string2, string3, BTMUtils.getTimeStamp(), null);
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer][jdbcCloseMethodBegin] - {} ", throwable);
            return false;
        }
    }

    public static final boolean jdbcExecuteBatchMethodBegin(Object object, String string, String string2, String string3) {
        try {
            RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
            if (requestIdentifier == null || requestIdentifier.isPointcutLimitReached()) {
                return false;
            }
            sqlBlockLocal.set(null);
            return MethodEventProcessor.eventStarted(requestIdentifier, null, "JDBC", string, string2, string3, BTMUtils.getTimeStamp(), null);
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer][jdbcExecuteBatchMethodBegin] - {} ", throwable);
            return false;
        }
    }

    public static final boolean jdbcStatmentMethodBegin(Object object, String string, String string2, String string3) {
        try {
            RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
            if (requestIdentifier == null || requestIdentifier.isPointcutLimitReached()) {
                return false;
            }
            return MethodEventProcessor.eventStarted(requestIdentifier, null, "JDBC", string, string2, string3, BTMUtils.getTimeStamp(), null);
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer][jdbcStatmentMethodBegin] - {} ", throwable);
            return false;
        }
    }

    public static final boolean jtdsStatmentMethodBegin(Object object, String string, String string2, String string3, String string4) {
        BTMSqlBoolean bTMSqlBoolean = sqlBlockLocal.get();
        if (bTMSqlBoolean == null || bTMSqlBoolean.isSqlFlag()) {
            return false;
        }
        try {
            RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
            if (requestIdentifier != null) {
                String string5 = RootTracer.getJdbcUrl(object);
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("sqlStmt", string);
                hashMap.put("jdbcUrl", string5);
                hashMap.put("sqlError", "-");
                return MethodEventProcessor.eventStarted(requestIdentifier, hashMap, "SQL", string2, string3, string4, BTMUtils.getTimeStamp(), null);
            }
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer][jtdsStatmentMethodBegin] - {} ", throwable);
        }
        sqlBlockLocal.set(null);
        return false;
    }

    private static final String getJdbcUrl(Object object) {
        String string = "-";
        try {
            Method method = object.getClass().getMethod("getConnection", new Class[0]);
            method.setAccessible(true);
            Object object2 = method.invoke(object, TraceUtils.ARGS);
            Method method2 = object2.getClass().getMethod("getMetaData", new Class[0]);
            method2.setAccessible(true);
            Object object3 = method2.invoke(object2, TraceUtils.ARGS);
            if (object3 != null) {
                Method method3 = object3.getClass().getMethod("getURL", new Class[0]);
                method3.setAccessible(true);
                Object object4 = method3.invoke(object3, TraceUtils.ARGS);
                string = object4.toString();
                if (!BTMDiscovery.getDataBaseHT().containsKey(string)) {
                    RootTracer.updateDBDetails(object2);
                }
            }
        }
        catch (Exception exception) {
            BTMLog.logger.warn("Exception occured while getting JDBC URL from statment Object {}", (Object)exception.getMessage());
            BTMLog.logger.error("{}", exception);
        }
        return string;
    }

    public static final void jtdsStatmentMethodEnd(String string, String string2, String string3, boolean bl, int n) {
        try {
            if (bl) {
                RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
                MethodEventProcessor.eventEnded(requestIdentifier, false, BTMUtils.getTimeStamp());
            }
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer][jtdsStatmentMethodEnd] - {} ", throwable);
        }
    }

    public static final void jdbcExecuteBatchMethodEnd(String string, String string2, String string3, boolean bl, int n) {
        try {
            if (bl) {
                RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
                MethodEventProcessor.eventEnded(requestIdentifier, false, BTMUtils.getTimeStamp());
                RootTracer.setSQLThreadLocal();
            }
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer][jdbcExecuteBatchMethodEnd] - {} ", throwable);
        }
    }

    public static final void jtdsStatmentMethodEnd(Object object, String string, String string2, String string3, boolean bl, int n) {
        try {
            if (bl) {
                RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
                MethodEventProcessor.sqlEventEnded(requestIdentifier, true, BTMUtils.getTimeStamp(), object);
            }
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer][jtdsStatmentMethodEnd] - {} ", throwable);
        }
    }

    public static final boolean jtdsCallableOrPreparedStatmentMethodBegin(Object object, String string, String string2, String string3) {
        BTMSqlBoolean bTMSqlBoolean = sqlBlockLocal.get();
        if (bTMSqlBoolean == null || bTMSqlBoolean.isSqlFlag()) {
            return false;
        }
        try {
            RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
            if (requestIdentifier != null) {
                String string4 = requestIdentifier.getPrepareOrCallableStmtQuery(object);
                if (string4.equals("-")) {
                    return false;
                }
                String string5 = RootTracer.getJdbcUrl(object);
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("sqlStmt", string4);
                hashMap.put("jdbcUrl", string5);
                hashMap.put("sqlError", "-");
                return MethodEventProcessor.eventStarted(requestIdentifier, hashMap, "SQL", string, string2, string3, BTMUtils.getTimeStamp(), null);
            }
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer][jtdsCallableOrPreparedStatmentMethodBegin] - {} ", throwable);
        }
        sqlBlockLocal.set(null);
        return false;
    }

    public static final void jtdsCallableOrPreparedStatmentMethodEnd(String string, String string2, String string3, boolean bl, int n) {
        try {
            if (bl) {
                RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
                MethodEventProcessor.eventEnded(requestIdentifier, false, BTMUtils.getTimeStamp());
            }
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer][jtdsCallableOrPreparedStatmentMethodEnd] - {} ", throwable);
        }
    }

    public static final void jtdsCallableOrPreparedStatmentMethodEnd(Object object, String string, String string2, String string3, boolean bl, int n) {
        try {
            if (bl) {
                RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
                MethodEventProcessor.sqlEventEnded(requestIdentifier, true, BTMUtils.getTimeStamp(), object);
            }
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer][jtdsCallableOrPreparedStatmentMethodEnd] - {} ", throwable);
        }
    }

    public static final boolean mongoDBPointCutMethodBegin(Object object, Object object2, String string, String string2, String string3) {
        try {
            Map map;
            RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
            if (requestIdentifier == null || requestIdentifier.isPointcutLimitReached()) {
                return false;
            }
            String[] stringArray = requestIdentifier.getNoSQLConnectionDetails(object);
            if (stringArray == null) {
                stringArray = TraceUtils.getMongoHostPortDetails(object, requestIdentifier);
            }
            if (stringArray != null && (map = TraceUtils.getMongoDBDetails(object, object2, stringArray, string2)) != null) {
                return MethodEventProcessor.eventStarted(requestIdentifier, map, "MONGODB", string, string2, string3, BTMUtils.getTimeStamp(), null);
            }
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer][mongoDBPointCutMethodBegin] - {} ", throwable);
        }
        return false;
    }

    public static final boolean mongoDBPointCutDropMethodBegin(Object object, String string, String string2, String string3) {
        try {
            return RootTracer.mongoDBPointCutMethodBegin(object, null, string, string2, string3);
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer][mongoDBPointCutDropMethodBegin] - {} ", throwable);
            return false;
        }
    }

    public static final boolean redisSendCommandMethodBegin() {
        RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
        return requestIdentifier != null;
    }

    public static final void redisSendCommandMethodEnd(Object object, Object object2, boolean bl) {
        try {
            RequestIdentifier requestIdentifier;
            if (bl && (requestIdentifier = MethodEventProcessor.getRequestIdentifier()) != null) {
                String[] stringArray = requestIdentifier.getNoSQLConnectionDetails(object);
                if (stringArray == null) {
                    stringArray = TraceUtils.getRedisHostPortDetails(object, requestIdentifier);
                }
                if (stringArray != null) {
                    TraceUtils.updateRedisDetails(object, stringArray, object2.toString(), requestIdentifier);
                }
            }
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer][redisSendCommandMethodEnd] - {} ", throwable);
        }
    }

    public static final boolean redisReadCommandMethodBegin(Object object, String string, String string2, String string3) {
        try {
            RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
            if (requestIdentifier == null) {
                return false;
            }
            Map map = null;
            map = string2.equals("getAll") ? requestIdentifier.getRedisCommandDetails(true) : requestIdentifier.getRedisCommandDetails();
            if (map != null) {
                return MethodEventProcessor.eventStarted(requestIdentifier, map, "REDIS", string, string2, string3, BTMUtils.getTimeStamp(), null);
            }
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer][redisReadCommandMethodBegin] - {} ", throwable);
        }
        return false;
    }

    public static final boolean soapWebServiceMethodBegin(Object object, Object object2, String string, String string2, String string3) {
        try {
            RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
            if (requestIdentifier == null || requestIdentifier.isPointcutLimitReached()) {
                return false;
            }
            HashMap hashMap = TraceUtils.getSOAPCallInfo(object, object2);
            return MethodEventProcessor.eventStarted(requestIdentifier, hashMap, "WEBSERVICE", string, string2, string3, BTMUtils.getTimeStamp(), null);
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer][soapWebServiceMethodBegin] - {} ", throwable);
            return false;
        }
    }

    public static final boolean apacheCxfExitWebServiceMethodBegin(Object object, Object object2, String string, String string2, String string3) {
        try {
            RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
            if (requestIdentifier == null || requestIdentifier.isPointcutLimitReached()) {
                return false;
            }
            Map map = TraceUtils.getApacheCxfCallInfo(object, object2);
            return MethodEventProcessor.eventStarted(requestIdentifier, map, "WEBSERVICE", string, string2, string3, BTMUtils.getTimeStamp(), null);
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer][apacheCxfExitWebServiceMethodBegin] - {} ", throwable);
            return false;
        }
    }

    public static final boolean apacheCxfEntryWebServiceMethodBegin(String string, String string2, String string3) {
        try {
            RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
            if (requestIdentifier == null || requestIdentifier.isPointcutLimitReached()) {
                return false;
            }
            return MethodEventProcessor.eventStarted(requestIdentifier, null, "WEBSERVICE_ENTRY", string, string2, string3, BTMUtils.getTimeStamp(), null);
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer][apacheCxfEntryWebServiceMethodBegin] - {} ", throwable);
            return false;
        }
    }

    public static final boolean axisWebServiceMethodBegin(Object object, String string, String string2, String string3) {
        try {
            RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
            if (requestIdentifier == null || requestIdentifier.isPointcutLimitReached()) {
                return false;
            }
            HashMap hashMap = TraceUtils.getAxisCallInfo(object);
            return MethodEventProcessor.eventStarted(requestIdentifier, hashMap, "WEBSERVICE", string, string2, string3, BTMUtils.getTimeStamp(), null);
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer][axisWebServiceMethodBegin] - {} ", throwable);
            return false;
        }
    }

    public static final boolean httpOtherMethodBegin(Object object, String string, String string2, String string3) {
        try {
            RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
            if (requestIdentifier == null || requestIdentifier.isPointcutLimitReached()) {
                return false;
            }
            String string4 = "HTTPErrorStream";
            return MethodEventProcessor.eventStarted(requestIdentifier, null, string4, string, string2, string3, BTMUtils.getTimeStamp(), null);
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer][httpOtherMethodBegin] - {} ", throwable);
            return false;
        }
    }

    public static final boolean httpUrlConnMethodBegin(Object object, String string, String string2, String string3) {
        try {
            RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
            if (requestIdentifier == null || requestIdentifier.isPointcutLimitReached()) {
                return false;
            }
            HashMap<String, String> hashMap = TraceUtils.getHttpCallInfo(object, requestIdentifier);
            if (hashMap == null) {
                return false;
            }
            String string4 = "HttpConn";
            if (hashMap.containsKey("HTTP")) {
                string4 = "HTTP";
            }
            return MethodEventProcessor.eventStarted(requestIdentifier, hashMap, string4, string, string2, string3, BTMUtils.getTimeStamp(), null);
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer] [httpUrlConnMethodBegin] - {} ", throwable);
            return false;
        }
    }

    public static final void httpUrlConnMethodEnd(Object object, String string, String string2, String string3, boolean bl, int n) {
        try {
            if (bl) {
                RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
                requestIdentifier.updateHTTPConnectionID();
                if (n == 191) {
                    MethodEventProcessor.eventEnded(requestIdentifier, true, BTMUtils.getTimeStamp());
                } else {
                    MethodEventProcessor.eventEnded(requestIdentifier, false, BTMUtils.getTimeStamp());
                }
            }
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer] [httpUrlConnMethodEnd] - {} ", throwable);
        }
    }

    public static final void inputStreamEnd(Object object, String string, String string2, String string3, boolean bl, int n) {
        try {
            if (bl) {
                RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
                TraceUtils.updateHTTPStatusCodeFromStreamEnd(object, requestIdentifier);
                if (n == 191) {
                    MethodEventProcessor.eventEnded(requestIdentifier, true, BTMUtils.getTimeStamp());
                } else {
                    MethodEventProcessor.eventEnded(requestIdentifier, false, BTMUtils.getTimeStamp());
                }
            }
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer] [inputStreamEnd] - {} ", throwable);
        }
    }

    public static final boolean httpStreamMethodBegin(Object object, String string, String string2, String string3) {
        try {
            String string4;
            RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
            if (requestIdentifier == null || requestIdentifier.isPointcutLimitReached()) {
                return false;
            }
            if (!TraceUtils.isValidHttpObject(object)) {
                return false;
            }
            String string5 = "HTTPStream";
            String string6 = requestIdentifier.getHttpCallCounter();
            HashMap<String, String> hashMap = null;
            if (string6 != null && (string4 = requestIdentifier.getExternalURL(string6)) != null) {
                hashMap = new HashMap<String, String>();
                hashMap.put("NODE_ORDER", string6);
                hashMap.put("EXTURL", string4);
            }
            return MethodEventProcessor.eventStarted(requestIdentifier, hashMap, string5, string, string2, string3, BTMUtils.getTimeStamp(), null);
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer] [httpStreamMethodBegin] - {} ", throwable);
            return false;
        }
    }

    public static final boolean apacheHttpRequestMethodBegin(Object object, Object object2, String string, String string2, String string3) {
        try {
            RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
            if (requestIdentifier == null || requestIdentifier.isPointcutLimitReached()) {
                return false;
            }
            Map map = TraceUtils.getApacheHttpCallInfo(object, object2, requestIdentifier);
            if (map == null) {
                return false;
            }
            return MethodEventProcessor.eventStarted(requestIdentifier, map, "HTTP", string, string2, string3, BTMUtils.getTimeStamp(), null);
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer] [apacheHttpRequestMethodBegin] - {} ", throwable);
            return false;
        }
    }

    public static final boolean apacheHttpUriMethodBegin(Object object, String string, String string2, String string3) {
        try {
            RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
            if (requestIdentifier == null || requestIdentifier.isPointcutLimitReached()) {
                return false;
            }
            Map map = TraceUtils.getApacheHttpCallInfo(null, object, requestIdentifier);
            if (map == null) {
                return false;
            }
            return MethodEventProcessor.eventStarted(requestIdentifier, map, "HTTP", string, string2, string3, BTMUtils.getTimeStamp(), null);
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer] [apacheHttpUriMethodBegin] - {} ", throwable);
            return false;
        }
    }

    public static final boolean apacheCommonHttpMethodBegin(Object object, String string, String string2, String string3) {
        try {
            RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
            if (requestIdentifier == null || requestIdentifier.isPointcutLimitReached()) {
                return false;
            }
            Map map = TraceUtils.getApacheHttpCommonCallInfo(object, requestIdentifier);
            if (map == null) {
                return false;
            }
            return MethodEventProcessor.eventStarted(requestIdentifier, map, "HTTP", string, string2, string3, BTMUtils.getTimeStamp(), null);
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer] [apacheCommonHttpMethodBegin] - {} ", throwable);
            return false;
        }
    }

    public static final void apacheCommonHttpMethodEnd(Object object, String string, String string2, String string3, boolean bl, int n) {
        try {
            if (bl) {
                RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
                if (n == 191) {
                    MethodEventProcessor.eventEnded(requestIdentifier, true, BTMUtils.getTimeStamp());
                } else {
                    TraceUtils.updateHTTPStatusCode(object, requestIdentifier, false);
                    MethodEventProcessor.eventEnded(requestIdentifier, false, BTMUtils.getTimeStamp());
                }
            }
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer] [apacheCommonHttpMethodEnd] - {} ", throwable);
        }
    }

    public static final void apacheHttpMethodEnd(Object object, String string, String string2, String string3, boolean bl, int n) {
        try {
            if (bl) {
                RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
                if (n == 191) {
                    MethodEventProcessor.eventEnded(requestIdentifier, true, BTMUtils.getTimeStamp());
                } else {
                    TraceUtils.updateHTTPStatusCode(object, requestIdentifier, true);
                    MethodEventProcessor.eventEnded(requestIdentifier, false, BTMUtils.getTimeStamp());
                }
            }
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer] [apacheHttpMethodEnd] - {} ", throwable);
        }
    }

    public static final boolean threadRunMethodBegin(Object object, String string, String string2, String string3) {
        try {
            if (!PropsManager.isTalkingToAgent()) {
                return false;
            }
            boolean bl = object instanceof Thread;
            if (bl) {
                RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
                return MethodEventProcessor.eventStarted(requestIdentifier, null, "THREAD", string, string2, string3, BTMUtils.getTimeStamp(), null);
            }
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer] [threadRunMethodBegin] - {} ", throwable);
        }
        return false;
    }

    public static final void threadRunMethodEnd(Object object, String string, String string2, String string3, boolean bl, int n) {
        try {
            if (bl) {
                RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
                MethodEventProcessor.rootEventEnded(requestIdentifier, n == 191, BTMUtils.getTimeStamp(), null, null, null);
            }
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer] [threadRunMethodEnd] - {} ", throwable);
        }
    }

    public static final boolean threadStartMethodBegin(Object object, String string, String string2, String string3) {
        block17: {
            try {
                RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
                if (requestIdentifier == null || requestIdentifier.isPointcutLimitReached()) {
                    return false;
                }
                boolean bl = object instanceof Thread;
                if (!bl) break block17;
                try {
                    String string4;
                    String string5;
                    Object object2;
                    Object object3;
                    Thread thread = (Thread)object;
                    String string6 = thread.getClass().getName();
                    String string7 = thread.getName();
                    long l = thread.getId();
                    if (string6.startsWith("com.eg.jtm") || thread.getContextClassLoader() == null) {
                        BTMLog.logger.debug("Skipping the thread " + string7 + " id :" + l);
                        return false;
                    }
                    if (Utilities.isThreadClassExcluded(string6)) {
                        BTMLog.logger.debug("Skipping the thread " + string7 + " id :" + l);
                        return false;
                    }
                    try {
                        object3 = Thread.currentThread().getStackTrace();
                        if (object3 != null) {
                            for (int i = 4; i < 10; ++i) {
                                object2 = object3[i];
                                string5 = ((StackTraceElement)object2).getClassName();
                                if (!string5.startsWith("sun.") && !string5.startsWith("com.sun.jndi.ldap.") && !string5.startsWith("java.") || string5.equals("java.lang.Thread")) continue;
                                BTMLog.logger.info("Skipping the thread : {}  id : {} ThreadGrandParent Class Name : {} ", string7, l, string5);
                                return false;
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    object3 = UUID.randomUUID().toString();
                    String string8 = requestIdentifier.getReqGUID();
                    if (string8.lastIndexOf("#~#") < 0) {
                        return false;
                    }
                    object2 = string8.substring(0, string8.lastIndexOf("#~#"));
                    string5 = string8.substring(string8.lastIndexOf("#~#") + 3);
                    String string9 = requestIdentifier.getThreadCallCounter();
                    if (string9 != null && string9.length() > 0) {
                        string4 = string9.substring(string9.lastIndexOf(".") + 1);
                        try {
                            int n = Integer.parseInt(string4);
                            string9 = string5 + ".A." + ++n;
                            requestIdentifier.setThreadCallCounter(string9, l, (String)object3, (String)object2);
                        }
                        catch (Exception exception) {
                            BTMLog.logger.error("[threadStartMethodBegin] Exception Occured {} ", exception);
                        }
                    } else {
                        if (string5 != null) {
                            string4 = string5 + ".A.1";
                            requestIdentifier.setThreadCallCounter(string4, l, (String)object3, (String)object2);
                        }
                        string9 = requestIdentifier.getThreadCallCounter();
                    }
                    long l2 = BTMUtils.getTimeStamp();
                    return MethodEventProcessor.eventStarted(requestIdentifier, null, "THREAD_INIT", string, string2, string3 + "[#" + string7 + "-" + l + "#] " + "[ASYNC]-" + (String)object3, l2, null);
                }
                catch (Exception exception) {
                    BTMLog.logger.error("Exception in threadStartMethodBegin {} ", exception);
                }
            }
            catch (Throwable throwable) {
                BTMLog.logger.warn("[RootTracer] [threadStartMethodBegin] - {} ", throwable);
            }
        }
        return false;
    }

    public static final boolean ibmMQMethodBegin(Object object, String string, String string2, String string3) {
        try {
            RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
            if (requestIdentifier == null || requestIdentifier.isPointcutLimitReached()) {
                return false;
            }
            String string4 = "IBM WebSphere MQ";
            String string5 = "-";
            String string6 = "-";
            HashMap<String, String> hashMap = new HashMap<String, String>();
            ClassLoader classLoader = object.getClass().getClassLoader();
            Object[] objectArray = new Object[]{};
            Class<?> clazz = null;
            try {
                clazz = classLoader.loadClass("com.ibm.mq.MQDestination");
                Method method = clazz.getMethod("getName", new Class[0]);
                method.setAccessible(true);
                Object object2 = method.invoke(object, objectArray);
                if (object2 != null) {
                    string6 = object2.toString().trim();
                }
                Method method2 = clazz.getMethod("getConnectionReference", new Class[0]);
                method2.setAccessible(true);
                Object object3 = method2.invoke(object, objectArray);
                Class<?> clazz2 = classLoader.loadClass("com.ibm.mq.MQQueueManager");
                Method method3 = clazz2.getMethod("getName", new Class[0]);
                method3.setAccessible(true);
                Object object4 = method3.invoke(object3, objectArray);
                Class<?> clazz3 = object.getClass();
                Class<?> clazz4 = classLoader.loadClass("com.ibm.mq.MQQueue");
                boolean bl = clazz3.isAssignableFrom(clazz4);
                Class<?> clazz5 = classLoader.loadClass("com.ibm.mq.MQTopic");
                boolean bl2 = clazz3.isAssignableFrom(clazz5);
                if (bl) {
                    string5 = object4 + "/" + string6;
                } else if (bl2) {
                    string5 = object4 + "/" + string6;
                }
                hashMap.put("JMS-QUEUE", string5);
                String string7 = "PRODUCER";
                if (string2.equals("get")) {
                    string7 = "CONSUMER";
                }
                hashMap.put("TYPE", string7);
                hashMap.put("JMS-PROVIDER", string4);
                String string8 = string4 + "::" + string5 + "::" + string7;
                hashMap.put("TFT_KEY", string8);
            }
            catch (Exception exception) {
                return false;
            }
            return MethodEventProcessor.eventStarted(requestIdentifier, hashMap, "JMS", string, string2, string3, BTMUtils.getTimeStamp(), null);
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer] [ibmMQMethodBegin] - {} ", throwable);
            return false;
        }
    }

    public static final boolean ibmMQDistributionMethodBegin(Object object, String string, String string2, String string3) {
        try {
            RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
            if (requestIdentifier == null || requestIdentifier.isPointcutLimitReached()) {
                return false;
            }
            String string4 = "IBM WebSphere MQ";
            String string5 = "-";
            HashMap<String, String> hashMap = new HashMap<String, String>();
            ClassLoader classLoader = object.getClass().getClassLoader();
            Object[] objectArray = new Object[]{};
            Class<?> clazz = null;
            try {
                String string6 = "*";
                clazz = classLoader.loadClass("com.ibm.mq.MQDestination");
                Method method = clazz.getMethod("getConnectionReference", new Class[0]);
                method.setAccessible(true);
                Object object2 = method.invoke(object, objectArray);
                Class<?> clazz2 = classLoader.loadClass("com.ibm.mq.MQQueueManager");
                Method method2 = clazz2.getMethod("getName", new Class[0]);
                method2.setAccessible(true);
                Object object3 = method2.invoke(object2, objectArray);
                string5 = object3 + "/" + string6;
                String string7 = "PRODUCER";
                hashMap.put("JMS-QUEUE", string5);
                hashMap.put("TYPE", string7);
                hashMap.put("JMS-PROVIDER", string4);
                String string8 = string4 + "::" + string5 + "::" + string7;
                hashMap.put("TFT_KEY", string8);
            }
            catch (Exception exception) {
                return false;
            }
            return MethodEventProcessor.eventStarted(requestIdentifier, hashMap, "JMS", string, string2, string3, BTMUtils.getTimeStamp(), null);
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer] [ibmMQDistributionMethodBegin] - {} ", throwable);
            return false;
        }
    }

    public static boolean jmsMethodBegin() {
        try {
            RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
            if (requestIdentifier != null) {
                return true;
            }
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer] [jmsMethodBegin] - {} ", throwable);
        }
        return false;
    }

    public static final void jmsConnectionMethodEnd(Object object, Object object2, String string, String string2, String string3, boolean bl, int n) {
        try {
            if (bl && n != 191 && object2 != null && object != null) {
                String string4 = TraceUtils.getJMSProvider(object2);
                RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
                requestIdentifier.addProviderName(object, string4);
            }
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer] [jmsConnectionMethodEnd] - {} ", throwable);
        }
    }

    public static final void jmsCreateProducerMethodEnd(Object object, Object object2, Object object3, String string, String string2, String string3, boolean bl, int n) {
        try {
            if (bl && n != 191 && object2 != null && object != null) {
                RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
                if (requestIdentifier != null && object3 != null) {
                    String string4 = requestIdentifier.getProviderName(object2);
                    String[] stringArray = TraceUtils.getJMSData(object, object3, string4, true);
                    requestIdentifier.addJMSDetails(object, stringArray);
                } else {
                    String string5 = requestIdentifier.getProviderName(object2);
                    String[] stringArray = new String[]{string5};
                    requestIdentifier.addJMSDetails(object, stringArray);
                }
            }
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer] [jmsCreateProducerMethodEnd] - {} ", throwable);
        }
    }

    public static final boolean jms2ProducerMethodBegin(Object object, Object object2, Object object3, String string, String string2, String string3) {
        try {
            Object object4;
            RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
            if (requestIdentifier == null || requestIdentifier.isPointcutLimitReached()) {
                return false;
            }
            boolean bl = requestIdentifier.getCurrentMinfo().getType().equals("JMS");
            if (bl) {
                return false;
            }
            boolean bl2 = false;
            String string4 = "-";
            String string5 = "-";
            String string6 = "-";
            try {
                object4 = requestIdentifier.getJMSDetails(object);
                if (object4 == null) {
                    object4 = TraceUtils.getMuleJMSDetails(object, object3, requestIdentifier);
                }
                if (object4 != null) {
                    if (((String[])object4).length == 1) {
                        object4 = TraceUtils.getJMSData(object, object2, object4[0], true);
                    }
                    string5 = object4[0];
                    string6 = object4[1];
                    string4 = object4[2];
                    bl2 = true;
                }
            }
            catch (Exception exception) {
                BTMLog.logger.error("EXCEPTION - [jms2ProducerMethodBegin] {} ", exception);
            }
            if (bl2) {
                object4 = TraceUtils.transmitGUIDandJMSDetails(object3, requestIdentifier, string4, string5, string6);
                if (object4 == null) {
                    return false;
                }
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("JMS-PROVIDER", string4);
                hashMap.put("JMS-QUEUE", string5);
                hashMap.put("TYPE", string6);
                String string7 = string4 + "::" + string5 + "::" + string6;
                hashMap.put("TFT_KEY", string7);
                hashMap.put("NODE_ORDER", object4);
                return MethodEventProcessor.eventStarted(requestIdentifier, hashMap, "JMS", string, string2, string3, BTMUtils.getTimeStamp(), null);
            }
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer] [jms2ProducerMethodBegin] - {} ", throwable);
        }
        return false;
    }

    public static final boolean jmsProducerMethodBegin(Object object, Object object2, String string, String string2, String string3) {
        try {
            Object object3;
            RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
            if (requestIdentifier == null || requestIdentifier.isPointcutLimitReached()) {
                return false;
            }
            boolean bl = requestIdentifier.getCurrentMinfo().getType().equals("JMS");
            if (bl) {
                return false;
            }
            boolean bl2 = false;
            String string4 = "-";
            String string5 = "-";
            String string6 = "-";
            try {
                object3 = requestIdentifier.getJMSDetails(object);
                if (object3 == null) {
                    object3 = TraceUtils.getMuleJMSDetails(object, object2, requestIdentifier);
                }
                if (object3 != null) {
                    string5 = object3[0];
                    string6 = object3[1];
                    string4 = object3[2];
                    bl2 = true;
                }
            }
            catch (Exception exception) {
                BTMLog.logger.error("EXCEPTION - [jmsProducerMethodBegin] {} ", exception);
            }
            if (bl2) {
                object3 = TraceUtils.transmitGUIDandJMSDetails(object2, requestIdentifier, string4, string5, string6);
                if (object3 == null) {
                    return false;
                }
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("JMS-PROVIDER", string4);
                hashMap.put("JMS-QUEUE", string5);
                hashMap.put("TYPE", string6);
                String string7 = string4 + "::" + string5 + "::" + string6;
                hashMap.put("TFT_KEY", string7);
                hashMap.put("NODE_ORDER", object3);
                return MethodEventProcessor.eventStarted(requestIdentifier, hashMap, "JMS", string, string2, string3, BTMUtils.getTimeStamp(), null);
            }
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer] [jmsProducerMethodBegin] - {} ", throwable);
        }
        return false;
    }

    public static final void jmsCreateSenderOrCreateReceiverMethodEnd(Object object, Object object2, Object object3, String string, String string2, String string3, boolean bl, int n) {
        try {
            if (bl && n != 191 && object2 != null && object3 != null && object != null) {
                String[] stringArray = null;
                RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
                if (requestIdentifier != null) {
                    String string4 = requestIdentifier.getProviderName(object2);
                    stringArray = string2.equals("createSender") ? TraceUtils.getJMSData(object, object3, string4, true) : TraceUtils.getJMSData(object, object3, string4, false);
                    requestIdentifier.addJMSDetails(object, stringArray);
                }
            }
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer] [jmsCreateSenderOrCreateReceiverMethodEnd] - {} ", throwable);
        }
    }

    public static final void jmsCreateSubscriberOrPublisherMethodEnd(Object object, Object object2, Object object3, String string, String string2, String string3, boolean bl, int n) {
        try {
            if (bl && n != 191 && object2 != null && object3 != null && object != null) {
                String[] stringArray = null;
                RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
                if (requestIdentifier != null) {
                    String string4 = requestIdentifier.getProviderName(object2);
                    stringArray = string2.equals("createPublisher") ? TraceUtils.getJMSData(object, object3, string4, true) : TraceUtils.getJMSData(object, object3, string4, false);
                    requestIdentifier.addJMSDetails(object, stringArray);
                }
            }
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer] [jmsCreateSubscriberOrPublisherMethodEnd] - {} ", throwable);
        }
    }

    public static final void jmsCreateConsumerMethodEnd(Object object, Object object2, Object object3, String string, String string2, String string3, boolean bl, int n) {
        try {
            RequestIdentifier requestIdentifier;
            if (bl && n != 191 && object2 != null && object != null && object3 != null && (requestIdentifier = MethodEventProcessor.getRequestIdentifier()) != null) {
                String string4 = requestIdentifier.getProviderName(object2);
                String[] stringArray = TraceUtils.getJMSData(object, object3, string4, false);
                requestIdentifier.addJMSDetails(object, stringArray);
            }
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer] [jmsCreateConsumerMethodEnd] - {} ", throwable);
        }
    }

    public static final boolean jmsOnMessageMethodBegin(Object object, Object object2, String string, String string2, String string3) {
        try {
            if (!PropsManager.isTalkingToAgent()) {
                return false;
            }
            RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
            HashMap hashMap = new HashMap();
            String string4 = null;
            String string5 = "JMS_ENTRY";
            if (requestIdentifier == null) {
                hashMap = TraceUtils.getJmsEntryRequestDetails(object, object2);
            } else {
                string5 = "JMS_LISTENER";
            }
            if (hashMap != null && hashMap.containsKey("MATCH")) {
                string4 = (String)hashMap.remove("MATCH");
            }
            return MethodEventProcessor.eventStarted(requestIdentifier, hashMap, string5, string, string2, string3, BTMUtils.getTimeStamp(), string4, null, null, null);
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer] [jmsOnMessageMethodBegin] - {} ", throwable);
            return false;
        }
    }

    public static final void jmsOnMessageMethodEnd(String string, String string2, String string3, boolean bl, int n) {
        try {
            if (bl) {
                RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
                MethodEventProcessor.rootEventEnded(requestIdentifier, n == 191, BTMUtils.getTimeStamp(), null, null, null);
            }
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer] [jmsOnMessageMethodEnd] - {} ", throwable);
        }
    }

    public static final boolean jmsConsumerMethodBegin(Object object, String string, String string2, String string3) {
        try {
            Object object2;
            RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
            if (requestIdentifier == null || requestIdentifier.isPointcutLimitReached()) {
                return false;
            }
            boolean bl = false;
            Object object3 = "-";
            String string4 = "-";
            String string5 = "-";
            try {
                object2 = requestIdentifier.getJMSDetails(object);
                if (object2 != null) {
                    string4 = object2[0];
                    string5 = object2[1];
                    object3 = object2[2];
                }
                bl = true;
            }
            catch (Exception exception) {
                BTMLog.logger.error("EXCEPTION - [jmsConsumerMethodBegin] {} ", exception);
            }
            if (bl) {
                object2 = new HashMap();
                ((HashMap)object2).put("JMS-PROVIDER", object3);
                ((HashMap)object2).put("JMS-QUEUE", string4);
                ((HashMap)object2).put("TYPE", string5);
                String string6 = (String)object3 + "::" + string4 + "::" + string5;
                ((HashMap)object2).put("TFT_KEY", string6);
                return MethodEventProcessor.eventStarted(requestIdentifier, (Map)object2, "JMS", string, string2, string3, BTMUtils.getTimeStamp(), null);
            }
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer] [jmsConsumerMethodBegin] - {} ", throwable);
        }
        return false;
    }

    public static final void jmsCloseMethod(Object object) {
        try {
            RequestIdentifier requestIdentifier;
            if (object != null && (requestIdentifier = MethodEventProcessor.getRequestIdentifier()) != null) {
                requestIdentifier.removeObjectFromTable(object);
            }
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer] [jmsCloseMethod] - {} ", throwable);
        }
    }

    public static final boolean iBatisMethodBegin(Object object, Object object2, String string, String string2, String string3) {
        BTMSqlBoolean bTMSqlBoolean = sqlBlockLocal.get();
        if (bTMSqlBoolean == null || bTMSqlBoolean.isSqlFlag()) {
            return false;
        }
        try {
            RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
            if (requestIdentifier != null) {
                String string4 = RootTracer.getJdbcUrl(object2);
                String string5 = TraceUtils.getSQL(object);
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("sqlStmt", string5);
                hashMap.put("jdbcUrl", string4);
                hashMap.put("sqlError", "-");
                String string6 = requestIdentifier.getReqGUID();
                BTMLog.logger.debug("iBatisMethodBegin  true BLOCK - GUID {} - HandlerObj {} - StmtObj- {},  URL :{} & QueryStrin {} ", string6, object, object2, string4, string5);
                return MethodEventProcessor.eventStarted(requestIdentifier, hashMap, "SQL", string, string2, string3, BTMUtils.getTimeStamp(), null);
            }
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer] [iBatisMethodBegin] - {} ", throwable);
        }
        sqlBlockLocal.set(null);
        return false;
    }

    public static final void iBatisMethodEnd(String string, String string2, String string3, boolean bl, int n) {
        try {
            if (bl) {
                RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
                if (n == 191) {
                    MethodEventProcessor.eventEnded(requestIdentifier, true, BTMUtils.getTimeStamp());
                } else {
                    MethodEventProcessor.eventEnded(requestIdentifier, false, BTMUtils.getTimeStamp());
                }
            }
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer] [iBatisMethodEnd] - {} ", throwable);
        }
    }

    public static final boolean sapConnectMethodBegin(Object object, String string, String string2, String string3, String string4) {
        try {
            RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
            if (requestIdentifier == null || requestIdentifier.isPointcutLimitReached()) {
                return false;
            }
            String string5 = "-";
            String string6 = "-";
            String string7 = "-";
            String string8 = "-";
            String string9 = "-";
            String string10 = "-";
            String string11 = "-";
            String string12 = "-";
            String string13 = "-";
            String string14 = "-";
            String string15 = "-";
            ClassLoader classLoader = object.getClass().getClassLoader();
            Object[] objectArray = new Object[]{};
            Class<?> clazz = null;
            HashMap<String, String> hashMap = new HashMap<String, String>();
            try {
                clazz = classLoader.loadClass("com.sap.mw.jco.JCO$Client");
                BTMLog.logger.info(" JCO Class loaded successfully : {} ", (Object)clazz);
                Method method = clazz.getMethod("getASHost", new Class[0]);
                method.setAccessible(true);
                Object object2 = method.invoke(object, objectArray);
                BTMLog.logger.debug(" [JCO] - jcoASHost {} ", object2);
                if (object2 != null) {
                    string5 = object2.toString();
                }
                Method method2 = clazz.getMethod("getClient", new Class[0]);
                method2.setAccessible(true);
                Object object3 = method2.invoke(object, objectArray);
                BTMLog.logger.debug(" [JCO] - jcoClient {} ", object3);
                if (object3 != null) {
                    string6 = object3.toString();
                }
                Method method3 = clazz.getMethod("getGWHost", new Class[0]);
                method3.setAccessible(true);
                Object object4 = method3.invoke(object, objectArray);
                BTMLog.logger.debug(" [JCO] - jcoGWHost {}", object4);
                if (object4 != null) {
                    string7 = object4.toString();
                }
                Method method4 = clazz.getMethod("getGWServ", new Class[0]);
                method4.setAccessible(true);
                Object object5 = method4.invoke(object, objectArray);
                BTMLog.logger.debug(" [JCO] - jcoGWServ {}", object5);
                if (object5 != null) {
                    string8 = object5.toString();
                }
                Method method5 = clazz.getMethod("getMSHost", new Class[0]);
                method5.setAccessible(true);
                Object object6 = method5.invoke(object, objectArray);
                BTMLog.logger.debug(" [JCO] - jcoMSHost {}", object6);
                if (object6 != null) {
                    string9 = object6.toString();
                }
                Method method6 = clazz.getMethod("getGroup", new Class[0]);
                method6.setAccessible(true);
                Object object7 = method6.invoke(object, objectArray);
                BTMLog.logger.debug(" [JCO] - jcoGroup {}", object7);
                if (object7 != null) {
                    string10 = object7.toString();
                }
                Method method7 = clazz.getMethod("getSystemID", new Class[0]);
                method7.setAccessible(true);
                Object object8 = method7.invoke(object, objectArray);
                BTMLog.logger.debug(" [JCO] - jcoSystemId {}", object8);
                if (object8 != null) {
                    string11 = object8.toString();
                }
                Method method8 = clazz.getMethod("getSystemNumber", new Class[0]);
                method8.setAccessible(true);
                Object object9 = method8.invoke(object, objectArray);
                BTMLog.logger.debug(" [JCO] - jcoSystemNumber {}", object9);
                if (object9 != null) {
                    string12 = object9.toString();
                }
                Method method9 = clazz.getMethod("getTPName", new Class[0]);
                method9.setAccessible(true);
                Object object10 = method9.invoke(object, objectArray);
                BTMLog.logger.debug(" [JCO] - jcoTPName {}", object10);
                if (object10 != null) {
                    string13 = object10.toString();
                }
                Method method10 = clazz.getMethod("getURL", new Class[0]);
                method10.setAccessible(true);
                Object object11 = method10.invoke(object, objectArray);
                BTMLog.logger.debug(" [JCO] - jcoURL {}", object11);
                if (object11 != null) {
                    string15 = object11.toString();
                }
                Method method11 = clazz.getMethod("getUser", new Class[0]);
                method11.setAccessible(true);
                Object object12 = method11.invoke(object, objectArray);
                BTMLog.logger.debug(" [JCO] - jcoUser {}", object12);
                if (object12 != null) {
                    string14 = object12.toString();
                }
            }
            catch (Throwable throwable) {
                BTMLog.logger.error("EXCEPTION - [sapConnectMethodBegin] {} ", throwable);
                return false;
            }
            if (string == null) {
                string = "-";
            }
            hashMap.put("ASHost", string5);
            hashMap.put("CLIENT", string6);
            hashMap.put("GWHost", string7);
            hashMap.put("GWServ", string8);
            hashMap.put("MSHost", string9);
            hashMap.put("Group", string10);
            hashMap.put("SystemID", string11);
            hashMap.put("SystemNo", string12);
            hashMap.put("TPName", string13);
            hashMap.put("User", string14);
            hashMap.put("URL", string15);
            hashMap.put("JCOFunction", string);
            return MethodEventProcessor.eventStarted(requestIdentifier, hashMap, "SAP JCO", string2, string3, string4, BTMUtils.getTimeStamp(), null);
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer] [sapConnectMethodBegin] - {} ", throwable);
            return false;
        }
    }

    public static final void recordPOJOException(Object object, String string, String string2, String string3, boolean bl) {
        try {
            if (!bl) {
                return;
            }
            RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
            if (requestIdentifier == null) {
                return;
            }
            boolean bl2 = object instanceof Throwable;
            if (bl2) {
                MethodInfo methodInfo;
                Throwable throwable = (Throwable)object;
                if (PropsManager.isExceptionMatchedIncludeExceptionList(object.getClass().getName())) {
                    RootTracer.recordSQLException(throwable, string, string2, string3, bl);
                    return;
                }
                if (RootTracer.isFirstPOJOThrown(throwable, requestIdentifier) && (methodInfo = requestIdentifier.getCurrentMinfo()) != null) {
                    RootTracer.registerPOJOException(throwable, methodInfo, requestIdentifier);
                }
            }
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer] [recordPOJOException] - {} ", throwable);
        }
    }

    public static final void recordPOJOException(Object object, String string, String string2, String string3, long l) {
        if (l > 0L) {
            RootTracer.recordPOJOException(object, string, string2, string3, true);
        }
    }

    public static final void recordEntryPointException(Object object, String string, String string2, String string3, boolean bl) {
        try {
            Throwable throwable;
            RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
            if (requestIdentifier == null) {
                return;
            }
            if (PropsManager.isExceptionMatchedIgnoreExceptionList(object.getClass().getName()) && !PropsManager.isExceptionMatchedIncludeExceptionList(object.getClass().getName())) {
                return;
            }
            MethodInfo methodInfo = requestIdentifier.getCurrentMinfo();
            if (!methodInfo.isStartComponent()) {
                RootTracer.recordPOJOException(object, string, string2, string3, bl);
                return;
            }
            boolean bl2 = object instanceof Throwable;
            if (bl2 && RootTracer.isFirstEntryAndSqlThrown(throwable = (Throwable)object, requestIdentifier)) {
                MethodInfo methodInfo2 = null;
                Throwable throwable2 = throwable.getCause();
                if (throwable2 == null) {
                    throwable2 = throwable;
                    ExceptionUtils.collectRootAndBottomCause(throwable, requestIdentifier);
                } else if (requestIdentifier.isReadCause()) {
                    ExceptionUtils.collectCauses(throwable, requestIdentifier);
                } else {
                    ExceptionUtils.collectRootAndBottomCause(throwable, requestIdentifier);
                }
                methodInfo2 = requestIdentifier.getObjectFromPOJOExceptionTracker(throwable2);
                if (methodInfo2 != null && methodInfo2.getType().equals("POJO")) {
                    HashMap hashMap = new HashMap();
                    boolean bl3 = RootTracer.doExceptionTrack(throwable, requestIdentifier, hashMap);
                    if (bl3) {
                        return;
                    }
                    methodInfo2.setType("EXCEPTION");
                    methodInfo2.setProperties(hashMap);
                    long l = methodInfo2.getExecutionTime();
                    requestIdentifier.getRootMinfo().setErrorURL(true);
                    if ((double)l <= UPDManager.getMethExecCutOff() && !methodInfo.equals(methodInfo2)) {
                        MethodInfo methodInfo3 = methodInfo2.getParent();
                        if (methodInfo3 != null && methodInfo.equals(methodInfo3)) {
                            long l2;
                            List<Long> list = methodInfo.getChildMinfos();
                            if (!list.contains(l2 = methodInfo2.getId())) {
                                methodInfo.addToChildInfo(requestIdentifier.getChildMap(), methodInfo2);
                            }
                        } else {
                            methodInfo2.clearAllChildInfos(requestIdentifier.getChildMap());
                            methodInfo2.setExecutionTime();
                            methodInfo.addToChildInfo(requestIdentifier.getChildMap(), methodInfo2);
                            requestIdentifier.removeObjectFromPOJOExceptionTracker(throwable2);
                        }
                    }
                } else {
                    requestIdentifier.setFrontExceptionAvailable(true);
                    RootTracer.recordEntryandSqlException(throwable, string, string2, string3, requestIdentifier);
                }
            }
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer] [recordEntryPointException] - {} ", throwable);
        }
    }

    public static final void recordSQLException(Object object, String string, String string2, String string3, boolean bl) {
        try {
            Throwable throwable;
            if (!bl) {
                return;
            }
            RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
            if (requestIdentifier == null) {
                return;
            }
            if (PropsManager.isExceptionMatchedIgnoreExceptionList(object.getClass().getName()) && !PropsManager.isExceptionMatchedIncludeExceptionList(object.getClass().getName())) {
                return;
            }
            boolean bl2 = object instanceof Throwable;
            if (bl2 && RootTracer.isFirstEntryAndSqlThrown(throwable = (Throwable)object, requestIdentifier)) {
                if (requestIdentifier.isReadCause()) {
                    ExceptionUtils.collectCauses(throwable, requestIdentifier);
                } else {
                    ExceptionUtils.collectRootAndBottomCause(throwable, requestIdentifier);
                }
                RootTracer.recordEntryandSqlException(throwable, string, string2, string3, requestIdentifier);
            }
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("[RootTracer] [recordSQLException] - {} ", throwable);
        }
    }

    private static boolean doExceptionTrack(Throwable throwable, RequestIdentifier requestIdentifier, Map map) {
        if ((long)requestIdentifier.getTotalExceptionCount() > PropsManager.getCaptureExceptionsMaxTraceLimit()) {
            return true;
        }
        requestIdentifier.incrementTotalExceptionCounter();
        if (requestIdentifier.isExpWithStackTraceCountLimitReached() && requestIdentifier.isExpFQENCountLimitReached()) {
            return true;
        }
        if ((long)requestIdentifier.getTotalExceptionWithStackCount() < PropsManager.getCaptureExceptionsWithStackTraceLimit()) {
            map.put("EXCEPTION", TraceUtils.partialSTEs2Str(throwable, PropsManager.getMaxExceptionLineCount()));
            requestIdentifier.incrementExceptionWithStackCounter();
            requestIdentifier.setExceptionTraceAvailable(true);
        } else {
            requestIdentifier.setExpWithStackTraceCountLimitReached(true);
        }
        if (requestIdentifier.isExpWithStackTraceCountLimitReached()) {
            if ((long)requestIdentifier.getTotalFQExceptionCount() < PropsManager.getCaptureExceptionsWithFQENLimit()) {
                StringBuilder stringBuilder = new StringBuilder();
                String string = throwable.getMessage();
                string = throwable.getMessage() == null ? "-" : string;
                stringBuilder.append(throwable.getClass().getName()).append("?^?").append(string);
                map.put("EXCEPTION", stringBuilder.toString());
                requestIdentifier.incrementFQExceptionCounter();
            } else {
                requestIdentifier.setExpFQENCountLimitReached(true);
            }
        }
        return false;
    }

    private static void recordEntryandSqlException(Throwable throwable, String string, String string2, String string3, RequestIdentifier requestIdentifier) {
        if (requestIdentifier == null || requestIdentifier.isPointcutLimitReached()) {
            return;
        }
        HashMap hashMap = new HashMap();
        boolean bl = RootTracer.doExceptionTrack(throwable, requestIdentifier, hashMap);
        if (bl) {
            return;
        }
        RootTracer.registerEntryAndSqlException(throwable, requestIdentifier);
        long l = BTMUtils.getTimeStamp();
        boolean bl2 = MethodEventProcessor.eventStarted(requestIdentifier, hashMap, "EXCEPTION", string, string2, string3, l, null);
        if (bl2) {
            MethodEventProcessor.eventEnded(requestIdentifier, false, l);
            requestIdentifier.getRootMinfo().setErrorURL(true);
        }
    }

    private static boolean isFirstPOJOThrown(Object object, RequestIdentifier requestIdentifier) {
        return requestIdentifier.getObjectFromPOJOExceptionTracker(object) == null;
    }

    private static void registerPOJOException(Object object, MethodInfo methodInfo, RequestIdentifier requestIdentifier) {
        requestIdentifier.addObjectToPOJOExceptionTracker(object, methodInfo);
    }

    private static boolean isFirstEntryAndSqlThrown(Object object, RequestIdentifier requestIdentifier) {
        return requestIdentifier.getObjectFromEntryAndSQLTracker(object) == null;
    }

    private static void registerEntryAndSqlException(Object object, RequestIdentifier requestIdentifier) {
        requestIdentifier.addObjectToEntryAndSQLTracker(object);
    }
}

