/*
 * Decompiled with CFR 0.152.
 */
package com.eg.org.objectweb.asm.signature;

import com.eg.org.objectweb.asm.signature.SignatureVisitor;

public class SignatureWriter
extends SignatureVisitor {
    private final StringBuilder stringBuilder = new StringBuilder();
    private boolean hasFormals;
    private boolean hasParameters;
    private int argumentStack;

    public SignatureWriter() {
        super(458752);
    }

    public void visitFormalTypeParameter(String string) {
        if (!this.hasFormals) {
            this.hasFormals = true;
            this.stringBuilder.append('<');
        }
        this.stringBuilder.append(string);
        this.stringBuilder.append(':');
    }

    public SignatureVisitor visitClassBound() {
        return this;
    }

    public SignatureVisitor visitInterfaceBound() {
        this.stringBuilder.append(':');
        return this;
    }

    public SignatureVisitor visitSuperclass() {
        this.endFormals();
        return this;
    }

    public SignatureVisitor visitInterface() {
        return this;
    }

    public SignatureVisitor visitParameterType() {
        this.endFormals();
        if (!this.hasParameters) {
            this.hasParameters = true;
            this.stringBuilder.append('(');
        }
        return this;
    }

    public SignatureVisitor visitReturnType() {
        this.endFormals();
        if (!this.hasParameters) {
            this.stringBuilder.append('(');
        }
        this.stringBuilder.append(')');
        return this;
    }

    public SignatureVisitor visitExceptionType() {
        this.stringBuilder.append('^');
        return this;
    }

    public void visitBaseType(char c2) {
        this.stringBuilder.append(c2);
    }

    public void visitTypeVariable(String string) {
        this.stringBuilder.append('T');
        this.stringBuilder.append(string);
        this.stringBuilder.append(';');
    }

    public SignatureVisitor visitArrayType() {
        this.stringBuilder.append('[');
        return this;
    }

    public void visitClassType(String string) {
        this.stringBuilder.append('L');
        this.stringBuilder.append(string);
        this.argumentStack *= 2;
    }

    public void visitInnerClassType(String string) {
        this.endArguments();
        this.stringBuilder.append('.');
        this.stringBuilder.append(string);
        this.argumentStack *= 2;
    }

    public void visitTypeArgument() {
        if (this.argumentStack % 2 == 0) {
            this.argumentStack |= 1;
            this.stringBuilder.append('<');
        }
        this.stringBuilder.append('*');
    }

    public SignatureVisitor visitTypeArgument(char c2) {
        if (this.argumentStack % 2 == 0) {
            this.argumentStack |= 1;
            this.stringBuilder.append('<');
        }
        if (c2 != '=') {
            this.stringBuilder.append(c2);
        }
        return this;
    }

    public void visitEnd() {
        this.endArguments();
        this.stringBuilder.append(';');
    }

    public String toString() {
        return this.stringBuilder.toString();
    }

    private void endFormals() {
        if (this.hasFormals) {
            this.hasFormals = false;
            this.stringBuilder.append('>');
        }
    }

    private void endArguments() {
        if (this.argumentStack % 2 == 1) {
            this.stringBuilder.append('>');
        }
        this.argumentStack /= 2;
    }
}

