/*
 * Decompiled with CFR 0.152.
 */
package com.eg.ch.qos.logback.core.helpers;

import java.util.regex.Pattern;

public class Transform {
    private static final String CDATA_START = "<![CDATA[";
    private static final String CDATA_END = "]]>";
    private static final String CDATA_PSEUDO_END = "]]&gt;";
    private static final String CDATA_EMBEDED_END = "]]>]]&gt;<![CDATA[";
    private static final int CDATA_END_LEN = "]]>".length();
    private static final Pattern UNSAFE_XML_CHARS = Pattern.compile("[\u0000-\b\u000b\f\u000e-\u001f<>&'\"]");

    public static String escapeTags(String string) {
        if (string == null || string.length() == 0 || !UNSAFE_XML_CHARS.matcher(string).find()) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        return Transform.escapeTags(stringBuffer);
    }

    public static String escapeTags(StringBuffer stringBuffer) {
        block8: for (int i2 = 0; i2 < stringBuffer.length(); ++i2) {
            char c2 = stringBuffer.charAt(i2);
            switch (c2) {
                case '\t': 
                case '\n': 
                case '\r': {
                    continue block8;
                }
                case '&': {
                    stringBuffer.replace(i2, i2 + 1, "&amp;");
                    continue block8;
                }
                case '<': {
                    stringBuffer.replace(i2, i2 + 1, "&lt;");
                    continue block8;
                }
                case '>': {
                    stringBuffer.replace(i2, i2 + 1, "&gt;");
                    continue block8;
                }
                case '\"': {
                    stringBuffer.replace(i2, i2 + 1, "&quot;");
                    continue block8;
                }
                case '\'': {
                    stringBuffer.replace(i2, i2 + 1, "&#39;");
                    continue block8;
                }
                default: {
                    if (c2 >= ' ') continue block8;
                    stringBuffer.replace(i2, i2 + 1, "\ufffd");
                }
            }
        }
        return stringBuffer.toString();
    }

    public static void appendEscapingCDATA(StringBuilder stringBuilder, String string) {
        if (string == null) {
            return;
        }
        int n2 = string.indexOf(CDATA_END);
        if (n2 < 0) {
            stringBuilder.append(string);
            return;
        }
        int n3 = 0;
        while (n2 > -1) {
            stringBuilder.append(string.substring(n3, n2));
            stringBuilder.append(CDATA_EMBEDED_END);
            n3 = n2 + CDATA_END_LEN;
            if (n3 < string.length()) {
                n2 = string.indexOf(CDATA_END, n3);
                continue;
            }
            return;
        }
        stringBuilder.append(string.substring(n3));
    }
}

