/*
 * Decompiled with CFR 0.152.
 */
package com.eg;

import com.eg.EgConfigInfo;
import com.eg.EgInstallInfo;
import com.eg.EgSSL;
import com.eg.IniFile;
import com.eg.MyHostnameVerifier;
import com.eg.MyX509TrustManager;
import com.xensource.xenapi.APIVersion;
import com.xensource.xenapi.Connection;
import com.xensource.xenapi.Host;
import com.xensource.xenapi.Session;
import com.xensource.xenapi.Types;
import com.xensource.xenapi.VM;
import com.xensource.xenapi.VMGuestMetrics;
import java.net.URL;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class XenServerDiscovery
extends Thread {
    public static Hashtable xenDiscoveryInfoHash = new Hashtable();
    public static Hashtable allServersHash = new Hashtable();
    private ArrayList checkIpAddressList = new ArrayList();
    private String connectionString = "";
    private String hostIp = "";
    private String webPort = "";
    private String xenUser = "";
    private String xenPassword = "";
    private boolean isSSL = false;
    private String sync = new String("ssl_sync");
    public static boolean isThreadStarted = false;
    public static Hashtable prevServertab = new Hashtable();
    public static Hashtable prevVDItab = new Hashtable();
    public static boolean isFirstTime = true;
    static /* synthetic */ Class class$com$xensource$xenapi$Types$HostIsSlave;
    static /* synthetic */ Class class$com$xensource$xenapi$Types$SessionAuthenticationFailed;
    static /* synthetic */ Class class$com$xensource$xenapi$Types$SessionInvalid;
    static /* synthetic */ Class class$com$xensource$xenapi$Types$HostDisabled;
    static /* synthetic */ Class class$com$xensource$xenapi$Types$HostNameInvalid;
    static /* synthetic */ Class class$com$xensource$xenapi$Types$HostDisabledUntilReboot;
    static /* synthetic */ Class class$com$xensource$xenapi$Types$HostNotEnoughFreeMemory;
    static /* synthetic */ Class class$com$xensource$xenapi$Types$HostNotLive;
    static /* synthetic */ Class class$com$xensource$xenapi$Types$HostOffline;
    static /* synthetic */ Class class$com$xensource$xenapi$Types$HostInEmergencyMode;
    static /* synthetic */ Class class$com$xensource$xenapi$Types$HostHasNoManagementIp;
    static /* synthetic */ Class class$com$xensource$xenapi$Types$HostUnknownToMaster;

    public XenServerDiscovery() {
        this.checkIpAddressList = new ArrayList();
        isThreadStarted = false;
        this.setName("XenServerDiscovery");
        this.start();
    }

    public void run() {
        if (EgConfigInfo.todie) {
            return;
        }
        try {
            if (isThreadStarted) {
                return;
            }
            Enumeration enumeration = xenDiscoveryInfoHash.keys();
            while (enumeration.hasMoreElements() && !EgConfigInfo.todie) {
                isThreadStarted = true;
                String string = (String)enumeration.nextElement();
                ArrayList arrayList = (ArrayList)xenDiscoveryInfoHash.get(string);
                if (arrayList == null || arrayList.size() < 5) continue;
                this.hostIp = (String)arrayList.get(0);
                this.webPort = (String)arrayList.get(1);
                this.xenUser = (String)arrayList.get(2);
                this.xenPassword = (String)arrayList.get(3);
                this.isSSL = (Boolean)arrayList.get(4);
                Connection connection = null;
                try {
                    this.connectionString = "http://" + this.hostIp + ":" + this.webPort + "";
                    if (this.isSSL) {
                        this.installSSL();
                        this.connectionString = "https://" + this.hostIp + ":" + this.webPort + "";
                    }
                    connection = new Connection(new URL(this.connectionString));
                    Session.loginWithPassword((Connection)connection, (String)this.xenUser, (String)this.xenPassword, (String)APIVersion.latest().toString());
                }
                catch (Exception exception) {
                    try {
                        if ((class$com$xensource$xenapi$Types$HostIsSlave == null ? XenServerDiscovery.class$("com.xensource.xenapi.Types$HostIsSlave") : class$com$xensource$xenapi$Types$HostIsSlave).getName().equals(exception.getClass().getName())) {
                            Types.HostIsSlave hostIsSlave = (Types.HostIsSlave)exception;
                            String string2 = hostIsSlave.masterIPAddress.trim();
                            connection = this.getConnection(string2);
                        } else if ((class$com$xensource$xenapi$Types$SessionAuthenticationFailed == null ? XenServerDiscovery.class$("com.xensource.xenapi.Types$SessionAuthenticationFailed") : class$com$xensource$xenapi$Types$SessionAuthenticationFailed).getName().equals(exception.getClass().getName())) {
                            System.out.println("[XenServerDiscovery] Invalid credentials  " + exception);
                        } else if ((class$com$xensource$xenapi$Types$SessionInvalid == null ? XenServerDiscovery.class$("com.xensource.xenapi.Types$SessionInvalid") : class$com$xensource$xenapi$Types$SessionInvalid).getName().equals(exception.getClass().getName())) {
                            System.out.println("[XenServerDiscovery] Invalid session " + exception);
                        } else if ((class$com$xensource$xenapi$Types$HostDisabled == null ? XenServerDiscovery.class$("com.xensource.xenapi.Types$HostDisabled") : class$com$xensource$xenapi$Types$HostDisabled).getName().equals(exception.getClass().getName())) {
                            System.out.println("[XenServerDiscovery] Hostname is disabled " + exception);
                        } else if ((class$com$xensource$xenapi$Types$HostNameInvalid == null ? XenServerDiscovery.class$("com.xensource.xenapi.Types$HostNameInvalid") : class$com$xensource$xenapi$Types$HostNameInvalid).getName().equals(exception.getClass().getName())) {
                            System.out.println("[XenServerDiscovery] Hostname is invalid " + exception);
                        } else if ((class$com$xensource$xenapi$Types$HostDisabledUntilReboot == null ? XenServerDiscovery.class$("com.xensource.xenapi.Types$HostDisabledUntilReboot") : class$com$xensource$xenapi$Types$HostDisabledUntilReboot).getName().equals(exception.getClass().getName())) {
                            System.out.println("[XenServerDiscovery] Host is disabled until restart " + exception);
                        } else if ((class$com$xensource$xenapi$Types$HostNotEnoughFreeMemory == null ? XenServerDiscovery.class$("com.xensource.xenapi.Types$HostNotEnoughFreeMemory") : class$com$xensource$xenapi$Types$HostNotEnoughFreeMemory).getName().equals(exception.getClass().getName())) {
                            System.out.println("[XenServerDiscovery] Host is not enough memory " + exception);
                        } else if ((class$com$xensource$xenapi$Types$HostNotLive == null ? XenServerDiscovery.class$("com.xensource.xenapi.Types$HostNotLive") : class$com$xensource$xenapi$Types$HostNotLive).getName().equals(exception.getClass().getName())) {
                            System.out.println("[XenServerDiscovery] Host is not live " + exception);
                        } else if ((class$com$xensource$xenapi$Types$HostOffline == null ? XenServerDiscovery.class$("com.xensource.xenapi.Types$HostOffline") : class$com$xensource$xenapi$Types$HostOffline).getName().equals(exception.getClass().getName())) {
                            System.out.println("[XenServerDiscovery] Host is Offline " + exception);
                        } else if ((class$com$xensource$xenapi$Types$HostInEmergencyMode == null ? XenServerDiscovery.class$("com.xensource.xenapi.Types$HostInEmergencyMode") : class$com$xensource$xenapi$Types$HostInEmergencyMode).getName().equals(exception.getClass().getName())) {
                            System.out.println("[XenServerDiscovery] Host is in emergency mode " + exception);
                        } else if ((class$com$xensource$xenapi$Types$HostHasNoManagementIp == null ? XenServerDiscovery.class$("com.xensource.xenapi.Types$HostHasNoManagementIp") : class$com$xensource$xenapi$Types$HostHasNoManagementIp).getName().equals(exception.getClass().getName())) {
                            System.out.println("[XenServerDiscovery] Host has no management ip " + exception);
                        } else if ((class$com$xensource$xenapi$Types$HostUnknownToMaster == null ? XenServerDiscovery.class$("com.xensource.xenapi.Types$HostUnknownToMaster") : class$com$xensource$xenapi$Types$HostUnknownToMaster).getName().equals(exception.getClass().getName())) {
                            System.out.println("[XenServerDiscovery] The master says the host is not known to it " + exception);
                        } else {
                            System.err.println("[XenServerDiscovery] failed for URL " + this.connectionString + " with user " + this.xenUser + " Reason: " + exception);
                            exception.printStackTrace();
                        }
                    }
                    catch (Exception exception2) {
                        System.err.println("[XenServerDiscovery] XenConnection failed for URL " + this.connectionString + " with user " + this.xenUser + " Reason: " + exception2);
                        exception2.printStackTrace();
                        System.out.println("[XenServerDiscovery] connection failed " + exception2);
                    }
                }
                if (connection == null) continue;
                this.setXenServersInfo(connection);
                try {
                    Session.logout((Connection)connection);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            isThreadStarted = false;
        }
        catch (Exception exception) {
            System.out.println("[XenServerDiscovery] Exception occured while discover the all XenServers: " + exception);
            exception.printStackTrace();
        }
    }

    public Connection getConnection(String string) {
        Connection connection = null;
        try {
            this.connectionString = "http://" + string + ":" + this.webPort + "";
            if (this.isSSL) {
                this.connectionString = "https://" + string + ":" + this.webPort + "";
            }
            connection = new Connection(new URL(this.connectionString));
            Session.loginWithPassword((Connection)connection, (String)this.xenUser, (String)this.xenPassword, (String)APIVersion.latest().toString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("[XenServerDiscovery] connection failed in Xen Pool Master Server : " + exception);
        }
        return connection;
    }

    private void setXenServersInfo(Connection connection) {
        Hashtable<Object, String> hashtable;
        Hashtable hashtable2;
        Hashtable hashtable3;
        Hashtable hashtable4;
        block18: {
            hashtable4 = new Hashtable();
            hashtable3 = new Hashtable();
            try {
                Object object;
                Object object2;
                hashtable2 = Host.getAllRecords((Connection)connection);
                if (hashtable2 == null || hashtable2.size() <= 0) break block18;
                hashtable = new Hashtable<Object, String>();
                Hashtable<Object, String> hashtable5 = new Hashtable<Object, String>();
                Iterator iterator = hashtable2.values().iterator();
                while (iterator.hasNext()) {
                    String string;
                    object2 = (Host.Record)iterator.next();
                    if (object2 == null || (object = object2.hostname) == null || ((String)object).length() == 0 || (string = object2.address) == null || string.length() == 0 || this.checkIpAddressList.contains(string)) continue;
                    this.checkIpAddressList.add(string);
                    Set set = object2.residentVMs;
                    if (set == null || set.size() == 0) {
                        hashtable.put(object, string);
                        continue;
                    }
                    boolean bl = false;
                    Iterator iterator2 = set.iterator();
                    int n = 0;
                    int n2 = 0;
                    while (iterator2.hasNext()) {
                        String string2;
                        VMGuestMetrics vMGuestMetrics;
                        VM vM = (VM)iterator2.next();
                        if (vM == null || (vMGuestMetrics = vM.getGuestMetrics(connection)) == null) continue;
                        Map map = null;
                        try {
                            map = vMGuestMetrics.getOsVersion(connection);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (map == null || map.size() == 0 || (string2 = (String)map.get("name")) == null || string2.length() == 0) continue;
                        if ((string2 = string2.toLowerCase()).indexOf("2008") > 0 || string2.indexOf("2012") > 0 || string2.indexOf("2016") > 0 || string2.indexOf("2019") > 0 || string2.indexOf("linux") > 0 || string2.indexOf("server") > 0) {
                            ++n;
                            continue;
                        }
                        ++n2;
                    }
                    bl = n >= n2;
                    if (bl) {
                        hashtable.put(object, string);
                        continue;
                    }
                    hashtable5.put(object, string);
                }
                if (!isFirstTime && (prevServertab != null && prevServertab.size() > 0 && prevServertab.containsKey(this.hostIp) || prevVDItab != null && prevVDItab.size() > 0 && prevVDItab.containsKey(this.hostIp))) {
                    object2 = new Hashtable();
                    object = new Hashtable();
                    if (prevServertab.containsKey(this.hostIp)) {
                        object2 = (Hashtable)prevServertab.get(this.hostIp);
                    }
                    if (prevVDItab.containsKey(this.hostIp)) {
                        object = (Hashtable)prevVDItab.get(this.hostIp);
                    }
                    this.writeRemovedServers((Hashtable)object2, (Hashtable)object, hashtable, hashtable5);
                }
                isFirstTime = false;
                if (hashtable.size() > 0) {
                    hashtable4.put(this.hostIp, hashtable);
                }
                if (hashtable5.size() > 0) {
                    hashtable3.put(this.hostIp, hashtable5);
                }
                if (hashtable4.size() > 0) {
                    prevServertab.putAll(hashtable4);
                }
                if (hashtable3.size() > 0) {
                    prevVDItab.putAll(hashtable3);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        hashtable2 = (Hashtable)allServersHash.get("Xen_virtual_server");
        if (hashtable2 == null) {
            hashtable2 = new Hashtable();
        }
        hashtable2.putAll(hashtable4);
        hashtable = (Hashtable<Object, String>)allServersHash.get("Xen_desktop_server");
        if (hashtable == null) {
            hashtable = new Hashtable<Object, String>();
        }
        hashtable.putAll(hashtable3);
        allServersHash.put("Xen_virtual_server", hashtable2);
        allServersHash.put("Xen_desktop_server", hashtable);
        System.out.println("[XenServerDiscovery] allServersHash: " + allServersHash);
    }

    public Hashtable getAllServersDetails() {
        return (Hashtable)allServersHash.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void installSSL() {
        String string = this.sync;
        synchronized (string) {
            try {
                EgSSL egSSL = EgSSL.getInstance();
                egSSL.enableSSL();
                SSLSocketFactory sSLSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
                Object var4_5 = null;
                MyX509TrustManager myX509TrustManager = new MyX509TrustManager();
                KeyManager[] keyManagerArray = null;
                TrustManager[] trustManagerArray = new TrustManager[]{myX509TrustManager};
                SSLContext sSLContext = SSLContext.getInstance("SSL");
                sSLContext.init(keyManagerArray, trustManagerArray, new SecureRandom());
                SSLSocketFactory sSLSocketFactory2 = sSLContext.getSocketFactory();
                HttpsURLConnection.setDefaultSSLSocketFactory(sSLSocketFactory2);
                HttpsURLConnection.setDefaultHostnameVerifier(new MyHostnameVerifier());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void writeRemovedServers(Hashtable hashtable, Hashtable hashtable2, Hashtable hashtable3, Hashtable hashtable4) {
        String string;
        String string2;
        Object object;
        Object object2;
        IniFile iniFile = new IniFile(EgInstallInfo.getInstallDir() + "/agent/logs/eg_agentAutoDelete.ini", true);
        Set set = hashtable.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            object2 = (String)iterator.next();
            object = (String)hashtable.get(object2);
            if (hashtable3.containsKey(object2) || hashtable3.containsKey(object)) continue;
            string2 = "Xen_virtual_server:" + (String)object + ":NULL";
            string = "Xen_virtual_server," + (String)object + "," + (String)object2 + ",NULL,no";
            iniFile.setValue("Removed_Servers", string2, string);
        }
        object2 = hashtable2.keySet();
        object = object2.iterator();
        while (object.hasNext()) {
            string2 = (String)object.next();
            string = (String)hashtable2.get(string2);
            if (hashtable4.containsKey(string2) || hashtable4.containsKey(string)) continue;
            String string3 = "Xen_desktop_server:" + string + ":NULL";
            String string4 = "Xen_desktop_server," + string + "," + string2 + ",NULL,no";
            iniFile.setValue("Removed_Servers", string3, string4);
        }
        iniFile.saveFile();
    }

    public static void main(String[] stringArray) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add("192.168.10.35");
        arrayList.add("80");
        arrayList.add("egmonitor");
        arrayList.add("egurkha");
        arrayList.add(new Boolean(false));
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        arrayList2.add("192.168.10.165");
        arrayList2.add("80");
        arrayList2.add("egmonitor");
        arrayList2.add("eGurkha2013");
        arrayList2.add(new Boolean(false));
        xenDiscoveryInfoHash.put("XenServer1", arrayList);
        xenDiscoveryInfoHash.put("XenServer2", arrayList2);
        XenServerDiscovery xenServerDiscovery = new XenServerDiscovery();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

