/*
 * Decompiled with CFR 0.152.
 */
package com.eg;

import com.eg.EgInstallInfo;
import com.eg.IniFile;
import com.eg.snmpgetsubtree;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class EgSnmpDiscovery {
    private String snmpWalkCmd = "snmpgetsubtree";
    public String[] lhs;
    public String[] rhs;
    public BufferedReader[] rd;
    private String snmpPortNo = "161";
    private Process process;
    private String errorMsg;
    public String transportLayer = "";
    private IniFile testIniFile = null;
    String iniFileName;
    String iniFile_dir;
    public boolean isEncryptionEnabled = false;
    private String snmpVersion;
    private String username;
    private String authPass;
    private String authType;
    private String encryptType;
    private String encryptflag;
    private String encryptPass;
    private String dataOverTCp;
    private String str_Context;
    private int discRetries = 0;

    public boolean runSnmpCmdForOid(String string, String string2, int n, String string3) {
        if (string.endsWith(".0")) {
            string = string.substring(0, string.lastIndexOf(".0"));
        }
        n /= 1000;
        ++n;
        this.iniFileName = "eg_services.ini";
        this.iniFile_dir = EgInstallInfo.getInstallDir() + "/manager/config/";
        this.testIniFile = new IniFile(this.iniFile_dir + this.iniFileName);
        this.dataOverTCp = this.testIniFile.getValue("MISC_ARGS", "DataOverTcp");
        this.snmpVersion = this.testIniFile.getValue("MISC_ARGS", "DiscoverySNMPVersion");
        String string4 = this.testIniFile.getValue("MISC_ARGS", "DiscRetries");
        if (string4 != null && string4.trim().length() > 0) {
            try {
                this.discRetries = Integer.parseInt(string4);
            }
            catch (Exception exception) {
                this.discRetries = 0;
                exception.printStackTrace();
            }
        }
        if (this.snmpVersion == null || this.snmpVersion.length() <= 0) {
            this.snmpVersion = "v1";
        }
        if (this.snmpVersion.equalsIgnoreCase("v3")) {
            this.username = this.testIniFile.getValue("MISC_ARGS", "SnmpUserName");
            this.authPass = this.testIniFile.getValue("MISC_ARGS", "SnmpUserPass");
            this.authType = this.testIniFile.getValue("MISC_ARGS", "SnmpAuthType");
            this.str_Context = this.testIniFile.getValue("MISC_ARGS", "SnmpMgrContext");
            this.encryptflag = this.testIniFile.getValue("MISC_ARGS", "EncType");
        }
        this.transportLayer = this.dataOverTCp != null && this.dataOverTCp.trim().equalsIgnoreCase("yes") ? "tcp" : "udp";
        if (this.username == null) {
            this.username = "none";
        } else if (this.authPass == null) {
            this.authPass = "none";
        } else if (this.authType == null) {
            this.authType = "md5";
        }
        if (this.encryptflag != null && this.encryptflag.equalsIgnoreCase("yes")) {
            this.encryptType = this.testIniFile.getValue("MISC_ARGS", "SnmpEncAuth");
            this.encryptPass = this.testIniFile.getValue("MISC_ARGS", "SnmpEncPass");
            this.isEncryptionEnabled = true;
        }
        if (this.encryptType == null) {
            this.encryptType = "des";
        } else if (this.encryptPass == null) {
            this.encryptPass = "none";
        }
        if (this.str_Context == null || this.str_Context.length() == 0 || this.str_Context.equalsIgnoreCase("none")) {
            this.str_Context = "";
        }
        String[] stringArray = null;
        if (this.snmpVersion.equalsIgnoreCase("v1") || this.snmpVersion.equalsIgnoreCase("v2")) {
            stringArray = new String[]{"-p", "" + this.snmpPortNo, "-c", string3, "-o", "-v", this.snmpVersion.equalsIgnoreCase("v1") ? "1" : "2", string2, string, this.transportLayer};
        } else if (!this.isEncryptionEnabled) {
            stringArray = new String[]{"-o", "-w", "2", "-v", "3", "-p", "" + this.snmpPortNo, "-u", this.username, "-a", this.authType, "-A", this.authPass, string2, string, "-n", this.str_Context, this.transportLayer};
        } else {
            System.out.println("[EgSnmpDiscovery]V3 encryption enabled Section");
            stringArray = new String[]{"-o", "-w", "2", "-v", "3", "-p", "" + this.snmpPortNo, "-u", this.username, "-a", this.authType, "-A", this.authPass, "-x", this.encryptType, "-X", this.encryptPass, string2, string, "-n", this.str_Context, this.transportLayer};
        }
        snmpgetsubtree snmpgetsubtree2 = new snmpgetsubtree(stringArray, n, this.discRetries);
        ArrayList arrayList = snmpgetsubtree2.getSubTree();
        this.lhs = null;
        this.rhs = null;
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        if (arrayList != null && arrayList.size() > 0) {
            int n2;
            int n3 = arrayList.size();
            for (n2 = 0; n2 < n3; ++n2) {
                int n4;
                String string5 = ((String)arrayList.get(n2)).trim();
                if (!string5.startsWith(string) || (n4 = string5.indexOf(61)) < 0) continue;
                String string6 = string5.substring(0, n4);
                String string7 = string5.substring(n4 + 1);
                String string8 = this.replace(string6, string, "");
                if (string8.length() > 0) {
                    string8 = new String(string8.substring(1));
                }
                if (string7.startsWith("\"")) {
                    String string9;
                    int n5 = string7.lastIndexOf("\"");
                    while (n5 <= 0 && ++n2 < n3 && (string9 = (String)arrayList.get(n2)) != null) {
                        string7 = string7 + " " + string9;
                        n5 = string7.lastIndexOf("\"");
                    }
                    string7 = new String(string7.substring(1, n5));
                }
                arrayList2.add(string7);
                arrayList3.add(string8);
            }
            Object[] objectArray = arrayList2.toArray();
            this.rhs = new String[objectArray.length];
            for (n2 = 0; n2 < objectArray.length; ++n2) {
                this.rhs[n2] = objectArray[n2].toString();
            }
            objectArray = arrayList3.toArray();
            this.lhs = new String[objectArray.length];
            for (n2 = 0; n2 < objectArray.length; ++n2) {
                this.lhs[n2] = objectArray[n2].toString();
            }
            return this.lhs.length > 0;
        }
        return false;
    }

    public String replace(String string, String string2, String string3) {
        if (string == null || string2 == null || string2.length() == 0 || string3 == null) {
            return string;
        }
        String string4 = string;
        int n = 0;
        int n2 = string4.indexOf(string2, n);
        if (n2 < 0) {
            return string;
        }
        int n3 = string2.length();
        int n4 = string3.length() - n3;
        n4 = n4 < 0 ? 0 : n4;
        StringBuilder stringBuilder = new StringBuilder(string.length() + (n4 *= 16));
        while (n2 >= 0) {
            stringBuilder.append(string, n, n2).append(string3);
            n = n2 + n3;
            n2 = string4.indexOf(string2, n);
        }
        stringBuilder.append(string, n, string.length());
        return stringBuilder.toString();
    }

    public BufferedReader[] executeProgram(String string) {
        Runtime runtime = Runtime.getRuntime();
        BufferedReader[] bufferedReaderArray = new BufferedReader[2];
        try {
            this.process = runtime.exec(string);
            bufferedReaderArray[1] = new BufferedReader(new InputStreamReader(this.process.getErrorStream()));
            bufferedReaderArray[0] = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
            return bufferedReaderArray;
        }
        catch (Exception exception) {
            bufferedReaderArray = null;
            exception.printStackTrace();
            return null;
        }
    }

    public void closeReader(BufferedReader bufferedReader) {
        if (bufferedReader == null) {
            return;
        }
        try {
            while (bufferedReader.readLine() != null) {
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            bufferedReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void cleanup() {
        if (this.rd != null && this.rd.length >= 2) {
            this.closeReader(this.rd[0]);
            this.closeReader(this.rd[1]);
        }
        this.rd = null;
        if (this.process != null) {
            this.process.destroy();
            this.process = null;
        }
    }
}

