/*
 * Decompiled with CFR 0.152.
 */
package com.eg;

import com.eg.EgConfigInfo;
import com.eg.EgDateInfo;
import com.eg.EgDbInfo;
import com.eg.EgInstallInfo;
import com.eg.IniFile;
import com.egurkha.util.StringUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class EgJspCompiler
extends Thread {
    private String mgrUrl;
    private static boolean debug;
    private boolean delayStart;
    public boolean done;
    private int jspCount = 0;
    private static EgConfigInfo config;
    private static EgDbInfo dbInfo;
    private static String finalDir;
    private static String logDir;
    final ArrayBlockingQueue queue = new ArrayBlockingQueue(10000);
    ThreadPoolExecutor threadPool = null;
    private int initPoolSize = 2;
    private int maxPoolSize = 2;
    private long keepAliveTime = 10L;
    private long sleepAfterCompile = 0L;
    private static String egServicesIniFile;

    public EgJspCompiler(String string, boolean bl, boolean bl2, long l) {
        this.mgrUrl = string;
        debug = bl;
        this.delayStart = bl2;
        this.sleepAfterCompile = l;
        this.setName("EgJspCompilerThread");
        this.setDaemon(true);
        this.start();
    }

    private Runnable createTask(final String string) {
        return new Runnable(){

            public void run() {
                if (EgConfigInfo.todie) {
                    return;
                }
                try {
                    Thread.currentThread().setName("EgJspCompilerTask");
                    URL uRL = new URL(string + "?jsp_precompile=true");
                    HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
                    httpURLConnection.connect();
                    int n = httpURLConnection.getResponseCode();
                    httpURLConnection.disconnect();
                    EgJspCompiler.this.done = true;
                    if (n != 200) {
                        EgJspCompiler.logToErrorFile("Error in compiling ", string, "ERROR-CODE : " + n);
                    }
                }
                catch (Exception exception) {
                    EgJspCompiler.logToErrorFile(string, exception);
                    EgJspCompiler.this.done = true;
                }
            }

            public String toString() {
                return string;
            }
        };
    }

    private void compileAllJsps(File file) {
        if (file != null && file.isDirectory()) {
            File file2;
            int n;
            FileFilter fileFilter = new FileFilter(){

                public boolean accept(File file) {
                    return file.isDirectory();
                }
            };
            File[] fileArray = file.listFiles(fileFilter);
            FilenameFilter filenameFilter = new FilenameFilter(){

                public boolean accept(File file, String string) {
                    return string.endsWith(".jsp");
                }
            };
            File[] fileArray2 = file.listFiles(filenameFilter);
            if (fileArray2 != null) {
                for (n = 0; n < fileArray2.length; ++n) {
                    file2 = fileArray2[n];
                    if (file2 == null) continue;
                    String string = file.getPath();
                    String string2 = string.substring(string.indexOf("webapps") + 7);
                    string2 = StringUtils.replace((String)string2, (String)"\\", (String)"/");
                    this.mgrUrl = StringUtils.replace((String)this.mgrUrl, (String)"\\", (String)"/");
                    try {
                        ++this.jspCount;
                        Runnable runnable = this.createTask(this.mgrUrl + string2 + "/" + file2.getName());
                        this.threadPool.execute(runnable);
                        continue;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
            if (fileArray != null) {
                for (n = 0; n < fileArray.length; ++n) {
                    file2 = fileArray[n];
                    if (file2 == null) continue;
                    this.compileAllJsps(file2);
                }
            }
        }
    }

    public void run() {
        if (EgConfigInfo.todie) {
            return;
        }
        try {
            this.initPoolSize = Integer.valueOf(dbInfo.getThreadPoolProperties("jspc", "initThreads"));
            this.maxPoolSize = Integer.valueOf(dbInfo.getThreadPoolProperties("jspc", "maxThreads"));
            this.keepAliveTime = Integer.valueOf(dbInfo.getThreadPoolProperties("jspc", "threadTimeout")).intValue();
            this.threadPool = new ThreadPoolExecutor(this.initPoolSize, this.maxPoolSize, this.keepAliveTime, TimeUnit.SECONDS, this.queue);
            if (this.delayStart) {
                Thread.sleep(EgConfigInfo.msecPerMin * 3L);
            }
            EgJspCompiler.logToErrorFile("INFO ", "Starting JSP compilation ...");
            this.compileAllJsps(new File(finalDir));
            while (this.threadPool.getActiveCount() != 0 && !EgConfigInfo.todie && this.threadPool.getActiveCount() >= 50) {
            }
            this.threadPool.shutdown();
            this.threadPool.shutdownNow();
            if (this.delayStart) {
                EgJspCompiler.logToErrorFile("INFO ", "INI getting update with TRUE ...");
                this.setIniFileFlag("TRUE");
            }
        }
        catch (Exception exception) {
            EgJspCompiler.logToErrorFile("Exception", exception);
        }
    }

    private void setIniFileFlag(String string) {
        IniFile iniFile = new IniFile(egServicesIniFile, true);
        iniFile.setValue("START MANAGER", "flag", string);
        iniFile.saveFile();
    }

    public int getActiveCount() {
        int n = 0;
        if (this.threadPool != null) {
            n = this.threadPool.getActiveCount();
        }
        return n;
    }

    public boolean isTerminated() {
        if (this.threadPool != null) {
            boolean bl = this.threadPool.isTerminated();
            if (bl) {
                EgJspCompiler.logToErrorFile("INFO ", "JSP compilation has been completed successfully...");
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean shutdownNow() {
        block5: {
            try {
                if (this.threadPool != null) {
                    List<Runnable> list = this.threadPool.shutdownNow();
                    if (list != null && list.size() > 0) {
                        for (int i = 0; i < list.size(); ++i) {
                            Runnable runnable = list.get(i);
                            this.threadPool.remove(runnable);
                        }
                        EgJspCompiler.logToErrorFile("INFO ", "JSP compiler has done for 2 mins and exited");
                        return true;
                    }
                    break block5;
                }
                return false;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return true;
    }

    public static void logToErrorFile(String string, String string2) {
        EgJspCompiler.logToErrorFile("INFO :", string, string2);
    }

    public static void logToErrorFile(String string, Object object) {
        EgJspCompiler.logToErrorFile("ERROR :", string, object.toString());
    }

    public static synchronized void logToErrorFile(String string, String string2, String string3) {
        if (!debug) {
            return;
        }
        PrintWriter printWriter = null;
        EgDateInfo egDateInfo = new EgDateInfo();
        String string4 = egDateInfo.egetDate(false);
        File file = new File(logDir + ".log");
        if (file.length() >= 1000000L) {
            EgInstallInfo.fileRename(logDir + ".log", logDir + "_1.log");
        }
        file = null;
        try {
            if (printWriter == null) {
                printWriter = new PrintWriter(new FileWriter(logDir + ".log", true));
            }
        }
        catch (Exception exception) {
            System.err.println("Cannot open log file ");
            return;
        }
        String string5 = new String(string4 + " " + string + " " + string2 + " " + string3);
        printWriter.println(string5);
        printWriter.close();
    }

    static {
        config = new EgConfigInfo("manager");
        dbInfo = new EgDbInfo("manager");
        finalDir = EgConfigInfo.optEgurkha + "/manager/tomcat/webapps/final/";
        logDir = EgConfigInfo.optEgurkha + "/manager/logs/jsp_compile";
        egServicesIniFile = EgConfigInfo.egMgrConfigDir + EgConfigInfo.egServicesConfigFile;
    }
}

