/*
 * Decompiled with CFR 0.152.
 */
package com.eg;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Statement;
import java.util.Properties;

public class EgCheckDBUser {
    Connection conn = null;
    Statement stmt = null;
    String url;
    String driver;
    String urlWithSvcName;
    String username;
    String password;
    String ntlmV2;
    String errorMsg = "";
    public boolean canContinue = false;
    String domain;

    public static void main(String[] stringArray) {
        System.setProperty("jsse.enableCBCProtection", "false");
        if (stringArray.length < 10) {
            System.out.println("Please pass 10 arguments to execute ...");
            return;
        }
        EgCheckDBUser egCheckDBUser = new EgCheckDBUser(stringArray);
        if (egCheckDBUser.execute()) {
            System.out.println("TRUE");
        } else {
            String string = egCheckDBUser.getUrlWithServiceName();
            if (string.equalsIgnoreCase("SQLSERVER")) {
                System.out.println("User " + egCheckDBUser.username + " does not exist!");
            } else {
                try {
                    if (egCheckDBUser.errorMsg.indexOf("ORA-01017") >= 0) {
                        System.out.println("Oracle User " + egCheckDBUser.username + " does not exist! or invalid USERNAME/PASSWORD (ORA-01017)");
                    } else if (!egCheckDBUser.connect(string)) {
                        if (egCheckDBUser.errorMsg.indexOf("ORA-12514") >= 0) {
                            System.out.println("Database connection failed due to invalid SID/SERVICENAME (ORA-12514)");
                        } else if (egCheckDBUser.errorMsg.indexOf("ORA-12505") >= 0) {
                            System.out.println("Database connection failed due to invalid SID/SERVICENAME (ORA-12505)");
                        } else if (egCheckDBUser.errorMsg.indexOf("ORA-01017") >= 0) {
                            System.out.println("User " + egCheckDBUser.username + " does not exist! or invalid USERNAME/PASSWORD (ORA-01017)");
                        } else {
                            System.out.println("User " + egCheckDBUser.username + " does not exist!");
                        }
                    } else {
                        System.out.println("SERVICENAME");
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public boolean execute() {
        boolean bl = false;
        try {
            bl = this.connect();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.closeConnection();
        return bl;
    }

    public EgCheckDBUser(String[] stringArray) {
        if (!(stringArray[0].equals("-driver") || stringArray[2].equals("-url") || stringArray[4].equals("-user") || stringArray[6].equals("-password") || stringArray[8].equals("-ntlmv2"))) {
            this.errorMsg = "Usage java UserCreate -url <url> -driver <driver> -user <username -password <password> -ntlmv2 <true / false>";
            return;
        }
        this.driver = stringArray[1];
        this.url = stringArray[3];
        this.username = stringArray[5];
        int n = this.username.indexOf("\\");
        if (n < 0) {
            n = this.username.indexOf("/");
        }
        if (n > 0) {
            this.domain = this.username.substring(0, n);
            this.username = this.username.substring(n + 1);
        }
        this.password = stringArray[7];
        this.ntlmV2 = stringArray[9];
    }

    void closeConnection() {
        try {
            if (this.stmt != null) {
                this.stmt.close();
            }
            if (this.conn != null) {
                this.conn.close();
            }
        }
        catch (Exception exception) {
            this.errorMsg = "Error When the connection is closed ...!";
            return;
        }
    }

    public boolean connect() {
        try {
            Class.forName(this.driver);
            if (this.domain == null || this.domain.equalsIgnoreCase("none")) {
                this.conn = DriverManager.getConnection(this.url, this.username, this.password);
            } else {
                Properties properties = new Properties();
                properties.put("user", this.username);
                properties.put("password", this.password);
                properties.put("domain", this.domain);
                if (this.ntlmV2 != null && this.ntlmV2.equals("true")) {
                    properties.put("useNTLMv2", this.ntlmV2);
                }
                this.conn = DriverManager.getConnection(this.url, properties);
            }
        }
        catch (Exception exception) {
            this.errorMsg = exception.toString();
            return false;
        }
        return true;
    }

    public String getUrlWithServiceName() {
        int n = this.url.indexOf("sqlserver");
        if (n == -1) {
            int n2 = this.url.lastIndexOf(":");
            String string = this.url.substring(n2 + 1);
            this.urlWithSvcName = this.url.substring(0, n2) + "/" + string;
        } else {
            this.urlWithSvcName = "SQLSERVER";
        }
        return this.urlWithSvcName;
    }

    public boolean connect(String string) {
        try {
            Class.forName(this.driver);
            this.conn = DriverManager.getConnection(string, this.username, this.password);
        }
        catch (Exception exception) {
            this.errorMsg = exception.toString();
            return false;
        }
        return true;
    }
}

