/*
 * Decompiled with CFR 0.152.
 */
package com.eg;

import com.eg.CacheConfigParameter;
import com.eg.Cacheability;
import com.eg.HTTPCacheHeader;
import com.egurkha.ini.IniUI;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class CacheFilter
implements Filter {
    private Cacheability cacheability;
    private boolean isStatic;
    private long seconds;
    String cachingParam = null;
    private static final Logger LOGGER = Logger.getLogger(CacheFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
        this.cacheability = Boolean.valueOf(filterConfig.getInitParameter(CacheConfigParameter.PRIVATE.getName())) != false ? Cacheability.PRIVATE : Cacheability.PUBLIC;
        this.isStatic = Boolean.valueOf(filterConfig.getInitParameter(CacheConfigParameter.STATIC.getName()));
        IniUI iniUI = IniUI.getInstance();
        this.cachingParam = iniUI.getValue("Caching", "EnableBrowserCaching");
        try {
            this.seconds = Long.valueOf(filterConfig.getInitParameter(CacheConfigParameter.EXPIRATION_TIME.getName()));
        }
        catch (NumberFormatException numberFormatException) {
            throw new ServletException("The initialization parameter " + CacheConfigParameter.EXPIRATION_TIME.getName() + " is missing for filter " + filterConfig.getFilterName() + ".");
        }
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        StringBuilder stringBuilder = null;
        if (this.cachingParam != null && this.cachingParam.equalsIgnoreCase("true")) {
            stringBuilder = new StringBuilder(this.cacheability.getValue()).append(", max-age=").append(this.seconds);
            if (!this.isStatic) {
                stringBuilder.append(", must-revalidate");
            }
            httpServletResponse.setHeader(HTTPCacheHeader.CACHE_CONTROL.getName(), stringBuilder.toString());
            httpServletResponse.setDateHeader(HTTPCacheHeader.EXPIRES.getName(), System.currentTimeMillis() + this.seconds * 1000L);
        }
        if (httpServletResponse.containsHeader("Pragma")) {
            LOGGER.debug((Object)"found pragma header");
            httpServletResponse.setHeader(HTTPCacheHeader.PRAGMA.getName(), "");
        } else {
            LOGGER.debug((Object)"did not find pragma header");
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    public void destroy() {
    }
}

