﻿clear
[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$egurkhaPath=(Get-Item Env:EGURKHA_INSTALL_DIR).value.ToString()
$metriInput=''
$sboDir=$egurkhaPath+'\agent\SBO'
if(!(Test-Path -Path $sboDir )){
    $null=New-Item -ItemType directory -Path $sboDir
}
$nwAsses=Get-Childitem "C:\*\Microsoft Skype for Business Network Assessment Tool" -Recurse
$nwrkAssessDir=$nwAsses.Directory[0].ToString()
$stdOutCallDtls=$sboDir+'\SBOCallsDtlsStdOut.txt'
$stdOut90metric=$sboDir+'\SBO90MetricStdOut.txt'
$stdOutConnChk=$sboDir+'\SBOConnChkStdOut.txt'

#----------Call Details-------------
push-location $nwrkAssessDir
$exe=$nwrkAssessDir+'\NetworkAssessmentTool.exe'
Start-Process -FilePath $exe -Wait -WindowStyle Hidden -RedirectStandardOutput $stdOutCallDtls

$callInitiate=0
$callComplted=0
$callFailed=0
$flag=$false
$cntnt=Get-Content -Path $stdOutCallDtls
for($j=0;$j -lt $cntnt.Length;$j++){
    if($cntnt[$j].Contains('Starting new call')){
        $callInitiate++
        $flag=$true    
    }
    if($cntnt[$j].Contains('Call completed')){
        $callComplted++
    }
    if($cntnt[$j].ToLower().Contains('error')){
        if($flag){
            $callFailed++
            $flag=$false
        }
        $errorDD='CallErrorDD#-~!~-~!~-~!~-~!~-~!~-~!~-~!~Call '+$callInitiate+': '+$cntnt[$j]+'~!~-'
        Write-Host $errorDD
    }
    if($cntnt[$j].StartsWith('Result has been written to:')){
        $cutStr='Result has been written to: '
        $metriInput=$cntnt[$j].Substring($cutStr.Length).Trim().ToString()
    }
}
$meaOutPut=$callInitiate.ToString()+'~'+$callComplted.ToString()+'~'+$callFailed.ToString()


# ---------Connection Check--------------
$connchkStatus='Success'
$arg='/connectivitycheck /verbose'
Start-Process -FilePath $exe -ArgumentList $arg -Wait -WindowStyle Hidden -RedirectStandardOutput $stdOutConnChk
$isFailed=$false
$connChkCnt=Get-Content -Path $stdOutConnChk
 foreach ($connOut in $connChkCnt){
    if($connOut.ToLower().contains('not reachable')){
        $outc='ConnchkDD#'+'-~!~-~!~-~!~-~!~-~!~-~!~-~!~-~!~'+$connOut
        Write-Host $outc
        $connchkStatus='Failure'
    }
 }
#----90th percentile-------
$exe = $nwrkAssessDir+'\ResultsAnalyzer.exe'
Start-Process -FilePath $exe -ArgumentList $metriInput -Wait -WindowStyle Hidden -RedirectStandardOutput $stdOut90metric
$metricCntnt=Get-Content -Path $stdOut90metric
$packetLoss=''
$rttLatency=''
$jittr=''
$packtReOrder=''
for($i=0;$i -lt $metricCntnt.Length;$i++){
    if($metricCntnt[$i].Contains('90th percentile values per')){
        $i++
        $packetLoss=$metricCntnt[$i].Substring(22)
        $packetLoss=$packetLoss.Substring(0,$packetLoss.Length-1)
        $i++
        $rttLatency=$metricCntnt[$i].Substring(22)
        $i++
        $jittr=$metricCntnt[$i].Substring(22)
        $i++
        $packtReOrder=$metricCntnt[$i].Substring(22)
        $packtReOrder=$packtReOrder.Substring(0,$packtReOrder.Length-1)
    }
}
$packetLoss=[math]::Round($packetLoss,2)
$rttLatency=[math]::Round($rttLatency,2)
$jittr=[math]::Round($jittr,2)
$packtReOrder=[math]::Round($packtReOrder,2)
$rsltAnalzer=$packetLoss.ToString()+'~'+$rttLatency.ToString()+'~'+$jittr.ToString()+'~'+$packtReOrder.ToString()

$itraMetric=Get-Content -Path $metriInput
$Tab = [char]9
for($k=0;$k -lt $itraMetric.Length;$k++){
    if($k -gt 0){
        $iline=$itraMetric[$k].Replace($Tab,'~')
        $iline=$iline.Replace('~','~!~')
        $ntItrea='NetworkItreationsDD#'+$iline+'~!~-~!~-'
        Write-Host $ntItrea
    }
}

$measr='SBOCallConnMeas#'+$meaOutPut+'~'+$connchkStatus+'~'+$rsltAnalzer
write-host $measr

$outputFile= Split-Path $metriInput -leaf
$dirPth=$metriInput.Substring(0,$metriInput.IndexOf($outputFile)).Trim()
$connChk=$dirPth+'connectivity_results.txt'

Remove-Item $metriInput
Remove-Item $connChk
Remove-Item $stdOutCallDtls
Remove-Item $stdOut90metric
Remove-Item $stdOutConnChk




