﻿Function Get-LocalTime(){
	[CmdletBinding()]
    Param(
        [Parameter(Mandatory=$true, Position=1)]
        [String]$dat, 
        [Parameter(Mandatory=$true, Position=2)]
        [String]$hr
    )
    Process
    {
        $ltimArr=@()
        $UTCTime=[DateTime]$dat
        $UTCTime=$UTCTime.AddHours([int]$hr)
        $strCurrentTimeZone = (Get-WmiObject win32_timezone).StandardName
        $TZ = [System.TimeZoneInfo]::FindSystemTimeZoneById($strCurrentTimeZone)
        $LocalTime = [System.TimeZoneInfo]::ConvertTimeFromUtc($UTCTime, $TZ)
        $ltimArr+='{0:yyyy-MM-dd}' -f $LocalTime
        $ltimArr+=(Get-Date $LocalTime).Hour
        Return $ltimArr
    }
}
[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$egurkhaPath=(Get-Item Env:EGURKHA_INSTALL_DIR).value.ToString()
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
$cqdModule=$scriptPath+"\MTMCallQlityReport.psm1"
Import-Module $egEncryPath,$egDatnKy,$cqdModule
clear

$TestInputs=$args
$userName=$TestInputs[0]
$password=Eg-O365Dcr -EncStr $TestInputs[1]
$mperiodAndIsTeam=$TestInputs[2].ToString().Split('#')
$mPeriodInMin=[int]$mperiodAndIsTeam[0].Trim()
$IsTeamsEnabled=$mperiodAndIsTeam[1].Trim()
$rptDateHr=$mperiodAndIsTeam[2].Trim()
$prxyCrds=$TestInputs[3].ToString().Split('#')
$proxyUsr=$prxyCrds[0]
$proxyPass=Eg-O365Dcr -EncStr $prxyCrds[1]
$proxyserverip=($TestInputs[4]).ToString().trim()

$dat1=(Get-Date).AddMinutes(-($mPeriodInMin))
$dat2=$dat1.ToUniversalTime()
$hr=$dat2.Hour
$strtDatStr='{0:yyyy-MM-dd}' -f $dat2
$endDatStr='{0:yyyy-MM-dd}' -f $dat2.AddDays(1)
if($rptDateHr -ne 'none'){
    $arr=$rptDateHr.Split('~')
    $lstRptDat=$arr[0]
    $chkrptDat=$lstRptDat
    $lstrptHr=$arr[1]
    $chkrptHr=$lstrptHr
    $chkPnt=$arr[2] 
}else{
    $lstRptDat=$strtDatStr
    $lstrptHr=$hr
}

$credential = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $userName, $(convertto-securestring $password -asplaintext -force)
if(!$proxyserverip.ToString().ToLower().Contains('none')){
    $proxyserver='http://'+$proxyserverip
    [system.net.webrequest]::defaultwebproxy = new-object system.net.webproxy($proxyserver)
    if($proxyUsr.ToString().ToLower() -ne 'none' -and $proxyPass.ToString().ToLower() -ne 'none'){
        $proxyCred = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $proxyUsr, $(convertto-securestring $proxyPass -asplaintext -force)
        [system.net.webrequest]::defaultwebproxy.credentials =$proxyCred   #[System.Net.CredentialCache]::DefaultNetworkCredentials
        [system.net.webrequest]::defaultwebproxy.BypassProxyOnLocal = $true
    }
 }
$measures='Measures.VBSS Stream Count','Measures.VBSS Poor Due To VideoPostFecplr Count','Measures.VBSS Poor Due To VideoLocalFrameLossPercentageAvg Count','Measures.VBSS Poor Due To VideoFrameRateAvg Count','Measures.VBSS Poor Stream Count','Measures.VBSS Good Stream Count','Measures.VBSS Unclassified Stream Count','Measures.VBSS Poor Percentage'
$Dimentions ='AllStreams.Date','AllStreams.Hour','AllStreams.First IP Address','AllStreams.Second IP Address','AllStreams.Conference Id','AllStreams.Is Teams','AllStreams.Media Type','AllStreams.ClassifiedPoorCall','AllStreams.VBSS Poor Due To VideoFrameRateAvg','AllStreams.VBSS Poor Due To VideoLocalFrameLossPercentageAvg','AllStreams.VBSS Poor Due To VideoPostFecplr','AllStreams.First UPN','AllStreams.Second UPN'

$VBBSTOutput=Get-CQDData -Dimensions $Dimentions -StartDate $lstRptDat -EndDate $endDatStr  -Measures $measures -OutPutType DataTable -username $username -password $password -CQDVer V3 | Where-Object { $_.'Media Type' -eq 'VBSS' -and [int]$_.Hour -gt $lstrptHr } | Where-Object {$_.'Is Teams' -eq '1' -or $_.'Is Teams' -eq $IsTeamsEnabled}
if($strtDatStr -ne $lstRptDat){
    $lstRptDat=$strtDatStr
    $lstrptHr=0
    $VBBSTOutput+=Get-CQDData -Dimensions $Dimentions -StartDate $lstRptDat -EndDate $endDatStr  -Measures $measures -OutPutType DataTable -username $username -password $password -CQDVer V3 | Where-Object { $_.'Media Type' -eq 'VBSS' -and [int]$_.Hour -ge $lstrptHr } | Where-Object {$_.'Is Teams' -eq '1' -or $_.'Is Teams' -eq $IsTeamsEnabled}
}
$VBBSTOutput | select * | ForEach-Object {if($_.Date -eq $lstRptDat -and $_.Hour -gt $lstrptHr){$lstrptHr=$_.Hour};}

$isWrite=$true
if($lstRptDat -eq $chkrptDat -and $lstrptHr -eq $chkrptHr){
    $chkPnt=[int]$chkPnt+1
    if([int]$chkPnt -gt 1){
        $isWrite=$false
    }
}else{
    $chkPnt=1
}
$rptDatHrstr='LastReporting Date and Hour#'+$lstRptDat+'~'+$lstrptHr+'~'+$chkPnt
Write-Host $rptDatHrstr

if($isWrite){
    $VBSSStreamCount= 0 
    $VBSSPoorDueToVideoPostFecplrCount= 0 
    $VBSSPoorDueToVideoLocalFrameLossPercentageAvgCount= 0 
    $VBSSPoorDueToVideoFrameRateAvgCount= 0 
    $VBSSPoorStreamCount= 0 
    $VBSSGoodStreamCount= 0 
    $VBSSUnclassifiedStreamCount= 0 
    $VBSSPoorPercentage= 0 

    if($VBBSTOutput){
        $VBBSStreamCountlist =$VBBSTOutput  | where-object { -not [string]::IsNullOrEmpty($_.'VBSS Stream Count')  -and $_.'VBSS Stream Count' -ne 'NaN' } 
        $VBSSStreamCount = ($VBBSStreamCountlist| Measure-Object "VBSS Stream Count" -Sum | select Sum).Sum
        if(-not $VBSSStreamCount){  $VBSSStreamCount=0 }
        $VBBSStreamCountlist=$null

        Write-host '********************* dd VBSSPoorDueToVideoPostFecplrCount measure***********************'
        $VBSSPoorDueToVideoPostFecplrCountlist =$VBBSTOutput  | where-object { -not [string]::IsNullOrEmpty($_.'VBSS Poor Due To VideoPostFecplr Count')  -and $_.'VBSS Poor Due To VideoPostFecplr Count' -ne 'NaN' } 
        $VBSSPoorDueToVideoPostFecplrCount = ($VBSSPoorDueToVideoPostFecplrCountlist | Measure-Object "VBSS Poor Due To VideoPostFecplr Count" -Sum | select Sum).Sum
        if(-not $VBSSPoorDueToVideoPostFecplrCount){  $VBSSPoorDueToVideoPostFecplrCount=0 } else { $VBSSPoorDueToVideoPostFecplrCount=$VBSSPoorDueToVideoPostFecplrCount.ToString("#.##") }
        if($VBSSPoorDueToVideoPostFecplrCount){
            $ddlist = $VBSSPoorDueToVideoPostFecplrCountlist | Where-Object { $_."VBSS Poor Due To VideoPostFecplr Count" -gt 0.0001 } | Sort-Object { $_."VBSS Poor Due To VideoPostFecplr Count" -as [int] } -Descending | select -First 10
            foreach($in in $ddlist){
                $ltimArr=Get-LocalTime -dat $in.Date -hr $in.Hour
                Write-Host 'ddVideoPoorDueToVideoPostFecplrCount#' $ltimArr[0] ~!~ $ltimArr[1] ~!~ $in.'First UPN' ~!~ $in.'Second UPN' ~!~ $in.'First IP Address' ~!~ $in.'Second IP Address' ~!~ $in.'Conference Id' ~!~ $in.'VBSS Poor Due To VideoPostFecplr Count'
            }
            $ddlist=$null
        }
        $VBSSPoorDueToVideoPostFecplrCountlist=$null

        Write-host '********************* dd VBSSPoorDueToVideoLocalFrameLossPercentageAvgCount measure***********************'
        $VBSSPoorDueToVideoLocalFrameLossPercentageAvgCountlist =$VBBSTOutput  | where-object { -not [string]::IsNullOrEmpty($_.'VBSS Poor Due To VideoLocalFrameLossPercentageAvg Count')  -and $_.'VBSS Poor Due To VideoLocalFrameLossPercentageAvg Count' -ne 'NaN' } 
        $VBSSPoorDueToVideoLocalFrameLossPercentageAvgCount = ($VBSSPoorDueToVideoLocalFrameLossPercentageAvgCountlist | Measure-Object "VBSS Poor Due To VideoLocalFrameLossPercentageAvg Count" -Sum | select Sum).Sum
        if(-not $VBSSPoorDueToVideoLocalFrameLossPercentageAvgCount){  $VBSSPoorDueToVideoLocalFrameLossPercentageAvgCount=0 } else { $VBSSPoorDueToVideoLocalFrameLossPercentageAvgCount=$VBSSPoorDueToVideoLocalFrameLossPercentageAvgCount.ToString("#.##") }
        if($VBSSPoorDueToVideoLocalFrameLossPercentageAvgCount){
            $ddlist = $VBSSPoorDueToVideoLocalFrameLossPercentageAvgCountlist | Where-Object { $_."VBSS Poor Due To VideoLocalFrameLossPercentageAvg Count" -gt 0.0001 } | Sort-Object { $_."VBSS Poor Due To VideoLocalFrameLossPercentageAvg Count" -as [int] } -Descending | select -First 10
            foreach($in in $ddlist){
                $ltimArr=Get-LocalTime -dat $in.Date -hr $in.Hour
                Write-Host 'ddVBSSPoorDueToVideoLocalFrameLossPercentageAvgCount#' $ltimArr[0] ~!~ $ltimArr[1] ~!~ $in.'First UPN' ~!~ $in.'Second UPN' ~!~ $in.'First IP Address' ~!~ $in.'Second IP Address' ~!~ $in.'Conference Id' ~!~ $in.'VBSS Poor Due To VideoLocalFrameLossPercentageAvg Count'
            }
            $ddlist=$null
        }
        $VBSSPoorDueToVideoLocalFrameLossPercentageAvgCountlist=$null

        Write-host '********************* dd VBSSPoorDueToVideoFrameRateAvgCount measure***********************'
        $VBSSPoorDueToVideoFrameRateAvgCountlist =$VBBSTOutput  | where-object { -not [string]::IsNullOrEmpty($_.'VBSS Poor Due To VideoFrameRateAvg Count')  -and $_.'VBSS Poor Due To VideoFrameRateAvg Count' -ne 'NaN' } 
        $VBSSPoorDueToVideoFrameRateAvgCount = ($VBSSPoorDueToVideoFrameRateAvgCountlist | Measure-Object "VBSS Poor Due To VideoFrameRateAvg Count" -Sum | select Sum).Sum
        if(-not $VBSSPoorDueToVideoFrameRateAvgCount){  $VBSSPoorDueToVideoFrameRateAvgCount=0 } else { $VBSSPoorDueToVideoFrameRateAvgCount=$VBSSPoorDueToVideoFrameRateAvgCount.ToString("#.##") }
        if($VBSSPoorDueToVideoFrameRateAvgCount){
            $ddlist = $VBSSPoorDueToVideoFrameRateAvgCountlist | Where-Object { $_."VBSS Poor Due To VideoFrameRateAvg Count" -gt 0.0001 } | Sort-Object { $_."VBSS Poor Due To VideoFrameRateAvg Count" -as [int] } -Descending | select -First 10
            foreach($in in $ddlist){
                $ltimArr=Get-LocalTime -dat $in.Date -hr $in.Hour
                Write-Host 'ddVBSSPoorDueToVideoFrameRateAvgCount#' $ltimArr[0] ~!~ $ltimArr[1] ~!~ $in.'First UPN' ~!~ $in.'Second UPN' ~!~ $in.'First IP Address' ~!~ $in.'Second IP Address' ~!~ $in.'Conference Id' ~!~ $in.'VBSS Poor Due To VideoFrameRateAvg Count'
            }
            $ddlist=$null
        }
        $VBSSPoorDueToVideoFrameRateAvgCountlist=$null

        Write-host '********************* dd VBSSPoorStreamCount measure***********************'
        $VBSSPoorStreamCountlist =$VBBSTOutput  | where-object { -not [string]::IsNullOrEmpty($_.'VBSS Poor Stream Count')  -and $_.'VBSS Poor Stream Count' -ne 'NaN' } 
        $VBSSPoorStreamCount = ($VBSSPoorStreamCountlist | Measure-Object "VBSS Poor Stream Count" -Sum | select Sum).Sum
        if(-not $VBSSPoorStreamCount){  $VBSSPoorStreamCount=0 }  else { $VBSSPoorStreamCount=$VBSSPoorStreamCount.ToString("#.##") }
        if($VBSSPoorStreamCount){
            $ddlist = $VBSSPoorStreamCountlist | Where-Object { $_."VBSS Poor Stream Count" -gt 0.0001 } | Sort-Object { $_."VBSS Poor Stream Count" -as [int] } -Descending | select -First 10
            foreach($in in $ddlist){
                $ltimArr=Get-LocalTime -dat $in.Date -hr $in.Hour
                Write-Host 'ddVBSSPoorStreamCount#' $ltimArr[0] ~!~ $ltimArr[1] ~!~ $in.'First UPN' ~!~ $in.'Second UPN' ~!~ $in.'First IP Address' ~!~ $in.'Second IP Address' ~!~ $in.'Conference Id' ~!~ $in.'VBSS Poor Stream Count'
            }
            $ddlist=$null
        }
        $VBSSPoorStreamCountlist=$null

        $VBSSGoodStreamCountlist =$VBBSTOutput  | where-object { -not [string]::IsNullOrEmpty($_.'VBSS Good Stream Count')  -and $_.'VBSS Good Stream Count' -ne 'NaN' } 
        $VBSSGoodStreamCount = ($VBSSGoodStreamCountlist | Measure-Object "VBSS Good Stream Count" -Sum | select Sum).Sum
        if(-not $VBSSGoodStreamCount){  $VBSSGoodStreamCount=0 } else { $VBSSGoodStreamCount=$VBSSGoodStreamCount.ToString("#.##") }
        $VBSSGoodStreamCountlist=$null

        $VBSSUnclassifiedStreamCountlist =$VBBSTOutput  | where-object { -not [string]::IsNullOrEmpty($_.'VBSS Unclassified Stream Count')  -and $_.'VBSS Unclassified Stream Count' -ne 'NaN' } 
        $VBSSUnclassifiedStreamCount = ($VBSSUnclassifiedStreamCountlist | Measure-Object "VBSS Unclassified Stream Count" -Sum | select Sum).Sum
        if(-not $VBSSUnclassifiedStreamCount){  $VBSSUnclassifiedStreamCount=0 } else { $VBSSUnclassifiedStreamCount=$VBSSUnclassifiedStreamCount.ToString("#.##") }
        $VBSSUnclassifiedStreamCountlist=$null

        Write-host '********************* VBSSPoorPercentage measure***********************'
        # $VBSSPoorPercentagelist =$VBBSTOutput  | where-object { -not [string]::IsNullOrEmpty($_.'VBSS Poor Percentage')  -and $_.'VBSS Poor Percentage' -ne 'NaN' -and $_.'VBSS Poor Percentage' -gt 0.0001 } 
        # $VBSSPoorPercentage = ($VBSSPoorPercentagelist  | Measure-Object "VBSS Poor Percentage" -Average | select Average).Average
        $VBSSPoorPercentage = ($VBSSPoorStreamCount/$VBSSStreamCount)*100
        if(-not $VBSSPoorPercentage){  $VBSSPoorPercentage=0 } else { $VBSSPoorPercentage=$VBSSPoorPercentage.ToString("#.##") }
        $VBSSPoorPercentagelist=$null

        Write-Host 'measures##' $VBSSStreamCount ~ $VBSSPoorDueToVideoPostFecplrCount ~ $VBSSPoorDueToVideoLocalFrameLossPercentageAvgCount ~ $VBSSPoorDueToVideoFrameRateAvgCount ~ $VBSSPoorStreamCount ~ $VBSSGoodStreamCount ~ $VBSSUnclassifiedStreamCount ~ $VBSSPoorPercentage 
    }
}