﻿[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
Function Get-LocalTime(){
	[CmdletBinding()]
    Param(
        [Parameter(Mandatory=$true, Position=1)]
        [String]$dat, 
        [Parameter(Mandatory=$true, Position=2)]
        [String]$hr
    )
    Process
    {
        $ltimArr=@()
        $UTCTime=[DateTime]$dat
        $UTCTime=$UTCTime.AddHours([int]$hr)
        $strCurrentTimeZone = (Get-WmiObject win32_timezone).StandardName
        $TZ = [System.TimeZoneInfo]::FindSystemTimeZoneById($strCurrentTimeZone)
        $LocalTime = [System.TimeZoneInfo]::ConvertTimeFromUtc($UTCTime, $TZ)
        $ltimArr+='{0:yyyy-MM-dd}' -f $LocalTime
        $ltimArr+=(Get-Date $LocalTime).Hour
        Return $ltimArr
    }
}

$egurkhaPath=(Get-Item Env:EGURKHA_INSTALL_DIR).value.ToString()
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
$cqdModule=$scriptPath+"\MTMCallQlityReport.psm1"
Import-Module $egEncryPath,$egDatnKy,$cqdModule
clear

$TestInputs=$args
$userName=$TestInputs[0]
$password=Eg-O365Dcr -EncStr $TestInputs[1]
$mperiodAndIsTeam=$TestInputs[2].ToString().Split('#')
$mPeriodInMin=[int]$mperiodAndIsTeam[0].Trim()
$IsTeamsEnabled=$mperiodAndIsTeam[1].Trim()
$rptDateHr=$mperiodAndIsTeam[2].Trim()
$prxyCrds=$TestInputs[3].ToString().Split('#')
$proxyUsr=$prxyCrds[0]
$proxyPass=Eg-O365Dcr -EncStr $prxyCrds[1]
$proxyserverip=($TestInputs[4]).ToString().trim()

$dat1=(Get-Date).AddMinutes(-($mPeriodInMin))
$dat2=$dat1.ToUniversalTime()
$hr=$dat2.Hour
$strtDatStr='{0:yyyy-MM-dd}' -f $dat2
$endDatStr='{0:yyyy-MM-dd}' -f $dat2.AddDays(1)
if($rptDateHr -ne 'none'){
    $arr=$rptDateHr.Split('~')
    $lstRptDat=$arr[0]
    $chkrptDat=$lstRptDat
    $lstrptHr=$arr[1]
    $chkrptHr=$lstrptHr
    $chkPnt=$arr[2] 
}else{
    $lstRptDat=$strtDatStr
    $lstrptHr=$hr
}

$credential = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $userName, $(convertto-securestring $password -asplaintext -force)
if(!$proxyserverip.ToString().ToLower().Contains('none')){
    $proxyserver='http://'+$proxyserverip
    [system.net.webrequest]::defaultwebproxy = new-object system.net.webproxy($proxyserver)
    if($proxyUsr.ToString().ToLower() -ne 'none' -and $proxyPass.ToString().ToLower() -ne 'none'){
        $proxyCred = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $proxyUsr, $(convertto-securestring $proxyPass -asplaintext -force)
        [system.net.webrequest]::defaultwebproxy.credentials =$proxyCred   #[System.Net.CredentialCache]::DefaultNetworkCredentials
        [system.net.webrequest]::defaultwebproxy.BypassProxyOnLocal = $true
    }
 }

$measures='Measures.AppSharing Stream Count','Measures.AppSharing Poor Due To SpoiledTilePercentTotal Count','Measures.AppSharing Poor Due To RelativeOneWayAverage Count','Measures.AppSharing Poor Due To RDPTileProcessingLatencyAverage Count','Measures.AppSharing Poor Stream Count','Measures.AppSharing Good Stream Count','Measures.AppSharing Unclassified Stream Count','Measures.AppSharing Poor Percentage','Measures.Avg AppSharing Spoiled Tile Percent Total','Measures.Avg AppSharing Relative OneWay','Measures.Avg AppSharing RDP Tile Processing Latency','Measures.Avg Relative OneWay','Measures.Avg Relative OneWay Max'
$Dimentions ='AllStreams.Date','AllStreams.Hour','AllStreams.First IP Address','AllStreams.Second IP Address','AllStreams.Conference Id','AllStreams.AppSharing Poor Due To SpoiledTilePercentTotal','AllStreams.AppSharing Poor Due To RelativeOneWayAverage','AllStreams.AppSharing Poor Due To RDPTileProcessingLatencyAverage','AllStreams.ClassifiedPoorCall','AllStreams.Is Teams','AllStreams.Media Type','AllStreams.First UPN','AllStreams.Second UPN'

$AppShrngStrmsOutput=Get-CQDData -Dimensions $Dimentions -StartDate $lstRptDat -EndDate $endDatStr  -Measures $measures -OutPutType DataTable -username $username -password $password -CQDVer V3  | Where-Object { $_.'Media Type' -eq 'AppSharing' -and [int]$_.Hour -gt $lstrptHr} | Where-Object {$_.'Is Teams' -eq '1' -or $_.'Is Teams' -eq $IsTeamsEnabled}
if($strtDatStr -ne $lstRptDat){
    $lstRptDat=$strtDatStr
    $lstrptHr=0
    $AppShrngStrmsOutput+=Get-CQDData -Dimensions $Dimentions -StartDate $lstRptDat -EndDate $endDatStr  -Measures $measures -OutPutType DataTable -username $username -password $password -CQDVer V3  | Where-Object { $_.'Media Type' -eq 'AppSharing' -and [int]$_.Hour -ge $lstrptHr} | Where-Object {$_.'Is Teams' -eq '1' -or $_.'Is Teams' -eq $IsTeamsEnabled}
}
$AppShrngStrmsOutput | select * | ForEach-Object {if($_.Date -eq $lstRptDat -and $_.Hour -gt $lstrptHr){$lstrptHr=$_.Hour};}

$isWrite=$true
if($lstRptDat -eq $chkrptDat -and $lstrptHr -eq $chkrptHr){
    $chkPnt=[int]$chkPnt+1
    if([int]$chkPnt -gt 1){
        $isWrite=$false
    }
}else{
    $chkPnt=1
}
$rptDatHrstr='LastReporting Date and Hour#'+$lstRptDat+'~'+$lstrptHr+'~'+$chkPnt
Write-Host $rptDatHrstr

if($isWrite){
    $AppSharingStreamCount=0
    $AppSharingPoorDueToSpoiledTilePercentTotalCount=0
    $AppSharingPoorDueToRelativeOneWayAverageCount=0
    $AppSharingPoorDueToRDPTileProcessingLatencyAverageCount=0
    $AppSharingPoorStreamCount=0
    $AppSharingGoodStreamCount=0
    $AppSharingUnclassifiedStreamCount=0
    $AppSharingPoorPercentage=0
    $AvgAppSharingSpoiledTilePercentTotal=0
    $AvgAppSharingRDPTileProcessingLatency=0
    $AvgRelativeOneWay=0
    $AvgRelativeOneWayMax=0

    if($AppShrngStrmsOutput){
        $AppSharingStreamCountlist =$AppShrngStrmsOutput  | where-object { -not [string]::IsNullOrEmpty($_.'AppSharing Stream Count')  -and $_.'AppSharing Stream Count' -ne 'NaN' } 
        $AppSharingStreamCount = ($AppSharingStreamCountlist| Measure-Object "AppSharing Stream Count" -Sum | select Sum).Sum
        if(-not $AppSharingStreamCount){  
            $AppSharingStreamCount=0
        }
        $AppSharingStreamCountlist=$null

        $AppSharingPoorDueToSpoiledTilePercentTotalCountlist =$AppShrngStrmsOutput  | where-object { -not [string]::IsNullOrEmpty($_.'AppSharing Poor Due To SpoiledTilePercentTotal Count')  -and  $_.'AppSharing Poor Due To SpoiledTilePercentTotal Count' -ne 'NaN' -and $_.'AppSharing Poor Due To SpoiledTilePercentTotal' -eq 'TRUE' }
        $AppSharingPoorDueToSpoiledTilePercentTotalCount =($AppSharingPoorDueToSpoiledTilePercentTotalCountlist | Measure-Object "AppSharing Poor Due To SpoiledTilePercentTotal Count" -Sum | select Sum).Sum
        if($AppSharingPoorDueToSpoiledTilePercentTotalCount){
            $list=$AppSharingPoorDueToSpoiledTilePercentTotalCountlist | where-object {$_.'AppSharing Poor Due To SpoiledTilePercentTotal Count' -gt 0.0001 } | Sort-Object { $_."AppSharing Poor Due To SpoiledTilePercentTotal Count" -as [int] } -Descending | select -First 10
            foreach($in in $list){
                $ltimArr=Get-LocalTime -dat $in.Date -hr $in.Hour
                Write-Host 'ddAppSharingPoorDueToSpoiledTilePercentTotalCount#' $ltimArr[0] ~!~ $ltimArr[1] ~!~ $in.'First UPN' ~!~ $in.'Second UPN' ~!~ $in.'First IP Address' ~!~ $in.'Second IP Address' ~!~ $in.'Conference Id'  ~!~ $in.'AppSharing Poor Due To SpoiledTilePercentTotal Count'
            }
            $list=$null
        }
        else{ 
            $AppSharingPoorDueToSpoiledTilePercentTotalCount=0 
        }
        $AppSharingPoorDueToSpoiledTilePercentTotalCountlist=0

        $AppSharingPoorDueToRelativeOneWayAverageCountlist =$AppShrngStrmsOutput  | where-object { -not [string]::IsNullOrEmpty($_.'AppSharing Poor Due To RelativeOneWayAverage Count')  -and  $_.'AppSharing Poor Due To RelativeOneWayAverage Count' -ne 'NaN' -and $_.'AppSharing Poor Due To RelativeOneWayAverage' -eq 'TRUE'} 
        $AppSharingPoorDueToRelativeOneWayAverageCount =($AppSharingPoorDueToRelativeOneWayAverageCountlist | Measure-Object "AppSharing Poor Due To RelativeOneWayAverage Count" -Sum | select Sum).Sum
        if($AppSharingPoorDueToRelativeOneWayAverageCount){
            $list=$AppSharingPoorDueToRelativeOneWayAverageCountlist | where-object {$_.'AppSharing Poor Due To RelativeOneWayAverage Count' -gt 0.0001 } | Sort-Object { $_."AppSharing Poor Due To RelativeOneWayAverage Count" -as [int] } -Descending | select -First 10
            foreach($in in $list){
                $ltimArr=Get-LocalTime -dat $in.Date -hr $in.Hour
                Write-Host 'ddAppSharingPoorDueToRelativeOneWayAverageCount#' $ltimArr[0] ~!~ $ltimArr[1] ~!~ $in.'First UPN' ~!~ $in.'Second UPN' ~!~ $in.'First IP Address' ~!~ $in.'Second IP Address' ~!~ $in.'Conference Id' ~!~ $in.'AppSharing Poor Due To RelativeOneWayAverage Count'
            }
            $list=$null
        }
        else{ 
            $AppSharingPoorDueToRelativeOneWayAverageCount=0
        }
        $AppSharingPoorDueToRelativeOneWayAverageCountlist=$null

        $AppSharingPoorDueToRDPTileProcessingLatencyAverageCountlist =$AppShrngStrmsOutput  | where-object { -not [string]::IsNullOrEmpty($_.'AppSharing Poor Due To RDPTileProcessingLatencyAverage Count')  -and  $_.'AppSharing Poor Due To RDPTileProcessingLatencyAverage Count' -ne 'NaN' -and $_.'AppSharing Poor Due To RDPTileProcessingLatencyAverage' -eq 'TRUE' } 
        $AppSharingPoorDueToRDPTileProcessingLatencyAverageCount = ($AppSharingPoorDueToRDPTileProcessingLatencyAverageCountlist| Measure-Object "AppSharing Poor Due To RDPTileProcessingLatencyAverage Count" -Sum | select Sum).Sum
        if($AppSharingPoorDueToRDPTileProcessingLatencyAverageCount){
            $list=$AppSharingPoorDueToRDPTileProcessingLatencyAverageCountlist | where-object {$_.'AppSharing Poor Due To RDPTileProcessingLatencyAverage Count' -gt 0.0001 }  | Sort-Object { $_."AppSharing Poor Due To RDPTileProcessingLatencyAverage Count" -as [int] } -Descending | select -First 10
            foreach($in in $list){
                $ltimArr=Get-LocalTime -dat $in.Date -hr $in.Hour
                Write-Host 'ddAppSharingPoorDueToRDPTileProcessingLatencyAverageCount#' $ltimArr[0] ~!~ $ltimArr[1] ~!~ $in.'First UPN' ~!~ $in.'Second UPN' ~!~ $in.'First IP Address' ~!~ $in.'Second IP Address' ~!~ $in.'Conference Id'  ~!~ $in.'AppSharing Poor Due To RDPTileProcessingLatencyAverage Count'
            }
            $list=$null
        }
        else{ 
            $AppSharingPoorDueToRDPTileProcessingLatencyAverageCount=0 
        }
        $AppSharingPoorDueToRDPTileProcessingLatencyAverageCountlist=$null

        $AppSharingPoorStreamCountlist =$AppShrngStrmsOutput  | where-object { -not [string]::IsNullOrEmpty($_.'AppSharing Poor Stream Count')  -and  $_.'AppSharing Poor Stream Count' -ne 'NaN' -and $_.'ClassifiedPoorCall' -eq 'TRUE' } 
        $AppSharingPoorStreamCount = ($AppSharingPoorStreamCountlist | Measure-Object "AppSharing Poor Stream Count" -Sum | select Sum).Sum
        if($AppSharingPoorStreamCount){
            $list=$AppSharingPoorStreamCountlist | where-object {$_.'AppSharing Poor Stream Count' -gt 0.0001} | Sort-Object { $_."AppSharing Poor Stream Count" -as [int] } -Descending  | select -First 10
            foreach($in in $list){
                $ltimArr=Get-LocalTime -dat $in.Date -hr $in.Hour
                Write-Host 'ddAppSharingPoorStreamCount#' $ltimArr[0] ~!~ $ltimArr[1] ~!~ $in.'First UPN' ~!~ $in.'Second UPN' ~!~ $in.'First IP Address' ~!~ $in.'Second IP Address' ~!~ $in.'Conference Id' ~!~ $in.'AppSharing Poor Stream Count'
            }
            $list=$null
        }
        else{ 
            $AppSharingPoorStreamCount=0
        }
        $AppSharingPoorStreamCountlist=$null

        $AppSharingGoodStreamCountlist =$AppShrngStrmsOutput  | where-object { -not [string]::IsNullOrEmpty($_.'AppSharing Good Stream Count')  -and  $_.'AppSharing Good Stream Count' -ne 'NaN' } 
        $AppSharingGoodStreamCount = ($AppSharingGoodStreamCountlist | Measure-Object "AppSharing Good Stream Count" -Sum | select Sum).Sum
        if(-not $AppSharingGoodStreamCount){
            $AppSharingGoodStreamCount =0
        }
        $AppSharingGoodStreamCountlist=$null

        $AppSharingUnclassifiedStreamCountlist =$AppShrngStrmsOutput  | where-object { -not [string]::IsNullOrEmpty($_.'AppSharing Unclassified Stream Count')  -and  $_.'AppSharing Unclassified Stream Count' -ne 'NaN' } 
        $AppSharingUnclassifiedStreamCount =($AppSharingUnclassifiedStreamCountlist | Measure-Object "AppSharing Unclassified Stream Count" -Sum | select Sum).Sum
        if(-not $AppSharingUnclassifiedStreamCount){
            $AppSharingUnclassifiedStreamCount =0
        } 
        $AppSharingUnclassifiedStreamCountlist=$null

        write-host '*********** AppSharingPoorPercentage measure **************'
        #$AppSharingPoorPercentagelist =$AppShrngStrmsOutput  | where-object { -not [string]::IsNullOrEmpty($_.'AppSharing Poor Percentage')  -and  $_.'AppSharing Poor Percentage' -ne 'NaN' -and $_.'AppSharing Poor Percentage' -gt 0.0001} 
        #$AppSharingPoorPercentage = ($AppSharingPoorPercentagelist | Measure-Object "AppSharing Poor Percentage" -Average | select Average).Average
        $AppSharingPoorPercentage = ($AppSharingPoorStreamCount/$AppSharingStreamCount)*100
        if(-not $AppSharingPoorPercentage) { $AppSharingPoorPercentage =0 } else { $AppSharingPoorPercentage=$AppSharingPoorPercentage.ToString("#.##") }
        $AppSharingPoorPercentagelist=$null

        $AvgAppSharingSpoiledTilePercentTotallist =$AppShrngStrmsOutput  | where-object { -not [string]::IsNullOrEmpty($_.'Avg AppSharing Spoiled Tile Percent Total')  -and  $_.'Avg AppSharing Spoiled Tile Percent Total' -ne 'NaN' -and $_.'Avg AppSharing Spoiled Tile Percent Total' -gt 0.0001 } 
        $AvgAppSharingSpoiledTilePercentTotal = ($AvgAppSharingSpoiledTilePercentTotallist | Measure-Object "Avg AppSharing Spoiled Tile Percent Total" -Average | select Average).Average
        if( -not $AvgAppSharingSpoiledTilePercentTotal) { $AvgAppSharingSpoiledTilePercentTotal=0 } else { $AvgAppSharingSpoiledTilePercentTotal=$AvgAppSharingSpoiledTilePercentTotal.ToString("#.##") }
        $AvgAppSharingSpoiledTilePercentTotallist=$null

        $AvgAppSharingRDPTileProcessingLatencylist =$AppShrngStrmsOutput  | where-object { -not [string]::IsNullOrEmpty($_.'Avg AppSharing RDP Tile Processing Latency')  -and  $_.'Avg AppSharing RDP Tile Processing Latency' -ne 'NaN' -and $_.'Avg AppSharing RDP Tile Processing Latency' -gt 0.0001 } 
        $AvgAppSharingRDPTileProcessingLatency = ($AvgAppSharingRDPTileProcessingLatencylist | Measure-Object "Avg AppSharing RDP Tile Processing Latency" -Average | select Average).Average
        if( -not $AvgAppSharingRDPTileProcessingLatency) { $AvgAppSharingRDPTileProcessingLatency=0 }  else { $AvgAppSharingRDPTileProcessingLatency=$AvgAppSharingRDPTileProcessingLatency.ToString("#.##") }
        $AvgAppSharingRDPTileProcessingLatencylist=0

        $AvgRelativeOneWaylist =$AppShrngStrmsOutput | where-object { -not [string]::IsNullOrEmpty($_.'Avg Relative OneWay')  -and  $_.'Avg Relative OneWay' -ne 'NaN' -and $_.'Avg Relative OneWay' -gt 0.0001 }
        $AvgRelativeOneWay = ($AvgRelativeOneWaylist  | Measure-Object "Avg Relative OneWay" -Average | select Average).Average
        if(-not $AvgRelativeOneWay){ $AvgRelativeOneWay =0 }  else { $AvgRelativeOneWay=$AvgRelativeOneWay.ToString("#.##") }
        $AvgRelativeOneWaylist=$null

        $AvgRelativeOneWayMaxlist =$AppShrngStrmsOutput | where-object { -not [string]::IsNullOrEmpty($_.'Avg Relative OneWay Max')  -and  $_.'Avg Relative OneWay Max' -ne 'NaN' -and $_.'Avg Relative OneWay Max' -gt 0.0001 } 
        $AvgRelativeOneWayMax = ($AvgRelativeOneWayMaxlist | Measure-Object "Avg Relative OneWay Max" -Average | select Average).Average
        if( -not $AvgRelativeOneWayMax ){ $AvgRelativeOneWayMax =0 } else { $AvgRelativeOneWayMax=$AvgRelativeOneWayMax.ToString("#.##") }
        $AvgRelativeOneWayMaxlist=$null

        Write-Host 'measures##' $AppSharingStreamCount ~ $AppSharingPoorDueToSpoiledTilePercentTotalCount ~ $AppSharingPoorDueToRelativeOneWayAverageCount ~ $AppSharingPoorDueToRDPTileProcessingLatencyAverageCount ~ $AppSharingPoorStreamCount ~ $AppSharingGoodStreamCount ~ $AppSharingUnclassifiedStreamCount ~ $AppSharingPoorPercentage ~ $AvgAppSharingSpoiledTilePercentTotal ~ $AvgAppSharingRDPTileProcessingLatency ~ $AvgRelativeOneWay ~ $AvgRelativeOneWayMax 
    }
}

# SIG # Begin signature block
# MIIcdAYJKoZIhvcNAQcCoIIcZTCCHGECAQExCzAJBgUrDgMCGgUAMGkGCisGAQQB
# gjcCAQSgWzBZMDQGCisGAQQBgjcCAR4wJgIDAQAABBAfzDtgWUsITrck0sYpfvNR
# AgEAAgEAAgEAAgEAAgEAMCEwCQYFKw4DAhoFAAQUyeN8/c2w5DBuJ6d7ZlKukt1Q
# v4SggherMIIFMDCCBBigAwIBAgIQBAkYG1/Vu2Z1U0O1b5VQCDANBgkqhkiG9w0B
# AQsFADBlMQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYD
# VQQLExB3d3cuZGlnaWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVk
# IElEIFJvb3QgQ0EwHhcNMTMxMDIyMTIwMDAwWhcNMjgxMDIyMTIwMDAwWjByMQsw
# CQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cu
# ZGlnaWNlcnQuY29tMTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQg
# Q29kZSBTaWduaW5nIENBMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA
# +NOzHH8OEa9ndwfTCzFJGc/Q+0WZsTrbRPV/5aid2zLXcep2nQUut4/6kkPApfmJ
# 1DcZ17aq8JyGpdglrA55KDp+6dFn08b7KSfH03sjlOSRI5aQd4L5oYQjZhJUM1B0
# sSgmuyRpwsJS8hRniolF1C2ho+mILCCVrhxKhwjfDPXiTWAYvqrEsq5wMWYzcT6s
# cKKrzn/pfMuSoeU7MRzP6vIK5Fe7SrXpdOYr/mzLfnQ5Ng2Q7+S1TqSp6moKq4Tz
# rGdOtcT3jNEgJSPrCGQ+UpbB8g8S9MWOD8Gi6CxR93O8vYWxYoNzQYIH5DiLanMg
# 0A9kczyen6Yzqf0Z3yWT0QIDAQABo4IBzTCCAckwEgYDVR0TAQH/BAgwBgEB/wIB
# ADAOBgNVHQ8BAf8EBAMCAYYwEwYDVR0lBAwwCgYIKwYBBQUHAwMweQYIKwYBBQUH
# AQEEbTBrMCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wQwYI
# KwYBBQUHMAKGN2h0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFz
# c3VyZWRJRFJvb3RDQS5jcnQwgYEGA1UdHwR6MHgwOqA4oDaGNGh0dHA6Ly9jcmw0
# LmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJRFJvb3RDQS5jcmwwOqA4oDaG
# NGh0dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJRFJvb3RD
# QS5jcmwwTwYDVR0gBEgwRjA4BgpghkgBhv1sAAIEMCowKAYIKwYBBQUHAgEWHGh0
# dHBzOi8vd3d3LmRpZ2ljZXJ0LmNvbS9DUFMwCgYIYIZIAYb9bAMwHQYDVR0OBBYE
# FFrEuXsqCqOl6nEDwGD5LfZldQ5YMB8GA1UdIwQYMBaAFEXroq/0ksuCMS1Ri6en
# IZ3zbcgPMA0GCSqGSIb3DQEBCwUAA4IBAQA+7A1aJLPzItEVyCx8JSl2qB1dHC06
# GsTvMGHXfgtg/cM9D8Svi/3vKt8gVTew4fbRknUPUbRupY5a4l4kgU4QpO4/cY5j
# DhNLrddfRHnzNhQGivecRk5c/5CxGwcOkRX7uq+1UcKNJK4kxscnKqEpKBo6cSgC
# PC6Ro8AlEeKcFEehemhor5unXCBc2XGxDI+7qPjFEmifz0DLQESlE/DmZAwlCEIy
# sjaKJAL+L3J+HNdJRZboWR3p+nRka7LrZkPas7CM1ekN3fYBIM6ZMWM9CBoYs4Gb
# T8aTEAb8B4H6i9r5gkn3Ym6hU/oSlBiFLpKR6mhsRDKyZqHnGKSaZFHvMIIFNDCC
# BBygAwIBAgIQAuEYSxAWnqD3sU8D3BMzUjANBgkqhkiG9w0BAQsFADByMQswCQYD
# VQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGln
# aWNlcnQuY29tMTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQgQ29k
# ZSBTaWduaW5nIENBMB4XDTE4MDcxMDAwMDAwMFoXDTIxMDkxNTEyMDAwMFowcTEL
# MAkGA1UEBhMCVVMxEzARBgNVBAgTCk5ldyBKZXJzZXkxDzANBgNVBAcTBklzZWxp
# bjEdMBsGA1UEChMUZUcgSW5ub3ZhdGlvbnMsIEluYy4xHTAbBgNVBAMTFGVHIElu
# bm92YXRpb25zLCBJbmMuMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA
# oNt7XWB1y9xwtvCGO/XipXallOkZ3ScdXunWCONnBzryRdCj7C/WX9s1CU8KkjRP
# FjWW+BOXvvC4ZUqw0Ad2uJAXyBY2/lV9eaoTRFB6Kb2/tJzG3je7Vcu8MxGJlwzP
# QQrr6icEJeqAPFE7vmzThVbd9H1n5Zdmwx20WCFe2V9qyVYHt7/6GS7WB2CwwjT6
# iVmiKP8HZXgr3tHZeAEb7tdQqd5//9e+8Mp8anb8ZdNgC9PQjBmbrQ/wH3kV65gK
# L+5kbgRvIfsmYxXiU1IFkq4rSQ+tfsDtYqBhGfovef9Gt8ZTjx7S4fortxwR7tlz
# i+wLO5m8I9sm4I2ouyIOQQIDAQABo4IBxTCCAcEwHwYDVR0jBBgwFoAUWsS5eyoK
# o6XqcQPAYPkt9mV1DlgwHQYDVR0OBBYEFD3yRqdsw6UIddfMPwhUMv2AaGRAMA4G
# A1UdDwEB/wQEAwIHgDATBgNVHSUEDDAKBggrBgEFBQcDAzB3BgNVHR8EcDBuMDWg
# M6Axhi9odHRwOi8vY3JsMy5kaWdpY2VydC5jb20vc2hhMi1hc3N1cmVkLWNzLWcx
# LmNybDA1oDOgMYYvaHR0cDovL2NybDQuZGlnaWNlcnQuY29tL3NoYTItYXNzdXJl
# ZC1jcy1nMS5jcmwwTAYDVR0gBEUwQzA3BglghkgBhv1sAwEwKjAoBggrBgEFBQcC
# ARYcaHR0cHM6Ly93d3cuZGlnaWNlcnQuY29tL0NQUzAIBgZngQwBBAEwgYQGCCsG
# AQUFBwEBBHgwdjAkBggrBgEFBQcwAYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29t
# ME4GCCsGAQUFBzAChkJodHRwOi8vY2FjZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNl
# cnRTSEEyQXNzdXJlZElEQ29kZVNpZ25pbmdDQS5jcnQwDAYDVR0TAQH/BAIwADAN
# BgkqhkiG9w0BAQsFAAOCAQEAP1QnJ6TEczaeGxVokMinsKam1mJB+zDk4B9rfm31
# iaZe9OeNvR/UJAs+5b0gKBZF9NmTVdayAYV74vZU5IElRo59q6hbg/20Wu87UyoE
# Yjwrv2DxHgl3z80piuLllmoe79vEu/bYvreBamzZmHlyxRP0us2KRfEsLBH23y1o
# zBATLc3yBu+mCfDg9E1RfhpKyD1iMHkbC90To6bpOlP9Pd6R4WEAFROILgm2bofQ
# ZhN4UNKbJ1uLCvV2NiUbU7+YSC3NP9SdphaDBiOnUWiK8MjTIPZbhh3QjI5f342q
# cUiR4LGx/Z/6pq4w6YHWd8c1czexD7xVCom7ZafCOKFWyzCCBmowggVSoAMCAQIC
# EAMBmgI6/1ixa9bV6uYX8GYwDQYJKoZIhvcNAQEFBQAwYjELMAkGA1UEBhMCVVMx
# FTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNv
# bTEhMB8GA1UEAxMYRGlnaUNlcnQgQXNzdXJlZCBJRCBDQS0xMB4XDTE0MTAyMjAw
# MDAwMFoXDTI0MTAyMjAwMDAwMFowRzELMAkGA1UEBhMCVVMxETAPBgNVBAoTCERp
# Z2lDZXJ0MSUwIwYDVQQDExxEaWdpQ2VydCBUaW1lc3RhbXAgUmVzcG9uZGVyMIIB
# IjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAo2Rd/Hyz4II14OD2xirmSXU7
# zG7gU6mfH2RZ5nxrf2uMnVX4kuOe1VpjWwJJUNmDzm9m7t3LhelfpfnUh3SIRDsZ
# yeX1kZ/GFDmsJOqoSyyRicxeKPRktlC39RKzc5YKZ6O+YZ+u8/0SeHUOplsU/UUj
# joZEVX0YhgWMVYd5SEb3yg6Np95OX+Koti1ZAmGIYXIYaLm4fO7m5zQvMXeBMB+7
# NgGN7yfj95rwTDFkjePr+hmHqH7P7IwMNlt6wXq4eMfJBi5GEMiN6ARg27xzdPpO
# 2P6qQPGyznBGg+naQKFZOtkVCVeZVjCT88lhzNAIzGvsYkKRrALA76TwiRGPdwID
# AQABo4IDNTCCAzEwDgYDVR0PAQH/BAQDAgeAMAwGA1UdEwEB/wQCMAAwFgYDVR0l
# AQH/BAwwCgYIKwYBBQUHAwgwggG/BgNVHSAEggG2MIIBsjCCAaEGCWCGSAGG/WwH
# ATCCAZIwKAYIKwYBBQUHAgEWHGh0dHBzOi8vd3d3LmRpZ2ljZXJ0LmNvbS9DUFMw
# ggFkBggrBgEFBQcCAjCCAVYeggFSAEEAbgB5ACAAdQBzAGUAIABvAGYAIAB0AGgA
# aQBzACAAQwBlAHIAdABpAGYAaQBjAGEAdABlACAAYwBvAG4AcwB0AGkAdAB1AHQA
# ZQBzACAAYQBjAGMAZQBwAHQAYQBuAGMAZQAgAG8AZgAgAHQAaABlACAARABpAGcA
# aQBDAGUAcgB0ACAAQwBQAC8AQwBQAFMAIABhAG4AZAAgAHQAaABlACAAUgBlAGwA
# eQBpAG4AZwAgAFAAYQByAHQAeQAgAEEAZwByAGUAZQBtAGUAbgB0ACAAdwBoAGkA
# YwBoACAAbABpAG0AaQB0ACAAbABpAGEAYgBpAGwAaQB0AHkAIABhAG4AZAAgAGEA
# cgBlACAAaQBuAGMAbwByAHAAbwByAGEAdABlAGQAIABoAGUAcgBlAGkAbgAgAGIA
# eQAgAHIAZQBmAGUAcgBlAG4AYwBlAC4wCwYJYIZIAYb9bAMVMB8GA1UdIwQYMBaA
# FBUAEisTmLKZB+0e36K+Vw0rZwLNMB0GA1UdDgQWBBRhWk0ktkkynUoqeRqDS/Qe
# icHKfTB9BgNVHR8EdjB0MDigNqA0hjJodHRwOi8vY3JsMy5kaWdpY2VydC5jb20v
# RGlnaUNlcnRBc3N1cmVkSURDQS0xLmNybDA4oDagNIYyaHR0cDovL2NybDQuZGln
# aWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJlZElEQ0EtMS5jcmwwdwYIKwYBBQUHAQEE
# azBpMCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wQQYIKwYB
# BQUHMAKGNWh0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3Vy
# ZWRJRENBLTEuY3J0MA0GCSqGSIb3DQEBBQUAA4IBAQCdJX4bM02yJoFcm4bOIyAP
# gIfliP//sdRqLDHtOhcZcRfNqRu8WhY5AJ3jbITkWkD73gYBjDf6m7GdJH7+IKRX
# rVu3mrBgJuppVyFdNC8fcbCDlBkFazWQEKB7l8f2P+fiEUGmvWLZ8Cc9OB0obzpS
# CfDscGLTYkuw4HOmksDTjjHYL+NtFxMG7uQDthSr849Dp3GdId0UyhVdkkHa+Q+B
# 0Zl0DSbEDn8btfWg8cZ3BigV6diT5VUW8LsKqxzbXEgnZsijiwoc5ZXarsQuWaBh
# 3drzbaJh6YoLbewSGL33VVRAA5Ira8JRwgpIr7DUbuD0FAo6G+OPPcqvao173NhE
# MIIGzTCCBbWgAwIBAgIQBv35A5YDreoACus/J7u6GzANBgkqhkiG9w0BAQUFADBl
# MQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3
# d3cuZGlnaWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVkIElEIFJv
# b3QgQ0EwHhcNMDYxMTEwMDAwMDAwWhcNMjExMTEwMDAwMDAwWjBiMQswCQYDVQQG
# EwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNl
# cnQuY29tMSEwHwYDVQQDExhEaWdpQ2VydCBBc3N1cmVkIElEIENBLTEwggEiMA0G
# CSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDogi2Z+crCQpWlgHNAcNKeVlRcqcTS
# QQaPyTP8TUWRXIGf7Syc+BZZ3561JBXCmLm0d0ncicQK2q/LXmvtrbBxMevPOkAM
# Rk2T7It6NggDqww0/hhJgv7HxzFIgHweog+SDlDJxofrNj/YMMP/pvf7os1vcyP+
# rFYFkPAyIRaJxnCI+QWXfaPHQ90C6Ds97bFBo+0/vtuVSMTuHrPyvAwrmdDGXRJC
# geGDboJzPyZLFJCuWWYKxI2+0s4Grq2Eb0iEm09AufFM8q+Y+/bOQF1c9qjxL6/s
# iSLyaxhlscFzrdfx2M8eCnRcQrhofrfVdwonVnwPYqQ/MhRglf0HBKIJAgMBAAGj
# ggN6MIIDdjAOBgNVHQ8BAf8EBAMCAYYwOwYDVR0lBDQwMgYIKwYBBQUHAwEGCCsG
# AQUFBwMCBggrBgEFBQcDAwYIKwYBBQUHAwQGCCsGAQUFBwMIMIIB0gYDVR0gBIIB
# yTCCAcUwggG0BgpghkgBhv1sAAEEMIIBpDA6BggrBgEFBQcCARYuaHR0cDovL3d3
# dy5kaWdpY2VydC5jb20vc3NsLWNwcy1yZXBvc2l0b3J5Lmh0bTCCAWQGCCsGAQUF
# BwICMIIBVh6CAVIAQQBuAHkAIAB1AHMAZQAgAG8AZgAgAHQAaABpAHMAIABDAGUA
# cgB0AGkAZgBpAGMAYQB0AGUAIABjAG8AbgBzAHQAaQB0AHUAdABlAHMAIABhAGMA
# YwBlAHAAdABhAG4AYwBlACAAbwBmACAAdABoAGUAIABEAGkAZwBpAEMAZQByAHQA
# IABDAFAALwBDAFAAUwAgAGEAbgBkACAAdABoAGUAIABSAGUAbAB5AGkAbgBnACAA
# UABhAHIAdAB5ACAAQQBnAHIAZQBlAG0AZQBuAHQAIAB3AGgAaQBjAGgAIABsAGkA
# bQBpAHQAIABsAGkAYQBiAGkAbABpAHQAeQAgAGEAbgBkACAAYQByAGUAIABpAG4A
# YwBvAHIAcABvAHIAYQB0AGUAZAAgAGgAZQByAGUAaQBuACAAYgB5ACAAcgBlAGYA
# ZQByAGUAbgBjAGUALjALBglghkgBhv1sAxUwEgYDVR0TAQH/BAgwBgEB/wIBADB5
# BggrBgEFBQcBAQRtMGswJAYIKwYBBQUHMAGGGGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0
# LmNvbTBDBggrBgEFBQcwAoY3aHR0cDovL2NhY2VydHMuZGlnaWNlcnQuY29tL0Rp
# Z2lDZXJ0QXNzdXJlZElEUm9vdENBLmNydDCBgQYDVR0fBHoweDA6oDigNoY0aHR0
# cDovL2NybDMuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJlZElEUm9vdENBLmNy
# bDA6oDigNoY0aHR0cDovL2NybDQuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJl
# ZElEUm9vdENBLmNybDAdBgNVHQ4EFgQUFQASKxOYspkH7R7for5XDStnAs0wHwYD
# VR0jBBgwFoAUReuir/SSy4IxLVGLp6chnfNtyA8wDQYJKoZIhvcNAQEFBQADggEB
# AEZQPsm3KCSnOB22WymvUs9S6TFHq1Zce9UNC0Gz7+x1H3Q48rJcYaKclcNQ5IK5
# I9G6OoZyrTh4rHVdFxc0ckeFlFbR67s2hHfMJKXzBBlVqefj56tizfuLLZDCwNK1
# lL1eT7EF0g49GqkUW6aGMWKoqDPkmzmnxPXOHXh2lCVz5Cqrz5x2S+1fwksW5Etw
# TACJHvzFebxMElf+X+EevAJdqP77BzhPDcZdkbkPZ0XN1oPt55INjbFpjE/7WeAj
# D9KqrgB87pxCDs+R1ye3Fu4Pw718CqDuLAhVhSK46xgaTfwqIa1JMYNHlXdx3LEb
# S0scEJx3FMGdTy9alQgpECYxggQzMIIELwIBATCBhjByMQswCQYDVQQGEwJVUzEV
# MBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNlcnQuY29t
# MTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQgQ29kZSBTaWduaW5n
# IENBAhAC4RhLEBaeoPexTwPcEzNSMAkGBSsOAwIaBQCgcDAQBgorBgEEAYI3AgEM
# MQIwADAZBgkqhkiG9w0BCQMxDAYKKwYBBAGCNwIBBDAcBgorBgEEAYI3AgELMQ4w
# DAYKKwYBBAGCNwIBFTAjBgkqhkiG9w0BCQQxFgQUwDnoBtUFsJ6kzFoh64u2cnGM
# XcgwDQYJKoZIhvcNAQEBBQAEggEAh6iLhK2A4tZbXcrb7h9dbu+LQ4qS2v+jHs0G
# C4Rp+yN2NkT0fAutISYkKnh85klyaBYhdBYRvpQ8ST+suf7sP9l8tGMkJpaJU1x5
# +HopZ+g/dfxP9Pe1xd8OkIx6wFkgHUWoX+mHD3QLF0OOraeOA8601N2hF0wtSS4a
# mNSlFyZdv3ZG+NSGM4kdCbniKkkAu1apwzE8fmVVLGVX44QxtQvmnU37WqYXH04P
# OubprSpMHZIwMr/K2EQ2vvVgJUBqG672mZAFegi34wgPMG6h1P4aTS69hb+0KDtV
# qI2vfBcV/PxPhik1dk8v//MQJJ+9mjJ4db1Iu3RL+vQ9pMqEt6GCAg8wggILBgkq
# hkiG9w0BCQYxggH8MIIB+AIBATB2MGIxCzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxE
# aWdpQ2VydCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5jb20xITAfBgNVBAMT
# GERpZ2lDZXJ0IEFzc3VyZWQgSUQgQ0EtMQIQAwGaAjr/WLFr1tXq5hfwZjAJBgUr
# DgMCGgUAoF0wGAYJKoZIhvcNAQkDMQsGCSqGSIb3DQEHATAcBgkqhkiG9w0BCQUx
# DxcNMjAwNzIzMDIwNDAxWjAjBgkqhkiG9w0BCQQxFgQUa94VZfDjVGg9OyVXbuGk
# QbhUhbgwDQYJKoZIhvcNAQEBBQAEggEAcbXZ3TJAZCo+E/5j4Z2OIq6mk4baEfoi
# uj/BMlWD2W8GNLZo7Ri/bq6595d2ycTuBlr0ntcHLUVPHraHhoVSVonwCGAlNFd4
# Nb15BTgl8fsAeodG550OT5hOGnispST+2RccvM2KZfAQgTQ1m3d0bHd1jP2TUXt6
# +eZJg9OnJZYP+iy5HqY5IHBUIxCVo0CV8nIFYBBV8mIzk+m03xMYzv4jQw9wzxrG
# oI7Ol5MG4xZ2exu0Dy5TPECwq7nHSHyAe4dEPpNE4sr20oqeqWN0c/kPrvpdpIDl
# HF+wVFY33+bwKFZKM69DZXgvv9ugO9dMLo6/+bo+guLu3xJLSd5ToA==
# SIG # End signature block
