/*
 * Decompiled with CFR 0.152.
 */
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.TimeZone;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

public class CtxCloudHelper {
    public static final String accessTokenURL = "https://trust.citrixworkspacesapi.net/root/tokens/clients";
    public static final String authenticateURL = "https://trust.citrixworkspacesapi.net";
    public static final String coreURL = "https://core.citrixworkspacesapi.net";
    public static final String cwsURL = "https://cws.citrixworkspacesapi.net";
    public static Hashtable allServiceHash = new Hashtable();
    public static Hashtable xenDesktopLicenseExpiryHash = new Hashtable();
    public static Hashtable providerLocationHash = new Hashtable();
    public static Hashtable providerLocationTimeHash = new Hashtable();
    private static final long providerCachePeriod = 300000L;
    public static Hashtable resourceLocationHash = new Hashtable();
    public static Hashtable resourceLocationTimeHash = new Hashtable();
    private static final long resourceCachePeriod = 300000L;
    private String customerId = null;
    private String clientId = null;
    private String clientSecret = null;
    private RequestConfig requestConfig = null;
    private static final int timeout = 30000;

    public CtxCloudHelper(String string, String string2) {
        this.setClientInfo(string, string2);
        this.requestConfig = RequestConfig.custom().setConnectionRequestTimeout(30000).setConnectTimeout(30000).setSocketTimeout(30000).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setClientInfo(String string, String string2) {
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        int n = 0;
        FileReader fileReader = null;
        BufferedReader bufferedReader = null;
        File file = new File(string2);
        if (file != null && file.exists() && file.isFile()) {
            try {
                fileReader = new FileReader(string2);
                bufferedReader = new BufferedReader(fileReader);
                while ((string6 = bufferedReader.readLine()) != null) {
                    if (n == 0) {
                        ++n;
                        continue;
                    }
                    StringTokenizer stringTokenizer = new StringTokenizer(string6 = string6.trim(), ",");
                    int n2 = stringTokenizer.countTokens();
                    if (n2 < 3) continue;
                    string3 = stringTokenizer.nextToken();
                    string4 = stringTokenizer.nextToken();
                    string5 = stringTokenizer.nextToken();
                    if (string3.startsWith("\"") && string3.endsWith("\"")) {
                        string3 = string3.substring(1, string3.length() - 1);
                    }
                    if (string4.startsWith("\"") && string4.endsWith("\"")) {
                        string4 = string4.substring(1, string4.length() - 1);
                    }
                    if (!string5.startsWith("\"") || !string5.endsWith("\"")) continue;
                    string5 = string5.substring(1, string5.length() - 1);
                }
            }
            catch (Exception exception) {
            }
            finally {
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                    if (fileReader != null) {
                        fileReader.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        if (string4 != null && string4.trim().length() > 0 && string5 != null && string5.trim().length() > 0) {
            this.customerId = string;
            this.clientId = string4;
            this.clientSecret = string5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getAccessToken() {
        String string = null;
        CloseableHttpClient closeableHttpClient = null;
        CloseableHttpResponse closeableHttpResponse = null;
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        StringBuffer stringBuffer = null;
        try {
            if (this.clientId == null || this.clientId.trim().length() == 0 || this.clientSecret == null || this.clientSecret.trim().length() == 0) {
                String string2 = string;
                return string2;
            }
            String string3 = "{\"ClientId\":\"" + this.clientId + "\",\"ClientSecret\":\"" + this.clientSecret + "\"}";
            StringEntity stringEntity = new StringEntity(string3);
            closeableHttpClient = HttpClients.createDefault();
            HttpPost httpPost = new HttpPost(accessTokenURL);
            httpPost.setHeader("Accept", "application/json");
            httpPost.setHeader("Content-type", "application/json");
            httpPost.setEntity((HttpEntity)stringEntity);
            httpPost.setConfig(this.requestConfig);
            closeableHttpResponse = closeableHttpClient.execute((HttpUriRequest)httpPost);
            if (closeableHttpResponse == null) return string;
            if (closeableHttpResponse.getStatusLine().getStatusCode() != 200) {
                String string4 = closeableHttpResponse.getStatusLine().toString();
                System.out.println("[CtxCloudHelper] getAccessToken statusLine is " + string4);
                System.err.println("[CtxCloudHelper] getAccessToken statusLine is " + string4);
                String string5 = string;
                return string5;
            }
            inputStreamReader = new InputStreamReader(closeableHttpResponse.getEntity().getContent());
            bufferedReader = new BufferedReader(inputStreamReader);
            stringBuffer = new StringBuffer();
            String string6 = "";
            while ((string6 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string6);
            }
            JsonParser jsonParser = new JsonParser();
            JsonObject jsonObject = (JsonObject)jsonParser.parse(stringBuffer.toString());
            if (jsonObject == null) return string;
            if (!jsonObject.has("token")) return string;
            string = jsonObject.get("token").toString();
            return string;
        }
        catch (Exception exception) {
            string = null;
            System.out.println("[CtxCloudHelper] Exception occured while calling the getAccessToken method " + exception);
            exception.printStackTrace();
            return string;
        }
        finally {
            try {
                if (closeableHttpResponse != null) {
                    closeableHttpResponse.close();
                }
                if (closeableHttpClient != null) {
                    closeableHttpClient = null;
                }
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                if (inputStreamReader != null) {
                    inputStreamReader.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAuthenticate(String string) {
        boolean bl = false;
        if (string == null || string.trim().length() == 0) {
            return bl;
        }
        CloseableHttpClient closeableHttpClient = null;
        CloseableHttpResponse closeableHttpResponse = null;
        try {
            String string2 = "CWSAuth bearer=" + string;
            closeableHttpClient = HttpClients.createDefault();
            HttpPost httpPost = new HttpPost(authenticateURL);
            httpPost.setHeader("Customer", this.customerId);
            httpPost.setHeader("Authorization", string2);
            httpPost.setConfig(this.requestConfig);
            closeableHttpResponse = closeableHttpClient.execute((HttpUriRequest)httpPost);
            if (closeableHttpResponse != null) {
                if (closeableHttpResponse.getStatusLine().getStatusCode() != 200) {
                    String string3 = closeableHttpResponse.getStatusLine().toString();
                    System.out.println("[CtxCloudHelper] isAuthenticate statusLine is " + string3);
                    System.err.println("[CtxCloudHelper] isAuthenticate statusLine is " + string3);
                    boolean bl2 = bl;
                    return bl2;
                }
                bl = true;
            }
        }
        catch (Exception exception) {
            bl = false;
            System.out.println("[CtxCloudHelper] Exception occured while calling the isAuthenticate method " + exception);
            exception.printStackTrace();
        }
        finally {
            try {
                if (closeableHttpResponse != null) {
                    closeableHttpResponse.close();
                }
                if (closeableHttpClient != null) {
                    closeableHttpClient = null;
                }
            }
            catch (Exception exception) {}
        }
        return bl;
    }

    public Hashtable getSubscribedServices(String string) {
        Hashtable hashtable;
        block13: {
            String string2 = "https://core.citrixworkspacesapi.net/" + this.customerId + "/serviceStates";
            hashtable = new Hashtable();
            try {
                String string3 = this.getJsonString(string2, string);
                if (string3 == null || string3.trim().length() == 0) {
                    return hashtable;
                }
                ArrayList<String> arrayList = new ArrayList<String>();
                String string4 = "";
                String string5 = "";
                String string6 = "";
                String string7 = "";
                String string8 = "";
                String string9 = "";
                JsonArray jsonArray = null;
                JsonParser jsonParser = new JsonParser();
                JsonObject jsonObject = (JsonObject)jsonParser.parse(string3.trim());
                if (jsonObject == null || !jsonObject.has("items") || (jsonArray = (JsonArray)jsonObject.get("items")) == null || jsonArray.size() <= 0) break block13;
                int n = jsonArray.size();
                for (int i = 0; i < n; ++i) {
                    JsonObject jsonObject2 = (JsonObject)jsonArray.get(i);
                    if (jsonObject2 == null) continue;
                    if (jsonObject2.has("serviceName")) {
                        string4 = jsonObject2.get("serviceName").toString();
                    }
                    if (jsonObject2.has("state")) {
                        string6 = jsonObject2.get("state").toString();
                    }
                    if (jsonObject2.has("type")) {
                        string7 = jsonObject2.get("type").toString();
                    }
                    if (jsonObject2.has("quantity")) {
                        string8 = jsonObject2.get("quantity").toString();
                    }
                    if (jsonObject2.has("daysToExpiration")) {
                        string9 = jsonObject2.get("daysToExpiration").toString();
                    }
                    if (string4 == null || string4.trim().length() == 0) continue;
                    string5 = (String)allServiceHash.get(string4 = CtxCloudHelper.replace(string4.trim(), "\"", ""));
                    if (string5 != null && string5.trim().length() > 0) {
                        string4 = string5;
                    }
                    if ((string6 = this.getValueOfString(string6)).equalsIgnoreCase("NotOnboarded") || string6.equalsIgnoreCase("Default")) continue;
                    string7 = this.getValueOfString(string7);
                    string8 = this.getValueOfString(string8, true);
                    string9 = this.getValueOfString(string9, true);
                    long l = -1L;
                    if (string4.equalsIgnoreCase("Virtual Apps and Desktops")) {
                        try {
                            l = Long.parseLong(string9.trim());
                        }
                        catch (Exception exception) {
                            l = -1L;
                        }
                    }
                    xenDesktopLicenseExpiryHash.put(this.customerId, new Long(l));
                    arrayList = new ArrayList();
                    arrayList.add(string4);
                    arrayList.add(string6);
                    arrayList.add(string7);
                    arrayList.add(string8);
                    arrayList.add(string9);
                    hashtable.put(string4, arrayList);
                }
            }
            catch (Exception exception) {
                System.out.println("[CtxCloudHelper] Exception occured while calling the getSubscribedServices method " + exception);
                exception.printStackTrace();
            }
        }
        return hashtable;
    }

    public ArrayList getOpenTickets(String string) {
        String string2 = "https://cws.citrixworkspacesapi.net/" + this.customerId + "/servicerequests?status=open";
        ArrayList arrayList = new ArrayList();
        try {
            String string3 = this.getJsonString(string2, string);
            if (string3 == null || string3.trim().length() == 0) {
                return arrayList;
            }
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            String string4 = "";
            String string5 = "";
            String string6 = "";
            String string7 = "";
            String string8 = "";
            String string9 = "";
            String string10 = "";
            JsonArray jsonArray = null;
            JsonParser jsonParser = new JsonParser();
            JsonObject jsonObject = (JsonObject)jsonParser.parse(string3.trim());
            if (jsonObject != null && jsonObject.has("result") && (jsonArray = (JsonArray)jsonObject.get("result")) != null && jsonArray.size() > 0) {
                int n = jsonArray.size();
                for (int i = 0; i < n; ++i) {
                    JsonObject jsonObject2 = (JsonObject)jsonArray.get(i);
                    if (jsonObject2 == null) continue;
                    if (jsonObject2.has("caseNumber")) {
                        string4 = jsonObject2.get("caseNumber").toString();
                    }
                    if (jsonObject2.has("status")) {
                        string5 = jsonObject2.get("status").toString();
                    }
                    if (jsonObject2.has("subject")) {
                        string6 = jsonObject2.get("subject").toString();
                    }
                    if (jsonObject2.has("email")) {
                        string7 = jsonObject2.get("email").toString();
                    }
                    if (jsonObject2.has("dateOpened")) {
                        string8 = jsonObject2.get("dateOpened").toString();
                    }
                    if (jsonObject2.has("lastUpdated")) {
                        string9 = jsonObject2.get("lastUpdated").toString();
                    }
                    if (jsonObject2.has("serviceProduct")) {
                        string10 = jsonObject2.get("serviceProduct").toString();
                    }
                    string4 = this.getValueOfString(string4);
                    string5 = this.getValueOfString(string5);
                    string6 = this.getValueOfString(string6);
                    string7 = this.getValueOfString(string7);
                    string8 = this.getValueOfString(string8);
                    string9 = this.getValueOfString(string9);
                    string10 = this.getValueOfString(string10);
                    long l = this.getTime(string8, false);
                    long l2 = this.getTime(string9, false);
                    arrayList2 = new ArrayList();
                    arrayList2.add(string4);
                    arrayList2.add(string5);
                    arrayList2.add(string6);
                    arrayList2.add(string7);
                    arrayList2.add(new Long(l));
                    arrayList2.add(new Long(l2));
                    arrayList2.add(string10);
                    arrayList.add(arrayList2);
                }
            }
        }
        catch (Exception exception) {
            System.out.println("[CtxCloudHelper] Exception occured while calling the getOpenTickets method " + exception);
            exception.printStackTrace();
        }
        return arrayList;
    }

    public String getProviderLocation(String string) {
        long l;
        long l2;
        long l3;
        Object object;
        String string2 = "https://cws.citrixworkspacesapi.net/" + this.customerId + "/resourceproviders";
        String string3 = null;
        boolean bl = true;
        string3 = (String)providerLocationHash.get(this.customerId);
        if (string3 != null && string3.trim().length() > 0 && (object = (Long)providerLocationTimeHash.get(this.customerId)) != null && (l3 = (l2 = System.currentTimeMillis()) - (l = ((Long)object).longValue())) < 300000L) {
            return string3;
        }
        try {
            object = this.getJsonString(string2, string);
            if (object == null || ((String)object).trim().length() == 0) {
                providerLocationHash.remove(this.customerId);
                providerLocationTimeHash.remove(this.customerId);
                bl = false;
                return string3;
            }
            JsonArray jsonArray = null;
            JsonParser jsonParser = new JsonParser();
            JsonObject jsonObject = (JsonObject)jsonParser.parse(((String)object).trim());
            if (jsonObject != null) {
                String string4 = "";
                String string5 = "";
                if (jsonObject.has("resourceProviders") && (jsonArray = (JsonArray)jsonObject.get("resourceProviders")) != null && jsonArray.size() > 0) {
                    int n = jsonArray.size();
                    for (int i = 0; i < n; ++i) {
                        JsonObject jsonObject2 = (JsonObject)jsonArray.get(i);
                        if (jsonObject2 == null) continue;
                        if (jsonObject2.has("id")) {
                            string4 = jsonObject2.get("id").toString();
                        }
                        if (string4 == null) continue;
                        string4 = CtxCloudHelper.replace(string4.trim(), "\"", "");
                        if (jsonObject2.has("uri")) {
                            string5 = jsonObject2.get("uri").toString();
                        }
                        if (string5 == null) continue;
                        string5 = CtxCloudHelper.replace(string5.trim(), "\"", "");
                        if (string4.equalsIgnoreCase("aggregation") && string5.length() > 20) {
                            string3 = string5.substring(20);
                            continue;
                        }
                        if (!string4.equalsIgnoreCase("licensing") || string5.length() <= 18) continue;
                        string3 = string5.substring(18);
                    }
                }
            }
        }
        catch (Exception exception) {
            providerLocationHash.remove(this.customerId);
            providerLocationTimeHash.remove(this.customerId);
            bl = false;
            System.out.println("[CtxCloudHelper] Exception occured while calling the getProviderLocation method " + exception);
            exception.printStackTrace();
        }
        if (bl && string3 != null) {
            providerLocationHash.put(this.customerId, string3);
            providerLocationTimeHash.put(this.customerId, new Long(System.currentTimeMillis()));
        }
        return string3;
    }

    public Hashtable getResourceLocations(String string) {
        long l;
        long l2;
        long l3;
        Object object;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String string2 = this.getProviderLocation(string);
        if (string2 == null || string2.trim().length() == 0) {
            return hashtable;
        }
        String string3 = "https://registry-" + string2 + "/resourcelocations";
        boolean bl = true;
        hashtable = (Hashtable<String, String>)resourceLocationHash.get(this.customerId);
        if (hashtable != null && hashtable.size() > 0 && (object = (Long)resourceLocationTimeHash.get(this.customerId)) != null && (l3 = (l2 = System.currentTimeMillis()) - (l = ((Long)object).longValue())) < 300000L) {
            return hashtable;
        }
        hashtable = new Hashtable<String, String>();
        try {
            object = this.getJsonString(string3, string);
            if (object == null || ((String)object).trim().length() == 0) {
                resourceLocationHash.remove(this.customerId);
                resourceLocationTimeHash.remove(this.customerId);
                bl = false;
                return hashtable;
            }
            JsonArray jsonArray = null;
            JsonParser jsonParser = new JsonParser();
            JsonObject jsonObject = (JsonObject)jsonParser.parse(((String)object).trim());
            if (jsonObject != null) {
                String string4 = "";
                String string5 = "";
                if (jsonObject.has("items") && (jsonArray = (JsonArray)jsonObject.get("items")) != null && jsonArray.size() > 0) {
                    int n = jsonArray.size();
                    for (int i = 0; i < n; ++i) {
                        JsonObject jsonObject2 = (JsonObject)jsonArray.get(i);
                        if (jsonObject2 == null) continue;
                        if (jsonObject2.has("id")) {
                            string4 = jsonObject2.get("id").toString();
                        }
                        if (string4 == null) continue;
                        string4 = CtxCloudHelper.replace(string4.trim(), "\"", "");
                        if (jsonObject2.has("name")) {
                            string5 = jsonObject2.get("name").toString();
                        }
                        if (string5 == null) continue;
                        string5 = CtxCloudHelper.replace(string5.trim(), "\"", "");
                        if (string4 == null || string4.trim().length() <= 0 || string5 == null || string5.trim().length() <= 0) continue;
                        hashtable.put(string4, string5);
                    }
                }
            }
        }
        catch (Exception exception) {
            resourceLocationHash.remove(this.customerId);
            resourceLocationTimeHash.remove(this.customerId);
            bl = false;
            System.out.println("[CtxCloudHelper] Exception occured while calling the getResourceLocations method " + exception);
            exception.printStackTrace();
        }
        if (bl && hashtable != null) {
            resourceLocationHash.put(this.customerId, hashtable);
            resourceLocationTimeHash.put(this.customerId, new Long(System.currentTimeMillis()));
        }
        return hashtable;
    }

    public Hashtable getEdgeServers(String string) {
        Hashtable hashtable = new Hashtable();
        String string2 = this.getProviderLocation(string);
        if (string2 == null || string2.trim().length() == 0) {
            return hashtable;
        }
        Hashtable hashtable2 = this.getResourceLocations(string);
        if (hashtable2 == null || hashtable2.size() == 0) {
            return hashtable;
        }
        try {
            Enumeration enumeration = hashtable2.keys();
            while (enumeration.hasMoreElements()) {
                JsonParser jsonParser;
                JsonArray jsonArray;
                String string3;
                String string4;
                String string5;
                String string6 = (String)enumeration.nextElement();
                if (string6 == null || string6.trim().length() == 0 || (string5 = (String)hashtable2.get(string6)) == null || string5.trim().length() == 0 || (string4 = this.getJsonString(string3 = "https://agenthub-" + string2 + "/EdgeServers?Location=" + string6 + "&ExtendedData=true&ConnectorType=All", string)) == null || string4.trim().length() == 0 || (jsonArray = (JsonArray)(jsonParser = new JsonParser()).parse(string4.trim())) == null || jsonArray.size() <= 0) continue;
                int n = jsonArray.size();
                for (int i = 0; i < n; ++i) {
                    String string7 = null;
                    String string8 = null;
                    String string9 = null;
                    String string10 = null;
                    String string11 = null;
                    String string12 = null;
                    String string13 = null;
                    String string14 = null;
                    String string15 = null;
                    String string16 = null;
                    JsonObject jsonObject = (JsonObject)jsonArray.get(i);
                    if (jsonObject == null) continue;
                    if (jsonObject.has("id")) {
                        string7 = jsonObject.get("id").toString();
                    }
                    if (string7 == null) continue;
                    string7 = CtxCloudHelper.replace(string7.trim(), "\"", "");
                    if (jsonObject.has("fqdn")) {
                        string8 = jsonObject.get("fqdn").toString();
                    }
                    if (string8 == null) continue;
                    string8 = CtxCloudHelper.replace(string8.trim(), "\"", "");
                    if (jsonObject.has("location")) {
                        string9 = jsonObject.get("location").toString();
                    }
                    string9 = this.getValueOfString(string9);
                    if (jsonObject.has("currentVersion")) {
                        string10 = jsonObject.get("currentVersion").toString();
                    }
                    string10 = this.getValueOfString(string10);
                    if (jsonObject.has("expectedVersion")) {
                        string11 = jsonObject.get("expectedVersion").toString();
                    }
                    string11 = this.getValueOfString(string11);
                    if (jsonObject.has("versionState")) {
                        string12 = jsonObject.get("versionState").toString();
                    }
                    string12 = this.getValueOfString(string12);
                    if (jsonObject.has("inMaintenance")) {
                        string13 = jsonObject.get("inMaintenance").toString();
                    }
                    string13 = string13 == null ? "false" : CtxCloudHelper.replace(string13.trim(), "\"", "");
                    if (jsonObject.has("upgradeDisabled")) {
                        string14 = jsonObject.get("upgradeDisabled").toString();
                    }
                    string14 = string14 == null ? "false" : CtxCloudHelper.replace(string14.trim(), "\"", "");
                    if (jsonObject.has("connectorType")) {
                        string15 = jsonObject.get("connectorType").toString();
                    }
                    string15 = this.getValueOfString(string15);
                    if (jsonObject.has("status")) {
                        string16 = jsonObject.get("status").toString();
                    }
                    string16 = this.getValueOfString(string16);
                    String string17 = "Good";
                    ArrayList arrayList = new ArrayList();
                    Hashtable hashtable3 = this.getEdgeServerAlerts(string, string7, string9);
                    if (hashtable3 != null) {
                        string17 = (String)hashtable3.get("overallStatus");
                        if (string17 == null || string17.trim().length() == 0) {
                            string17 = "Good";
                        }
                        if ((arrayList = (ArrayList)hashtable3.get("alerts")) == null) {
                            arrayList = new ArrayList();
                        }
                    }
                    String string18 = string5 + ":" + string8;
                    ArrayList<Object> arrayList2 = new ArrayList<Object>();
                    arrayList2.add(string7);
                    arrayList2.add(string8);
                    arrayList2.add(string5);
                    arrayList2.add(string10);
                    arrayList2.add(string11);
                    arrayList2.add(string12);
                    arrayList2.add(string13);
                    arrayList2.add(string14);
                    arrayList2.add(string15);
                    arrayList2.add(string16);
                    arrayList2.add(string17);
                    arrayList2.add(arrayList);
                    hashtable.put(string18, arrayList2);
                }
            }
        }
        catch (Exception exception) {
            System.out.println("[CtxCloudHelper] Exception occured while calling the getEdgeServers method " + exception);
            exception.printStackTrace();
        }
        return hashtable;
    }

    public Hashtable getEdgeServerAlerts(String string, String string2, String string3) {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        String string4 = this.getProviderLocation(string);
        if (string4 == null || string4.trim().length() == 0) {
            return hashtable;
        }
        String string5 = "https://healthdataalertstore-" + string4 + "/alerts/edgeserver?edgeserverid=" + string2 + "&resourcelocationid=" + string3;
        try {
            String string6 = this.getJsonString(string5, string);
            if (string6 == null || string6.trim().length() == 0) {
                return hashtable;
            }
            JsonArray jsonArray = null;
            JsonParser jsonParser = new JsonParser();
            JsonObject jsonObject = (JsonObject)jsonParser.parse(string6.trim());
            if (jsonObject != null) {
                String string7 = null;
                ArrayList arrayList = new ArrayList();
                if (jsonObject.has("overallStatus")) {
                    string7 = jsonObject.get("overallStatus").toString();
                }
                string7 = string7 == null ? "-" : CtxCloudHelper.replace(string7.trim(), "\"", "");
                if (jsonObject.has("alerts") && (jsonArray = (JsonArray)jsonObject.get("alerts")) != null && jsonArray != null && jsonArray.size() > 0) {
                    int n = jsonArray.size();
                    for (int i = 0; i < n; ++i) {
                        String string8 = null;
                        String string9 = null;
                        String string10 = null;
                        String string11 = null;
                        String string12 = null;
                        String string13 = null;
                        String string14 = null;
                        String string15 = null;
                        JsonObject jsonObject2 = (JsonObject)jsonArray.get(i);
                        if (jsonObject2 == null) continue;
                        if (jsonObject2.has("objectType")) {
                            string8 = jsonObject2.get("objectType").toString();
                        }
                        if (string8 == null) continue;
                        string8 = this.getValueOfString(string8);
                        if (jsonObject2.has("alertId")) {
                            string9 = jsonObject2.get("alertId").toString();
                        }
                        if (string9 == null) continue;
                        string9 = this.getValueOfString(string9);
                        if (jsonObject2.has("alertTitle")) {
                            string10 = jsonObject2.get("alertTitle").toString();
                        }
                        if (string10 == null) continue;
                        string10 = this.getValueOfString(string10);
                        if (jsonObject2.has("alertType")) {
                            string11 = jsonObject2.get("alertType").toString();
                        }
                        if (string11 == null) continue;
                        string11 = this.getValueOfString(string11);
                        if (jsonObject2.has("message")) {
                            string12 = jsonObject2.get("message").toString();
                        }
                        string12 = this.getValueOfString(string12);
                        if (jsonObject2.has("kbArticleLink")) {
                            string13 = jsonObject2.get("kbArticleLink").toString();
                        }
                        string13 = this.getValueOfString(string13);
                        if (jsonObject2.has("isOutdated")) {
                            string14 = jsonObject2.get("isOutdated").toString();
                        }
                        string14 = this.getValueOfString(string14);
                        if (jsonObject2.has("responseTimestamp")) {
                            string15 = jsonObject2.get("responseTimestamp").toString();
                        }
                        string15 = this.getValueOfString(string15);
                        long l = this.getTime(string15, false);
                        ArrayList<Object> arrayList2 = new ArrayList<Object>();
                        arrayList2.add(string8);
                        arrayList2.add(string9);
                        arrayList2.add(string10);
                        arrayList2.add(string11);
                        arrayList2.add(string12);
                        arrayList2.add(string13);
                        arrayList2.add(string14);
                        arrayList2.add(new Long(l));
                        arrayList.add(arrayList2);
                    }
                }
                hashtable.put("overallStatus", string7);
                hashtable.put("alerts", arrayList);
            }
        }
        catch (Exception exception) {
            System.out.println("[CtxCloudHelper] Exception occured while calling the getEdgeServerAlerts method " + exception);
            exception.printStackTrace();
        }
        return hashtable;
    }

    public ArrayList getCloudLicenseUsages(String string) {
        ArrayList<Object> arrayList;
        block21: {
            arrayList = new ArrayList<Object>();
            String string2 = this.getProviderLocation(string);
            if (string2 == null || string2.trim().length() == 0) {
                return arrayList;
            }
            String string3 = "https://cloudlicense-" + string2 + "/cloudlicenseusages/products/xenappxendesktop/current";
            try {
                Object object;
                String string4 = this.getJsonString(string3, string);
                if (string4 == null || string4.trim().length() == 0) {
                    return arrayList;
                }
                JsonParser jsonParser = new JsonParser();
                JsonObject jsonObject = (JsonObject)jsonParser.parse(string4.trim());
                if (jsonObject == null) break block21;
                String string5 = null;
                String string6 = null;
                String string7 = null;
                Object object2 = null;
                String string8 = null;
                String string9 = null;
                String string10 = null;
                String string11 = null;
                String string12 = null;
                String string13 = null;
                ArrayList arrayList2 = new ArrayList();
                if (jsonObject.has("totalUsageCount")) {
                    string5 = jsonObject.get("totalUsageCount").toString();
                }
                string5 = this.getValueOfString(string5, true);
                if (jsonObject.has("totalAvailableLicenseCount")) {
                    string6 = jsonObject.get("totalAvailableLicenseCount").toString();
                }
                string6 = this.getValueOfString(string6, true);
                if (jsonObject.has("remainingLicenseCount")) {
                    string7 = jsonObject.get("remainingLicenseCount").toString();
                }
                string7 = this.getValueOfString(string7, true);
                if (jsonObject.has("productName")) {
                    object2 = jsonObject.get("productName").toString();
                }
                object2 = this.getValueOfString((String)object2);
                if (jsonObject.has("userLicenseUsage") && (object = (JsonObject)jsonObject.get("userLicenseUsage")) != null) {
                    if (object.has("totalUsageCount")) {
                        string8 = object.get("totalUsageCount").toString();
                    }
                    if (object.has("releasedCount")) {
                        string9 = object.get("releasedCount").toString();
                    }
                }
                string8 = this.getValueOfString(string8, true);
                string9 = this.getValueOfString(string9, true);
                if (jsonObject.has("deviceLicenseUsage") && (object = (JsonObject)jsonObject.get("deviceLicenseUsage")) != null) {
                    if (object.has("totalUsageCount")) {
                        string10 = object.get("totalUsageCount").toString();
                    }
                    if (object.has("releasedCount")) {
                        string11 = object.get("releasedCount").toString();
                    }
                }
                string10 = this.getValueOfString(string10, true);
                string11 = this.getValueOfString(string11, true);
                if (jsonObject.has("nextExpiredLicenses")) {
                    object = null;
                    try {
                        object = (JsonObject)jsonObject.get("nextExpiredLicenses");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (object != null) {
                        if (object.has("daysToExpire")) {
                            string12 = object.get("daysToExpire").toString();
                        }
                        if (object.has("totalCount")) {
                            string13 = object.get("totalCount").toString();
                        }
                    }
                }
                string12 = string12 == null ? "-5" : CtxCloudHelper.replace(string12.trim(), "\"", "");
                string13 = string13 == null ? "-5" : CtxCloudHelper.replace(string13.trim(), "\"", "");
                object = (String)allServiceHash.get(object2);
                if (object != null && ((String)object).trim().length() > 0) {
                    object2 = object;
                }
                arrayList.add(string5);
                arrayList.add(string6);
                arrayList.add(string7);
                arrayList.add(string8);
                arrayList.add(string9);
                arrayList.add(string10);
                arrayList.add(string11);
                arrayList.add(string12);
                arrayList.add(string13);
                arrayList.add(object2);
            }
            catch (Exception exception) {
                System.out.println("[CtxCloudHelper] Exception occured while calling the getCloudLicenseUsages method " + exception);
                exception.printStackTrace();
            }
        }
        return arrayList;
    }

    public ArrayList getCloudLicenseActiveUse(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = this.getProviderLocation(string);
        if (string2 == null || string2.trim().length() == 0) {
            return arrayList;
        }
        String string3 = "https://cloudlicense-" + string2 + "/cloudlicenseactiveuse/products/xenappxendesktop/current";
        try {
            String string4 = this.getJsonString(string3, string);
            if (string4 == null || string4.trim().length() == 0) {
                return arrayList;
            }
            JsonParser jsonParser = new JsonParser();
            JsonObject jsonObject = (JsonObject)jsonParser.parse(string4.trim());
            if (jsonObject != null) {
                String string5 = null;
                String string6 = null;
                String string7 = null;
                String string8 = null;
                String string9 = null;
                String string10 = null;
                String string11 = null;
                String string12 = null;
                String string13 = null;
                String string14 = null;
                ArrayList arrayList2 = new ArrayList();
                if (jsonObject.has("dailyActiveUseValue")) {
                    string5 = jsonObject.get("dailyActiveUseValue").toString();
                }
                string5 = string5 == null || string5.trim().equalsIgnoreCase("null") ? "-5" : CtxCloudHelper.replace(string5.trim(), "\"", "");
                if (jsonObject.has("dailyActiveUsePercentage")) {
                    string6 = jsonObject.get("dailyActiveUsePercentage").toString();
                }
                string6 = string6 == null || string6.trim().equalsIgnoreCase("null") ? "-5" : CtxCloudHelper.replace(string6.trim(), "\"", "");
                if (jsonObject.has("monthlyActiveUseValue")) {
                    string7 = jsonObject.get("monthlyActiveUseValue").toString();
                }
                string7 = string7 == null || string7.trim().equalsIgnoreCase("null") ? "-5" : CtxCloudHelper.replace(string7.trim(), "\"", "");
                if (jsonObject.has("monthlyActiveUsePercentage")) {
                    string8 = jsonObject.get("monthlyActiveUsePercentage").toString();
                }
                string8 = string8 == null || string8.trim().equalsIgnoreCase("null") ? "-5" : CtxCloudHelper.replace(string8.trim(), "\"", "");
                if (jsonObject.has("dailyDeviceActiveUseValue")) {
                    string9 = jsonObject.get("dailyDeviceActiveUseValue").toString();
                }
                string9 = string9 == null || string9.trim().equalsIgnoreCase("null") ? "-5" : CtxCloudHelper.replace(string9.trim(), "\"", "");
                if (jsonObject.has("dailyDeviceActiveUsePercentage")) {
                    string10 = jsonObject.get("dailyDeviceActiveUsePercentage").toString();
                }
                string10 = string10 == null || string10.trim().equalsIgnoreCase("null") ? "-5" : CtxCloudHelper.replace(string10.trim(), "\"", "");
                if (jsonObject.has("monthlyDeviceActiveUseValue")) {
                    string11 = jsonObject.get("monthlyDeviceActiveUseValue").toString();
                }
                string11 = string11 == null || string11.trim().equalsIgnoreCase("null") ? "-5" : CtxCloudHelper.replace(string11.trim(), "\"", "");
                if (jsonObject.has("monthlyDeviceActiveUsePercentage")) {
                    string12 = jsonObject.get("monthlyDeviceActiveUsePercentage").toString();
                }
                string12 = string12 == null || string12.trim().equalsIgnoreCase("null") ? "-5" : CtxCloudHelper.replace(string12.trim(), "\"", "");
                if (jsonObject.has("productName")) {
                    string13 = jsonObject.get("productName").toString();
                }
                string13 = this.getValueOfString(string13);
                if (jsonObject.has("recordingTimeStamp")) {
                    string14 = jsonObject.get("recordingTimeStamp").toString();
                }
                string14 = this.getValueOfString(string14);
                String string15 = (String)allServiceHash.get(string13);
                if (string15 != null && string15.trim().length() > 0) {
                    string13 = string15;
                }
                arrayList.add(string5);
                arrayList.add(string6);
                arrayList.add(string7);
                arrayList.add(string8);
                arrayList.add(string9);
                arrayList.add(string10);
                arrayList.add(string11);
                arrayList.add(string12);
                arrayList.add(string13);
                arrayList.add(string14);
            }
        }
        catch (Exception exception) {
            System.out.println("[CtxCloudHelper] Exception occured while calling the getCloudLicenseActiveUse method " + exception);
            exception.printStackTrace();
        }
        return arrayList;
    }

    public ArrayList getReleasableLicenses(String string, String string2) {
        ArrayList arrayList = new ArrayList();
        String string3 = this.getProviderLocation(string);
        if (string3 == null || string3.trim().length() == 0) {
            return arrayList;
        }
        String string4 = "https://cloudlicense-" + string3 + "/cloudlicenseusages/vad/releasable?licenseType=" + string2;
        try {
            String string5 = this.getJsonString(string4, string);
            if (string5 == null || string5.trim().length() == 0) {
                return arrayList;
            }
            JsonArray jsonArray = null;
            JsonParser jsonParser = new JsonParser();
            JsonObject jsonObject = (JsonObject)jsonParser.parse(string5.trim());
            if (jsonObject != null && jsonObject.has("consumerList") && (jsonArray = (JsonArray)jsonObject.get("consumerList")) != null && jsonArray != null && jsonArray.size() > 0) {
                int n = jsonArray.size();
                for (int i = 0; i < n; ++i) {
                    JsonObject jsonObject2 = (JsonObject)jsonArray.get(i);
                    if (jsonObject2 == null) continue;
                    String string6 = null;
                    String string7 = null;
                    String string8 = null;
                    String string9 = null;
                    String string10 = null;
                    ArrayList arrayList2 = new ArrayList();
                    if (jsonObject2.has("consumerId")) {
                        string6 = jsonObject2.get("consumerId").toString();
                    }
                    string6 = this.getValueOfString(string6);
                    if (jsonObject2.has("consumerDisplayName")) {
                        string7 = jsonObject2.get("consumerDisplayName").toString();
                    }
                    string7 = this.getValueOfString(string7);
                    if (jsonObject2.has("domain")) {
                        string8 = jsonObject2.get("domain").toString();
                    }
                    string8 = this.getValueOfString(string8);
                    if (jsonObject2.has("firstLogonTime")) {
                        string9 = jsonObject2.get("firstLogonTime").toString();
                    }
                    string9 = this.getValueOfString(string9);
                    if (jsonObject2.has("latestLogonTime")) {
                        string10 = jsonObject2.get("latestLogonTime").toString();
                    }
                    string10 = this.getValueOfString(string10);
                    long l = this.getTime(string9);
                    long l2 = this.getTime(string10);
                    ArrayList<Object> arrayList3 = new ArrayList<Object>();
                    arrayList3.add(string6);
                    arrayList3.add(string7);
                    arrayList3.add(string8);
                    arrayList3.add(new Long(l));
                    arrayList3.add(new Long(l2));
                    arrayList.add(arrayList3);
                }
            }
        }
        catch (Exception exception) {
            System.out.println("[CtxCloudHelper] Exception occured while calling the getReleasableLicenses method " + exception);
            exception.printStackTrace();
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getJsonString(String string, String string2) {
        String string3 = "";
        CloseableHttpClient closeableHttpClient = null;
        CloseableHttpResponse closeableHttpResponse = null;
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        StringBuffer stringBuffer = null;
        try {
            String string4 = "CWSAuth bearer=" + string2;
            closeableHttpClient = HttpClients.createDefault();
            HttpGet httpGet = new HttpGet(string);
            httpGet.setHeader("Authorization", string4);
            httpGet.setConfig(this.requestConfig);
            closeableHttpResponse = closeableHttpClient.execute((HttpUriRequest)httpGet);
            if (closeableHttpResponse != null) {
                if (closeableHttpResponse.getStatusLine().getStatusCode() != 200) {
                    String string5 = closeableHttpResponse.getStatusLine().toString();
                    System.out.println("[CtxCloudHelper] getJsonString statusLine is " + string5);
                    System.err.println("[CtxCloudHelper] getJsonString statusLine is " + string5);
                    String string6 = string3;
                    return string6;
                }
                inputStreamReader = new InputStreamReader(closeableHttpResponse.getEntity().getContent());
                bufferedReader = new BufferedReader(inputStreamReader);
                stringBuffer = new StringBuffer();
                String string7 = "";
                while ((string7 = bufferedReader.readLine()) != null) {
                    stringBuffer.append(string7);
                }
                string3 = new String(stringBuffer.toString());
            }
        }
        catch (Exception exception) {
            string3 = "";
            System.out.println("[CtxCloudHelper] Exception occured while calling the getJsonString method " + exception);
            exception.printStackTrace();
        }
        finally {
            try {
                if (closeableHttpResponse != null) {
                    closeableHttpResponse.close();
                }
                if (closeableHttpClient != null) {
                    closeableHttpClient = null;
                }
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                if (inputStreamReader != null) {
                    inputStreamReader.close();
                }
            }
            catch (Exception exception) {}
        }
        return string3;
    }

    public static String replace(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        while (string.indexOf(string2) > -1) {
            stringBuffer.append(string.substring(0, string.indexOf(string2)) + string3);
            string = string.substring(string.indexOf(string2) + string2.length(), string.length());
        }
        if (string.length() > 0) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public long getTime(String string) {
        long l = -1L;
        try {
            if (string == null || string.trim().length() == 0 || string.trim().equals("-")) {
                return l;
            }
            DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ISO_DATE_TIME;
            TemporalAccessor temporalAccessor = dateTimeFormatter.parse(string);
            Date date = Date.from(Instant.from(temporalAccessor));
            l = date.getTime();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return l;
    }

    public long getTime(String string, boolean bl) {
        long l = -1L;
        try {
            if (string == null || string.trim().length() == 0 || string.trim().equals("-")) {
                return l;
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            Date date = simpleDateFormat.parse(string);
            l = date.getTime();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return l;
    }

    public String getValueOfString(String string) {
        return this.getValueOfString(string, false);
    }

    public String getValueOfString(String string, boolean bl) {
        String string2 = "-";
        if (bl) {
            string2 = "0";
        }
        if (string == null || string.trim().length() == 0) {
            return string2;
        }
        string = string.trim();
        if ((string = CtxCloudHelper.replace(string, "\"", "")).equalsIgnoreCase("null")) {
            return string2;
        }
        return string;
    }

    public static void main(String[] stringArray) {
        String string = stringArray[0];
        String string2 = stringArray[1];
        CtxCloudHelper ctxCloudHelper = new CtxCloudHelper(string, string2);
        String string3 = ctxCloudHelper.getAccessToken();
        System.out.println("Access Token " + string3);
        if (string3 == null || string3.trim().length() == 0) {
            return;
        }
        boolean bl = ctxCloudHelper.isAuthenticate(string3);
        System.out.println("Authenticate " + bl);
        System.out.println("Subscribed Services " + ctxCloudHelper.getSubscribedServices(string3));
        System.out.println("Provider Location " + ctxCloudHelper.getProviderLocation(string3));
        System.out.println("Resource Location " + ctxCloudHelper.getResourceLocations(string3));
        System.out.println("Open Tickets " + ctxCloudHelper.getOpenTickets(string3));
        System.out.println("Edge Servers " + ctxCloudHelper.getEdgeServers(string3));
        System.out.println("Cloud License Usage " + ctxCloudHelper.getCloudLicenseUsages(string3));
        System.out.println("Cloud Active License Usage " + ctxCloudHelper.getCloudLicenseActiveUse(string3));
        System.out.println("Cloud User Licenses " + ctxCloudHelper.getReleasableLicenses(string3, "user"));
        System.out.println("Cloud Device Licenses " + ctxCloudHelper.getReleasableLicenses(string3, "device"));
        System.out.println("Cloud User Licenses size " + ctxCloudHelper.getReleasableLicenses(string3, "user").size());
        System.out.println("Cloud Device Licenses size " + ctxCloudHelper.getReleasableLicenses(string3, "device").size());
    }

    static {
        allServiceHash.put("accesssecurity", "Access Control");
        allServiceHash.put("aggregation", "Aggregation");
        allServiceHash.put("applayering", "App Layering");
        allServiceHash.put("browserservice", "Secure Browser");
        allServiceHash.put("cas", "Analytics");
        allServiceHash.put("daas", "Managed Desktops");
        allServiceHash.put("itm", "Intelligent Traffic Management");
        allServiceHash.put("itsm", "ITSM Adapter");
        allServiceHash.put("licensing", "License Usage Insights");
        allServiceHash.put("lifecyclemanagement", "Smart Tools");
        allServiceHash.put("mas", "Application Delivery Management");
        allServiceHash.put("microapps", "Microapps");
        allServiceHash.put("netscalergateway", "Gateway");
        allServiceHash.put("sdwanorchestrator", "SD-WAN Orchestrator");
        allServiceHash.put("sharefile", "Content Collaboration");
        allServiceHash.put("waf", "Web App Firewall");
        allServiceHash.put("wem", "Workspace Environment Management");
        allServiceHash.put("xendesktop", "Virtual Apps and Desktops");
        allServiceHash.put("xenmobile", "Endpoint Management");
        allServiceHash.put("office365", "Office365");
    }
}

