/*
 * Decompiled with CFR 0.152.
 */
package com.eg.ch.qos.logback.classic.turbo;

import com.eg.ch.qos.logback.classic.Level;
import com.eg.ch.qos.logback.classic.Logger;
import com.eg.ch.qos.logback.classic.LoggerContext;
import com.eg.ch.qos.logback.classic.gaffer.GafferUtil;
import com.eg.ch.qos.logback.classic.joran.JoranConfigurator;
import com.eg.ch.qos.logback.classic.turbo.TurboFilter;
import com.eg.ch.qos.logback.classic.util.EnvUtil;
import com.eg.ch.qos.logback.core.joran.event.SaxEvent;
import com.eg.ch.qos.logback.core.joran.spi.ConfigurationWatchList;
import com.eg.ch.qos.logback.core.joran.spi.JoranException;
import com.eg.ch.qos.logback.core.joran.util.ConfigurationWatchListUtil;
import com.eg.ch.qos.logback.core.spi.FilterReply;
import com.eg.ch.qos.logback.core.status.StatusUtil;
import com.eg.org.slf4j.Marker;
import java.io.File;
import java.net.URL;
import java.util.List;

public class ReconfigureOnChangeFilter
extends TurboFilter {
    public static final long DEFAULT_REFRESH_PERIOD = 60000L;
    long refreshPeriod = 60000L;
    URL mainConfigurationURL;
    protected volatile long nextCheck;
    ConfigurationWatchList configurationWatchList;
    private long invocationCounter = 0L;
    private volatile long mask = 15L;
    private volatile long lastMaskCheck = System.currentTimeMillis();
    private static final int MAX_MASK = 65535;
    private static final long MASK_INCREASE_THRESHOLD = 100L;
    private static final long MASK_DECREASE_THRESHOLD = 800L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        this.configurationWatchList = ConfigurationWatchListUtil.getConfigurationWatchList(this.context);
        if (this.configurationWatchList != null) {
            this.mainConfigurationURL = this.configurationWatchList.getMainURL();
            if (this.mainConfigurationURL == null) {
                this.addWarn("Due to missing top level configuration file, automatic reconfiguration is impossible.");
                return;
            }
            List<File> list = this.configurationWatchList.getCopyOfFileWatchList();
            long l2 = this.refreshPeriod / 1000L;
            this.addInfo("Will scan for changes in [" + list + "] every " + l2 + " seconds. ");
            ConfigurationWatchList configurationWatchList = this.configurationWatchList;
            synchronized (configurationWatchList) {
                this.updateNextCheck(System.currentTimeMillis());
            }
            super.start();
        } else {
            this.addWarn("Empty ConfigurationWatchList in context");
        }
    }

    public String toString() {
        return "ReconfigureOnChangeFilter{invocationCounter=" + this.invocationCounter + '}';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FilterReply decide(Marker marker, Logger logger, Level level, String string, Object[] objectArray, Throwable throwable) {
        if (!this.isStarted()) {
            return FilterReply.NEUTRAL;
        }
        if ((this.invocationCounter++ & this.mask) != this.mask) {
            return FilterReply.NEUTRAL;
        }
        long l2 = System.currentTimeMillis();
        ConfigurationWatchList configurationWatchList = this.configurationWatchList;
        synchronized (configurationWatchList) {
            this.updateMaskIfNecessary(l2);
            if (this.changeDetected(l2)) {
                this.disableSubsequentReconfiguration();
                this.detachReconfigurationToNewThread();
            }
        }
        return FilterReply.NEUTRAL;
    }

    private void updateMaskIfNecessary(long l2) {
        long l3 = l2 - this.lastMaskCheck;
        this.lastMaskCheck = l2;
        if (l3 < 100L && this.mask < 65535L) {
            this.mask = this.mask << 1 | 1L;
        } else if (l3 > 800L) {
            this.mask >>>= 2;
        }
    }

    void detachReconfigurationToNewThread() {
        this.addInfo("Detected change in [" + this.configurationWatchList.getCopyOfFileWatchList() + "]");
        this.context.getExecutorService().submit(new ReconfiguringThread());
    }

    void updateNextCheck(long l2) {
        this.nextCheck = l2 + this.refreshPeriod;
    }

    protected boolean changeDetected(long l2) {
        if (l2 >= this.nextCheck) {
            this.updateNextCheck(l2);
            return this.configurationWatchList.changeDetected();
        }
        return false;
    }

    void disableSubsequentReconfiguration() {
        this.nextCheck = Long.MAX_VALUE;
    }

    public long getRefreshPeriod() {
        return this.refreshPeriod;
    }

    public void setRefreshPeriod(long l2) {
        this.refreshPeriod = l2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ReconfiguringThread
    implements Runnable {
        ReconfiguringThread() {
        }

        @Override
        public void run() {
            if (ReconfigureOnChangeFilter.this.mainConfigurationURL == null) {
                ReconfigureOnChangeFilter.this.addInfo("Due to missing top level configuration file, skipping reconfiguration");
                return;
            }
            LoggerContext loggerContext = (LoggerContext)ReconfigureOnChangeFilter.this.context;
            ReconfigureOnChangeFilter.this.addInfo("Will reset and reconfigure context named [" + ReconfigureOnChangeFilter.this.context.getName() + "]");
            if (ReconfigureOnChangeFilter.this.mainConfigurationURL.toString().endsWith("xml")) {
                this.performXMLConfiguration(loggerContext);
            } else if (ReconfigureOnChangeFilter.this.mainConfigurationURL.toString().endsWith("groovy")) {
                if (EnvUtil.isGroovyAvailable()) {
                    loggerContext.reset();
                    GafferUtil.runGafferConfiguratorOn(loggerContext, (Object)this, ReconfigureOnChangeFilter.this.mainConfigurationURL);
                } else {
                    ReconfigureOnChangeFilter.this.addError("Groovy classes are not available on the class path. ABORTING INITIALIZATION.");
                }
            }
        }

        private void performXMLConfiguration(LoggerContext loggerContext) {
            JoranConfigurator joranConfigurator = new JoranConfigurator();
            joranConfigurator.setContext(ReconfigureOnChangeFilter.this.context);
            StatusUtil statusUtil = new StatusUtil(ReconfigureOnChangeFilter.this.context);
            List<SaxEvent> list = joranConfigurator.recallSafeConfiguration();
            URL uRL = ConfigurationWatchListUtil.getMainWatchURL(ReconfigureOnChangeFilter.this.context);
            loggerContext.reset();
            long l2 = System.currentTimeMillis();
            try {
                joranConfigurator.doConfigure(ReconfigureOnChangeFilter.this.mainConfigurationURL);
                if (statusUtil.hasXMLParsingErrors(l2)) {
                    this.fallbackConfiguration(loggerContext, list, uRL);
                }
            }
            catch (JoranException joranException) {
                this.fallbackConfiguration(loggerContext, list, uRL);
            }
        }

        private void fallbackConfiguration(LoggerContext loggerContext, List<SaxEvent> list, URL uRL) {
            JoranConfigurator joranConfigurator = new JoranConfigurator();
            joranConfigurator.setContext(ReconfigureOnChangeFilter.this.context);
            if (list != null) {
                ReconfigureOnChangeFilter.this.addWarn("Falling back to previously registered safe configuration.");
                try {
                    loggerContext.reset();
                    JoranConfigurator.informContextOfURLUsedForConfiguration(ReconfigureOnChangeFilter.this.context, uRL);
                    joranConfigurator.doConfigure(list);
                    ReconfigureOnChangeFilter.this.addInfo("Re-registering previous fallback configuration once more as a fallback configuration point");
                    joranConfigurator.registerSafeConfiguration(list);
                }
                catch (JoranException joranException) {
                    ReconfigureOnChangeFilter.this.addError("Unexpected exception thrown by a configuration considered safe.", joranException);
                }
            } else {
                ReconfigureOnChangeFilter.this.addWarn("No previous configuration to fall back on.");
            }
        }
    }
}

