/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgLangInfo;
import com.egurkha.util.EgUtilities;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class NetworkTrafficTest
extends EgTest {
    private EgUtilities egutil = null;
    private double receivedPkts;
    private double sendPkts;
    private double prevReceivedPkts = 0.0;
    private double prevSendPkts = 0.0;
    private static int iPktRateIndex = 0;
    private static int oPktRateIndex = 1;
    private String agentlessCmd = null;
    private XCmdGeneric xcmdG = null;
    private String index;
    Boolean lock;
    static String commandToUse = "netstat -e";
    NetworkTrafficTestHelper helper = null;
    String[] ntkInterfaces = null;
    NetworkTrafficGeneric netG = null;
    public boolean isIfconfigCmd = true;
    private boolean highSecure = false;

    public static void main(String[] stringArray) {
        NetworkTrafficTest networkTrafficTest = new NetworkTrafficTest(stringArray);
        while (true) {
            try {
                while (true) {
                    networkTrafficTest.executeTest();
                    Thread.sleep(20000L);
                }
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }

    public NetworkTrafficTest(String[] stringArray) {
        super(stringArray);
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            if (stringArray[i].equalsIgnoreCase("-host")) {
                this.targetHost = stringArray[++i];
            }
            if (!stringArray[i].equalsIgnoreCase("-high_security")) continue;
            this.highSecure = (string = stringArray[++i]) != null && (string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("true"));
        }
        if (this.targetHost == null) {
            this.targetHost = this.getHostName();
        }
        this.numOutputFields = 2;
        this.index = this.siteName + siteAndInfoSeparator + infoFieldSeparator;
        if (!this.meAgentless) {
            this.egutil = EgUtilities.createInstance();
        }
    }

    public boolean executeTest() {
        this.initTest();
        if (!this.meAgentless) {
            return this.executeNetstat(commandToUse, false);
        }
        if (this.isPerfmon) {
            this.checkNbt();
            if (this.nbtName == null) {
                this.errorMsg = "Failed to get the NETBios name for  " + this.targetHost;
                this.logToErrorFile("ERROR", this.entity, this.errorMsg);
                this.removeJNIFromMemory();
                this.helper = null;
                this.updateAllResultSets();
                return false;
            }
            if (this.xcmdG == null) {
                this.xcmdG = new XCmdGeneric(this.nbtName);
            }
            if (!this.alos.equalsIgnoreCase("nt")) {
                if (this.helper == null) {
                    this.helper = new NetworkTrafficTestHelper(this.nbtName, this.os);
                    this.discCount = 0;
                }
                if (this.discCount >= this.maxDiscCount) {
                    this.discCount = 0;
                }
                if (this.discCount == 0) {
                    this.ntkInterfaces = this.helper.getNetworkInterfaces();
                    if (this.ntkInterfaces == null) {
                        this.removeJNIFromMemory();
                        this.helper = null;
                        this.agentlessCmd = "netstat -e";
                        return this.executeNetstat(this.agentlessCmd, true);
                    }
                }
                ++this.discCount;
                double[][] dArray = this.helper.getNtkInterfaceMeasures(this.ntkInterfaces);
                if (dArray == null) {
                    this.errorMsg = "NetworkTrafficTest is failed to get the jni values for " + this.targetHost;
                    this.logToErrorFile("ERROR", this.entity, this.errorMsg);
                    this.updateAllResultSets();
                    this.removeJNIFromMemory();
                    this.helper = null;
                    return false;
                }
                try {
                    for (int i = 0; i < dArray.length; ++i) {
                        if (dArray[i][0] < 0.0) {
                            dArray[i][0] = 0.0;
                        }
                        if (dArray[i][1] < 0.0) {
                            dArray[i][1] = 0.0;
                        }
                        this.receivedPkts += dArray[i][0];
                        this.sendPkts += dArray[i][1];
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    this.errorMsg = "NetworkTrafficTest: Number format error for " + this.targetHost;
                    numberFormatException.printStackTrace();
                    this.updateAllResultSets();
                    return false;
                }
                if (this.prevReceivedPkts == 0.0 || this.prevSendPkts == 0.0) {
                    this.addValueToResultSet(this.index, iPktRateIndex, 0.0);
                    this.addValueToResultSet(this.index, oPktRateIndex, 0.0);
                    this.prevReceivedPkts = this.receivedPkts;
                    this.prevSendPkts = this.sendPkts;
                    this.updateAllResultSets();
                    return true;
                }
                this.computeResults();
                this.prevReceivedPkts = this.receivedPkts;
                this.prevSendPkts = this.sendPkts;
                this.updateAllResultSets();
                return true;
            }
            this.agentlessCmd = "netstat -e";
            return this.executeNetstat(this.agentlessCmd, true);
        }
        if ((this.isSSH || this.isRexec) && this.alos.equalsIgnoreCase("solaris")) {
            ArrayList arrayList;
            if (this.alpassword.equalsIgnoreCase("none") || this.aluser.equalsIgnoreCase("NONE")) {
                this.errorMsg = "NetworkTrafficTest is configured in Agentless and os/aluser can't  be NONE for " + this.targetHost;
                this.logToErrorFile("ERROR", this.entity, this.errorMsg);
                this.updateAllResultSets();
                return false;
            }
            String string = "";
            if (this.isSSH) {
                string = "ssh";
            } else if (this.isRexec) {
                string = "rexec";
            }
            if (this.netG == null) {
                this.netG = new NetworkTrafficGeneric(string, this.targetHost, this.sshPort, this.aluser, this.alpassword);
            }
            if ((arrayList = this.netG.getActualResultsOnSolaris(this.timeSinceLastTest)) == null) {
                this.updateAllResultSets();
                this.netG = null;
                return true;
            }
            try {
                int n = arrayList.size();
                StringTokenizer stringTokenizer = null;
                for (int i = 0; i < n; ++i) {
                    String string2 = (String)arrayList.get(i);
                    stringTokenizer = new StringTokenizer(string2, "#");
                    if (stringTokenizer.countTokens() <= 0) {
                        this.updateAllResultSets();
                        return true;
                    }
                    String string3 = stringTokenizer.nextToken();
                    Double d = null;
                    d = new Double(stringTokenizer.nextToken());
                    double d2 = d;
                    d = new Double(stringTokenizer.nextToken());
                    double d3 = d;
                    this.index = this.siteName + siteAndInfoSeparator + infoFieldSeparator + string3;
                    this.addValueToResultSet(this.index, iPktRateIndex, this.checkValue(d2));
                    this.addValueToResultSet(this.index, oPktRateIndex, this.checkValue(d3));
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.updateAllResultSets();
            }
            this.updateAllResultSets();
        } else if ((this.isSSH || this.isRexec) && this.alos.equalsIgnoreCase("linux")) {
            ArrayList arrayList;
            if (this.alpassword.equalsIgnoreCase("none") || this.aluser.equalsIgnoreCase("NONE")) {
                this.errorMsg = "NetworkTrafficTest is configured in Agentless and os/aluser can't  be NONE for " + this.targetHost;
                this.logToErrorFile("ERROR", this.entity, this.errorMsg);
                this.updateAllResultSets();
                return false;
            }
            String string = "";
            if (this.isSSH) {
                string = "ssh";
            } else if (this.isRexec) {
                string = "rexec";
            }
            if (this.netG == null) {
                this.netG = this.highSecure ? new NetworkTrafficGeneric(string, this.targetHost, this.sshPort, this.aluser, this.alpassword, this.highSecure) : new NetworkTrafficGeneric(string, this.targetHost, this.sshPort, this.aluser, this.alpassword);
            }
            if ((arrayList = this.netG.getActualResultsOnLinux(this.timeSinceLastTest, this)) == null) {
                this.updateAllResultSets();
                this.netG = null;
                return true;
            }
            try {
                int n = arrayList.size();
                StringTokenizer stringTokenizer = null;
                for (int i = 0; i < n; ++i) {
                    String string4 = (String)arrayList.get(i);
                    stringTokenizer = new StringTokenizer(string4, "#");
                    if (stringTokenizer.countTokens() <= 0) {
                        this.updateAllResultSets();
                        return true;
                    }
                    String string5 = stringTokenizer.nextToken();
                    Double d = null;
                    d = new Double(stringTokenizer.nextToken());
                    double d4 = d;
                    d = new Double(stringTokenizer.nextToken());
                    double d5 = d;
                    this.index = this.siteName + siteAndInfoSeparator + infoFieldSeparator + string5;
                    this.addValueToResultSet(this.index, iPktRateIndex, this.checkValue(d4));
                    this.addValueToResultSet(this.index, oPktRateIndex, this.checkValue(d5));
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.updateAllResultSets();
            }
            this.updateAllResultSets();
        } else if ((this.isSSH || this.isRexec) && this.alos.equalsIgnoreCase("tru64")) {
            ArrayList arrayList;
            if (this.alpassword.equalsIgnoreCase("none") || this.aluser.equalsIgnoreCase("NONE")) {
                this.errorMsg = "NetworkTrafficTest is configured in Agentless and os/aluser can't  be NONE for " + this.targetHost;
                this.logToErrorFile("ERROR", this.entity, this.errorMsg);
                this.updateAllResultSets();
                return false;
            }
            String string = "";
            if (this.isSSH) {
                string = "ssh";
            } else if (this.isRexec) {
                string = "rexec";
            }
            if (this.netG == null) {
                this.netG = new NetworkTrafficGeneric(string, this.targetHost, this.sshPort, this.aluser, this.alpassword);
            }
            if ((arrayList = this.netG.getActualResultsOnTru64(this.timeSinceLastTest)) == null) {
                this.updateAllResultSets();
                this.netG = null;
                return true;
            }
            try {
                int n = arrayList.size();
                StringTokenizer stringTokenizer = null;
                System.out.println("OUT is " + arrayList);
                for (int i = 0; i < n; ++i) {
                    String string6 = (String)arrayList.get(i);
                    stringTokenizer = new StringTokenizer(string6, "#");
                    if (stringTokenizer.countTokens() <= 0) {
                        this.updateAllResultSets();
                        return true;
                    }
                    String string7 = stringTokenizer.nextToken();
                    Double d = null;
                    d = new Double(stringTokenizer.nextToken());
                    double d6 = d;
                    d = new Double(stringTokenizer.nextToken());
                    double d7 = d;
                    this.index = this.siteName + siteAndInfoSeparator + infoFieldSeparator + string7;
                    this.addValueToResultSet(this.index, iPktRateIndex, this.checkValue(d6));
                    this.addValueToResultSet(this.index, oPktRateIndex, this.checkValue(d7));
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.updateAllResultSets();
            }
            this.updateAllResultSets();
        } else if ((this.isSSH || this.isRexec) && this.alos.equalsIgnoreCase("hpux")) {
            ArrayList arrayList;
            if (this.alpassword.equalsIgnoreCase("none") || this.aluser.equalsIgnoreCase("NONE")) {
                this.errorMsg = "NetworkTrafficTest is configured in Agentless and os/aluser can't  be NONE for " + this.targetHost;
                this.logToErrorFile("ERROR", this.entity, this.errorMsg);
                this.updateAllResultSets();
                return false;
            }
            String string = "";
            if (this.isSSH) {
                string = "ssh";
            } else if (this.isRexec) {
                string = "rexec";
            }
            if (this.netG == null) {
                this.netG = new NetworkTrafficGeneric(string, this.targetHost, this.sshPort, this.aluser, this.alpassword);
            }
            if ((arrayList = this.netG.getActualResultsOnHPUnix(this.timeSinceLastTest)) == null) {
                this.updateAllResultSets();
                this.netG = null;
                return true;
            }
            try {
                int n = arrayList.size();
                StringTokenizer stringTokenizer = null;
                for (int i = 0; i < n; ++i) {
                    String string8 = (String)arrayList.get(i);
                    stringTokenizer = new StringTokenizer(string8, "#");
                    if (stringTokenizer.countTokens() <= 0) {
                        this.updateAllResultSets();
                        return true;
                    }
                    String string9 = stringTokenizer.nextToken();
                    Double d = null;
                    d = new Double(stringTokenizer.nextToken());
                    double d8 = d;
                    d = new Double(stringTokenizer.nextToken());
                    double d9 = d;
                    this.index = this.siteName + siteAndInfoSeparator + infoFieldSeparator + string9;
                    this.addValueToResultSet(this.index, iPktRateIndex, this.checkValue(d8));
                    this.addValueToResultSet(this.index, oPktRateIndex, this.checkValue(d9));
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.updateAllResultSets();
            }
            this.updateAllResultSets();
        } else if ((this.isSSH || this.isRexec) && this.alos.equalsIgnoreCase("aix")) {
            ArrayList arrayList;
            if (this.alpassword.equalsIgnoreCase("none") || this.aluser.equalsIgnoreCase("NONE")) {
                this.errorMsg = "NetworkTrafficTest is configured in Agentless and os/aluser can't  be NONE for " + this.targetHost;
                this.logToErrorFile("ERROR", this.entity, this.errorMsg);
                this.updateAllResultSets();
                return false;
            }
            String string = "";
            if (this.isSSH) {
                string = "ssh";
            } else if (this.isRexec) {
                string = "rexec";
            }
            if (this.netG == null) {
                this.netG = new NetworkTrafficGeneric(string, this.targetHost, this.sshPort, this.aluser, this.alpassword);
            }
            if ((arrayList = this.netG.getActualResultsOnAix(this.timeSinceLastTest)) == null) {
                this.updateAllResultSets();
                this.netG = null;
                return true;
            }
            try {
                int n = arrayList.size();
                StringTokenizer stringTokenizer = null;
                for (int i = 0; i < n; ++i) {
                    String string10 = (String)arrayList.get(i);
                    stringTokenizer = new StringTokenizer(string10, "#");
                    if (stringTokenizer.countTokens() <= 1) {
                        this.updateAllResultSets();
                        return true;
                    }
                    String string11 = stringTokenizer.nextToken();
                    Double d = null;
                    d = new Double(stringTokenizer.nextToken());
                    double d10 = d;
                    d = new Double(stringTokenizer.nextToken());
                    double d11 = d;
                    this.index = this.siteName + siteAndInfoSeparator + infoFieldSeparator + string11;
                    this.addValueToResultSet(this.index, iPktRateIndex, this.checkValue(d10));
                    this.addValueToResultSet(this.index, oPktRateIndex, this.checkValue(d11));
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.updateAllResultSets();
                return false;
            }
            this.updateAllResultSets();
        }
        return true;
    }

    private boolean executeNetstat(String string, boolean bl) {
        ArrayList arrayList = null;
        this.sendPkts = 0.0;
        this.receivedPkts = 0.0;
        arrayList = !bl ? this.egutil.getExecOutputLines(string) : this.xcmdG.executeRemoteCommand(string);
        if (arrayList == null || arrayList.size() < 2) {
            this.errorMsg = new String("Failed to run " + string);
            this.updateAllResultSets();
            return false;
        }
        ArrayList arrayList2 = (ArrayList)arrayList.get(0);
        if (arrayList2 != null && arrayList2.size() > 0) {
            int n = arrayList2.size();
            String string2 = EgLangInfo.getAgentCommandSearch((String)"netstat -e", (String)"Unicast packets");
            String string3 = EgLangInfo.getAgentCommandSearch((String)"netstat -e", (String)"Non-unicast packets");
            ArrayList arrayList3 = new ArrayList();
            arrayList3 = this.getTokensList(string2);
            arrayList3.addAll(this.getTokensList(string3));
            int n2 = arrayList3.size();
            for (int i = 0; i < n; ++i) {
                String string4 = (String)arrayList2.get(i);
                for (int j = 0; j < n2; ++j) {
                    String string5 = (String)arrayList3.get(j);
                    if (!string4.startsWith(string5) && string4.indexOf(string5) < 0) continue;
                    StringTokenizer stringTokenizer = new StringTokenizer(string4);
                    int n3 = stringTokenizer.countTokens();
                    int n4 = n3 - 2;
                    for (int k = 0; k < n4; ++k) {
                        stringTokenizer.nextToken();
                    }
                    String string6 = stringTokenizer.nextToken();
                    String string7 = stringTokenizer.nextToken();
                    try {
                        this.receivedPkts += Double.parseDouble(string6);
                        this.sendPkts += Double.parseDouble(string7);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("Number format error");
                        numberFormatException.printStackTrace();
                    }
                }
            }
            if (this.prevReceivedPkts == 0.0 || this.prevSendPkts == 0.0) {
                this.addValueToResultSet(this.index, iPktRateIndex, 0.0);
                this.addValueToResultSet(this.index, oPktRateIndex, 0.0);
                this.prevReceivedPkts = this.receivedPkts;
                this.prevSendPkts = this.sendPkts;
                this.updateAllResultSets();
                return true;
            }
            this.computeResults();
            this.prevReceivedPkts = this.receivedPkts;
            this.prevSendPkts = this.sendPkts;
        }
        this.updateAllResultSets();
        return true;
    }

    private ArrayList getTokensList(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            int n = stringTokenizer.countTokens();
            for (int i = 0; i < n; ++i) {
                String string2 = stringTokenizer.nextToken();
                if (string2 == null || string2.trim().length() <= 0) continue;
                string2 = string2.trim();
                arrayList.add(string2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList;
    }

    public void stopTest() {
        this.removeJNIFromMemory();
    }

    public void removeJNIFromMemory() {
        if (this.isPerfmon) {
            if (this.helper != null) {
                this.helper.removeHandles();
            }
            this.helper = null;
        }
    }

    void computeResults() {
        double d = this.receivedPkts - this.prevReceivedPkts;
        double d2 = this.sendPkts - this.prevSendPkts;
        double d3 = this.timeSinceLastTest < 0.0 || d < 0.0 ? -5.0 : d / this.timeSinceLastTest;
        double d4 = this.timeSinceLastTest < 0.0 || d2 < 0.0 ? -5.0 : d2 / this.timeSinceLastTest;
        this.addValueToResultSet(this.index, iPktRateIndex, this.checkValue(d3));
        this.addValueToResultSet(this.index, oPktRateIndex, this.checkValue(d4));
    }

    private double checkValue(double d) {
        if (d > 9.99999999999999E14) {
            d = -5.0;
        }
        return d;
    }
}

