/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgDateInfo;
import com.eg.EgLangInfo;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.TimeZone;

public class NvidiaFeatureTest
extends GenericTest {
    private String url = "";
    private boolean isSSL = false;
    private static SimpleDateFormat utcFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    private static SimpleDateFormat currentTimeFormat = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
    private static EgDateInfo dateInfo = new EgDateInfo();
    public Hashtable totalCountDDHash = new Hashtable();
    public Hashtable usedCountDDHash = new Hashtable();

    public NvidiaFeatureTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(this.measureCount);
        this.isNewDynamicInfoTest = true;
        String string = this.getValueForParam("ssl");
        this.isSSL = string != null && string.trim().length() > 0 && string.trim().equalsIgnoreCase("true") && string.trim().equalsIgnoreCase("yes");
        this.url = this.isSSL ? "https://" : "http://";
        this.url = this.url + this.targetHost + ":" + this.portNo;
        utcFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        TimeZone timeZone = Calendar.getInstance().getTimeZone();
        currentTimeFormat.setTimeZone(TimeZone.getTimeZone(timeZone.getID()));
    }

    public void freeTest() {
        this.totalCountDDHash = new Hashtable();
        this.usedCountDDHash = new Hashtable();
    }

    public void computeMeasures(Hashtable hashtable) {
        this.totalCountDDHash = new Hashtable();
        this.usedCountDDHash = new Hashtable();
        long l = (long)((double)(75L * this.measurePeriod) / 100.0);
        String string = this.url + "/api/1.0/instances/~/features";
        Hashtable hashtable2 = new Hashtable();
        try {
            JsonArray jsonArray = (JsonArray)NvidiaHelper.readFromUrl((String)string, (boolean)this.isSSL, (long)l);
            if (jsonArray == null || jsonArray.size() == 0) {
                return;
            }
            int n = jsonArray.size();
            for (int i = 0; i < n; ++i) {
                String string2;
                JsonObject jsonObject = (JsonObject)jsonArray.get(i);
                if (jsonObject == null) continue;
                double d = -5.0;
                double d2 = -5.0;
                double d3 = -5.0;
                double d4 = -5.0;
                double d5 = -5.0;
                double d6 = -5.0;
                double d7 = -5.0;
                double d8 = -5.0;
                String string3 = NvidiaHelper.getJsonObjectString((JsonObject)jsonObject, (String)"id");
                if (string3 == null || string3.trim().length() == 0 || string3.equalsIgnoreCase("-") || (string2 = NvidiaHelper.getJsonObjectString((JsonObject)jsonObject, (String)"featureName")) == null || string2.trim().length() == 0 || string2.equalsIgnoreCase("-")) continue;
                d = this.getFeatureType(NvidiaHelper.getJsonObjectString((JsonObject)jsonObject, (String)"type"));
                d2 = this.getDoubleValue(NvidiaHelper.getJsonObjectString((JsonObject)jsonObject, (String)"featureCount"));
                d3 = this.getDoubleValue(NvidiaHelper.getJsonObjectString((JsonObject)jsonObject, (String)"used"));
                if (d2 > 0.0 && d3 >= 0.0 && d2 >= d3) {
                    d4 = d2 - d3;
                    d5 = d3 / d2 * 100.0;
                    if (d5 > 100.0) {
                        d5 = 100.0;
                    }
                }
                d6 = this.getDoubleValue(NvidiaHelper.getJsonObjectString((JsonObject)jsonObject, (String)"overdraftCount"));
                d7 = this.getBooleanValue(NvidiaHelper.getJsonObjectString((JsonObject)jsonObject, (String)"uncappedOverdraft"));
                d8 = this.getDoubleValue(NvidiaHelper.getJsonObjectString((JsonObject)jsonObject, (String)"reserved"));
                String string4 = NvidiaHelper.getJsonObjectString((JsonObject)jsonObject, (String)"featureVersion");
                String string5 = NvidiaHelper.getJsonObjectString((JsonObject)jsonObject, (String)"starts");
                String string6 = NvidiaHelper.getJsonObjectString((JsonObject)jsonObject, (String)"issued");
                String string7 = NvidiaHelper.getJsonObjectString((JsonObject)jsonObject, (String)"expiry");
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(string4);
                arrayList.add(string5);
                arrayList.add(string6);
                arrayList.add(string7);
                string2 = string2 + ":" + string3;
                this.totalCountDDHash.put(string2, arrayList);
                if (string3 != null && (string3 = string3.trim()).length() > 0 && !string3.equalsIgnoreCase("-")) {
                    this.getLicenseFeatureDD(string2, string3, l);
                }
                ArrayList<Double> arrayList2 = new ArrayList<Double>();
                arrayList2.add(new Double(d));
                arrayList2.add(new Double(d2));
                arrayList2.add(new Double(d3));
                arrayList2.add(new Double(d4));
                arrayList2.add(new Double(d5));
                arrayList2.add(new Double(d6));
                arrayList2.add(new Double(d7));
                arrayList2.add(new Double(d8));
                this.addNewMeasure(string2, arrayList2);
            }
        }
        catch (Exception exception) {
            String string8 = EgInstallInfo.getStackTraceAsString((Exception)exception);
            this.logToErrorFile("ERROR", this.entity, string8);
        }
    }

    private void getLicenseFeatureDD(String string, String string2, long l) {
        try {
            String string3 = this.url + "/api/1.0/instances/~/features/" + string2 + "/clients";
            JsonArray jsonArray = (JsonArray)NvidiaHelper.readFromUrl((String)string3, (boolean)this.isSSL, (long)l);
            if (jsonArray == null || jsonArray.size() == 0) {
                return;
            }
            int n = jsonArray.size();
            for (int i = 0; i < n; ++i) {
                String string4;
                JsonObject jsonObject = (JsonObject)jsonArray.get(i);
                if (jsonObject == null) continue;
                JsonObject jsonObject2 = NvidiaHelper.getJsonObject((JsonObject)jsonObject, (String)"client");
                String string5 = "-";
                String string6 = "-";
                String string7 = "-";
                String string8 = "-";
                String string9 = "-";
                String string10 = "-";
                if (jsonObject2 != null) {
                    string10 = NvidiaHelper.getJsonObjectString((JsonObject)jsonObject2, (String)"servedStatus");
                    string9 = NvidiaHelper.getJsonObjectString((JsonObject)jsonObject2, (String)"hostName");
                    string7 = NvidiaHelper.getJsonObjectString((JsonObject)jsonObject2, (String)"machineType");
                    string8 = this.convetTimeFormat(NvidiaHelper.getJsonObjectString((JsonObject)jsonObject2, (String)"expiry"));
                    string4 = NvidiaHelper.getJsonObject((JsonObject)jsonObject2, (String)"hostid");
                    if (string4 != null) {
                        string5 = NvidiaHelper.getJsonObjectString((JsonObject)string4, (String)"hostidValue");
                        string6 = NvidiaHelper.getJsonObjectString((JsonObject)string4, (String)"hostidType");
                    }
                }
                string4 = NvidiaHelper.getJsonObjectString((JsonObject)jsonObject, (String)"useCount");
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(string9);
                arrayList.add(string5);
                arrayList.add(string6);
                arrayList.add(string7);
                arrayList.add(string4);
                arrayList.add(string10);
                arrayList.add(string8);
                ArrayList arrayList2 = (ArrayList)this.usedCountDDHash.get(string);
                if (arrayList2 == null) {
                    arrayList2 = new ArrayList();
                }
                arrayList2.add(arrayList);
                this.usedCountDDHash.put(string, arrayList2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private String convetTimeFormat(String string) {
        String string2 = "";
        if (string == null || string.trim().length() == 0 || string.trim().equals("-")) {
            return "-";
        }
        try {
            Date date = utcFormat.parse(string.trim());
            String string3 = currentTimeFormat.format(date);
            Date date2 = currentTimeFormat.parse(string3);
            string2 = dateInfo.egetDate(date2);
        }
        catch (Exception exception) {
            string2 = "-";
            exception.printStackTrace();
        }
        return string2;
    }

    private double getBooleanValue(String string) {
        double d = -5.0;
        try {
            if (string == null || string.trim().length() == 0 || string.equalsIgnoreCase("-")) {
                d = -5.0;
            }
            if ((string = string.trim()).equalsIgnoreCase("yes") || string.equalsIgnoreCase("true")) {
                d = 1.0;
            } else if (string.equalsIgnoreCase("no") || string.equalsIgnoreCase("false")) {
                d = 0.0;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            d = -5.0;
        }
        return d;
    }

    private double getFeatureType(String string) {
        double d = -1.0;
        try {
            if (string == null || string.trim().length() == 0 || string.equalsIgnoreCase("-")) {
                d = -5.0;
            }
            if ((string = string.trim()).equalsIgnoreCase("CONCURRENT")) {
                d = 1.0;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            d = -1.0;
        }
        return d;
    }

    private double getDoubleValue(String string) {
        double d = -5.0;
        try {
            if (string == null || string.trim().length() == 0 || string.equalsIgnoreCase("-")) {
                return -5.0;
            }
            d = EgLangInfo.getDoubleValue((String)string.trim());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return d;
    }

    public static void main(String[] stringArray) {
        NvidiaFeatureTest nvidiaFeatureTest = new NvidiaFeatureTest(stringArray);
        nvidiaFeatureTest.computeMeasures(new Hashtable());
    }
}

