/*
 * Decompiled with CFR 0.152.
 */
import com.egurkha.util.EgUtilities;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class NetworkTest
extends EgTest {
    int size = 1000;
    int numPac = 10;
    int packetInterval = 50;
    int timeOut = 1000;
    int availability;
    double minDelay;
    double avgDelay;
    double lossPct;
    private static int avgDelayIndex = 0;
    private static int minDelayIndex = 1;
    private static int lossPctIndex = 2;
    private static int availabilityIndex = 3;
    private String index;
    private String realIndex;
    private ArrayList procList = new ArrayList();
    private boolean isWindowsOS = false;
    private EgUtilities egutil = null;
    String[] targets = new String[0];
    String[] names = new String[0];

    public NetworkTest(String[] stringArray) {
        super(stringArray);
        this.numOutputFields = 4;
        String string = "";
        String string2 = System.getProperty("os.name").toLowerCase();
        if (string2.indexOf("win") >= 0) {
            this.isWindowsOS = true;
        }
        if (stringArray.length < 2 || !stringArray[0].equalsIgnoreCase("-host")) {
            System.err.println("Usage: NetworkTest -host <host> -packetSize <size> -packetCount <numPac> -timeout <timeout>");
            return;
        }
        this.targetHost = new String(stringArray[1]);
        this.index = new String(this.siteName + siteAndInfoSeparator + infoFieldSeparator);
        this.egutil = EgUtilities.createInstance();
        for (int i = 2; i < stringArray.length; ++i) {
            if (stringArray[i].equalsIgnoreCase("-packetSize")) {
                if (++i < stringArray.length) {
                    this.size = Integer.parseInt(stringArray[i]);
                    continue;
                }
                System.err.println("Usage: NetworkTest -host <host> -packetSize <size> -packetCount <numPac>");
                return;
            }
            if (stringArray[i].equalsIgnoreCase("-packetCount")) {
                if (++i < stringArray.length) {
                    this.numPac = Integer.parseInt(stringArray[i]);
                    continue;
                }
                System.err.println("Usage: NetworkTest -host <host> -packetSize <size> -packetCount <numPac>");
                return;
            }
            if (stringArray[i].equalsIgnoreCase("-timeout")) {
                if (++i < stringArray.length) {
                    this.timeOut = Integer.parseInt(stringArray[i]) * 1000;
                    continue;
                }
                System.err.println("Usage: NetworkTest -host <host> -packetSize <size> -packetCount <numPac> -timeout <timeout>");
                return;
            }
            if (stringArray[i].equalsIgnoreCase("-packetInterval")) {
                if (++i < stringArray.length) {
                    this.packetInterval = Integer.parseInt(stringArray[i]);
                    continue;
                }
                System.err.println("Usage: NetworkTest -host <host> -packetSize <size> -packetCount <numPac> -timeout <timeout>");
                return;
            }
            if (!stringArray[i].equalsIgnoreCase("-targets")) continue;
            if (++i < stringArray.length) {
                string = stringArray[i];
                continue;
            }
            System.err.println("Usage: NetworkTest -host <host> -packetSize <size> -packetCount <numPac> -timeout <timeout>");
            return;
        }
        if (this.timeOut > 0 && this.numPac > 0) {
            this.defaultTimeout = this.timeout = (long)(this.timeOut * this.numPac);
        }
        String string3 = EgInstallInfo.getBinDir() + "nfping ";
        String string4 = " -t " + this.packetInterval + " -s " + this.size + " -n " + this.numPac + " -w " + this.timeOut + " -i";
        if (string != null && string.length() > 0 && !string.equalsIgnoreCase("none")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
            this.targets = new String[stringTokenizer.countTokens()];
            this.names = new String[this.targets.length];
            for (int i = 0; i < this.targets.length; ++i) {
                String string5 = stringTokenizer.nextToken().trim();
                int n = string5.indexOf(58);
                if (n < 0) {
                    this.targets[i] = string5;
                    this.names[i] = string5;
                } else {
                    this.names[i] = string5.substring(0, n);
                    this.targets[i] = string5.substring(n + 1);
                }
                this.procList.add(string3 + this.targets[i] + string4);
            }
        }
    }

    private double getVal(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (stringTokenizer.countTokens() < 1) {
            return -5.0;
        }
        String string2 = stringTokenizer.nextToken();
        try {
            double d = Double.parseDouble(string2);
            if (d < 0.0) {
                d = Math.abs(d);
            }
            return d / 1000.0;
        }
        catch (Exception exception) {
            return -5.0;
        }
    }

    public boolean executeTest() {
        this.initTest();
        if (this.targets != null && this.targets.length > 0) {
            boolean bl = true;
            for (int i = 0; i < this.targets.length; ++i) {
                this.realIndex = this.index + this.names[i];
                boolean bl2 = this.executeTest(this.targets[i]);
                if (bl2) continue;
                bl = false;
            }
            this.updateAllResultSets(true);
            return bl;
        }
        this.realIndex = this.index;
        boolean bl = this.executeTest(this.targetHost);
        this.updateAllResultSets();
        return bl;
    }

    private boolean executeTest(String string) {
        this.minDelay = -1.0;
        this.avgDelay = -1.0;
        this.lossPct = -1.0;
        String string2 = "cmd.exe /c " + EgInstallInfo.getBinDir() + "nfping " + string + " -t " + this.packetInterval + " -s " + this.size + " -n " + this.numPac + " -w " + this.timeOut + " -i";
        System.out.println("cmd =" + string2);
        long l = System.currentTimeMillis();
        EgUtilities egUtilities = EgUtilities.createInstance();
        ArrayList arrayList = egUtilities.getExecOutputLines(string2);
        long l2 = System.currentTimeMillis();
        System.out.println("NetworkTest for targetHost: " + this.targetHost + " reportingName: " + this.reportingName + " target: " + string + " took " + (l2 - l));
        if (arrayList == null || arrayList.size() < 2) {
            this.errorMsg = new String("Execution of nfping failed for this target " + string);
            this.addValueToResultSet(this.realIndex, minDelayIndex, -1.0);
            this.addValueToResultSet(this.realIndex, avgDelayIndex, -1.0);
            this.addValueToResultSet(this.realIndex, lossPctIndex, -1.0);
            if (this.numOutputFields > availabilityIndex) {
                this.addValueToResultSet(this.realIndex, availabilityIndex, -1.0);
            }
            return false;
        }
        ArrayList arrayList2 = (ArrayList)arrayList.get(0);
        if (arrayList2 == null || arrayList2.size() == 0) {
            this.errorMsg = new String("Execution of nfping failed for this target " + string);
            this.addValueToResultSet(this.realIndex, minDelayIndex, -1.0);
            this.addValueToResultSet(this.realIndex, avgDelayIndex, -1.0);
            this.addValueToResultSet(this.realIndex, lossPctIndex, -1.0);
            if (this.numOutputFields > availabilityIndex) {
                this.addValueToResultSet(this.realIndex, availabilityIndex, -1.0);
            }
            return false;
        }
        try {
            Object var13_8 = null;
            this.lossPct = -5.0;
            this.minDelay = -5.0;
            this.avgDelay = -5.0;
            for (int i = 0; i < arrayList2.size(); ++i) {
                String string3;
                String string4;
                StringTokenizer stringTokenizer;
                String string5 = (String)arrayList2.get(i);
                if (string5 == null) continue;
                if (string5.indexOf("% loss") >= 0) {
                    stringTokenizer = new StringTokenizer(string5, "%");
                    if (stringTokenizer.countTokens() < 2 || (string4 = stringTokenizer.nextToken()).indexOf("(") < 0 || (stringTokenizer = new StringTokenizer(string4, "(")).countTokens() < 2) continue;
                    stringTokenizer.nextToken();
                    string3 = stringTokenizer.nextToken();
                    try {
                        this.lossPct = Double.parseDouble(string3);
                    }
                    catch (Exception exception) {}
                    continue;
                }
                if (string5.indexOf("Minimum =") < 0 || string5.indexOf("Maximum =") < 0 || (stringTokenizer = new StringTokenizer(string5, "=")).countTokens() < 4) continue;
                stringTokenizer.nextToken();
                string4 = stringTokenizer.nextToken().trim();
                stringTokenizer.nextToken();
                string3 = stringTokenizer.nextToken().trim();
                this.minDelay = this.getVal(string4);
                this.avgDelay = this.getVal(string3);
            }
            if (this.lossPct > 100.0) {
                this.errorMsg = "packet loss is greater than 100  " + this.lossPct;
                this.logToErrorFile("ERROR", this.entity, this.errorMsg + " AL is " + arrayList + " Command was - " + string2 + "for the target " + string);
                this.lossPct = 100.0;
            }
            this.availability = this.lossPct == 100.0 ? 0 : (this.lossPct < 0.0 ? -5 : 100);
            this.addValueToResultSet(this.realIndex, minDelayIndex, this.minDelay);
            this.addValueToResultSet(this.realIndex, avgDelayIndex, this.avgDelay);
            this.addValueToResultSet(this.realIndex, lossPctIndex, this.lossPct);
            if (this.numOutputFields > availabilityIndex) {
                this.addValueToResultSet(this.realIndex, availabilityIndex, this.availability);
            }
            return true;
        }
        catch (Exception exception) {
            this.errorMsg = new String("Exception during nfping process for this target " + string + " " + exception.toString());
            this.logToErrorFile("Exception[" + this.realIndex + "]", this.entity, this.errorMsg);
            this.logToErrorFile("OUTPUT[" + this.realIndex + "]", this.entity, arrayList.toString());
            String string6 = "minDelay=>" + this.minDelay + " avgDelay =>" + this.avgDelay + " lossPct =>" + this.lossPct + "availability=>" + this.availability;
            this.logToErrorFile("ExceptionOutput[" + this.realIndex + "]", this.entity, string6);
            if (this.minDelay <= 0.0) {
                this.addValueToResultSet(this.realIndex, minDelayIndex, -1.0);
            } else {
                this.addValueToResultSet(this.realIndex, minDelayIndex, this.minDelay);
            }
            if (this.avgDelay <= 0.0) {
                this.addValueToResultSet(this.realIndex, avgDelayIndex, -1.0);
            } else {
                this.addValueToResultSet(this.realIndex, avgDelayIndex, this.avgDelay);
            }
            if (this.lossPct <= 0.0) {
                this.addValueToResultSet(this.realIndex, lossPctIndex, -1.0);
                this.availability = -1;
            } else {
                this.addValueToResultSet(this.realIndex, lossPctIndex, this.lossPct);
            }
            if (this.numOutputFields > availabilityIndex) {
                this.addValueToResultSet(this.realIndex, availabilityIndex, this.availability);
            }
            return false;
        }
    }

    public void killProcess() {
        if (this.isWindowsOS) {
            if (this.procList == null || this.procList.size() == 0) {
                System.out.println("NetworkTest procList is not set");
                return;
            }
            ArrayList arrayList = this.egutil.getPid(this.procList);
            if (arrayList != null && arrayList.size() > 0) {
                System.out.println("Killing Network Test processes " + arrayList);
                this.egutil.killProcesses(arrayList);
            }
        }
    }
}

