/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgInstallInfo;
import com.eg.EgSSL;
import com.eg.IniFile;
import com.eg.IniHelper;
import com.eg.apm.APMCleanUpUtils;
import com.eg.apm.APMComponentIDRepository;
import com.eg.apm.APMDiscoveryHelper;
import com.eg.apm.APMDiscoveryLogger;
import com.eg.apm.APMFileOperations;
import com.eg.apm.APMUtils;
import com.eg.apm.ApmConfigManager;
import com.eg.apm.ContainersService;
import com.eg.apm.KubernetesAPI;
import com.eg.jtm.BTMConstants;
import com.eg.org.slf4j.Logger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApmDiscoveryContributor
extends Thread {
    String sep = System.getProperty("file.separator");
    protected final String loggerDispStr = "[ApmDiscoveryContributor]";
    private static final String winCommand_1 = "cmd /c netstat -aonp tcp | findstr ";
    private static final String winCommand_2 = "| findstr LISTENING";
    private static final long minSleep = 50L;
    private static long lastModifiedTime = -1L;
    private static long lastAgentTestsModifiedTime = -1L;
    private static boolean agentDiscoverEnabled = true;
    private static long lastCleanupiniModifiedTime = -1L;
    private boolean isCleanUpEnabled = true;
    private static final String btmJarDefaultLogPath = EgInstallInfo.getInstallDir() + "/lib/apm/Java/default/logs";
    private String btmJarLogPath = "lib/apm/Java/default/logs";
    private static String btmJarLogPathWindows = "lib/apm/Java/default/logs";
    private String windowsTempPath = System.getenv("TEMP") + "/logs";
    private static final String linuxTempPath = "/tmp/logs";
    private static final String btmFileName = "BTMLog.log";
    private static final String cleanIni = EgInstallInfo.getInstallDir() + BTMConstants.APM_DISCOVERY_CLEANUP;
    private int cleanUpThreshold = 3;
    private int checkForEvery = 3;
    long threshTimeForDeletion = this.checkForEvery * 60 * 60 * 1000;
    private int dicoveryMaxWaitTime = 15;
    private HashMap unknownContainers = new HashMap();
    private HashMap<String, Long> manualHttpReq = new HashMap();
    private long lastBtmLogDeletionTime = -1L;
    private long lastApmIniModifiedTime = -1L;
    private long lastRunTime = 0L;
    private int customPort = 7011;
    public static final String kubeSync = new String("kube");

    public ApmDiscoveryContributor() {
        this.setDaemon(true);
        this.setName("ApmDiscoveryContributor");
        this.start();
        this.readFromini();
        APMDiscoveryLogger.discoveryLogger.info("{} ApmDiscoveryContributor Thread started ", (Object)"[ApmDiscoveryContributor]");
    }

    public ApmDiscoveryContributor(boolean bl) {
    }

    @Override
    public void run() {
        this.suspendThread(30000L);
        this.isAgentTestsIniUpdated();
        APMDiscoveryLogger.discoveryLogger.trace("{} agentDiscoverEnabled  : {} ", (Object)"[ApmDiscoveryContributor]", (Object)agentDiscoverEnabled);
        IniFile iniFile = new IniFile(EgInstallInfo.getInstallDir() + BTMConstants.AGENT_APM_FILEPATH);
        int n = this.getPort(iniFile, "APM_DISCOVERY", "Custom_Port_For_AutoManage");
        this.customPort = n > 0 ? n : 7011;
        ContainersService.initContainerClusterEnvDiscovery();
        while (true) {
            try {
                while (true) {
                    if (!agentDiscoverEnabled) {
                        this.suspendThread(180000L);
                        this.isAgentTestsIniUpdated();
                        APMDiscoveryLogger.discoveryLogger.trace("{} agentDiscoverEnabled  : {} ", (Object)"[ApmDiscoveryContributor]", (Object)agentDiscoverEnabled);
                        if (!agentDiscoverEnabled) {
                            APMDiscoveryLogger.discoveryLogger.trace("{} agentDiscoverEnabled  : {} , Skipping the process..", (Object)"[ApmDiscoveryContributor]", (Object)agentDiscoverEnabled);
                            continue;
                        }
                    }
                    boolean bl = this.discoveryIniUpdated();
                    long l = System.currentTimeMillis();
                    long l2 = l - this.lastRunTime;
                    boolean bl2 = false;
                    if (l2 >= 300000L) {
                        this.isAgentTestsIniUpdated();
                        bl2 = true;
                    }
                    if (APMDiscoveryLogger.discoveryLogger.isTraceEnabled()) {
                        APMDiscoveryLogger.discoveryLogger.trace("{} agentDiscoverEnabled  : {} ", (Object)"[ApmDiscoveryContributor]", (Object)agentDiscoverEnabled);
                        APMDiscoveryLogger.discoveryLogger.trace("{} lastRunTime  : {} ", (Object)"[ApmDiscoveryContributor]", (Object)this.lastRunTime);
                        APMDiscoveryLogger.discoveryLogger.trace("{} iniUpdated  : {} ", (Object)"[ApmDiscoveryContributor]", (Object)bl);
                        APMDiscoveryLogger.discoveryLogger.trace("{} doProcess  : {} ", (Object)"[ApmDiscoveryContributor]", (Object)bl2);
                        APMDiscoveryLogger.discoveryLogger.trace("{} fullyDiscoveredContainerIds : {} ", (Object)"[ApmDiscoveryContributor]", (Object)APMDiscoveryHelper.getDiscoveredList());
                    }
                    if (bl || bl2) {
                        this.processDiscoveryDetails();
                        this.processForManualHttpRequest();
                        this.findKubernetesServiceNames();
                        this.lastRunTime = System.currentTimeMillis();
                    } else {
                        APMDiscoveryLogger.discoveryLogger.trace("{} ApmDiscoveryContributor.run()  suspending thread for 10sec....", (Object)"[ApmDiscoveryContributor]");
                    }
                    this.processBtmJarLogFileDeletion();
                    if (this.apmIniUpdated()) {
                        this.readFromApmIni();
                    }
                    this.suspendThread(ApmConfigManager.getInstance().getDiscoveryContributorSleepTime());
                }
            }
            catch (Exception exception) {
                APMDiscoveryLogger.discoveryLogger.warn("{} Unable to do process discovery details : {}", (Object)"[ApmDiscoveryContributor]", (Object)exception);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void findKubernetesServiceNames() {
        if (!ContainersService.isKube()) {
            APMDiscoveryLogger.discoveryLogger.trace("{}  No Kubernetes Env found, Skipping findKubernetesServiceNames() process", (Object)"[ApmDiscoveryContributor]");
            return;
        }
        try {
            boolean bl = true;
            ArrayList<IniHelper> arrayList = new ArrayList<IniHelper>();
            ArrayList<IniHelper> arrayList2 = new ArrayList<IniHelper>();
            String string = kubeSync;
            synchronized (string) {
                IniFile iniFile = new IniFile(EgInstallInfo.getInstallDir() + BTMConstants.APM_DISCOVERY_FILEPATH);
                String string2 = "KUBERNETES_DETAILS_TEMP";
                String[] stringArray = iniFile.getVariables(string2);
                Vector vector = iniFile.getAllValues(string2);
                APMDiscoveryLogger.discoveryLogger.info("{}  Kubernetes Service Name Discovery Starting : {}", (Object)"[ApmDiscoveryContributor]", (Object)vector);
                APMDiscoveryLogger.discoveryLogger.info("{}  kubeValueList : {}", (Object)"[ApmDiscoveryContributor]", (Object)vector);
                APMDiscoveryLogger.discoveryLogger.info("{}  Kubernetes ip : {}, port : {}, ssl : {}, token : {} ", new Object[]{"[ApmDiscoveryContributor]", ContainersService.ip, ContainersService.port, ContainersService.ssl, ContainersService.serviceToken});
                if (stringArray != null && stringArray.length > 0) {
                    KubernetesAPI kubernetesAPI = new KubernetesAPI(ContainersService.ip, ContainersService.port, ContainersService.serviceToken, ContainersService.ssl);
                    for (int i = 0; i < stringArray.length; ++i) {
                        String string3 = stringArray[i];
                        if (i == 2 && !kubernetesAPI.isKubeMasterReachable()) {
                            APMDiscoveryLogger.discoveryLogger.warn("{} Kubernetes Master is unreachable, Skipping Kubernetes Service Name Discovery,  isKubeMasterReachable : {}", (Object)"[ApmDiscoveryContributor]", (Object)kubernetesAPI.isKubeMasterReachable());
                            return;
                        }
                        if (string3 == null || string3.length() <= 0) continue;
                        String string4 = (String)vector.get(i);
                        StringTokenizer stringTokenizer = new StringTokenizer(string4, ":");
                        String string5 = "";
                        String string6 = "";
                        int n = stringTokenizer.countTokens();
                        if (n != 2) continue;
                        string5 = stringTokenizer.nextToken();
                        string6 = stringTokenizer.nextToken();
                        HashMap hashMap = kubernetesAPI.getCachedServiceCopy(string6);
                        ArrayList arrayList3 = kubernetesAPI.getLabelNameFromPod(string6, string5);
                        bl = kubernetesAPI.isKubeMasterReachable();
                        APMDiscoveryLogger.discoveryLogger.trace("{}  Cached Service map : {}", (Object)"[ApmDiscoveryContributor]", (Object)hashMap);
                        APMDiscoveryLogger.discoveryLogger.debug("{}  Doing Kubernetes Service Name Discovery for Namespace - {}, Pod - {} labelList : {}", new Object[]{"[ApmDiscoveryContributor]", string6, string5, arrayList3});
                        String string7 = "";
                        if (arrayList3 != null && arrayList3.size() > 0) {
                            string7 = (String)arrayList3.get(0);
                        }
                        boolean bl2 = false;
                        String string8 = "";
                        if (string7 == null || string7.length() <= 0) continue;
                        try {
                            if (hashMap != null && hashMap.containsKey(string7)) {
                                bl2 = true;
                                string8 = (String)hashMap.get(string7);
                            } else {
                                string8 = kubernetesAPI.getServicename(string6, string7);
                                bl2 = true;
                            }
                            APMDiscoveryLogger.discoveryLogger.trace("{}  serviceName : {}", (Object)"[ApmDiscoveryContributor]", (Object)string8);
                            if (!bl2) continue;
                            String string9 = string4 + ":" + string8;
                            arrayList.add(this.getIniHelper("KUBERNETES_DETAILS", string3, string9));
                            arrayList2.add(this.getIniHelper(string2, string3, string3));
                            continue;
                        }
                        catch (Exception exception) {
                            APMDiscoveryLogger.discoveryLogger.warn("{} Unable to do port finding : ", (Object)"[ApmDiscoveryContributor]", (Object)exception);
                        }
                    }
                }
                boolean bl3 = this.storeToIni(arrayList, arrayList2);
                if (APMDiscoveryLogger.discoveryLogger.isTraceEnabled()) {
                    APMDiscoveryLogger.discoveryLogger.trace("{} ServiceName addThis    : {}", (Object)"[ApmDiscoveryContributor]", arrayList);
                    APMDiscoveryLogger.discoveryLogger.trace("{} ServiceName deleteThis :   {}", (Object)"[ApmDiscoveryContributor]", arrayList2);
                    APMDiscoveryLogger.discoveryLogger.trace("{} ServiceName stored : {}", (Object)"[ApmDiscoveryContributor]", (Object)bl3);
                }
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Unable to process kunernetes service name discovery details : {}", (Object)"[ApmDiscoveryContributor]", (Object)exception);
        }
    }

    int getPort(IniFile iniFile, String string, String string2) {
        try {
            String string3 = iniFile.getValue(string, string2);
            if (string3 != null && string3.length() > 0) {
                int n = Integer.parseInt(string3);
                return n;
            }
        }
        catch (NumberFormatException numberFormatException) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Exception while retriving port from ini!!...{} ", (Object)"[ApmDiscoveryContributor]", (Object)numberFormatException);
        }
        return 0;
    }

    private boolean isMaxDiscoveryTimeReached(String string, long l, long l2) {
        boolean bl = false;
        try {
            if (this.manualHttpReq.containsKey(string)) {
                long l3 = this.manualHttpReq.get(string);
                long l4 = l2 - l3;
                if (l >= l4) {
                    bl = true;
                }
            } else {
                bl = true;
                this.manualHttpReq.put(string, l2);
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Unable to do process isMaxDiscoveryTimeReached() : {}", (Object)"[ApmDiscoveryContributor]", (Object)exception);
        }
        return bl;
    }

    private void processForManualHttpRequest() {
        try {
            ArrayList<IniHelper> arrayList = new ArrayList<IniHelper>();
            ArrayList arrayList2 = new ArrayList();
            ArrayList<IniHelper> arrayList3 = new ArrayList<IniHelper>();
            IniFile iniFile = new IniFile(EgInstallInfo.getInstallDir() + BTMConstants.APM_DISCOVERY_FILEPATH);
            String string = "JAVA_SERVER_DETAILS_DO_HTTP_REQ";
            String[] stringArray = iniFile.getVariables(string);
            Vector vector = iniFile.getAllValues(string);
            long l = this.dicoveryMaxWaitTime * 60 * 1000;
            long l2 = System.currentTimeMillis();
            for (int i = 0; i < stringArray.length; ++i) {
                String string2;
                StringTokenizer stringTokenizer;
                int n;
                String string3 = stringArray[i];
                if (string3 == null || string3.length() <= 0 || (n = (stringTokenizer = new StringTokenizer(string2 = (String)vector.get(i), "#~#")).countTokens()) != 3) continue;
                String string4 = stringTokenizer.nextToken();
                String string5 = stringTokenizer.nextToken();
                if (!APMDiscoveryHelper.isInDiscoverdList(string5) && this.isMaxDiscoveryTimeReached(string5, l, l2)) {
                    String string6 = stringTokenizer.nextToken();
                    ArrayList<String> arrayList4 = this.getAllAvailablePort(string4);
                    APMDiscoveryLogger.discoveryLogger.trace("{}  Port list {} for  {} :{}", new Object[]{"[ApmDiscoveryContributor]", arrayList4, string3, string5});
                    APMDiscoveryLogger.discoveryLogger.debug("{}  Going to do Http request for {} :{}  {}", new Object[]{"[ApmDiscoveryContributor]", string3, string4, string5});
                    this.doManualHttpRequest(string3, arrayList4);
                    continue;
                }
                this.manualHttpReq.remove(string5);
                arrayList.add(APMUtils.getIniHelper((String)string, (String)string3, (String)string3));
                arrayList3.add(APMUtils.getIniHelper((String)"JAVA_SERVER_DETAILS_HTTP_CALL_DONE", (String)(string4 + "@" + string3), (String)string2));
                APMDiscoveryLogger.discoveryLogger.trace("{} {} is in discoverd list so skipping manual request for  {}:{} ", new Object[]{"[ApmDiscoveryContributor]", string5, string3, string4});
            }
            APMDiscoveryHelper.storeToIni(arrayList2, arrayList);
            if (ApmConfigManager.getInstance().isSaveDetailsOnTempFile()) {
                APMDiscoveryHelper.saveToIni(APMCleanUpUtils.getTrashFileName(), arrayList3, null);
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Unable to do process processForManualHttpRequest() : {} ", (Object)"[ApmDiscoveryContributor]", (Object)exception);
        }
    }

    public String makeGetRequest(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            try {
                APMDiscoveryLogger.discoveryLogger.trace("{}  Doing Http request to {} with  {}", new Object[]{"[ApmDiscoveryContributor]", string, string2});
                URL uRL = new URL(string);
                HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
                httpURLConnection.setRequestMethod("GET");
                httpURLConnection.setRequestProperty("User-Agent", string2);
                int n = httpURLConnection.getResponseCode();
                stringBuilder.append(" <h1>Response Code :</h1>").append(n);
                if (n != 200) {
                    stringBuilder.append("GET request not worked : ");
                }
            }
            catch (Exception exception) {
                stringBuilder.append(exception.getCause());
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Unable to do make http url hit  : {}", (Object)"[ApmDiscoveryContributor]", (Object)exception);
        }
        return stringBuilder.toString();
    }

    private void enableSsl() {
        EgSSL egSSL = EgSSL.getInstance();
        egSSL.enableSSL();
        SSLSocketFactory sSLSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        Object var3_3 = null;
        try {
            MyX509TrustManager myX509TrustManager = new MyX509TrustManager();
            KeyManager[] keyManagerArray = null;
            TrustManager[] trustManagerArray = new TrustManager[]{myX509TrustManager};
            SSLContext sSLContext = SSLContext.getInstance("SSL");
            sSLContext.init(keyManagerArray, trustManagerArray, new SecureRandom());
            SSLSocketFactory sSLSocketFactory2 = sSLContext.getSocketFactory();
            HttpsURLConnection.setDefaultSSLSocketFactory(sSLSocketFactory2);
            HttpsURLConnection.setDefaultHostnameVerifier((HostnameVerifier)new MyHostnameVerifier());
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Unable to enable ssl to  make Http Request : {}", (Object)"[ApmDiscoveryContributor]", (Object)exception);
        }
    }

    private void doManualHttpRequest(String string, ArrayList arrayList) {
        try {
            if (arrayList != null && arrayList.size() > 0) {
                int n;
                for (n = 0; n < arrayList.size(); ++n) {
                    try {
                        int n2 = Integer.parseInt((String)arrayList.get(n));
                        this.hitTheUrl(string, n2);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        APMDiscoveryLogger.discoveryLogger.warn("{} Unable to do process doManualHttpRequest() :{} ", (Object)"[ApmDiscoveryContributor]", (Object)numberFormatException);
                    }
                }
                if (!arrayList.contains("80")) {
                    n = Integer.parseInt("80");
                    this.hitTheUrl(string, n);
                }
                if (!arrayList.contains("8080")) {
                    n = Integer.parseInt("8080");
                    this.hitTheUrl(string, n);
                }
                if (!arrayList.contains("443")) {
                    n = Integer.parseInt("443");
                    this.hitTheUrl(string, n);
                }
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Unable to do process doManualHttpRequest() : {}", (Object)"[ApmDiscoveryContributor]", (Object)exception);
        }
    }

    private void hitTheUrl(String string, int n) {
        try {
            String string2 = "http://" + string + ":" + n + "/";
            String string3 = "https://" + string + ":" + n + "/";
            String string4 = "Mozilla/5.0";
            this.makeGetRequest(string2, string4);
            this.enableSsl();
            this.makeGetRequest(string3, string4);
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Unable to do process discovery details : {}", (Object)"[ApmDiscoveryContributor]", (Object)exception);
        }
    }

    public ArrayList<String> getAllAvailablePort(String string) {
        String string2 = System.getProperty("os.name").toLowerCase();
        Runtime runtime = Runtime.getRuntime();
        if (string2.indexOf("win") >= 0) {
            try {
                Process process = runtime.exec(winCommand_1 + string + winCommand_2);
                ArrayList<String> arrayList = this.getPortUsingPid(process, "win");
                APMDiscoveryLogger.discoveryLogger.debug("{} Windows mode retrived all listening port for Pid [{}]", (Object)"[ApmDiscoveryContributor]", (Object)string);
                return arrayList;
            }
            catch (Exception exception) {
                APMDiscoveryLogger.discoveryLogger.warn("{} Exception occurred while executing [Windows command] to get ports and PID - {} ", (Object)"[ApmDiscoveryContributor]", (Object)exception);
            }
        } else if (string2.indexOf("nix") > -1 || string2.indexOf("nux") > -1 || string2.indexOf("aix") > -1) {
            String[] stringArray = new String[]{"/bin/sh", "-c", "netstat -anlp | grep " + string + " | grep LISTEN"};
            try {
                Process process = runtime.exec(stringArray);
                ArrayList<String> arrayList = this.getPortUsingPid(process, "linux");
                APMDiscoveryLogger.discoveryLogger.debug("{} Linux mode retrived all listening port for Pid [{}]", (Object)"[ApmDiscoveryContributor]", (Object)string);
                return arrayList;
            }
            catch (Exception exception) {
                APMDiscoveryLogger.discoveryLogger.warn("{} Exception occurred while executing [Linux command] to get ports and PID.... ", (Object)"[ApmDiscoveryContributor]", (Object)exception);
            }
        } else {
            APMDiscoveryLogger.discoveryLogger.debug("{} Unsuported OS: unable to get port details for Pid: [{}] return false ", (Object)"[ApmDiscoveryContributor]", (Object)string);
            return null;
        }
        return null;
    }

    private ArrayList<String> getPortUsingPid(Process process, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                int n;
                String string3;
                StringTokenizer stringTokenizer;
                String string4;
                if (string.equals("win")) {
                    string4 = string2.trim().replaceAll(" +", "#");
                    stringTokenizer = new StringTokenizer(string4, "#");
                    stringTokenizer.nextElement();
                    string3 = (String)stringTokenizer.nextElement();
                    if (string3 == null || (n = string3.indexOf(":")) <= -1) continue;
                    arrayList.add(string3.substring(n + 1));
                    continue;
                }
                string4 = string2.trim().replaceAll(" +", "#");
                stringTokenizer = new StringTokenizer(string4, "#");
                stringTokenizer.nextElement();
                stringTokenizer.nextElement();
                stringTokenizer.nextElement();
                string3 = (String)stringTokenizer.nextElement();
                if (string3 == null || (n = string3.indexOf(":")) <= -1) continue;
                String string5 = string3.substring(n);
                arrayList.add(string5.replaceAll(":", "").trim());
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Exception occurred while getting Port using master PID - {} ", (Object)"[ApmDiscoveryContributor]", (Object)exception);
        }
        return arrayList;
    }

    void processBtmJarLogFileDeletion() {
        try {
            long l = System.currentTimeMillis() - this.lastBtmLogDeletionTime;
            APMDiscoveryLogger.discoveryLogger.trace("{} lastBtmLogDeletionTime  : {} , checkForEvery : {}", new Object[]{"[ApmDiscoveryContributor]", this.lastBtmLogDeletionTime, this.checkForEvery});
            if (l >= this.threshTimeForDeletion) {
                Hashtable hashtable;
                this.lastBtmLogDeletionTime = System.currentTimeMillis();
                if (this.cleanupIniUpdated()) {
                    this.readFromini();
                }
                if (!this.isCleanUpEnabled) {
                    APMDiscoveryLogger.discoveryLogger.info("{} APM Discovery - BTM Jar log folder cleanup is not enabled", (Object)"[ApmDiscoveryContributor]");
                    return;
                }
                DockerContainers dockerContainers = this.getDockerInstance();
                if (dockerContainers != null && dockerContainers.isDockerServer) {
                    hashtable = this.getBtmjarLogFolderNames(this.btmJarLogPath);
                    this.processForDockerContainers(this.btmJarLogPath, hashtable, dockerContainers);
                }
                if (APMUtils.isWindows) {
                    hashtable = this.getBtmjarLogFolderNames(btmJarLogPathWindows);
                    this.processForStandAlone(btmJarLogPathWindows, hashtable);
                } else {
                    hashtable = this.getBtmjarLogFolderNames(this.btmJarLogPath);
                    this.processForStandAlone(this.btmJarLogPath, hashtable);
                }
                hashtable = this.getBtmjarLogFolderNames(btmJarDefaultLogPath);
                this.processForStandAlone(btmJarDefaultLogPath, hashtable);
                if (APMUtils.isWindows) {
                    hashtable = this.getBtmjarLogFolderNames(this.windowsTempPath);
                    this.processForStandAlone(this.windowsTempPath, hashtable);
                } else {
                    hashtable = this.getBtmjarLogFolderNames(linuxTempPath);
                    this.processForStandAlone(linuxTempPath, hashtable);
                }
                HashMap hashMap = this.getPathsSentByBTMJar();
                this.processIndividualPath(hashMap);
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Unable to do apm discvoery log deletion process :{} ", (Object)"[ApmDiscoveryContributor]", (Object)exception);
        }
    }

    private HashMap getPathsSentByBTMJar() {
        Hashtable hashtable = new Hashtable();
        IniFile iniFile = new IniFile(cleanIni);
        return APMUtils.getLinesAsMap((IniFile)iniFile, (String)"LOG_PATHS", (Logger)APMDiscoveryLogger.discoveryLogger);
    }

    private void processIndividualPath(HashMap hashMap) {
        if (hashMap.size() < 0) {
            return;
        }
        Iterator iterator = hashMap.entrySet().iterator();
        APMFileOperations aPMFileOperations = new APMFileOperations();
        long l = System.currentTimeMillis();
        long l2 = this.cleanUpThreshold * 60 * 60 * 1000;
        ArrayList<IniHelper> arrayList = new ArrayList<IniHelper>();
        while (iterator.hasNext()) {
            try {
                Map.Entry entry = iterator.next();
                String string = (String)entry.getKey();
                String string2 = (String)entry.getValue();
                string2 = string2.substring(string2.indexOf("^") + 1);
                File file = new File(string2);
                if (file.exists()) {
                    String string3;
                    long l3 = file.lastModified();
                    if (l - l3 < l2 || !aPMFileOperations.deleteDirectory(string3 = string2.replace(btmFileName, ""))) continue;
                    APMDiscoveryLogger.discoveryLogger.warn("{} Old eG_BTM log folder [{}] has been deleted ", (Object)"[ApmDiscoveryContributor]", (Object)string3);
                    arrayList.add(APMUtils.getIniHelper((String)"LOG_PATHS", (String)string, (String)string));
                    continue;
                }
                arrayList.add(APMUtils.getIniHelper((String)"LOG_PATHS", (String)string, (String)string));
            }
            catch (Exception exception) {
                APMDiscoveryLogger.discoveryLogger.warn("{} Unable to do log folder deletion process for a specific foldername : {}", (Object)"[ApmDiscoveryContributor]", (Object)exception);
            }
        }
        if (arrayList.size() > 0) {
            APMDiscoveryHelper.saveToIni(cleanIni, null, arrayList);
            APMDiscoveryLogger.discoveryLogger.trace("{} Remove log paths from ini  : {} ", (Object)"[ApmDiscoveryContributor]", arrayList);
        }
    }

    private void processForStandAlone(String string, Hashtable hashtable) {
        if (hashtable.size() < 0) {
            return;
        }
        APMDiscoveryLogger.discoveryLogger.info("{} Log path : {}, logFolderNamemap  : {}", new Object[]{"[ApmDiscoveryContributor]", string, hashtable});
        Iterator iterator = hashtable.entrySet().iterator();
        APMFileOperations aPMFileOperations = new APMFileOperations();
        long l = System.currentTimeMillis();
        long l2 = this.cleanUpThreshold * 60 * 60 * 1000;
        while (iterator.hasNext()) {
            try {
                String string2;
                Map.Entry entry = iterator.next();
                String string3 = (String)entry.getKey();
                long l3 = (Long)entry.getValue();
                long l4 = l - l3;
                if (l4 < l2 || !aPMFileOperations.deleteDirectory(string2 = string + File.separator + string3)) continue;
                APMDiscoveryLogger.discoveryLogger.warn("{} Old eG_BTM log folder [{}] that belongs to {} has been deleted ", new Object[]{"[ApmDiscoveryContributor]", string2, string3});
            }
            catch (Exception exception) {
                APMDiscoveryLogger.discoveryLogger.warn("{} Unable to do log folder deletion process for specific foldername {}", (Object)"[ApmDiscoveryContributor]", (Object)exception);
            }
        }
    }

    private void processForDockerContainers(String string, Hashtable hashtable, DockerContainers dockerContainers) {
        if (hashtable.size() < 0) {
            return;
        }
        Hashtable hashtable2 = dockerContainers.getRunningContainerIpDetails();
        if (hashtable2 == null) {
            hashtable2 = new Hashtable();
        }
        APMDiscoveryLogger.discoveryLogger.info("{} ipMap  : {}", (Object)"[ApmDiscoveryContributor]", hashtable2);
        APMDiscoveryLogger.discoveryLogger.info("{} Log path : {}, logFolderNamemap  : {}", new Object[]{"[ApmDiscoveryContributor]", string, hashtable});
        Iterator iterator = hashtable.entrySet().iterator();
        APMFileOperations aPMFileOperations = new APMFileOperations();
        long l = System.currentTimeMillis();
        long l2 = this.cleanUpThreshold * 60 * 60 * 1000;
        while (iterator.hasNext()) {
            try {
                String string2;
                Map.Entry entry = iterator.next();
                String string3 = (String)entry.getKey();
                long l3 = (Long)entry.getValue();
                long l4 = l - l3;
                if (l4 < l2 || hashtable2.containsKey(string3) || !aPMFileOperations.deleteDirectory(string2 = string + File.separator + string3)) continue;
                APMDiscoveryLogger.discoveryLogger.warn("{} Old eG_BTM log folder [{}] that belongs to {} has been deleted ", new Object[]{"[ApmDiscoveryContributor]", string2, string3});
            }
            catch (Exception exception) {
                APMDiscoveryLogger.discoveryLogger.warn("{} Unable to do log folder deletion process for specific foldername : {}", (Object)"[ApmDiscoveryContributor]", (Object)exception);
            }
        }
    }

    private Hashtable getBtmjarLogFolderNames(String string) {
        Hashtable<Object, Long> hashtable = new Hashtable<Object, Long>();
        try {
            String string2 = string;
            File file = new File(string2);
            boolean bl = file.exists();
            boolean bl2 = file.canWrite();
            APMDiscoveryLogger.discoveryLogger.debug("{} Log path : {}, isExist : {} , canWrite :{} ", new Object[]{"[ApmDiscoveryContributor]", string, bl, bl2});
            if (!bl || !bl2) {
                return hashtable;
            }
            Object[] objectArray = file.list(new FilenameFilter(){

                public boolean accept(File file, String string) {
                    return new File(file, string).isDirectory();
                }
            });
            APMDiscoveryLogger.discoveryLogger.debug("{} Available folder names under {} : {} ", new Object[]{"[ApmDiscoveryContributor]", this.btmJarLogPath, Arrays.toString(objectArray)});
            if (objectArray != null && objectArray.length > 0) {
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    String string3 = string2 + File.separator + (String)object + File.separator + btmFileName;
                    File file2 = new File(string3);
                    if (!file2.exists()) continue;
                    long l = file2.lastModified();
                    hashtable.put(object, l);
                }
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Unable to get BTM jar log folder name from {}: ", new Object[]{"[ApmDiscoveryContributor]", this.btmJarLogPath, exception});
        }
        return hashtable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readFromini() {
        boolean bl = false;
        String string = null;
        String string2 = null;
        int n = 3;
        int n2 = 3;
        try {
            block14: {
                try {
                    IniFile iniFile = new IniFile(cleanIni);
                    String string3 = iniFile.getValue("APM_DISCOVERY_CLEANUP", "Apm_Discovery_Cleanup");
                    string3 = string3.trim();
                    if (string3 != null && string3.length() > 0) {
                        bl = Boolean.parseBoolean(string3);
                    }
                    String string4 = iniFile.getValue("APM_DISCOVERY_CLEANUP", "Btm_Jar_Log_Location");
                    if ((string4 = string4.trim()) != null && string4.length() > 0) {
                        string = string4;
                    }
                    String string5 = iniFile.getValue("APM_DISCOVERY_CLEANUP", "Btm_Jar_Log_Location_Windows");
                    if ((string5 = string5.trim()) != null && string5.length() > 0) {
                        string2 = string5;
                    }
                    String string6 = iniFile.getValue("APM_DISCOVERY_CLEANUP", "Log_Cleanup_Threshold");
                    if ((string6 = string6.trim()) != null && string6.length() > 0) {
                        n = Integer.parseInt(string6);
                    }
                    String string7 = iniFile.getValue("APM_DISCOVERY_CLEANUP", "Check_Update_For_Btm_Logs");
                    if ((string7 = string7.trim()) == null || string7.length() <= 0) break block14;
                    n2 = Integer.parseInt(string7);
                }
                catch (Exception exception) {
                    APMDiscoveryLogger.discoveryLogger.warn("{} Unable to read discovery clean up ini : ", (Object)"[ApmDiscoveryContributor]", (Object)exception);
                    Object var13_14 = null;
                    this.isCleanUpEnabled = bl;
                    this.cleanUpThreshold = n;
                    this.checkForEvery = n2;
                    this.threshTimeForDeletion = this.checkForEvery * 60 * 60 * 1000;
                    if (string != null && string.length() > 0) {
                        this.btmJarLogPath = string;
                    }
                    if (string2 != null && string2.length() > 0) {
                        btmJarLogPathWindows = string2;
                    }
                    APMDiscoveryLogger.discoveryLogger.info("{} isCleanUpEnabled : {}, btmLogPath : {}, btmJarLogPathWindows : {}, cleanUpThreshold : {}, checkForEvery : {}, lastBtmLogDeletionTime : {}, windowsTempPath : {}, linuxTempPath : {}, btmJarDefaultLogPath : {} ", new Object[]{"[ApmDiscoveryContributor]", this.isCleanUpEnabled, this.btmJarLogPath, btmJarLogPathWindows, this.cleanUpThreshold, this.checkForEvery, this.lastBtmLogDeletionTime, this.windowsTempPath, linuxTempPath, btmJarDefaultLogPath});
                    return;
                }
            }
            Object var13_13 = null;
            this.isCleanUpEnabled = bl;
            this.cleanUpThreshold = n;
            this.checkForEvery = n2;
            this.threshTimeForDeletion = this.checkForEvery * 60 * 60 * 1000;
            if (string != null && string.length() > 0) {
                this.btmJarLogPath = string;
            }
            if (string2 != null && string2.length() > 0) {
                btmJarLogPathWindows = string2;
            }
            APMDiscoveryLogger.discoveryLogger.info("{} isCleanUpEnabled : {}, btmLogPath : {}, btmJarLogPathWindows : {}, cleanUpThreshold : {}, checkForEvery : {}, lastBtmLogDeletionTime : {}, windowsTempPath : {}, linuxTempPath : {}, btmJarDefaultLogPath : {} ", new Object[]{"[ApmDiscoveryContributor]", this.isCleanUpEnabled, this.btmJarLogPath, btmJarLogPathWindows, this.cleanUpThreshold, this.checkForEvery, this.lastBtmLogDeletionTime, this.windowsTempPath, linuxTempPath, btmJarDefaultLogPath});
            return;
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            this.isCleanUpEnabled = bl;
            this.cleanUpThreshold = n;
            this.checkForEvery = n2;
            this.threshTimeForDeletion = this.checkForEvery * 60 * 60 * 1000;
            if (string != null && string.length() > 0) {
                this.btmJarLogPath = string;
            }
            if (string2 != null && string2.length() > 0) {
                btmJarLogPathWindows = string2;
            }
            APMDiscoveryLogger.discoveryLogger.info("{} isCleanUpEnabled : {}, btmLogPath : {}, btmJarLogPathWindows : {}, cleanUpThreshold : {}, checkForEvery : {}, lastBtmLogDeletionTime : {}, windowsTempPath : {}, linuxTempPath : {}, btmJarDefaultLogPath : {} ", new Object[]{"[ApmDiscoveryContributor]", this.isCleanUpEnabled, this.btmJarLogPath, btmJarLogPathWindows, this.cleanUpThreshold, this.checkForEvery, this.lastBtmLogDeletionTime, this.windowsTempPath, linuxTempPath, btmJarDefaultLogPath});
            throw throwable;
        }
    }

    void processDiscoveryDetails() {
        try {
            ArrayList<IniHelper> arrayList = new ArrayList<IniHelper>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            ArrayList<IniHelper> arrayList3 = new ArrayList<IniHelper>();
            IniFile iniFile = new IniFile(EgInstallInfo.getInstallDir() + BTMConstants.APM_DISCOVERY_FILEPATH);
            String string = "JAVA_SERVER_DETAILS_CONTAINER_BASED_TEMP";
            String string2 = "JAVA_UNIQUE_GUID_MAPPING_TEMP";
            String string3 = "APPFLOW_SERVICE_AUTO_NAME_MAPPING_TEMP";
            String[] stringArray = iniFile.getVariables(string);
            Vector vector = iniFile.getAllValues(string);
            String[] stringArray2 = iniFile.getVariables(string2);
            Vector vector2 = iniFile.getAllValues(string2);
            Vector<String> vector3 = new Vector<String>();
            vector3.addAll(Arrays.asList(stringArray2));
            String[] stringArray3 = iniFile.getLinesUnderSubject(string3);
            HashMap hashMap = APMDiscoveryHelper.getLinesAsMap(stringArray3);
            boolean bl = false;
            if (stringArray != null && stringArray.length > 0) {
                DockerContainers dockerContainers = this.getDockerInstance();
                Hashtable hashtable = new Hashtable();
                Hashtable hashtable2 = new Hashtable();
                if (dockerContainers != null && dockerContainers.isDockerServer) {
                    bl = true;
                }
                if (bl) {
                    hashtable = dockerContainers.getRunningContainerIpDetails();
                    hashtable2 = dockerContainers.getContinerPortDetails();
                }
                if (APMDiscoveryLogger.discoveryLogger.isInfoEnabled()) {
                    APMDiscoveryLogger.discoveryLogger.trace("{}  is Docker Server : {}", (Object)"[ApmDiscoveryContributor]", (Object)bl);
                    APMDiscoveryLogger.discoveryLogger.trace("{}  Container Docker port map() : {}", (Object)"[ApmDiscoveryContributor]", (Object)hashtable2);
                    APMDiscoveryLogger.discoveryLogger.trace("{}  Container Docker ip map() : {}", (Object)"[ApmDiscoveryContributor]", (Object)hashtable);
                    APMDiscoveryLogger.discoveryLogger.info("{}  tempAppNameMap() : {}", (Object)"[ApmDiscoveryContributor]", (Object)hashMap);
                    APMDiscoveryLogger.discoveryLogger.info("{} unknownContainers  : {}", (Object)"[ApmDiscoveryContributor]", (Object)this.unknownContainers);
                }
                for (int i = 0; i < stringArray.length; ++i) {
                    String string4 = stringArray[i];
                    if (string4 == null || string4.length() <= 0) continue;
                    APMDiscoveryLogger.discoveryLogger.trace("{}  Doing docker port check for  : {}", (Object)"[ApmDiscoveryContributor]", (Object)string4);
                    StringTokenizer stringTokenizer = new StringTokenizer(string4, ":");
                    String string5 = "";
                    String string6 = "";
                    int n = stringTokenizer.countTokens();
                    if (n != 3) continue;
                    String string7 = stringTokenizer.nextToken();
                    string6 = stringTokenizer.nextToken();
                    string5 = stringTokenizer.nextToken();
                    boolean bl2 = false;
                    int n2 = 0;
                    if (string7 == null || string7.length() <= 0) continue;
                    try {
                        String string8;
                        String string9;
                        int n3;
                        if (hashtable2.containsKey(string7)) {
                            bl2 = true;
                            n2 = Integer.parseInt((String)hashtable2.get(string7));
                        } else {
                            if (bl) {
                                n2 = dockerContainers.getDockerPort(string7);
                                APMDiscoveryLogger.discoveryLogger.info("{} dockerContainerName: {}, getDockerPort() : {}", new Object[]{"[ApmDiscoveryContributor]", string7, n2});
                            }
                            if (n2 == 0) {
                                if (bl) {
                                    n2 = dockerContainers.getPodPort(string7);
                                    APMDiscoveryLogger.discoveryLogger.info("{} dockerContainerName: {}, getPodPort(): {}", new Object[]{"[ApmDiscoveryContributor]", string7, n2});
                                }
                                if (n2 != 0) {
                                    bl2 = true;
                                }
                            } else {
                                bl2 = true;
                            }
                        }
                        if (hashtable.containsKey(string7) && n2 == 0) {
                            if (ApmConfigManager.getInstance().isManageByCustomPortForDocker()) {
                                n2 = this.customPort > 0 ? this.customPort : 7011;
                                APMDiscoveryLogger.discoveryLogger.warn("{} {} port not found in 'docker inspect' cmd but its is available in list of running containers, so considering this as ghost container and using {} to manage the component.", new Object[]{"[ApmDiscoveryContributor]", string7, n2});
                                bl2 = true;
                            } else {
                                APMDiscoveryLogger.discoveryLogger.warn("{} DOCKER DISCOVERY - Unable to discover port for {}, So, Skipping the auto manage. Component type :{} , Contaiener ID :{} , ", new Object[]{"[ApmDiscoveryContributor]", string7, string5, string7});
                            }
                        }
                        if (bl2) {
                            boolean bl3 = this.isReachedToMaximumDeletionCounter(string4);
                            if (bl3) {
                                APMDiscoveryLogger.discoveryLogger.warn("{} {} is in unknown container list and reached maximum counter for deletion and adding to deletion list.", new Object[]{"[ApmDiscoveryContributor]", string7, string4});
                                arrayList3.add(this.getIniHelper(string, string4, string4));
                                arrayList3.add(this.getIniHelper(string2, string4, string4));
                                this.unknownContainers.remove(string4);
                            } else {
                                APMDiscoveryLogger.discoveryLogger.warn("{} container ip & port not found for {} & adding it into unknown containers list ", (Object)"[ApmDiscoveryContributor]", (Object)string7);
                                this.addToUnKnownContainers(string4);
                            }
                        }
                        if (!bl2) continue;
                        String string10 = string7 + ":" + n2 + ":" + string5;
                        String string11 = (String)vector.get(i);
                        if (string11 != null) {
                            string11 = string11.replace("#~#0#~#", "#~#" + n2 + "#~#");
                        }
                        if ((n3 = vector3.indexOf(string4)) <= -1 || (string9 = (String)vector2.get(n3)) == null || string9.length() <= 0) continue;
                        if (!arrayList2.contains(string9) && !APMDiscoveryHelper.isInDiscoverdList(string9)) {
                            arrayList.add(this.getIniHelper("JAVA_UNIQUE_GUID_MAPPING", string10, string9));
                            arrayList.add(this.getIniHelper("JAVA_SERVER_DETAILS_CONTAINER_BASED", string10, string11));
                            arrayList.add(this.getIniHelper("JAVA_SERVER_DETAILS_DISCOVERD_TIME", string10, System.currentTimeMillis() + ""));
                            string8 = (String)hashMap.get(string4);
                            if (string8 != null && string8.length() > 0) {
                                arrayList.add(this.getIniHelper("APPFLOW_SERVICE_AUTO_NAME_MAPPING", string10, string8));
                                arrayList3.add(this.getIniHelper(string3, string4, string4));
                            }
                            arrayList3.add(this.getIniHelper(string2, string4, string4));
                            arrayList3.add(this.getIniHelper(string, string4, string4));
                            arrayList2.add(string9);
                            if (!APMComponentIDRepository.isThisManaged((String)string10)) continue;
                            String string12 = APMComponentIDRepository.getJvmGuidFromTemp((String)string10);
                            APMComponentIDRepository.addToTempComponentRepository((String)string12, (String)string9);
                            APMComponentIDRepository.addToTempComponentRepository((String)string9, (String)string12);
                            APMDiscoveryLogger.discoveryLogger.info("{} {} is already discovered and auto-managed with {}:{}, Skipping port docker finding and registering temporary id into repo", new Object[]{"[ApmDiscoveryContributor]", string9, string10, string12});
                            continue;
                        }
                        if (APMDiscoveryHelper.isInDiscoverdList(string9)) {
                            APMDiscoveryLogger.discoveryLogger.warn("{} {} Already discovered, so skipping port finding for [{}] and adding to delete list : ", new Object[]{"[ApmDiscoveryContributor]", string9, string4});
                        }
                        if ((string8 = (String)hashMap.get(string4)) != null && string8.length() > 0) {
                            arrayList3.add(this.getIniHelper(string3, string4, string4));
                        }
                        arrayList3.add(this.getIniHelper(string2, string4, string4));
                        arrayList3.add(this.getIniHelper(string, string4, string4));
                        continue;
                    }
                    catch (Exception exception) {
                        APMDiscoveryLogger.discoveryLogger.warn("{} Unable to do port finding : {}", (Object)"[ApmDiscoveryContributor]", (Object)exception);
                    }
                }
            }
            boolean bl4 = this.storeToIni(arrayList, arrayList3);
            if (APMDiscoveryLogger.discoveryLogger.isTraceEnabled()) {
                APMDiscoveryLogger.discoveryLogger.trace("{} addThis    : {}", (Object)"[ApmDiscoveryContributor]", arrayList);
                APMDiscoveryLogger.discoveryLogger.trace("{} deleteThis :  {}", (Object)"[ApmDiscoveryContributor]", arrayList3);
                APMDiscoveryLogger.discoveryLogger.trace("{} guids :{}", (Object)"[ApmDiscoveryContributor]", arrayList2);
                APMDiscoveryLogger.discoveryLogger.trace("{} stored : {}", (Object)"[ApmDiscoveryContributor]", (Object)bl4);
            }
            if (bl4 && arrayList2.size() > 0) {
                this.setStatus(arrayList2);
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Unable to process discovery details : {}", (Object)"[ApmDiscoveryContributor]", (Object)exception);
        }
    }

    private void setStatus(ArrayList arrayList) {
        try {
            if (arrayList != null && arrayList.size() > 0) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    String string = (String)arrayList.get(i);
                    APMDiscoveryHelper.addToDiscoveredList(string);
                    APMComponentIDRepository.setStatusForBtmDiscovery((String)string, (boolean)true);
                }
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Unable to set status foe newly discovered jvm guids : {}", (Object)"[ApmDiscoveryContributor]", (Object)exception);
        }
    }

    private boolean storeToIni(ArrayList arrayList, ArrayList arrayList2) {
        return APMDiscoveryHelper.storeToIni(arrayList, arrayList2);
    }

    public DockerContainers getDockerInstance() {
        DockerContainers dockerContainers = null;
        if (!EgInstallInfo.isWindows) {
            dockerContainers = DockerContainers.getDockerContainerInstance();
        }
        return dockerContainers;
    }

    private boolean discoveryIniUpdated() {
        boolean bl = false;
        long l = IniFile.getLastModified((String)(EgInstallInfo.getInstallDir() + BTMConstants.APM_DISCOVERY_FILEPATH));
        APMDiscoveryLogger.discoveryLogger.trace("{} Current eg_apmdiscovery.ini file LastModified {}", (Object)"[ApmDiscoveryContributor]", (Object)l);
        APMDiscoveryLogger.discoveryLogger.trace("{} Previous eg_apmdiscovery.ini lastModifiedTime {} ", (Object)"[ApmDiscoveryContributor]", (Object)lastModifiedTime);
        if (lastModifiedTime > -1L) {
            if (l != lastModifiedTime) {
                bl = true;
                lastModifiedTime = l;
            }
        } else {
            lastModifiedTime = l;
            bl = true;
        }
        return bl;
    }

    private boolean isAgentTestsIniUpdated() {
        boolean bl;
        block8: {
            bl = false;
            try {
                long l = IniFile.getLastModified((String)(EgInstallInfo.getInstallDir() + "/agent/config/eg_agentTests.ini"));
                APMDiscoveryLogger.discoveryLogger.debug("{} Current eg_agentTests.ini file LastModified {}", (Object)"[ApmDiscoveryContributor]", (Object)l);
                APMDiscoveryLogger.discoveryLogger.debug("{} Previous eg_agentTests.ini lastAgentTestsModifiedTime {} ", (Object)"[ApmDiscoveryContributor]", (Object)lastAgentTestsModifiedTime);
                if (lastAgentTestsModifiedTime > -1L) {
                    if (l != lastAgentTestsModifiedTime) {
                        bl = true;
                        lastAgentTestsModifiedTime = l;
                    }
                } else {
                    lastAgentTestsModifiedTime = l;
                    bl = true;
                }
                if (!bl) break block8;
                try {
                    IniFile iniFile = new IniFile(EgInstallInfo.getInstallDir() + "/agent/config/eg_agentTests.ini");
                    String string = iniFile.getValue("AGENT_SETTINGS", "AgentDiscover");
                    if (string != null && string.length() != 0) {
                        agentDiscoverEnabled = Boolean.parseBoolean(string);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return bl;
    }

    private boolean cleanupIniUpdated() {
        boolean bl = false;
        long l = IniFile.getLastModified((String)cleanIni);
        APMDiscoveryLogger.discoveryLogger.trace("{} Current eg_apmdiscovery_cleanup.inifile LastModified {} ", (Object)"[ApmDiscoveryContributor]", (Object)l);
        APMDiscoveryLogger.discoveryLogger.trace("{} Previous eg_apmdiscovery_cleanup.ini lastModifiedTime {}", (Object)"[ApmDiscoveryContributor]", (Object)lastModifiedTime);
        if (lastCleanupiniModifiedTime > -1L) {
            if (l != lastCleanupiniModifiedTime) {
                bl = true;
                lastCleanupiniModifiedTime = l;
            }
        } else {
            lastCleanupiniModifiedTime = l;
            bl = true;
        }
        return bl;
    }

    private void suspendThread(long l) {
        try {
            Thread.sleep(l);
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.error("{} exception in Agent data Contributor thread while suspending Thread..{}", (Object)"[ApmDiscoveryContributor]", (Object)exception);
        }
    }

    private IniHelper getIniHelper(final String string, final String string2, final String string3) {
        IniHelper iniHelper = new IniHelper(string, string2, string3){

            public String toString() {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(string);
                stringBuilder.append("  ");
                stringBuilder.append(string2);
                stringBuilder.append("=");
                stringBuilder.append(string3);
                return stringBuilder.toString();
            }
        };
        return iniHelper;
    }

    private void addToUnKnownContainers(String string) {
        try {
            if (this.unknownContainers.containsKey(string)) {
                int n = (Integer)this.unknownContainers.get(string);
                this.unknownContainers.put(string, n + 1);
            } else {
                this.unknownContainers.put(string, 1);
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Unable to do process discovery details : {}", (Object)"[ApmDiscoveryContributor]", (Object)exception);
        }
    }

    private boolean isReachedToMaximumDeletionCounter(String string) {
        try {
            int n;
            if (this.unknownContainers.containsKey(string) && (n = ((Integer)this.unknownContainers.get(string)).intValue()) >= 5) {
                return true;
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Unable to do process discovery details : ", (Object)"[ApmDiscoveryContributor]", (Object)exception);
        }
        return false;
    }

    private void readFromApmIni() {
        try {
            String string = EgInstallInfo.getInstallDir() + BTMConstants.AGENT_APM_FILEPATH;
            IniFile iniFile = new IniFile(string);
            String string2 = iniFile.getValue("APM_DISCOVERY", "Discovery_Max_Wait_Time");
            string2 = string2.trim();
            if (string2 != null && string2.length() > 0) {
                this.dicoveryMaxWaitTime = Integer.parseInt(string2);
            }
            APMDiscoveryLogger.discoveryLogger.debug("{} dicoveryMaxWaitTime :  {} ", (Object)"[ApmDiscoveryContributor]", (Object)this.dicoveryMaxWaitTime);
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Unable to do read ini file : {}", (Object)"[ApmDiscoveryContributor]", (Object)exception);
        }
    }

    private boolean apmIniUpdated() {
        boolean bl = false;
        long l = IniFile.getLastModified((String)(EgInstallInfo.getInstallDir() + BTMConstants.AGENT_APM_FILEPATH));
        APMDiscoveryLogger.discoveryLogger.trace("{} Current eg_apm.ini file LastModified : {}, lastModifiedTime : {}", new Object[]{"[ApmDiscoveryContributor]", l, lastModifiedTime});
        if (this.lastApmIniModifiedTime > -1L) {
            if (l != this.lastApmIniModifiedTime) {
                bl = true;
                this.lastApmIniModifiedTime = l;
            }
        } else {
            this.lastApmIniModifiedTime = l;
            bl = true;
        }
        return bl;
    }
}

