/*
 * Decompiled with CFR 0.152.
 */
package com.eg.ch.qos.logback.core.sift;

import com.eg.ch.qos.logback.core.Appender;
import com.eg.ch.qos.logback.core.AppenderBase;
import com.eg.ch.qos.logback.core.sift.AppenderFactory;
import com.eg.ch.qos.logback.core.sift.AppenderTracker;
import com.eg.ch.qos.logback.core.sift.Discriminator;
import com.eg.ch.qos.logback.core.util.Duration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SiftingAppenderBase<E>
extends AppenderBase<E> {
    protected AppenderTracker<E> appenderTracker;
    AppenderFactory<E> appenderFactory;
    Duration timeout = new Duration(1800000L);
    int maxAppenderCount = Integer.MAX_VALUE;
    Discriminator<E> discriminator;

    public Duration getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Duration duration) {
        this.timeout = duration;
    }

    public int getMaxAppenderCount() {
        return this.maxAppenderCount;
    }

    public void setMaxAppenderCount(int n2) {
        this.maxAppenderCount = n2;
    }

    public void setAppenderFactory(AppenderFactory<E> appenderFactory) {
        this.appenderFactory = appenderFactory;
    }

    @Override
    public void start() {
        int n2 = 0;
        if (this.discriminator == null) {
            this.addError("Missing discriminator. Aborting");
            ++n2;
        }
        if (!this.discriminator.isStarted()) {
            this.addError("Discriminator has not started successfully. Aborting");
            ++n2;
        }
        if (this.appenderFactory == null) {
            this.addError("AppenderFactory has not been set. Aborting");
            ++n2;
        } else {
            this.appenderTracker = new AppenderTracker<E>(this.context, this.appenderFactory);
            this.appenderTracker.setMaxComponents(this.maxAppenderCount);
            this.appenderTracker.setTimeout(this.timeout.getMilliseconds());
        }
        if (n2 == 0) {
            super.start();
        }
    }

    @Override
    public void stop() {
        for (Appender appender : this.appenderTracker.allComponents()) {
            appender.stop();
        }
    }

    protected abstract long getTimestamp(E var1);

    @Override
    protected void append(E e2) {
        if (!this.isStarted()) {
            return;
        }
        String string = this.discriminator.getDiscriminatingValue(e2);
        long l2 = this.getTimestamp(e2);
        Appender appender = (Appender)this.appenderTracker.getOrCreate(string, l2);
        if (this.eventMarksEndOfLife(e2)) {
            this.appenderTracker.endOfLife(string);
        }
        this.appenderTracker.removeStaleComponents(l2);
        appender.doAppend(e2);
    }

    protected abstract boolean eventMarksEndOfLife(E var1);

    public Discriminator<E> getDiscriminator() {
        return this.discriminator;
    }

    public void setDiscriminator(Discriminator<E> discriminator) {
        this.discriminator = discriminator;
    }

    public AppenderTracker<E> getAppenderTracker() {
        return this.appenderTracker;
    }

    public String getDiscriminatorKey() {
        if (this.discriminator != null) {
            return this.discriminator.getKey();
        }
        return null;
    }
}

