/*
 * Decompiled with CFR 0.152.
 */
package com.eg.ch.qos.logback.core.db;

import com.eg.ch.qos.logback.core.db.ConnectionSource;
import com.eg.ch.qos.logback.core.db.DBHelper;
import com.eg.ch.qos.logback.core.db.dialect.DBUtil;
import com.eg.ch.qos.logback.core.db.dialect.SQLDialectCode;
import com.eg.ch.qos.logback.core.spi.ContextAwareBase;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;

public abstract class ConnectionSourceBase
extends ContextAwareBase
implements ConnectionSource {
    private boolean started;
    private String user = null;
    private String password = null;
    private SQLDialectCode dialectCode = SQLDialectCode.UNKNOWN_DIALECT;
    private boolean supportsGetGeneratedKeys = false;
    private boolean supportsBatchUpdates = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void discoverConnectionProperties() {
        Connection connection = null;
        try {
            connection = this.getConnection();
            if (connection == null) {
                this.addWarn("Could not get a connection");
                return;
            }
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            DBUtil dBUtil = new DBUtil();
            dBUtil.setContext(this.getContext());
            this.supportsGetGeneratedKeys = dBUtil.supportsGetGeneratedKeys(databaseMetaData);
            this.supportsBatchUpdates = dBUtil.supportsBatchUpdates(databaseMetaData);
            this.dialectCode = DBUtil.discoverSQLDialect(databaseMetaData);
            this.addInfo("Driver name=" + databaseMetaData.getDriverName());
            this.addInfo("Driver version=" + databaseMetaData.getDriverVersion());
            this.addInfo("supportsGetGeneratedKeys=" + this.supportsGetGeneratedKeys);
        }
        catch (SQLException sQLException) {
            this.addWarn("Could not discover the dialect to use.", sQLException);
        }
        finally {
            DBHelper.closeConnection(connection);
        }
    }

    public final boolean supportsGetGeneratedKeys() {
        return this.supportsGetGeneratedKeys;
    }

    public final SQLDialectCode getSQLDialectCode() {
        return this.dialectCode;
    }

    public final String getPassword() {
        return this.password;
    }

    public final void setPassword(String string) {
        this.password = string;
    }

    public final String getUser() {
        return this.user;
    }

    public final void setUser(String string) {
        this.user = string;
    }

    public final boolean supportsBatchUpdates() {
        return this.supportsBatchUpdates;
    }

    public boolean isStarted() {
        return this.started;
    }

    public void start() {
        this.started = true;
    }

    public void stop() {
        this.started = false;
    }
}

