/*
 * Decompiled with CFR 0.152.
 */
import com.eg.IniFile;
import com.eg.snmpgetsubtree;
import com.egurkha.util.EgUtilities;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class SNMPValidator
extends EgServerValidator {
    public String community = "public";
    public String snmpWalkCmd = "snmpgetsubtree";
    public String[] lhs;
    public String[] rhs;
    public boolean isSnmpV2 = false;
    private EgUtilities egutil = EgUtilities.createInstance();
    private int timeOut = 1;
    public String snmpPortNo = "161";
    public String test = "";
    public String compType = "";
    public String host = "";
    public String port = "";
    public String timeout = "";
    public String oid = "";
    public String transportLayer = "";
    public String defaultOID = ".1.3.6.1.2.1.1.1";
    public String netFlowOID = ".1.3.6.1.4.1.9.9.387.1.7.2";
    public String nBarOID = ".1.3.6.1.4.1.9.9.244.1.1.1.1.1.1";
    public String reportingName = "";
    public String isAgentLess = "";
    public String alMode = "";
    public String alUser = "";
    public String alPassword = "";
    public boolean meAgentLess = false;
    public ArrayList validationMsgs = null;
    public String subject = "WORKING_TESTS";
    public String key = "";
    public String errorMsg = "error";
    public String validationMsg = "";
    public String validationErrorMsg = "";
    public boolean isWindowsOS = false;
    public boolean isFromManager = false;
    public boolean isTargetIp = true;
    public boolean isNetFlowSupportToBeValidated = false;
    public boolean isNBarSupportToBeValidated = false;
    public boolean isIPReachabilityEnabled = true;
    IniFile file = new IniFile(EgInstallInfo.getInstallDir() + "/agent/config/eg_tests.ini");
    public String username = null;
    public String authPass = null;
    public String authType = null;
    public String context = null;
    public String snmpVersion = "v1";
    public String encryptType = null;
    public String encryptPass = null;
    public boolean isEncryptionEnabled = false;
    public String mibName;
    public String contextValue = "";
    public boolean isPortRelevantTest = false;
    public String engineIDVal = "";

    public SNMPValidator(String[] stringArray, Boolean bl) {
        super(stringArray);
        String string;
        String string2;
        this.validationMsgs = new ArrayList();
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string3;
                string2 = stringArray[i];
                String string4 = string2.substring(0, string2.indexOf(":"));
                String string5 = string2.substring(string2.indexOf(":") + 1);
                if ((string4 = string4.trim()) != null && string4.equalsIgnoreCase("-host")) {
                    this.host = string5;
                    continue;
                }
                if (string4 != null && string4.equalsIgnoreCase("-snmpPort")) {
                    this.port = this.snmpPortNo = string5;
                    continue;
                }
                if (string4 != null && string4.equalsIgnoreCase("-timeout")) {
                    this.timeout = "1";
                    continue;
                }
                if (string4 != null && string4.equalsIgnoreCase("-snmpversion")) {
                    this.snmpVersion = string5;
                    continue;
                }
                if (string4 != null && string4.equalsIgnoreCase("-snmpCommunity")) {
                    this.community = string5;
                    continue;
                }
                if (string4 != null && string4.equalsIgnoreCase("-context")) {
                    this.contextValue = string5;
                    if (string5 == null || string5.length() == 0 || string5.equalsIgnoreCase("none")) {
                        this.context = "";
                        continue;
                    }
                    this.context = string5;
                    continue;
                }
                if (string4 != null && string4.equalsIgnoreCase("-username")) {
                    this.username = string5;
                    continue;
                }
                if (string4 != null && string4.equalsIgnoreCase("-data_over_tcp")) {
                    string3 = string5;
                    if (string3 != null && string3.equalsIgnoreCase("yes")) {
                        this.transportLayer = "tcp";
                        continue;
                    }
                    this.transportLayer = "udp";
                    continue;
                }
                if (string4 != null && string4.equalsIgnoreCase("-authpass")) {
                    if ((string5 = EgCrypt.decrypt((String)string5)).indexOf("~EG~") != -1) {
                        string5 = string5.substring(0, string5.indexOf("~EG~"));
                    }
                    this.authPass = string5;
                    continue;
                }
                if (string4 != null && string4.equalsIgnoreCase("-authtype")) {
                    this.authType = string5;
                    continue;
                }
                if (string4 != null && string4.equalsIgnoreCase("-oidvalue")) {
                    this.oid = string5;
                    continue;
                }
                if (string4 != null && string4.equalsIgnoreCase("-oid")) {
                    this.oid = string5;
                    continue;
                }
                if (string4 != null && string4.equalsIgnoreCase("-agentless")) {
                    this.isAgentLess = string5;
                    if (this.isAgentLess != null && this.isAgentLess.equalsIgnoreCase("y")) {
                        this.isAgentLess = "true";
                        continue;
                    }
                    this.isAgentLess = "false";
                    continue;
                }
                if (string4 != null && string4.equalsIgnoreCase("-encryptflag")) {
                    this.alMode = string5;
                    if (this.alMode.equalsIgnoreCase("true")) {
                        this.isEncryptionEnabled = true;
                        continue;
                    }
                    this.isEncryptionEnabled = false;
                    continue;
                }
                if (string4 != null && string4.equalsIgnoreCase("-encrypttype")) {
                    this.encryptType = string5;
                    continue;
                }
                if (string4 != null && string4.equalsIgnoreCase("-encryptpassword")) {
                    if ((string5 = EgCrypt.decrypt((String)string5)).indexOf("~EG~") != -1) {
                        string5 = string5.substring(0, string5.indexOf("~EG~"));
                    }
                    this.encryptPass = string5;
                    continue;
                }
                if (string4 != null && string4.equalsIgnoreCase("-test")) {
                    this.test = string5;
                    if (this.compType == null || this.compType.toLowerCase().indexOf("cisco") <= -1) continue;
                    string3 = string5.substring(0, string5.indexOf("@"));
                    if (string3.equalsIgnoreCase("NetFlowTest") || string3.equalsIgnoreCase("TopSrcFlowTest") || string3.equalsIgnoreCase("TopDstFlowTest")) {
                        this.isNetFlowSupportToBeValidated = true;
                    }
                    if (!string3.equalsIgnoreCase("NBarTest")) continue;
                    this.isNBarSupportToBeValidated = true;
                    continue;
                }
                if (string4 != null && string4.equalsIgnoreCase("-componenttype")) {
                    this.compType = string5;
                    continue;
                }
                if (string4 == null || !string4.equalsIgnoreCase("-engineid")) continue;
                string3 = string5;
                this.engineIDVal = string3 != null && (string3.trim().equalsIgnoreCase("true") || string3.trim().equalsIgnoreCase("yes")) ? "yes" : "no";
            }
        }
        if ((string = System.getProperty("os.name").toLowerCase()).indexOf("win") >= 0) {
            this.isWindowsOS = true;
        }
        if (this.community == null || this.community.equals("")) {
            this.community = "none";
        }
        try {
            Integer.parseInt(this.snmpPortNo);
        }
        catch (NumberFormatException numberFormatException) {
            this.snmpPortNo = "161";
            numberFormatException.printStackTrace();
        }
        if (this.timeout != null) {
            try {
                int n;
                this.timeOut = n = Integer.parseInt(this.timeout);
            }
            catch (Exception exception) {}
        } else {
            string2 = System.getProperty("SNMPTIMEOUT");
            int n = 0;
            if (string2 != null) {
                try {
                    n = Integer.parseInt(string2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.egutil.setTimeout((long)this.timeOut);
        if (!this.isIpAddress(this.host)) {
            this.isTargetIp = false;
        }
        this.key = this.test + "#~#" + this.reportingName + ":" + this.port + ":" + this.sid;
        this.validationMsgs = new ArrayList();
        String string6 = this.file.getValue("AGENT_SETTINGS", "IPReachabilityCheckForSNMPValidator").trim();
        this.isIPReachabilityEnabled = string6 != null && string6.equalsIgnoreCase("yes");
        this.validate();
    }

    public void validate() {
        try {
            boolean bl;
            if (this.isIPReachabilityEnabled) {
                if (!this.isIPReachable()) {
                    this.errorMsg = "Host IP/Name '" + this.host + "' is invalid or  Host IP/Name is unreachable#Stack Trace: " + this.ipStacktrace + "#" + this.getCurrentTime();
                    this.logMsgToStatusFile(this.subject, this.key, this.errorMsg);
                    this.validationMsgs.add("Host IP/Name$#$Host IP/Name  '" + this.host + "' is invalid or Host IP/Name is unreachable");
                    this.validationMsgs.add("OID and other Parameters$#$NA");
                    return;
                }
                if (!this.isValidOID(this.oid)) {
                    boolean bl2;
                    this.validationMsgs.add("Host IP/Name$#$OK");
                    boolean bl3 = this.isValidOID(this.defaultOID);
                    if (this.isNetFlowSupportToBeValidated) {
                        bl2 = this.checkNetFlowSupport(this.netFlowOID);
                        if (!bl2) {
                            this.validationMsgs.add("NetFlow Support$#$failed");
                        } else {
                            this.validationMsgs.add("NetFlow Support$#$OK");
                        }
                    }
                    if (this.isNBarSupportToBeValidated) {
                        bl2 = this.checkNetFlowSupport(this.nBarOID);
                        if (!bl2) {
                            this.validationMsgs.add("NBar Support$#$failed");
                        } else {
                            this.validationMsgs.add("NBar Support$#$OK");
                        }
                    }
                    if (bl3) {
                        this.validationMsgs.add("OID and other parameters$#$Snmp walk failed for OID '" + this.oid + "',but worked for MIB-II OIDs. Please check if SNMP is enabled for the OID '" + this.oid + "'");
                    } else {
                        this.validationMsgs.add("OID and other parameters$#$" + this.validationErrorMsg);
                    }
                    return;
                }
                this.validationMsgs.add("Host IP/Name$#$OK");
                this.validationMsgs.add("OID and other parameters$#$OK");
            } else {
                if (!this.isValidOID(this.oid)) {
                    boolean bl4;
                    this.validationMsgs.add("ICMP ping request disabled for this Host IP/Name ");
                    boolean bl5 = this.isValidOID(this.defaultOID);
                    if (this.isNetFlowSupportToBeValidated) {
                        bl4 = this.checkNetFlowSupport(this.netFlowOID);
                        if (!bl4) {
                            this.validationMsgs.add("NetFlow Support$#$failed");
                        } else {
                            this.validationMsgs.add("NetFlow Support$#$OK");
                        }
                    }
                    if (this.isNBarSupportToBeValidated) {
                        bl4 = this.checkNetFlowSupport(this.nBarOID);
                        if (!bl4) {
                            this.validationMsgs.add("NBar Support$#$failed");
                        } else {
                            this.validationMsgs.add("NBar Support$#$OK");
                        }
                    }
                    if (bl5) {
                        this.validationMsgs.add("OID and other parameters$#$Snmp walk failed for OID '" + this.oid + "',but worked for MIB-II OIDs. Please check if SNMP is enabled for the OID '" + this.oid + "'");
                    } else {
                        this.validationMsgs.add("OID and other parameters$#$" + this.validationErrorMsg);
                    }
                    return;
                }
                this.validationMsgs.add("OID and other parameters$#$OK");
                this.validationMsgs.add("ICMP ping request disabled for this $#$Host IP/Name  " + this.host);
            }
            if (this.isNetFlowSupportToBeValidated) {
                bl = this.checkNetFlowSupport(this.netFlowOID);
                if (!bl) {
                    this.validationMsgs.add("NetFlow Enabled$#$NetFlow support not available");
                } else {
                    this.validationMsgs.add("NetFlow Enabled$#$OK");
                }
            }
            if (this.isNBarSupportToBeValidated) {
                bl = this.checkNetFlowSupport(this.nBarOID);
                if (!bl) {
                    this.validationMsgs.add("NBar Enabled$#$NBar support not available");
                } else {
                    this.validationMsgs.add("Nbar Enabled$#$OK");
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public ArrayList getValidationMsgs() {
        return this.validationMsgs;
    }

    public boolean isValidOID(String string) {
        boolean bl = true;
        try {
            int n;
            CharSequence charSequence;
            Object object;
            Object object2;
            if (string == null) {
                return false;
            }
            long l = System.currentTimeMillis();
            if (string.endsWith(".0")) {
                string = string.substring(0, string.lastIndexOf(".0"));
            }
            if (this.isSnmpV2) {
                this.snmpVersion = "v2";
            }
            String[] stringArray = null;
            stringArray = this.snmpVersion.equalsIgnoreCase("v1") || this.snmpVersion.equalsIgnoreCase("v2") ? new String[]{"-p", "" + this.snmpPortNo, "-c", this.community, "-o", "-v", this.snmpVersion.equalsIgnoreCase("v1") ? "1" : "2", this.host, string, this.transportLayer} : (!this.isEncryptionEnabled ? new String[]{"-o", "-w", "2", "-v", "3", "-p", "" + this.snmpPortNo, "-u", this.username, "-a", this.authType, "-A", this.authPass, this.host, string, "-n", this.context, this.engineIDVal, this.transportLayer} : new String[]{"-o", "-w", "2", "-v", "3", "-p", "" + this.snmpPortNo, "-u", this.username, "-a", this.authType, "-A", this.authPass, "-x", this.encryptType, "-X", this.encryptPass, this.host, string, "-n", this.context, this.engineIDVal, this.transportLayer});
            snmpgetsubtree snmpgetsubtree2 = new snmpgetsubtree(stringArray, this.timeOut);
            ArrayList arrayList = snmpgetsubtree2.getSubTree();
            String string2 = "";
            String string3 = "";
            if (arrayList.size() == 0) {
                string2 = string;
                int n2 = string2.lastIndexOf(".");
                string3 = string2.substring(0, n2);
                if (this.isSnmpV2) {
                    this.snmpVersion = "v2";
                }
                if (this.snmpVersion.equalsIgnoreCase("v1") || this.snmpVersion.equalsIgnoreCase("v2")) {
                    stringArray[8] = string3;
                } else if (!this.isEncryptionEnabled) {
                    stringArray[14] = string3;
                } else {
                    stringArray[18] = string3;
                }
                object2 = new snmpgetsubtree(stringArray, this.timeOut);
                object = ((snmpgetsubtree)((Object)object2)).getSubTree();
                charSequence = "";
                if (object != null && ((ArrayList)object).size() > 0) {
                    n = ((ArrayList)object).size();
                    for (int i = 0; i < n; ++i) {
                        charSequence = (String)((ArrayList)object).get(i);
                        if (!((String)charSequence).startsWith(string)) continue;
                        arrayList.add(charSequence);
                    }
                }
            }
            this.lhs = null;
            this.rhs = null;
            ArrayList<String> arrayList2 = new ArrayList<String>();
            object2 = new ArrayList();
            this.mibName = string;
            if (arrayList != null && arrayList.size() > 0) {
                int n3 = arrayList.size();
                for (n = 0; n < n3; ++n) {
                    int n4;
                    String string4 = ((String)arrayList.get(n)).trim();
                    if (!string4.startsWith(string) || (n4 = string4.indexOf(61)) < 0) continue;
                    String string5 = string4.substring(0, n4);
                    String string6 = string4.substring(n4 + 1);
                    String string7 = this.replace(string5, string, "");
                    if (string7.length() > 0) {
                        string7 = new String(string7.substring(1));
                    }
                    if (string6.startsWith("\"")) {
                        String string8;
                        int n5 = string6.lastIndexOf("\"");
                        while (n5 <= 0 && ++n < n3 && (string8 = (String)arrayList.get(n)) != null) {
                            string6 = string6 + " " + string8;
                            n5 = string6.lastIndexOf("\"");
                        }
                        string6 = new String(string6.substring(1, n5));
                    }
                    arrayList2.add(string6);
                    ((ArrayList)object2).add(string7);
                }
                object = arrayList2.toArray();
                this.rhs = new String[((Object[])object).length];
                for (n = 0; n < ((Object)object).length; ++n) {
                    this.rhs[n] = object[n].toString();
                }
                object = ((ArrayList)object2).toArray();
                this.lhs = new String[((Object)object).length];
                for (n = 0; n < ((Object)object).length; ++n) {
                    this.lhs[n] = object[n].toString();
                }
                bl = this.lhs.length > 0;
            } else {
                charSequence = new StringBuffer("java com/eg/snmpgetsubtree");
                for (n = 0; n < stringArray.length; ++n) {
                    ((StringBuffer)charSequence).append(" ");
                    ((StringBuffer)charSequence).append(stringArray[n]);
                }
                if (this.snmpVersion.equalsIgnoreCase("v1") || this.snmpVersion.equalsIgnoreCase("v2")) {
                    this.errorMsg = new String("The OID you have provided for the validation or one of the parameters below may be incorrect. Also, check if the system agent's IP address/name  has  access rights to query the SNMP MIB of the target device. ~@~ ");
                    this.errorMsg = this.errorMsg + "SNMP port :" + this.snmpPortNo + "~@~";
                    this.errorMsg = this.errorMsg + "SNMP commnunity:" + this.community + "~@~";
                } else if (!this.isEncryptionEnabled) {
                    this.errorMsg = new String("The OID you have provided for the validation or one of the parameters below may be incorrect. Also, check if the system agent's IP address/name  has  access rights to query the SNMP MIB of the target device. ~@~ ");
                    this.errorMsg = this.errorMsg + "SNMP port :" + this.snmpPortNo + "~@~";
                    this.errorMsg = this.errorMsg + "User name :" + this.username + "~@~";
                    this.errorMsg = this.errorMsg + "Password :" + EgCrypt.encrypt((String)this.authPass) + "~@~";
                    this.errorMsg = this.errorMsg + "context :" + this.contextValue + "~@~";
                    this.errorMsg = this.errorMsg + "Authentication type :" + this.authType + "~@~";
                } else {
                    this.errorMsg = new String("The OID you have provided for the validation or one of the parameters below may be incorrect. Also, check if the system agent's IP address/name  has  access rights to query the SNMP MIB of the target device. ~@~ ");
                    this.errorMsg = this.errorMsg + "SNMP port :" + this.snmpPortNo + "~@~";
                    this.errorMsg = this.errorMsg + "User name :" + this.username + "~@~";
                    this.errorMsg = this.errorMsg + "Password :" + EgCrypt.encrypt((String)this.authPass) + "~@~";
                    this.errorMsg = this.errorMsg + "context :" + this.contextValue + "~@~";
                    this.errorMsg = this.errorMsg + "Authentication type :" + this.authType + "~@~";
                    this.errorMsg = this.errorMsg + "Encryption type :" + this.encryptType + "~@~";
                    this.errorMsg = this.errorMsg + "Encryption password :" + EgCrypt.encrypt((String)this.encryptPass) + "~@~";
                }
                this.validationErrorMsg = "Validation Failed; Reason: " + this.errorMsg;
                if (this.validationErrorMsg != null && this.validationErrorMsg.indexOf(":") > 0) {
                    StringTokenizer stringTokenizer = new StringTokenizer(this.validationErrorMsg, ":");
                    StringBuffer stringBuffer = new StringBuffer();
                    while (stringTokenizer.hasMoreTokens()) {
                        String string9 = stringTokenizer.nextToken();
                        stringBuffer.append(string9.trim());
                        if (!stringTokenizer.hasMoreTokens()) continue;
                        stringBuffer.append("|colon|");
                    }
                    this.validationErrorMsg = stringBuffer.toString();
                    this.validationErrorMsg = this.validationErrorMsg.trim();
                }
                bl = false;
            }
        }
        catch (Exception exception) {
            String string10 = this.getStackTraceAsString(exception);
            String string11 = string10.substring(0, string10.indexOf("at"));
            if (string11.indexOf("User name has to be provided") > 0) {
                this.validationErrorMsg = "Validation Failed; Reason: User name has to be provided";
            }
            if (string11.indexOf("TimeoutException") > 0) {
                this.validationErrorMsg = "Validation Failed; Reason: SNMP walk Timed out";
            }
            bl = false;
        }
        return bl;
    }

    public boolean checkNetFlowSupport(String string) {
        boolean bl = true;
        try {
            int n;
            String string2;
            Serializable serializable;
            Object object;
            int n2;
            if (string == null) {
                return false;
            }
            long l = System.currentTimeMillis();
            if (string.endsWith(".0")) {
                string = string.substring(0, string.lastIndexOf(".0"));
            }
            if (this.isSnmpV2) {
                this.snmpVersion = "v2";
            }
            String[] stringArray = null;
            stringArray = this.snmpVersion.equalsIgnoreCase("v1") || this.snmpVersion.equalsIgnoreCase("v2") ? new String[]{"-p", "" + this.snmpPortNo, "-c", this.community, "-o", "-v", this.snmpVersion.equalsIgnoreCase("v1") ? "1" : "2", this.host, string, this.transportLayer} : (!this.isEncryptionEnabled ? new String[]{"-o", "-w", "2", "-v", "3", "-p", "" + this.snmpPortNo, "-u", this.username, "-a", this.authType, "-A", this.authPass, this.host, string, "-n", this.context, this.transportLayer} : new String[]{"-o", "-w", "2", "-v", "3", "-p", "" + this.snmpPortNo, "-u", this.username, "-a", this.authType, "-A", this.authPass, "-x", this.encryptType, "-X", this.encryptPass, this.host, string, "-n", this.context, this.transportLayer});
            snmpgetsubtree snmpgetsubtree2 = new snmpgetsubtree(stringArray, this.timeOut);
            ArrayList arrayList = snmpgetsubtree2.getSubTree();
            String string3 = "";
            String string4 = "";
            if (arrayList.size() == 0) {
                string3 = string;
                n2 = string3.lastIndexOf(".");
                string4 = string3.substring(0, n2);
                if (this.isSnmpV2) {
                    this.snmpVersion = "v2";
                }
                if (this.snmpVersion.equalsIgnoreCase("v1") || this.snmpVersion.equalsIgnoreCase("v2")) {
                    stringArray[8] = string4;
                } else if (!this.isEncryptionEnabled) {
                    stringArray[14] = string4;
                } else {
                    stringArray[18] = string4;
                }
                object = new snmpgetsubtree(stringArray, this.timeOut);
                serializable = ((snmpgetsubtree)((Object)object)).getSubTree();
                string2 = "";
                if (serializable != null && ((ArrayList)serializable).size() > 0) {
                    n = ((ArrayList)serializable).size();
                    for (int i = 0; i < n; ++i) {
                        string2 = (String)((ArrayList)serializable).get(i);
                        if (!string2.startsWith(string)) continue;
                        arrayList.add(string2);
                    }
                }
            }
            if (arrayList != null && arrayList.size() > 0) {
                String string5;
                n2 = arrayList.size();
                object = new StringBuffer(128);
                for (int i = 0; i < n2; ++i) {
                    string2 = ((String)arrayList.get(i)).trim();
                    ((StringBuffer)object).append(object + " ");
                    if (!string2.startsWith(string) || (n = string2.indexOf(61)) < 0) continue;
                    String string6 = string2.substring(0, n);
                    String string7 = string2.substring(n + 1);
                    if (string6 == null || !string6.equals(string + ".0") || string7 == null || string7.equals("") || string7.equalsIgnoreCase("null")) continue;
                    int n3 = Integer.parseInt(string7);
                    if (n3 > 0) {
                        bl = true;
                        break;
                    }
                    if (n3 != 0) continue;
                    bl = false;
                    break;
                }
                if (!bl && (string5 = ((StringBuffer)object).toString()) != null && !string5.equals("")) {
                    this.validationErrorMsg = string5;
                }
            } else {
                StringBuffer stringBuffer = new StringBuffer("java com/eg/snmpgetsubtree");
                for (int i = 0; i < stringArray.length; ++i) {
                    stringBuffer.append(" ");
                    stringBuffer.append(stringArray[i]);
                }
                if (this.snmpVersion.equalsIgnoreCase("v1") || this.snmpVersion.equalsIgnoreCase("v2")) {
                    this.errorMsg = new String("The OID you have provided for the validation or one of the parameters below may be incorrect. Also, check if the system agent's IP address/name  has  access rights to query the SNMP MIB of the target device. ~@~ ");
                    this.errorMsg = this.errorMsg + "SNMP port :" + this.snmpPortNo + "~@~";
                    this.errorMsg = this.errorMsg + "SNMP commnunity:" + this.community + "~@~";
                } else if (!this.isEncryptionEnabled) {
                    this.errorMsg = new String("The OID you have provided for the validation or one of the parameters below may be incorrect. Also, check if the system agent's IP address/name  has  access rights to query the SNMP MIB of the target device. ~@~ ");
                    this.errorMsg = this.errorMsg + "SNMP port :" + this.snmpPortNo + "~@~";
                    this.errorMsg = this.errorMsg + "User name :" + this.username + "~@~";
                    this.errorMsg = this.errorMsg + "Password :" + EgCrypt.encrypt((String)this.authPass) + "~@~";
                    this.errorMsg = this.errorMsg + "context :" + this.contextValue + "~@~";
                    this.errorMsg = this.errorMsg + "Authentication type :" + this.authType + "~@~";
                } else {
                    this.errorMsg = new String("The OID you have provided for the validation or one of the parameters below may be incorrect. Also, check if the system agent's IP address/name  has  access rights to query the SNMP MIB of the target device. ~@~ ");
                    this.errorMsg = this.errorMsg + "SNMP port :" + this.snmpPortNo + "~@~";
                    this.errorMsg = this.errorMsg + "User name :" + this.username + "~@~";
                    this.errorMsg = this.errorMsg + "Password :" + EgCrypt.encrypt((String)this.authPass) + "~@~";
                    this.errorMsg = this.errorMsg + "context :" + this.contextValue + "~@~";
                    this.errorMsg = this.errorMsg + "Authentication type :" + this.authType + "~@~";
                    this.errorMsg = this.errorMsg + "Encryption type :" + this.encryptType + "~@~";
                    this.errorMsg = this.errorMsg + "Encryption password :" + EgCrypt.encrypt((String)this.encryptPass) + "~@~";
                }
                this.validationErrorMsg = "Validation Failed; Reason: " + this.errorMsg;
                if (this.validationErrorMsg != null && this.validationErrorMsg.indexOf(":") > 0) {
                    StringTokenizer stringTokenizer = new StringTokenizer(this.validationErrorMsg, ":");
                    serializable = new StringBuffer();
                    while (stringTokenizer.hasMoreTokens()) {
                        string2 = stringTokenizer.nextToken();
                        ((StringBuffer)serializable).append(string2.trim());
                        if (!stringTokenizer.hasMoreTokens()) continue;
                        ((StringBuffer)serializable).append("|colon|");
                    }
                    this.validationErrorMsg = ((StringBuffer)serializable).toString();
                    this.validationErrorMsg = this.validationErrorMsg.trim();
                }
                bl = false;
            }
        }
        catch (Exception exception) {
            String string8 = this.getStackTraceAsString(exception);
            String string9 = string8.substring(0, string8.indexOf("at"));
            if (string9.indexOf("User name has to be provided") > 0) {
                this.validationErrorMsg = "Validation Failed; Reason: User name has to be provided";
            }
            if (string9.indexOf("TimeoutException") > 0) {
                this.validationErrorMsg = "Validation Failed; Reason: SNMP walk Timed out";
            }
            bl = false;
        }
        return bl;
    }

    public String replace(String string, String string2, String string3) {
        if (string == null || string2 == null || string2.length() == 0 || string3 == null) {
            return string;
        }
        String string4 = string;
        int n = 0;
        int n2 = string4.indexOf(string2, n);
        if (n2 < 0) {
            return string;
        }
        int n3 = string2.length();
        int n4 = string3.length() - n3;
        n4 = n4 < 0 ? 0 : n4;
        StringBuilder stringBuilder = new StringBuilder(string.length() + (n4 *= 16));
        while (n2 >= 0) {
            stringBuilder.append(string, n, n2).append(string3);
            n = n2 + n3;
            n2 = string4.indexOf(string2, n);
        }
        stringBuilder.append(string, n, string.length());
        return stringBuilder.toString();
    }

    public boolean isIpAddress(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        if (stringTokenizer.countTokens() != 4) {
            return false;
        }
        int n = stringTokenizer.countTokens();
        for (int i = 0; i < n; ++i) {
            try {
                int n2 = Integer.parseInt(stringTokenizer.nextToken());
                if (n2 <= 255 && n2 >= 0) continue;
                return false;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return true;
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"-host:192.168.10.10", "-test:DeviceUptimeTest", "snmpPort:161", "-timeout:10", "-snmpversion:v1", "-snmpCommunity:public", "-username:none", "-authpass:none", "-authtype:md5", "-oid:.1.3.6.1.2.1.1.3", "-agentless:n", "-encryptflag:false", "-encrypttype:des", "-encryptpassword:none"};
        SNMPValidator sNMPValidator = new SNMPValidator(stringArray2, new Boolean(true));
        ArrayList arrayList = sNMPValidator.getValidationMsgs();
    }
}

