/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgLangInfo;
import com.egurkha.util.EgUtilities;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;

class SystemTest
extends EgTest {
    private int repeat = 2;
    private int period;
    private double cpuUtil = 0.0;
    private double run = 0.0;
    private double block = 0.0;
    private double swap = 0.0;
    private double free = 0.0;
    private double scan = 0.0;
    private double sysCpu = 0.0;
    private double steal = -5.0;
    private String index;
    private static int cpuUtilIndex = 0;
    private static int sysCpuIndex = 1;
    private static int runIndex = 2;
    private static int blockIndex = 3;
    private static int swapIndex = 4;
    private static int freeIndex = 5;
    private static int scanIndex = 6;
    private static int stealIndex = 7;
    private static long mb = 0x100000L;
    private static boolean isMpStatExist = false;
    private EgUtilities egutil = null;
    private static long lastCacheTime = 0L;
    private static long lastRunTime = 0L;
    private long mpstatRunTime = 3600000L;
    private static Hashtable lastResults = new Hashtable();
    private static String dsync = new String("dt");
    public ArrayList cpuDDList = new ArrayList();
    public ArrayList memDDList = new ArrayList();
    public boolean isEnabledFreeMemDD = true;
    public boolean isDoneCpuDD = false;
    public boolean isDoneMemDD = false;
    public boolean isCpuFromIdle = false;
    public boolean use_top_forDD = false;

    public void freeTest() {
        this.cpuDDList = new ArrayList();
        this.memDDList = new ArrayList();
        this.isDoneCpuDD = false;
        this.isDoneMemDD = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopTest() {
        if (this.cacheTestResults) {
            String string = dsync;
            synchronized (string) {
                lastResults.clear();
                lastCacheTime = 0L;
            }
        }
    }

    public static void main(String[] stringArray) {
        SystemTest systemTest = new SystemTest(stringArray);
        systemTest.executeTest();
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        systemTest.executeTest();
    }

    public SystemTest(String[] stringArray) {
        super(stringArray);
        if (stringArray.length < 2 || !stringArray[0].equalsIgnoreCase("-host") || !stringArray[2].equalsIgnoreCase("-duration")) {
            return;
        }
        this.numOutputFields = 8;
        this.targetHost = new String(stringArray[1]);
        this.period = Integer.parseInt(stringArray[3]);
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            if (stringArray[i].equalsIgnoreCase("-enable_memory_diagnosis") && i + 1 < stringArray.length) {
                string = stringArray[i + 1].trim();
                if (string != null && (string.equalsIgnoreCase("True") || string.equalsIgnoreCase("Yes") || string.equalsIgnoreCase("Y"))) {
                    this.isEnabledFreeMemDD = true;
                    continue;
                }
                this.isEnabledFreeMemDD = false;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-include_wait") && i + 1 < stringArray.length) {
                string = stringArray[i + 1].trim();
                if (string != null && (string.equalsIgnoreCase("True") || string.equalsIgnoreCase("Yes") || string.equalsIgnoreCase("Y"))) {
                    this.isCpuFromIdle = true;
                    continue;
                }
                this.isCpuFromIdle = false;
                continue;
            }
            if (!stringArray[i].equalsIgnoreCase("-use_top_for_DD") || i + 1 >= stringArray.length) continue;
            string = stringArray[i + 1].trim();
            this.use_top_forDD = string != null && (string.equalsIgnoreCase("True") || string.equalsIgnoreCase("Yes") || string.equalsIgnoreCase("Y"));
        }
        this.index = new String(this.siteName + siteAndInfoSeparator + infoFieldSeparator);
        RunVmstat runVmstat = new RunVmstat(this.repeat, this.period);
        this.egutil = EgUtilities.createInstance();
    }

    private ArrayList myTokenizer(String string, boolean bl) {
        boolean bl2 = bl;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            if (n == 1 && bl2) {
                String string2 = stringTokenizer.nextToken();
                if (string2.equalsIgnoreCase("am") || string2.equalsIgnoreCase("pm")) {
                    arrayList.add(string2);
                } else {
                    arrayList.add("AM");
                    arrayList.add(string2);
                }
            } else {
                arrayList.add(stringTokenizer.nextToken());
            }
            ++n;
        }
        return arrayList;
    }

    private ArrayList getMpstatOutput() {
        String string;
        ArrayList arrayList;
        if (!isMpStatExist) {
            long l = System.currentTimeMillis();
            if (l - lastRunTime > this.mpstatRunTime) {
                isMpStatExist = this.isMpstatExist();
            }
            if (!isMpStatExist) {
                return null;
            }
        }
        if ((arrayList = this.egutil.getExecOutputLines(string = "mpstat -P ALL " + this.period + " " + this.repeat)) == null || arrayList.size() < 2) {
            return null;
        }
        ArrayList arrayList2 = (ArrayList)arrayList.get(0);
        return arrayList2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isMpstatExist() {
        try {
            ArrayList arrayList;
            ArrayList arrayList2 = this.egutil.getExecOutputLines("which mpstat");
            if (arrayList2 != null && arrayList2.size() > 1 && (arrayList = (ArrayList)arrayList2.get(0)) != null && arrayList.size() > 0) {
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception exception) {
        }
        finally {
            lastRunTime = System.currentTimeMillis();
        }
        System.out.println("SystemTest: No mpstat found in current path!");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeTest() {
        this.initTest();
        if (this.meAgentless || this.isContainerApp) {
            this.isDynamicInfoTest = true;
            this.isPassive = true;
            this.updateAllResultSets();
            return true;
        }
        try {
            long l;
            long l2;
            if (this.cacheTestResults && lastResults != null && lastResults.size() > 0 && (l2 = (l = System.currentTimeMillis()) - lastCacheTime) < this.minMeasurePeriod / 3L) {
                Hashtable hashtable = null;
                Object object = dsync;
                synchronized (object) {
                    hashtable = (Hashtable)lastResults.clone();
                }
                object = hashtable.keys();
                while (object.hasMoreElements()) {
                    String string = (String)object.nextElement();
                    ArrayList arrayList = (ArrayList)hashtable.get(string);
                    if (arrayList == null) continue;
                    for (int i = 0; i < arrayList.size(); ++i) {
                        String string2;
                        int n;
                        Double d = (Double)arrayList.get(i);
                        double d2 = d;
                        if (i == 0 && d2 > 0.0) {
                            n = string.lastIndexOf(infoFieldSeparator);
                            if (n >= 0) {
                                string2 = string.substring(n);
                                this.cpuDDList.add(string2);
                            }
                        } else if (i == 5 && d2 > 0.0 && (n = string.lastIndexOf(infoFieldSeparator)) >= 0) {
                            string2 = string.substring(n);
                            this.memDDList.add(string2);
                        }
                        this.addValueToResultSet(string, i, d2);
                    }
                }
                this.updateAllResultSets();
                return true;
            }
            ArrayList arrayList = this.getMpstatOutput();
            ArrayList arrayList2 = RunVmstat.runCmd();
            double d = 1.0;
            int n = 3;
            if (arrayList2 != null && arrayList2.size() >= 2) {
                int n2;
                int n3;
                int n4;
                int n5;
                int n6;
                int n7;
                int n8;
                int n9;
                ArrayList arrayList3 = (ArrayList)arrayList2.get(0);
                if (arrayList3 != null && arrayList3.size() > 0) {
                    int n10;
                    String string = (String)arrayList3.get(0);
                    if (string.indexOf("pagesize =") >= 1 && string.endsWith(")") && (n10 = (string = string.substring(0, string.length() - 1)).lastIndexOf(" ")) >= 0) {
                        string = string.substring(n10 + 1);
                        try {
                            d = Double.parseDouble(string);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if ((string = (String)arrayList3.get(1)).toLowerCase().indexOf("procs") >= 0) {
                        string = (String)arrayList3.get(2);
                        n = 4;
                    }
                    string = string.trim();
                    ArrayList arrayList4 = this.myTokenizer(string, false);
                    int n11 = arrayList4.indexOf("r");
                    int n12 = arrayList4.indexOf("b");
                    n9 = arrayList4.indexOf("w");
                    n8 = arrayList4.indexOf("free");
                    if (n8 < 0) {
                        n8 = arrayList4.indexOf("fre");
                    }
                    boolean bl = false;
                    if (n8 < 0) {
                        n8 = arrayList4.indexOf("frs");
                        bl = true;
                    }
                    n7 = arrayList4.lastIndexOf("us");
                    n6 = -1;
                    n6 = !bl ? arrayList4.lastIndexOf("sy") : arrayList4.lastIndexOf("su");
                    n5 = arrayList4.lastIndexOf("id");
                    n4 = arrayList4.lastIndexOf("st");
                    String string3 = (String)arrayList3.get(n);
                    StringTokenizer stringTokenizer = new StringTokenizer(string3);
                    String[] stringArray = new String[stringTokenizer.countTokens()];
                    n3 = stringTokenizer.countTokens();
                    this.swap = !EgAgentCommon.isOsf1 ? this.getUsedSwap() : -5.0;
                    this.scan = -5.0;
                    this.run = -5.0;
                    this.free = -5.0;
                    this.block = -5.0;
                    double d3 = 0.0;
                    this.sysCpu = 0.0;
                    double d4 = 0.0;
                    for (n2 = 0; n2 < n3; ++n2) {
                        stringArray[n2] = stringTokenizer.nextToken();
                        if (n2 == n11) {
                            this.run = Double.parseDouble(stringArray[n2]);
                            continue;
                        }
                        if (n2 == n12) {
                            this.block = Double.parseDouble(stringArray[n2]);
                            continue;
                        }
                        if (n2 == n8) {
                            if (stringArray[n2].endsWith("K")) {
                                stringArray[n2] = stringArray[n2].substring(0, stringArray[n2].length() - 1);
                                this.free = Double.parseDouble(stringArray[n2]);
                                this.free = this.free * d / 1024.0;
                                continue;
                            }
                            this.free = Double.parseDouble(stringArray[n2]) / 1024.0;
                            continue;
                        }
                        if (n2 == n6) {
                            this.sysCpu = Double.parseDouble(stringArray[n2]);
                            continue;
                        }
                        if (n2 == n7) {
                            d3 = Double.parseDouble(stringArray[n2]);
                            continue;
                        }
                        if (n2 == n5) {
                            d4 = Double.parseDouble(stringArray[n2]);
                            continue;
                        }
                        if (n2 != n4) continue;
                        this.steal = Double.parseDouble(stringArray[n2]);
                    }
                    if (this.isCpuFromIdle) {
                        if (d4 > 100.0) {
                            d4 = 100.0;
                        }
                        this.cpuUtil = 100.0 - d4;
                    } else {
                        this.cpuUtil = this.sysCpu + d3;
                    }
                    if (this.cpuUtil > 100.0) {
                        this.cpuUtil = 100.0;
                    }
                    if (this.sysCpu > 100.0) {
                        this.sysCpu = 100.0;
                    }
                    if (d3 > 100.0) {
                        d3 = 100.0;
                    }
                } else {
                    this.errorMsg = new String("Failed to run vmstat");
                    this.stopTest();
                    this.updateAllResultSets();
                    return false;
                }
                double d5 = 0.0;
                if (!EgAgentCommon.isFreeBsd) {
                    d5 = this.getRealFreeMem();
                }
                if (d5 > 0.0) {
                    this.free = d5;
                }
                if (arrayList == null || arrayList.size() == 0) {
                    String string = this.index + "Summary";
                    this.addValueToResultSet(string, cpuUtilIndex, this.cpuUtil);
                    if (this.cpuUtil > 0.0 && (n9 = string.lastIndexOf(infoFieldSeparator)) >= 0) {
                        String string4 = string.substring(n9);
                        this.cpuDDList.add(string4);
                    }
                    this.addValueToResultSet(string, sysCpuIndex, this.sysCpu);
                    this.addValueToResultSet(string, runIndex, this.run);
                    this.addValueToResultSet(string, blockIndex, this.block);
                    this.addValueToResultSet(string, swapIndex, this.swap);
                    this.addValueToResultSet(string, freeIndex, this.free);
                    if (this.free > 0.0 && (n9 = string.lastIndexOf(infoFieldSeparator)) >= 0) {
                        String string5 = string.substring(n9);
                        this.memDDList.add(string5);
                    }
                    this.addValueToResultSet(string, scanIndex, this.scan);
                    this.addValueToResultSet(string, stealIndex, this.steal);
                    if (this.cacheTestResults) {
                        String string6 = dsync;
                        synchronized (string6) {
                            ArrayList<Double> arrayList5 = new ArrayList<Double>();
                            arrayList5.add(new Double(this.cpuUtil));
                            arrayList5.add(new Double(this.sysCpu));
                            arrayList5.add(new Double(this.run));
                            arrayList5.add(new Double(this.block));
                            arrayList5.add(new Double(this.swap));
                            arrayList5.add(new Double(this.free));
                            arrayList5.add(new Double(this.scan));
                            arrayList5.add(new Double(this.steal));
                            lastResults.put(string, arrayList5);
                            lastCacheTime = System.currentTimeMillis();
                        }
                    }
                    this.updateAllResultSets();
                } else {
                    ArrayList arrayList6;
                    String string;
                    int n13;
                    Hashtable<String, ArrayList<Double>> hashtable = new Hashtable<String, ArrayList<Double>>();
                    n9 = 0;
                    n8 = arrayList.size() - 1;
                    ArrayList<String> arrayList7 = new ArrayList<String>();
                    n7 = 3;
                    n6 = 5;
                    n5 = 6;
                    n4 = 0;
                    n3 = 0;
                    int n14 = 0;
                    int n15 = 0;
                    int n16 = 0;
                    int n17 = 0;
                    n2 = 0;
                    for (n13 = 0; n13 < n8; ++n13) {
                        string = (String)arrayList.get(n13);
                        if ((string = string.trim()).length() == 0 || string.startsWith("Average") || string.indexOf("intr/s") < 0 && string.indexOf("%usr") < 0 && string.indexOf("%user") < 0 && string.indexOf("%sys") < 0 || (arrayList6 = this.myTokenizer(string, true)).size() < 7) continue;
                        for (int i = 0; i < arrayList6.size(); ++i) {
                            String string7 = (String)arrayList6.get(i);
                            if (string7.equalsIgnoreCase("%usr") || string7.equalsIgnoreCase("%user")) {
                                n7 = i;
                                continue;
                            }
                            if (string7.equalsIgnoreCase("%sys") || string7.equalsIgnoreCase("%system")) {
                                n6 = i;
                                continue;
                            }
                            if (string7.equalsIgnoreCase("%idl") || string7.equalsIgnoreCase("%idle")) {
                                n5 = i;
                                continue;
                            }
                            if (string7.equalsIgnoreCase("%nice") || string7.equalsIgnoreCase("%nice")) {
                                n4 = i;
                                continue;
                            }
                            if (string7.equalsIgnoreCase("%iowait") || string7.equalsIgnoreCase("%iowait")) {
                                n3 = i;
                                continue;
                            }
                            if (string7.equalsIgnoreCase("%irq") || string7.equalsIgnoreCase("%irq")) {
                                n14 = i;
                                continue;
                            }
                            if (string7.equalsIgnoreCase("%soft") || string7.equalsIgnoreCase("%soft")) {
                                n15 = i;
                                continue;
                            }
                            if (string7.equalsIgnoreCase("%steal") || string7.equalsIgnoreCase("%steal")) {
                                n16 = i;
                                continue;
                            }
                            if (!string7.equalsIgnoreCase("%guest") && !string7.equalsIgnoreCase("%guest")) continue;
                            n17 = i;
                        }
                        break;
                    }
                    for (n13 = n8; n13 >= 0; --n13) {
                        int n18;
                        ArrayList<Double> arrayList8;
                        String string8;
                        String string9;
                        string = (String)arrayList.get(n13);
                        if ((string = string.trim()).length() == 0 || string.startsWith("Average") || string.indexOf("intr/s") >= 0 || string.indexOf("%usr") >= 0 || string.indexOf("%user") >= 0 || string.indexOf("%sys") >= 0 || (arrayList6 = this.myTokenizer(string, true)).size() < 7) continue;
                        String string10 = (String)arrayList6.get(2);
                        boolean bl = false;
                        if (string10.equalsIgnoreCase("all")) {
                            string10 = "Summary";
                            bl = true;
                        } else {
                            try {
                                Integer.parseInt(string10);
                            }
                            catch (Exception exception) {
                                continue;
                            }
                            string10 = "Processor_" + string10;
                        }
                        String string11 = (String)arrayList6.get(n7);
                        String string12 = (String)arrayList6.get(n6);
                        String string13 = (String)arrayList6.get(n5);
                        double d6 = 0.0;
                        double d7 = 0.0;
                        double d8 = 0.0;
                        double d9 = 0.0;
                        double d10 = 0.0;
                        double d11 = 0.0;
                        if (n4 > 0 && (string9 = (String)arrayList6.get(n4)) != null && string9.length() > 0) {
                            string9 = string9.trim();
                            d6 = EgLangInfo.getDoubleValue((String)string9);
                        }
                        if (n3 > 0 && (string9 = (String)arrayList6.get(n3)) != null && string9.length() > 0) {
                            string9 = string9.trim();
                            d7 = EgLangInfo.getDoubleValue((String)string9);
                        }
                        if (n14 > 0 && (string9 = (String)arrayList6.get(n14)) != null && string9.length() > 0) {
                            string9 = string9.trim();
                            d8 = EgLangInfo.getDoubleValue((String)string9);
                        }
                        if (n15 > 0 && (string9 = (String)arrayList6.get(n15)) != null && string9.length() > 0) {
                            string9 = string9.trim();
                            d9 = EgLangInfo.getDoubleValue((String)string9);
                        }
                        if (n16 > 0 && (string9 = (String)arrayList6.get(n16)) != null && string9.length() > 0) {
                            string9 = string9.trim();
                            d10 = EgLangInfo.getDoubleValue((String)string9);
                        }
                        if (n17 > 0 && (string9 = (String)arrayList6.get(n17)) != null && string9.length() > 0) {
                            string9 = string9.trim();
                            d11 = EgLangInfo.getDoubleValue((String)string9);
                        }
                        this.sysCpu = -1.0;
                        double d12 = -1.0;
                        double d13 = 0.0;
                        try {
                            this.sysCpu = Double.parseDouble(string12);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            d12 = Double.parseDouble(string11);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            d13 = Double.parseDouble(string13);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (this.isCpuFromIdle) {
                            if (d13 > 100.0) {
                                d13 = 100.0;
                            }
                            this.cpuUtil = 100.0 - d13;
                        } else if (d12 >= 0.0) {
                            this.cpuUtil = d12 + this.sysCpu + d6 + d7 + d8 + d9 + d10 + d11;
                        }
                        if (this.cpuUtil > 100.0) {
                            this.cpuUtil = 100.0;
                        }
                        if (this.sysCpu > 100.0) {
                            this.sysCpu = 100.0;
                        }
                        if (d12 > 100.0) {
                            d12 = 100.0;
                        }
                        if (arrayList7.contains(string8 = this.index + string10)) break;
                        arrayList7.add(string8);
                        this.addValueToResultSet(string8, cpuUtilIndex, this.cpuUtil);
                        this.addValueToResultSet(string8, sysCpuIndex, this.sysCpu);
                        if (!bl) {
                            this.addValueToResultSet(string8, runIndex, -5.0);
                            this.addValueToResultSet(string8, blockIndex, -5.0);
                            this.addValueToResultSet(string8, swapIndex, -5.0);
                            this.addValueToResultSet(string8, freeIndex, -5.0);
                            this.addValueToResultSet(string8, scanIndex, -5.0);
                            this.addValueToResultSet(string8, stealIndex, -5.0);
                            if (!this.cacheTestResults) continue;
                            String string14 = dsync;
                            synchronized (string14) {
                                arrayList8 = new ArrayList();
                                arrayList8.add(new Double(this.cpuUtil));
                                arrayList8.add(new Double(this.sysCpu));
                                arrayList8.add(new Double(-5.0));
                                arrayList8.add(new Double(-5.0));
                                arrayList8.add(new Double(-5.0));
                                arrayList8.add(new Double(-5.0));
                                arrayList8.add(new Double(-5.0));
                                arrayList8.add(new Double(-5.0));
                                hashtable.put(string8, arrayList8);
                                continue;
                            }
                        }
                        if (this.cpuUtil > 0.0 && (n18 = string8.lastIndexOf(infoFieldSeparator)) >= 0) {
                            arrayList8 = string8.substring(n18);
                            this.cpuDDList.add(arrayList8);
                        }
                        this.addValueToResultSet(string8, runIndex, this.run);
                        this.addValueToResultSet(string8, blockIndex, this.block);
                        this.addValueToResultSet(string8, swapIndex, this.swap);
                        this.addValueToResultSet(string8, freeIndex, this.free);
                        if (this.free > 0.0 && (n18 = string8.lastIndexOf(infoFieldSeparator)) >= 0) {
                            arrayList8 = string8.substring(n18);
                            this.memDDList.add(arrayList8);
                        }
                        this.addValueToResultSet(string8, scanIndex, this.scan);
                        if (n16 > 0) {
                            this.addValueToResultSet(string8, stealIndex, d10);
                        } else {
                            this.addValueToResultSet(string8, stealIndex, this.steal);
                        }
                        if (!this.cacheTestResults) continue;
                        String string15 = dsync;
                        synchronized (string15) {
                            arrayList8 = new ArrayList<Double>();
                            arrayList8.add(new Double(this.cpuUtil));
                            arrayList8.add(new Double(this.sysCpu));
                            arrayList8.add(new Double(this.run));
                            arrayList8.add(new Double(this.block));
                            arrayList8.add(new Double(this.swap));
                            arrayList8.add(new Double(this.free));
                            arrayList8.add(new Double(this.scan));
                            if (n16 > 0) {
                                arrayList8.add(new Double(d10));
                            } else {
                                arrayList8.add(new Double(this.steal));
                            }
                            hashtable.put(string8, arrayList8);
                            continue;
                        }
                    }
                    if (this.cacheTestResults) {
                        String string16 = dsync;
                        synchronized (string16) {
                            lastResults = hashtable;
                            lastCacheTime = System.currentTimeMillis();
                        }
                    }
                    this.updateAllResultSets();
                }
                return true;
            }
            this.errorMsg = new String("Failed to run vmstat");
            this.updateAllResultSets();
            this.stopTest();
            return false;
        }
        catch (Exception exception) {
            this.errorMsg = new String("Exception in SystemTest");
            this.stopTest();
            return false;
        }
    }

    private double getUsedSwap() {
        double d = -5.0;
        File file = new File("/proc/meminfo");
        if (!file.exists()) {
            if (EgAgentCommon.isFreeBsd) {
                ArrayList arrayList = this.egutil.getExecOutputLines("swapinfo");
                if (arrayList == null || arrayList.size() < 2) {
                    return d;
                }
                ArrayList arrayList2 = (ArrayList)arrayList.get(0);
                if (arrayList2 == null || arrayList2.size() == 0) {
                    return d;
                }
                int n = arrayList2.size();
                for (int i = 0; i < n; ++i) {
                    String string = (String)arrayList2.get(i);
                    if (string == null || string.length() == 0 || (string = string.trim()).startsWith("Device") || string.indexOf("Used") > -1 || string.indexOf("Avail") > -1) continue;
                    System.out.println("[SystemTest] line ==>" + string);
                    StringTokenizer stringTokenizer = new StringTokenizer(string);
                    stringTokenizer.nextToken();
                    stringTokenizer.nextToken();
                    String string2 = stringTokenizer.nextToken();
                    stringTokenizer.nextToken();
                    d = Double.parseDouble(string2);
                    break;
                }
            }
            System.out.println("[SystemTest] swap memory " + d);
            return d;
        }
        String string = "";
        String[] stringArray = new String[]{"/bin/sh", "-c", "cat /proc/meminfo | grep Swap"};
        BufferedReader bufferedReader = SystemTest.executeProgram1(stringArray);
        if (bufferedReader != null) {
            try {
                string = bufferedReader.readLine();
                if (string == null) {
                    return d;
                }
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                if (stringTokenizer.countTokens() >= 4) {
                    stringTokenizer.nextToken();
                    stringTokenizer.nextToken();
                    string = stringTokenizer.nextToken();
                    d = Double.parseDouble(string);
                    d /= (double)mb;
                    while (bufferedReader.readLine() != null) {
                    }
                    bufferedReader.close();
                    bufferedReader = null;
                    return d;
                }
                double d2 = 0.0;
                double d3 = 0.0;
                do {
                    StringTokenizer stringTokenizer2;
                    int n;
                    if (string == null) {
                        return -5.0;
                    }
                    if (string.startsWith("SwapTotal")) {
                        n = string.indexOf(58);
                        if (n < 0) continue;
                        stringTokenizer2 = new StringTokenizer(string = string.substring(n + 1).trim());
                        if (stringTokenizer2.countTokens() > 1) {
                            string = stringTokenizer2.nextToken();
                        }
                        try {
                            d2 = Double.parseDouble(string.trim());
                        }
                        catch (Exception exception) {
                            return d;
                        }
                    } else {
                        if (!string.startsWith("SwapFree") || (n = string.indexOf(58)) < 0) continue;
                        stringTokenizer2 = new StringTokenizer(string = string.substring(n + 1).trim());
                        if (stringTokenizer2.countTokens() > 1) {
                            string = stringTokenizer2.nextToken();
                        }
                        try {
                            d3 = Double.parseDouble(string.trim());
                        }
                        catch (Exception exception) {
                            return d;
                        }
                    }
                } while ((string = bufferedReader.readLine()) != null);
                if (d2 > 0.0) {
                    d = d2 - d3;
                    if ((d /= 1024.0) < 0.0) {
                        d = -5.0;
                    }
                }
                bufferedReader.close();
                bufferedReader = null;
                return d;
            }
            catch (Exception exception) {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                }
                return d;
            }
        }
        return d;
    }

    public static BufferedReader executeProgram1(String[] stringArray) {
        Runtime runtime = Runtime.getRuntime();
        Process process = null;
        try {
            process = runtime.exec(stringArray);
            if (process == null) {
                return null;
            }
            return new BufferedReader(new InputStreamReader(process.getInputStream()));
        }
        catch (Exception exception) {
            return null;
        }
    }

    private double getRealFreeMem() {
        try {
            String string = "free -m";
            EgUtilities egUtilities = EgUtilities.createInstance();
            ArrayList arrayList = egUtilities.getExecOutputLines(string);
            if (arrayList == null || arrayList.size() <= 0) {
                return -5.0;
            }
            ArrayList arrayList2 = (ArrayList)arrayList.get(0);
            double d = -5.0;
            double d2 = -5.0;
            double d3 = -5.0;
            StringTokenizer stringTokenizer = null;
            if (arrayList2 != null && arrayList2.size() > 0) {
                int n = arrayList2.size();
                String string2 = "";
                boolean bl = false;
                boolean bl2 = false;
                for (int i = 0; i < n; ++i) {
                    String string3;
                    string2 = (String)arrayList2.get(i);
                    if (string2 == null || string2.trim().length() == 0) continue;
                    if ((string2 = string2.trim()).indexOf("total") >= 0 && (string2.indexOf("buff/cache") > 0 || string2.indexOf("buffers/cache") > 0)) {
                        bl = true;
                        if (string2.indexOf("available") <= 0) continue;
                        bl2 = true;
                        continue;
                    }
                    if (string2.startsWith("Mem:") || string2.indexOf("Mem:") >= 0) {
                        stringTokenizer = new StringTokenizer(string2);
                        if (!bl) continue;
                        int n2 = stringTokenizer.countTokens();
                        if (n2 == 7) {
                            stringTokenizer.nextToken();
                            stringTokenizer.nextToken();
                            if (bl2) {
                                stringTokenizer.nextToken();
                                string3 = stringTokenizer.nextToken();
                                double d4 = EgLangInfo.getDoubleValue((String)string3.trim());
                                stringTokenizer.nextToken();
                                String string4 = stringTokenizer.nextToken();
                                double d5 = EgLangInfo.getDoubleValue((String)string4.trim());
                                if (d4 >= 0.0 && d5 >= 0.0) {
                                    d3 = d4 + d5;
                                } else if (d4 >= 0.0 && d5 < 0.0) {
                                    d3 = d4;
                                } else if (d4 < 0.0 && d5 >= 0.0) {
                                    d3 = d5;
                                }
                            } else {
                                stringTokenizer.nextToken();
                                stringTokenizer.nextToken();
                                stringTokenizer.nextToken();
                                stringTokenizer.nextToken();
                                string3 = stringTokenizer.nextToken();
                                d3 = EgLangInfo.getDoubleValue((String)string3.trim());
                            }
                        }
                        if (n2 < 8) continue;
                        stringTokenizer.nextToken();
                        stringTokenizer.nextToken();
                        stringTokenizer.nextToken();
                        stringTokenizer.nextToken();
                        stringTokenizer.nextToken();
                        stringTokenizer.nextToken();
                        stringTokenizer.nextToken();
                        stringTokenizer.nextToken();
                        string3 = stringTokenizer.nextToken();
                        d3 = EgLangInfo.getDoubleValue((String)string3.trim());
                        continue;
                    }
                    if (string2.indexOf("-/+ buffers/cache:") < 0 && string2.indexOf("buffers/cache:") <= -1) continue;
                    stringTokenizer = new StringTokenizer(string2);
                    stringTokenizer.nextToken();
                    stringTokenizer.nextToken();
                    String string5 = stringTokenizer.nextToken();
                    string3 = stringTokenizer.nextToken();
                    d3 = Double.parseDouble(string3);
                }
            }
            return d3;
        }
        catch (Exception exception) {
            return -5.0;
        }
    }

    public ArrayList getTopCommandOutput() {
        String string = "top -b -n 1";
        ArrayList arrayList = this.egutil.getExecOutputLines(string);
        if (arrayList == null || arrayList.size() < 2) {
            return null;
        }
        ArrayList arrayList2 = (ArrayList)arrayList.get(0);
        return arrayList2;
    }
}

