/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class SybSpaceTest
extends GenericTest {
    private String user;
    private String passwd;
    private String dbName;
    private String includeDb;
    private String excludeDb;
    private String useProcedure;
    private boolean procedureValue = false;
    private String charSet = "";
    private String encryptPassword = "false";
    private String defaultCharSet = "iso_1";
    private boolean isFirstTime = true;
    private boolean isCharsetProcNeeded = false;
    private String sybBelow15 = "";
    private boolean isSybBelow15 = false;
    private String driver = "com.sybase.jdbc4.jdbc.SybDriver";

    public SybSpaceTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(6);
        this.user = this.getValueForParam("user");
        this.passwd = this.getValueForParam("password");
        this.dbName = this.getValueForParam("dbName");
        this.includeDb = this.getValueForParam("include_db");
        this.excludeDb = this.getValueForParam("exclude_db");
        this.useProcedure = this.getValueForParam("use_storedprocedure");
        this.charSet = this.getValueForParam("charset");
        this.encryptPassword = this.getValueForParam("encrypt_password");
        this.sybBelow15 = this.getValueForParam("Driver_compatibility");
        this.isSybBelow15 = this.sybBelow15 == null || this.sybBelow15.trim().length() == 0 ? false : this.sybBelow15.equalsIgnoreCase("true") || this.sybBelow15.equalsIgnoreCase("yes");
        if (this.dbName == null || this.dbName.equalsIgnoreCase("none")) {
            this.dbName = "master";
        }
        if (this.useProcedure == null || this.useProcedure.equalsIgnoreCase("true") || this.useProcedure.equalsIgnoreCase("yes")) {
            this.procedureValue = true;
        }
        if (this.isSybBelow15) {
            this.driver = "com.sybase.jdbc2.jdbc.SybDriver";
            this.charSet = this.defaultCharSet;
        } else {
            if (this.charSet == null || this.charSet.trim().length() == 0 || this.charSet.equalsIgnoreCase("NULL") || this.charSet.equalsIgnoreCase("none")) {
                this.charSet = this.defaultCharSet;
                this.isCharsetProcNeeded = true;
            }
            this.encryptPassword = this.encryptPassword != null && (this.encryptPassword.trim().equalsIgnoreCase("y") || this.encryptPassword.trim().equalsIgnoreCase("yes")) ? "true" : "false";
        }
    }

    public void computeMeasures(Hashtable hashtable) {
        Object object;
        if (this.isCharsetProcNeeded && this.isFirstTime) {
            object = SybDbStats.getCharSetName(this.targetHost, this.portNo, this.user, this.passwd, this.charSet, this.encryptPassword, this.driver, false);
            System.out.println(" charSetName :" + (String)object);
            if (object != null && ((String)object).length() > 0) {
                this.charSet = object;
                this.isFirstTime = false;
            } else {
                this.isFirstTime = true;
                return;
            }
        }
        if ((object = new SybDbStats(this.targetHost, this.portNo, "master", this.user, this.passwd, this.charSet, this.encryptPassword, this.driver, this.isSybBelow15)) == null) {
            this.logToErrorFile("Error :", " SybSpaceTest   ", " Connection is null ");
            return;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        StringTokenizer stringTokenizer = null;
        try {
            Object object2;
            if (this.includeDb != null && !this.includeDb.equalsIgnoreCase("none") && !this.includeDb.equalsIgnoreCase("all")) {
                stringTokenizer = new StringTokenizer(this.includeDb, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    object2 = stringTokenizer.nextToken();
                    if (arrayList.contains(object2)) continue;
                    arrayList.add(object2);
                }
            }
            if (this.excludeDb != null && !this.excludeDb.equalsIgnoreCase("none")) {
                stringTokenizer = new StringTokenizer(this.excludeDb, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    object2 = stringTokenizer.nextToken();
                    if (arrayList2.contains(object2)) continue;
                    arrayList2.add(object2);
                }
            }
            if (this.procedureValue) {
                if (((SybDbStats)object).executeDbSpace(arrayList, arrayList2)) {
                    for (int i = 0; i < ((SybDbStats)object).dbNames.length; ++i) {
                        ArrayList arrayList3 = ((SybDbStats)object).getDbSpaceStats(((SybDbStats)object).dbNames[i]);
                        this.addNewMeasure(((SybDbStats)object).dbNames[i], arrayList3);
                    }
                }
            } else {
                object2 = ((SybDbStats)object).executeDbSpaceUsingQuery(arrayList, arrayList2);
                if (object2 == null || ((Hashtable)object2).size() == 0) {
                    ArrayList<Double> arrayList4 = new ArrayList<Double>();
                    for (int i = 0; i < 6; ++i) {
                        arrayList4.add(new Double(-5.0));
                    }
                    this.addNewMeasure(arrayList4);
                } else {
                    Enumeration enumeration = ((Hashtable)object2).keys();
                    while (enumeration.hasMoreElements()) {
                        String string = (String)enumeration.nextElement();
                        ArrayList arrayList5 = (ArrayList)((Hashtable)object2).get(string);
                        this.addNewMeasure(string, arrayList5);
                    }
                }
            }
            ((SybDbStats)object).close();
            object = null;
        }
        catch (Exception exception) {
            this.logToErrorFile("Error :", "SybSpaceTest Exception message ", exception.toString());
            ((SybDbStats)object).close();
            object = null;
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        SybSpaceTest sybSpaceTest = new SybSpaceTest(stringArray);
        sybSpaceTest.computeMeasures(new Hashtable());
    }
}

