/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgDateInfo;
import com.eg.IPV6Helper;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;

public class MsSqlDbStats {
    private String driver = "net.sourceforge.jtds.jdbc.Driver";
    private String firstUrl = "jdbc:jtds:sqlserver://";
    public int rowCount = 0;
    public boolean dbccUpdate = false;
    private Connection conn = null;
    public String[] dbNames;
    public String[] instanceName;
    private double[] dbSize;
    private double[] dbUtil;
    private double[] dbReserved;
    private double[] dbData;
    private double[] dbIndex;
    private double[] dbUnused;
    private ArrayList sp_monitorStats = null;
    private String excludeDb = "none";
    private ArrayList al_excludeDbs;
    private Hashtable Logdata = new Hashtable();
    public boolean blockedDetails = false;
    public boolean gotBlockedDetails = false;
    private String version = "";
    private String svr = null;
    private String port = null;
    private String db = null;
    private String pass = null;
    private String user = null;
    private String domain = null;
    private String instance = null;
    private String ssl = null;
    private boolean isNTLMv2 = false;
    private double ioMicro = -5.0;
    private double idleMicro = -5.0;
    private double cpuMicro = -5.0;
    private double packtsrcvd = -5.0;
    private double packetsent = -5.0;
    private double packteerror = -5.0;
    private double read = -5.0;
    private double write = -5.0;
    private double error = -5.0;
    private long prevTime = -5L;
    private boolean isFirstTime = true;
    private int noOfProcessor;
    public String useoption = "";
    private boolean firstTime = true;
    private Hashtable fileGrpHash = new Hashtable();
    static String mssqlSync = new String("mssqlSync");
    static Hashtable sqlActiveClusterHash = new Hashtable();
    private int timeoutSecs = 120;

    public MsSqlDbStats(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        string = IPV6Helper.getValidIPAddress((String)string);
        this.conn = this.getConnection(string, string2, string3, string4, string5, string6, string7);
        if (this.conn == null) {
            MsSqlDbStats.logToErrorFile("ERROR:", this.getClass().getName(), " connection is null for targetHost :" + string + " Port :" + string2 + " Instance : " + this.instance);
            return;
        }
    }

    public MsSqlDbStats(String string, String string2, String string3, String string4, String string5, String string6, String string7, boolean bl) {
        this.svr = string;
        this.port = string2;
        this.db = string3;
        this.user = string4;
        this.pass = string5;
        this.domain = string6;
        this.ssl = string7;
        this.isNTLMv2 = bl;
        this.svr = IPV6Helper.getValidIPAddress((String)string);
    }

    public void setConnection() {
        this.conn = this.instance == null ? this.getConnection(this.svr, this.port, this.db, this.user, this.pass, this.domain, this.ssl, this.isNTLMv2) : this.getConnection(this.svr, this.port, this.db, this.user, this.pass, this.domain, this.instance, this.ssl, this.isNTLMv2);
        if (this.conn == null) {
            MsSqlDbStats.logToErrorFile("ERROR:", this.getClass().getName(), " connection is null for targetHost :" + this.svr + " Port :" + this.port + " Instance : " + this.instance);
            return;
        }
    }

    public void setConnection(int n) {
        this.conn = this.instance == null ? this.getConnection(this.svr, this.port, this.db, this.user, this.pass, this.domain, this.ssl, this.isNTLMv2, this.timeoutSecs) : this.getConnection(this.svr, this.port, this.db, this.user, this.pass, this.domain, this.instance, this.ssl, this.isNTLMv2, this.timeoutSecs);
        if (this.conn == null) {
            MsSqlDbStats.logToErrorFile("ERROR:", this.getClass().getName(), " connection is null for targetHost :" + this.svr + " Port :" + this.port + " Instance : " + this.instance);
            return;
        }
    }

    public MsSqlDbStats(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, boolean bl) {
        string = IPV6Helper.getValidIPAddress((String)string);
        this.isNTLMv2 = bl;
        this.conn = this.getConnection(string, string2, string3, string4, string5, string6, string7, string8, bl);
        if (this.conn == null) {
            MsSqlDbStats.logToErrorFile("ERROR:", this.getClass().getName(), " connection is null for targetHost :" + string + " Port :" + string2 + " Instance : " + string7);
            return;
        }
    }

    public MsSqlDbStats(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, boolean bl, boolean bl2) {
        this.svr = string;
        this.port = string2;
        this.db = string3;
        this.user = string4;
        this.pass = string5;
        this.domain = string6;
        this.instance = string7;
        this.ssl = string8;
        this.isNTLMv2 = bl2;
        this.svr = IPV6Helper.getValidIPAddress((String)string);
    }

    public MsSqlDbStats(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, boolean bl, boolean bl2, int n) {
        this.svr = string;
        this.port = string2;
        this.db = string3;
        this.user = string4;
        this.pass = string5;
        this.domain = string6;
        this.instance = string7;
        this.ssl = string8;
        this.isNTLMv2 = bl2;
        this.svr = IPV6Helper.getValidIPAddress((String)string);
        this.timeoutSecs = n;
    }

    public MsSqlDbStats(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, boolean bl, boolean bl2, int n, int n2) {
        this.svr = string;
        this.port = string2;
        this.db = string3;
        this.user = string4;
        this.pass = string5;
        this.domain = string6;
        this.instance = string7;
        this.ssl = string8;
        this.isNTLMv2 = bl2;
        this.noOfProcessor = n;
        this.svr = IPV6Helper.getValidIPAddress((String)string);
        this.timeoutSecs = n2;
        System.out.println("Msdbstatstest noOfProcessor:::" + this.noOfProcessor);
    }

    public MsSqlDbStats(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, boolean bl, int n) {
        string = IPV6Helper.getValidIPAddress((String)string);
        this.isNTLMv2 = bl;
        this.conn = this.getConnection(string, string2, string3, string4, string5, string6, string7, string8, bl);
        if (this.conn == null) {
            MsSqlDbStats.logToErrorFile("ERROR:", this.getClass().getName(), " connection is null for targetHost :" + string + " Port :" + string2 + " Instance : " + string7);
            return;
        }
    }

    public void setLogTable(Hashtable hashtable) {
        this.Logdata = (Hashtable)hashtable.clone();
    }

    public void setExcludeDb(String string) {
        if (string != null && !string.equalsIgnoreCase("none")) {
            this.al_excludeDbs = new ArrayList();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",:;");
            while (stringTokenizer.hasMoreTokens()) {
                this.al_excludeDbs.add(stringTokenizer.nextToken());
            }
        }
    }

    public boolean executeLogSpace() {
        String string;
        int n;
        if (this.conn == null) {
            return false;
        }
        ArrayList<String> arrayList = this.getDatabases(this.conn);
        if (arrayList == null) {
            this.dbNames = null;
            return false;
        }
        if (this.al_excludeDbs != null && this.al_excludeDbs.size() > 0) {
            ArrayList<String> arrayList2 = new ArrayList<String>();
            for (n = 0; n < arrayList.size(); ++n) {
                string = (String)arrayList.get(n);
                if (this.al_excludeDbs.contains(string)) continue;
                arrayList2.add(string);
            }
            arrayList = arrayList2;
        }
        int n2 = arrayList.size();
        this.dbNames = new String[n2];
        for (n = 0; n < n2; ++n) {
            this.dbNames[n] = string = (String)arrayList.get(n);
        }
        return true;
    }

    public boolean executeDbSpace() {
        String string;
        int n;
        if (this.conn == null) {
            return false;
        }
        ArrayList<String> arrayList = this.getDatabases(this.conn);
        if (arrayList == null) {
            this.dbNames = null;
            return false;
        }
        if (this.al_excludeDbs != null && this.al_excludeDbs.size() > 0) {
            ArrayList<String> arrayList2 = new ArrayList<String>();
            for (n = 0; n < arrayList.size(); ++n) {
                string = (String)arrayList.get(n);
                if (this.al_excludeDbs.contains(string)) continue;
                arrayList2.add(string);
            }
            arrayList = arrayList2;
        }
        int n2 = arrayList.size();
        this.dbNames = new String[n2];
        this.dbSize = new double[n2];
        this.dbUtil = new double[n2];
        this.dbReserved = new double[n2];
        this.dbData = new double[n2];
        this.dbIndex = new double[n2];
        this.dbUnused = new double[n2];
        for (n = 0; n < n2; ++n) {
            this.dbNames[n] = string = (String)arrayList.get(n);
            this.getSpaceUsageFor(this.conn, string, n);
        }
        return true;
    }

    public ArrayList executeQuery(String string, String string2, int n) {
        this.rowCount = 0;
        if (this.conn == null) {
            return null;
        }
        Statement statement = null;
        ResultSet resultSet = null;
        ArrayList<String> arrayList = null;
        arrayList = n == -1 ? new ArrayList<String>() : new ArrayList(n);
        try {
            try {
                statement = this.conn.createStatement();
            }
            catch (Exception exception) {
                MsSqlDbStats.logToErrorFile("ERROR:", this.getClass().getName() + " Failed to Create Statement targetHost :" + this.svr + " Port :" + this.port + " Instance : " + this.instance, exception.toString());
                exception.printStackTrace();
                return null;
            }
            int n2 = statement.getFetchSize();
            this.conn.setAutoCommit(false);
            statement.setFetchSize(10);
            statement.setQueryTimeout(600);
            resultSet = statement.executeQuery(string);
            if (resultSet == null) {
                this.closeStmt(statement);
                return null;
            }
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n3 = resultSetMetaData.getColumnCount();
            int n4 = 0;
            boolean bl = true;
            resultSet.setFetchSize(10);
            while (resultSet.next()) {
                String string3 = "";
                if (bl) {
                    String string4 = "";
                    StringBuffer stringBuffer = new StringBuffer();
                    for (int i = 1; i <= n3; ++i) {
                        try {
                            string4 = resultSet.getString(i);
                            if (string4 != null) {
                                string4 = string4.trim();
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        if (string4 != null && string4.trim().length() > 0) {
                            stringBuffer.append(string4);
                        } else {
                            stringBuffer.append("-");
                        }
                        if (i >= n3) continue;
                        stringBuffer.append(string2);
                    }
                    string3 = stringBuffer.toString();
                }
                if (++n4 <= n || n == -1) {
                    arrayList.add(string3);
                    continue;
                }
                bl = false;
            }
            this.rowCount = n4;
            statement.setFetchSize(n2);
            this.closeRs(resultSet);
            this.closeStmt(statement);
        }
        catch (Exception exception) {
            MsSqlDbStats.logToErrorFile("ERROR:", this.getClass().getName() + " Exception in executeQuery() targetHost :" + this.svr + " Port :" + this.port + " Instance : " + this.instance, exception.toString());
            exception.printStackTrace();
            this.closeRs(resultSet);
            this.closeStmt(statement);
            arrayList = null;
        }
        return arrayList;
    }

    public ArrayList getTopApps() {
        Statement statement = null;
        ResultSet resultSet = null;
        String string = "SELECT REPLACE( convert(varchar(128), program_name), left(convert(varchar(128), program_name), charindex(']',convert(varchar(128), program_name))), '' ) as Program,count(*) as CliCount,sum(convert(bigint,cpu)) as cpu,sum(convert(bigint,datediff(second, login_time, getdate() ) ))  time_in_secs FROM\tmaster.dbo.sysprocesses with (NOLOCK) WHERE \tdatediff(second, login_time, getdate() ) > 0 and spid > 50  GROUP BY REPLACE( convert(varchar(128), program_name), left(convert(varchar(128), program_name), charindex(']',convert(varchar(128), program_name))), '' )";
        System.out.println("[MsSqlAppsTest]query====>" + string);
        ArrayList arrayList = new ArrayList();
        try {
            if (this.conn != null) {
                try {
                    statement = this.conn.createStatement();
                }
                catch (Exception exception) {
                    MsSqlDbStats.logToErrorFile("ERROR:", this.getClass().getName(), " Failed to create statement targetHost :" + this.svr + " Port :" + this.port + " Instance : " + this.instance);
                    exception.printStackTrace();
                    return null;
                }
            }
            if (statement != null) {
                resultSet = statement.executeQuery(string);
            }
            if (resultSet == null) {
                this.closeStmt(statement);
                return null;
            }
            while (resultSet.next()) {
                String string2 = "";
                ArrayList<Object> arrayList2 = new ArrayList<Object>();
                String string3 = resultSet.getString(1);
                if (string3 == null || string3.trim().length() == 0) continue;
                if ((string3 = string3.trim()).indexOf("Microsoft") > -1 && string3.indexOf("Windows") > -1 && string3.indexOf("Operating") > -1 && string3.indexOf("System") > -1) {
                    System.out.println("[MsSqlAppsTest]program name received====>" + string3);
                    string3 = "Microsoft\u00ae Windows\u00ae Operating System";
                }
                System.out.println("[MsSqlAppsTest]program====>" + string3);
                double d = resultSet.getDouble(2);
                double d2 = resultSet.getDouble(3);
                double d3 = resultSet.getDouble(4);
                double d4 = 0.0;
                if (d3 > 0.0) {
                    d4 = d2 /= d3;
                }
                if (d > 0.0) {
                    d4 /= d;
                }
                if (string3 == null || string3.length() <= 0) continue;
                arrayList2.add(string3);
                arrayList2.add(new Double(d));
                arrayList2.add(new Double(d2));
                arrayList2.add(new Double(d4));
                arrayList.add(arrayList2);
            }
            this.closeRs(resultSet);
            this.closeStmt(statement);
        }
        catch (Exception exception) {
            System.out.println("exception =  " + exception);
            exception.printStackTrace();
            this.closeRs(resultSet);
            this.closeStmt(statement);
        }
        return arrayList;
    }

    public ArrayList getAppDetails() {
        String string;
        String string2;
        ArrayList arrayList;
        Statement statement = null;
        ResultSet resultSet = null;
        String string3 = "SELECT TOP 10 spid,convert(varchar(64),db_name(dbid)) as DBName,cpu,datediff(second,login_time, getdate()) as Secs,convert(float, cpu / datediff(second,login_time, getdate())) as PScore,convert(varchar(64), hostname) as Host,REPLACE( convert(varchar(128), program_name), left(convert(varchar(128), program_name), charindex(']',convert(varchar(128), program_name))), '' ) as Program,convert(varchar(64), loginame) as Login,convert(varchar (64), NT_username) as NTUser,convert(varchar (64), NT_Domain) as NTDomain FROM\tmaster.dbo.sysprocesses with (NOLOCK) WHERE\tdatediff(second,login_time, getdate()) > 0 and \tspid > 50 and \tloginame<> '" + this.user + "' ORDER BY pscore desc";
        ArrayList<ArrayList> arrayList2 = new ArrayList<ArrayList>();
        try {
            if (this.conn != null) {
                try {
                    statement = this.conn.createStatement();
                }
                catch (Exception exception) {
                    MsSqlDbStats.logToErrorFile("ERROR:", this.getClass().getName(), " Failed to create statement targetHost :" + this.svr + " Port :" + this.port + " Instance : " + this.instance);
                    exception.printStackTrace();
                    return null;
                }
            }
            if (statement != null) {
                resultSet = statement.executeQuery(string3);
            }
            if (resultSet == null) {
                this.closeStmt(statement);
                return null;
            }
            while (resultSet.next()) {
                String string4 = "";
                arrayList = new ArrayList();
                string2 = resultSet.getString(1).trim();
                string = resultSet.getString(2).trim();
                double d = resultSet.getDouble(3);
                double d2 = resultSet.getDouble(4);
                double d3 = resultSet.getDouble(5);
                String string5 = resultSet.getString(6).trim();
                String string6 = resultSet.getString(7).trim();
                String string7 = resultSet.getString(8).trim();
                String string8 = resultSet.getString(9);
                if (string6.indexOf("Microsoft") > -1 && string6.indexOf("Windows") > -1 && string6.indexOf("Operating") > -1 && string6.indexOf("System") > -1) {
                    string6 = "Microsoft\u00ae Windows\u00ae Operating System";
                }
                if (string8 == null) {
                    string8 = "-";
                } else if ((string8 = string8.trim()).length() == 0) {
                    string8 = "-";
                }
                String string9 = resultSet.getString(10);
                if (string9 == null) {
                    string9 = "-";
                } else if ((string9 = string9.trim()).length() == 0) {
                    string9 = "-";
                }
                string8 = string8.trim();
                string9 = string9.trim();
                arrayList.add(string2);
                arrayList.add(string);
                arrayList.add(string5);
                arrayList.add(string6);
                arrayList.add(string7);
                arrayList.add(new Double(d));
                arrayList.add(new Double(d2));
                arrayList.add(new Double(d3));
                arrayList.add(string8);
                arrayList.add(string9);
                arrayList2.add(arrayList);
            }
            this.closeRs(resultSet);
            this.closeStmt(statement);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.closeRs(resultSet);
            this.closeStmt(statement);
        }
        for (int i = 0; i < arrayList2.size(); ++i) {
            arrayList = (ArrayList)arrayList2.get(i);
            string2 = (String)arrayList.get(0);
            string = this.getCommandFor(string2);
            arrayList.add(string);
        }
        return arrayList2;
    }

    public ArrayList getBlockers() {
        String string;
        String string2;
        ArrayList arrayList;
        boolean bl = false;
        Statement statement = null;
        ResultSet resultSet = null;
        String string3 = "";
        HashMap hashMap = new HashMap();
        if (this.version.trim().length() == 0 && (hashMap = this.getVersion(true)) != null && hashMap.size() > 0) {
            this.version = (String)hashMap.get("productSeries");
        }
        if (this.version.trim().startsWith("8.") || this.version.trim().startsWith("7.")) {
            string3 = "SELECT distinct spid,loginame,DB_NAME(dbid),cmd,physical_io,memusage from master.dbo.sysprocesses with (NOLOCK) WHERE blocked = 0 AND spid in (select blocked from master.dbo.sysprocesses with (NOLOCK) ) ";
        } else {
            string3 = "SELECT distinct a.spid,a.loginame,DB_NAME(a.dbid),a.cmd,a.physical_io,(a.memusage*8) as memory_usage_kb,a.Sql_handle, a.program_name,b.total_elapsed_time as total_elapsed_time_millsec from master.dbo.sysprocesses as a with (NOLOCK) , sys.dm_exec_requests as b WHERE blocked = 0 and a.spid = b.session_id AND spid in (select blocked from master.dbo.sysprocesses with (NOLOCK)) order by b.total_elapsed_time desc";
            bl = true;
        }
        ArrayList<ArrayList> arrayList2 = new ArrayList<ArrayList>();
        try {
            if (this.conn != null) {
                statement = this.conn.createStatement();
            }
            if (statement != null) {
                resultSet = statement.executeQuery(string3);
            }
            if (resultSet == null) {
                this.closeStmt(statement);
                return null;
            }
            while (resultSet.next()) {
                String string4 = "";
                arrayList = new ArrayList();
                string2 = resultSet.getString(1).trim();
                string = resultSet.getString(2).trim();
                String string5 = resultSet.getString(3).trim();
                String string6 = resultSet.getString(4);
                double d = resultSet.getDouble(5);
                double d2 = resultSet.getDouble(6);
                arrayList.add(string2);
                arrayList.add(string);
                arrayList.add(string5);
                arrayList.add(string6);
                arrayList.add(new Double(d));
                arrayList.add(new Double(d2));
                if (bl) {
                    String string7 = resultSet.getString(8);
                    double d3 = resultSet.getDouble(9);
                    string7 = string7.trim();
                    arrayList.add(string7);
                    arrayList.add(new Double(d3));
                } else {
                    arrayList.add("N/A");
                    arrayList.add("N/A");
                }
                arrayList2.add(arrayList);
            }
            this.closeRs(resultSet);
            this.closeStmt(statement);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.closeRs(resultSet);
            this.closeStmt(statement);
        }
        for (int i = 0; i < arrayList2.size(); ++i) {
            arrayList = (ArrayList)arrayList2.get(i);
            string2 = (String)arrayList.get(0);
            string = this.getCommandFor(string2);
            arrayList.set(3, string);
        }
        return arrayList2;
    }

    public ArrayList getDbSpaceStats(String string) {
        int n = 6;
        if (this.dbNames == null || this.dbNames.length == 0) {
            ArrayList<Double> arrayList = new ArrayList<Double>();
            for (int i = 0; i < n; ++i) {
                arrayList.add(new Double(-5.0));
            }
            return arrayList;
        }
        int n2 = -1;
        for (int i = 0; i < this.dbNames.length; ++i) {
            if (!this.dbNames[i].equals(string)) continue;
            n2 = i;
            break;
        }
        if (n2 < 0) {
            ArrayList<Double> arrayList = new ArrayList<Double>();
            for (int i = 0; i < n; ++i) {
                arrayList.add(new Double(-5.0));
            }
            return arrayList;
        }
        ArrayList<Double> arrayList = new ArrayList<Double>();
        arrayList.add(new Double(this.dbSize[n2]));
        arrayList.add(new Double(this.dbUtil[n2]));
        arrayList.add(new Double(this.dbReserved[n2]));
        arrayList.add(new Double(this.dbData[n2]));
        arrayList.add(new Double(this.dbIndex[n2]));
        arrayList.add(new Double(this.dbUnused[n2]));
        return arrayList;
    }

    public ArrayList getSpMonitorStats() {
        return this.sp_monitorStats;
    }

    public String getCommandFor(String string) {
        String string2;
        String string3;
        if (this.conn == null) {
            return null;
        }
        Statement statement = null;
        ResultSet resultSet = null;
        String string4 = null;
        HashMap hashMap = new HashMap();
        if (!this.gotBlockedDetails || this.blockedDetails) {
            if (this.version.trim().length() == 0 && (hashMap = this.getVersion(true)) != null && hashMap.size() > 0) {
                this.version = (String)hashMap.get("productSeries");
            }
            string4 = this.version.trim().startsWith("8.") || this.version.trim().startsWith("7.") ? "DECLARE @handle binary(20)\n SELECT @handle = sql_handle FROM master..sysprocesses WHERE spid = " + string + "\nSELECT [text]    FROM ::fn_get_sql(@handle)" : "DECLARE @handle binary(20)\n SELECT @handle = sql_handle FROM master..sysprocesses WHERE spid = " + string + "\nSELECT [text]     FROM sys.dm_exec_sql_text(@handle)";
            this.gotBlockedDetails = true;
            try {
                statement = this.conn.createStatement();
                if (!this.gotBlockedDetails) {
                    this.blockedDetails = false;
                }
                statement.execute(string4);
                resultSet = statement.getResultSet();
                if (resultSet == null) {
                    this.closeStmt(statement);
                    return null;
                }
                string3 = "";
                while (resultSet.next()) {
                    string2 = resultSet.getString(1);
                    string2 = string2.trim();
                    string2 = string2.replace('\n', ' ');
                    string2 = string2.replace('\r', ' ');
                    if ((string3 = string3 + string2 + "<br>") == null || string3.length() <= 0) continue;
                    this.blockedDetails = true;
                }
                this.closeRs(resultSet);
                this.closeStmt(statement);
                if (this.blockedDetails) {
                    return string3;
                }
            }
            catch (Exception exception) {
                this.closeRs(resultSet);
                this.closeStmt(statement);
                this.blockedDetails = false;
            }
        }
        if (!this.blockedDetails) {
            string3 = "DBCC INPUTBUFFER(";
            string3 = string3 + string + ")";
            try {
                statement = this.conn.createStatement();
                statement.execute(string3);
                resultSet = statement.getResultSet();
                if (resultSet == null) {
                    this.closeStmt(statement);
                    return null;
                }
                string2 = "";
                while (resultSet.next()) {
                    String string5 = resultSet.getString("EventInfo");
                    string5 = string5.trim();
                    string5 = string5.replace('\n', ' ');
                    string5 = string5.replace('\r', ' ');
                    string2 = string2 + string5 + "<br>";
                }
                this.closeRs(resultSet);
                this.closeStmt(statement);
                return string2;
            }
            catch (Exception exception) {
                this.closeRs(resultSet);
                this.closeStmt(statement);
                return null;
            }
        }
        return null;
    }

    public boolean executeSpMonitor() {
        if (this.conn == null) {
            return false;
        }
        Statement statement = null;
        ResultSet resultSet = null;
        String string = "sp_monitor";
        double d = -5.0;
        double d2 = -5.0;
        double d3 = -5.0;
        double d4 = -5.0;
        double d5 = -5.0;
        double d6 = -5.0;
        double d7 = -5.0;
        double d8 = -5.0;
        double d9 = -5.0;
        try {
            String string2;
            statement = this.conn.createStatement();
            resultSet = statement.executeQuery(string);
            if (resultSet == null) {
                this.closeStmt(statement);
                return false;
            }
            long l = 0L;
            while (resultSet.next()) {
                string2 = resultSet.getString("seconds");
                l = Long.parseLong(string2);
            }
            this.closeRs(resultSet);
            if (statement.getMoreResults()) {
                resultSet = statement.getResultSet();
                if (resultSet == null) {
                    this.closeStmt(statement);
                    return false;
                }
                string2 = null;
                String string3 = null;
                String string4 = null;
                while (resultSet.next()) {
                    string2 = resultSet.getString("cpu_busy");
                    string3 = resultSet.getString("io_busy");
                    string4 = resultSet.getString("idle");
                }
                this.closeRs(resultSet);
                d = this.parse_spmon(string2);
                d2 = this.parse_spmon(string3);
                d3 = this.parse_spmon(string4);
                double d10 = 0.0;
                if (d > 0.0) {
                    d10 += d;
                }
                if (d2 > 0.0) {
                    d10 += d2;
                }
                if (d3 > 0.0) {
                    d10 += d3;
                }
                if (d10 > 0.0) {
                    d = d / d10 * 100.0;
                    d2 = d2 / d10 * 100.0;
                    d3 = d3 / d10 * 100.0;
                }
                if (this.noOfProcessor > 0) {
                    d /= (double)this.noOfProcessor;
                    d2 /= (double)this.noOfProcessor;
                    d3 /= (double)this.noOfProcessor;
                } else {
                    d = -5.0;
                    d2 = -5.0;
                    d3 = -5.0;
                }
                if (statement.getMoreResults()) {
                    resultSet = statement.getResultSet();
                    if (resultSet == null) {
                        this.closeStmt(statement);
                        return false;
                    }
                    while (resultSet.next()) {
                        string2 = resultSet.getString("packets_received");
                        string3 = resultSet.getString("packets_sent");
                        string4 = resultSet.getString("packet_errors");
                    }
                    this.closeRs(resultSet);
                    if (l > 0L) {
                        d7 = (double)this.parse_spmon2(string2) / (double)l;
                        d8 = (double)this.parse_spmon2(string3) / (double)l;
                        d9 = (double)this.parse_spmon2(string4) / (double)l;
                    }
                    if (statement.getMoreResults()) {
                        resultSet = statement.getResultSet();
                        if (resultSet == null) {
                            this.closeStmt(statement);
                            return false;
                        }
                        while (resultSet.next()) {
                            string2 = resultSet.getString("total_read");
                            string3 = resultSet.getString("total_write");
                            string4 = resultSet.getString("total_errors");
                        }
                        this.closeRs(resultSet);
                        if (l > 0L) {
                            d4 = (double)this.parse_spmon2(string2) / (double)l;
                            d5 = (double)this.parse_spmon2(string3) / (double)l;
                            d6 = (double)this.parse_spmon2(string4) / (double)l;
                        }
                    }
                }
            }
            this.closeStmt(statement);
            d = d < 0.0 ? -5.0 : d;
            d2 = d2 < 0.0 ? -5.0 : d2;
            d3 = d3 < 0.0 ? -5.0 : d3;
            d4 = d4 < 0.0 ? -5.0 : d4;
            d5 = d5 < 0.0 ? -5.0 : d5;
            d6 = d6 < 0.0 ? -5.0 : d6;
            d7 = d7 < 0.0 ? -5.0 : d7;
            d8 = d8 < 0.0 ? -5.0 : d8;
            d9 = d9 < 0.0 ? -5.0 : d9;
            this.sp_monitorStats = new ArrayList(9);
            this.sp_monitorStats.add(new Double(d));
            this.sp_monitorStats.add(new Double(d2));
            this.sp_monitorStats.add(new Double(d3));
            this.sp_monitorStats.add(new Double(d7));
            this.sp_monitorStats.add(new Double(d8));
            this.sp_monitorStats.add(new Double(d9));
            this.sp_monitorStats.add(new Double(d4));
            this.sp_monitorStats.add(new Double(d5));
            this.sp_monitorStats.add(new Double(d6));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.closeRs(resultSet);
            this.closeStmt(statement);
            return false;
        }
        return true;
    }

    public boolean executeQueryMonitor(int n, String string) {
        if (this.conn == null) {
            MsSqlDbStats.logToErrorFile("ERROR:", this.getClass().getName(), " connection is null for reportingName : " + string + " targetHost :" + this.svr + " Port :" + this.port + " Instance : " + this.instance);
            return false;
        }
        Statement statement = null;
        ResultSet resultSet = null;
        double d = -1.0;
        double d2 = -1.0;
        double d3 = -1.0;
        double d4 = -1.0;
        double d5 = -1.0;
        double d6 = -1.0;
        double d7 = -1.0;
        double d8 = -1.0;
        double d9 = -1.0;
        double d10 = -1.0;
        long l = System.currentTimeMillis();
        String string2 = "select @@IO_BUSY AS 'IO microseconds',@@IDLE AS 'Idle microseconds',@@CPU_BUSY AS 'CPU microseconds',@@PACK_RECEIVED AS 'Packets Received',@@PACK_SENT AS 'Pack Sent',@@PACKET_ERRORS AS 'Packet Errors',@@CONNECTIONS AS 'Login Attempts',@@TOTAL_ERRORS AS 'Errors',@@TOTAL_READ AS 'Reads', @@TOTAL_WRITE AS 'Writes',@@TIMETICKS AS 'Time Picks'";
        double d11 = -5.0;
        double d12 = -5.0;
        double d13 = -5.0;
        double d14 = -5.0;
        double d15 = -5.0;
        double d16 = -5.0;
        double d17 = -5.0;
        double d18 = -5.0;
        double d19 = -5.0;
        try {
            statement = this.conn.createStatement();
            resultSet = statement.executeQuery(string2);
            if (resultSet == null) {
                this.closeStmt(statement);
                this.isFirstTime = true;
                return false;
            }
            long l2 = 0L;
            while (resultSet.next()) {
                d2 = resultSet.getDouble(1);
                d3 = resultSet.getDouble(2);
                d = resultSet.getDouble(3);
                d4 = resultSet.getDouble(4);
                d5 = resultSet.getDouble(5);
                d6 = resultSet.getDouble(6);
                d9 = resultSet.getDouble(8);
                d7 = resultSet.getDouble(9);
                d8 = resultSet.getDouble(10);
                d10 = resultSet.getDouble(11);
            }
            this.closeRs(resultSet);
            this.closeStmt(statement);
            if (this.isFirstTime) {
                this.isFirstTime = false;
                this.ioMicro = d2;
                this.idleMicro = d3;
                this.cpuMicro = d;
                this.packtsrcvd = d4;
                this.packetsent = d5;
                this.packteerror = d6;
                this.read = d7;
                this.write = d8;
                this.error = d9;
                this.prevTime = l;
                return false;
            }
            l2 = (l - this.prevTime) / 1000L;
            if (!(d >= 0.0 && d2 >= 0.0 && d3 >= 0.0)) {
                this.isFirstTime = true;
                MsSqlDbStats.logToErrorFile("Error :", "MsSqlEngineTest executeQueryMonitor", "Possible Error code could be msg:8115 Arithmetic overflow error in " + string);
                return false;
            }
            d11 = (d - this.cpuMicro) * d10 * 100.0 / (double)(l2 * 1000L * 1000L);
            d12 = (d2 - this.ioMicro) * d10 * 100.0 / (double)(l2 * 1000L * 1000L);
            d13 = (d3 - this.idleMicro) * d10 * 100.0 / (double)(l2 * 1000L * 1000L);
            double d20 = 0.0;
            if (d11 > 0.0) {
                d20 += d11;
            }
            if (d12 > 0.0) {
                d20 += d12;
            }
            if (d13 > 0.0) {
                d20 += d13;
            }
            if (d20 > 0.0) {
                d11 = d11 / d20 * 100.0;
                d12 = d12 / d20 * 100.0;
                d13 = d13 / d20 * 100.0;
            }
            if (this.noOfProcessor > 0) {
                d11 /= (double)this.noOfProcessor;
                d12 /= (double)this.noOfProcessor;
                d13 /= (double)this.noOfProcessor;
            } else {
                d11 = -5.0;
                d12 = -5.0;
                d13 = -5.0;
            }
            if (l2 > 0L) {
                if (d4 >= 0.0) {
                    d17 = (d4 - this.packtsrcvd) / (double)l2;
                }
                if (d5 >= 0.0) {
                    d18 = (d5 - this.packetsent) / (double)l2;
                }
                if (d6 >= 0.0) {
                    d19 = (d6 - this.packteerror) / (double)l2;
                }
            }
            if (l2 > 0L) {
                if (d7 >= 0.0) {
                    d14 = (d7 - this.read) / (double)l2;
                }
                if (d8 >= 0.0) {
                    d15 = (d8 - this.write) / (double)l2;
                }
                if (d9 >= 0.0) {
                    d16 = (d9 - this.error) / (double)l2;
                }
            }
            d11 = d11 < 0.0 ? -5.0 : d11;
            d12 = d12 < 0.0 ? -5.0 : d12;
            d13 = d13 < 0.0 ? -5.0 : d13;
            d14 = d14 < 0.0 ? -5.0 : d14;
            d15 = d15 < 0.0 ? -5.0 : d15;
            d16 = d16 < 0.0 ? -5.0 : d16;
            d17 = d17 < 0.0 ? -5.0 : d17;
            d18 = d18 < 0.0 ? -5.0 : d18;
            d19 = d19 < 0.0 ? -5.0 : d19;
            this.ioMicro = d2;
            this.idleMicro = d3;
            this.cpuMicro = d;
            this.packtsrcvd = d4;
            this.packetsent = d5;
            this.packteerror = d6;
            this.read = d7;
            this.write = d8;
            this.error = d9;
            this.prevTime = l;
            this.sp_monitorStats = new ArrayList();
            this.sp_monitorStats.add(new Double(d11));
            this.sp_monitorStats.add(new Double(d12));
            this.sp_monitorStats.add(new Double(d13));
            this.sp_monitorStats.add(new Double(d17));
            this.sp_monitorStats.add(new Double(d18));
            this.sp_monitorStats.add(new Double(d19));
            this.sp_monitorStats.add(new Double(d14));
            this.sp_monitorStats.add(new Double(d15));
            this.sp_monitorStats.add(new Double(d16));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.closeRs(resultSet);
            this.closeStmt(statement);
            return false;
        }
        return true;
    }

    public void close() {
        if (this.conn == null) {
            return;
        }
        try {
            this.conn.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private int parse_spmon(String string) {
        if (string == null) {
            return -1;
        }
        int n = -1;
        n = string.indexOf("-");
        if (n >= 0) {
            string = string.substring(n + 1);
            string = string.replace('%', ' ');
            string = string.trim();
            int n2 = -1;
            try {
                n2 = Integer.parseInt(string);
            }
            catch (Exception exception) {
                n2 = -1;
            }
            if (n2 < 0) {
                n2 = -1;
            }
            return n2;
        }
        return -1;
    }

    private int parse_spmon2(String string) {
        if (string == null) {
            return -1;
        }
        int n = -1;
        n = string.indexOf("(");
        if (n >= 0) {
            string = string.substring(n + 1);
            string = string.replace(')', ' ');
            string = string.trim();
            int n2 = -1;
            try {
                n2 = Integer.parseInt(string);
            }
            catch (Exception exception) {
                n2 = -1;
            }
            if (n2 < 0) {
                n2 = -1;
            }
            return n2;
        }
        return -1;
    }

    private void getSpaceUsageFor(Connection connection, String string, int n) {
        Statement statement = null;
        ResultSet resultSet = null;
        String string2 = "USE \"" + string + "\"";
        String string3 = "sp_spaceused";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "";
        String string8 = "";
        String string9 = "";
        String string10 = "";
        double d = -5.0;
        boolean bl = false;
        String string11 = "SELECT  b.groupname AS 'File Group', [Filename],a.groupid FROM sys.sysfiles a (NOLOCK) JOIN sys.sysfilegroups b (NOLOCK) ON a.groupid = b.groupid ORDER BY b.groupname";
        try {
            Serializable serializable;
            if (this.dbccUpdate) {
                string10 = " @updateusage = 'TRUE'";
            }
            if (connection != null) {
                statement = connection.createStatement();
            }
            if (statement != null) {
                statement.execute(string2);
                resultSet = statement.executeQuery(string3 + string10);
            }
            if (resultSet == null) {
                this.dbSize[n] = -5.0;
                this.dbUtil[n] = -5.0;
                this.dbReserved[n] = -5.0;
                this.dbData[n] = -5.0;
                this.dbIndex[n] = -5.0;
                this.dbUnused[n] = -5.0;
                bl = true;
            }
            if (!bl) {
                while (resultSet.next()) {
                    string4 = resultSet.getString("database_size");
                }
                this.closeRs(resultSet);
                if (statement.getMoreResults()) {
                    resultSet = statement.getResultSet();
                    if (resultSet == null) {
                        bl = true;
                    }
                    if (!bl) {
                        while (resultSet.next()) {
                            string7 = resultSet.getString("reserved");
                            string6 = resultSet.getString("data");
                            string8 = resultSet.getString("index_size");
                            string9 = resultSet.getString("unused");
                        }
                        this.closeRs(resultSet);
                    }
                }
            }
            if (statement != null) {
                serializable = new Hashtable();
                resultSet = statement.executeQuery(string11);
                if (resultSet == null) {
                    MsSqlDbStats.logToErrorFile(this.getClass().getName(), " Result set is null for filegroup usage of a DB  ", " getSpaceUsageFor method");
                } else {
                    while (resultSet.next()) {
                        String string12 = resultSet.getString(1).trim();
                        String string13 = resultSet.getString(2).trim();
                        String string14 = resultSet.getString(3).trim();
                        String string15 = string + ":" + string12;
                        ((Hashtable)serializable).put(string14, string15);
                    }
                    this.closeRs(resultSet);
                    this.fileGrpHash.put(string, serializable);
                }
            }
            this.closeRs(resultSet);
            this.closeStmt(statement);
            if (bl) {
                return;
            }
            if (this.Logdata != null && this.Logdata.size() > 0) {
                serializable = (Double)this.Logdata.get(string);
                d = serializable != null ? (Double)serializable : 0.0;
            }
            double d2 = -5.0;
            double d3 = -5.0;
            double d4 = -5.0;
            double d5 = -5.0;
            double d6 = -5.0;
            d2 = this.parse(string4);
            if (d >= 0.0) {
                d2 -= (d /= 1024.0);
            }
            d3 = this.parse(string7);
            d4 = this.parse(string6);
            d5 = this.parse(string8);
            d6 = this.parse(string9);
            double d7 = -5.0;
            if (d2 != 0.0) {
                d7 = d3 * 100.0 / d2;
            }
            if (d7 >= 100.0) {
                d7 = 100.0;
            }
            this.dbSize[n] = d2;
            this.dbUtil[n] = d7;
            this.dbReserved[n] = d3;
            this.dbData[n] = d4;
            this.dbIndex[n] = d5;
            this.dbUnused[n] = d6;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.closeRs(resultSet);
            this.closeStmt(statement);
            this.dbSize[n] = -5.0;
            this.dbUtil[n] = -5.0;
            this.dbReserved[n] = -5.0;
            this.dbData[n] = -5.0;
            this.dbIndex[n] = -5.0;
            this.dbUnused[n] = -5.0;
        }
    }

    private double parse(String string) {
        try {
            if (string == null || string.length() == 0) {
                return -5.0;
            }
            if (string.indexOf("MB") < 0 && string.indexOf("KB") < 0) {
                return -5.0;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            if (stringTokenizer.countTokens() < 2) {
                return -5.0;
            }
            String string2 = stringTokenizer.nextToken();
            double d = Double.parseDouble(string2);
            if (stringTokenizer.nextToken().equalsIgnoreCase("KB")) {
                d /= 1024.0;
            }
            return d;
        }
        catch (Exception exception) {
            return -5.0;
        }
    }

    private double parseDouble(String string) {
        double d = -5.0;
        try {
            string = string.trim();
            d = Double.parseDouble(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return d;
    }

    private void closeStmt(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void closeRs(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private Connection getConnection(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        return this.getConnection(string, string2, string3, string4, string5, string6, string7, false);
    }

    private Connection getConnection(String string, String string2, String string3, String string4, String string5, String string6, String string7, boolean bl) {
        try {
            if (string6 == null) {
                string6 = "none";
            }
            Class.forName(this.driver);
            Properties properties = new Properties();
            if (string6 != null && !string6.equalsIgnoreCase("none")) {
                properties.put("user", string4);
                properties.put("password", string5);
                properties.put("domain", string6);
                properties.put("useNTLMv2", bl + "");
            } else {
                properties.put("user", string4);
                properties.put("password", string5);
            }
            String string8 = this.firstUrl + string + ":" + string2 + "/" + string3 + ";charset=utf8";
            if (string7 != null && "true".equalsIgnoreCase(string7)) {
                string8 = string8 + ";ssl=request";
            }
            System.out.println("SQL DB URL  " + string8);
            String string9 = new String(string8);
            this.conn = this.newConnection(string9, properties);
            if (this.conn == null) {
                MsSqlDbStats.logToErrorFile(this.getClass().getName(), " MsSql db Connection  is null  ", " Host IP Address is  " + string);
                return null;
            }
            this.conn.setAutoCommit(false);
            this.conn.setTransactionIsolation(1);
            return this.conn;
        }
        catch (Exception exception) {
            System.err.println("Failed to establish a MsSql db connection with " + string);
            exception.printStackTrace();
            return null;
        }
    }

    private Connection getConnection(String string, String string2, String string3, String string4, String string5, String string6, String string7, boolean bl, int n) {
        try {
            if (string6 == null) {
                string6 = "none";
            }
            Class.forName(this.driver);
            Properties properties = new Properties();
            if (string6 != null && !string6.equalsIgnoreCase("none")) {
                properties.put("user", string4);
                properties.put("password", string5);
                properties.put("domain", string6);
                properties.put("useNTLMv2", bl + "");
            } else {
                properties.put("user", string4);
                properties.put("password", string5);
            }
            String string8 = this.firstUrl + string + ":" + string2 + "/" + string3 + ";charset=utf8";
            if (string7 != null && "true".equalsIgnoreCase(string7)) {
                string8 = string8 + ";ssl=request";
            }
            System.out.println("SQL DB URL  " + string8);
            String string9 = new String(string8);
            this.conn = this.newConnection(string9, properties, n);
            if (this.conn == null) {
                MsSqlDbStats.logToErrorFile(this.getClass().getName(), " MsSql db Connection  is null  ", " Host IP Address is  " + string);
                return null;
            }
            this.conn.setAutoCommit(false);
            this.conn.setTransactionIsolation(1);
            return this.conn;
        }
        catch (Exception exception) {
            System.err.println("Failed to establish a MsSql db connection with " + string);
            exception.printStackTrace();
            return null;
        }
    }

    private String getConString(String string, String string2) {
        if ("true".equalsIgnoreCase(string2)) {
            string = string + ";ssl=request";
        }
        String string3 = new String(string);
        return string3;
    }

    private Properties getvalue(String string, String string2, String string3, boolean bl) {
        Properties properties = new Properties();
        if (!string3.equalsIgnoreCase("none")) {
            properties.put("user", string);
            properties.put("password", string2);
            properties.put("domain", string3);
            properties.put("useNTLMv2", this.isNTLMv2 + "");
        } else {
            properties.put("user", string);
            properties.put("password", string2);
        }
        return properties;
    }

    private Connection getConnection(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
        return this.getConnection(string, string2, string3, string4, string5, string6, string7, string8, false);
    }

    private Connection getConnection(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, boolean bl) {
        String string9 = null;
        try {
            if (string6 == null) {
                string6 = "none";
            }
            Class.forName(this.driver);
            Properties properties = this.getvalue(string4, string5, string6, bl);
            if (string7 == null || string7.length() == 0 || string7.equalsIgnoreCase("default") || string7.equalsIgnoreCase("none")) {
                if (string2 == null || string2.equalsIgnoreCase("NULL")) {
                    return null;
                }
                string9 = this.firstUrl + string + ":" + string2 + "/" + string3 + ";charset=utf8";
                if (string8 != null && "true".equalsIgnoreCase(string8)) {
                    string9 = string9 + ";ssl=request";
                }
                String string10 = string9;
                this.conn = this.newConnection(string10, properties);
            } else if (string2 == null || string2.equalsIgnoreCase("NULL")) {
                string9 = this.firstUrl + string + "/" + string3 + ";INSTANCE=" + string7 + ";charset=utf8";
                String string11 = "";
                if ("true".equalsIgnoreCase(string8)) {
                    string9 = string9 + ";ssl=request";
                }
                string11 = string9;
                this.conn = this.newConnection(string11, properties);
            } else {
                string9 = this.firstUrl + string + ":" + string2 + "/" + string3 + ";charset=utf8";
                String string12 = "";
                if ("true".equalsIgnoreCase(string8)) {
                    string9 = string9 + ";ssl=request";
                }
                string12 = string9;
                this.conn = this.newConnection(string12, properties);
                if (this.conn == null) {
                    string9 = this.firstUrl + string + "/" + string3 + ";INSTANCE=" + string7 + ";charset=utf8";
                    string12 = "";
                    if ("true".equalsIgnoreCase(string8)) {
                        string9 = string9 + ";ssl=request";
                    }
                    string12 = string9;
                    this.conn = this.newConnection(string12, properties);
                }
            }
            if (this.conn == null) {
                MsSqlDbStats.logToErrorFile(this.getClass().getName(), " MsSql db Connection  is null  ", " Host IP Address is  " + string + "Url :" + string9);
                return null;
            }
            this.conn.setAutoCommit(false);
            this.conn.setTransactionIsolation(1);
            return this.conn;
        }
        catch (Exception exception) {
            System.err.println("Failed to establish a MsSql db connection with " + string);
            exception.printStackTrace();
            return null;
        }
    }

    private Connection getConnection(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, boolean bl, int n) {
        String string9 = null;
        try {
            if (string6 == null) {
                string6 = "none";
            }
            Class.forName(this.driver);
            Properties properties = this.getvalue(string4, string5, string6, bl);
            if (string7 == null || string7.length() == 0 || string7.equalsIgnoreCase("default") || string7.equalsIgnoreCase("none")) {
                if (string2 == null || string2.equalsIgnoreCase("NULL")) {
                    return null;
                }
                string9 = this.firstUrl + string + ":" + string2 + "/" + string3 + ";charset=utf8";
                if (string8 != null && "true".equalsIgnoreCase(string8)) {
                    string9 = string9 + ";ssl=request";
                }
                String string10 = string9;
                this.conn = this.newConnection(string10, properties, n);
            } else if (string2 == null || string2.equalsIgnoreCase("NULL")) {
                string9 = this.firstUrl + string + "/" + string3 + ";INSTANCE=" + string7 + ";charset=utf8";
                String string11 = "";
                if ("true".equalsIgnoreCase(string8)) {
                    string9 = string9 + ";ssl=request";
                }
                string11 = string9;
                this.conn = this.newConnection(string11, properties, n);
            } else {
                string9 = this.firstUrl + string + ":" + string2 + "/" + string3 + ";charset=utf8";
                String string12 = "";
                if ("true".equalsIgnoreCase(string8)) {
                    string9 = string9 + ";ssl=request";
                }
                string12 = string9;
                this.conn = this.newConnection(string12, properties, n);
                if (this.conn == null) {
                    string9 = this.firstUrl + string + "/" + string3 + ";INSTANCE=" + string7 + ";charset=utf8";
                    string12 = "";
                    if ("true".equalsIgnoreCase(string8)) {
                        string9 = string9 + ";ssl=request";
                    }
                    string12 = string9;
                }
                this.conn = this.newConnection(string12, properties, n);
            }
            if (this.conn == null) {
                MsSqlDbStats.logToErrorFile(this.getClass().getName(), " MsSql db Connection  is null  ", " Host IP Address is  " + string + "Url :" + string9);
                return null;
            }
            this.conn.setAutoCommit(false);
            this.conn.setTransactionIsolation(1);
            return this.conn;
        }
        catch (Exception exception) {
            System.err.println("Failed to establish a MsSql db connection with " + string);
            exception.printStackTrace();
            return null;
        }
    }

    private ArrayList getDatabases(Connection connection) {
        Statement statement = null;
        ResultSet resultSet = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = "SELECT name FROM master.dbo.sysdatabases with (NOLOCK)";
        try {
            if (connection != null) {
                statement = connection.createStatement();
            }
            if (statement != null) {
                resultSet = statement.executeQuery(string);
            }
            while (resultSet != null && resultSet.next()) {
                String string2 = resultSet.getString(1);
                if (arrayList.indexOf(string2) >= 0) continue;
                arrayList.add(string2);
            }
            this.closeRs(resultSet);
            this.closeStmt(statement);
            return arrayList;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.closeRs(resultSet);
            this.closeStmt(statement);
            return null;
        }
    }

    public HashMap getVersion(boolean bl) {
        String string = "sp1";
        String string2 = "7.";
        double d = 80.0;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Statement statement = null;
        ResultSet resultSet = null;
        String string3 = "SELECT SERVERPROPERTY('productversion'),SERVERPROPERTY('productlevel')";
        String string4 = "";
        String string5 = "true";
        try {
            if (this.conn == null) {
                MsSqlDbStats.logToErrorFile("MsSqlDbStats:getVersion()", "Connection is null", " for targetHost" + this.svr);
                string5 = "false";
                hashMap.put("connection", string5);
                return null;
            }
            hashMap.put("connection", string5);
            statement = this.conn.createStatement();
            if (statement != null) {
                resultSet = statement.executeQuery(string3);
            }
            while (resultSet.next()) {
                string2 = resultSet.getString(1);
                string = resultSet.getString(2);
                hashMap.put("productSeries", string2);
                hashMap.put("servicePack", string);
            }
            this.closeRs(resultSet);
            string4 = !string2.trim().startsWith("8.") && !string2.trim().startsWith("7.") ? "select compatibility_level from sys.databases where name='master'" : "select cmptlevel from sysdatabases where name='master'";
            if (statement != null) {
                resultSet = statement.executeQuery(string4);
            }
            while (resultSet.next()) {
                d = resultSet.getDouble(1);
                hashMap.put("compatibilityLevel", new Double(d));
            }
            this.closeRs(resultSet);
            this.closeStmt(statement);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.closeRs(resultSet);
            this.closeStmt(statement);
            return hashMap;
        }
        return hashMap;
    }

    public double getVersion() {
        Statement statement = null;
        ResultSet resultSet = null;
        String string = "select @@version";
        String string2 = "Microsoft SQL Server ";
        int n = string2.length();
        double d = 0.0;
        try {
            if (this.conn != null) {
                statement = this.conn.createStatement();
            }
            if (statement != null) {
                resultSet = statement.executeQuery(string);
            }
            block4: while (resultSet != null && resultSet.next()) {
                String string3 = resultSet.getString(1);
                StringTokenizer stringTokenizer = new StringTokenizer(string3, "-");
                while (stringTokenizer.hasMoreTokens()) {
                    String string4 = stringTokenizer.nextToken();
                    if (!string4.startsWith(string2)) continue;
                    try {
                        String string5 = string4.substring(n, string4.length()).trim();
                        d = Double.parseDouble(string5);
                        continue block4;
                    }
                    catch (Exception exception) {
                        d = 2000.0;
                    }
                }
            }
            this.closeRs(resultSet);
            this.closeStmt(statement);
            return d;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.closeRs(resultSet);
            this.closeStmt(statement);
            return -1.0;
        }
    }

    private Connection newConnection(String string, Properties properties) throws SQLException {
        Connection connection = null;
        long l = System.currentTimeMillis();
        try {
            Class.forName("net.sourceforge.jtds.jdbc.Driver");
            connection = DriverManager.getConnection(string, properties);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Error  while getting connection for   " + this.getClass().getName() + "    Test..." + exception.getMessage());
            MsSqlDbStats.logToErrorFile(this.getClass().getName(), " MsSql db Connection  is null  ", " Host IP Address is  " + this.svr);
            long l2 = System.currentTimeMillis();
            long l3 = l2 - l;
            if (l3 >= 60000L) {
                System.out.println(this.getClass().getName() + " test got stuck while getting connection...");
                l = l2;
            }
            return null;
        }
        return connection;
    }

    private Connection newConnection(String string, Properties properties, int n) throws SQLException {
        Connection connection = null;
        long l = System.currentTimeMillis();
        try {
            Class.forName("net.sourceforge.jtds.jdbc.Driver");
            DriverManager.setLoginTimeout(n);
            connection = DriverManager.getConnection(string, properties);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Error  while getting connection for   " + this.getClass().getName() + "    Test..." + exception.getMessage());
            MsSqlDbStats.logToErrorFile(this.getClass().getName(), " MsSql db Connection  is null  ", " Host IP Address is  " + this.svr + " :" + exception.getMessage().toString());
            long l2 = System.currentTimeMillis();
            long l3 = l2 - l;
            if (l3 >= 60000L) {
                System.out.println(this.getClass().getName() + " test got stuck while getting connection...");
                l = l2;
            }
            return null;
        }
        return connection;
    }

    private static void logToErrorFile(String string, String string2, String string3) {
        PrintWriter printWriter;
        String string4 = "agent";
        EgDateInfo egDateInfo = new EgDateInfo();
        EgConfigInfo egConfigInfo = new EgConfigInfo(string4);
        if (string3 == null) {
            return;
        }
        String string5 = egDateInfo.egetDate();
        try {
            printWriter = new PrintWriter(new FileWriter(EgConfigInfo.egAgentErrorFile, true));
        }
        catch (Exception exception) {
            System.err.println("Cannot open log file ");
            return;
        }
        String string6 = new String(string5 + " " + string + " " + string2 + ": " + string3);
        printWriter.println(string6);
        printWriter.close();
        printWriter = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getDbSpacedetails() {
        double d;
        double d2;
        String string;
        Hashtable hashtable;
        Hashtable<Object, Serializable> hashtable2;
        Hashtable hashtable3;
        String string2;
        double d3;
        double d4;
        double d5;
        String string3;
        double d6;
        String string4;
        ArrayList arrayList;
        Hashtable<String, Double> hashtable4;
        Statement statement;
        ResultSet resultSet;
        block47: {
            block46: {
                resultSet = null;
                statement = null;
                hashtable4 = new Hashtable<String, Double>();
                try {
                    if (this.conn == null) break block46;
                    arrayList = this.getDatabases(this.conn);
                    if (arrayList == null) {
                        this.dbNames = null;
                        return hashtable4;
                    }
                    if (this.al_excludeDbs != null && this.al_excludeDbs.size() > 0) {
                        ArrayList<String> arrayList2 = new ArrayList<String>();
                        for (int i = 0; i < arrayList.size(); ++i) {
                            String string5 = (String)arrayList.get(i);
                            if (string5 == null || string5.trim().length() <= 0 || this.al_excludeDbs.contains(string5)) continue;
                            arrayList2.add(string5);
                        }
                        arrayList = arrayList2;
                    }
                    int n = arrayList.size();
                    String string6 = "select name,physical_name, CAST(FILEPROPERTY(name, 'SPACEUSED') AS INT)/128.0 from sys.database_files where type=0";
                    System.out.println(" usedSizeQry :" + string6);
                    for (int i = 0; i < n; ++i) {
                        String string7 = (String)arrayList.get(i);
                        String string8 = "USE \"" + string7 + "\"";
                        try {
                            statement = this.conn.createStatement();
                        }
                        catch (SQLException sQLException) {
                            MsSqlDbStats.logToErrorFile("Error :", " Failed to create statement", sQLException.toString());
                            sQLException.printStackTrace();
                            return hashtable4;
                        }
                        if (statement != null) {
                            try {
                                statement.execute(string8);
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                                this.closeStmt(statement);
                                continue;
                            }
                            resultSet = statement.executeQuery(string6);
                        }
                        string4 = "";
                        d6 = 0.0;
                        while (resultSet.next()) {
                            string4 = resultSet.getString(2);
                            d6 = resultSet.getDouble(3);
                            hashtable4.put(string4, new Double(d6));
                        }
                        this.closeRs(resultSet);
                        this.closeStmt(statement);
                    }
                    System.out.println("UsedSizeHash : " + hashtable4);
                }
                catch (Exception exception) {
                    MsSqlDbStats.logToErrorFile("Error :", "MsSqlSpaceTest usedSizeQry execute query ", exception.toString());
                    exception.printStackTrace();
                }
            }
            arrayList = "";
            string3 = "";
            d5 = -5.0;
            d4 = -5.0;
            string4 = "";
            d6 = -5.0;
            boolean bl = false;
            d3 = -5.0;
            string2 = "";
            hashtable3 = new Hashtable();
            hashtable2 = new Hashtable<Object, Serializable>();
            hashtable = new Hashtable();
            String string9 = "";
            String string10 = "";
            string = "";
            d2 = 0.0;
            d = 0.0;
            if (this.conn != null) {
                statement = this.conn.createStatement();
            }
            if (statement != null) break block47;
            Hashtable<Object, Serializable> hashtable5 = hashtable2;
            this.closeRs(resultSet);
            this.closeStmt(statement);
            return hashtable5;
        }
        try {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            String string11 = "select s.volume_mount_point as 'drive',db_name(s.database_id) as 'database name',(size*8)/1024 as current_file_size ,case when mf.max_size=-1 then (s.total_bytes-s.available_bytes)/(1024*1024) when mf.max_size>0 then CONVERT(DECIMAL(10,2),mf.SIZE/128.0 - ((SIZE/128.0) - CAST(FILEPROPERTY(mf.NAME, 'SPACEUSED') AS INT)/128.0)) end as used_size_mb,case when mf.max_size=-1  and growth=0 then (size*8)/1024 when mf.max_size=-1 and growth>0 then s.total_bytes/(1024*1024) when mf.max_size > 0 then (max_size*8)/1024  end as max_file_size,case when mf.max_size=-1  and growth=0 then 'File' when mf.max_size=-1 and growth>0 then 'Disk' when mf.max_size > 0 then 'File'  end as max_size_type, case when growth=0 then 'no' when growth > 0 then 'yes' end as is_growth_enabled,max_size,mf.physical_name,mf.data_space_id  from  sys.master_files as mf cross apply sys.dm_os_volume_stats(mf.database_id, mf.file_id) as s where mf.data_space_id <> 0";
            resultSet = statement.executeQuery(string11);
            while (resultSet.next()) {
                ArrayList arrayList3;
                Hashtable hashtable6;
                Object object6;
                string3 = resultSet.getString(1);
                arrayList = resultSet.getString(2);
                d = resultSet.getDouble(3);
                d3 = resultSet.getDouble(4);
                d5 = resultSet.getDouble(5);
                string = resultSet.getString(6);
                string4 = resultSet.getString(7);
                d6 = resultSet.getDouble(8);
                string2 = resultSet.getString(9);
                object5 = resultSet.getString(10);
                boolean bl = false;
                double d7 = 0.0;
                double d8 = 0.0;
                if (string.equalsIgnoreCase("File")) {
                    bl = true;
                }
                if (bl) {
                    if (hashtable4 != null && hashtable4.containsKey(string2)) {
                        d2 = (Double)hashtable4.get(string2);
                    }
                } else {
                    if (hashtable4 != null && hashtable4.containsKey(string2)) {
                        d7 = (Double)hashtable4.get(string2);
                    }
                    d8 = d - d7;
                }
                d4 = string4.equalsIgnoreCase("yes") ? 100.0 : 0.0;
                if (string3 == null || string3.length() == 0) {
                    if (string2.indexOf(":") > -1) {
                        string3 = string2.substring(0, string2.indexOf(":") + 2);
                    } else if (string2.indexOf("/") > -1 && ((StringTokenizer)(object6 = new StringTokenizer(string2, "/"))).hasMoreTokens()) {
                        string3 = ((StringTokenizer)object6).nextToken();
                        string3 = "/" + string3;
                    }
                    System.out.println("MsSqlSpaceTest --> drive::" + string3);
                }
                if ((object6 = (Hashtable)this.fileGrpHash.get(arrayList)) != null && (hashtable6 = (String)((Hashtable)object6).get(object5)) != null) {
                    arrayList3 = arrayList;
                    arrayList = hashtable6;
                    hashtable.put(arrayList, arrayList3);
                }
                if ((hashtable6 = (Hashtable)hashtable3.get(arrayList)) == null) {
                    hashtable6 = new Hashtable();
                    d3 = bl ? d2 : (d3 -= d8);
                    arrayList3 = new ArrayList();
                    arrayList3.add(new Double(d5));
                    arrayList3.add(new Double(d3));
                    arrayList3.add(new Double(d4));
                    arrayList3.add(new Double(d6));
                    arrayList3.add(string);
                    hashtable6.put(string3, arrayList3);
                    hashtable3.put(arrayList, hashtable6);
                    continue;
                }
                arrayList3 = (ArrayList)hashtable6.get(string3);
                ArrayList<Object> arrayList4 = null;
                if (arrayList3 == null) {
                    d3 = bl ? d2 : (d3 -= d8);
                    arrayList4 = new ArrayList<Object>();
                    arrayList4.add(new Double(d5));
                    arrayList4.add(new Double(d3));
                    arrayList4.add(new Double(d4));
                    arrayList4.add(new Double(d6));
                    arrayList4.add(string);
                } else {
                    Double d9 = (Double)arrayList3.get(0);
                    object4 = (Double)arrayList3.get(1);
                    object3 = (Double)arrayList3.get(2);
                    object2 = (Double)arrayList3.get(3);
                    object = (String)arrayList3.get(4);
                    if (string.equalsIgnoreCase("Disk") && ((String)object).equalsIgnoreCase("Disk")) {
                        d3 = (Double)object4 - d8;
                    } else if (((String)object).equalsIgnoreCase("File") && string.equalsIgnoreCase("Disk")) {
                        double d10 = d3 - d8;
                        d3 = (Double)object4 + d10;
                        object = "Disk";
                    } else if (((String)object).equalsIgnoreCase("Disk") && string.equalsIgnoreCase("File")) {
                        d5 = d9;
                        d3 = (Double)object4 + d2;
                        object = "Disk";
                    } else if (((String)object).equalsIgnoreCase("File") && string.equalsIgnoreCase("File")) {
                        d5 += d9.doubleValue();
                        d3 = d2 + (Double)object4;
                        object = "File";
                    }
                    if ((Double)object3 == 100.0) {
                        d4 = 100.0;
                    } else if (d4 == 100.0) {
                        d4 = 100.0;
                    }
                    arrayList4 = new ArrayList();
                    arrayList4.add(new Double(d5));
                    arrayList4.add(new Double(d3));
                    arrayList4.add(new Double(d4));
                    arrayList4.add(new Double(d6));
                    arrayList4.add(object);
                }
                hashtable6.put(string3, arrayList4);
            }
            object5 = hashtable3.keys();
            while (object5.hasMoreElements()) {
                Hashtable<String, Object> hashtable7 = new Hashtable<String, Object>();
                boolean bl = true;
                String string12 = (String)object5.nextElement();
                Hashtable hashtable8 = (Hashtable)hashtable3.get(string12);
                double d11 = 0.0;
                double d12 = 0.0;
                double d13 = 0.0;
                object4 = hashtable8.keys();
                while (object4.hasMoreElements()) {
                    object3 = (String)object4.nextElement();
                    object2 = (ArrayList)hashtable8.get(object3);
                    object = (Double)((ArrayList)object2).get(0);
                    Double d14 = (Double)((ArrayList)object2).get(1);
                    Double d15 = (Double)((ArrayList)object2).get(2);
                    d11 += ((Double)object).doubleValue();
                    d13 += d14.doubleValue();
                    if (!bl || !((d12 = d15.doubleValue()) > 0.0)) continue;
                    bl = false;
                }
                object3 = new ArrayList();
                ((ArrayList)object3).add(new Double(d11));
                ((ArrayList)object3).add(new Double(d13));
                ((ArrayList)object3).add(new Double(d12));
                hashtable7.put(string12, object3);
                object2 = (String)hashtable.get(string12);
                if (object2 == null) continue;
                object = (ArrayList)hashtable2.get(object2);
                if (object == null) {
                    object = new ArrayList();
                    ((ArrayList)object).add(hashtable7);
                } else {
                    ((ArrayList)object).add(hashtable7);
                }
                hashtable2.put(object2, (Serializable)object);
            }
            this.closeRs(resultSet);
            this.closeStmt(statement);
        }
        catch (Exception exception) {
            try {
                MsSqlDbStats.logToErrorFile("Error :", "MsSqlSpaceTest execute query ", exception.toString());
                exception.printStackTrace();
                this.closeRs(resultSet);
                this.closeStmt(statement);
            }
            catch (Throwable throwable) {
                this.closeRs(resultSet);
                this.closeStmt(statement);
                throw throwable;
            }
        }
        return hashtable2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getLogFile(String string) {
        ResultSet resultSet = null;
        Statement statement = null;
        Hashtable<String, Double> hashtable = new Hashtable<String, Double>();
        try {
            if (this.conn == null) {
                System.out.println("connection is null in MsSqlSpaceTest");
                Hashtable<String, Double> hashtable2 = hashtable;
                return hashtable2;
            }
            statement = this.conn.createStatement();
            if (statement == null) {
                Hashtable<String, Double> hashtable3 = hashtable;
                return hashtable3;
            }
            String string2 = "select object_name,counter_name,instance_name,cntr_value from sys.dm_os_performance_counters where counter_name in ('Log File(s) Size (KB)') and object_name in('MSSQL$" + string + ":Databases','SQLServer:Databases')";
            resultSet = statement.executeQuery(string2);
            while (resultSet.next()) {
                String string3 = resultSet.getString(3).trim();
                double d = resultSet.getDouble(4);
                hashtable.put(string3, new Double(d));
            }
            this.closeRs(resultSet);
            this.closeStmt(statement);
            this.closeRs(resultSet);
            this.closeStmt(statement);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            this.closeRs(resultSet);
            this.closeStmt(statement);
        }
        return hashtable;
    }

    public static String getSqlServerProcessID(String string) {
        if (string == null || string.trim().length() == 0) {
            MsSqlDbStats.logToErrorFile("INFO :", "MsSqlDbStats", " Method getSqlServerProcessID reporting Name is empty or null");
            return "";
        }
        String string2 = "";
        try {
            if (sqlActiveClusterHash == null || sqlActiveClusterHash.size() == 0 || !sqlActiveClusterHash.containsKey(string)) {
                return "";
            }
            string2 = (String)sqlActiveClusterHash.get(string);
            if (string2 == null || string2.trim().length() == 0) {
                return "";
            }
        }
        catch (Exception exception) {
            MsSqlDbStats.logToErrorFile("INFO :", " MsSqlDbStats Exception getting the mssql cluster process id   reportingName :" + string, exception.toString());
            return "";
        }
        return string2;
    }

    public static void setSqlServerProcessID(String string, String string2) {
        if (string == null || string.trim().length() == 0) {
            MsSqlDbStats.logToErrorFile("INFO :", " MsSqlDbStats", "reporting Name is empty or null  ");
            return;
        }
        if (string2 != null && string2.trim().length() > 0) {
            sqlActiveClusterHash.put(string, string2);
        }
    }
}

