/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.apm.CustomQueue;
import com.eg.apm.NodeBTMLogger;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class APMNodeQueue<E>
implements CustomQueue<E> {
    private Queue<E> queue = null;
    private int maxLimit = 0;
    protected String loggerDispStr = "[APMNodeQueue]";

    public APMNodeQueue(int n) {
        this.maxLimit = n;
        this.queue = new LinkedBlockingQueue(this.maxLimit);
    }

    public boolean enqueue(E e) {
        try {
            return this.queue.add(e);
        }
        catch (IllegalStateException illegalStateException) {
            int n = this.queue.size();
            NodeBTMLogger.nodeLogger.warn(this.loggerDispStr + "Could not add element to Queue, queue size is " + n);
            try {
                e = this.queue.poll();
                NodeBTMLogger.nodeLogger.warn(this.loggerDispStr + "Removed and Discarded the old(head) elements from queue");
            }
            catch (Exception exception) {
                NodeBTMLogger.nodeLogger.warn(this.loggerDispStr + "Could not delete element from Queue, due to the exception ", (Throwable)exception);
            }
            NodeBTMLogger.nodeLogger.debug(this.loggerDispStr + "Attempting to add element into queue after removing old(head) element");
            return this.enqueue(e, true);
        }
        catch (Exception exception) {
            NodeBTMLogger.nodeLogger.warn(this.loggerDispStr + "Could not add element to queue, due to the exception ", (Throwable)exception);
            return false;
        }
    }

    public boolean enqueue(E e, boolean bl) {
        try {
            return this.queue.add(e);
        }
        catch (IllegalStateException illegalStateException) {
            int n = this.queue.size();
            NodeBTMLogger.nodeLogger.warn(this.loggerDispStr + "The second attempt to add element into queue is failed. Queue size is : " + n);
            NodeBTMLogger.nodeLogger.warn(this.loggerDispStr + "Discarding element .... " + e.toString());
            return false;
        }
        catch (Exception exception) {
            NodeBTMLogger.nodeLogger.warn(this.loggerDispStr + "Could not add element to Queue, due to the exception ", (Throwable)exception);
            return false;
        }
    }

    public E dequeue() {
        E e = null;
        try {
            e = this.queue.poll();
        }
        catch (Exception exception) {
            NodeBTMLogger.nodeLogger.warn(this.loggerDispStr + "Could not delete element from Queue, due to the exception ", (Throwable)exception);
        }
        return e;
    }

    public E dequeue(boolean bl) {
        E e = null;
        try {
            e = ((LinkedBlockingQueue)this.queue).take();
        }
        catch (Exception exception) {
            NodeBTMLogger.nodeLogger.warn(this.loggerDispStr + "Could not delete element from Queue, due to the exception ", (Throwable)exception);
        }
        return e;
    }

    final void clearQueue() {
        try {
            this.queue.clear();
        }
        catch (Exception exception) {
            NodeBTMLogger.nodeLogger.warn(this.loggerDispStr + "Could not clear elements from Queue, due to the exception ", (Throwable)exception);
        }
    }

    public int getSize() {
        return this.queue.size();
    }
}

