﻿
$egInstallpath=Get-ChildItem Env:EGURKHA_INSTALL_DIR |Select Value
$egurkhaPath=$egInstallpath.Value.ToString()
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
Import-Module $egEncryPath,$egDatnKy -WarningAction SilentlyContinue
clear
[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12

$TestInputs=$args
$reportingname=$TestInputs[0]
$username=$TestInputs[1]
$password=Eg-O365Dcr -EncStr $TestInputs[2]
$proxyCrdlserver=$TestInputs[3].ToString().Split('#')
$proxyUser=$proxyCrdlserver[0]
$proxyPass=Eg-O365Dcr -EncStr $proxyCrdlserver[1]
$proxyserverip=$proxyCrdlserver[2]
$inputRptDat=$TestInputs[4]
$proxyserver=$proxyserver='http://'+$proxyserverip

$domain=Eg-GetDomain -userName $username -Password $password -proxyUsr $proxyUser -proxyPass $proxyPass -IsIntial $true -proxyserver $proxyserver
$azureVal=Eg-GetAzureEnv -UserName $username -subject 'O365_Graph'
$azureEnvArr=$azureVal.Split(',')

$rptPath=$egurkhaPath+'\agent\SBO\'+$reportingname
if(!(Test-Path -Path $rptPath )){
   $null =  New-Item -ItemType directory -Path $rptPath -WarningAction SilentlyContinue
}

$WriteLog=$true
$LogFile = $rptPath+"\sboreports.log"
$LogFile1 = $rptPath+"\sboreports1.log"
$isFrstTimLog=$true

# Writes output to a log file with a time date stamp
Function Write-Log {
	Param ([string]$string)

	[string]$date = Get-Date -Format G
	
    if ($WriteLog) {
       ( "[" + $date + "] - [" + $reportingname+"] mTime -  " + $mTime + " - " + $string ) | Out-File -FilePath $LogFile -Append } 

    if($isFrstTimLog){     
        if ($WriteLog -eq $true){ #if flag is true 
            if ([System.IO.File]::Exists($LogFile) -and (Get-Item $LogFile).length -gt 2mb) {  #if the size of file is greater than 1MB 
                if([System.IO.File]::Exists($LogFile1)){  #if logfile1 already exists, delete logfile1 
                    Remove-Item $LogFile1 
                } 
                Rename-Item $LogFile $LogFile1 
            }
        }
        $isFrstTimLog=$false
    }

}

Function Eg-InvokeUrl(){
	[CmdletBinding()]
    Param(
        [Parameter(Mandatory=$true, Position=1)]
        [String]$Url, 
        [Parameter(Mandatory=$true, Position=2)]
        [String]$filePath
        
    )

    Process
    {
        $creds = New-Object "Microsoft.IdentityModel.Clients.ActiveDirectory.ClientCredential" -ArgumentList $appId, $appSecret
        $authContext = New-Object "Microsoft.IdentityModel.Clients.ActiveDirectory.AuthenticationContext"-ArgumentList $authString
        $context = $authContext.AcquireTokenAsync($Resource, $creds).Result
        $authCode=$context.CreateAuthorizationHeader()

        $header = @{
            'Authorization'=$authCode
        }
        
        $query = Invoke-RestMethod -Method 'Get' -Headers $header -Uri $Url
        $query=$query.Replace('ï»¿','')
        $query=$query.Replace(' ','')

        $resultarray = ConvertFrom-Csv -InputObject $query
        $reprts=$resultarray | ConvertTo-Json 
        $jsonreprt=@()
        $jsonreprt='{ "Usage" :['+$reprts+']}'
        $reports=$jsonreprt | ConvertFrom-Json

        for($i=0;$i -lt $reports.Usage.Length ;$i++ ){  
            $reports.Usage[$i] |Export-Csv $filePath -Append -NoTypeInformation -Force
        } 
    }
}

Write-Log ".........Started Running the Script........."
$timenow = [int][double]::Parse((Get-Date -UFormat %s))
$deviceusagecsv = $rptPath+'\DeviceUsagereport'+$timenow+'.csv'
try{
$authString=$azureEnvArr[0]+$domain
$Resource=$azureEnvArr[1]
$msGraphPath=$egurkhaPath+"\agent\O365\MsGraph"
$keyFileNam = '\GraphDetailsKey.dat'

$unProtPath= $msGraphPath+'\GraphDetails.dat'
$kvalue= Get-Content -Path $msGraphPath$keyFileNam
$null=Unprotect-File $unProtPath -Algorithm AES -KeyAsPlainText $kvalue -DstSuffix '.txt'

$SkypeInput=$msGraphPath+"\GraphDetails.txt"
$GetInput = Get-Content -Path $SkypeInput
}catch{
    Write-Log "File not found. The $GetInput location does not contain GraphDetails "
}
$flag=$false

    foreach($inp in $GetInput){
        if($inp.StartsWith('[') -and $inp.Contains($domain)){
            $flag=$true
        }
        if($flag){
            if($inp.Contains("client_id")){
                $appId =$inp.ToString().Substring($inp.IndexOf('~')+1)
            }
            if($inp.Contains("client_secret")){
                $appSecret =$inp.ToString().Substring($inp.IndexOf('~')+1)
                $flag=$false
            }
            if($inp.Contains("TenantName")){
                $tenantID=$inp.ToString().Substring($inp.IndexOf('~')+1)
            }
            if($inp.Contains("Authority")){
                $authString = $inp.ToString().Substring($inp.IndexOf('~')+1)
                $authString=$authString+$domain
            }
            if($inp.Contains("Resource")){
                $Resource =$inp.ToString().Substring($inp.IndexOf('~')+1)
                $flag=$false
            }
        }
    }

#$sysDate = (Get-Date).AddDays($ReportRefreshDate).ToString("yyyy-MM-dd")
#$sysDate = (Get-Date).AddDays(-2).ToString("yyyy-MM-dd")
$path=(([XML]((Get-Package -Name AzureAD  | select SwidTagText)).SwidTagText).SoftwareIdentity.Meta.InstalledLocation)+'\Microsoft.IdentityModel.Clients.ActiveDirectory.dll'
Add-Type -Path $path
<#
$actvtcntsurl = "https://graph.microsoft.com/v1.0/reports/getSkypeForBusinessActivityCounts(period='D7')"
Eg-InvokeUrl -Url $actvtcntsurl -filePath $activecntcsv
try{
$SkyActcnt= import-csv $activecntcsv
}catch{
Write-Log "File not found. The $reportingname location does not contain Activecount report"
}
    $Totpeertopeercnt = 0
    $Totorganizedcnt = 0
    $TotParticipatedcnt = 0

    foreach($skypeActivecnt in $SkyActcnt){
        if($skypeActivecnt.ReportDate -eq $inputRptDat){
            $Totpeertopeercnt += $skypeActivecnt.'Peer-to-peer'
            $Totorganizedcnt += $skypeActivecnt.Organized
            $TotParticipatedcnt += $skypeActivecnt.Participated
        }
    }
#>
$devicusgeurl = $azureEnvArr[2]+"reports/getSkypeForBusinessDeviceUsageDistributionUserCounts(period='D7')"
Eg-InvokeUrl -Url $devicusgeurl -filePath $deviceusagecsv
try{
    $SkyDevUsg= import-csv $deviceusagecsv
    Write-Log "created the deviceusagecsv file and processing"
}catch{
    Write-Log "File not found. The $reportingname location does not contain deviceusage report "
}

<#
$usrdetilurl = "https://graph.microsoft.com/v1.0/reports/getSkypeForBusinessActivityUserDetail(Date=$inputRptDat)"   #Date=$sysDate
Eg-InvokeUrl -Url $usrdetilurl -filePath $userdetilcsv
Write-Log ("Eg-InvokeUrl  usrdetilurl>>>>>" + $usrdetilurl + "<<<<<" )

try{
$SkyUsrDetail= import-csv $userdetilcsv
}catch{
	Write-Log "File not found. The $reportingname location does not contain userdetial report "
}

    $peertopimcnt = 0
    $peertopAudcnt = 0
    $peertopAudmincnt = 0
    $peertopvidcnt = 0
    $peertopvidmincnt = 0
    $peertopAppcnt = 0
    $peertopFletracnt = 0

    $orgconimcnt = 0
    $orgconAudvidcnt = 0
    $orgconAudvidmincnt = 0
    $orgconwebcnt = 0
    $orgcondial3partcnt = 0
    $orgcondialmscnt = 0
    $orgcondialinmsmincnt = 0
    $orgcondialoutmsmincnt = 0
    $orgconAppcnt = 0

    $parconimcnt = 0
    $parconAudvidcnt = 0
    $parconAudvidmincnt = 0
    $parconwebcnt = 0
    $parcondial3partcnt = 0
    $parconAppcnt = 0


    $SBOUsgReptHash = @{}

    $SBOUsgReptHash.Add('Peer-to-peerIM',@{})
    $SBOUsgReptHash.Add('Peer-to-peerAudio',@{})
    $SBOUsgReptHash.Add('Peer-to-peerAudioMinutes',@{})
    $SBOUsgReptHash.Add('Peer-to-peerVideo',@{})
    $SBOUsgReptHash.Add('Peer-to-peerVideoMinutes',@{})
    $SBOUsgReptHash.Add('Peer-to-peerAppSharing',@{})
    $SBOUsgReptHash.Add('Peer-to-peerFileTransfer',@{})

    $SBOUsgReptHash.Add('OrganizedConferenceIM',@{})
    $SBOUsgReptHash.Add('OrganizedConferenceAudio/Video',@{})
    $SBOUsgReptHash.Add('OrganizedConferenceAudio/VideoMinutes',@{})
    $SBOUsgReptHash.Add('OrganizedConferenceWeb',@{})
    $SBOUsgReptHash.Add('OrganizedConferenceDial-in/out3rdParty',@{})
    $SBOUsgReptHash.Add('OrganizedConferenceDial-in/outMicrosoft',@{})
    $SBOUsgReptHash.Add('OrganizedConferenceDial-inMicrosoftMinutes',@{})
    $SBOUsgReptHash.Add('OrganizedConferenceDial-outMicrosoftMinutes',@{})
    $SBOUsgReptHash.Add('OrganizedConferenceAppSharing',@{})

    $SBOUsgReptHash.Add('ParticipatedConferenceIM',@{})
    $SBOUsgReptHash.Add('ParticipatedConferenceAudio/Video',@{})
    $SBOUsgReptHash.Add('ParticipatedConferenceAudio/VideoMinutes',@{})
    $SBOUsgReptHash.Add('ParticipatedConferenceWeb',@{})
    $SBOUsgReptHash.Add('ParticipatedConferenceDial-in/out3rdParty',@{})
    $SBOUsgReptHash.Add('ParticipatedConferenceAppSharing',@{})
    $reportDte=''
    $isTrue=$true
foreach($skypedetil in $SkyUsrDetail){ 
        #if($isTrue){
            $isTrue=$false
            $rptDat = $skypedetil.ReportRefreshDate
            $rplcCnt=$reportingname+'='+$inputRptDat
            $sboFilePath=$egurkhaPath+'/agent/SBO/'+$reportingname+'/SBODataFile.ini'
            if($rptDat -ne ''){    
                if(Test-Path $sboFilePath -PathType Leaf){
                    $val=''
                    Get-Content $sboFilePath | ForEach-Object{$rptVal=$_ -split '=';if($rptVal[0] -eq $reportingname){$val=$_}} 
                    if($val -ne ''){
                        (Get-Content $sboFilePath).replace($val,$rplcCnt) | Set-Content $sboFilePath
                    }
                }
            }
       # }
       
       $peertopimcnt += $skypedetil.'Peer-to-peerIMCount'
       $peertopAudcnt += $skypedetil.'Peer-to-peerAudioCount'
       $peertopAudmincnt += $skypedetil.'Peer-to-peerAudioMinutes'
       $peertopvidcnt += $skypedetil.'Peer-to-peerVideoCount'
       $peertopvidmincnt += $skypedetil.'Peer-to-peerVideoMinutes'
       $peertopAppcnt += $skypedetil.'Peer-to-peerAppSharingCount'
       $peertopFletracnt += $skypedetil.'Peer-to-peerFileTransferCount'

       $orgconimcnt += $skypedetil.'OrganizedConferenceIMCount'
       $orgconAudvidcnt += $skypedetil.'OrganizedConferenceAudio/VideoCount'
       $orgconAudvidmincnt += $skypedetil.'OrganizedConferenceAudio/VideoMinutes'
       $orgconwebcnt += $skypedetil.'OrganizedConferenceWebCount'
       $orgcondial3partcnt += $skypedetil.'OrganizedConferenceDial-in/out3rdPartyCount'
       $orgcondialmscnt += $skypedetil.'OrganizedConferenceDial-in/outMicrosoftCount'
       $orgcondialinmsmincnt += $skypedetil.'OrganizedConferenceDial-inMicrosoftMinutes'
       $orgcondialoutmsmincnt += $skypedetil.'OrganizedConferenceDial-outMicrosoftMinutes'
       $orgconAppcnt += $skypedetil.'OrganizedConferenceAppSharingCount'

       $parconimcnt += $skypedetil.ParticipatedConferenceIMCount
       $parconAudvidcnt += $skypedetil.'ParticipatedConferenceAudio/VideoCount'
       $parconAudvidmincnt += $skypedetil.'ParticipatedConferenceAudio/VideoMinutes'
       $parconwebcnt += $skypedetil.ParticipatedConferenceWebCount
       $parcondial3partcnt += $skypedetil.'ParticipatedConferenceDial-in/out3rdPartyCount'
       $parconAppcnt += $skypedetil.ParticipatedConferenceAppSharingCount

       $reportrefdte = $skypedetil.ReportRefreshDate
       $username = $skypedetil.UserPrincipalName
       $PeerLastActivityDate = $skypedetil.'Peer-to-peerLastActivityDate'
       $OrganizedConferenceLastActivityDate = $skypedetil.OrganizedConferenceLastActivityDate
       $ParticipatedConferenceLastActivityDate = $skypedetil.ParticipatedConferenceLastActivityDate
       $LastActivityDate = $skypedetil.LastActivityDate
       $IsDeleted = $skypedetil.IsDeleted
       $DeletedDate = $skypedetil.DeletedDate
       $AssignedProducts = $skypedetil.AssignedProducts

       if([int]$skypedetil.'Peer-to-peerIMCount' -gt 0){
       $dd= $reportrefdte+'~!~'+$username+'~!~'+$skypedetil.'Peer-to-peerIMCount'+'~!~'+$PeerLastActivityDate+'~!~'+$OrganizedConferenceLastActivityDate+'~!~'+$ParticipatedConferenceLastActivityDate+'~!~'+$LastActivityDate+'~!~'+$IsDeleted+'~!~'+$DeletedDate+'~!~'+$AssignedProducts
       $SBOUsgReptHash['Peer-to-peerIM'].Add($dd,[int]($skypedetil.'Peer-to-peerIMCount'))
       }
       if([int]$skypedetil.'Peer-to-peerAudioCount' -gt 0){
       $dd= $reportrefdte+'~!~'+$username+'~!~'+$skypedetil.'Peer-to-peerAudioCount'+'~!~'+$PeerLastActivityDate+'~!~'+$OrganizedConferenceLastActivityDate+'~!~'+$ParticipatedConferenceLastActivityDate+'~!~'+$LastActivityDate+'~!~'+$IsDeleted+'~!~'+$DeletedDate+'~!~'+$AssignedProducts
       $SBOUsgReptHash['Peer-to-peerAudio'].Add($dd,[int]($skypedetil.'Peer-to-peerAudioCount'))
       }
       if([int]$skypedetil.'Peer-to-peerAudioMinutes' -gt 0){
       $dd= $reportrefdte+'~!~'+$username+'~!~'+$skypedetil.'Peer-to-peerAudioMinutes'+'~!~'+$PeerLastActivityDate+'~!~'+$OrganizedConferenceLastActivityDate+'~!~'+$ParticipatedConferenceLastActivityDate+'~!~'+$LastActivityDate+'~!~'+$IsDeleted+'~!~'+$DeletedDate+'~!~'+$AssignedProducts
       $SBOUsgReptHash['Peer-to-peerAudioMinutes'].Add($dd,[int]($skypedetil.'Peer-to-peerAudioMinutes'))
       }
       if([int]$skypedetil.'Peer-to-peerVideoCount' -gt 0){
       $dd= $reportrefdte+'~!~'+$username+'~!~'+$skypedetil.'Peer-to-peerVideoCount'+'~!~'+$PeerLastActivityDate+'~!~'+$OrganizedConferenceLastActivityDate+'~!~'+$ParticipatedConferenceLastActivityDate+'~!~'+$LastActivityDate+'~!~'+$IsDeleted+'~!~'+$DeletedDate+'~!~'+$AssignedProducts
       $SBOUsgReptHash['Peer-to-peerVideo'].Add($dd,[int]($skypedetil.'Peer-to-peerVideoCount'))
       }
       if([int]$skypedetil.'Peer-to-peerVideoMinutes' -gt 0){
       $dd= $reportrefdte+'~!~'+$username+'~!~'+$skypedetil.'Peer-to-peerVideoMinutes'+'~!~'+$PeerLastActivityDate+'~!~'+$OrganizedConferenceLastActivityDate+'~!~'+$ParticipatedConferenceLastActivityDate+'~!~'+$LastActivityDate+'~!~'+$IsDeleted+'~!~'+$DeletedDate+'~!~'+$AssignedProducts
       $SBOUsgReptHash['Peer-to-peerVideoMinutes'].Add($dd,[int]($skypedetil.'Peer-to-peerVideoMinutes'))
       }
       if([int]$skypedetil.'Peer-to-peerAppSharingCount' -gt 0){
       $dd= $reportrefdte+'~!~'+$username+'~!~'+$skypedetil.'Peer-to-peerAppSharingCount'+'~!~'+$PeerLastActivityDate+'~!~'+$OrganizedConferenceLastActivityDate+'~!~'+$ParticipatedConferenceLastActivityDate+'~!~'+$LastActivityDate+'~!~'+$IsDeleted+'~!~'+$DeletedDate+'~!~'+$AssignedProducts
       $SBOUsgReptHash['Peer-to-peerAppSharing'].Add($dd,[int]($skypedetil.'Peer-to-peerAppSharingCount'))
       }
       if([int]$skypedetil.'Peer-to-peerFileTransferCount' -gt 0){
       $dd= $reportrefdte+'~!~'+$username+'~!~'+$skypedetil.'Peer-to-peerFileTransferCount'+'~!~'+$PeerLastActivityDate+'~!~'+$OrganizedConferenceLastActivityDate+'~!~'+$ParticipatedConferenceLastActivityDate+'~!~'+$LastActivityDate+'~!~'+$IsDeleted+'~!~'+$DeletedDate+'~!~'+$AssignedProducts
       $SBOUsgReptHash['Peer-to-peerFileTransfer'].Add($dd,[int]($skypedetil.'Peer-to-peerFileTransferCount'))
       }
       if([int]$skypedetil.'OrganizedConferenceIMCount' -gt 0){
       $dd= $reportrefdte+'~!~'+$username+'~!~'+$skypedetil.'OrganizedConferenceIMCount'+'~!~'+$PeerLastActivityDate+'~!~'+$OrganizedConferenceLastActivityDate+'~!~'+$ParticipatedConferenceLastActivityDate+'~!~'+$LastActivityDate+'~!~'+$IsDeleted+'~!~'+$DeletedDate+'~!~'+$AssignedProducts
       $SBOUsgReptHash['OrganizedConferenceIM'].Add($dd,[int]($skypedetil.'OrganizedConferenceIMCount'))
       }
       if([int]$skypedetil.'OrganizedConferenceAudio/VideoCount' -gt 0){
       $dd= $reportrefdte+'~!~'+$username+'~!~'+$skypedetil.'OrganizedConferenceAudio/VideoCount'+'~!~'+$PeerLastActivityDate+'~!~'+$OrganizedConferenceLastActivityDate+'~!~'+$ParticipatedConferenceLastActivityDate+'~!~'+$LastActivityDate+'~!~'+$IsDeleted+'~!~'+$DeletedDate+'~!~'+$AssignedProducts
       $SBOUsgReptHash['OrganizedConferenceAudio/Video'].Add($dd,[int]($skypedetil.'OrganizedConferenceAudio/VideoCount'))
       }
       if([int]$skypedetil.'OrganizedConferenceAudio/VideoMinutes' -gt 0){
       $dd= $reportrefdte+'~!~'+$username+'~!~'+$skypedetil.'OrganizedConferenceAudio/VideoMinutes'+'~!~'+$PeerLastActivityDate+'~!~'+$OrganizedConferenceLastActivityDate+'~!~'+$ParticipatedConferenceLastActivityDate+'~!~'+$LastActivityDate+'~!~'+$IsDeleted+'~!~'+$DeletedDate+'~!~'+$AssignedProducts
       $SBOUsgReptHash['OrganizedConferenceAudio/VideoMinutes'].Add($dd,[int]($skypedetil.'OrganizedConferenceAudio/VideoMinutes'))
       }
       if([int]$skypedetil.'OrganizedConferenceWebCount' -gt 0){
       $dd= $reportrefdte+'~!~'+$username+'~!~'+$skypedetil.'OrganizedConferenceWebCount'+'~!~'+$PeerLastActivityDate+'~!~'+$OrganizedConferenceLastActivityDate+'~!~'+$ParticipatedConferenceLastActivityDate+'~!~'+$LastActivityDate+'~!~'+$IsDeleted+'~!~'+$DeletedDate+'~!~'+$AssignedProducts
       $SBOUsgReptHash['OrganizedConferenceWeb'].Add($dd,[int]($skypedetil.'OrganizedConferenceWebCount'))
       }
       if([int]$skypedetil.'OrganizedConferenceDial-in/out3rdPartyCount' -gt 0){
       $dd= $reportrefdte+'~!~'+$username+'~!~'+$skypedetil.'OrganizedConferenceDial-in/out3rdPartyCount'+'~!~'+$PeerLastActivityDate+'~!~'+$OrganizedConferenceLastActivityDate+'~!~'+$ParticipatedConferenceLastActivityDate+'~!~'+$LastActivityDate+'~!~'+$IsDeleted+'~!~'+$DeletedDate+'~!~'+$AssignedProducts
       $SBOUsgReptHash['OrganizedConferenceDial-in/out3rdParty'].Add($dd,[int]($skypedetil.'OrganizedConferenceDial-in/out3rdPartyCount'))
       }
       if([int]$skypedetil.'OrganizedConferenceDial-in/outMicrosoftCount' -gt 0){
       $dd= $reportrefdte+'~!~'+$username+'~!~'+$skypedetil.'OrganizedConferenceDial-in/outMicrosoftCount'+'~!~'+$PeerLastActivityDate+'~!~'+$OrganizedConferenceLastActivityDate+'~!~'+$ParticipatedConferenceLastActivityDate+'~!~'+$LastActivityDate+'~!~'+$IsDeleted+'~!~'+$DeletedDate+'~!~'+$AssignedProducts
       $SBOUsgReptHash['OrganizedConferenceDial-in/outMicrosoft'].Add($dd,[int]($skypedetil.'OrganizedConferenceDial-in/outMicrosoftCount'))
       }
       if([int]$skypedetil.'OrganizedConferenceDial-inMicrosoftMinutes' -gt 0){
       $dd= $reportrefdte+'~!~'+$username+'~!~'+$skypedetil.'OrganizedConferenceDial-inMicrosoftMinutes'+'~!~'+$PeerLastActivityDate+'~!~'+$OrganizedConferenceLastActivityDate+'~!~'+$ParticipatedConferenceLastActivityDate+'~!~'+$LastActivityDate+'~!~'+$IsDeleted+'~!~'+$DeletedDate+'~!~'+$AssignedProducts
       $SBOUsgReptHash['OrganizedConferenceDial-inMicrosoftMinutes'].Add($dd,[int]($skypedetil.'OrganizedConferenceDial-inMicrosoftMinutes'))
       }
       if([int]$skypedetil.'OrganizedConferenceDial-outMicrosoftMinutes' -gt 0){
       $dd= $reportrefdte+'~!~'+$username+'~!~'+$skypedetil.'OrganizedConferenceDial-outMicrosoftMinutes'+'~!~'+$PeerLastActivityDate+'~!~'+$OrganizedConferenceLastActivityDate+'~!~'+$ParticipatedConferenceLastActivityDate+'~!~'+$LastActivityDate+'~!~'+$IsDeleted+'~!~'+$DeletedDate+'~!~'+$AssignedProducts
       $SBOUsgReptHash['OrganizedConferenceDial-outMicrosoftMinutes'].Add($dd,[int]($skypedetil.'OrganizedConferenceDial-outMicrosoftMinutes'))
       }
       if([int]$skypedetil.'OrganizedConferenceAppSharingCount' -gt 0){
       $dd= $reportrefdte+'~!~'+$username+'~!~'+$skypedetil.'OrganizedConferenceAppSharingCount'+'~!~'+$PeerLastActivityDate+'~!~'+$OrganizedConferenceLastActivityDate+'~!~'+$ParticipatedConferenceLastActivityDate+'~!~'+$LastActivityDate+'~!~'+$IsDeleted+'~!~'+$DeletedDate+'~!~'+$AssignedProducts
       $SBOUsgReptHash['OrganizedConferenceAppSharing'].Add($dd,[int]($skypedetil.'OrganizedConferenceAppSharingCount'))
       }
       if([int]$skypedetil.ParticipatedConferenceIMCount -gt 0){
       $dd= $reportrefdte+'~!~'+$username+'~!~'+$skypedetil.ParticipatedConferenceIMCount+'~!~'+$PeerLastActivityDate+'~!~'+$OrganizedConferenceLastActivityDate+'~!~'+$ParticipatedConferenceLastActivityDate+'~!~'+$LastActivityDate+'~!~'+$IsDeleted+'~!~'+$DeletedDate+'~!~'+$AssignedProducts
       $SBOUsgReptHash['ParticipatedConferenceIM'].Add($dd,[int]($skypedetil.ParticipatedConferenceIMCount))
       }
       if([int]$skypedetil.'ParticipatedConferenceAudio/VideoCount' -gt 0){
       $dd= $reportrefdte+'~!~'+$username+'~!~'+$skypedetil.'ParticipatedConferenceAudio/VideoCount'+'~!~'+$PeerLastActivityDate+'~!~'+$OrganizedConferenceLastActivityDate+'~!~'+$ParticipatedConferenceLastActivityDate+'~!~'+$LastActivityDate+'~!~'+$IsDeleted+'~!~'+$DeletedDate+'~!~'+$AssignedProducts
       $SBOUsgReptHash['ParticipatedConferenceAudio/Video'].Add($dd,[int]($skypedetil.'ParticipatedConferenceAudio/VideoCount'))
       }
       if([int]$skypedetil.'ParticipatedConferenceAudio/VideoMinutes' -gt 0){
       $dd= $reportrefdte+'~!~'+$username+'~!~'+$skypedetil.'ParticipatedConferenceAudio/VideoMinutes'+'~!~'+$PeerLastActivityDate+'~!~'+$OrganizedConferenceLastActivityDate+'~!~'+$ParticipatedConferenceLastActivityDate+'~!~'+$LastActivityDate+'~!~'+$IsDeleted+'~!~'+$DeletedDate+'~!~'+$AssignedProducts
       $SBOUsgReptHash['ParticipatedConferenceAudio/VideoMinutes'].Add($dd,[int]($skypedetil.'ParticipatedConferenceAudio/VideoMinutes'))
       }
       if([int]$skypedetil.ParticipatedConferenceWebCount -gt 0){
       $dd= $reportrefdte+'~!~'+$username+'~!~'+$skypedetil.ParticipatedConferenceWebCount+'~!~'+$PeerLastActivityDate+'~!~'+$OrganizedConferenceLastActivityDate+'~!~'+$ParticipatedConferenceLastActivityDate+'~!~'+$LastActivityDate+'~!~'+$IsDeleted+'~!~'+$DeletedDate+'~!~'+$AssignedProducts
       $SBOUsgReptHash['ParticipatedConferenceWeb'].Add($dd,[int]($skypedetil.ParticipatedConferenceWebCount))
       }
       if([int]$skypedetil.'ParticipatedConferenceDial-in/out3rdPartyCount' -gt 0){
       $dd= $reportrefdte+'~!~'+$username+'~!~'+$skypedetil.'ParticipatedConferenceDial-in/out3rdPartyCount'+'~!~'+$PeerLastActivityDate+'~!~'+$OrganizedConferenceLastActivityDate+'~!~'+$ParticipatedConferenceLastActivityDate+'~!~'+$LastActivityDate+'~!~'+$IsDeleted+'~!~'+$DeletedDate+'~!~'+$AssignedProducts
       $SBOUsgReptHash['ParticipatedConferenceDial-in/out3rdParty'].Add($dd,[int]($skypedetil.'ParticipatedConferenceDial-in/out3rdPartyCount'))
       }
       if([int]$skypedetil.ParticipatedConferenceAppSharingCount -gt 0){
       $dd= $reportrefdte+'~!~'+$username+'~!~'+$skypedetil.ParticipatedConferenceAppSharingCount+'~!~'+$PeerLastActivityDate+'~!~'+$OrganizedConferenceLastActivityDate+'~!~'+$ParticipatedConferenceLastActivityDate+'~!~'+$LastActivityDate+'~!~'+$IsDeleted+'~!~'+$DeletedDate+'~!~'+$AssignedProducts
       $SBOUsgReptHash['ParticipatedConferenceAppSharing'].Add($dd,[int]($skypedetil.ParticipatedConferenceAppSharingCount))
       }

}
    #Write-Host 'ReportDate:'$reportDte
    Write-Host '-------------Peet to Peer Sessions-------------'
    Write-Host 'peermeasure~' $peertopimcnt'~'$peertopAudcnt'~'$peertopAudmincnt'~'$peertopvidcnt'~'$peertopvidmincnt'~'$peertopAppcnt'~'$peertopFletracnt'~'$Totpeertopeercnt

        foreach($peer in $SBOUsgReptHash['Peer-to-peerIM'].GetEnumerator() | sort -Property value -Descending | select -First 25)
	    {
		    Write-Host '#peerInstantsMsgsdd~!~'$peer.Key
	    }
        foreach($peer in $SBOUsgReptHash['Peer-to-peerAudio'].GetEnumerator() | sort -Property value -Descending | select -First 25 )
	    {
		    Write-Host '#peerAudiocalldd~!~'$peer.key
	    }
        foreach($peer in $SBOUsgReptHash['Peer-to-peerAudioMinutes'].GetEnumerator() | sort -Property value -Descending | select -First 25 )
	    {
		    Write-Host '#peerAudiomindd~!~'$peer.key
	    }
        foreach($peer in $SBOUsgReptHash['Peer-to-peerVideo'].GetEnumerator() | sort -Property value -Descending | select -First 25 )
	    {
		    Write-Host '#peervideocalldd~!~'$peer.Key
	    }
        foreach($peer in $SBOUsgReptHash['Peer-to-peerVideoMinutes'].GetEnumerator() | sort -Property value -Descending | select -First 25 )
	    {
		    Write-Host '#peervideomindd~!~'$peer.key
	    }
        foreach($peer in $SBOUsgReptHash['Peer-to-peerAppSharing'].GetEnumerator() | sort -Property value -Descending | select -First 25 )
	    {
		    Write-Host '#peerAppsharedd~!~'$peer.key
	    }
        foreach($peer in $SBOUsgReptHash['Peer-to-peerFileTransfer'].GetEnumerator() | sort -Property value -Descending | select -First 25 )
	    {
		    Write-Host '#peerfiletransdd~!~'$peer.key
	    }

    Write-Host '-------------Organized Confereneces-------------'
    Write-Host 'orgconmeasures~' $orgconimcnt'~'$orgconAudvidcnt'~'$orgconAudvidmincnt'~'$orgconwebcnt'~'$orgcondial3partcnt'~'$orgcondialmscnt'~'$orgcondialinmsmincnt'~'$orgcondialoutmsmincnt'~'$orgconAppcnt'~'$Totorganizedcnt

        foreach($orgcon in $SBOUsgReptHash['OrganizedConferenceIM'].GetEnumerator() | sort -Property value -Descending | select -First 25)
	    {
		    Write-Host '#orgInstantsMsgsdd~!~'$orgcon.key
	    }
        foreach($orgcon in $SBOUsgReptHash['OrganizedConferenceAudio/Video'].GetEnumerator() | sort -Property value -Descending | select -First 25)
	    {
		    Write-Host '#orgAudiovideocalldd~!~'$orgcon.key
	    }
        foreach($orgcon in $SBOUsgReptHash['OrganizedConferenceAudio/VideoMinutes'].GetEnumerator() | sort -Property value -Descending | select -First 25)
	    {
		    Write-Host '#orgAudiovideomindd~!~'$orgcon.key
	    }
        foreach($orgcon in $SBOUsgReptHash['OrganizedConferenceWeb'].GetEnumerator() | sort -Property value -Descending | select -First 25)
	    {
		    Write-Host '#orgwebdd~!~'$orgcon.key
	    }
        foreach($orgcon in $SBOUsgReptHash['OrganizedConferenceDial-in/out3rdParty'].GetEnumerator() | sort -Property value -Descending | select -First 25)
	    {
		    Write-Host '#orgDialinout3dd~!~'$orgcon.key
	    }
        foreach($orgcon in $SBOUsgReptHash['OrganizedConferenceDial-in/outMicrosoft'].GetEnumerator() | sort -Property value -Descending | select -First 25)
	    {
		    Write-Host '#orgDialinoutmsdd~!~'$orgcon.key
	    }
        foreach($orgcon in $SBOUsgReptHash['OrganizedConferenceDial-inMicrosoftMinutes'].GetEnumerator() | sort -Property value -Descending | select -First 25)
	    {
		    Write-Host '#orgDialinmsmindd~!~'$orgcon.key
	    }
        foreach($orgcon in $SBOUsgReptHash['OrganizedConferenceDial-outMicrosoftMinutes'].GetEnumerator() | sort -Property value -Descending | select -First 25)
	    {
		    Write-Host '#orgDialoutmsmindd~!~'$orgcon.key
	    }
        foreach($orgcon in $SBOUsgReptHash['OrganizedConferenceAppSharing'].GetEnumerator() | sort -Property value -Descending | select -First 25)
	    {
		    Write-Host '#orgAppsharedd~!~'$orgcon.key
	    }

    Write-Host '-------------participated Confereneces-------------'
    Write-Host 'parconmeasures~' $parconimcnt'~'$parconAudvidcnt'~'$parconAudvidmincnt'~'$parconwebcnt'~'$parcondial3partcnt'~'$parconAppcnt'~'$TotParticipatedcnt
        
        foreach($parcon in $SBOUsgReptHash['ParticipatedConferenceIM'].GetEnumerator() | sort -Property value -Descending | select -First 25)
	    {
		    Write-Host '#parInstantsMsgsdd~!~'$parcon.key
	    }
        foreach($parcon in $SBOUsgReptHash['ParticipatedConferenceAudio/Video'].GetEnumerator() | sort -Property value -Descending | select -First 25)
	    {
		    Write-Host '#parAudiovideocalldd~!~'$parcon.key
	    }
        foreach($parcon in $SBOUsgReptHash['ParticipatedConferenceAudio/VideoMinutes'].GetEnumerator() | sort -Property value -Descending | select -First 25)
	    {
		    Write-Host '#parAudiovideomindd~!~'$parcon.key
	    }
        foreach($parcon in $SBOUsgReptHash['ParticipatedConferenceWeb'].GetEnumerator() | sort -Property value -Descending | select -First 25)
	    {
		    Write-Host '#parwebdd~!~'$parcon.key
	    }
        foreach($parcon in $SBOUsgReptHash['ParticipatedConferenceDial-in/out3rdParty'].GetEnumerator() | sort -Property value -Descending | select -First 25)
	    {
		    Write-Host '#parDialinout3dd~!~'$parcon.key
	    }
        foreach($parcon in $SBOUsgReptHash['ParticipatedConferenceAppSharing'].GetEnumerator() | sort -Property value -Descending | select -First 25)
	    {
		    Write-Host '#parAppsharedd~!~'$parcon.key
	    }
      $SBOUsgReptHash =$null
  #>  
    Write-Host '-------------Device Usage-------------'
   
   foreach($dev in $SkyDevUsg){
        $isFlag=$false
        $dev.PSObject.Properties | ForEach-Object{
            if($_.Name -eq 'ReportPeriod'){break}
            
            if($isFlag){
                $write='deviceinfo~ '+$_.Name+' ~ '+$_.Value
                Write-Host $write  
            }

            if($_.Name -eq 'ReportRefreshDate'){$isFlag=$true}
        }
  }

<#

    if(Test-Path -Path $SkypeInput){
    Write-Log (" inside SkypeInput csv remove path" )
        Remove-Item $SkypeInput -Force
    }

    if($Error){ Write-Log $Error ;$Error.Clear()}
     
    if(Test-Path -Path $userdetilcsv){
    Write-Log (" inside userdetails csv remove path" )
        Remove-Item $userdetilcsv -Force
    }
    
    if($Error){ Write-Log $Error ;$Error.Clear()}
    
    if(Test-Path -Path $activecntcsv){
    Write-Log (" inside activecntcsv csv remove path" )
        Remove-Item $activecntcsv -Force
    }
  #>  
    if($Error){ Write-Log 'Error.... $Error' ;$Error.Clear()}
    
    if(Test-Path -Path $deviceusagecsv){
        Write-Log (" Removing the  deviceusagecsv file" )
        Remove-Item $deviceusagecsv -Force
    }
    if($Error){ Write-Log ('Error.... '+$Error ) ;$Error.Clear()} 
    Write-Log (".............Script completed.............." )
# SIG # Begin signature block
# MIIcdAYJKoZIhvcNAQcCoIIcZTCCHGECAQExCzAJBgUrDgMCGgUAMGkGCisGAQQB
# gjcCAQSgWzBZMDQGCisGAQQBgjcCAR4wJgIDAQAABBAfzDtgWUsITrck0sYpfvNR
# AgEAAgEAAgEAAgEAAgEAMCEwCQYFKw4DAhoFAAQU5NfOHOkuyoeY3gzlvL+lcFvK
# F/yggherMIIFMDCCBBigAwIBAgIQBAkYG1/Vu2Z1U0O1b5VQCDANBgkqhkiG9w0B
# AQsFADBlMQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYD
# VQQLExB3d3cuZGlnaWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVk
# IElEIFJvb3QgQ0EwHhcNMTMxMDIyMTIwMDAwWhcNMjgxMDIyMTIwMDAwWjByMQsw
# CQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cu
# ZGlnaWNlcnQuY29tMTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQg
# Q29kZSBTaWduaW5nIENBMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA
# +NOzHH8OEa9ndwfTCzFJGc/Q+0WZsTrbRPV/5aid2zLXcep2nQUut4/6kkPApfmJ
# 1DcZ17aq8JyGpdglrA55KDp+6dFn08b7KSfH03sjlOSRI5aQd4L5oYQjZhJUM1B0
# sSgmuyRpwsJS8hRniolF1C2ho+mILCCVrhxKhwjfDPXiTWAYvqrEsq5wMWYzcT6s
# cKKrzn/pfMuSoeU7MRzP6vIK5Fe7SrXpdOYr/mzLfnQ5Ng2Q7+S1TqSp6moKq4Tz
# rGdOtcT3jNEgJSPrCGQ+UpbB8g8S9MWOD8Gi6CxR93O8vYWxYoNzQYIH5DiLanMg
# 0A9kczyen6Yzqf0Z3yWT0QIDAQABo4IBzTCCAckwEgYDVR0TAQH/BAgwBgEB/wIB
# ADAOBgNVHQ8BAf8EBAMCAYYwEwYDVR0lBAwwCgYIKwYBBQUHAwMweQYIKwYBBQUH
# AQEEbTBrMCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wQwYI
# KwYBBQUHMAKGN2h0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFz
# c3VyZWRJRFJvb3RDQS5jcnQwgYEGA1UdHwR6MHgwOqA4oDaGNGh0dHA6Ly9jcmw0
# LmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJRFJvb3RDQS5jcmwwOqA4oDaG
# NGh0dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJRFJvb3RD
# QS5jcmwwTwYDVR0gBEgwRjA4BgpghkgBhv1sAAIEMCowKAYIKwYBBQUHAgEWHGh0
# dHBzOi8vd3d3LmRpZ2ljZXJ0LmNvbS9DUFMwCgYIYIZIAYb9bAMwHQYDVR0OBBYE
# FFrEuXsqCqOl6nEDwGD5LfZldQ5YMB8GA1UdIwQYMBaAFEXroq/0ksuCMS1Ri6en
# IZ3zbcgPMA0GCSqGSIb3DQEBCwUAA4IBAQA+7A1aJLPzItEVyCx8JSl2qB1dHC06
# GsTvMGHXfgtg/cM9D8Svi/3vKt8gVTew4fbRknUPUbRupY5a4l4kgU4QpO4/cY5j
# DhNLrddfRHnzNhQGivecRk5c/5CxGwcOkRX7uq+1UcKNJK4kxscnKqEpKBo6cSgC
# PC6Ro8AlEeKcFEehemhor5unXCBc2XGxDI+7qPjFEmifz0DLQESlE/DmZAwlCEIy
# sjaKJAL+L3J+HNdJRZboWR3p+nRka7LrZkPas7CM1ekN3fYBIM6ZMWM9CBoYs4Gb
# T8aTEAb8B4H6i9r5gkn3Ym6hU/oSlBiFLpKR6mhsRDKyZqHnGKSaZFHvMIIFNDCC
# BBygAwIBAgIQAuEYSxAWnqD3sU8D3BMzUjANBgkqhkiG9w0BAQsFADByMQswCQYD
# VQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGln
# aWNlcnQuY29tMTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQgQ29k
# ZSBTaWduaW5nIENBMB4XDTE4MDcxMDAwMDAwMFoXDTIxMDkxNTEyMDAwMFowcTEL
# MAkGA1UEBhMCVVMxEzARBgNVBAgTCk5ldyBKZXJzZXkxDzANBgNVBAcTBklzZWxp
# bjEdMBsGA1UEChMUZUcgSW5ub3ZhdGlvbnMsIEluYy4xHTAbBgNVBAMTFGVHIElu
# bm92YXRpb25zLCBJbmMuMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA
# oNt7XWB1y9xwtvCGO/XipXallOkZ3ScdXunWCONnBzryRdCj7C/WX9s1CU8KkjRP
# FjWW+BOXvvC4ZUqw0Ad2uJAXyBY2/lV9eaoTRFB6Kb2/tJzG3je7Vcu8MxGJlwzP
# QQrr6icEJeqAPFE7vmzThVbd9H1n5Zdmwx20WCFe2V9qyVYHt7/6GS7WB2CwwjT6
# iVmiKP8HZXgr3tHZeAEb7tdQqd5//9e+8Mp8anb8ZdNgC9PQjBmbrQ/wH3kV65gK
# L+5kbgRvIfsmYxXiU1IFkq4rSQ+tfsDtYqBhGfovef9Gt8ZTjx7S4fortxwR7tlz
# i+wLO5m8I9sm4I2ouyIOQQIDAQABo4IBxTCCAcEwHwYDVR0jBBgwFoAUWsS5eyoK
# o6XqcQPAYPkt9mV1DlgwHQYDVR0OBBYEFD3yRqdsw6UIddfMPwhUMv2AaGRAMA4G
# A1UdDwEB/wQEAwIHgDATBgNVHSUEDDAKBggrBgEFBQcDAzB3BgNVHR8EcDBuMDWg
# M6Axhi9odHRwOi8vY3JsMy5kaWdpY2VydC5jb20vc2hhMi1hc3N1cmVkLWNzLWcx
# LmNybDA1oDOgMYYvaHR0cDovL2NybDQuZGlnaWNlcnQuY29tL3NoYTItYXNzdXJl
# ZC1jcy1nMS5jcmwwTAYDVR0gBEUwQzA3BglghkgBhv1sAwEwKjAoBggrBgEFBQcC
# ARYcaHR0cHM6Ly93d3cuZGlnaWNlcnQuY29tL0NQUzAIBgZngQwBBAEwgYQGCCsG
# AQUFBwEBBHgwdjAkBggrBgEFBQcwAYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29t
# ME4GCCsGAQUFBzAChkJodHRwOi8vY2FjZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNl
# cnRTSEEyQXNzdXJlZElEQ29kZVNpZ25pbmdDQS5jcnQwDAYDVR0TAQH/BAIwADAN
# BgkqhkiG9w0BAQsFAAOCAQEAP1QnJ6TEczaeGxVokMinsKam1mJB+zDk4B9rfm31
# iaZe9OeNvR/UJAs+5b0gKBZF9NmTVdayAYV74vZU5IElRo59q6hbg/20Wu87UyoE
# Yjwrv2DxHgl3z80piuLllmoe79vEu/bYvreBamzZmHlyxRP0us2KRfEsLBH23y1o
# zBATLc3yBu+mCfDg9E1RfhpKyD1iMHkbC90To6bpOlP9Pd6R4WEAFROILgm2bofQ
# ZhN4UNKbJ1uLCvV2NiUbU7+YSC3NP9SdphaDBiOnUWiK8MjTIPZbhh3QjI5f342q
# cUiR4LGx/Z/6pq4w6YHWd8c1czexD7xVCom7ZafCOKFWyzCCBmowggVSoAMCAQIC
# EAMBmgI6/1ixa9bV6uYX8GYwDQYJKoZIhvcNAQEFBQAwYjELMAkGA1UEBhMCVVMx
# FTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNv
# bTEhMB8GA1UEAxMYRGlnaUNlcnQgQXNzdXJlZCBJRCBDQS0xMB4XDTE0MTAyMjAw
# MDAwMFoXDTI0MTAyMjAwMDAwMFowRzELMAkGA1UEBhMCVVMxETAPBgNVBAoTCERp
# Z2lDZXJ0MSUwIwYDVQQDExxEaWdpQ2VydCBUaW1lc3RhbXAgUmVzcG9uZGVyMIIB
# IjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAo2Rd/Hyz4II14OD2xirmSXU7
# zG7gU6mfH2RZ5nxrf2uMnVX4kuOe1VpjWwJJUNmDzm9m7t3LhelfpfnUh3SIRDsZ
# yeX1kZ/GFDmsJOqoSyyRicxeKPRktlC39RKzc5YKZ6O+YZ+u8/0SeHUOplsU/UUj
# joZEVX0YhgWMVYd5SEb3yg6Np95OX+Koti1ZAmGIYXIYaLm4fO7m5zQvMXeBMB+7
# NgGN7yfj95rwTDFkjePr+hmHqH7P7IwMNlt6wXq4eMfJBi5GEMiN6ARg27xzdPpO
# 2P6qQPGyznBGg+naQKFZOtkVCVeZVjCT88lhzNAIzGvsYkKRrALA76TwiRGPdwID
# AQABo4IDNTCCAzEwDgYDVR0PAQH/BAQDAgeAMAwGA1UdEwEB/wQCMAAwFgYDVR0l
# AQH/BAwwCgYIKwYBBQUHAwgwggG/BgNVHSAEggG2MIIBsjCCAaEGCWCGSAGG/WwH
# ATCCAZIwKAYIKwYBBQUHAgEWHGh0dHBzOi8vd3d3LmRpZ2ljZXJ0LmNvbS9DUFMw
# ggFkBggrBgEFBQcCAjCCAVYeggFSAEEAbgB5ACAAdQBzAGUAIABvAGYAIAB0AGgA
# aQBzACAAQwBlAHIAdABpAGYAaQBjAGEAdABlACAAYwBvAG4AcwB0AGkAdAB1AHQA
# ZQBzACAAYQBjAGMAZQBwAHQAYQBuAGMAZQAgAG8AZgAgAHQAaABlACAARABpAGcA
# aQBDAGUAcgB0ACAAQwBQAC8AQwBQAFMAIABhAG4AZAAgAHQAaABlACAAUgBlAGwA
# eQBpAG4AZwAgAFAAYQByAHQAeQAgAEEAZwByAGUAZQBtAGUAbgB0ACAAdwBoAGkA
# YwBoACAAbABpAG0AaQB0ACAAbABpAGEAYgBpAGwAaQB0AHkAIABhAG4AZAAgAGEA
# cgBlACAAaQBuAGMAbwByAHAAbwByAGEAdABlAGQAIABoAGUAcgBlAGkAbgAgAGIA
# eQAgAHIAZQBmAGUAcgBlAG4AYwBlAC4wCwYJYIZIAYb9bAMVMB8GA1UdIwQYMBaA
# FBUAEisTmLKZB+0e36K+Vw0rZwLNMB0GA1UdDgQWBBRhWk0ktkkynUoqeRqDS/Qe
# icHKfTB9BgNVHR8EdjB0MDigNqA0hjJodHRwOi8vY3JsMy5kaWdpY2VydC5jb20v
# RGlnaUNlcnRBc3N1cmVkSURDQS0xLmNybDA4oDagNIYyaHR0cDovL2NybDQuZGln
# aWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJlZElEQ0EtMS5jcmwwdwYIKwYBBQUHAQEE
# azBpMCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wQQYIKwYB
# BQUHMAKGNWh0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3Vy
# ZWRJRENBLTEuY3J0MA0GCSqGSIb3DQEBBQUAA4IBAQCdJX4bM02yJoFcm4bOIyAP
# gIfliP//sdRqLDHtOhcZcRfNqRu8WhY5AJ3jbITkWkD73gYBjDf6m7GdJH7+IKRX
# rVu3mrBgJuppVyFdNC8fcbCDlBkFazWQEKB7l8f2P+fiEUGmvWLZ8Cc9OB0obzpS
# CfDscGLTYkuw4HOmksDTjjHYL+NtFxMG7uQDthSr849Dp3GdId0UyhVdkkHa+Q+B
# 0Zl0DSbEDn8btfWg8cZ3BigV6diT5VUW8LsKqxzbXEgnZsijiwoc5ZXarsQuWaBh
# 3drzbaJh6YoLbewSGL33VVRAA5Ira8JRwgpIr7DUbuD0FAo6G+OPPcqvao173NhE
# MIIGzTCCBbWgAwIBAgIQBv35A5YDreoACus/J7u6GzANBgkqhkiG9w0BAQUFADBl
# MQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3
# d3cuZGlnaWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVkIElEIFJv
# b3QgQ0EwHhcNMDYxMTEwMDAwMDAwWhcNMjExMTEwMDAwMDAwWjBiMQswCQYDVQQG
# EwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNl
# cnQuY29tMSEwHwYDVQQDExhEaWdpQ2VydCBBc3N1cmVkIElEIENBLTEwggEiMA0G
# CSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDogi2Z+crCQpWlgHNAcNKeVlRcqcTS
# QQaPyTP8TUWRXIGf7Syc+BZZ3561JBXCmLm0d0ncicQK2q/LXmvtrbBxMevPOkAM
# Rk2T7It6NggDqww0/hhJgv7HxzFIgHweog+SDlDJxofrNj/YMMP/pvf7os1vcyP+
# rFYFkPAyIRaJxnCI+QWXfaPHQ90C6Ds97bFBo+0/vtuVSMTuHrPyvAwrmdDGXRJC
# geGDboJzPyZLFJCuWWYKxI2+0s4Grq2Eb0iEm09AufFM8q+Y+/bOQF1c9qjxL6/s
# iSLyaxhlscFzrdfx2M8eCnRcQrhofrfVdwonVnwPYqQ/MhRglf0HBKIJAgMBAAGj
# ggN6MIIDdjAOBgNVHQ8BAf8EBAMCAYYwOwYDVR0lBDQwMgYIKwYBBQUHAwEGCCsG
# AQUFBwMCBggrBgEFBQcDAwYIKwYBBQUHAwQGCCsGAQUFBwMIMIIB0gYDVR0gBIIB
# yTCCAcUwggG0BgpghkgBhv1sAAEEMIIBpDA6BggrBgEFBQcCARYuaHR0cDovL3d3
# dy5kaWdpY2VydC5jb20vc3NsLWNwcy1yZXBvc2l0b3J5Lmh0bTCCAWQGCCsGAQUF
# BwICMIIBVh6CAVIAQQBuAHkAIAB1AHMAZQAgAG8AZgAgAHQAaABpAHMAIABDAGUA
# cgB0AGkAZgBpAGMAYQB0AGUAIABjAG8AbgBzAHQAaQB0AHUAdABlAHMAIABhAGMA
# YwBlAHAAdABhAG4AYwBlACAAbwBmACAAdABoAGUAIABEAGkAZwBpAEMAZQByAHQA
# IABDAFAALwBDAFAAUwAgAGEAbgBkACAAdABoAGUAIABSAGUAbAB5AGkAbgBnACAA
# UABhAHIAdAB5ACAAQQBnAHIAZQBlAG0AZQBuAHQAIAB3AGgAaQBjAGgAIABsAGkA
# bQBpAHQAIABsAGkAYQBiAGkAbABpAHQAeQAgAGEAbgBkACAAYQByAGUAIABpAG4A
# YwBvAHIAcABvAHIAYQB0AGUAZAAgAGgAZQByAGUAaQBuACAAYgB5ACAAcgBlAGYA
# ZQByAGUAbgBjAGUALjALBglghkgBhv1sAxUwEgYDVR0TAQH/BAgwBgEB/wIBADB5
# BggrBgEFBQcBAQRtMGswJAYIKwYBBQUHMAGGGGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0
# LmNvbTBDBggrBgEFBQcwAoY3aHR0cDovL2NhY2VydHMuZGlnaWNlcnQuY29tL0Rp
# Z2lDZXJ0QXNzdXJlZElEUm9vdENBLmNydDCBgQYDVR0fBHoweDA6oDigNoY0aHR0
# cDovL2NybDMuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJlZElEUm9vdENBLmNy
# bDA6oDigNoY0aHR0cDovL2NybDQuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJl
# ZElEUm9vdENBLmNybDAdBgNVHQ4EFgQUFQASKxOYspkH7R7for5XDStnAs0wHwYD
# VR0jBBgwFoAUReuir/SSy4IxLVGLp6chnfNtyA8wDQYJKoZIhvcNAQEFBQADggEB
# AEZQPsm3KCSnOB22WymvUs9S6TFHq1Zce9UNC0Gz7+x1H3Q48rJcYaKclcNQ5IK5
# I9G6OoZyrTh4rHVdFxc0ckeFlFbR67s2hHfMJKXzBBlVqefj56tizfuLLZDCwNK1
# lL1eT7EF0g49GqkUW6aGMWKoqDPkmzmnxPXOHXh2lCVz5Cqrz5x2S+1fwksW5Etw
# TACJHvzFebxMElf+X+EevAJdqP77BzhPDcZdkbkPZ0XN1oPt55INjbFpjE/7WeAj
# D9KqrgB87pxCDs+R1ye3Fu4Pw718CqDuLAhVhSK46xgaTfwqIa1JMYNHlXdx3LEb
# S0scEJx3FMGdTy9alQgpECYxggQzMIIELwIBATCBhjByMQswCQYDVQQGEwJVUzEV
# MBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNlcnQuY29t
# MTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQgQ29kZSBTaWduaW5n
# IENBAhAC4RhLEBaeoPexTwPcEzNSMAkGBSsOAwIaBQCgcDAQBgorBgEEAYI3AgEM
# MQIwADAZBgkqhkiG9w0BCQMxDAYKKwYBBAGCNwIBBDAcBgorBgEEAYI3AgELMQ4w
# DAYKKwYBBAGCNwIBFTAjBgkqhkiG9w0BCQQxFgQUWVcELJVoRcpGxSzONSSqvxxt
# YfswDQYJKoZIhvcNAQEBBQAEggEAEZSHdP0AEIAMlp/mqR7MYiveqX5rZJixHBa9
# hiC75Q/JOoPM3CFTNJzTD5P7a8ANbNpz92iSLyXuU9183L27Rrx76UGd7RumqX6+
# lJWfk8pDNbJeW4FwHTfrlndPTxZT6OI9mFEnTG96Jf5wZ2Dn7JYeKyJva4aHqnuI
# 0PGNNipLvL6ocvXDUv/xBwIM/F9Uycanu4JMGjiQi2stMW1QcgH3Im6XffEb4+gV
# b1+twD8cs3uP0Icww7ST7PCFSMdQOq7I/IKvlMpQ9R6MVc5iSO6NeYWSfLi9xLXz
# VHBFOMu4fVkrur3BeaeX+zwinkudVNV1ZDxIdSqZ90LwBqFBWKGCAg8wggILBgkq
# hkiG9w0BCQYxggH8MIIB+AIBATB2MGIxCzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxE
# aWdpQ2VydCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5jb20xITAfBgNVBAMT
# GERpZ2lDZXJ0IEFzc3VyZWQgSUQgQ0EtMQIQAwGaAjr/WLFr1tXq5hfwZjAJBgUr
# DgMCGgUAoF0wGAYJKoZIhvcNAQkDMQsGCSqGSIb3DQEHATAcBgkqhkiG9w0BCQUx
# DxcNMjAwNzIzMDIwNDIwWjAjBgkqhkiG9w0BCQQxFgQU5pC5hiWE67vGhPDH+mhk
# qM4Tf7owDQYJKoZIhvcNAQEBBQAEggEAGBOC5oV/6Vaz8zoWmrezCp13MApuM0l2
# 3WIpdCha8hIOaFK+pEhr48TrOYgfi6TYCCivlpY3CufsuVb2hmXepEvupTUzMCnI
# LZSyzJ3/pwir11AnJvJWMt1YtvEZjEO/cH6NOav4RBaDVYsMP1iLG7YvCbDoO1OF
# oLI7kL0IpJStyJTH3cHVYbTSS9lsUQqHZMM4iZorbdJqPvcKtCpFfqUWBTTdjodJ
# mBN7IcgWZG6jJxvtNrgDGocQScJIqioPD8NyeWprxb/qb+Oa0u34sIvU6DTOQm5B
# q95bgw7oNQmpCkkxMuFyHMy756cTO34o0q4FalFY3ISLhT+48LZiVg==
# SIG # End signature block
