﻿clear
[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$egInstallpath=Get-ChildItem Env:EGURKHA_INSTALL_DIR |Select Value
$egurkhaPath=$egInstallpath.Value.ToString()
$egEncryPath=$egurkhaPath+"\lib\EGFileEncryption.psm1"
$egDatnKy=$egurkhaPath+'\lib\GetDatnKeyFiles.psm1'
Import-Module $egEncryPath,$egDatnKy

$TestInputs=$args
$userName=$TestInputs[0]
$Password=Eg-O365Dcr -EncStr $TestInputs[1]
$proxyUsr=$TestInputs[2]
$proxyPass=Eg-O365Dcr -EncStr $TestInputs[3]
$DateProxyhostRepName=($TestInputs[4]).ToString().Split("#")
$readeddate=[datetime]($DateProxyhostRepName[0].Trim())
$proxyserverip=($DateProxyhostRepName[1]).ToString().trim()
$reportingname=($DateProxyhostRepName[2]).ToString().trim()


$ToReadDate=$readeddate.tostring(“yyyy-MM-dd”)
$proxyserver='http://'+$proxyserverip
$domain=Eg-GetDomain -userName $userName -Password $Password -proxyUsr $proxyUsr -proxyPass $proxyPass -IsIntial $true -proxyserver $proxyserver



$rptPath=$egurkhaPath+'\agent\O365\'+$reportingname
if(!(Test-Path -Path $rptPath )){
   $null =  New-Item -ItemType directory -Path $rptPath -WarningAction SilentlyContinue
}

try{
    $msGraphPath=$egurkhaPath+"\agent\O365\MsGraph"
    $keyFileNam = '\GraphDetailsKey.dat'
    $unProtPath= $msGraphPath+'\GraphDetails.dat'
    $kvalue= Get-Content -Path $msGraphPath$keyFileNam
    $null=Unprotect-File $unProtPath -Algorithm AES -KeyAsPlainText $kvalue -DstSuffix '.txt'
    $SkypeInput=$msGraphPath+"\GraphDetails.txt"
    $GetInput = Get-Content -Path $SkypeInput
}catch{
    Write-Error -Message "File not found. The $GetInput location does not contain GraphDetails "
}



Function Eg-InvokeUrl(){
	[CmdletBinding()]
    Param(
        [Parameter(Mandatory=$true, Position=1)]
        [String]$Url, 
        [Parameter(Mandatory=$true, Position=2)]
        [String]$filePath,
        [Parameter(Mandatory=$true, Position=3)]
        [Object]$header               
    )

    Process
    {
        $query = Invoke-RestMethod -Method 'Get' -Headers $header -Uri $Url
        $query=$query.Replace('ï»¿','')
        $query=$query.Replace(' ','')
        $resultarray = ConvertFrom-Csv -InputObject $query
        $reprts=$resultarray | ConvertTo-Json 
        $jsonreprt=@()
        $jsonreprt='{ "Usage" :['+$reprts+']}'
        $reports=$jsonreprt | ConvertFrom-Json
        for($i=0;$i -lt $reports.Usage.Length ;$i++ ){  
            $reports.Usage[$i] |Export-Csv $filePath -Append -NoTypeInformation -Force
        }
    }
}


$flag=$false
foreach($inp in $GetInput){
    if($inp.StartsWith('[') -and $inp.Contains($domain)){
        $flag=$true
    }
    if($flag){
        if($inp.Contains("client_id")){
            $appId =$inp.ToString().Substring($inp.IndexOf('~')+1)
        }
        if($inp.Contains("client_secret")){
            $appSecret =$inp.ToString().Substring($inp.IndexOf('~')+1)
        }
        if($inp.Contains("TenantName")){
            $tenantID=$inp.ToString().Substring($inp.IndexOf('~')+1)
        }
        if($inp.Contains("Authority")){
            $authString = $inp.ToString().Substring($inp.IndexOf('~')+1)
            $authString=$authString+$domain
        }
        if($inp.Contains("Resource")){
            $Resource =$inp.ToString().Substring($inp.IndexOf('~')+1)
            $flag=$false
        }
    }
}

$path=(([XML]((Get-Package -Name AzureAD  | select SwidTagText)).SwidTagText).SoftwareIdentity.Meta.InstalledLocation)+'\Microsoft.IdentityModel.Clients.ActiveDirectory.dll'
Add-Type -Path $path

$creds = New-Object "Microsoft.IdentityModel.Clients.ActiveDirectory.ClientCredential" -ArgumentList $appId, $appSecret
$authContext = New-Object "Microsoft.IdentityModel.Clients.ActiveDirectory.AuthenticationContext"-ArgumentList $authString
$context = $authContext.AcquireTokenAsync($Resource, $creds).Result
$authCode=$context.CreateAuthorizationHeader()
$header = @{
    'Authorization'=$authCode
}


$timenow = [int][double]::Parse((Get-Date -UFormat %s))
$O365GrupsActvts = $rptPath+'\getOffice365GroupsActivityDetail'+$timenow+'.csv'
#$date=([Datetime]"2019-02-21").tostring(“yyyy-MM-dd”)
$O365GrupsActvtUrl ="https://graph.microsoft.com/v1.0/reports/getOffice365GroupsActivityDetail(period='D7')"   #date="+$date+")"
Eg-InvokeUrl -Url $O365GrupsActvtUrl -filePath $O365GrupsActvts -header $header

$GrpsAct= Import-Csv  $O365GrupsActvts | Select * |  Where-Object { $_.IsDeleted -eq 'FALSE'}
$csvDir=$rptPath+'/'
Eg-DeleteCsvFiles -FilePath $csvDir -Pattern 'getOffice365GroupsActivityDetail'
$reportdate=$GrpsAct | select ReportRefreshDate -First 1
$reportdate=($reportdate.ReportRefreshDate)
if([datetime]$reportdate -ge [datetime]$ToReadDate)
{
    Write-Host 'ReadedDate for the Date#'$reportdate
} 
else{ 
    Write-Host 'thereIs No Data on#'$ToReadDate
    exit  
    }



$totalgrpscnt=$GrpsAct.Count
Write-Host '***********************Start****************************'
<#
if($totalgrpscnt){

    $topGrups = $GrpsAct | select * | Sort-Object { $_.MemberCount -as [int] }  -Descending | select  -First 5
    foreach($in in $topGrups)
    {

        Write-Host 'topGrpsMembersCount#' $in.GroupDisplayName ~!~ $in.OwnerPrincipalName ~!~ $in.LastActivityDate ~!~ $in.GroupType ~!~ $in.MemberCount

    }
}

Write-Host '***************************************************'

$sumofExternalMembCnt= ($GrpsAct | select ExternalMemberCount | measure-object -property ExternalMemberCount -Sum).sum
if($sumofExternalMembCnt){

    $topExternalMembCnt= $GrpsAct | select * | Sort-Object { $_.ExternalMemberCount -as [int] }  -Descending  | select -First 5
    foreach($in in $topExternalMembCnt)
    {

        Write-Host 'topGrpsExternalMembersCount#' $in.GroupDisplayName ~!~ $in.OwnerPrincipalName ~!~ $in.LastActivityDate ~!~ $in.GroupType ~!~ $in.ExternalMemberCount

    }

}
#>
Write-Host '***************************************************'

$sumofExMailBoxStorage= ($GrpsAct | select 'ExchangeMailboxStorageUsed(Byte)' | measure-object -property 'ExchangeMailboxStorageUsed(Byte)' -Sum).sum
if($sumofExMailBoxStorage){

    $sumofExMailBoxStorage = [math]::round($sumofExMailBoxStorage/1Gb, 2) 
    $topExMailBoxByStorage= $GrpsAct | select * | Sort-Object { $_.'ExchangeMailboxStorageUsed(Byte)' -as [double] }  -Descending| select -First 10
    foreach($in in $topExMailBoxByStorage)
    {
        $exchangembUsed = [math]::round(($in.'ExchangeMailboxStorageUsed(Byte)')/1Mb,2)
        Write-Host 'topGrpsWithExchngMailBoxStorageUsage#' $in.GroupDisplayName ~!~ $in.OwnerPrincipalName ~!~ $in.LastActivityDate ~!~ $in.GroupType ~!~ $exchangembUsed

    }
}

Write-Host '***************************************************'

$sumofExMailBoxItemsCnt= ($GrpsAct | select ExchangeMailboxTotalItemCount | measure-object -property ExchangeMailboxTotalItemCount -Sum).sum
if($sumofExMailBoxItemsCnt){
    
    $topExMailBoxByItemsCnt= $GrpsAct | select * | Sort-Object { $_.ExchangeMailboxTotalItemCount -as [double] }  -Descending | select -First 10
    foreach($in in $topExMailBoxByItemsCnt)
    {

        Write-Host 'topGrpsExchangeMailboxTotalItemCount#' $in.GroupDisplayName ~!~ $in.OwnerPrincipalName ~!~ $in.LastActivityDate ~!~ $in.GroupType ~!~ $in.ExchangeMailboxTotalItemCount

    }
}

Write-Host '***************************************************'

$sumofSharepointTotlfilsCnt= ($GrpsAct | select SharePointTotalFileCount | measure-object -property SharePointTotalFileCount -Sum).sum
if($sumofSharepointTotlfilsCnt){
    
    $topSharepointTotlfilsCnt= $GrpsAct | select * | Sort-Object { $_.SharePointTotalFileCount -as [double] }  -Descending | select -First 10
    foreach($in in $topSharepointTotlfilsCnt)
    {

        Write-Host 'topGrpsSharepointToalFileCount#' $in.GroupDisplayName ~!~ $in.OwnerPrincipalName ~!~ $in.LastActivityDate ~!~ $in.GroupType ~!~ $in.SharePointTotalFileCount

    }
}

Write-Host '***************************************************'

$sumofSharepointStageUsed= ($GrpsAct | select 'SharePointSiteStorageUsed(Byte)' | measure-object -property 'SharePointSiteStorageUsed(Byte)' -Sum).sum
if($sumofSharepointStageUsed){

    $sumofSharepointStageUsed = [math]::round($sumofSharepointStageUsed/1Gb, 2) 
    $topSharepointStageUsed= $GrpsAct | select * | Sort-Object { $_.'SharePointSiteStorageUsed(Byte)' -as [double] }  -Descending | select -First 10
    foreach($in in $topSharepointStageUsed)
    {
        $SharepointsiteUsed = [math]::round(($in.'SharePointSiteStorageUsed(Byte)')/1Mb,2)
        Write-Host 'topGrpsSharePointSiteStorageUsed#' $in.GroupDisplayName ~!~ $in.OwnerPrincipalName ~!~ $in.LastActivityDate ~!~ $in.GroupType ~!~ $SharepointsiteUsed

    }
}
Write-Host '***************************************************'

$sumofSharepointActfilesCnt= ($GrpsAct | select SharePointActiveFileCount | measure-object -property SharePointActiveFileCount -Sum).sum
if($sumofSharepointActfilesCnt){

    $topSharepointActfilesCnt= $GrpsAct | select * | Sort-Object { $_.SharePointActiveFileCount -as [double] } -Descending | select -First 10
    foreach($in in $topSharepointActfilesCnt)
    {

        Write-Host 'topGrpsSharePointActiveFileCount#' $in.GroupDisplayName ~!~ $in.OwnerPrincipalName ~!~ $in.LastActivityDate ~!~ $in.GroupType ~!~ $in.SharePointActiveFileCount

    }
}

Write-Host '***************************************************'

$sumofExcngRcvdEmailsCnt= ($GrpsAct | select ExchangeReceivedEmailCount | measure-object -property ExchangeReceivedEmailCount -Sum).sum
if($sumofExcngRcvdEmailsCnt){

    $topExcngRcvdEmailsCnt= $GrpsAct | select * | Sort-Object  { $_.ExchangeReceivedEmailCount -as [double] } -Descending | select -First 10
    foreach($in in $topExcngRcvdEmailsCnt)
    {

    Write-Host 'topGrpsExchangeReceivedEmailCount#' $in.GroupDisplayName ~!~ $in.OwnerPrincipalName ~!~ $in.LastActivityDate ~!~ $in.GroupType ~!~ $in.ExchangeReceivedEmailCount

    }
}

Write-Host '***************************************************'

$sumofYamerPstedMsgCnt= ($GrpsAct | select YammerPostedMessageCount | measure-object -property YammerPostedMessageCount -Sum).sum
if($sumofYamerPstedMsgCnt){

    $topYamerPstedMsgCnt= $GrpsAct | select * | Sort-Object { $_.YammerPostedMessageCount -as [double] } -Descending | select -First 10
    foreach($in in $topYamerPstedMsgCnt)
    {
        Write-Host 'topGrpsYammerPostedMessageCount#' $in.GroupDisplayName ~!~ $in.OwnerPrincipalName ~!~ $in.LastActivityDate ~!~ $in.GroupType ~!~ $in.YammerPostedMessageCount
    }
}

Write-Host '***************************************************'

$sumYamerReadMsgCnt= ($GrpsAct | select YammerReadMessageCount | measure-object -property YammerReadMessageCount -Sum).sum
if($sumYamerReadMsgCnt){

    $topYammerReadMsgCnt= $GrpsAct | select * | Sort-Object { $_.YammerReadMessageCount -as [double] } -Descending | select -First 10
    foreach($in in $topYammerReadMsgCnt)
    {
        Write-Host 'topGrpsYammerReadMessageCount#' $in.GroupDisplayName ~!~ $in.OwnerPrincipalName ~!~ $in.LastActivityDate ~!~ $in.GroupType ~!~ $in.YammerReadMessageCount
    }
}

Write-Host '***************************************************'

$sumYamerLikedMsgCnt= ($GrpsAct | select YammerLikedMessageCount | measure-object -property YammerLikedMessageCount -Sum).sum
if($sumYamerLikedMsgCnt){
 
    $topYamerLikedMsgCnt= $GrpsAct | select * | Sort-Object { $_.YammerLikedMessageCount -as [double] } -Descending | select -First 10
    foreach($in in $topYamerLikedMsgCnt)
    {
        Write-Host 'topGrpsYammerLikedMessageCount#' $in.GroupDisplayName ~!~ $in.OwnerPrincipalName ~!~ $in.LastActivityDate ~!~ $in.GroupType ~!~ $in.YammerLikedMessageCount
    }
}

Write-Host 'measures#' $sumofExMailBoxStorage ~ $sumofExMailBoxItemsCnt ~ $sumofSharepointTotlfilsCnt ~ $sumofSharepointStageUsed ~ $sumofSharepointActfilesCnt ~ $sumofExcngRcvdEmailsCnt ~ $sumofYamerPstedMsgCnt ~ $sumYamerReadMsgCnt ~ $sumYamerLikedMsgCnt

Write-Host '*************************Done**************************'






# SIG # Begin signature block
# MIIcdAYJKoZIhvcNAQcCoIIcZTCCHGECAQExCzAJBgUrDgMCGgUAMGkGCisGAQQB
# gjcCAQSgWzBZMDQGCisGAQQBgjcCAR4wJgIDAQAABBAfzDtgWUsITrck0sYpfvNR
# AgEAAgEAAgEAAgEAAgEAMCEwCQYFKw4DAhoFAAQUfudjds6VLidkXtbe3YE4E/kF
# 1WyggherMIIFMDCCBBigAwIBAgIQBAkYG1/Vu2Z1U0O1b5VQCDANBgkqhkiG9w0B
# AQsFADBlMQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYD
# VQQLExB3d3cuZGlnaWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVk
# IElEIFJvb3QgQ0EwHhcNMTMxMDIyMTIwMDAwWhcNMjgxMDIyMTIwMDAwWjByMQsw
# CQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cu
# ZGlnaWNlcnQuY29tMTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQg
# Q29kZSBTaWduaW5nIENBMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA
# +NOzHH8OEa9ndwfTCzFJGc/Q+0WZsTrbRPV/5aid2zLXcep2nQUut4/6kkPApfmJ
# 1DcZ17aq8JyGpdglrA55KDp+6dFn08b7KSfH03sjlOSRI5aQd4L5oYQjZhJUM1B0
# sSgmuyRpwsJS8hRniolF1C2ho+mILCCVrhxKhwjfDPXiTWAYvqrEsq5wMWYzcT6s
# cKKrzn/pfMuSoeU7MRzP6vIK5Fe7SrXpdOYr/mzLfnQ5Ng2Q7+S1TqSp6moKq4Tz
# rGdOtcT3jNEgJSPrCGQ+UpbB8g8S9MWOD8Gi6CxR93O8vYWxYoNzQYIH5DiLanMg
# 0A9kczyen6Yzqf0Z3yWT0QIDAQABo4IBzTCCAckwEgYDVR0TAQH/BAgwBgEB/wIB
# ADAOBgNVHQ8BAf8EBAMCAYYwEwYDVR0lBAwwCgYIKwYBBQUHAwMweQYIKwYBBQUH
# AQEEbTBrMCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wQwYI
# KwYBBQUHMAKGN2h0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFz
# c3VyZWRJRFJvb3RDQS5jcnQwgYEGA1UdHwR6MHgwOqA4oDaGNGh0dHA6Ly9jcmw0
# LmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJRFJvb3RDQS5jcmwwOqA4oDaG
# NGh0dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJRFJvb3RD
# QS5jcmwwTwYDVR0gBEgwRjA4BgpghkgBhv1sAAIEMCowKAYIKwYBBQUHAgEWHGh0
# dHBzOi8vd3d3LmRpZ2ljZXJ0LmNvbS9DUFMwCgYIYIZIAYb9bAMwHQYDVR0OBBYE
# FFrEuXsqCqOl6nEDwGD5LfZldQ5YMB8GA1UdIwQYMBaAFEXroq/0ksuCMS1Ri6en
# IZ3zbcgPMA0GCSqGSIb3DQEBCwUAA4IBAQA+7A1aJLPzItEVyCx8JSl2qB1dHC06
# GsTvMGHXfgtg/cM9D8Svi/3vKt8gVTew4fbRknUPUbRupY5a4l4kgU4QpO4/cY5j
# DhNLrddfRHnzNhQGivecRk5c/5CxGwcOkRX7uq+1UcKNJK4kxscnKqEpKBo6cSgC
# PC6Ro8AlEeKcFEehemhor5unXCBc2XGxDI+7qPjFEmifz0DLQESlE/DmZAwlCEIy
# sjaKJAL+L3J+HNdJRZboWR3p+nRka7LrZkPas7CM1ekN3fYBIM6ZMWM9CBoYs4Gb
# T8aTEAb8B4H6i9r5gkn3Ym6hU/oSlBiFLpKR6mhsRDKyZqHnGKSaZFHvMIIFNDCC
# BBygAwIBAgIQAuEYSxAWnqD3sU8D3BMzUjANBgkqhkiG9w0BAQsFADByMQswCQYD
# VQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGln
# aWNlcnQuY29tMTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQgQ29k
# ZSBTaWduaW5nIENBMB4XDTE4MDcxMDAwMDAwMFoXDTIxMDkxNTEyMDAwMFowcTEL
# MAkGA1UEBhMCVVMxEzARBgNVBAgTCk5ldyBKZXJzZXkxDzANBgNVBAcTBklzZWxp
# bjEdMBsGA1UEChMUZUcgSW5ub3ZhdGlvbnMsIEluYy4xHTAbBgNVBAMTFGVHIElu
# bm92YXRpb25zLCBJbmMuMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA
# oNt7XWB1y9xwtvCGO/XipXallOkZ3ScdXunWCONnBzryRdCj7C/WX9s1CU8KkjRP
# FjWW+BOXvvC4ZUqw0Ad2uJAXyBY2/lV9eaoTRFB6Kb2/tJzG3je7Vcu8MxGJlwzP
# QQrr6icEJeqAPFE7vmzThVbd9H1n5Zdmwx20WCFe2V9qyVYHt7/6GS7WB2CwwjT6
# iVmiKP8HZXgr3tHZeAEb7tdQqd5//9e+8Mp8anb8ZdNgC9PQjBmbrQ/wH3kV65gK
# L+5kbgRvIfsmYxXiU1IFkq4rSQ+tfsDtYqBhGfovef9Gt8ZTjx7S4fortxwR7tlz
# i+wLO5m8I9sm4I2ouyIOQQIDAQABo4IBxTCCAcEwHwYDVR0jBBgwFoAUWsS5eyoK
# o6XqcQPAYPkt9mV1DlgwHQYDVR0OBBYEFD3yRqdsw6UIddfMPwhUMv2AaGRAMA4G
# A1UdDwEB/wQEAwIHgDATBgNVHSUEDDAKBggrBgEFBQcDAzB3BgNVHR8EcDBuMDWg
# M6Axhi9odHRwOi8vY3JsMy5kaWdpY2VydC5jb20vc2hhMi1hc3N1cmVkLWNzLWcx
# LmNybDA1oDOgMYYvaHR0cDovL2NybDQuZGlnaWNlcnQuY29tL3NoYTItYXNzdXJl
# ZC1jcy1nMS5jcmwwTAYDVR0gBEUwQzA3BglghkgBhv1sAwEwKjAoBggrBgEFBQcC
# ARYcaHR0cHM6Ly93d3cuZGlnaWNlcnQuY29tL0NQUzAIBgZngQwBBAEwgYQGCCsG
# AQUFBwEBBHgwdjAkBggrBgEFBQcwAYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29t
# ME4GCCsGAQUFBzAChkJodHRwOi8vY2FjZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNl
# cnRTSEEyQXNzdXJlZElEQ29kZVNpZ25pbmdDQS5jcnQwDAYDVR0TAQH/BAIwADAN
# BgkqhkiG9w0BAQsFAAOCAQEAP1QnJ6TEczaeGxVokMinsKam1mJB+zDk4B9rfm31
# iaZe9OeNvR/UJAs+5b0gKBZF9NmTVdayAYV74vZU5IElRo59q6hbg/20Wu87UyoE
# Yjwrv2DxHgl3z80piuLllmoe79vEu/bYvreBamzZmHlyxRP0us2KRfEsLBH23y1o
# zBATLc3yBu+mCfDg9E1RfhpKyD1iMHkbC90To6bpOlP9Pd6R4WEAFROILgm2bofQ
# ZhN4UNKbJ1uLCvV2NiUbU7+YSC3NP9SdphaDBiOnUWiK8MjTIPZbhh3QjI5f342q
# cUiR4LGx/Z/6pq4w6YHWd8c1czexD7xVCom7ZafCOKFWyzCCBmowggVSoAMCAQIC
# EAMBmgI6/1ixa9bV6uYX8GYwDQYJKoZIhvcNAQEFBQAwYjELMAkGA1UEBhMCVVMx
# FTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNv
# bTEhMB8GA1UEAxMYRGlnaUNlcnQgQXNzdXJlZCBJRCBDQS0xMB4XDTE0MTAyMjAw
# MDAwMFoXDTI0MTAyMjAwMDAwMFowRzELMAkGA1UEBhMCVVMxETAPBgNVBAoTCERp
# Z2lDZXJ0MSUwIwYDVQQDExxEaWdpQ2VydCBUaW1lc3RhbXAgUmVzcG9uZGVyMIIB
# IjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAo2Rd/Hyz4II14OD2xirmSXU7
# zG7gU6mfH2RZ5nxrf2uMnVX4kuOe1VpjWwJJUNmDzm9m7t3LhelfpfnUh3SIRDsZ
# yeX1kZ/GFDmsJOqoSyyRicxeKPRktlC39RKzc5YKZ6O+YZ+u8/0SeHUOplsU/UUj
# joZEVX0YhgWMVYd5SEb3yg6Np95OX+Koti1ZAmGIYXIYaLm4fO7m5zQvMXeBMB+7
# NgGN7yfj95rwTDFkjePr+hmHqH7P7IwMNlt6wXq4eMfJBi5GEMiN6ARg27xzdPpO
# 2P6qQPGyznBGg+naQKFZOtkVCVeZVjCT88lhzNAIzGvsYkKRrALA76TwiRGPdwID
# AQABo4IDNTCCAzEwDgYDVR0PAQH/BAQDAgeAMAwGA1UdEwEB/wQCMAAwFgYDVR0l
# AQH/BAwwCgYIKwYBBQUHAwgwggG/BgNVHSAEggG2MIIBsjCCAaEGCWCGSAGG/WwH
# ATCCAZIwKAYIKwYBBQUHAgEWHGh0dHBzOi8vd3d3LmRpZ2ljZXJ0LmNvbS9DUFMw
# ggFkBggrBgEFBQcCAjCCAVYeggFSAEEAbgB5ACAAdQBzAGUAIABvAGYAIAB0AGgA
# aQBzACAAQwBlAHIAdABpAGYAaQBjAGEAdABlACAAYwBvAG4AcwB0AGkAdAB1AHQA
# ZQBzACAAYQBjAGMAZQBwAHQAYQBuAGMAZQAgAG8AZgAgAHQAaABlACAARABpAGcA
# aQBDAGUAcgB0ACAAQwBQAC8AQwBQAFMAIABhAG4AZAAgAHQAaABlACAAUgBlAGwA
# eQBpAG4AZwAgAFAAYQByAHQAeQAgAEEAZwByAGUAZQBtAGUAbgB0ACAAdwBoAGkA
# YwBoACAAbABpAG0AaQB0ACAAbABpAGEAYgBpAGwAaQB0AHkAIABhAG4AZAAgAGEA
# cgBlACAAaQBuAGMAbwByAHAAbwByAGEAdABlAGQAIABoAGUAcgBlAGkAbgAgAGIA
# eQAgAHIAZQBmAGUAcgBlAG4AYwBlAC4wCwYJYIZIAYb9bAMVMB8GA1UdIwQYMBaA
# FBUAEisTmLKZB+0e36K+Vw0rZwLNMB0GA1UdDgQWBBRhWk0ktkkynUoqeRqDS/Qe
# icHKfTB9BgNVHR8EdjB0MDigNqA0hjJodHRwOi8vY3JsMy5kaWdpY2VydC5jb20v
# RGlnaUNlcnRBc3N1cmVkSURDQS0xLmNybDA4oDagNIYyaHR0cDovL2NybDQuZGln
# aWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJlZElEQ0EtMS5jcmwwdwYIKwYBBQUHAQEE
# azBpMCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wQQYIKwYB
# BQUHMAKGNWh0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3Vy
# ZWRJRENBLTEuY3J0MA0GCSqGSIb3DQEBBQUAA4IBAQCdJX4bM02yJoFcm4bOIyAP
# gIfliP//sdRqLDHtOhcZcRfNqRu8WhY5AJ3jbITkWkD73gYBjDf6m7GdJH7+IKRX
# rVu3mrBgJuppVyFdNC8fcbCDlBkFazWQEKB7l8f2P+fiEUGmvWLZ8Cc9OB0obzpS
# CfDscGLTYkuw4HOmksDTjjHYL+NtFxMG7uQDthSr849Dp3GdId0UyhVdkkHa+Q+B
# 0Zl0DSbEDn8btfWg8cZ3BigV6diT5VUW8LsKqxzbXEgnZsijiwoc5ZXarsQuWaBh
# 3drzbaJh6YoLbewSGL33VVRAA5Ira8JRwgpIr7DUbuD0FAo6G+OPPcqvao173NhE
# MIIGzTCCBbWgAwIBAgIQBv35A5YDreoACus/J7u6GzANBgkqhkiG9w0BAQUFADBl
# MQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3
# d3cuZGlnaWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVkIElEIFJv
# b3QgQ0EwHhcNMDYxMTEwMDAwMDAwWhcNMjExMTEwMDAwMDAwWjBiMQswCQYDVQQG
# EwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNl
# cnQuY29tMSEwHwYDVQQDExhEaWdpQ2VydCBBc3N1cmVkIElEIENBLTEwggEiMA0G
# CSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDogi2Z+crCQpWlgHNAcNKeVlRcqcTS
# QQaPyTP8TUWRXIGf7Syc+BZZ3561JBXCmLm0d0ncicQK2q/LXmvtrbBxMevPOkAM
# Rk2T7It6NggDqww0/hhJgv7HxzFIgHweog+SDlDJxofrNj/YMMP/pvf7os1vcyP+
# rFYFkPAyIRaJxnCI+QWXfaPHQ90C6Ds97bFBo+0/vtuVSMTuHrPyvAwrmdDGXRJC
# geGDboJzPyZLFJCuWWYKxI2+0s4Grq2Eb0iEm09AufFM8q+Y+/bOQF1c9qjxL6/s
# iSLyaxhlscFzrdfx2M8eCnRcQrhofrfVdwonVnwPYqQ/MhRglf0HBKIJAgMBAAGj
# ggN6MIIDdjAOBgNVHQ8BAf8EBAMCAYYwOwYDVR0lBDQwMgYIKwYBBQUHAwEGCCsG
# AQUFBwMCBggrBgEFBQcDAwYIKwYBBQUHAwQGCCsGAQUFBwMIMIIB0gYDVR0gBIIB
# yTCCAcUwggG0BgpghkgBhv1sAAEEMIIBpDA6BggrBgEFBQcCARYuaHR0cDovL3d3
# dy5kaWdpY2VydC5jb20vc3NsLWNwcy1yZXBvc2l0b3J5Lmh0bTCCAWQGCCsGAQUF
# BwICMIIBVh6CAVIAQQBuAHkAIAB1AHMAZQAgAG8AZgAgAHQAaABpAHMAIABDAGUA
# cgB0AGkAZgBpAGMAYQB0AGUAIABjAG8AbgBzAHQAaQB0AHUAdABlAHMAIABhAGMA
# YwBlAHAAdABhAG4AYwBlACAAbwBmACAAdABoAGUAIABEAGkAZwBpAEMAZQByAHQA
# IABDAFAALwBDAFAAUwAgAGEAbgBkACAAdABoAGUAIABSAGUAbAB5AGkAbgBnACAA
# UABhAHIAdAB5ACAAQQBnAHIAZQBlAG0AZQBuAHQAIAB3AGgAaQBjAGgAIABsAGkA
# bQBpAHQAIABsAGkAYQBiAGkAbABpAHQAeQAgAGEAbgBkACAAYQByAGUAIABpAG4A
# YwBvAHIAcABvAHIAYQB0AGUAZAAgAGgAZQByAGUAaQBuACAAYgB5ACAAcgBlAGYA
# ZQByAGUAbgBjAGUALjALBglghkgBhv1sAxUwEgYDVR0TAQH/BAgwBgEB/wIBADB5
# BggrBgEFBQcBAQRtMGswJAYIKwYBBQUHMAGGGGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0
# LmNvbTBDBggrBgEFBQcwAoY3aHR0cDovL2NhY2VydHMuZGlnaWNlcnQuY29tL0Rp
# Z2lDZXJ0QXNzdXJlZElEUm9vdENBLmNydDCBgQYDVR0fBHoweDA6oDigNoY0aHR0
# cDovL2NybDMuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJlZElEUm9vdENBLmNy
# bDA6oDigNoY0aHR0cDovL2NybDQuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJl
# ZElEUm9vdENBLmNybDAdBgNVHQ4EFgQUFQASKxOYspkH7R7for5XDStnAs0wHwYD
# VR0jBBgwFoAUReuir/SSy4IxLVGLp6chnfNtyA8wDQYJKoZIhvcNAQEFBQADggEB
# AEZQPsm3KCSnOB22WymvUs9S6TFHq1Zce9UNC0Gz7+x1H3Q48rJcYaKclcNQ5IK5
# I9G6OoZyrTh4rHVdFxc0ckeFlFbR67s2hHfMJKXzBBlVqefj56tizfuLLZDCwNK1
# lL1eT7EF0g49GqkUW6aGMWKoqDPkmzmnxPXOHXh2lCVz5Cqrz5x2S+1fwksW5Etw
# TACJHvzFebxMElf+X+EevAJdqP77BzhPDcZdkbkPZ0XN1oPt55INjbFpjE/7WeAj
# D9KqrgB87pxCDs+R1ye3Fu4Pw718CqDuLAhVhSK46xgaTfwqIa1JMYNHlXdx3LEb
# S0scEJx3FMGdTy9alQgpECYxggQzMIIELwIBATCBhjByMQswCQYDVQQGEwJVUzEV
# MBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNlcnQuY29t
# MTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQgQ29kZSBTaWduaW5n
# IENBAhAC4RhLEBaeoPexTwPcEzNSMAkGBSsOAwIaBQCgcDAQBgorBgEEAYI3AgEM
# MQIwADAZBgkqhkiG9w0BCQMxDAYKKwYBBAGCNwIBBDAcBgorBgEEAYI3AgELMQ4w
# DAYKKwYBBAGCNwIBFTAjBgkqhkiG9w0BCQQxFgQUGS58zG5ie/HSe1jt9qg/1rB6
# ClUwDQYJKoZIhvcNAQEBBQAEggEAC047ZF4OFU0ry0S+l8wJPljOYW06v1vK91rM
# ARl1hDOh9U5B5v9xdG/jw4VlvWEH3ytHxGPchAsCbdJyUHvK2s0jVivwwyuS8Ja2
# +ZibHDFnWL44DEuEv9j3qO6SJIhgjlKCHxJWbTib31SDvAq8WAKfTTYxP6/QiZ8M
# QKKTN54v73P9RuW0nzLVrQQLk+vaYZXSAH/u8TlCN67rd1dS+zV3lJksI7oiyXep
# 62/Lw1QbhxiQQx+n9g6DK/0sMSin+mTziICE8PIad6M7kw9clRYxk5w8Xile+sqj
# EEoOEmKAZJm8csIJLcLeaCEePQPO80M5ImRuPapNcfaafxccvKGCAg8wggILBgkq
# hkiG9w0BCQYxggH8MIIB+AIBATB2MGIxCzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxE
# aWdpQ2VydCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5jb20xITAfBgNVBAMT
# GERpZ2lDZXJ0IEFzc3VyZWQgSUQgQ0EtMQIQAwGaAjr/WLFr1tXq5hfwZjAJBgUr
# DgMCGgUAoF0wGAYJKoZIhvcNAQkDMQsGCSqGSIb3DQEHATAcBgkqhkiG9w0BCQUx
# DxcNMjAwNzIzMDIwNDA4WjAjBgkqhkiG9w0BCQQxFgQUAspkrH/NhCm5c64tovRJ
# eabu1howDQYJKoZIhvcNAQEBBQAEggEAW85EbK7H5qINjXY9CttEUrcNaN7+S1e3
# EKd1gAzHO5qcWOlD4v7A46ZHTVJc2qbWa67/XCDkVRNECBu11z22kR77n6xyw7R0
# E4dEEuZDxDkUfiVtiN9ZbR4rPWXK7343MldD2AYewXkfVkpth53ivIm16Q2zUzWB
# NPAQn/X+HUIQFXM8G8XWHwgC5W54qauLMlKC5QEEhZe0Pcn+dgDAZajF8ijufdBL
# YCfl5khB6htkpC/U310qEhGX1hDxyvvGdwKamVKsGTL5R4nYSc6imNQUUea/TZNi
# iAdZVf5cMQhIn93rPpYdBXrMb25b4ndZl6V3ToJfOdqqg0WvjyFqSA==
# SIG # End signature block
