﻿[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$egInstallpath=Get-ChildItem Env:EGURKHA_INSTALL_DIR |Select Value
$egurkhaPath=$egInstallpath.Value.ToString()
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
Import-Module $egEncryPath,$egDatnKy
clear 

$TestInputs=$args

$reportingname='EXO\'+$TestInputs[0]
try{
    $readfiles=Eg-ReadFile -ComntRptPath $reportingname -FileName "mailbox" -keyFileName "kmailbox" -EgPath $egurkhaPath
    $datafile=$readfiles[1] -replace (".csv",".dat") 
    $csvfile=Unprotect-File $datafile -Algorithm AES -KeyAsPlainText $readfiles[0]	
    $MailboxesDetails= import-csv $csvfile
    Remove-Item $csvfile
    Eg-DeleteFiles -FilePath $readfiles[2] -Pattern 'mailbox' -InputFile $readfiles[3]
    Eg-DeleteFiles -FilePath $readfiles[2] -Pattern 'kmailbox' -InputFile $readfiles[4]
    Write-Host 'ReadFile:'$readfiles[3]
    }
    catch [System.Management.Automation.RuntimeException] {
        Write-Error -Message "File not found. The $reportingname location does not contain mailbox files."
    }
    catch{
        $errmsg=$_.Exception.Message
        $errstack=$_.Exception.StackTrace
        Write-Error -Message $errmsg
    }

Try{
    $readArr =Eg-ReadFile -ComntRptPath $reportingname -FileName "O365msolUsr" -keyFileName "kO365msolUsr" -EgPath $egurkhaPath
    $unProtctMUsr =$readArr[1] -replace (".csv",".dat") 
    $musrPath =Unprotect-File $unProtctMUsr -Algorithm AES -KeyAsPlainText $readArr[0]	
    $msoluserS = import-csv $musrPath
    Remove-Item $musrPath
    Write-Host 'ReadFile:'$readArr[3]
    }Catch{}
    
    Eg-DeleteFiles -FilePath $readArr[2] -Pattern 'O365msolUsr' -InputFile $readArr[3]
    Eg-DeleteFiles -FilePath $readArr[2] -Pattern 'kO365msolUsr' -InputFile $readArr[4]

	$Datacenter = @{}
	$Datacenter["AF"]=@("","Afghanistan")
    $Datacenter["AL"]=@("","Albania")
    $Datacenter["DZ"]=@("","Algeria")
    $Datacenter["AS"]=@("","American Samoa")
    $Datacenter["AD"]=@("","Andorra")
    $Datacenter["AO"]=@("","Angola")
    $Datacenter["AI"]=@("","Anguilla")
    $Datacenter["AQ"]=@("","Antarctica")
    $Datacenter["AG"]=@("","Antigua and Barbuda")
    $Datacenter["AR"]=@("","Argentina")
    $Datacenter["AM"]=@("","Amsterdam, Netherlands")
    $Datacenter["AW"]=@("","Aruba")
    $Datacenter["AU"]=@("","Australia")
    $Datacenter["AT"]=@("","Austria")
    $Datacenter["AZ"]=@("","Azerbaijan")
    $Datacenter["BS"]=@("","Bahamas")
    $Datacenter["BH"]=@("","Bahrain")
    $Datacenter["BD"]=@("","Bangladesh")
    $Datacenter["BB"]=@("","Barbados")
    $Datacenter["BY"]=@("","Belarus")
    $Datacenter["BE"]=@("","Belgium")
    $Datacenter["BZ"]=@("","Belize")
    $Datacenter["BJ"]=@("","Benin")
    $Datacenter["BM"]=@("","Bermuda")
    $Datacenter["BT"]=@("","Bhutan")
    $Datacenter["BO"]=@("","Bolivia")
    $Datacenter["BQ"]=@("","Bonaire")
    $Datacenter["BA"]=@("","Bosnia and Herzegovina")
    $Datacenter["BW"]=@("","Botswana")
    $Datacenter["BV"]=@("","Bouvet Island")
    $Datacenter["BR"]=@("","Brazil")
    $Datacenter["IO"]=@("","British Indian Ocean Territory")
    $Datacenter["BN"]=@("","Brunei Darussalam")
    $Datacenter["BG"]=@("","Bulgaria")
    $Datacenter["BF"]=@("","Burkina Faso")
    $Datacenter["BI"]=@("","Burundi")
    $Datacenter["KH"]=@("","Cambodia")
    $Datacenter["CM"]=@("","Cameroon")
    $Datacenter["CA"]=@("","Canada")
    $Datacenter["CV"]=@("","Cape Verde")
    $Datacenter["KY"]=@("","Cayman Islands")
    $Datacenter["CF"]=@("","Central African Republic")
    $Datacenter["TD"]=@("","Chad")
    $Datacenter["CL"]=@("","Chile")
    $Datacenter["CN"]=@("","China")
    $Datacenter["CX"]=@("","Christmas Island")
    $Datacenter["CC"]=@("","Cocos (Keeling) Islands")
    $Datacenter["CO"]=@("","Colombia")
    $Datacenter["KM"]=@("","Comoros")
    $Datacenter["CG"]=@("","Congo")
    $Datacenter["CD"]=@("","Democratic Republic of the Congo")
    $Datacenter["CK"]=@("","Cook Islands")
    $Datacenter["CR"]=@("","Costa Rica")
    $Datacenter["HR"]=@("","Croatia")
    $Datacenter["CU"]=@("","Cuba")
    $Datacenter["CW"]=@("","Curacao")
    $Datacenter["CY"]=@("","Cyprus")
    $Datacenter["CZ"]=@("","Czech Republic")
    $Datacenter["CI"]=@("","Cote d'Ivoire")
    $Datacenter["DK"]=@("","Denmark")
    $Datacenter["DJ"]=@("","Djibouti")
    $Datacenter["DM"]=@("","Dominica")
    $Datacenter["DO"]=@("","Dominican Republic")
    $Datacenter["EC"]=@("","Ecuador")
    $Datacenter["EG"]=@("","Egypt")
    $Datacenter["SV"]=@("","El Salvador")
    $Datacenter["GQ"]=@("","Equatorial Guinea")
    $Datacenter["ER"]=@("","Eritrea")
    $Datacenter["EE"]=@("","Estonia")
    $Datacenter["ET"]=@("","Ethiopia")
    $Datacenter["FK"]=@("","Falkland Islands (Malvinas)")
    $Datacenter["FO"]=@("","Faroe Islands")
    $Datacenter["FJ"]=@("","Fiji")
    $Datacenter["FI"]=@("","Finland")
    $Datacenter["FR"]=@("","France")
    $Datacenter["GF"]=@("","French Guiana")
    $Datacenter["PF"]=@("","French Polynesia")
    $Datacenter["TF"]=@("","French Southern Territories")
    $Datacenter["GA"]=@("","Gabon")
    $Datacenter["GM"]=@("","Gambia")
    $Datacenter["GE"]=@("","Georgia")
    $Datacenter["DE"]=@("","Germany")
    $Datacenter["GH"]=@("","Ghana")
    $Datacenter["GI"]=@("","Gibraltar")
    $Datacenter["GR"]=@("","Greece")
    $Datacenter["GL"]=@("","Greenland")
    $Datacenter["GD"]=@("","Grenada")
    $Datacenter["GP"]=@("","Guadeloupe")
    $Datacenter["GU"]=@("","Guam")
    $Datacenter["GT"]=@("","Guatemala")
    $Datacenter["GG"]=@("","Guernsey")
    $Datacenter["GN"]=@("","Guinea")
    $Datacenter["GW"]=@("","Guinea-Bissau")
    $Datacenter["GY"]=@("","Guyana")
    $Datacenter["HT"]=@("","Haiti")
    $Datacenter["HM"]=@("","Heard Island and McDonald Islands")
    $Datacenter["VA"]=@("","Holy See (Vatican City State)")
    $Datacenter["HN"]=@("","Honduras")
    $Datacenter["HK"]=@("","Hong Kong")
    $Datacenter["HU"]=@("","Hungary")
    $Datacenter["IS"]=@("","Iceland")
    $Datacenter["IN"]=@("","India")
    $Datacenter["ID"]=@("","Indonesia")
    $Datacenter["IR"]=@("","Islamic Republic of Iran")
    $Datacenter["IQ"]=@("","Iraq")
    $Datacenter["IE"]=@("","Ireland")
    $Datacenter["IM"]=@("","Isle of Man")
    $Datacenter["IL"]=@("","Israel")
    $Datacenter["IT"]=@("","Italy")
    $Datacenter["JM"]=@("","Jamaica")
    $Datacenter["JP"]=@("","Japan")
    $Datacenter["JE"]=@("","Jersey")
    $Datacenter["JO"]=@("","Jordan")
    $Datacenter["KZ"]=@("","Kazakhstan")
    $Datacenter["KE"]=@("","Kenya")
    $Datacenter["KI"]=@("","Kiribati")
    $Datacenter["KP"]=@("","Democratic People's Republic of Korea")
    $Datacenter["KR"]=@("","Republic of Korea")
    $Datacenter["KW"]=@("","Kuwait")
    $Datacenter["KG"]=@("","Kyrgyzstan")
    $Datacenter["LA"]=@("","Lao People's Democratic Republic")
    $Datacenter["LV"]=@("","Latvia")
    $Datacenter["LB"]=@("","Lebanon")
    $Datacenter["LS"]=@("","Lesotho")
    $Datacenter["LR"]=@("","Liberia")
    $Datacenter["LY"]=@("","Libya")
    $Datacenter["LI"]=@("","Liechtenstein")
    $Datacenter["LT"]=@("","Lithuania")
    $Datacenter["LU"]=@("","Luxembourg")
    $Datacenter["MO"]=@("","Macao")
    $Datacenter["MK"]=@("","The Former Yugoslav Republic of Macedonia")
    $Datacenter["MG"]=@("","Madagascar")
    $Datacenter["MW"]=@("","Malawi")
    $Datacenter["MY"]=@("","Malaysia")
    $Datacenter["MV"]=@("","Maldives")
    $Datacenter["ML"]=@("","Mali")
    $Datacenter["MT"]=@("","Malta")
    $Datacenter["MH"]=@("","Marshall Islands")
    $Datacenter["MQ"]=@("","Martinique")
    $Datacenter["MR"]=@("","Mauritania")
    $Datacenter["MU"]=@("","Mauritius")
    $Datacenter["YT"]=@("","Mayotte")
    $Datacenter["MX"]=@("","Mexico")
    $Datacenter["FM"]=@("","Federated States of Micronesia")
    $Datacenter["MD"]=@("","Republic of Moldova")
    $Datacenter["MC"]=@("","Monaco")
    $Datacenter["MN"]=@("","Mongolia")
    $Datacenter["ME"]=@("","Montenegro")
    $Datacenter["MS"]=@("","Montserrat")
    $Datacenter["MA"]=@("","Morocco")
    $Datacenter["MZ"]=@("","Mozambique")
    $Datacenter["MM"]=@("","Myanmar")
    $Datacenter["NA"]=@("","Namibia")
    $Datacenter["NR"]=@("","Nauru")
    $Datacenter["NP"]=@("","Nepal")
    $Datacenter["NL"]=@("","Netherlands")
    $Datacenter["NC"]=@("","New Caledonia")
    $Datacenter["NZ"]=@("","New Zealand")
    $Datacenter["NI"]=@("","Nicaragua")
    $Datacenter["NE"]=@("","Niger")
    $Datacenter["NG"]=@("","Nigeria")
    $Datacenter["NU"]=@("","Niue")
    $Datacenter["NF"]=@("","Norfolk Island")
    $Datacenter["MP"]=@("","Northern Mariana Islands")
    $Datacenter["NO"]=@("","Norway")
    $Datacenter["OM"]=@("","Oman")
    $Datacenter["PK"]=@("","Pakistan")
    $Datacenter["PW"]=@("","Palau")
    $Datacenter["PS"]=@("","State of Palestine")
    $Datacenter["PA"]=@("","Panama")
    $Datacenter["PG"]=@("","Papua New Guinea")
    $Datacenter["PY"]=@("","Paraguay")
    $Datacenter["PE"]=@("","Peru")
    $Datacenter["PH"]=@("","Philippines")
    $Datacenter["PN"]=@("","Pitcairn")
    $Datacenter["PL"]=@("","Poland")
    $Datacenter["PT"]=@("","Portugal")
    $Datacenter["PR"]=@("","Puerto Rico")
    $Datacenter["QA"]=@("","Qatar")
    $Datacenter["RO"]=@("","Romania")
    $Datacenter["RU"]=@("","Russian Federation")
    $Datacenter["RW"]=@("","Rwanda")
    $Datacenter["RE"]=@("","Reunion")
    $Datacenter["BL"]=@("","Saint Barthelemy")
    $Datacenter["SH"]=@("","Saint Helena")
    $Datacenter["KN"]=@("","Saint Kitts and Nevis")
    $Datacenter["LC"]=@("","Saint Lucia")
    $Datacenter["MF"]=@("","Saint Martin (French part)")
    $Datacenter["PM"]=@("","Saint Pierre and Miquelon")
    $Datacenter["VC"]=@("","Saint Vincent and the Grenadines")
    $Datacenter["WS"]=@("","Samoa")
    $Datacenter["SM"]=@("","San Marino")
    $Datacenter["ST"]=@("","Sao Tome and Principe")
    $Datacenter["SA"]=@("","Saudi Arabia")
    $Datacenter["SN"]=@("","Senegal")
    $Datacenter["RS"]=@("","Serbia")
    $Datacenter["SC"]=@("","Seychelles")
    $Datacenter["SL"]=@("","Sierra Leone")
    $Datacenter["SG"]=@("","Singapore")
    $Datacenter["SX"]=@("","Sint Maarten (Dutch part)")
    $Datacenter["SK"]=@("","Slovakia")
    $Datacenter["SI"]=@("","Slovenia")
    $Datacenter["SB"]=@("","Solomon Islands")
    $Datacenter["SO"]=@("","Somalia")
    $Datacenter["ZA"]=@("","South Africa")
    $Datacenter["GS"]=@("","South Georgia and the South Sandwich Islands")
    $Datacenter["SS"]=@("","South Sudan")
    $Datacenter["ES"]=@("","Spain")
    $Datacenter["LK"]=@("","Sri Lanka")
    $Datacenter["SD"]=@("","Sudan")
    $Datacenter["SR"]=@("","Suriname")
    $Datacenter["SJ"]=@("","Svalbard and Jan Mayen")
    $Datacenter["SZ"]=@("","Swaziland")
    $Datacenter["SE"]=@("","Sweden")
    $Datacenter["CH"]=@("","Switzerland")
    $Datacenter["SY"]=@("","Syrian Arab Republic")
    $Datacenter["TW"]=@("","Taiwan")
    $Datacenter["TJ"]=@("","Tajikistan")
    $Datacenter["TZ"]=@("","United Republic of Tanzania")
    $Datacenter["TH"]=@("","Thailand")
    $Datacenter["TL"]=@("","Timor-Leste")
    $Datacenter["TG"]=@("","Togo")
    $Datacenter["TK"]=@("","Tokelau")
    $Datacenter["TO"]=@("","Tonga")
    $Datacenter["TT"]=@("","Trinidad and Tobago")
    $Datacenter["TN"]=@("","Tunisia")
    $Datacenter["TR"]=@("","Turkey")
    $Datacenter["TM"]=@("","Turkmenistan")
    $Datacenter["TC"]=@("","Turks and Caicos Islands")
    $Datacenter["TV"]=@("","Tuvalu")
    $Datacenter["UG"]=@("","Uganda")
    $Datacenter["UA"]=@("","Ukraine")
    $Datacenter["AE"]=@("","United Arab Emirates")
    $Datacenter["GB"]=@("","United Kingdom")
    $Datacenter["US"]=@("","United States")
    $Datacenter["UM"]=@("","United States Minor Outlying Islands")
    $Datacenter["UY"]=@("","Uruguay")
    $Datacenter["UZ"]=@("","Uzbekistan")
    $Datacenter["VU"]=@("","Vanuatu")
    $Datacenter["VE"]=@("","Venezuela")
    $Datacenter["VN"]=@("","Viet Nam")
    $Datacenter["VG"]=@("","British Virgin Islands")
    $Datacenter["VI"]=@("","Vienna, Austria")
    $Datacenter["WF"]=@("","Wallis and Futuna")
    $Datacenter["EH"]=@("","Western Sahara")
    $Datacenter["YE"]=@("","Yemen")
    $Datacenter["ZM"]=@("","Zambia")
    $Datacenter["ZW"]=@("","Zimbabwe")
    $Datacenter["CP"]=@("","Brazil")
    $Datacenter["KA"]=@("","Japan")
    $Datacenter["OS"]=@("","Japan")
    $Datacenter["TY"]=@("","Japan")
    $Datacenter["DB"]=@("","Dublin, Ireland")
    $Datacenter["HE"]=@("","Finland")
    $Datacenter["KL"]=@("","Kuala Lumpur, Malaysia")
    $Datacenter["YQ"]=@("","Quebec City, Canada")
    $Datacenter["LO"]=@("","London, England")
	$Mailboxes = $MailboxesDetails | Where-Object {$_.RecipientTypeDetails -ne "DiscoveryMailbox"}
	#$ServerCount = ($Mailboxes | Group-Object {$_.ServerName}).count
	#$DatabaseCount = ($Mailboxes | Group-Object {$_.Database}).count
	$Mailboxes = $Mailboxes | Group-Object {$_.ServerName.SubString(0,2)} | Select @{Name="Datacenter";Expression={$_.Name}}, Count

	$Locations=@()
    $MailLocationsCount=0
	$LocationsConsolCount=0
	$usersLocationsCount=0
	
	# Not pretty error handling but allows counts to add properly when a datacenter location could not be identified from the table
	$E = $ErrorActionPreference
	$ErrorActionPreference = "SilentlyContinue"
	if($Mailboxes -ne $null -and $Mailboxes -ne ''){
        
		ForEach ($Mailbox in $Mailboxes) {
		  $Object = New-Object -TypeName PSObject
		  if($Datacenter[$Mailbox.Datacenter] -eq $null){
			$Datacenter[$Mailbox.Datacenter]=@("Unknown","Unknown")
		  }
		  $Object | Add-Member -Name 'Datacenter' -MemberType NoteProperty -Value $Mailbox.Datacenter
		  $Object | Add-Member -Name 'Region' -MemberType NoteProperty -Value $Datacenter[$Mailbox.Datacenter][0]
		  $Object | Add-Member -Name 'Location' -MemberType NoteProperty -Value $Datacenter[$Mailbox.Datacenter][1]
		  $Object | Add-Member -Name 'Count' -MemberType NoteProperty -Value $Mailbox.Count
		  $Locations += $Object
		}

		$ErrorActionPreference = $E

		$TotalMailboxes = ($Locations | Measure-Object Count -Sum).sum

		if($TotalMailboxes -eq $null ){
		  $TotalMailboxes=0
		}

		$LocationsConsolidated = $Locations | Group-Object Location | ForEach {
		      New-Object PSObject -Property @{
		      Location = $_.Name
		      Mailboxes = ("{0,9}" -f ($_.Group | Measure-Object Count -Sum).Sum)
		      }
		} | Sort-Object Count -Descending


		$ddpairs=$LocationsConsolidated | Select Location, Mailboxes
		foreach($ddline in $ddpairs){
			$LocationsConsolCount++    
			Write-Host '#DD' $ddline.Location '~!~'$ddline.Mailboxes.Trim()
		}
        $MailLocationsCount=$Locations.Count
	}
	else{
		$LocationsConsolCount = '-5'
		$MailLocationsCount= '-5'
	}
    $msoluserLocations = @()
    $msoluserS=$msoluserS | Where {$_.Userprincipalname -notlike '*#EXT#*'}

    ForEach ($msoluser in $msoluserS) {
     if($msoluser.UsageLocation -eq '' -or $Datacenter[$msoluser.UsageLocation] -eq $null){
        $Datacenter[$msoluser.UsageLocation]=@("Unknown","Unknown")
     }
	  $MsolObject = New-Object -TypeName PSObject
	  $MsolObject | Add-Member -Name 'UsageLocation' -MemberType NoteProperty -Value $Datacenter[$msoluser.UsageLocation][1]
	  $MsolObject | Add-Member -Name 'Count' -MemberType NoteProperty -Value 1
	  $msoluserLocations += $MsolObject
	}

	$usersLocationsConsolidated = $msoluserLocations | Group-Object UsageLocation | ForEach {
	      New-Object PSObject -Property @{
	      Location = $_.Name
	      Unique_Count = ("{0,9}" -f ($_.Group | Measure-Object Count -Sum).Sum)
	      }
	} | Sort-Object Unique_Count -Descending

	foreach($ddline in $usersLocationsConsolidated){
		$usersLocationsCount++    
		Write-Host '#UserLocationDD' $ddline.Location '~!~'$ddline.Unique_Count.Trim()
	}

    Write-Host '#Measure ' $MailLocationsCount '~' $LocationsConsolCount '~' $usersLocationsCount
# SIG # Begin signature block
# MIIcdAYJKoZIhvcNAQcCoIIcZTCCHGECAQExCzAJBgUrDgMCGgUAMGkGCisGAQQB
# gjcCAQSgWzBZMDQGCisGAQQBgjcCAR4wJgIDAQAABBAfzDtgWUsITrck0sYpfvNR
# AgEAAgEAAgEAAgEAAgEAMCEwCQYFKw4DAhoFAAQU3L2GvC03vT80FDVH+Sj6/qgb
# imqggherMIIFMDCCBBigAwIBAgIQBAkYG1/Vu2Z1U0O1b5VQCDANBgkqhkiG9w0B
# AQsFADBlMQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYD
# VQQLExB3d3cuZGlnaWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVk
# IElEIFJvb3QgQ0EwHhcNMTMxMDIyMTIwMDAwWhcNMjgxMDIyMTIwMDAwWjByMQsw
# CQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cu
# ZGlnaWNlcnQuY29tMTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQg
# Q29kZSBTaWduaW5nIENBMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA
# +NOzHH8OEa9ndwfTCzFJGc/Q+0WZsTrbRPV/5aid2zLXcep2nQUut4/6kkPApfmJ
# 1DcZ17aq8JyGpdglrA55KDp+6dFn08b7KSfH03sjlOSRI5aQd4L5oYQjZhJUM1B0
# sSgmuyRpwsJS8hRniolF1C2ho+mILCCVrhxKhwjfDPXiTWAYvqrEsq5wMWYzcT6s
# cKKrzn/pfMuSoeU7MRzP6vIK5Fe7SrXpdOYr/mzLfnQ5Ng2Q7+S1TqSp6moKq4Tz
# rGdOtcT3jNEgJSPrCGQ+UpbB8g8S9MWOD8Gi6CxR93O8vYWxYoNzQYIH5DiLanMg
# 0A9kczyen6Yzqf0Z3yWT0QIDAQABo4IBzTCCAckwEgYDVR0TAQH/BAgwBgEB/wIB
# ADAOBgNVHQ8BAf8EBAMCAYYwEwYDVR0lBAwwCgYIKwYBBQUHAwMweQYIKwYBBQUH
# AQEEbTBrMCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wQwYI
# KwYBBQUHMAKGN2h0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFz
# c3VyZWRJRFJvb3RDQS5jcnQwgYEGA1UdHwR6MHgwOqA4oDaGNGh0dHA6Ly9jcmw0
# LmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJRFJvb3RDQS5jcmwwOqA4oDaG
# NGh0dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJRFJvb3RD
# QS5jcmwwTwYDVR0gBEgwRjA4BgpghkgBhv1sAAIEMCowKAYIKwYBBQUHAgEWHGh0
# dHBzOi8vd3d3LmRpZ2ljZXJ0LmNvbS9DUFMwCgYIYIZIAYb9bAMwHQYDVR0OBBYE
# FFrEuXsqCqOl6nEDwGD5LfZldQ5YMB8GA1UdIwQYMBaAFEXroq/0ksuCMS1Ri6en
# IZ3zbcgPMA0GCSqGSIb3DQEBCwUAA4IBAQA+7A1aJLPzItEVyCx8JSl2qB1dHC06
# GsTvMGHXfgtg/cM9D8Svi/3vKt8gVTew4fbRknUPUbRupY5a4l4kgU4QpO4/cY5j
# DhNLrddfRHnzNhQGivecRk5c/5CxGwcOkRX7uq+1UcKNJK4kxscnKqEpKBo6cSgC
# PC6Ro8AlEeKcFEehemhor5unXCBc2XGxDI+7qPjFEmifz0DLQESlE/DmZAwlCEIy
# sjaKJAL+L3J+HNdJRZboWR3p+nRka7LrZkPas7CM1ekN3fYBIM6ZMWM9CBoYs4Gb
# T8aTEAb8B4H6i9r5gkn3Ym6hU/oSlBiFLpKR6mhsRDKyZqHnGKSaZFHvMIIFNDCC
# BBygAwIBAgIQAuEYSxAWnqD3sU8D3BMzUjANBgkqhkiG9w0BAQsFADByMQswCQYD
# VQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGln
# aWNlcnQuY29tMTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQgQ29k
# ZSBTaWduaW5nIENBMB4XDTE4MDcxMDAwMDAwMFoXDTIxMDkxNTEyMDAwMFowcTEL
# MAkGA1UEBhMCVVMxEzARBgNVBAgTCk5ldyBKZXJzZXkxDzANBgNVBAcTBklzZWxp
# bjEdMBsGA1UEChMUZUcgSW5ub3ZhdGlvbnMsIEluYy4xHTAbBgNVBAMTFGVHIElu
# bm92YXRpb25zLCBJbmMuMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA
# oNt7XWB1y9xwtvCGO/XipXallOkZ3ScdXunWCONnBzryRdCj7C/WX9s1CU8KkjRP
# FjWW+BOXvvC4ZUqw0Ad2uJAXyBY2/lV9eaoTRFB6Kb2/tJzG3je7Vcu8MxGJlwzP
# QQrr6icEJeqAPFE7vmzThVbd9H1n5Zdmwx20WCFe2V9qyVYHt7/6GS7WB2CwwjT6
# iVmiKP8HZXgr3tHZeAEb7tdQqd5//9e+8Mp8anb8ZdNgC9PQjBmbrQ/wH3kV65gK
# L+5kbgRvIfsmYxXiU1IFkq4rSQ+tfsDtYqBhGfovef9Gt8ZTjx7S4fortxwR7tlz
# i+wLO5m8I9sm4I2ouyIOQQIDAQABo4IBxTCCAcEwHwYDVR0jBBgwFoAUWsS5eyoK
# o6XqcQPAYPkt9mV1DlgwHQYDVR0OBBYEFD3yRqdsw6UIddfMPwhUMv2AaGRAMA4G
# A1UdDwEB/wQEAwIHgDATBgNVHSUEDDAKBggrBgEFBQcDAzB3BgNVHR8EcDBuMDWg
# M6Axhi9odHRwOi8vY3JsMy5kaWdpY2VydC5jb20vc2hhMi1hc3N1cmVkLWNzLWcx
# LmNybDA1oDOgMYYvaHR0cDovL2NybDQuZGlnaWNlcnQuY29tL3NoYTItYXNzdXJl
# ZC1jcy1nMS5jcmwwTAYDVR0gBEUwQzA3BglghkgBhv1sAwEwKjAoBggrBgEFBQcC
# ARYcaHR0cHM6Ly93d3cuZGlnaWNlcnQuY29tL0NQUzAIBgZngQwBBAEwgYQGCCsG
# AQUFBwEBBHgwdjAkBggrBgEFBQcwAYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29t
# ME4GCCsGAQUFBzAChkJodHRwOi8vY2FjZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNl
# cnRTSEEyQXNzdXJlZElEQ29kZVNpZ25pbmdDQS5jcnQwDAYDVR0TAQH/BAIwADAN
# BgkqhkiG9w0BAQsFAAOCAQEAP1QnJ6TEczaeGxVokMinsKam1mJB+zDk4B9rfm31
# iaZe9OeNvR/UJAs+5b0gKBZF9NmTVdayAYV74vZU5IElRo59q6hbg/20Wu87UyoE
# Yjwrv2DxHgl3z80piuLllmoe79vEu/bYvreBamzZmHlyxRP0us2KRfEsLBH23y1o
# zBATLc3yBu+mCfDg9E1RfhpKyD1iMHkbC90To6bpOlP9Pd6R4WEAFROILgm2bofQ
# ZhN4UNKbJ1uLCvV2NiUbU7+YSC3NP9SdphaDBiOnUWiK8MjTIPZbhh3QjI5f342q
# cUiR4LGx/Z/6pq4w6YHWd8c1czexD7xVCom7ZafCOKFWyzCCBmowggVSoAMCAQIC
# EAMBmgI6/1ixa9bV6uYX8GYwDQYJKoZIhvcNAQEFBQAwYjELMAkGA1UEBhMCVVMx
# FTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNv
# bTEhMB8GA1UEAxMYRGlnaUNlcnQgQXNzdXJlZCBJRCBDQS0xMB4XDTE0MTAyMjAw
# MDAwMFoXDTI0MTAyMjAwMDAwMFowRzELMAkGA1UEBhMCVVMxETAPBgNVBAoTCERp
# Z2lDZXJ0MSUwIwYDVQQDExxEaWdpQ2VydCBUaW1lc3RhbXAgUmVzcG9uZGVyMIIB
# IjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAo2Rd/Hyz4II14OD2xirmSXU7
# zG7gU6mfH2RZ5nxrf2uMnVX4kuOe1VpjWwJJUNmDzm9m7t3LhelfpfnUh3SIRDsZ
# yeX1kZ/GFDmsJOqoSyyRicxeKPRktlC39RKzc5YKZ6O+YZ+u8/0SeHUOplsU/UUj
# joZEVX0YhgWMVYd5SEb3yg6Np95OX+Koti1ZAmGIYXIYaLm4fO7m5zQvMXeBMB+7
# NgGN7yfj95rwTDFkjePr+hmHqH7P7IwMNlt6wXq4eMfJBi5GEMiN6ARg27xzdPpO
# 2P6qQPGyznBGg+naQKFZOtkVCVeZVjCT88lhzNAIzGvsYkKRrALA76TwiRGPdwID
# AQABo4IDNTCCAzEwDgYDVR0PAQH/BAQDAgeAMAwGA1UdEwEB/wQCMAAwFgYDVR0l
# AQH/BAwwCgYIKwYBBQUHAwgwggG/BgNVHSAEggG2MIIBsjCCAaEGCWCGSAGG/WwH
# ATCCAZIwKAYIKwYBBQUHAgEWHGh0dHBzOi8vd3d3LmRpZ2ljZXJ0LmNvbS9DUFMw
# ggFkBggrBgEFBQcCAjCCAVYeggFSAEEAbgB5ACAAdQBzAGUAIABvAGYAIAB0AGgA
# aQBzACAAQwBlAHIAdABpAGYAaQBjAGEAdABlACAAYwBvAG4AcwB0AGkAdAB1AHQA
# ZQBzACAAYQBjAGMAZQBwAHQAYQBuAGMAZQAgAG8AZgAgAHQAaABlACAARABpAGcA
# aQBDAGUAcgB0ACAAQwBQAC8AQwBQAFMAIABhAG4AZAAgAHQAaABlACAAUgBlAGwA
# eQBpAG4AZwAgAFAAYQByAHQAeQAgAEEAZwByAGUAZQBtAGUAbgB0ACAAdwBoAGkA
# YwBoACAAbABpAG0AaQB0ACAAbABpAGEAYgBpAGwAaQB0AHkAIABhAG4AZAAgAGEA
# cgBlACAAaQBuAGMAbwByAHAAbwByAGEAdABlAGQAIABoAGUAcgBlAGkAbgAgAGIA
# eQAgAHIAZQBmAGUAcgBlAG4AYwBlAC4wCwYJYIZIAYb9bAMVMB8GA1UdIwQYMBaA
# FBUAEisTmLKZB+0e36K+Vw0rZwLNMB0GA1UdDgQWBBRhWk0ktkkynUoqeRqDS/Qe
# icHKfTB9BgNVHR8EdjB0MDigNqA0hjJodHRwOi8vY3JsMy5kaWdpY2VydC5jb20v
# RGlnaUNlcnRBc3N1cmVkSURDQS0xLmNybDA4oDagNIYyaHR0cDovL2NybDQuZGln
# aWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJlZElEQ0EtMS5jcmwwdwYIKwYBBQUHAQEE
# azBpMCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wQQYIKwYB
# BQUHMAKGNWh0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3Vy
# ZWRJRENBLTEuY3J0MA0GCSqGSIb3DQEBBQUAA4IBAQCdJX4bM02yJoFcm4bOIyAP
# gIfliP//sdRqLDHtOhcZcRfNqRu8WhY5AJ3jbITkWkD73gYBjDf6m7GdJH7+IKRX
# rVu3mrBgJuppVyFdNC8fcbCDlBkFazWQEKB7l8f2P+fiEUGmvWLZ8Cc9OB0obzpS
# CfDscGLTYkuw4HOmksDTjjHYL+NtFxMG7uQDthSr849Dp3GdId0UyhVdkkHa+Q+B
# 0Zl0DSbEDn8btfWg8cZ3BigV6diT5VUW8LsKqxzbXEgnZsijiwoc5ZXarsQuWaBh
# 3drzbaJh6YoLbewSGL33VVRAA5Ira8JRwgpIr7DUbuD0FAo6G+OPPcqvao173NhE
# MIIGzTCCBbWgAwIBAgIQBv35A5YDreoACus/J7u6GzANBgkqhkiG9w0BAQUFADBl
# MQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3
# d3cuZGlnaWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVkIElEIFJv
# b3QgQ0EwHhcNMDYxMTEwMDAwMDAwWhcNMjExMTEwMDAwMDAwWjBiMQswCQYDVQQG
# EwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNl
# cnQuY29tMSEwHwYDVQQDExhEaWdpQ2VydCBBc3N1cmVkIElEIENBLTEwggEiMA0G
# CSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDogi2Z+crCQpWlgHNAcNKeVlRcqcTS
# QQaPyTP8TUWRXIGf7Syc+BZZ3561JBXCmLm0d0ncicQK2q/LXmvtrbBxMevPOkAM
# Rk2T7It6NggDqww0/hhJgv7HxzFIgHweog+SDlDJxofrNj/YMMP/pvf7os1vcyP+
# rFYFkPAyIRaJxnCI+QWXfaPHQ90C6Ds97bFBo+0/vtuVSMTuHrPyvAwrmdDGXRJC
# geGDboJzPyZLFJCuWWYKxI2+0s4Grq2Eb0iEm09AufFM8q+Y+/bOQF1c9qjxL6/s
# iSLyaxhlscFzrdfx2M8eCnRcQrhofrfVdwonVnwPYqQ/MhRglf0HBKIJAgMBAAGj
# ggN6MIIDdjAOBgNVHQ8BAf8EBAMCAYYwOwYDVR0lBDQwMgYIKwYBBQUHAwEGCCsG
# AQUFBwMCBggrBgEFBQcDAwYIKwYBBQUHAwQGCCsGAQUFBwMIMIIB0gYDVR0gBIIB
# yTCCAcUwggG0BgpghkgBhv1sAAEEMIIBpDA6BggrBgEFBQcCARYuaHR0cDovL3d3
# dy5kaWdpY2VydC5jb20vc3NsLWNwcy1yZXBvc2l0b3J5Lmh0bTCCAWQGCCsGAQUF
# BwICMIIBVh6CAVIAQQBuAHkAIAB1AHMAZQAgAG8AZgAgAHQAaABpAHMAIABDAGUA
# cgB0AGkAZgBpAGMAYQB0AGUAIABjAG8AbgBzAHQAaQB0AHUAdABlAHMAIABhAGMA
# YwBlAHAAdABhAG4AYwBlACAAbwBmACAAdABoAGUAIABEAGkAZwBpAEMAZQByAHQA
# IABDAFAALwBDAFAAUwAgAGEAbgBkACAAdABoAGUAIABSAGUAbAB5AGkAbgBnACAA
# UABhAHIAdAB5ACAAQQBnAHIAZQBlAG0AZQBuAHQAIAB3AGgAaQBjAGgAIABsAGkA
# bQBpAHQAIABsAGkAYQBiAGkAbABpAHQAeQAgAGEAbgBkACAAYQByAGUAIABpAG4A
# YwBvAHIAcABvAHIAYQB0AGUAZAAgAGgAZQByAGUAaQBuACAAYgB5ACAAcgBlAGYA
# ZQByAGUAbgBjAGUALjALBglghkgBhv1sAxUwEgYDVR0TAQH/BAgwBgEB/wIBADB5
# BggrBgEFBQcBAQRtMGswJAYIKwYBBQUHMAGGGGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0
# LmNvbTBDBggrBgEFBQcwAoY3aHR0cDovL2NhY2VydHMuZGlnaWNlcnQuY29tL0Rp
# Z2lDZXJ0QXNzdXJlZElEUm9vdENBLmNydDCBgQYDVR0fBHoweDA6oDigNoY0aHR0
# cDovL2NybDMuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJlZElEUm9vdENBLmNy
# bDA6oDigNoY0aHR0cDovL2NybDQuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJl
# ZElEUm9vdENBLmNybDAdBgNVHQ4EFgQUFQASKxOYspkH7R7for5XDStnAs0wHwYD
# VR0jBBgwFoAUReuir/SSy4IxLVGLp6chnfNtyA8wDQYJKoZIhvcNAQEFBQADggEB
# AEZQPsm3KCSnOB22WymvUs9S6TFHq1Zce9UNC0Gz7+x1H3Q48rJcYaKclcNQ5IK5
# I9G6OoZyrTh4rHVdFxc0ckeFlFbR67s2hHfMJKXzBBlVqefj56tizfuLLZDCwNK1
# lL1eT7EF0g49GqkUW6aGMWKoqDPkmzmnxPXOHXh2lCVz5Cqrz5x2S+1fwksW5Etw
# TACJHvzFebxMElf+X+EevAJdqP77BzhPDcZdkbkPZ0XN1oPt55INjbFpjE/7WeAj
# D9KqrgB87pxCDs+R1ye3Fu4Pw718CqDuLAhVhSK46xgaTfwqIa1JMYNHlXdx3LEb
# S0scEJx3FMGdTy9alQgpECYxggQzMIIELwIBATCBhjByMQswCQYDVQQGEwJVUzEV
# MBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNlcnQuY29t
# MTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQgQ29kZSBTaWduaW5n
# IENBAhAC4RhLEBaeoPexTwPcEzNSMAkGBSsOAwIaBQCgcDAQBgorBgEEAYI3AgEM
# MQIwADAZBgkqhkiG9w0BCQMxDAYKKwYBBAGCNwIBBDAcBgorBgEEAYI3AgELMQ4w
# DAYKKwYBBAGCNwIBFTAjBgkqhkiG9w0BCQQxFgQU5KQ4M71I1wGvh2z8AlkNNmx2
# O04wDQYJKoZIhvcNAQEBBQAEggEATg75hAvMjxsZS7/U+yjiSz4x6QcDn2WiiPwN
# JJ4R057BOf5B7qwhnzkrMMLJ/X1AsWVBW5ZRcrekZcITXx+DtZrPZDTL1+cmcV1W
# Y0srbZPYArP4MU9DBdmAesYsOQzqze8G1B1ijTuG1C3QDa3zHIRuFdltNElbGaYv
# nGEKXLhavWMd4NN4O9bw4UO2KLGJrMqjUy9AwuiCzhFfM1Ikz+YQZaDk0fef06O4
# GnRbbJ9qqPsVwPvaZAWk584IEum3Iv045kHZrL2fAT0o0OO6ziQgX0TdMQFYVUYa
# ytM0ZqLC84DeasI7yg2Myd5VKxbkZDMfasiHPyWQXH1O8OfRCKGCAg8wggILBgkq
# hkiG9w0BCQYxggH8MIIB+AIBATB2MGIxCzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxE
# aWdpQ2VydCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5jb20xITAfBgNVBAMT
# GERpZ2lDZXJ0IEFzc3VyZWQgSUQgQ0EtMQIQAwGaAjr/WLFr1tXq5hfwZjAJBgUr
# DgMCGgUAoF0wGAYJKoZIhvcNAQkDMQsGCSqGSIb3DQEHATAcBgkqhkiG9w0BCQUx
# DxcNMjAwODA3MDE1MDM2WjAjBgkqhkiG9w0BCQQxFgQULlYBmRYZxZhT6PgdThAk
# CRIpY/cwDQYJKoZIhvcNAQEBBQAEggEAR44GcHYR+O5Q2ttjxKxbyRR9+OYv1S1q
# 766Gf50D9wAwU25bKM2fHQ3N/pFWMr8kV24yRdciFKTwy/JaQEL+DAT3MrK58EaE
# 1LWs/9ijFaDG3EH7GJUUBx4IA58mlsBblqz7uLj0nWrRRtvkaV1PGKP2i+0wqCGv
# gsaRkIE2nzyb2dU/LAa4ks5BcsOsf/1LEjCvFLQQsaOa9ER41e4D9peZ1KjjSQjp
# av7E8pmq2VmHzcVjQ8c1TjMh9RjGeSlqXoRPZe0cehuFO+eAfQ5Bzj3TbZH86YwB
# aH74uAvd9UPB2ofaBZWh4tReRZg2xEpXUPg/ZM3BnaT7/zPlgm6+fg==
# SIG # End signature block
