/*
 * Decompiled with CFR 0.152.
 */
package com.eg.ch.qos.logback.classic.joran.action;

import com.eg.ch.qos.logback.classic.LoggerContext;
import com.eg.ch.qos.logback.classic.joran.ReconfigureOnChangeTask;
import com.eg.ch.qos.logback.classic.util.EnvUtil;
import com.eg.ch.qos.logback.core.joran.action.Action;
import com.eg.ch.qos.logback.core.joran.spi.InterpretationContext;
import com.eg.ch.qos.logback.core.joran.util.ConfigurationWatchListUtil;
import com.eg.ch.qos.logback.core.status.OnConsoleStatusListener;
import com.eg.ch.qos.logback.core.util.ContextUtil;
import com.eg.ch.qos.logback.core.util.Duration;
import com.eg.ch.qos.logback.core.util.OptionHelper;
import com.eg.ch.qos.logback.core.util.StatusListenerConfigHelper;
import java.net.URL;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.xml.sax.Attributes;

public class ConfigurationAction
extends Action {
    static final String INTERNAL_DEBUG_ATTR = "debug";
    static final String PACKAGING_DATA_ATTR = "packagingData";
    static final String SCAN_ATTR = "scan";
    static final String SCAN_PERIOD_ATTR = "scanPeriod";
    static final String DEBUG_SYSTEM_PROPERTY_KEY = "logback.debug";
    long threshold = 0L;

    /*
     * Unable to fully structure code
     */
    public void begin(InterpretationContext var1_1, String var2_2, Attributes var3_3) {
        this.threshold = System.currentTimeMillis();
        var4_4 = this.getSystemProperty("logback.debug");
        if (var4_4 == null) {
            var4_4 = var1_1.subst(var3_3.getValue("debug"));
        }
        if (OptionHelper.isEmpty(var4_4)) ** GOTO lbl13
        if (var4_4.equalsIgnoreCase("false")) ** GOTO lbl13
        if (var4_4.equalsIgnoreCase("null")) {
lbl13:
            // 3 sources

            this.addInfo("debug attribute not set");
        } else {
            StatusListenerConfigHelper.addOnConsoleListenerInstance(this.context, new OnConsoleStatusListener());
        }
        this.processScanAttrib(var1_1, var3_3);
        var5_5 = (LoggerContext)this.context;
        var6_6 = OptionHelper.toBoolean(var1_1.subst(var3_3.getValue("packagingData")), false);
        var5_5.setPackagingDataEnabled(var6_6);
        if (EnvUtil.isGroovyAvailable()) {
            var7_7 = new ContextUtil(this.context);
            var7_7.addGroovyPackages(var5_5.getFrameworkPackages());
        }
        var1_1.pushObject(this.getContext());
    }

    String getSystemProperty(String string) {
        try {
            return System.getProperty(string);
        }
        catch (SecurityException securityException) {
            return null;
        }
    }

    void processScanAttrib(InterpretationContext interpretationContext, Attributes attributes) {
        String string = interpretationContext.subst(attributes.getValue(SCAN_ATTR));
        if (!OptionHelper.isEmpty(string)) {
            if (!"false".equalsIgnoreCase(string)) {
                ScheduledExecutorService scheduledExecutorService = this.context.getScheduledExecutorService();
                URL uRL = ConfigurationWatchListUtil.getMainWatchURL(this.context);
                if (uRL == null) {
                    this.addWarn("Due to missing top level configuration file, reconfiguration on change (configuration file scanning) cannot be done.");
                    return;
                }
                ReconfigureOnChangeTask reconfigureOnChangeTask = new ReconfigureOnChangeTask();
                reconfigureOnChangeTask.setContext(this.context);
                this.context.putObject("RECONFIGURE_ON_CHANGE_TASK", reconfigureOnChangeTask);
                String string2 = interpretationContext.subst(attributes.getValue(SCAN_PERIOD_ATTR));
                Duration duration = this.getDuration(string, string2);
                if (duration == null) {
                    return;
                }
                this.addInfo("Will scan for changes in [" + uRL + "] ");
                this.addInfo("Setting ReconfigureOnChangeTask scanning period to " + duration);
                ScheduledFuture<?> scheduledFuture = scheduledExecutorService.scheduleAtFixedRate(reconfigureOnChangeTask, duration.getMilliseconds(), duration.getMilliseconds(), TimeUnit.MILLISECONDS);
                this.context.addScheduledFuture(scheduledFuture);
            }
        }
    }

    private Duration getDuration(String string, String string2) {
        Duration duration = null;
        if (!OptionHelper.isEmpty(string2)) {
            try {
                duration = Duration.valueOf(string2);
            }
            catch (NumberFormatException numberFormatException) {
                this.addError("Error while converting [" + string + "] to long", numberFormatException);
            }
        }
        return duration;
    }

    public void end(InterpretationContext interpretationContext, String string) {
        this.addInfo("End of configuration.");
        interpretationContext.popObject();
    }
}

