/*
 * Decompiled with CFR 0.152.
 */
package com.eg.ch.qos.logback.core.pattern;

import com.eg.ch.qos.logback.core.pattern.Converter;
import com.eg.ch.qos.logback.core.pattern.FormatInfo;
import com.eg.ch.qos.logback.core.pattern.SpacePadder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FormattingConverter<E>
extends Converter<E> {
    static final int INITIAL_BUF_SIZE = 256;
    static final int MAX_CAPACITY = 1024;
    FormatInfo formattingInfo;

    public final FormatInfo getFormattingInfo() {
        return this.formattingInfo;
    }

    public final void setFormattingInfo(FormatInfo formatInfo) {
        if (this.formattingInfo != null) {
            throw new IllegalStateException("FormattingInfo has been already set");
        }
        this.formattingInfo = formatInfo;
    }

    @Override
    public final void write(StringBuilder stringBuilder, E e2) {
        String string = this.convert(e2);
        if (this.formattingInfo == null) {
            stringBuilder.append(string);
            return;
        }
        int n2 = this.formattingInfo.getMin();
        int n3 = this.formattingInfo.getMax();
        if (string == null) {
            if (0 < n2) {
                SpacePadder.spacePad(stringBuilder, n2);
            }
            return;
        }
        int n4 = string.length();
        if (n4 > n3) {
            if (this.formattingInfo.isLeftTruncate()) {
                stringBuilder.append(string.substring(n4 - n3));
            } else {
                stringBuilder.append(string.substring(0, n3));
            }
        } else if (n4 < n2) {
            if (this.formattingInfo.isLeftPad()) {
                SpacePadder.leftPad(stringBuilder, string, n2);
            } else {
                SpacePadder.rightPad(stringBuilder, string, n2);
            }
        } else {
            stringBuilder.append(string);
        }
    }
}

