/*
* @(#)PortHandler.java
*
* FingerTip Technologies Pvt. Ltd.
* First Floor, WoodHead Center,
* 23 SivaGanga Road, Nungambakkam, Chennai, India.
*
* This software is the confidential and proprietary information of
* FingerTip Online Pvt. Ltd.
* ("Confidential Information"). You shall not
* disclose such Confidential Information and shall use it only in
* accordance with the terms of the license agreement you entered into
* with FingerTip Technologies Pvt. Ltd.
*/

package fingertip.comporthandler;
/*
 * Project		: GSM Engine
 * Class 		: PortHandler.java
 *
 * Date-Created : 28.02.2002
 * Date-Last
 * Modified		: 12.06.2002
 * Purpose		: Returns the COMPort Handler Instance.Creates the COM Port Connection.
 *
 * @(#)PortHandler.java
 * @author C Sundharavelu
 * @version 1.0
 *
 */
import javax.comm.CommPortIdentifier;
import javax.comm.SerialPort;

import java.lang.String;

import java.util.Enumeration;

import fingertip.config.GSMEngineConfig;
import fingertip.utils.LogWriter;
import fingertip.utils.StringManager;


public class PortHandler {

	/**
	 * Holds the Communication Port Identifier
	 *
	 */
	public CommPortIdentifier portIden;

	/**
	 * Holds the Serial Port Identifier
	 *
	 */
	public SerialPort port;

	/**
	 * Holds the Static Port Handler Variable
	 *
	 */
	public static PortHandler handler = null;

	/**
	 * Holds the Read Comm Object
	 *
	 */
	private ReadComm readPort;

	/**
	 * Holds the Write Comm Object
	 *
	 */
	private WriteComm writePort;


	/**
	 * Holds the StringManager Object
	 *
	 */
	private StringManager sm =
        StringManager.getManager(Constants.Package);


	/**
	 * Constructor
	 *
	 */
	public PortHandler() {
		portIden = null;
		port = null;
		handler = null;
	}

	/**
	 * Returns the SerialPort Object
	 * @return Serial Port Returns SerialPort Communication Object
	 */
	public SerialPort getSerialPort() {
		return port;
	}

	/**
	 * Returns the PortHandler Instance
	 * @return PortHandler PortHandler Instance
	 */
	public static PortHandler getInstance() {
		if(handler == null) {
			handler = new PortHandler();
			if(! handler.init()) handler = null;
		}
		return handler;
	}


	/**
	 * Returns the COM Port Reader
	 * @return ReadComm Returns ReadComm Object
	 */
	public ReadComm getCommReader() {
		return this.readPort;
	}

	/**
	 * Returns the COM Port Writer
	 * @return WriteCOmm Returns WriteComm Object
	 */
	public WriteComm getCommWriter() {
		return this.writePort;
	}

	/**
	 * Closes the Communication Ports
	 *
	 */
	public void close() {
		closeCommPort();
		this.port.close();
		this.port = null;
		handler = null;
	}



	/**
	 * Closes the COM Ports and assigns null
	 *
	 */
	private void closeCommPort() {

		if(this.readPort != null) {
			this.readPort.close();
			this.readPort = null;
		}

		if(this.writePort != null)	{
			this.writePort.close();
			this.writePort = null;
		}

	}

	/**
	 * Returns true if the COM port intialization is successful.
	 * @return true if the COM port intiallization is successful other wise false
	 */
	private boolean init() {
		LogWriter lgwr = null;
		try {
			lgwr = LogWriter.getInstance();
			String command = GSMEngineConfig.getInstance().getProperty("Command");
			if (command == null || command.trim().length() == 0)
			{
				Enumeration enum = CommPortIdentifier.getPortIdentifiers();
				boolean bNotFound = true;

				String portName = GSMEngineConfig.getInstance().getProperty("Port");

				while(enum.hasMoreElements() && bNotFound ) {
					 portIden = (CommPortIdentifier)enum.nextElement();
					 if(portIden.getName().equals(portName))
							bNotFound = false;
				}
				if( bNotFound) {
					lgwr.log(sm.getString("PortHandler.notFound",portName));
					System.out.println("COM Port Not Found");
					System.exit(-1);
				}

				port = (SerialPort) portIden.open("FingerTipHandler",2000);

				lgwr.log(sm.getString("PortHandler.started",portName,String.valueOf(2000)));

				//System.out.println("SMS Alert Sender started at port 2000 on "+portName);

				System.out.println(sm.getString("PortHandler.console",portName));

				port.notifyOnDataAvailable(true);
				port.setSerialPortParams(19200,
					SerialPort.DATABITS_8,
					SerialPort.STOPBITS_1,
					SerialPort.PARITY_NONE);

				port.setFlowControlMode(SerialPort.FLOWCONTROL_NONE );
				//port.setFlowControlMode(SerialPort.FLOWCONTROL_XONXOFF_OUT);

				this.readPort = new ReadComm(port,port.getInputStream());
				this.writePort = new WriteComm(port.getOutputStream());

				lgwr.log(sm.getString("PortHandler.portsReady"));

				return true;
			} else
				return true;
		} catch (Exception e) {
			lgwr.log(sm.getString("PortHandler.failed",e));
			//e.printStackTrace();
			return false;
		}
	}
}