<!DOCTYPE html>


<%@ taglib prefix = "egui" uri = "WEB-INF/eg-taglib.tld"%>
<%@ page import="java.io.*" %>
<%@ include file="admin/EgTrackerA.jsp" %>
<%@ page import = "com.egurkha.UserRegistry"%>
<%@ page import = "com.egurkha.EgUserRole"%>
<%@ page import = "com.egurkha.EgUserPermission"%>
<%@ page import="com.eg.EgInstallInfo" %>
<%@ page import = "com.eg.IniFile"%>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page errorPage = "EgProbsM.jsp" %>
<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
    IniFile dbIni =  new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_ui.ini");
	IniFile eg_dbaseIni =  new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_dbase.ini");
	String playBackFrequency = dbIni.getValue("Misc_TV_Settings","PlaybackFrequency");
	String playBackOrder = dbIni.getValue("Misc_TV_Settings","PlaybackOrder");
	String manager_version = eg_dbaseIni.getValue("MANAGER_DETAILS","ManagerVersion");
	//String needAutomaticScroll = dbIni.getValue("AutoScroll","needAutomaticScroll");
	String needAutomaticScroll = dbIni.getValue("Misc_TV_Settings","needAutomaticScroll");
	String tvModeModule=request.getParameter("Tvmodule");
	if(StringUtils.isNull(tvModeModule))
		tvModeModule="All";
%>

<html >
<head>
	<meta charset="UTF-8">
	<title>TV Mode</title>
	<meta http-equiv="X-UA-Compatible" content="IE=Edge,chrome=1"/>
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	
	<egui:skin ui="monitor"/>
	<script src="/final/jquery/jquery.js"></script>
	<script src="/final/scripts/gridstack/dist/lodash.min.js"></script>
	<script src="/final/extjs/ext-all.js"></script>
	<script>
	var url1="/final/Tvmodejson.jsp";
	var param='Tvmodule=<%=tvModeModule%>';
	var gettingURL=null;
	var playBackFrequency=Number('<%=playBackFrequency%>');
	var playBackOrder='<%=playBackOrder%>';
	var needAutomaticScrollKey = false;
	var managerVersion='<%=manager_version%>';
	var csrfToken='<%=strCsrfToken%>';
	var isTvMode =  true;
	if ('<%=needAutomaticScroll%>' == 'yes')
	{
		needAutomaticScrollKey = true;
	}
	</script>

<link rel="stylesheet"  href="/final/styles/lightslider.css"/> 
<script src="/final/scripts/lightslider.js"></script> 
<script type="text/javascript" src="/final/scripts/utilities/tvModeGeneric.js"></script>
<style>
body, html {
  height: 100%;
  margin: 0;
  background:#fff;
}

.bg {
  height: 100%;
  background-color:#000;
  background-position: center;
  background-repeat: no-repeat;
  background-size: cover;
}
.tvmodetitle{
	width:100%;
	height:145px;
	position:absolute;
	bottom:-145px;
	left:0;
	right:0;
	text-align:center;
	padding:0 10px 0px 0px;
	z-index:990;
	color:#fff;
	background: rgba(0,0,0,0.7);
	font-size:36px;
	text-shadow: 0 1px #fff;
}
.centered {
    position: fixed;
    top: 50%;
    left: 50%;
	width:100%;
	text-align:center;
    transform: translate(-50%, -50%);
	padding: 50px;
	border-width: 1px 0px;
	border-style:solid;
	font-weight:500;
	border-color:#c9c8c8;
 }

 .centered span {
      font-size: 5em;
	  color:#fff;
      font-weight:400;
 }
 .tvmode_title{
	font-size: 30px;
	font-weight:500;
    
}
.tvmode_header{
	font-size: 14px;
	font-weight:500;
    color : #1a1a1a;
}
.tvmode_splash_title{
	font-size: 5em;
	padding:10px 10px 20px 10px;
	font-weight:500;
	line-height:2em;
	color:#fecb00;
	margin-bottom:10px;
    
}
.tvmode_splash_subtitle{
	font-size: 3em;
	font-weight:400;
	padding:10px;
	color:#ffffff;
    border-top:#292929 1px solid;
}
.titleBg{
	margin:10em 0em 0em 0em;
	position:absolute;
	top:5em;
	width:100%;
	padding:10em 10em 10em 10em;
}
.tvmode_footer{
	position:absolute;
	bottom:0;
	left:0;
	right:0;
	width:100%;
	height:5em;
	padding:0 2em;
	line-height:5em;
	text-align:right;
	border-width:1px 0px 0px 0px;
	border-style:solid;
	border-color:#373c3f;
	background-color:rgba(0,0,0,0.8);
}
.tvmode_legend{
	position:absolute
	top:0;
	right:0;
	
}
.tvmode_copyrights{
	font-size: 1.5em;
	font-weight:500;
	margin-right:2em;
	color:#fff;
}
.title_box{
	background-color:rgba(0,0,0,0.7);
	padding:2em;
	display:inline-block;
}
.title_border{
	border-width:1px 1px 1px 1px;
	border-style:dashed;
	border-color:#566061;
	padding:2em;
	display:inline-block;
}
</style>
</head>
<body id="tvModeGenericPage">
<script> 
	

	Ext.onReady(function () {
	if(!Ext.isEmpty(gettingURL)) {
    Ext.create('Ext.window.Window', {
        ui: 'plain',
        width: '100%',
        height: '100%',
		shadow:false,
        style: {
            'background': '#000'
        },
        id: 'splash',
        resizable: false,
        layout: {
            type: 'fit',
            align: 'stretch',
            pack: 'center'
        },
        header: false,
        border: false,
        items: [{
                xtype: 'panel',
                layout: {
                    type: 'fit'
                },
                flex: 1,
                tpl: new Ext.Template(
                    '<table style="text-align:center;height: 100%;width: 100%;"  id="splashcontent" >',
					'<td style="vertical-align:middle;width:100%;height:100%;">',
					'<div style="background-image:url({imgSrc})" class="bg" >',
					'<div class="titleBg">',
					'<span class="title_box">',
					'<span class="title_border">',
					'<span class="tvmode_splash_title">{title}</span>',
					'<br>',
                    '<span class="tvmode_splash_subtitle">{subTitle}</span>',
					'</span>',
					'</span>',
					'</div>',
					'<div class="tvmode_footer">',
					'<span class="tvmode_copyrights" style="float:left">&copy; eG Innovations, Inc. All Rights Reserved - v '+managerVersion+'</span>',
					'<span style="float:right"><img src="../final/images/tvmodefooter-logo.png" style="vertical-align:middle" /></span>',
					'<div style="clear:both"></div>',
					'</div>',
					'</div>',
                    '</td></table>', {
                        compiled: true
                    }
                ),
                data: {
                    'imgSrc': '../final/images/unsplash1.jpg',
					'title':'eG KIOSK MODE',
                    'subTitle': 'End-to-End Performance Monitoring'
                }
            }

        ],
        renderTo: Ext.getBody()
    }).show().center();
	}
	Ext.EventManager.addListener(window, 'keyup', handleTVModeKeyPrs,this);
		Ext.Ajax.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};
		Ext.data.Connection.prototype.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};
		Ext.data.ScriptTagProxy.prototype.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};
		function handleTVModeKeyPrs(e){
			if(e!=null && !Ext.isEmpty(e) && e.keyCode!=null && e.keyCode==27)
			{
				
				Ext.defer(function(){
					frame = parent.document.getElementById('tvMode');
					frameDoc = frame.contentDocument || frame.contentWindow.document;
					frameDoc.documentElement.innerHTML = "";
					frame.src="about:blank";
					if(!Ext.isEmpty(Ext.getCmp('splash'))){
						Ext.destroy(Ext.getCmp('splash'));
					}
				},300);
			}
		}
	});

</script>
</body>

</html>
