<%
/************************************************************************************************
* File				:	RUMSnapshotJson.jsp
* Purpose			:	Displays the configured measures and its details for RUM Snapshot Report
* Creation			:	Vengatesan R at 22/12/2017
*
*************************************************************************************************/
%>

<%@ page import = "egurkha.reporter.*" %>
<%@ page import = "java.util.*" %>
<%@ page import = "java.text.SimpleDateFormat" %>
<%@ page import = "egurkha.*" %>
<%@ page import = "com.eg.EgDbInfo" %>
<%@ page import ="com.eg.EgInstallInfo"%>
<%@ page import ="com.eg.IniFile"%>
<%@ page import="com.egurkha.ini.*" %>
<%@ page import="com.eg.EgDateInfo" %>
<%@ page import="com.eg.EgGroupInfo" %>
<%@ page import="com.eg.EgReportInfo" %>
<%@ page import="com.eg.EgSpecsInfo" %>
<%@ page import = "com.egurkha.*" %>
<%@ page import = "java.net.*" %>
<%@ page import="com.eg.EgThresholdInfo" %>
<%@ page import="com.eg.EgTablesInfo" %>
<%@ page import="com.eg.EgMappingInfo" %>
<%@ page import = "com.eg.EgURLEncoder" %>
<%@ page import = "com.egurkha.util.DateTimeTokenizer" %>
<%@ page import = "com.egurkha.util.DateUtil" %>
<%@ page import = "com.egurkha.util.StringUtils" %>
<%@ page import = "java.text.*" %>
<%@ page import="net.sf.json.*" %>
<%@ page import = "com.eg.EgConfigInfo"%>
<%@ include file = "ErReporterTracker.jsp" %>


<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%
try
{	
	JSONObject combo=new JSONObject();
	JSONObject urlFields=new JSONObject();
	JSONObject labelFields=new JSONObject();
    JSONObject hiddenFields = new JSONObject();
	JSONObject selectedFields = new JSONObject();
	JSONObject selectionDetails = new JSONObject();
	JSONObject iterateJObject;
	JSONArray iterateJArray;
	JSONArray selectedComboJArray=null;
 	JSONObject rootjson=new JSONObject();
	JSONObject loopJsonObj = new JSONObject();

	String bggroundStr = (String)request.getAttribute("bggroundStr");
	String status = (String)request.getAttribute("status");

	String strTestt="";
	//Back Button - Start

	HashMap backreqMap = (HashMap)session.getAttribute("backQuery");
	String backQnumber = request.getParameter("backQnumber");
	String servlet2 = request.getParameter("backServletName");
	String reqFromFavorite = request.getParameter("fromFavorite");
	String favorite_id = request.getParameter("FavoriteId");
	ErHelperUtils erhelputils = null;
	ErEsxVMutils erEsxUtils = new ErEsxVMutils();
	if( servlet2!=null && !servlet2.equals(""))
		erhelputils = new ErHelperUtils(backreqMap,backQnumber,servlet2);
	else
		erhelputils = new ErHelperUtils(backreqMap,backQnumber);

	boolean enableBack=erhelputils.isBackButtonEnable();
	String backButtonEnable = request.getParameter("back");
	rootjson.put("ID","backQnumber="+erhelputils.getBackID()+"&"+erhelputils.getQueryString());
	if(backButtonEnable != null && backButtonEnable.equalsIgnoreCase("True"))
	{
		status = (String)request.getParameter("status");
		request.setAttribute("htdata",null);
		bggroundStr = (String)request.getParameter("bggroundStr");
	}
	//Back Button - End
	String mngrIProc = new IniFile(new EgConfigInfo("manager").getDbFile()).getValue("DB_PROPERTIES","ManagerUrl");
	List lst = new LinkedList();
	IniUI ui = IniUI.getInstance();
	EgDateInfo egDt = new EgDateInfo();
	String Hourfrom="";
	String Minfrom="";
	String Hourto="";
	String Minto="";
	String fromTime,toTime;
	String variable;
	StringTokenizer st;
	EgMappingInfo intlmap=new EgMappingInfo(thisuser.getLanguage());
	ErComponentsUtils compUtil = new ErComponentsUtils(thisuser.getLoginID());
	ErUtils erUtils = new ErUtils();
	ErInfo erInfo = new ErInfo();
	EgReportInfo reportInfo=new EgReportInfo("manager");
	EgSpecsInfo specsInfo = new EgSpecsInfo("manager");
	String confrimation = reportInfo.getValue("BACKGROUND_PROCESS","NeedConfirmation");
	String strbgrepportName = reportInfo.getValue("BACKGROUND_PROCESS","EnableBackgroundReport");
	String limitforbg = reportInfo.getValue("BACKGROUND_PROCESS","MinDurationForReport");
	String overAllRecCount = request.getParameter("overAllRecCount");
	EgThresholdInfo hreshholdInfo = new EgThresholdInfo("manager");
	EgTablesInfo tablesInfo = new EgTablesInfo("manager");
	EgDbInfo dbInfo = new EgDbInfo("manager");
	User this_user = UserRegistry.getInstance().getUser(session.getId());
	String loginid = this_user.getLoginID();
	ArrayList subjects = (ArrayList)reportInfo.getVariables("RUM_SNAPSHOT");
	String installDir = EgInstallInfo.getInstallDir();
	String totalTest = reportInfo.getValue("RUM_SNAPSHOT","RUMTest");
	ArrayList totalTestlst = new ArrayList();
	if(totalTest!=null)
	{
		StringTokenizer valueTokens = new StringTokenizer(totalTest,",");
		while(valueTokens.hasMoreTokens())
		{
			String testS = valueTokens.nextToken();
			totalTestlst.add(testS);
		}
	}
	int pageWith=1024;
	String er_option =request.getParameter("er_option");
	String er_site = request.getParameter("er_site");
	String er_compType = request.getParameter("er_compType");
	String er_component[] = request.getParameterValues("er_component");
	String durationStart = request.getParameter("durationStart");
	String durationEnd = request.getParameter("durationEnd");
	String guidField = request.getParameter("guidField");

	if(durationStart==null)
	{
		durationStart = "";
	}
	if(durationEnd==null)
	{
		durationEnd = "";
	}
	if(guidField==null)
	{
		guidField = "";
	}
	rootjson.put("durationStart",durationStart);
	rootjson.put("durationEnd",durationEnd);
	rootjson.put("guidField",guidField);

	if(er_compType==null)
	{
		//er_compType = "All";
	}
	List v_site=new ArrayList();
	ArrayList v_comptype=new ArrayList();
	Vector v_comps = compUtil.getAllUserComponents1();
	ArrayList aListSupportedComponentType = reportInfo.getComponentsList("RUM_SNAPSHOT",false);
	for(int i=0; i<v_comps.size(); i++) 
	{
		String loopComponent = (String) v_comps.get(i);
		String loopType = loopComponent.substring(loopComponent.lastIndexOf(":")+1);
		if(!v_comptype.contains(loopType)) 
		{
			if(aListSupportedComponentType.contains(loopType))
				v_comptype.add(loopType);
		}
	}
	System.out.println("v_comptype_____ "+v_comptype);
	Hashtable htAllGroups=erEsxUtils.getGroups(null,v_comptype, thisuser, loginid, "Yes",true);
	ArrayList aListOption = erEsxUtils.getOptions(htAllGroups);
	/*if(aListOption!=null && aListOption.contains("Component"))
	{
		aListOption.remove("Component");
	}*/
	System.out.println("aListOptionaListOption "+aListOption);
	if(er_option == null || (er_option!=null && er_option.isEmpty()) || er_option.equalsIgnoreCase("null"))
	{
		if(aListOption!=null && aListOption.contains("Service"))
			er_option = "Service";
		else if(aListOption!=null && aListOption.size()>0)
			er_option = (String)aListOption.get(0);
	}
	if(er_option!=null && er_option.equalsIgnoreCase("Component"))
	{
		er_site = null;
	}
	List v_option = new ArrayList();
	if(aListOption!=null && aListOption.size()>0)
		v_option.addAll(aListOption);
	JSONArray arr = new JSONArray();
	JSONObject obj1=null;
	if(v_option!=null && v_option.size()>0 )
	{
		selectedFields.put("selectedAnalysisByCombo",er_option);
		for(int i=0; i<v_option.size(); i++)
		{
			String tempStr = (String)v_option.get(i);
			//if(tempStr.equalsIgnoreCase("Component"))
				//continue;
			obj1 = new JSONObject();
			obj1.put("displayField", intlmap.getTextDescription("reporter.common."+tempStr));
			obj1.put("valueField",tempStr);
			arr.add(obj1);
		}
	}
	else
	{
		obj1 = new JSONObject();
		obj1.put("displayField", intlmap.getTextDescription("reporter.common.Not Applicable"));
		obj1.put("valueField","-1");
		arr.add(obj1);
	}
	labelFields.put("analysisComboLabel",intlmap.getTextDescription("reporter.uptime.Analyze by"));
	combo.put("analysisByCombo",arr);
	ArrayList aListComponentTemp = null;
	String headerKeyName = null;
	if(er_option!=null && !er_option.equalsIgnoreCase("Component"))
	{
		v_site = erEsxUtils.getGroupsName(htAllGroups,er_option);
		if(er_site==null)
		{
			if(v_site!=null && v_site.size()>0)
			{
				er_site = (String)v_site.get(0);
			}
			else
			{
				er_site = "";
			}
		}
		if(er_site.equalsIgnoreCase("--Default--"))
		{
			selectionDetails.put(intlmap.getTextDescription("reporter.thin."+er_option),intlmap.getTextDescription("reporter.common.--Default--"));
		}
		else
		{
			selectionDetails.put(intlmap.getTextDescription("reporter.thin."+er_option),er_site);
		}
		combo.put("siteCombo",getJSONComboFromList(v_site,"",intlmap,false,"",false));
		labelFields.put("siteComboLabel",intlmap.getTextDescription("reporter.common."+er_option));
		selectedFields.put("selectedSiteCombo",er_site);
		aListComponentTemp = erEsxUtils.getComponentForGroup(htAllGroups,er_option,er_site);
		headerKeyName=er_option+" : "+er_site;
	}
	else
	{
		aListComponentTemp = erEsxUtils.getComponentForGroup(htAllGroups,er_option,null);
		headerKeyName=er_option+" : "+er_compType;
	}
	List compList = new ArrayList();
	System.out.println("aListComponentTemp   "+aListComponentTemp);
	v_comptype = new ArrayList();
	if(aListComponentTemp!=null)
	{
		for(int n=0;n<aListComponentTemp.size();n++)
		{
			String comp = (String)aListComponentTemp.get(n);
			int index=comp.lastIndexOf(":");
			if(index>-1)
			{ 
				String  v_componentType = comp.substring(index+1,comp.length()); 
				if(er_compType==null)
				{
					er_compType = v_componentType;
				}
				if(!v_comptype.contains(v_componentType))
				{
					v_comptype.add(v_componentType);
				}
				if(er_compType.equalsIgnoreCase("All") || er_compType.equalsIgnoreCase(v_componentType))
				{
					compList.add(comp);
				}
			}
		}
	}
	combo.put("compTypeCombo",getJSONComboFromList(v_comptype,"",intlmap,false,intlmap.getTextDescription("reporter.thin.All"),true));
	labelFields.put("compTypeComboLabel",intlmap.getTextDescription("reporter.thin.Component Type"));
	selectedFields.put("selectedCompTypeCombo",er_compType);

	combo.put("componentCombo",getJSONComboFromList(compList,"",intlmap,false,intlmap.getTextDescription("reporter.thin.All Components"),false));
	labelFields.put("componentLabel",intlmap.getTextDescription("reporter.thin.Components"));
	List er_componentList = null;
	if(er_component==null || er_component.length==0)
	{
		//er_componentList = new ArrayList();
		//er_componentList.add("All");
		if(compList.size()>0)
		{
			selectedFields.put("componentSelected",compList.get(0));
		}
		else
		{
			selectedFields.put("componentSelected","-1");
		}
	}
	else
	{
		er_componentList = Arrays.asList(er_component);
		selectedFields.put("componentSelected",er_componentList.get(0));
	}
	//selectedFields.put("componentSelected",er_componentList);

	IniFile inifile = new IniFile(installDir +"/manager/config/eg_report.ini");
	String timeline =request.getParameter("er_timeline");
	String rtype =request.getParameter("er_type");
	String reqFromSchedule = request.getParameter("fromSchedule");
	String schedule_id = request.getParameter("schedule_id");
	String isSubmit = request.getParameter("isSubmit");
	String er_zone = request.getParameter("er_zone");

	
	ErReqData erd = new ErReqData(request);
	EgDateInfo egDate = new EgDateInfo();
	long msecsPerHour = (long) 1000 * 60 * 60;

	fromTime = reportInfo.getTimeFrame("RUM_SNAPSHOT","FROM");
	toTime = reportInfo.getTimeFrame("RUM_SNAPSHOT","TO");

	st = new StringTokenizer(fromTime,":");
	if(st.hasMoreTokens())
	{
		Hourfrom = st.nextToken();
		Minfrom = st.nextToken();
	}
	st=new StringTokenizer(toTime,":");
	if(st.hasMoreTokens())
	{
		Hourto = st.nextToken();
		Minto = st.nextToken();
	}
	String Days = reportInfo.getExcludeWeekend("RUM_SNAPSHOT");

	String timefrom2=request.getParameter("timefrom");
	String minfrom2=request.getParameter("minfrom");
	String timeto2=request.getParameter("timeto");
	String minto2=request.getParameter("minto");

	if (timefrom2!=null)
		Hourfrom=timefrom2;
	if (minfrom2!=null)
		Minfrom=minfrom2;
	if (timeto2!=null)
		Hourto=timeto2;
	if (minto2!=null)
		Minto=minto2;
	
	String uiFile = "eg_ui.ini";
	String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile egUI = new IniFile(s_iniFile_dir + uiFile);
	String currentDateFormat = strUserDateFormat;//egUI.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");

	String starttimeformat="";	
	String endtimeformat="";
	String dispDate = null;
	String comFormat = null;
	String  s_st_time   = request.getParameter("startdate");
	String s_en_time    = request.getParameter("enddate");
	String s_st_hr      = request.getParameter("starthr");
	String s_en_hr      = request.getParameter("endhr");
	String strmin       = request.getParameter("startmin");
	String enmin        = request.getParameter("endmin");
	String  er_timeline = request.getParameter("er_timeline");
	String start_date   = request.getParameter("startdate");
	String end_date     = request.getParameter("enddate");

	System.out.println("s_st_time  "+s_st_time);
	System.out.println("s_st_hr  "+s_st_hr);
	System.out.println("strmin  "+strmin);
	String  pdfStartDate = s_st_time+" "+s_st_hr+":"+strmin;
	String  pdfEndDate   = s_en_time+" "+s_en_hr+":"+enmin;
	String pdfTime = "From "+pdfStartDate+" hrs "+" "+" To "+pdfEndDate+" hrs";

	Vector applnPdfData = new Vector();
	applnPdfData = (Vector)request.getAttribute("applnPdfData");
	pdfTime = "RUM Snapshot "+pdfTime;

	if(er_timeline==null  || er_timeline.equals(" "))
	{
		er_timeline="1 day";
	}
	//Date calculation according to time select
	String[] options = {"Any","1 hour", "3 hours", "6 hours", "9 hours", "12 hours", "15 hours", "18 hours", "21 hours","1 day", "2 days", "3 days", "4 days", "5 days", "6 days","1 week","2 weeks","3 weeks","4 weeks","1 month","2 months","3 months"};
	String startDateTime="";
	String endDateTime="";
	if(er_timeline!=null&&!er_timeline.equals("Any"))
	{
		int blankSpaceIndex = er_timeline.indexOf(DateTimeTokenizer.BLANK_SPACE);
		if (blankSpaceIndex > 0)
		{
			SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy HH:mm");
			java.util.Date today =egDt.egetRealDate();
			endDateTime = sdf.format(today);
			long value = Integer.parseInt(er_timeline.substring(0, blankSpaceIndex));
			String unit = er_timeline.substring(blankSpaceIndex+1).toLowerCase();
			if (unit.startsWith("h"))
			{//hours
				value *= 3600;
			}
			else if (unit.startsWith("d"))
			{//days
				value *= (24 * 3600);
			}
			else if (unit.startsWith("w"))
			{//weeks
				value *= (7 * 24 * 3600);
			}
			else if (unit.startsWith("mo"))
			{//months
				java.util.Date dt_temp = new java.util.Date(egDt.egetUTCDate());
				Calendar cal_temp = new GregorianCalendar();
				cal_temp.setTime(dt_temp);
				//cal_temp.add(Calendar.DATE,-1);
				cal_temp.add(Calendar.HOUR_OF_DAY,0);
				java.util.Date dt_temp1 = cal_temp.getTime();
				long l_temp = dt_temp1.getTime();
				int  totalDays=24*(ErUtils.getMaxDaysInMonth());
				startDateTime = egDt.egetDate(l_temp -(long)( (value*totalDays * msecsPerHour)));
				startDateTime = DateUtil.changeDateFormat(startDateTime,
				"dd/MM/yyyy HH:mm","MM/dd/yyyy HH:mm");
			}
			if (unit!=null&&!unit.startsWith("mo"))
			{
				java.util.Date start = egDt.egetRealDate();
				start.setTime(today.getTime() - (value * 1000));
				startDateTime = sdf.format(start);
			}
		}
		if ((startDateTime != null) && (endDateTime != null))
		{
			int shr = Integer.parseInt(startDateTime.substring(startDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE)+1, startDateTime.indexOf(":")));
			strmin=startDateTime.substring(startDateTime.indexOf(":")+1);
			int en_hr = Integer.parseInt(endDateTime.substring(endDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE)+1, endDateTime.indexOf(":")));
			enmin=endDateTime.substring(endDateTime.indexOf(":")+1);
			s_en_time=endDateTime.substring(0, endDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE));
			s_st_time=startDateTime.substring(0, startDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE));
			s_st_hr = String.valueOf(shr);
			s_en_hr = String.valueOf(en_hr);
		}
	}
	String disable="";
	if(er_timeline!=null&&!er_timeline.equals("Any"))
	{
		disable ="disabled";
	}
	if(er_timeline!=null&&er_timeline.equals("Any"))
	{
		String StrDate="";
		try
		{
			java.text.SimpleDateFormat df=new java.text.SimpleDateFormat("MM/dd/yyyy k 'at' hh:mm");
			StrDate =df.format(egDt.egetRealDate());
		}
		catch(Exception ee)
		{
			////System.out.println("Exception is"+ee);
		}
		String SDate =StrDate.substring(0,StrDate.indexOf(" "));
		String shour =StrDate.substring(StrDate.indexOf(" "),StrDate.lastIndexOf(""));
		shour = shour.substring(0,3);
		if(s_st_time==null)
		{
			s_st_time=SDate;
		}
		if(s_en_time==null)
		{
			s_en_time=SDate;
		}
		if(s_st_hr==null)
		{
			shour =shour.trim();
			int starthr = Integer.parseInt(shour);
			starthr = starthr-1;
			s_st_hr=String.valueOf(starthr);
		}
		if(s_en_hr==null)
		{
			shour =shour.trim();
			s_en_hr =shour;
		}
		strmin="00";
		enmin="00";
	}

	session.setAttribute("PDF_URL", mngrIProc+"/final/reporter/RUMSnapshotPrint.jsp");
	urlFields.put("PDF_URL",mngrIProc+"/final/reporter/RUMSnapshotPrint.jsp");

	String excludeweekend=request.getParameter("er_excwe");
	if (excludeweekend==null ||	excludeweekend.equals(""))
		excludeweekend="No";

	hiddenFields.put("option","RUMReport");
	hiddenFields.put("inidate",currentDateFormat);
	hiddenFields.put("currTime","");
	hiddenFields.put("er_rtype","RUMSnapshot");
	hiddenFields.put("er_trgttype","RUM Snapshot Report");
	hiddenFields.put("er_gtype","RUMSnapshot");
	hiddenFields.put("pdfTime",pdfTime);
	hiddenFields.put("uid",EgURLEncoder.encode(loginid,"UTF-8"));
	hiddenFields.put("userID",EgURLEncoder.encode(loginid,"UTF-8"));
	hiddenFields.put("eruserid",EgURLEncoder.encode(loginid,"UTF-8"));
	hiddenFields.put("er_trenddata","No");
	hiddenFields.put("servers",request.getParameter("servers"));
	hiddenFields.put("er_check",request.getParameter("er_check"));
	hiddenFields.put("schedule_id",schedule_id);
	hiddenFields.put("er_ViewName","RUMSnapshot.jsp");
	hiddenFields.put("getMaxDaysInMonth",ErUtils.getMaxDaysInMonth());
	hiddenFields.put("forwardto","RUMSnapshotJson");
	hiddenFields.put("er_bgreportfrom","RUM_SNAPSHOT");
	hiddenFields.put("bgenabled",strbgrepportName);
	hiddenFields.put("limitforbg",limitforbg);
	hiddenFields.put("savereport","save");
	hiddenFields.put("servletName","com.eg.ErRUMSnapshotC");

	iterateJArray=new JSONArray();
	iterateJObject=new JSONObject();
	iterateJObject.put("displayField",intlmap.getTextDescription("reporter.common.Yes")+" ("+Days+") ");
	iterateJObject.put("valueField","Yes");
	iterateJArray.add(iterateJObject);
	iterateJObject=new JSONObject();
	iterateJObject.put("displayField",intlmap.getTextDescription("reporter.common.No"));
	iterateJObject.put("valueField","No");
	iterateJArray.add(iterateJObject);
	combo.put("excludeWeekendsCombo",iterateJArray);
	labelFields.put("excludeWeekendsLabel",intlmap.getTextDescription("reporter.thin.Exclude weekends"));
	labelFields.put("excludeDaysLabel",intlmap.getTextDescription("reporter.thin.Excludes")+" "+Days);
	if(excludeweekend.equalsIgnoreCase("Yes") )
	{
		selectedFields.put("excludeWeekendsSelected","Yes");
		//selectionDetails.put(intlmap.getTextDescription("reporter.thin.Exclude weekends"),"Yes");

		lst.add('"'+intlmap.getTextDescription("reporter.common.Time period")+":"+intlmap.getTextDescription("reporter.common.From")+" "+request.getParameter("timefrom")+":"+request.getParameter("minfrom")+intlmap.getTextDescription("reporter.common.Hrs")+" "+intlmap.getTextDescription("reporter.common.To")+" "+request.getParameter("timeto")+":"+request.getParameter("minto")+intlmap.getTextDescription("reporter.common.Hrs")+'"'+","+'"'+
		
		intlmap.getTextDescription("reporter.common.Exclude weekends")+":"+Days+'"');
	}
	else
	{
		selectedFields.put("excludeWeekendsSelected","No");
		//selectionDetails.put(intlmap.getTextDescription("reporter.thin.Exclude weekends"),"No");

		lst.add(intlmap.getTextDescription("reporter.common.Time period")+":"+intlmap.getTextDescription("reporter.common.From")+" "+request.getParameter("timefrom")+":"+request.getParameter("minfrom")+intlmap.getTextDescription("reporter.common.Hrs")+" "+intlmap.getTextDescription("reporter.common.To")+" "+request.getParameter("timeto")+":"+request.getParameter("minto")+intlmap.getTextDescription("reporter.common.Hrs"));
		
	}
 
	selectedFields.put("selectedTimeFrom",Hourfrom);
	selectedFields.put("selectedMinsFrom",Minfrom);
	selectedFields.put("selectedTimeTo",Hourto);
	selectedFields.put("selectedMinsTo",Minto);
%>
	<%@  include file ="ErTimeFormatJSON.jsp"%>
<%
		
	String sdate = request.getParameter("startdate");	
	String edate = request.getParameter("enddate");	
	String shr = request.getParameter("starthr");	
	String ehr = request.getParameter("endhr");	
	String smin = request.getParameter("startmin");	
	String emin = request.getParameter("endmin");
	
	starttimeformat = sdate+ " " +shr+":"+smin+" "+"Hrs ";
	
	endtimeformat   = edate+ " " +ehr+":"+emin+" Hrs ";
	//Time zone conversion 
	
	pdfStartDate=startDateForDisplay+" "+startHourForDisplay+":"+startMinForDisplay;
	pdfEndDate = endDateForDisplay+" "+endHourForDisplay+":"+endMinForDisplay;
		


	Vector dvec = new Vector();
	String stimefmt = "Start Date : "+pdfStartDate;
	String etimefmt = "End Date : "+pdfEndDate;

	String ssd=stimefmt+"  "+etimefmt;

	lst.add('"'+ssd+'"');

	
	hiddenFields.put("userTimeline",strUsrTimeline);
	combo.put("timelineCombo",timelineComboArray);
	labelFields.put("timelineComboLabel",intlmap.getTextDescription("reporter.common.Timeline"));
	selectedFields.put("selectedTimeline",er_timeline);
	selectedFields.put("startDate",startDateJSON);
	selectedFields.put("endDate",endDateJSON);
	selectedFields.put("startHour",startHourJSON);
	selectedFields.put("endHour",endHourJSON);
	selectedFields.put("startmin",startMin);
	selectedFields.put("endmin",endMin);
	selectedFields.put("selectedGraphMode",selectedGraphMode);

	//User TimeZone changes
	selectedFields.put("startDateForDisplay",startDateForDisplay);
	selectedFields.put("startHourForDisplay",startHourForDisplay);
	selectedFields.put("startMinForDisplay",startMinForDisplay);
	selectedFields.put("endDateForDisplay",endDateForDisplay);
	selectedFields.put("endHourForDisplay",endHourForDisplay);
	selectedFields.put("endMinForDisplay",endMinForDisplay);
	
	selectionDetails.put(intlmap.getTextDescription("reporter.common.Time Period"),Hourfrom+":"+Minfrom+"<span class='font_bold'>  "+intlmap.getTextDescription("reporter.common.to")+" </span> "+Hourto+":"+Minto);
		
	selectionDetails.put((String)intlmap.getTextDescription("reporter.common.Timeline"),pdfStartDate+" "+intlmap.getTextDescription("reporter.common.hrs")+" <span class='font_bold'>"+intlmap.getTextDescription("reporter.common.to")+"</span> "+pdfEndDate+" "+intlmap.getTextDescription("reporter.common.hrs"));
 	
	String er_reportgenration = request.getParameter("er_reportgenration");
	String er_background ="";
	String er_foreground ="";
	if (er_reportgenration != null && er_reportgenration.equals("background"))
	{
		selectedFields.put("reportGenerationSelected","background");
		er_background = "selected";
		er_foreground = "";
	}
		else if(er_reportgenration != null && er_reportgenration.equals("background-csv"))
	{
		selectedFields.put("reportGenerationSelected","background-csv");
		er_background = "selected";
		er_foreground = "";
	}
	else
	{
		selectedFields.put("reportGenerationSelected","foreground");
		er_background = "";
		er_foreground = "selected";
	}
	String bg_reportname = request.getParameter("bg_reportname");
	if(bg_reportname == null)
	{
		bg_reportname = "";
	}
	String reportgenColspan = "5";
	if(rtype != null && rtype.equalsIgnoreCase("No"))
	{
		if(er_reportgenration != null && er_reportgenration.equals("background"))
			reportgenColspan = "2";
		else
			reportgenColspan = "3";
	}
	if(strbgrepportName != null && strbgrepportName.equalsIgnoreCase("Yes"))
	{
		labelFields.put("reportGenerationLabel",intlmap.getTextDescription("reporter.consolidated.Report Generation"));
		labelFields.put("reportNameLabel",intlmap.getTextDescription("reporter.consolidated.Report Name"));
		iterateJArray=new JSONArray();
		iterateJObject=new JSONObject();
		iterateJObject.put("displayField",strbackground);
		iterateJObject.put("valueField","background");
		iterateJArray.add(iterateJObject);

		iterateJObject=new JSONObject();
		iterateJObject.put("displayField","Background Save - CSV");
		iterateJObject.put("valueField","background-csv");
		iterateJArray.add(iterateJObject);

		iterateJObject=new JSONObject();
		iterateJObject.put("displayField",strforeground);
		iterateJObject.put("valueField","foreground");
		iterateJArray.add(iterateJObject);
		combo.put("reportGenerationCombo",iterateJArray);

		//||er_reportgenration.equalsIgnoreCase("background-csv")||er_reportgenration.equals("background-xls"))
		if (er_reportgenration != null && (er_reportgenration.equals("background")||er_reportgenration.equalsIgnoreCase("background-csv")||er_reportgenration.equals("background-xls")))
		{
			selectedFields.put("reportNameSelected",bg_reportname);
		}
		
	}
	if((reqFromSchedule!=null && reqFromSchedule.equalsIgnoreCase("Yes")) || (reqFromFavorite!=null && reqFromFavorite.equalsIgnoreCase("Yes")))
	{
		labelFields.put("saveButton",intlmap.getTextDescription("reporter.common.SAVE"));
		String fromReq = "schedule";
		if(reqFromFavorite!=null && reqFromFavorite.equalsIgnoreCase("Yes"))
			fromReq = "favorite";
	}
	else
	{
		labelFields.put("submitButton",intlmap.getTextDescription("reporter.common.SUBMIT"));
	}
	if(bggroundStr != null && !bggroundStr.equals(""))
	{
		String strreportName = "RUM_SNAPSHOT";
 		if(status != null && (status.equalsIgnoreCase("duplicate") || status.equalsIgnoreCase("exceedLimit")))
		{
			strreportName ="All Report Types";
		}
		if(status !=null && status.equalsIgnoreCase("success"))
			labelFields.put("bgStatus","success");
		else if(status !=null && status.equalsIgnoreCase("duplicate"))
			labelFields.put("bgStatus","duplicate");
		if(strreportName!=null && strreportName.indexOf(" ") > -1)
		{
			strreportName = com.eg.EgURLEncoder.encode(strreportName, "UTF-8");
		}
		String bgroundResponseTxt=bggroundStr;
		if(status != null && !status.equalsIgnoreCase("exceedLimit"))
		{
			bgroundResponseTxt=erbgreport.getlangsupportedString(bggroundStr,bgString,urs);
		}
		labelFields.put("bgResponseText",bgroundResponseTxt);
		urlFields.put("bgUrl","/final/servlet/com.eg.ErStartBackGroundReportC?back=true&er_bgreportfrom="+strreportName+"&userID="+com.eg.EgURLEncoder.encode(urs, "UTF-8")+"&savereport=search&er_filterby=Report_Name&forwardto=ErBackGoundProcess");
		labelFields.put("bgAnchor",intlmap.getTextDescription("reporter.common.Click here to see a list of generated and processing reports"));
		
	}
	ArrayList resultList = (ArrayList)session.getAttribute("RUM_SNAPSHOT_RESULT_LIST");
	HashMap summaryMap = (HashMap)session.getAttribute("RUM_SNAPSHOT_SUMMARYMAP");
	String checkedFilterData = request.getParameter("checkedFilterData");
	HashMap checkedFilterMp = null;
	int totalCheckedCount = 0;
	if(checkedFilterData!=null && checkedFilterData.length()>0)
	{
		checkedFilterData = erUtils.specialCharDecode(checkedFilterData);
		String[] checkedFilterDataAry = checkedFilterData.split("\\|");
		if(checkedFilterDataAry!=null && checkedFilterDataAry.length>0)
		{
			checkedFilterMp = new HashMap();
			for(int i=0;i<checkedFilterDataAry.length;i++)
			{
				String filterStrByMeasure = checkedFilterDataAry[i];
				if(filterStrByMeasure!=null && filterStrByMeasure.length()>0 && filterStrByMeasure.indexOf("#")>-1)
				{
					String columnName = filterStrByMeasure.substring(0,filterStrByMeasure.indexOf("#"));
					String columnVals = filterStrByMeasure.substring(filterStrByMeasure.indexOf("#")+1,filterStrByMeasure.length());
					if(columnVals.length()>0)
					{
						String columnValAry[] = columnVals.split(",");
						List columnValLst = Arrays.asList(columnValAry);
						checkedFilterMp.put(columnName,columnValLst);
						totalCheckedCount = totalCheckedCount+columnValLst.size();
					}
				}
			}
		}
	}
	String forUniqueData = request.getParameter("forUniqueData");
	String measures = reportInfo.getValue("RUM_SNAPSHOT","RUMTest_DispMeasure");
	String filterMeasure = reportInfo.getValue("RUM_SNAPSHOT","RUMTest_FilterMeasure");
	String needUserExperience = reportInfo.getValue("RUM_SNAPSHOT","needUserExperience");
	ArrayList filterDataAry = new ArrayList();
	ArrayList filterByMeasure = new ArrayList();
	HashMap filterMeasureInfo = new HashMap();
	System.out.println("forUniqueData______ "+forUniqueData);
	if(request.getParameter("isSubmit")!=null && resultList!=null && resultList.size()>0)
	{
		if(summaryMap!=null && summaryMap.size()>0)
		{
			lst.add(" ");
			Vector v_measure_csv_summary = new Vector();
			v_measure_csv_summary.add(" ");
			v_measure_csv_summary.add("Transaction count");
			v_measure_csv_summary.add("Healthy");
			v_measure_csv_summary.add("Slow");
			v_measure_csv_summary.add("Error");
			v_measure_csv_summary.add("Respone Time(Avg)");
			v_measure_csv_summary.add("Unique Transaction");
			List list_data_summary = new LinkedList();
			
			HashMap summaryMapUI = new HashMap(summaryMap);
			String totalCountStr = (String)summaryMapUI.get("TOTALCOUNT");
			String responseTimeStr = (String)summaryMapUI.get("RESPONSETIME");
			String urlCountStr = (String)summaryMapUI.get("URLCOUNT");
			String healthyStr = (String)summaryMapUI.get("HEALTHY");
			String slowStr = (String)summaryMapUI.get("SLOW");
			String errorStr = (String)summaryMapUI.get("ERROR");
			if(totalCountStr==null || totalCountStr.equalsIgnoreCase("null"))
			{
				totalCountStr = "0";
			}
			if(responseTimeStr==null || responseTimeStr.equalsIgnoreCase("null"))
			{
				responseTimeStr = "0";
			}
			if(urlCountStr==null || urlCountStr.equalsIgnoreCase("null"))
			{
				urlCountStr = "0";
			}
			if(healthyStr==null || healthyStr.equalsIgnoreCase("null"))
			{
				healthyStr = "0";
			}
			if(slowStr==null || slowStr.equalsIgnoreCase("null"))
			{
				slowStr = "0";
			}
			if(errorStr==null || errorStr.equalsIgnoreCase("null"))
			{
				errorStr = "0";
			}

			double totalCount = Double.parseDouble(totalCountStr);
			double responseTime = Double.parseDouble(responseTimeStr);
			double urlCount = Double.parseDouble(urlCountStr);
			double healthy = Double.parseDouble(healthyStr);
			double slow = Double.parseDouble(slowStr);
			double error = Double.parseDouble(errorStr);

			healthyStr = erUtils.roundOffDigit((healthy/totalCount)*100,1);
			slowStr = erUtils.roundOffDigit((slow/totalCount)*100,1);
			errorStr =  erUtils.roundOffDigit((error/totalCount)*100,1);

			summaryMapUI.put("HEALTHY",healthyStr+"#"+healthy);
			summaryMapUI.put("SLOW",slowStr+"#"+slow);
			summaryMapUI.put("ERROR",errorStr+"#"+error);
			summaryMapUI.put("RESPONSETIME",erUtils.roundOffDigit(responseTime,2));
			
			list_data_summary.add(" ");
			list_data_summary.add(summaryMapUI.get("TOTALCOUNT"));
			list_data_summary.add(summaryMapUI.get("HEALTHY"));
			list_data_summary.add(summaryMapUI.get("SLOW"));
			list_data_summary.add(summaryMapUI.get("ERROR"));
			list_data_summary.add(summaryMapUI.get("RESPONSETIME"));
			list_data_summary.add(summaryMapUI.get("URLCOUNT"));

			rootjson.put("Summary",summaryMapUI);
			String s_title_summary= "Summary";
			Hashtable ht1 = new Hashtable();
			Hashtable sen1 = new Hashtable();
			sen1.put(v_measure_csv_summary,list_data_summary);
			ht1.put(s_title_summary,sen1);
			lst.add(ht1);
		}
		boolean isCustomPaging = true;
		Map otherInfo = (HashMap)session.getAttribute("RUM_SNAPSHOT_OTHER");
		if(otherInfo == null)
		{
			otherInfo = (HashMap)request.getAttribute("RUM_SNAPSHOT_OTHER");
		}
		if(otherInfo!=null && otherInfo.size()>0)
		{
			JSONObject otherInfoJson = new JSONObject();
			otherInfoJson.put("isRangeNeed", (String)otherInfo.get("isRangeNeed"));
			otherInfoJson.put("overAllRecCount", (String)otherInfo.get("overAllRecCount"));
			otherInfoJson.put("dataPageNo", (String)otherInfo.get("dataPageNo"));
			otherInfoJson.put("recordPerPage", (String)otherInfo.get("recordPerPage"));
			rootjson.put("OTHER_INFO",otherInfoJson);
			if(!(((String)otherInfo.get("isRangeNeed")).equalsIgnoreCase("true")) && ((String)otherInfo.get("dataPageNo")).equalsIgnoreCase("1"))
			{
				isCustomPaging = false;
			}
		}
		Vector v_measure_csv = new Vector();
		List list_data = new LinkedList();
		String[] measuresValLst = measures.split(",");
		String[] measuresLst = new String[measuresValLst.length];
		String[] measuresDispLst = new String[measuresValLst.length];
		for(int i=0;i<measuresValLst.length;i++)
		{
			String colName = measuresValLst[i];
			String dispCol = colName;
			if(colName!=null && colName.indexOf("#")>-1)
			{
				dispCol = dispCol.substring(dispCol.indexOf("#")+1,dispCol.length());
				colName = colName.substring(0,colName.indexOf("#"));
			}
			else
			{
				dispCol = intlmap.getMeasureDescription((String)totalTestlst.get(0), colName);
			}
			measuresLst[i] = colName;
			measuresDispLst[i] = dispCol;
		}
		if(filterMeasure!=null && filterMeasure.length()>0)
		{
			String filterMeasureAry[] = filterMeasure.split(",");
			if(filterMeasureAry.length>0)
			{
				for(int i=0;i<filterMeasureAry.length;i++)
				{
					String filterMeasureVal = filterMeasureAry[i];
					System.out.println("filterMeasureVal________ "+filterMeasureVal);
					HashMap measureWiseMap = new HashMap();
					String tempMes = filterMeasureVal.substring(0,filterMeasureVal.indexOf("#"));
					String tempDispMes = filterMeasureVal.substring(filterMeasureVal.indexOf("#")+1,filterMeasureVal.length());
					HashMap measureInfoMap = new HashMap();
					measureInfoMap.put("groupHead",intlmap.getTextDescription("reporter.common."+tempDispMes));
					measureInfoMap.put("id",tempMes);
					measureWiseMap.put(tempMes,measureInfoMap);
					filterDataAry.add(measureWiseMap);
					filterByMeasure.add(tempMes);
				}
			}
		}
		if(needUserExperience!=null && needUserExperience.equalsIgnoreCase("yes"))
		{
			// fill state info i.e., healthy,slow,error
			HashMap measureInfoMapTemp = new HashMap();
			HashMap measureWiseMapTemp = new HashMap();
			measureInfoMapTemp.put("groupHead",intlmap.getTextDescription("reporter.common.User Experience"));
			measureInfoMapTemp.put("id","User_Experience");
			measureWiseMapTemp.put("User_Experience",measureInfoMapTemp);
			if(filterDataAry.size()>0)
			{
				filterDataAry.add(0,measureWiseMapTemp);
			}
			else
			{
				filterDataAry.add(measureWiseMapTemp);
			}
		}
		TreeSet filterValue = new TreeSet();
		filterValue.add("Healthy");
		filterValue.add("Slow");
		filterValue.add("Error");
		filterMeasureInfo.put("User_Experience",filterValue);
		if(true)
		{
			// fill user Satisfaction info i.e., Satisfied,Tolerating,Frustrated
			HashMap measureInfoMapTemp = new HashMap();
			HashMap measureWiseMapTemp = new HashMap();
			measureInfoMapTemp.put("groupHead",intlmap.getTextDescription("reporter.common.User Satisfaction"));
			measureInfoMapTemp.put("id","User_Satisfaction");
			measureWiseMapTemp.put("User_Satisfaction",measureInfoMapTemp);
			if(filterDataAry.size()>1)
			{
				filterDataAry.add(1,measureWiseMapTemp);
			}
			else
			{
				filterDataAry.add(measureWiseMapTemp);
			}
		}
		filterValue = new TreeSet();
		filterValue.add("Satisfied");
		filterValue.add("Tolerating");
		filterValue.add("Frustrated");
		filterMeasureInfo.put("User_Satisfaction",filterValue);
		
		JSONObject gridObj = new JSONObject();
		JSONArray gridCol = new JSONArray();
		JSONArray gridColUI = new JSONArray();
		gridCol.add("User Experience");
		gridColUI.add(intlmap.getTextDescription("reporter.common.User Experience"));
		v_measure_csv.add(intlmap.getTextDescription("reporter.common.User Experience"));
		for(int i=0;i<measuresLst.length;i++)
		{
			String colName = measuresLst[i];
			String dispCol = measuresDispLst[i];
			gridCol.add(dispCol);
			gridColUI.add(intlmap.getTextDescription("reporter.common."+dispCol));
			v_measure_csv.add(intlmap.getTextDescription("reporter.common."+dispCol));
		}
		JSONArray dataAry = new JSONArray();
		for(int i=0; i<resultList.size();i++)
		{
			Map dataMap = (HashMap)resultList.get(i);
			JSONArray data = new JSONArray();
			String state = (String)dataMap.get("RUM_EXPERIENCE");
			if(state!=null)
				state = state.toLowerCase();
			// urlQStr  ="var urlToGo = 'EgRUMTopology.jsp?rumGuid='+guidString+"&testName="+test+"&comesFrom=MyDashboard&myDashboardTheme="+strSkin";
			String ddUrl = "/final/monitor/EgRUMTopology.jsp?isReporterRequest=yes&";
			ddUrl+="rumGuid="+dataMap.get("GUID")+"&testName=RUMAppTest&comesFrom=MyDashboard&myDashboardTheme="+reporter_Skin;
			ddUrl+="#@#"+state;
			data.add(ddUrl);
			list_data.add(state);
			for(int j=0;j<measuresLst.length;j++)
			{
				String measure = measuresLst[j];
				String appendMesure = "";
				if(measure.equalsIgnoreCase("REQUEST_DATE"))
				{
					appendMesure = " - "+dataMap.get("REQUEST_TIME_ZONE");
				}
				if(measure.equalsIgnoreCase("APPLICATION_NAME"))
				{
					if(dataMap.get("PORT_NO")!=null)
					{
						appendMesure = ":"+dataMap.get("PORT_NO");
					}	
				}
				String gridDataVal = (String)dataMap.get(measure);
				if(gridDataVal!=null)
				{
					data.add(gridDataVal+appendMesure);
					list_data.add(gridDataVal+appendMesure);
					if(filterByMeasure!=null && filterByMeasure.contains(measure) && !gridDataVal.equals("-"))
					{
						filterValue = (TreeSet)filterMeasureInfo.get(measure);
						if(filterValue!=null)
						{
							filterValue.add(gridDataVal);
						}
						else
						{
							filterValue = new TreeSet();
							filterValue.add(gridDataVal);
							filterMeasureInfo.put(measure,filterValue);
						}
					}
				}
				else
				{
					data.add("-");
					list_data.add("-");
				}
			}
			dataAry.add(data);
		}
		String fromRunBtn = request.getParameter("fromRunBtn");
		if(fromRunBtn!=null && fromRunBtn.equalsIgnoreCase("yes"))
		{
			if(isCustomPaging && filterByMeasure!=null && filterByMeasure.size()>0)
			{
				// process Server side 
				for(int i=0;i<filterByMeasure.size();i++)
				{
					String filterMes = (String)filterByMeasure.get(i);
					filterValue = (TreeSet)filterMeasureInfo.get(filterMes);
					if(filterValue==null || filterValue.size()<6)
					{
						ErRUMSnapshotReportBean appBean = new ErRUMSnapshotReportBean();
						appBean.initRequest(request);
						Vector distinctData = null;
						distinctData = appBean.getDistinctDataForRUM(filterMes,"6");
						if(distinctData!=null && distinctData.size()>0)
						{
							if(filterValue==null || filterValue.size()==0)
							{
								filterValue = new TreeSet();
								filterValue.addAll(distinctData);
							}
							else
							{
								for(int j=0;j<distinctData.size();j++)
								{
									String dbData = (String)distinctData.get(j);
									if(filterValue.size()<6)
									{
										filterValue.add(dbData);
									}
								}
							}
							filterMeasureInfo.put(filterMes,filterValue);
						}
					}
				}
			}
			session.setAttribute("filteredMeasureInfo",filterMeasureInfo);
		}
		HashMap filterMeasureInfoTemp = (HashMap)session.getAttribute("filteredMeasureInfo");
		if(filterMeasureInfoTemp!=null)
		{
			filterMeasureInfo = filterMeasureInfoTemp;
		}
		JSONArray filterDetails = new JSONArray();
		session.setAttribute("filterDataAry",filterDataAry);
		System.out.println("filterMeasureInfo________ "+filterMeasureInfo);
		if(filterDataAry!=null)
		{
			for(int i=0;i<filterDataAry.size();i++)
			{
				HashMap measureWiseMap = (HashMap)filterDataAry.get(i);
				Iterator itrInfo = measureWiseMap.entrySet().iterator();
				while(itrInfo.hasNext())
				{
					Map.Entry map=(Map.Entry)itrInfo.next();
					String keyVal = (String)map.getKey();
					HashMap measureInfoMap = (HashMap)measureWiseMap.get(keyVal);
					String maxView = "yes";
					String clearView = "yes";
					if(keyVal!=null && (keyVal.equalsIgnoreCase("User_Experience")||keyVal.equalsIgnoreCase("User_Satisfaction")))
					{
						maxView = "no";
					}
					List columnValLst = new ArrayList();
					if(checkedFilterMp!=null && checkedFilterMp.get(keyVal)!=null)
					{
						columnValLst = (List)checkedFilterMp.get(keyVal);
					}
					if(filterMeasureInfo!=null && filterMeasureInfo.get(keyVal)!=null)
					{
						filterValue = (TreeSet)filterMeasureInfo.get(keyVal);
						if(filterValue.size()==1)
						{
							clearView = "no";
							// If uncomment, single value in filter is not visible.
							//continue;
						}
						if(filterValue.size()<=5)
						{
							maxView = "no";
						}
						Iterator itr = filterValue.iterator(); 
						int count = 0;
						ArrayList childAry = new ArrayList();
						while (itr.hasNext()) 
						{
							if(count==5) // shows only 5 value in UI
							{
								break;
							}
							String filterStr = (String)itr.next();
							JSONObject childObj = new JSONObject();
							if(keyVal!=null && (keyVal.equalsIgnoreCase("User_Experience")||keyVal.equalsIgnoreCase("User_Satisfaction")))
							{
								childObj.put("name",intlmap.getTextDescription("reporter.common."+filterStr));
							}
							else
							{
								childObj.put("name",filterStr);
							}
							childObj.put("value",filterStr);
							childObj.put("index",count);
							if(columnValLst.contains(filterStr))
							{
								childObj.put("isChecked",true);
							}
							else
							{
								childObj.put("isChecked",false);
							}
							childAry.add(childObj);
							count++;
						}
						if(keyVal!=null && (keyVal.equalsIgnoreCase("User_Experience")||keyVal.equalsIgnoreCase("User_Satisfaction"))) // swaping User Experience and User Satisfaction child data
						{
							JSONObject childObj = (JSONObject)childAry.get(0);
							childAry.remove(0);
							childAry.add(childObj);
						}
						measureInfoMap.put("maxView",maxView);
						measureInfoMap.put("checkedList",columnValLst);
						measureInfoMap.put("clear",clearView);
						measureInfoMap.put("child",childAry);
						filterDetails.add(measureInfoMap);
					}
				}
			}
		}
		if(filterDetails.size()>0)
		{
			rootjson.put("filterDetails",filterDetails);
		}
		rootjson.put("totalCheckedCount",totalCheckedCount);
		gridObj.put("gridCol",gridCol);
		gridObj.put("gridColUI",gridColUI);
		gridObj.put("gridData",dataAry);
		rootjson.put("gridObj",gridObj);
		rootjson.put("selectionDetails",selectionDetails);
		//pageWith=1024+gridCol.size() * 200;
		Hashtable mainTableRec = new Hashtable();	//SubTable Data
		Hashtable h_tab = new Hashtable();	//SubTitle with SubTable Data
		String s_title = "";

		mainTableRec.put(v_measure_csv,list_data);
		h_tab.put(s_title,mainTableRec);
		lst.add(h_tab);
		if(lst!= null && !lst.isEmpty())
		{
			session.setAttribute("list",lst);
		}
	}
	else if (forUniqueData!=null && forUniqueData.equalsIgnoreCase("yes"))
	{
		Vector uniqueData = (Vector)session.getAttribute("RUM_UNIQUE_DATA");
		System.out.println("uniqueData__________ "+uniqueData);
		if(uniqueData!=null && uniqueData.size()>0)
		{
			filterMeasure+=",User_Experience#User Experience,User_Satisfaction#User Satisfaction";
			String filterMeasureAry[] = filterMeasure.split(",");
			String columnName = request.getParameter("columnName");
			if(filterMeasureAry.length>0)
			{
				for(int i=0;i<filterMeasureAry.length;i++)
				{
					String filterMeasureVal = filterMeasureAry[i];
					String tempMes = filterMeasureVal.substring(0,filterMeasureVal.indexOf("#"));
					String tempDispMes = filterMeasureVal.substring(filterMeasureVal.indexOf("#")+1,filterMeasureVal.length());
					if(columnName==null || !columnName.equalsIgnoreCase(tempMes))
					{
						continue;
					}
					HashMap measureWiseMap = new HashMap();
					HashMap measureInfoMap = new HashMap();
					measureInfoMap.put("groupHead",intlmap.getTextDescription("reporter.common."+tempDispMes));
					measureInfoMap.put("id",tempMes);
					measureWiseMap.put(tempMes,measureInfoMap);
					filterDataAry.add(measureWiseMap);
					filterByMeasure.add(tempMes);
				}
			}
			if(filterByMeasure!=null && filterByMeasure.contains(columnName))
			{
				Iterator uni_itr = uniqueData.iterator();
				while(uni_itr.hasNext())
				{
					String vectVal = (String)uni_itr.next();
					TreeSet filterValue = (TreeSet)filterMeasureInfo.get(columnName);
					if(vectVal!=null && vectVal.length()>0 && !vectVal.equals("-"))
					{
						if(filterValue!=null)
						{
							filterValue.add(vectVal);
						}
						else
						{
							filterValue = new TreeSet();
							filterValue.add(vectVal);
							filterMeasureInfo.put(columnName,filterValue);
						}
					}
				}
			}
			JSONArray filterDetails = new JSONArray();
			if(filterDataAry!=null)
			{
				for(int i=0;i<filterDataAry.size();i++)
				{
					HashMap measureWiseMap = (HashMap)filterDataAry.get(i);
					Iterator itrInfo = measureWiseMap.entrySet().iterator();
					while(itrInfo.hasNext())
					{
						Map.Entry map=(Map.Entry)itrInfo.next();
						String keyVal = (String)map.getKey();
						HashMap measureInfoMap = (HashMap)measureWiseMap.get(keyVal);
						String maxView = "yes";
						String clearView = "yes";
						if(keyVal!=null && (keyVal.equalsIgnoreCase("User_Experience")||keyVal.equalsIgnoreCase("User_Satisfaction")))
						{
							maxView = "no";
						}
						List columnValLst = new ArrayList();
						if(checkedFilterMp!=null && checkedFilterMp.get(keyVal)!=null)
						{
							columnValLst = (List)checkedFilterMp.get(keyVal);
						}
						if(filterMeasureInfo!=null && filterMeasureInfo.get(keyVal)!=null)
						{
							TreeSet filterValue = (TreeSet)filterMeasureInfo.get(keyVal);
							Iterator itr = filterValue.iterator(); 
							int count = 0;
							ArrayList childAry = new ArrayList();
							while (itr.hasNext()) 
							{
								/*if(count==5) // shows only 5 value in UI
								{
									break;
								}*/
								String filterStr = (String)itr.next();
								JSONObject childObj = new JSONObject();
								if(keyVal!=null && (keyVal.equalsIgnoreCase("User_Experience")||keyVal.equalsIgnoreCase("User_Satisfaction")))
								{
									childObj.put("name",intlmap.getTextDescription("reporter.common."+filterStr));
								}
								else
								{
									childObj.put("name",filterStr);
								}
								childObj.put("value",filterStr);
								if(columnValLst.contains(filterStr))
								{
									childObj.put("isChecked",true);
								}
								else
								{
									childObj.put("isChecked",false);
								}
								childAry.add(childObj);
								count++;
							}
							measureInfoMap.put("maxView",maxView);
							measureInfoMap.put("checkedList",columnValLst);
							measureInfoMap.put("clear",clearView);
							measureInfoMap.put("child",childAry);
							filterDetails.add(measureInfoMap);
						}
					}
				}
			}
			if(filterDetails.size()>0)
			{
				rootjson.put("filterDetails",filterDetails);
				rootjson.put("filterDetailsDummy",filterDetails);
			}
		}
	}
	else
	{
		rootjson.put("NO_DATA","Yes");
		JSONArray filterDetails = new JSONArray();
		filterDataAry = (ArrayList)session.getAttribute("filterDataAry");
		filterMeasureInfo = (HashMap)session.getAttribute("filteredMeasureInfo");
		if(filterDataAry!=null)
		{
			for(int i=0;i<filterDataAry.size();i++)
			{
				HashMap measureWiseMap = (HashMap)filterDataAry.get(i);
				Iterator itrInfo = measureWiseMap.entrySet().iterator();
				while(itrInfo.hasNext())
				{
					Map.Entry map=(Map.Entry)itrInfo.next();
					String keyVal = (String)map.getKey();
					HashMap measureInfoMap = (HashMap)measureWiseMap.get(keyVal);
					String maxView = "yes";
					String clearView = "yes";
					if(keyVal!=null && (keyVal.equalsIgnoreCase("User_Experience")||keyVal.equalsIgnoreCase("User_Satisfaction")))
					{
						maxView = "no";
					}
					List columnValLst = new ArrayList();
					if(checkedFilterMp!=null && checkedFilterMp.get(keyVal)!=null)
					{
						columnValLst = (List)checkedFilterMp.get(keyVal);
					}
					if(filterMeasureInfo!=null && filterMeasureInfo.get(keyVal)!=null)
					{
						TreeSet filterValue = (TreeSet)filterMeasureInfo.get(keyVal);
						Iterator itr = filterValue.iterator(); 
						int count = 0;
						ArrayList childAry = new ArrayList();
						while (itr.hasNext()) 
						{
							if(count==5) // shows only 5 value in UI
							{
								break;
							}
							String filterStr = (String)itr.next();
							JSONObject childObj = new JSONObject();
							if(keyVal!=null && (keyVal.equalsIgnoreCase("User_Experience")||keyVal.equalsIgnoreCase("User_Satisfaction")))
							{
								childObj.put("name",intlmap.getTextDescription("reporter.common."+filterStr));
							}
							else
							{
								childObj.put("name",filterStr);
							}
							childObj.put("value",filterStr);
							if(columnValLst.contains(filterStr))
							{
								childObj.put("isChecked",true);
							}
							else
							{
								childObj.put("isChecked",false);
							}
							childAry.add(childObj);
							count++;
						}
						measureInfoMap.put("maxView",maxView);
						measureInfoMap.put("checkedList",columnValLst);
						measureInfoMap.put("clear",clearView);
						measureInfoMap.put("child",childAry);
						filterDetails.add(measureInfoMap);
					}
				}
			}
		}
		if(filterDetails.size()>0)
		{
			rootjson.put("filterDetails",filterDetails);
		}
		rootjson.put("totalCheckedCount",totalCheckedCount);
		lst.add(intlmap.getTextDescription("reporter.common.No measures available for the current selection"));
	}

	Map parameters = new HashMap();
	parameters= request.getParameterMap();
	String queryString =(String)ErUtils.prepareQueryString(request.getParameterMap());
	String Qstring="";
	String lastAccessQstring="";
	if(queryString!=null)
	{
		StringTokenizer strtok = new StringTokenizer(queryString,"&");
		while(strtok.hasMoreTokens())
		{
			String param = strtok.nextToken();
			int ind = param.indexOf("=");
			if (ind < 0)
				continue;
			String reqparam =param.substring(0,ind);
			String value = param.substring(ind+1);
			 if(reqparam!=null&&reqparam.equals("userID"))
			{
				value=com.eg.EgURLEncoder.encode(value, "UTF-8");
			}
			 if(reqparam!=null&&reqparam.equals("uid"))
			{
				value=com.eg.EgURLEncoder.encode(value, "UTF-8");
			}
			 if(reqparam!=null && ( reqparam.equals("startdate") || reqparam.equals("enddate") || reqparam.equals("inidate") || reqparam.equals("pdfTime") || reqparam.equals("select_testmes") || reqparam.equals("er_workgrpname") || reqparam.equals("er_trgttype") || reqparam.equals("limitforbg") || reqparam.equals("er_timeline") || reqparam.equals("er_usertimeline")  || reqparam.equals("limitforbg") || reqparam.equals("limitforbg")) )
			{
				value=com.eg.EgURLEncoder.encode(value, "UTF-8");
			}
			if(reqparam.equals("checkedFilterData"))
			{
				value = erUtils.specialCharEncode(checkedFilterData);
			}
			
				lastAccessQstring=lastAccessQstring+reqparam+"="+value+"&";
					
			if(reqparam!=null&&reqparam.equals("er_component"))
			{
				continue;
			}

			Qstring=Qstring+reqparam+"="+value+"&";
		}
		Qstring=Qstring;
	}
	Qstring+="&pageWidthProces="+pageWith;
	String dataProcess = mngrIProc+"/final/reporter/RUMSnapshotPrint.jsp;jsessionid="+ session.getId()+"?"+Qstring;

	session.setAttribute("MAIL_URL",dataProcess);
	HashMap hmQry = ErUtils.parseQueryString(Qstring);
	String targetType = "";
	if(hmQry != null && hmQry.get("er_trgttype") instanceof String)
	{
		targetType = (String)hmQry.get("er_trgttype");
	}
	else if(hmQry != null && hmQry.get("er_trgttype") instanceof String[])
	{
		targetType = ((String[])hmQry.get("er_trgttype"))[0];
	}
	String qString = ErUtils.prepareQueryString(hmQry);
	urlFields.put("saveQueryString",qString);
	//
	ArrayList listbackvar = new  ArrayList();
	if(request.getParameter("isSubmit")!=null)
	{
		if(overAllRecCount==null)
		{
			session.setAttribute("reportLastAccessedURL","/final/reporter/RUMSnapshot.jsp?"+lastAccessQstring);
			listbackvar.add("/servlet/com.eg.ErRUMSnapshotC?");
			listbackvar.add("status="+status+"&bggroundStr="+bggroundStr+"&"+queryString);
			session.setAttribute("favSchBackDisplay","Yes");
		}
	}
	else
	{
		session.setAttribute("reportLastAccessedURL","/final/reporter/RUMSnapshot.jsp?"+lastAccessQstring);
		listbackvar.add("RUMSnapshot.jsp");
		listbackvar.add(queryString);
		session.setAttribute("favSchBackDisplay","No");
	}
	session.setAttribute("reportLastAccessedURL","/final/reporter/RUMSnapshot.jsp?"+lastAccessQstring);
	String backadded = erhelputils.getBackID();
	backreqMap = erhelputils.setBackQueryMap(backreqMap,backadded,listbackvar);
	session.setAttribute("backQuery",backreqMap);
	rootjson.put("selectedFields",selectedFields);
	rootjson.put("hiddenFields",hiddenFields);
	rootjson.put("combo",combo);
	rootjson.put("labelFields",labelFields);
	rootjson.put("urlFields",urlFields);
	out.println(rootjson.toString());
}
catch(Exception t)
{
	t.printStackTrace();
}

	//For Setting the PDf File Name
	HashMap paramVal =new HashMap();
	paramVal.put("fileName","RUM_SNAPSHOT_Report");
	session.setAttribute("parameters", paramVal);
%>
 <%!
   public synchronized JSONArray getJSONComboFromList(List list,String infoVal,EgMappingInfo intlmap, boolean allSupport, String ui_text,boolean isCompType)
   {
		JSONArray arr=new JSONArray();
		JSONObject obj=null;
		if(list !=null && list.size()>0)
		{
			if(allSupport)
			{
				obj=new JSONObject();
				obj.put("displayField",ui_text);
				obj.put("valueField","All");
				arr.add(obj);
			}
			for (int i=0;i<list.size();i++)
			{
				String text=(String)list.get(i);
				String dispText=text;
				if(dispText.indexOf(":")>-1)
				{
					dispText = dispText.substring(0,dispText.lastIndexOf(":"));
				}
				obj=new JSONObject();
				if(isCompType)
				{
					obj.put("displayField",intlmap.getComponentTypeDescription(dispText));
				}
				else
				{
					if(dispText.equalsIgnoreCase("--Default--"))
					{
						dispText = intlmap.getTextDescription("reporter.common.--Default--");
					}
					if(dispText.endsWith(":NULL"))
					{
						dispText = dispText.substring(0,dispText.lastIndexOf(":"));
					}
					obj.put("displayField",dispText);
				}
				obj.put("valueField",text);
				arr.add(obj);
			}	
		}
		else
		{
			obj=new JSONObject();
			obj.put("displayField",intlmap.getTextDescription("reporter.common.Not Applicable"));
			obj.put("valueField","-1");
			arr.add(obj);
		}
		return arr;
	}
    public  String customReplaceAll(String source,String toReplace,String replacement) 
	{
        int idx = source.lastIndexOf(toReplace);
        if (idx != -1) 
		{
            StringBuffer ret = new StringBuffer(source);
            ret.replace(idx, idx + toReplace.length(), replacement);
            while ((idx = source.lastIndexOf(toReplace, idx - 1)) != -1) 
			{
                ret.replace(idx, idx + toReplace.length(), replacement);
            }
            source = ret.toString();
        }
        return source;
    }
%>