<!DOCTYPE html>

<%
/*******************************************************************************
*	File name			:	ErVDIAssessmentDrillDown.jsp
*	Purpose				:	DrillDown Page For Virtual Desktop Insight - VDI Assessment
*	Author				:	A.MuraliKanth
*	Creation Date		:	27/11/2012 - (dd/mm/yyyy)
********************************************************************************/
%>
<%@ include file="ErTracker.jsp" %>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ page import = "com.egurkha.util.*" %>
<%@ page import = "com.eg.EgReportInfo"%>
<%@ page import = "egurkha.reporter.ErUtils" %>
<%@ page import = "com.eg.EgMappingInfo" %>
<%@ page import = "com.eg.MappingNameSorter"%>
<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>

<%
	try
	{
		IniUI ui = IniUI.getInstance();
		UserRegistry tregistry = UserRegistry.getInstance();
		User tuser = tregistry.getUser(session.getId());
		String thisLanguage = ui.getDefaultLanguage();
		MappingNameSorter sorter = new MappingNameSorter(thisLanguage);
		if (tuser!=null)
		{
			String userLang = tuser.getLanguage();
			if (userLang!=null && !userLang.equalsIgnoreCase("NULL"))
			{
				thisLanguage=userLang;
			}
		}
		EgMappingInfo intlmap = new EgMappingInfo(thisuser.getLanguage());

		String subjectForChart ="";

		EgReportInfo reportInfo = new EgReportInfo("manager");
		ErUtils erUtils = new ErUtils();

		HashMap MeasureGroupWithUnit=null;
		HashMap unitForMeasure=null;
		ArrayList overAllData=null;
		ArrayList DataAvailableMeasureGroup=null;

		String reportType=request.getParameter("reporttype");
		String subType=request.getParameter("subtype");
		String measureGroup=request.getParameter("measureGroup");
		String measureGroupDisp = "";
		if(measureGroup!=null)
		{
			measureGroupDisp = StringUtils.replace(measureGroup,"_"," ");
		}
		String analyseDataBy=request.getParameter("analyseDataBy");
		String er_ranage=request.getParameter("er_ranage");
		if(er_ranage!=null && er_ranage.length()>0)
			er_ranage = erUtils.specialCharDecode(er_ranage);

		if(reportType!=null && reportType.equalsIgnoreCase("vdi_insight"))
		{
			if(subType!=null && subType.equalsIgnoreCase("resource_usage"))
			{
				subjectForChart = "Desktop_Insight_Resource_Usage_Chart_Details";
				MeasureGroupWithUnit=(HashMap)session.getAttribute("MeasureGroupWithUnit");
				overAllData=(ArrayList)session.getAttribute("overAllDataByDesktop");
				DataAvailableMeasureGroup=(ArrayList)session.getAttribute("DataAvailableMeasureGroup");
			}
			else if(subType!=null && subType.equalsIgnoreCase("application_activity"))
			{
				
				subjectForChart = "Desktop_Insight_Application_Activity";
				overAllData=(ArrayList)session.getAttribute("overallDataByAppln");
				unitForMeasure = (HashMap)session.getAttribute("unitForMeasure");
				DataAvailableMeasureGroup=(ArrayList)session.getAttribute("DataAvailableMeasureGroups");
			}
		}
		Float minusFive = new Float(-5.0f);
		int noOfColumn=DataAvailableMeasureGroup.size();
		int columnId=0;
		int sortbyColumnhighlight=0;
		if(measureGroup!=null)
		{
			columnId=DataAvailableMeasureGroup.indexOf(measureGroup);
			sortbyColumnhighlight=columnId+1;
		}
		if(columnId==-1)
			columnId=0;
		EgSorter sortObj = new EgSorter(overAllData,noOfColumn);
		columnId+=2;
		overAllData=(ArrayList)sortObj.sort(columnId,"Float","desc");
		float minVal = 0.0f;
		float maxVal = 0.0f;
		try{
			if(er_ranage!=null && er_ranage.indexOf("-")>-1)
			{
				String strMinVal = er_ranage.substring(0,er_ranage.indexOf("-"));
				String strMaxVal = er_ranage.substring(er_ranage.indexOf("-")+1);
				strMaxVal = strMaxVal.trim();
				if(strMaxVal.indexOf(" ")>-1)
					strMaxVal = strMaxVal.substring(0,strMaxVal.indexOf(" ")); 
				minVal = Float.parseFloat(strMinVal.trim());
				maxVal = Float.parseFloat(strMaxVal.trim());
			}
			else if(er_ranage!=null && er_ranage.indexOf(">")>-1)
			{
				String strMaxVal = er_ranage.substring(er_ranage.indexOf(">")+1);
				strMaxVal = strMaxVal.trim();
				if(strMaxVal.indexOf(" ")>-1)
					strMaxVal = strMaxVal.substring(0,strMaxVal.indexOf(" "));	
				minVal = Float.parseFloat(strMaxVal.trim());
				maxVal = Float.parseFloat(strMaxVal.trim());
			}
			else if(er_ranage!=null && er_ranage.indexOf("<")>-1)
			{
				String strMaxVal = er_ranage.substring(er_ranage.indexOf("<")+1);
				strMaxVal = strMaxVal.trim();
				if(strMaxVal.indexOf(" ")>-1)
					strMaxVal = strMaxVal.substring(0,strMaxVal.indexOf(" ")); 
				minVal = Float.parseFloat(strMaxVal.trim());
				maxVal = Float.parseFloat(strMaxVal.trim());
			}  
			/*else if(er_ranage!=null &&  er_ranage.indexOf("&gt;")>-1)
			{
				String strMaxVal = er_ranage.substring(er_ranage.indexOf("&gt;")+4);
				minVal = Float.parseFloat(strMaxVal.trim());
				maxVal = Float.parseFloat(strMaxVal.trim());
			}
			else if(er_ranage!=null &&  er_ranage.indexOf("&lt;")>-1)	  //..prakash for checking lessthan condiion
			{
				String strMaxVal = er_ranage.substring(er_ranage.indexOf("&lt;")+4);
				minVal = Float.parseFloat(strMaxVal.trim());
				maxVal = Float.parseFloat(strMaxVal.trim());
			}	*/
					
		}catch(Exception e){ e.printStackTrace();}
%>
<!Doctype html>
<head>

<meta name="Author" content="">
<meta  charset="UTF-8">

<link rel="stylesheet" type="text/css" href="../../final/styles/eGLightThemeIcons.css" />
<link rel="stylesheet" type="text/css" href="../../final/reporter/styles/printpagestyle.css" />

<style type="text/css" media="print">
#printbt, #csvbt, #savebt{ display:none}
</style>

<script>
function closeParendWidow()
{
	if(window.parent.Ext.getCmp('maximizeWindowLightBox')!=undefined)
			window.parent.Ext.getCmp('maximizeWindowLightBox').doClose();
}
</script>

</head>
<body marginwidth="20" marginheight="20" bgcolor="#FFFFFF" style="padding:0px 10px 10px 10px;margin-top:40px">

<%
		if(reportType!=null && reportType.equalsIgnoreCase("vdi_insight"))
		{
			if(subType!=null && subType.equalsIgnoreCase("resource_usage"))
			{
%>
	   <div class="printHeaderBox">
<!--<table width="100%" border="0" cellspacing="0" cellpadding="0" align="center"  style="border-bottom:1px solid #999;">
	<tr>
		<td style="padding:2px">-->
			<!--<div style="float:left" > <header><%=intlmap.getTextDescription("reporter.common.DESKTOPS RESOURCE USAGE DETAILS")%></header></div>-->
			<div class="printHeaderBoxTitle"><%=intlmap.getTextDescription("reporter.common.DESKTOPS RESOURCE USAGE DETAILS")%></div>

			<!--<div style="float:right;padding-left:5px"><img class="iconPrinter mouse"  src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" border="0" onClick="javascript:window.print()" alt='<egui:intnl text="reporter.common.PRINT"/>' title='<egui:intnl text="reporter.common.PRINT"/>'/></div>-->
				<div style="float:right;margin:0px 5px 0px 5px"><img class="mouse" src="/final/images/Light/newPopupWindowClose.png" border="0" onClick="javascript:closeParendWidow();" /></div>

				<div class="printHeaderBoxPrintIcon" style="float:left"><img class="iconPrinter mouse"  id="pri ntbt" src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" border="0" onClick="javascript:window.print()" alt='<egui:intnl text="reporter.common.PRINT"/>' title='<egui:intnl text="reporter.common.PRINT"/>'/></div>
		<!--<td>
	</tr>
</table>-->
</div>
<div class="printOuterBoxNoBorder">
<!--<table width="100%" border="0" cellspacing="0" cellpadding="0" align="center" style="border-bottom:1px solid #ccc;">
	<tr>
		<td align="left" valign="top">-->
			<!--<div style="clear:both;float:left;padding:4px;">
				<div style="float:left" class="formLabel"><%=intlmap.getTextDescription("reporter.common.Data Sorted By")%><%String tmp_sort=reportInfo.getValue(subjectForChart,measureGroup);%></div>
				<div style="float:left;width:10px" align="center" >:</div>
				<div style="float:left;" class="formValue"><%=tmp_sort.substring(tmp_sort.indexOf(" on ")+4)%></div>
			</div>-->
			<div class="printSelectionFields"><%=intlmap.getTextDescription("reporter.common.Data Sorted By")%> - <span class="bold"><egui:intnl text="<%=tmp_sort.substring(tmp_sort.indexOf(" on ")+4)%>" /></span></div>

			<div class="printSelectionFields"><%=intlmap.getTextDescription("reporter.common.Data Range")%> : <span class="bold"><%=er_ranage%></span></div>
		<!--</td>
	</tr>
</table>-->
</div>
<div class="printOuterBox">
	<div class="newTable">
		<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0">
			<thead>
			<tr>
							
		<%					if(DataAvailableMeasureGroup!=null)
							{
								//Add column headers
		%>
				<th  width="30%" align="center">
								
		<%						if(analyseDataBy!=null && analyseDataBy.equals("user"))
								{
		%>
					<%=intlmap.getTextDescription("reporter.common.User")%>
		<%						}
								else
								{
		%>
					<%=intlmap.getTextDescription("reporter.common.Desktop")%>
		<%
								}
		%>
				</th>
								
		<%
						for(int i=0;DataAvailableMeasureGroup.size()>i;i++)
								{
										String measures=(String)DataAvailableMeasureGroup.get(i);
								if(measureGroup!=null && !measureGroup.equalsIgnoreCase(measures))
									continue;
										String tmp=reportInfo.getValue(subjectForChart,measures);
										String MappedMeasure=tmp.substring(tmp.indexOf(" on ")+4);
										String titlehighlight="x-grid-cell x-grid-cell-first";
										String divhighlight="x-grid-cell-inner";
										
										if(sortbyColumnhighlight==(i+1))
										{
											//titlehighlight ="odd-col";
											//divhighlight="odd-col";
										}
										
		%>

				<th width="75px"  align="center" > <%=intlmap.getTextDescription("reporter.common."+MappedMeasure)%></th>

		<%
								}
							}
		%>
			</tr>
			</thead>
			<thead>
			<tr>
				<th class="subHeader">&nbsp;</th>
		<%
							if(MeasureGroupWithUnit!=null && DataAvailableMeasureGroup!=null)
							{
		%>
								
		<%						//Add units for columns
								for(int i=0;DataAvailableMeasureGroup.size()>i;i++)
								{
									String measures=(String)DataAvailableMeasureGroup.get(i);
							if(measureGroup!=null && !measureGroup.equalsIgnoreCase(measures))
									continue;
									String unit=(String)MeasureGroupWithUnit.get(measures);
									String titlehighlight="x-grid-cell x-grid-cell-first";
									String divhighlight="x-grid-cell-inner";
									if(sortbyColumnhighlight==(i+1))
									{
										//titlehighlight ="odd-col";
										//divhighlight="odd-col";
									}
									
		%>
				<th class="subHeader" width="75px" align="center"> <%=unit%> </th>
			
		<%
								}
							}
		%>
			</tr>
			</thead>

		<%
							if(overAllData!=null && !overAllData.isEmpty())
							{
								//Row data
								for(int i=0;overAllData.size()>i;i++)
								{
									ArrayList dataList=(ArrayList)overAllData.get(i);
									String s_desktop=(String)dataList.get(0);
							Float data=(Float)dataList.get(sortbyColumnhighlight);
							boolean showData=false;
							/*if(er_ranage!=null && (er_ranage.indexOf(">")>-1 || er_ranage.indexOf("&gt;")>-1 || er_ranage.indexOf("&lt;")>-1 || er_ranage.indexOf("<")>-1) && data.doubleValue()>=maxVal)
								showData=true;
							else if(er_ranage!=null && er_ranage.indexOf("-")>-1)
								showData=true;
							else if(data.doubleValue()>=minVal && data.doubleValue()<maxVal )
								showData=true; */
							if(er_ranage!=null && er_ranage.indexOf(">")>-1 && data.doubleValue()>=maxVal)	  
							{
								showData=true;
							}
							else if(er_ranage!=null && er_ranage.indexOf("<")>-1  && data.doubleValue()>=0 && data.doubleValue()<minVal)
								showData=true;
							else if(er_ranage!=null && er_ranage.indexOf("-")>-1 && data.doubleValue() >=0 && data.doubleValue()>=minVal && data.doubleValue()<maxVal )
								showData=true;
							else if(er_ranage == null || er_ranage.length()==0 || er_ranage.equalsIgnoreCase("NULL"))
								showData=true;
							if(showData)
							{
		%>
			<tr>
				<td><b><%=s_desktop%></b></td>
		<%
										if(dataList!=null)
										{
									int j=sortbyColumnhighlight;
									//for(int j=1;dataList.size()>j;j++)
											{
												String highlightClass="x-grid-cell x-grid-cell-first";
												String divClass="x-grid-cell-inner";
												if(sortbyColumnhighlight==j)
												{
													highlightClass="odd-col";
													divClass="odd-col";
												}
										data=(Float)dataList.get(j);
												if(data.compareTo(minusFive)>0)
												{
													float f_data=data.floatValue();
		%>
				<td align="center"><%=erUtils.round(f_data,4)%></td>
		<%										}
												else
												{
		%>
				<td align="center">-</td>
		<%										}
											}
										}
		%>
			</tr>
		<%
								}
							}
					}
		%>
	</table>
	</div>	
</div>
	<%
		}
		else if(subType!=null && subType.equalsIgnoreCase("application_activity"))
		{

%>
<!--<table width="100%" border="0" cellspacing="0" cellpadding="0" align="center"  style="border-bottom:1px solid #999;">
	<tr>
		<td style="padding:2px">-->
			<!--<div style="float:left" > <header><%=intlmap.getTextDescription("reporter.common.VDI APPLICATION ACTIVITY DETAILS")%></header></div>-->
	<div class="printHeaderBox" style="padding-right:30px;position:fixed;top:0px;">
			<div class="printHeaderBoxTitle"><%=intlmap.getTextDescription("reporter.common.VDI APPLICATION ACTIVITY DETAILS")%></div>

			<div style="float:right;margin:0px 5px 0px 5px"><img class="mouse" src="/final/images/Light/newPopupWindowClose.png" border="0" onClick="javascript:closeParendWidow();" /></div>

			<div class="printHeaderBoxPrintIcon" style="float:left"><img class="iconPrinter mouse"  id="prin tbt" src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" border="0" onClick="javascript:window.print()" alt='<egui:intnl text="reporter.common.PRINT"/>' title='<egui:intnl text="reporter.common.PRINT"/>'/></div>
		<!--<td>
	</tr>
</table>--> 
	</div>

	<div class="printOuterBoxNoBorder">
<!--<table width="100%" border="0" cellspacing="0" cellpadding="0" align="center" style="border-bottom:1px solid #ccc;">
	<tr>
		<td align="left" valign="top">-->
			<!--<div style="clear:both;float:left;padding:4px;">
				<div style="float:left" class="formLabel"><%=intlmap.getTextDescription("reporter.common.Top Applications - Sorted by ")%></div>
				<div style="float:left;width:10px" align="center" >:</div>
				<div style="float:left;" class="formValue"><%=measureGroupDisp.toUpperCase()%></div>
			</div>-->
			<div class="printSelectionFields"><%=intlmap.getTextDescription("reporter.common.Top Applications - Sorted by ")%> - <span class="bold"><%=measureGroup.toUpperCase()%></span></div>
		<!--</td>
	</tr>
</table>-->
</div>

<div class="printOuterBox">
	<div class="newTable">
	<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" class="printTable">
		<thead>
		<tr>
	<%
								if(DataAvailableMeasureGroup!=null)
								{
	%>
			<th class="printTableHeader2" width="20%" align="center"><%=intlmap.getTextDescription("reporter.common.APPLICATION")%></th>

	<%
									for(int i=0;DataAvailableMeasureGroup.size()>i;i++)
									{
										//String titleclass="";
										String measures=(String)DataAvailableMeasureGroup.get(i);
									
										//String tmp=reportInfo.getValue(subjectForChart,measures);
										//String MappedMeasure=tmp.substring(tmp.indexOf(" on ")+4);
										String unit=(String)unitForMeasure.get(measures);
										//titleclass="tdborder";

										String titlehighlight="x-grid-cell x-grid-cell-first";
										String divhighlight="x-grid-cell-inner";

										measures = measures.toUpperCase();

	%>
			<th class="printTableHeader2" width="75px" align="center" > <%=intlmap.getTextDescription("reporter.common."+measures)%> (<%=intlmap.getTextDescription("reporter.common."+unit)%>)
			</th>

	<%
									}
								}
	%>

		</tr>
		</thead>
	<%
								if(overAllData!=null && !overAllData.isEmpty())
								{
									for(int i=0;overAllData.size()>i;i++)
									{
										ArrayList dataList=(ArrayList)overAllData.get(i);
										String s_appln=(String)dataList.get(0);
	%>
		<tr>
			<td ><b><%=s_appln%></b></td>
	<%
										if(dataList!=null)
										{
											for(int j=1;dataList.size()>j;j++)
											{
												String highlightClass="x-grid-cell x-grid-cell-first";
												String divClass="x-grid-cell-inner";
												if(sortbyColumnhighlight==j)
												{
												highlightClass="odd-col";
												divClass="odd-col";
												}
												Float data=(Float)dataList.get(j);
											if(data.compareTo(minusFive)>0)
												{
													float f_data=data.floatValue();

	%>
			<td align="center"><%=erUtils.round(f_data,4)%></td>

	<%
												}
												else
												{
	%>
			<td align="center">-</td>
	<%
												}
											}
										}
	%>
		</tr>
	<%
									}
								}
	%>
	</table>
	</div>
</div>
<%
			}
		}
%>
</body>
</html>
	<%	}
		catch(Exception e)
		{
			e.printStackTrace();
		}
%>
