<%

/******************************************************************************************************************
*	FileName		:	ErSaveScheduleResponse.jsp
*	Purpose		:	To get schedule details.
*	Author		:	Solomon
*	Created		:
* Last modified:	10-08-2004- S.Solomon - code added to disallow duplicate schedule names.23-07-2004 M.Saravanan
*						save button disabled functionality added.08/07/2004 M.Saravanan
*						Selection Details get from Bean.21/05/2004 M.Saravanan
*						Display of Selected Infos for Schedules.06/05/2004 M.Saravanan
*						Mail Id verification is added.
*******************************************************************************************************************/
%>

<%@ include file = "ErReporterTracker.jsp" %>
<%@page import="egurkha.reporter.*"%>
<%@page import="java.util.*"%>
<%@page import="com.eg.IniFile"%>
<%@page import="com.eg.EgInstallInfo"%>
<%@page import= "com.eg.EgDbInfo"%>
<%@page import= "com.eg.EgTestInfo"%>
<%@page import= "com.eg.*"%>
<%@page import="java.text.SimpleDateFormat"%>
<%@page import="com.egurkha.util.DateTimeTokenizer"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ page import="net.sf.json.*"%>
<%@ page import = "com.eg.EgMappingInfo"%>
<%@ page import = "com.egurkha.util.StringUtils"%>

<%
	try
	{
		response.setHeader("Cache-Control","no-store");
		response.setHeader("Pragma","no-cache");
		response.setDateHeader("Expires", -1);
		response.setContentType("application/json");

		EgMappingInfo mappingInfo=new EgMappingInfo(trackerLanguage);
		//Back Button - Start
		HashMap backreqMap = (HashMap)session.getAttribute("backQuery");
		String backQnumber = request.getParameter("backQnumber");
		String servlet2 = request.getParameter("backServletName");
		String isViaResizePopUp = request.getParameter("via_resize_pop_up");
			Map schreqMap= (Map)session.getAttribute("SCH_QUERY_STRING");
			if(schreqMap!=null)
				session.removeAttribute("SCH_QUERY_STRING");

		ErHelperUtils erhelputils = null;

		ErUtils erUtils = new ErUtils();
		if( servlet2!=null && !servlet2.equals(""))
			erhelputils = new ErHelperUtils(backreqMap,backQnumber,servlet2);
		else
			erhelputils = new ErHelperUtils(backreqMap,backQnumber);

		boolean enableBack=erhelputils.isBackButtonEnable();
		//Back Button - End

		long sch_id = 0;
		String sch_name = "";
		String sch_mailFreq = "Daily";
		String sch_mailon="";
		String selectedDays_on="";
		String sch_printon="";
		String sch_printFreq ="None";
		String sch_mail_id="";
		java.util.Map sch_details = null;
		java.util.Map sch_modify_details = null;
		boolean isDouble=EgDbInfo.doubleByteEnabled;
		EgTestInfo tokInfo = new EgTestInfo("manager");

		Hashtable reqAttrs = (Hashtable) session.getAttribute("schedulePageReqAttrs");

		String s_timeline="";
		String graphtype="";
		String reporttype="";
		String strHours ="00";
		String strMin ="00";
		String schedule_on =null;
		String reportType = "";
		String reportName = "";
		String strToDisplay = "";
		String strScheduleID = request.getParameter("schedule_id");
		String from_fav = request.getParameter("fromFavorite");
		String fav_name = request.getParameter("fav_name");
		IniFile servicesIni = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_services.ini");
		boolean isPrintEnabled="true".equalsIgnoreCase(servicesIni.getValue("MISC_ARGS","EnableSchedulePrint"));
		String isScheduleSaveEnabled = servicesIni.getValue("MISC_ARGS","SaveScheduleReport");

		boolean isScheduleSave = false;
		if(isScheduleSaveEnabled!=null && (isScheduleSaveEnabled.equalsIgnoreCase("Yes") || isScheduleSaveEnabled.equalsIgnoreCase("true")))
		{
			isScheduleSave = true;
		}
		if(!isPrintEnabled)
			sch_mailFreq = "Daily";
		egurkha.reporter.ErScheduleTask task = null;
		if(strScheduleID!=null && strScheduleID.length()>0 && !strScheduleID.equalsIgnoreCase("NULL") && !strScheduleID.equalsIgnoreCase("undefined"))
		{
			try{
			sch_id = Integer.parseInt(strScheduleID);
			task = ErScheduleTask.getScheduleTask(sch_id);
			}catch(Exception e){
				e.printStackTrace();
			}
		}else
		{
			task =(egurkha.reporter.ErScheduleTask)reqAttrs.get("ScheduleTask");
		}
		if(task!=null)
		{
			sch_id = task.getScheduleId();
			sch_name = task.getName();
			sch_mailFreq = (task.getMailFrequency()).trim();
			if (sch_mailFreq.indexOf("#")>-1)
				sch_mailFreq=sch_mailFreq.substring(0,sch_mailFreq.indexOf("#"));

			schedule_on = task.getScheduleType();
			strHours = task.getScheduleRunAtHr();
			strMin = task.getScheduleRunAtMin();
			if(strHours == null)
				strHours = "00";
			if(strMin == null)
				strMin = "00";
			sch_mailon=task.getMailDay();
			selectedDays_on=task.getMailDay();
			sch_printon=task.getPrintDay();
			if(sch_printon==null)
				sch_printon="";
//
						try{
						String strScheduleTimeAt="";
						EgDateInfo _tdateInfo = new EgDateInfo();
						//TimeZone timeZone1= TimeZone.getTimeZone(EgInstallInfo.timeZoneId);
						TimeZone timeZone1= _tdateInfo.getRealTimeZone();
						TimeZone timeZone2 = TimeZone.getTimeZone(thisuser.getUserTimeZone());

						long timeDifference = 0;
                         double hrdiff =0;
						Calendar cal = Calendar.getInstance();
						cal.setTime(new java.util.Date(_tdateInfo.egetUTCDate(false)));
						cal.setTimeZone(_tdateInfo.getRealTimeZone());
						cal.set(cal.HOUR_OF_DAY,Integer.parseInt(strHours));
						cal.set(cal.MINUTE,Integer.parseInt(strMin));
						cal.set(cal.SECOND,0);
						java.util.Date sch_date = cal.getTime();
						long timeinMins = sch_date.getTime();
						boolean isDayLight = timeZone2.inDaylightTime(sch_date);
						if(thisuser.getUserTimeZone()!=null && !thisuser.getUserTimeZone().equalsIgnoreCase("default")){
							if(timeZone1.getDSTSavings()>0 && timeZone2.getDSTSavings()>0){
                              timeDifference = (timeZone1.getRawOffset() + timeZone1.getDSTSavings()) - (timeZone2.getRawOffset() + timeZone2.getDSTSavings());

							}else  if(timeZone1.getDSTSavings()>0)
							{
								isDayLight = timeZone1.inDaylightTime(sch_date);
								if(isDayLight){
									timeDifference = (timeZone1.getRawOffset() + timeZone1.getDSTSavings()) - timeZone2.getRawOffset();
								}else{
									timeDifference = timeZone1.getRawOffset() - timeZone2.getRawOffset();
								}
							}
							else  if(timeZone2.getDSTSavings()>0)
							{
							  if(isDayLight){
								timeDifference = timeZone1.getRawOffset() - (timeZone2.getRawOffset()+ timeZone2.getDSTSavings());
								 }else{
									 timeDifference = timeZone1.getRawOffset() - (timeZone2.getRawOffset());
								 }
								  
							}
							else
							{
								timeDifference = (timeZone1.getRawOffset()) - (timeZone2.getRawOffset());
							}
						}
						if(timeDifference>0)
							timeinMins = timeinMins - timeDifference;
						if(timeDifference<0)
							timeinMins = timeinMins + Math.abs(timeDifference);
						java.util.Date newDate = new java.util.Date(timeinMins);
						SimpleDateFormat fmt = new SimpleDateFormat("MM/dd/yyyy HH:mm");
						String modifyDate = fmt.format(newDate);
						if(modifyDate!=null && modifyDate.indexOf(" ")>-1)
						{
							strScheduleTimeAt = modifyDate.substring(modifyDate.indexOf(" ")+1);
						}
						if(strScheduleTimeAt!=null && strScheduleTimeAt.indexOf(":")>-1)
						{
							strHours = strScheduleTimeAt.substring(0,strScheduleTimeAt.indexOf(":"));
							strMin = strScheduleTimeAt.substring(strScheduleTimeAt.indexOf(":")+1);
						}
						}catch(Exception e){e.printStackTrace();}
//
			sch_printFreq = task.getPrintFrequency();
			if(sch_printFreq.indexOf("#")>-1)
				sch_printFreq=sch_printFreq.substring(0,sch_printFreq.indexOf("#"));

			sch_mail_id = (task.getMailId()==null)?"":task.getMailId();
			if(strScheduleID!=null && !strScheduleID.equals("") && !strScheduleID.equalsIgnoreCase("NULL"))
			{
				sch_details = request.getParameterMap();
				sch_modify_details = task.getDetails();
			}
			else
			{
				sch_details = task.getDetails();
			}
		}
		else
		{
			Map TempMap ;
			if(isViaResizePopUp!=null && isViaResizePopUp.equals("true"))
			{
				TempMap =schreqMap;
			}
			else
			{
				TempMap = request.getParameterMap();
			}
			sch_details = new HashMap();
			sch_modify_details = new HashMap();
			sch_details.putAll(TempMap);
			sch_modify_details.putAll(TempMap);
			if(sch_details.containsKey("ID"))
				sch_details.remove("ID");
			//sch_details = request.getParameterMap();
			//added by M.Saravanan
			if((ErScheduleTask.getMailID(urs)!=null)&& (ErScheduleTask.getMailID(urs).trim().length()!=0))
			{
				StringTokenizer st=new StringTokenizer(ErScheduleTask.getMailID(urs),",",false);
				StringBuffer sb_sch_mail_id=new StringBuffer();
				while(st.hasMoreTokens())
				{
					String s=st.nextToken();
					if(s.indexOf("@")>-1)
					{
						sb_sch_mail_id.append(s).append(",");
					}
				}
				if(sb_sch_mail_id.length()>0)
					sch_mail_id=sb_sch_mail_id.deleteCharAt(sb_sch_mail_id.length()-1).toString();
			}
		}
		try
		{
			s_timeline=(String)sch_details.get("er_timeline");
		}
		catch(ClassCastException e)
		{
			s_timeline=((String[])sch_details.get("er_timeline"))[0];
		}
		try
		{
			graphtype =(String)sch_details.get("er_gtype");
		}
		catch(ClassCastException e)
		{
			if(((String[])sch_details.get("er_gtype"))[0]!=null )
				graphtype =((String[])sch_details.get("er_gtype"))[0];
		}
		try
		{
			reporttype=(String)sch_details.get("er_rtype");
		}
		catch(ClassCastException e)
		{
			reporttype=((String[])sch_details.get("er_rtype"))[0];
		}
		if(reporttype==null)
		{
			try
			{
				reporttype=(String)sch_details.get("reporttype");
			}
			catch(ClassCastException e)
			{
				reporttype=((String[])sch_details.get("reporttype"))[0];
			}
		}
		if(graphtype==null || graphtype.equals("") && (reporttype!=null && !reporttype.equals("")))
			graphtype=reporttype;

		ErReportParam erp=new ErReportParam(sch_details,trackerLanguage);
		Vector detail=erp. getSelectionDetails();

		//ends
		HashMap AuditLogValue = new HashMap();
		String [] hours1 = {"00","01","02","03","04","05","06","07","08","09","10","11","12","13","14","15","16","17","18","19","20","21","22","23"};
		String [] minutes1 =  {"00","05","10","15","20","25","30","35","40","45","50","55"};
		if(schedule_on == null || schedule_on.length()==0)
			schedule_on = "DayEnd";
		//reportType = request.getParameter("er_rtype");
		reportName = request.getParameter("er_trgttype");

		if(reporttype != null && reporttype.equalsIgnoreCase("Macro"))
			strToDisplay = "disabled";
		boolean showModifyLink = false;
		showModifyLink = (sch_id>0 && !reporttype.equalsIgnoreCase("Homepage"));
		if(reportName != null && reportName.equalsIgnoreCase("System") && reporttype != null && reporttype.equalsIgnoreCase("Capacity Planning"))
			strToDisplay = "disabled";
		
		String schedule_Mail_Format = "PDF";
		 String schedule_Mail_Receive = "Attachment";
		/* by karthikeyan */
		if(sch_details!=null)
		{
			String comeFrom=request.getParameter("come_from");
			if(sch_details.get("scheduleMailreceiveType")!=null)
			{
				String receiveType = null;
				try
				{
					receiveType=(String)sch_details.get("scheduleMailreceiveType");
				}
				catch(ClassCastException e)
				{
					receiveType=((String[])sch_details.get("scheduleMailreceiveType"))[0];
				}	
				
				if(receiveType!=null && receiveType.length()!=0)
				{
					schedule_Mail_Receive=receiveType;
					sch_details.remove("scheduleMailreceiveType");
				}
			}
			else if(comeFrom!=null && comeFrom.equalsIgnoreCase("ViewSchedule"))
			{
				schedule_Mail_Receive = "InLine";
			}
			if(sch_details.get("scheduleMailFormat")!=null)
			{
				try
				{
					schedule_Mail_Format = (String)sch_details.get("scheduleMailFormat");
				}
				catch(ClassCastException e)
				{
					schedule_Mail_Format=((String[])sch_details.get("scheduleMailFormat"))[0];
				}
				//schedule_Mail_Format = (String)sch_details.get("scheduleMailFormat");
				sch_details.remove("scheduleMailFormat");
			}
		}
		//
		if(sch_modify_details!=null)
		{
			if(sch_modify_details.get("scheduleMailreceiveType")!=null)
			{
				//String receiveType = (String)sch_modify_details.get("scheduleMailreceiveType");
				String receiveType = null;
				try
				{
					receiveType=(String)sch_modify_details.get("scheduleMailreceiveType");
				}
				catch(ClassCastException e)
				{
					receiveType=((String[])sch_modify_details.get("scheduleMailreceiveType"))[0];
				}

				if(receiveType!=null && receiveType.length()!=0)
				{
					schedule_Mail_Receive=receiveType;
					sch_modify_details.remove("scheduleMailreceiveType");
				}
			}
			if(sch_modify_details.get("scheduleMailFormat")!=null)
			{
				// schedule_Mail_Format = (String)sch_modify_details.get("scheduleMailFormat");
				try
				{
					schedule_Mail_Format = (String)sch_modify_details.get("scheduleMailFormat");
				}
				catch(ClassCastException e)
				{
					schedule_Mail_Format=((String[])sch_modify_details.get("scheduleMailFormat"))[0];
				}
				sch_modify_details.remove("scheduleMailFormat");
			}
		}
		//
		
		boolean isCSVFormatEnabled = isCSVEnabledForReport(sch_details);

		String cmdValue=request.getParameter("SaveTo");
		cmdValue=(cmdValue==null)?"Save":cmdValue;
		JSONObject json = new JSONObject();
		JSONObject pageParams = new JSONObject();
		JSONObject hiddenParams = new JSONObject();
		JSONObject screenLabels = new JSONObject();

		pageParams.put("showModifyLink",String.valueOf(showModifyLink));

		pageParams.put("submitURL","/final/servlet/com.eg.ErSchedulerC?cmd="+cmdValue);
		if(isDouble)
			hiddenParams.put("isDoubleByteEnabled","true");
		else
			hiddenParams.put("isDoubleByteEnabled","false");

		hiddenParams.put("details",ErUtils.prepareQueryString(sch_details));
		if(isViaResizePopUp!=null && isViaResizePopUp.equals("true"))
			hiddenParams.put("isViaResizePopUp",isViaResizePopUp);
		hiddenParams.put("id",String.valueOf(sch_id));
		String fromFavSch = request.getParameter("fromFavSch");
		String backDisplay = (String)session.getAttribute("favSchBackDisplay");
		String strwidth = "90%";
		if(backDisplay!=null && (backDisplay.equalsIgnoreCase("No") && fromFavSch==null))
			strwidth="100%";

		pageParams.put("ShowScheduleFormat",isCSVFormatEnabled);
		pageParams.put("mainTitleWidth",strwidth);
		screenLabels.put("reporter.common.SAVE SCHEDULES",mappingInfo.getTextDescription("reporter.common.SAVE SCHEDULES"));
		screenLabels.put("reporter.common.Schedule Name",mappingInfo.getTextDescription("reporter.common.Schedule Name"));
		screenLabels.put("reporter.common.Mail",mappingInfo.getTextDescription("reporter.common.Mail"));
		screenLabels.put("reporter.common.Mail On",mappingInfo.getTextDescription("reporter.common.Mail On"));
		screenLabels.put("reporter.common.Mail Id",mappingInfo.getTextDescription("reporter.common.Mail Id"));
		screenLabels.put("reporter.common.Print",mappingInfo.getTextDescription("reporter.common.Print"));
		screenLabels.put("reporter.common.Print On",mappingInfo.getTextDescription("reporter.common.Print On"));
		screenLabels.put("reporter.common.Schedule type",mappingInfo.getTextDescription("reporter.common.Schedule Type"));
		screenLabels.put("reporter.common.Include in Mail as",mappingInfo.getTextDescription("reporter.common.Include in Mail as"));
		//screenLabels.put("reporter.common.Schedule Format",mappingInfo.getTextDescription("reporter.common.Schedule Format"));
		screenLabels.put("reporter.schedule.Schedule at",mappingInfo.getTextDescription("reporter.schedule.Schedule At"));
		screenLabels.put("reporter.common.Hrs",mappingInfo.getTextDescription("reporter.common.Hrs"));
		screenLabels.put("reporter.common.Mins",mappingInfo.getTextDescription("reporter.common.Mins"));
		screenLabels.put("reporter.common.PDF",mappingInfo.getTextDescription("reporter.common.PDF"));
		screenLabels.put("reporter.common.CSV",mappingInfo.getTextDescription("reporter.common.CSV"));
		
		boolean isBackButtonNeeded = false;
		if((backreqMap != null && backreqMap.size() > 0 &&  enableBack && request.getParameter("enableBack")!=null && request.getParameter("enableBack").equalsIgnoreCase("true")) || 
		(backDisplay!=null && backDisplay.equalsIgnoreCase("Yes")) || 
		(fromFavSch!=null && fromFavSch.equalsIgnoreCase("true")))
		{
			hiddenParams.put("ID","backQnumber="+erhelputils.getBackID()+"&"+erhelputils.getQueryString());
		//	hiddenParams.put("backButtonURL","../reporter/EgReporterback.jsp");
			isBackButtonNeeded = true;
		}
		if(isBackButtonNeeded)
		{
			pageParams.put("backButtonNeeded","true");
		}
		String s_error = (String)reqAttrs.get("ERROR");
		if(s_error!=null)
		{
			String strs_error="reporter.common."+s_error;
			screenLabels.put("errorMsg",mappingInfo.getTextDescription(strs_error));
		}
		pageParams.put("from_fav",from_fav);
		if(from_fav!=null && from_fav.equalsIgnoreCase("yes"))
		{
			pageParams.put("favouriteName",fav_name);
			pageParams.put("scheduleName",sch_name);
			hiddenParams.put("$_sch_name",fav_name);
		}
		else
		{
			pageParams.put("scheduleName",sch_name);
			hiddenParams.put("$_sch_name",sch_name);
		}
		JSONArray mailFreqJSON = new JSONArray();
		JSONObject mailFreqObj = new JSONObject();

		if(reporttype!=null && !reporttype.equals("Billing"))
		{
			if(isPrintEnabled)
			{
				mailFreqObj.put("displayField",mappingInfo.getTextDescription("reporter.common.None"));
				mailFreqObj.put("valueField","None");
				mailFreqJSON.add(mailFreqObj);
			}

			mailFreqObj = new JSONObject();
			mailFreqObj.put("displayField",mappingInfo.getTextDescription("reporter.common.Daily"));
			mailFreqObj.put("valueField","Daily");
			mailFreqJSON.add(mailFreqObj);

			mailFreqObj = new JSONObject();
			mailFreqObj.put("displayField",mappingInfo.getTextDescription("reporter.common.Day(s) of the week"));
			mailFreqObj.put("valueField","Days_of_the_week");
			mailFreqJSON.add(mailFreqObj);

			mailFreqObj = new JSONObject();
			mailFreqObj.put("displayField",mappingInfo.getTextDescription("reporter.common.Weekly"));
			mailFreqObj.put("valueField","Weekly");
			mailFreqJSON.add(mailFreqObj);

			mailFreqObj = new JSONObject();
			mailFreqObj.put("displayField",mappingInfo.getTextDescription("reporter.common.Weekend"));
			mailFreqObj.put("valueField","WeekEnd");
			mailFreqJSON.add(mailFreqObj);
		}
		mailFreqObj = new JSONObject();
		mailFreqObj.put("displayField",mappingInfo.getTextDescription("reporter.common.Monthly"));
		mailFreqObj.put("valueField","Monthly");
		mailFreqJSON.add(mailFreqObj);

		mailFreqObj = new JSONObject();
		mailFreqObj.put("displayField",mappingInfo.getTextDescription("reporter.common.Month-End"));
		mailFreqObj.put("valueField","MonthEnd");
		mailFreqJSON.add(mailFreqObj);

		pageParams.put("selectedMailFreq_value",sch_mailFreq);
		hiddenParams.put("$_mail_freq",sch_mailFreq);

		JSONArray mailOnJSON = new JSONArray();
		JSONObject mailOnObj = new JSONObject();

		mailOnObj.put("displayField",mappingInfo.getTextDescription("reporter.common.Sunday"));
		mailOnObj.put("valueField","Sunday");
		mailOnJSON.add(mailOnObj);

		mailOnObj = new JSONObject();
		mailOnObj.put("displayField",mappingInfo.getTextDescription("reporter.common.Monday"));
		mailOnObj.put("valueField","Monday");
		mailOnJSON.add(mailOnObj);

		mailOnObj = new JSONObject();
		mailOnObj.put("displayField",mappingInfo.getTextDescription("reporter.common.Tuesday"));
		mailOnObj.put("valueField","Tuesday");
		mailOnJSON.add(mailOnObj);

		mailOnObj = new JSONObject();
		mailOnObj.put("displayField",mappingInfo.getTextDescription("reporter.common.Wednesday"));
		mailOnObj.put("valueField","Wednesday");
		mailOnJSON.add(mailOnObj);

		mailOnObj = new JSONObject();
		mailOnObj.put("displayField",mappingInfo.getTextDescription("reporter.common.Thursday"));
		mailOnObj.put("valueField","Thursday");
		mailOnJSON.add(mailOnObj);

		mailOnObj = new JSONObject();
		mailOnObj.put("displayField",mappingInfo.getTextDescription("reporter.common.Friday"));
		mailOnObj.put("valueField","Friday");
		mailOnJSON.add(mailOnObj);

		mailOnObj = new JSONObject();
		mailOnObj.put("displayField",mappingInfo.getTextDescription("reporter.common.Saturday"));
		mailOnObj.put("valueField","Saturday");
		mailOnJSON.add(mailOnObj);

		JSONArray mailOnJSON1 = new JSONArray();
		JSONObject mailOnObj1 = new JSONObject();

		mailOnObj1.put("displayField",mappingInfo.getTextDescription("reporter.common.01"));
		mailOnObj1.put("valueField","01");
		mailOnJSON1.add(mailOnObj1);

		mailOnObj1 = new JSONObject();
		mailOnObj1.put("displayField",mappingInfo.getTextDescription("reporter.common.02"));
		mailOnObj1.put("valueField","02");
		mailOnJSON1.add(mailOnObj1);

		mailOnObj1 = new JSONObject();
		mailOnObj1.put("displayField",mappingInfo.getTextDescription("reporter.common.03"));
		mailOnObj1.put("valueField","03");
		mailOnJSON1.add(mailOnObj1);

		mailOnObj1 = new JSONObject();
		mailOnObj1.put("displayField",mappingInfo.getTextDescription("reporter.common.04"));
		mailOnObj1.put("valueField","04");
		mailOnJSON1.add(mailOnObj1);

		mailOnObj1 = new JSONObject();
		mailOnObj1.put("displayField",mappingInfo.getTextDescription("reporter.common.05"));
		mailOnObj1.put("valueField","05");
		mailOnJSON1.add(mailOnObj1);

		mailOnObj1 = new JSONObject();
		mailOnObj1.put("displayField",mappingInfo.getTextDescription("reporter.common.06"));
		mailOnObj1.put("valueField","06");
		mailOnJSON1.add(mailOnObj1);

		mailOnObj1 = new JSONObject();
		mailOnObj1.put("displayField",mappingInfo.getTextDescription("reporter.common.07"));
		mailOnObj1.put("valueField","07");
		mailOnJSON1.add(mailOnObj1);
		
		mailOnObj1 = new JSONObject();
		mailOnObj1.put("displayField",mappingInfo.getTextDescription("reporter.common.08"));
		mailOnObj1.put("valueField","08");
		mailOnJSON1.add(mailOnObj1);

		mailOnObj1 = new JSONObject();
		mailOnObj1.put("displayField",mappingInfo.getTextDescription("reporter.common.09"));
		mailOnObj1.put("valueField","09");
		mailOnJSON1.add(mailOnObj1);

		mailOnObj1 = new JSONObject();
		mailOnObj1.put("displayField",mappingInfo.getTextDescription("reporter.common.10"));
		mailOnObj1.put("valueField","10");
		mailOnJSON1.add(mailOnObj1);

		mailOnObj1.put("displayField",mappingInfo.getTextDescription("reporter.common.11"));
		mailOnObj1.put("valueField","11");
		mailOnJSON1.add(mailOnObj1);

		mailOnObj1 = new JSONObject();
		mailOnObj1.put("displayField",mappingInfo.getTextDescription("reporter.common.12"));
		mailOnObj1.put("valueField","12");
		mailOnJSON1.add(mailOnObj1);

		mailOnObj1 = new JSONObject();
		mailOnObj1.put("displayField",mappingInfo.getTextDescription("reporter.common.13"));
		mailOnObj1.put("valueField","13");
		mailOnJSON1.add(mailOnObj1);

		mailOnObj1 = new JSONObject();
		mailOnObj1.put("displayField",mappingInfo.getTextDescription("reporter.common.14"));
		mailOnObj1.put("valueField","14");
		mailOnJSON1.add(mailOnObj1);

		mailOnObj1 = new JSONObject();
		mailOnObj1.put("displayField",mappingInfo.getTextDescription("reporter.common.15"));
		mailOnObj1.put("valueField","15");
		mailOnJSON1.add(mailOnObj1);

		mailOnObj1 = new JSONObject();
		mailOnObj1.put("displayField",mappingInfo.getTextDescription("reporter.common.16"));
		mailOnObj1.put("valueField","16");
		mailOnJSON1.add(mailOnObj1);

		mailOnObj1 = new JSONObject();
		mailOnObj1.put("displayField",mappingInfo.getTextDescription("reporter.common.17"));
		mailOnObj1.put("valueField","17");
		mailOnJSON1.add(mailOnObj1);
		
		mailOnObj1 = new JSONObject();
		mailOnObj1.put("displayField",mappingInfo.getTextDescription("reporter.common.18"));
		mailOnObj1.put("valueField","18");
		mailOnJSON1.add(mailOnObj1);

		mailOnObj1 = new JSONObject();
		mailOnObj1.put("displayField",mappingInfo.getTextDescription("reporter.common.19"));
		mailOnObj1.put("valueField","19");
		mailOnJSON1.add(mailOnObj1);

		mailOnObj1 = new JSONObject();
		mailOnObj1.put("displayField",mappingInfo.getTextDescription("reporter.common.20"));
		mailOnObj1.put("valueField","20");
		mailOnJSON1.add(mailOnObj1);
        
		mailOnObj1.put("displayField",mappingInfo.getTextDescription("reporter.common.21"));
		mailOnObj1.put("valueField","21");
		mailOnJSON1.add(mailOnObj1);

		mailOnObj1 = new JSONObject();
		mailOnObj1.put("displayField",mappingInfo.getTextDescription("reporter.common.22"));
		mailOnObj1.put("valueField","22");
		mailOnJSON1.add(mailOnObj1);

		mailOnObj1 = new JSONObject();
		mailOnObj1.put("displayField",mappingInfo.getTextDescription("reporter.common.23"));
		mailOnObj1.put("valueField","23");
		mailOnJSON1.add(mailOnObj1);

		mailOnObj1 = new JSONObject();
		mailOnObj1.put("displayField",mappingInfo.getTextDescription("reporter.common.24"));
		mailOnObj1.put("valueField","24");
		mailOnJSON1.add(mailOnObj1);

		mailOnObj1 = new JSONObject();
		mailOnObj1.put("displayField",mappingInfo.getTextDescription("reporter.common.25"));
		mailOnObj1.put("valueField","25");
		mailOnJSON1.add(mailOnObj1);

		mailOnObj1 = new JSONObject();
		mailOnObj1.put("displayField",mappingInfo.getTextDescription("reporter.common.26"));
		mailOnObj1.put("valueField","26");
		mailOnJSON1.add(mailOnObj1);

		mailOnObj1 = new JSONObject();
		mailOnObj1.put("displayField",mappingInfo.getTextDescription("reporter.common.27"));
		mailOnObj1.put("valueField","27");
		mailOnJSON1.add(mailOnObj1);
		
		mailOnObj1 = new JSONObject();
		mailOnObj1.put("displayField",mappingInfo.getTextDescription("reporter.common.28"));
		mailOnObj1.put("valueField","28");
		mailOnJSON1.add(mailOnObj1);

		mailOnObj1 = new JSONObject();
		mailOnObj1.put("displayField",mappingInfo.getTextDescription("reporter.common.29"));
		mailOnObj1.put("valueField","29");
		mailOnJSON1.add(mailOnObj1);

		mailOnObj1 = new JSONObject();
		mailOnObj1.put("displayField",mappingInfo.getTextDescription("reporter.common.30"));
		mailOnObj1.put("valueField","30");
		mailOnJSON1.add(mailOnObj1);
        
		mailOnObj1.put("displayField",mappingInfo.getTextDescription("reporter.common.31"));
		mailOnObj1.put("valueField","31");
		mailOnJSON1.add(mailOnObj1);

		if(sch_mailon!=null && sch_mailon.indexOf(",")>-1)
		{
			sch_mailon=sch_mailon.substring(0,sch_mailon.indexOf(","));
		}
		
		if(!StringUtils.isNull(sch_mailon))
			pageParams.put("selectedMailOn_value",sch_mailon);
		else
			pageParams.put("selectedMailOn_value","Sunday");

		if(!StringUtils.isNull(selectedDays_on))
			pageParams.put("Selected_days",selectedDays_on);
		else
			pageParams.put("Selected_days","Sunday");

		hiddenParams.put("$_mail_on",sch_mailon);

		if(sch_mail_id!=null && sch_mail_id.indexOf("To:")>-1)
		{
			if(sch_mail_id.indexOf("To:")==sch_mail_id.lastIndexOf("To:"))
			{
				if(sch_mail_id.indexOf("cc:")>-1)
				{
					sch_mail_id=sch_mail_id.substring(sch_mail_id.indexOf("To:")+3,sch_mail_id.indexOf("cc:"));
					sch_mail_id=sch_mail_id.substring(0,sch_mail_id.length()-1);
				}
				else if(sch_mail_id.indexOf("bcc:")>-1)
				{
					sch_mail_id=sch_mail_id.substring(sch_mail_id.indexOf("To:")+3,sch_mail_id.indexOf("bcc:"));
					sch_mail_id=sch_mail_id.substring(0,sch_mail_id.length()-1);
				}
				else if(sch_mail_id.indexOf("Esc1:")>-1)
				{
					sch_mail_id=sch_mail_id.substring(sch_mail_id.indexOf("To:")+3,sch_mail_id.indexOf("Esc1:"));
					sch_mail_id=sch_mail_id.substring(0,sch_mail_id.length()-1);
				}
				else
					sch_mail_id=sch_mail_id.substring(sch_mail_id.indexOf("To:")+3);
			}
			else
			{
				StringTokenizer str_token=new StringTokenizer(sch_mail_id,",");
				String temp_mail_id="";
				while(str_token.hasMoreTokens())
				{
					String str_mai_id=(String)str_token.nextToken();
					if(str_mai_id.startsWith("To:"))
					{
						if(temp_mail_id==null || temp_mail_id.equals(""))
							temp_mail_id=str_mai_id.substring(str_mai_id.indexOf("To:")+3);
						else
							temp_mail_id+=","+str_mai_id.substring(str_mai_id.indexOf("To:")+3);
					}
				}
				sch_mail_id=temp_mail_id;
			}
		}
		else if(sch_mail_id!=null && sch_mail_id.indexOf("bcc:")>-1)
		{
			if(sch_mail_id.indexOf("bcc:")==sch_mail_id.lastIndexOf("bcc:"))
			{
				if(sch_mail_id.indexOf("Esc1:")>-1)
				{
					sch_mail_id=sch_mail_id.substring(sch_mail_id.indexOf("bcc:")+4,sch_mail_id.indexOf("Esc1:"));
					sch_mail_id=sch_mail_id.substring(0,sch_mail_id.length()-1);
				}
				else
					sch_mail_id=sch_mail_id.substring(sch_mail_id.indexOf("bcc:")+4);
			}
			else
			{
				StringTokenizer str_token=new StringTokenizer(sch_mail_id,",");
				String temp_mail_id="";
				while(str_token.hasMoreTokens())
				{
					String str_mai_id=(String)str_token.nextToken();
					if(str_mai_id.startsWith("bcc:"))
					{
						if(temp_mail_id==null || temp_mail_id.equals(""))
						temp_mail_id=str_mai_id.substring(str_mai_id.indexOf("bcc:")+4);
						else
						temp_mail_id+=","+str_mai_id.substring(str_mai_id.indexOf("bcc:")+4);
					}
				}
				sch_mail_id=temp_mail_id;
			}
		}
		else if(sch_mail_id!=null && sch_mail_id.indexOf("cc:")>-1)
		{
			if(sch_mail_id.indexOf("cc:")==sch_mail_id.lastIndexOf("cc:"))
			{
				if(sch_mail_id.indexOf("bcc:")>-1)
				{
					sch_mail_id=sch_mail_id.substring(sch_mail_id.indexOf("cc:")+3,sch_mail_id.indexOf("bcc:"));
					sch_mail_id=sch_mail_id.substring(0,sch_mail_id.length()-1);
				}
				else if(sch_mail_id.indexOf("Esc1:")>-1)
				{
					sch_mail_id=sch_mail_id.substring(sch_mail_id.indexOf("cc:")+3,sch_mail_id.indexOf("Esc1:"));
					sch_mail_id=sch_mail_id.substring(0,sch_mail_id.length()-1);
				}
				else
					sch_mail_id=sch_mail_id.substring(sch_mail_id.indexOf("cc:")+3);
			}
			else
			{
				StringTokenizer str_token=new StringTokenizer(sch_mail_id,",");
				String temp_mail_id="";
				while(str_token.hasMoreTokens())
				{
					String str_mai_id=(String)str_token.nextToken();
					if(str_mai_id.startsWith("cc:"))
					{
						if(temp_mail_id==null || temp_mail_id.equals(""))
						temp_mail_id=str_mai_id.substring(str_mai_id.indexOf("cc:")+3);
						else
						temp_mail_id+=","+str_mai_id.substring(str_mai_id.indexOf("cc:")+3);
					}
				}
				sch_mail_id=temp_mail_id;
			}
		}
		else if(sch_mail_id!=null && sch_mail_id.indexOf("Esc1:")>-1)
		{
			if(sch_mail_id.indexOf("Esc1:")==sch_mail_id.lastIndexOf("Esc1:"))
				sch_mail_id=sch_mail_id.substring(sch_mail_id.indexOf("Esc1:")+5);
			else
			{
				StringTokenizer str_token=new StringTokenizer(sch_mail_id,",");
				String temp_mail_id="";
				while(str_token.hasMoreTokens())
				{
					String str_mai_id=(String)str_token.nextToken();
					if(str_mai_id.startsWith("Esc1:"))
					{
						if(temp_mail_id==null || temp_mail_id.equals(""))
							temp_mail_id=str_mai_id.substring(str_mai_id.indexOf("Esc1:")+5);
						else
							temp_mail_id+=","+str_mai_id.substring(str_mai_id.indexOf("Esc1:")+5);
					}
				}
				sch_mail_id=temp_mail_id;
			}
		}
		if(strHours == null)
			strHours = "00";
		if(strMin == null)
			strMin = "00";
	//	hiddenParams.put("mail_id",sch_mail_id);
		hiddenParams.put("$_mail_id",sch_mail_id);
		pageParams.put("mail_id",sch_mail_id);

		if(sch_mailFreq.equalsIgnoreCase("None"))
			pageParams.put("disableMailID","true");
		else
			pageParams.put("disableMailID","false");

		if(isPrintEnabled)
		{
			pageParams.put("isPrintEnabled","true");
			pageParams.put("selectedPrintFreq_value",sch_printFreq);
			hiddenParams.put("$_print_freq",sch_printFreq);
			if(!StringUtils.isNull(sch_printon))
				pageParams.put("selectedPrintMailOn_value",sch_printon);
			else
				pageParams.put("selectedPrintMailOn_value","Sunday");
			hiddenParams.put("$_print_on",sch_printon);
		}
		else
		{
			pageParams.put("isPrintEnabled","false");
		}
		if(schedule_Mail_Format.equalsIgnoreCase("null")){
			schedule_Mail_Format="PDF";
		}
		pageParams.put("selectedScheduleType",schedule_on);
		pageParams.put("scheduleMailFormat",schedule_Mail_Format);
		pageParams.put("scheduleMailReceive",schedule_Mail_Receive);
		if(strHours!=null)
			pageParams.put("selectedScheduleHr",strHours);

		if(strMin!=null)
			pageParams.put("selectedScheduleMin",strMin);

		hiddenParams.put("$_schedule_type",schedule_on);
		hiddenParams.put("$_schedule_at",strHours+":"+strMin);

		JSONArray scheduleTypeJson = new JSONArray();

		JSONObject obj = new JSONObject();
		obj.put("displayField",mappingInfo.getTextDescription("reporter.common.Day-End"));
		obj.put("valueField","DayEnd");
		scheduleTypeJson.add(obj);

		obj = new JSONObject();
		obj.put("displayField",mappingInfo.getTextDescription("reporter.common.Anytime"));
		obj.put("valueField","AnyTime");
		scheduleTypeJson.add(obj);

		JSONArray scheduleMailFormatJson = new JSONArray();

		JSONObject scheduleMailFormatobj = new JSONObject();
		scheduleMailFormatobj.put("displayField",mappingInfo.getTextDescription("reporter.common.PDF"));
		scheduleMailFormatobj.put("valueField","PDF");
		scheduleMailFormatJson.add(scheduleMailFormatobj);

		scheduleMailFormatobj = new JSONObject();
		scheduleMailFormatobj.put("displayField",mappingInfo.getTextDescription("reporter.common.CSV"));
		scheduleMailFormatobj.put("valueField","CSV");
		scheduleMailFormatJson.add(scheduleMailFormatobj);

		JSONArray scheduleMailreceiveTypeJson = new JSONArray();
		JSONObject scheduleMailreceiveTypeObj = new JSONObject();

		scheduleMailreceiveTypeObj.put("displayField",mappingInfo.getTextDescription("reporter.common.Attachment"));
		scheduleMailreceiveTypeObj.put("valueField","Attachment");
		scheduleMailreceiveTypeJson.add(scheduleMailreceiveTypeObj);

		scheduleMailreceiveTypeObj = new JSONObject();
		scheduleMailreceiveTypeObj.put("displayField",mappingInfo.getTextDescription("reporter.common.Inline content"));
		scheduleMailreceiveTypeObj.put("valueField","InLine");
		scheduleMailreceiveTypeJson.add(scheduleMailreceiveTypeObj);

		JSONArray hrsComboJSON = new JSONArray();
		obj = new JSONObject();
		for(int f=0;f<hours1.length;f++)
		{
			obj = new JSONObject();
			obj.put("displayField",hours1[f]);
			obj.put("valueField",hours1[f]);
			hrsComboJSON.add(obj);
		}
		JSONArray minsComboJSON = new JSONArray();
		obj = new JSONObject();
		for(int f=0;f<minutes1.length;f++)
		{
			obj = new JSONObject();
			obj.put("displayField",minutes1[f]);
			obj.put("valueField",minutes1[f]);
			minsComboJSON.add(obj);
		}				
		if(showModifyLink)
		{
			screenLabels.put("reporter.common.Details of Your Selection",mappingInfo.getTextDescription("reporter.common.Details of Your Selection"));
			screenLabels.put("resultTableTitle",mappingInfo.getTextDescription("reporter.common.Click here to modify your selection"));
			pageParams.put("modifyScheduleURL","/final/servlet/com.eg.ErSchedulerC?cmd=Show&id="+sch_id+"&fromFavSch=true&enableBack=true&backServletName=/servlet/com.eg.ErSchedulerC?");
		}
		else
		{
			screenLabels.put("reporter.common.Details of Your Selection",mappingInfo.getTextDescription("reporter.common.Details of Your Selection"));
		}
		String repType=request.getParameter("er_gtype");
		hiddenParams.put("er_gtype",repType);
		String tempName = null;
		String selectionType="";
		JSONArray tableContent = new JSONArray();
		
		for(int k=0;k<detail.size();k++)
		{
			JSONObject trContent = new JSONObject();
			String seldet=detail.get(k).toString();
			ArrayList aListData = tokInfo.egTokenizer(seldet,"*eGStar*");
			int count=0;
			String disptimetext="";
			for(int kk=0;kk<aListData.size();kk++)//(st.hasMoreTokens())
			{
				String value=(String)aListData.get(kk);//st.nextToken();
				value=value.trim();
				if(value.equals("Selected Timeline"))
					disptimetext=value;
				if(repType!=null && repType.equalsIgnoreCase("Citrix") && value.indexOf("Citrix")>-1)
				{
					String temp=value.substring(value.indexOf("Citrix")+6);
					value="Thin Client-"+temp;
				}
				if(value.indexOf("VmGuestStatus_Report") >-1)
					value = "Virtualization - VM Distribution";
				if(value.equalsIgnoreCase("Operation Reports - Server"))
					value="Consolidated Reports - Server";
				if(value.equalsIgnoreCase("Operation Reports - Zone"))
					value="Consolidated Reports - Zone";
					String getindex="";
				if(value.indexOf("-")>-1)
					getindex="-";
				else if(value.indexOf("/")>-1)
					getindex="/";

				String displayValue = "";
				if(count==0)
				{
					if(value.indexOf(getindex)>-1)
					{
						String titname=value.substring(0,value.indexOf(getindex));
						String subtitname=value.substring(value.indexOf(getindex));
						String strsubtitname="reporter.common."+subtitname;

						displayValue = titname + mappingInfo.getTextDescription(strsubtitname);
						selectionType=subtitname;
					}
					else
					{
						displayValue =  value;
						selectionType=value;
					}
					tempName = value;
				}
				else
				{
					AuditLogValue.put(tempName,value);
					tempName = null;
					if(value.indexOf(getindex)>-1)
					{
						String titname=value.substring(0,value.indexOf(getindex));
						String subtitname=value.substring(value.indexOf(getindex));
						if( s_timeline!=null && s_timeline.indexOf(DateTimeTokenizer.BLANK_SPACE)==-1 && disptimetext.equals("Selected Timeline") )
							subtitname=ErUtils.geTimelineInTextFromMins(s_timeline,graphtype);
						if(selectionType!=null && selectionType.trim().equalsIgnoreCase("Selected CompType"))
						{
                               displayValue = mappingInfo.getComponentTypeDescription(value);
						}
						else if(selectionType!=null && selectionType.trim().equalsIgnoreCase("Selected Component"))
						{
							if(value.indexOf(":")!=-1)
							{
								String componentName=value.substring(0,value.lastIndexOf(":"));
								String componentType=value.substring(value.lastIndexOf(":")+1);

								displayValue = componentName+":"+mappingInfo.getComponentTypeDescription(componentType);
							}
							else
							{
								displayValue = mappingInfo.getComponentTypeDescription(value);
							}
						}
						else if(selectionType!=null && selectionType.trim().equalsIgnoreCase("Selected Site"))
						{
							if(value.indexOf(":")!=-1)
							{
								String componentName=value.substring(0,value.lastIndexOf(":"));
								String componentType=value.substring(value.lastIndexOf(":")+1);
								displayValue = componentName+":"+mappingInfo.getComponentTypeDescription(componentType);
							}
							else
							{
								displayValue = mappingInfo.getComponentTypeDescription(value);
							}
						}
						else if(selectionType!=null && selectionType.trim().equalsIgnoreCase("Selected Application"))
						{
							if(value.indexOf(":")!=-1)
							{
								String componentName=value.substring(0,value.lastIndexOf(":"));
								String componentType=value.substring(value.lastIndexOf(":")+1);
								displayValue = componentName+":"+mappingInfo.getComponentTypeDescription(componentType);
							}
							else
							{
								displayValue = mappingInfo.getComponentTypeDescription(value);
							}
						}
						else if(selectionType!=null && selectionType.trim().equalsIgnoreCase("Selected Test"))
						{
							displayValue = mappingInfo.getTestDescription(value);
						}
						else if(selectionType!=null && selectionType.trim().equalsIgnoreCase("Selected Components"))
						{
							if(value!=null)
							{
								StringBuffer sbVals = new StringBuffer(256);
								//String components[]=value.split(",");
								StringTokenizer componentTokens=new StringTokenizer(value,",");
								int noOfComponents=componentTokens.countTokens();
								String components[]=new String[noOfComponents];
								for(int i=0;i<noOfComponents;i++)
								{
									components[i]=componentTokens.nextToken();
								}
								for(int i=0;i<components.length;i++)
								{
									if(components[i].indexOf(":")!=-1)
									{
										String componentName=components[i].substring(0,components[i].lastIndexOf(":"));
										String componentType=components[i].substring(components[i].lastIndexOf(":")+1);
										sbVals.append(componentName+":"+mappingInfo.getComponentTypeDescription(componentType));
									}
									else
									{
										sbVals.append(mappingInfo.getComponentTypeDescription(components[i])+"|");
									}
									if(i<components.length-1)
									{
										sbVals.append(",");
									}
								}
								if(sbVals!=null)
									displayValue = sbVals.toString();
							}
						}
						else if(selectionType!=null && selectionType.trim().equalsIgnoreCase("Selected Tests"))
						{
							if(value!=null)
							{
								StringBuffer sbVals = new StringBuffer(256);
								//String tests[]=value.split(",");
								StringTokenizer testTokens=new StringTokenizer(value,",");
								int noOfTests=testTokens.countTokens();
								String tests[]=new String[noOfTests];
								for(int i=0;i<noOfTests;i++)
								{
									tests[i]=testTokens.nextToken();
								}
								for(int i=0;i<tests.length;i++)
								{
									sbVals.append(mappingInfo.getTestDescription(tests[i]));
									if(i<tests.length-1)
									{
										sbVals.append(",");
									}
								}
								if(sbVals!=null)
									displayValue = sbVals.toString();
							}
						}
						else if(selectionType!=null && selectionType.trim().equalsIgnoreCase("Selected Combinations"))
						{
							if(value!=null && value.trim().endsWith(","))
							{
								value=value.substring(0,value.length()-1);
							}
							StringTokenizer selectionsTokens=new StringTokenizer(value,",");
							Vector selections=new Vector();
							Vector combinations=new Vector();
							String test="";
							String measure="";
							StringBuffer sbVals = new StringBuffer(256);
							while(selectionsTokens.hasMoreTokens())
							{
								//selections.addElement();
								String selectionString=selectionsTokens.nextToken();
								if(selectionString!=null && selectionString.indexOf("|")!=-1)
								{
									if(selectionString!=null && !selectionString.trim().equals(""))
									{
										StringTokenizer combinationTokens=new StringTokenizer(selectionString,"|");
										while(combinationTokens.hasMoreTokens())
										{
											if(selectionString!=null && selectionString.indexOf("||")!=-1)
											{
												sbVals.append(combinationTokens.nextToken()+"|");
											}
											if(combinationTokens.hasMoreTokens())
											{
												String componentToken=combinationTokens.nextToken();
												if(componentToken.indexOf(":")!=-1)
												{
													String componentName=componentToken.substring(0,componentToken.lastIndexOf(":"));
													String componentType=componentToken.substring(componentToken.lastIndexOf(":")+1);
													sbVals.append(componentName+":"+mappingInfo.getComponentTypeDescription(componentType)+"|");
												}
												else if(componentToken!=null && componentToken.length()>0)
												{
													sbVals.append(mappingInfo.getComponentTypeDescription(componentToken)+"|");
												}
											}
											if(combinationTokens.hasMoreTokens())
											{
												sbVals.append(mappingInfo.getLayerDescription(combinationTokens.nextToken()));
											}
											if(combinationTokens.hasMoreTokens())
											{
												test=combinationTokens.nextToken();
												sbVals.append("|"+mappingInfo.getTestDescription(test));
											}
											if(combinationTokens.hasMoreTokens())
											{
												measure=combinationTokens.nextToken();
												sbVals.append("|"+mappingInfo.getMeasureDescription(test,measure));
											}
											if(combinationTokens.hasMoreTokens())
											{
												sbVals.append("|"+combinationTokens.nextToken());
											}
										}
										if(selectionsTokens.hasMoreTokens())
										{
											sbVals.append(",");
										}
									}
								}
								else
								{
									if(selectionString.indexOf(":")!=-1)
									{
										String componentName=selectionString.substring(0,selectionString.lastIndexOf(":"));
										String componentType=selectionString.substring(selectionString.lastIndexOf(":")+1);
										sbVals.append(componentName+":"+mappingInfo.getComponentTypeDescription(componentType));
									}
									else if(selectionString!=null && selectionString.length()>0)
									{
										sbVals.append(mappingInfo.getComponentTypeDescription(selectionString));
									}
									if(selectionsTokens.hasMoreTokens())
									{
										sbVals.append(",");
									}
								}
							}
							if(sbVals!=null)
								displayValue = sbVals.toString();
						}
						else if(selectionType!=null && selectionType.trim().equalsIgnoreCase("Selected Timeline"))
						{
							displayValue =titname+subtitname;
						}
						else
						{
							displayValue =  value;
						}
					}
					else
					{
						displayValue =  value;
					}
				}
				if(count%2==0)
				{
					trContent.put("Report_name",displayValue);
				}
				else
				{	
					if(displayValue.endsWith("last")){
						String lastCount = displayValue.substring(0, displayValue.indexOf(DateTimeTokenizer.BLANK_SPACE));
						String lastTime = displayValue.substring(displayValue.indexOf(DateTimeTokenizer.BLANK_SPACE)+1, displayValue.length());
						String tmpStr = lastTime.substring(0, displayValue.lastIndexOf("_")-2);
						if(lastCount.equals("1")){
							displayValue = "Last " + tmpStr ;
						}else{
							displayValue = "Last " + lastCount + " " + tmpStr;
						}						
					}
					trContent.put("Report_value",erUtils.specialCharDecode(displayValue));
				}
				count++;
			}
			tableContent.add(trContent);
		}
		session.setAttribute("sch_AuditLogValue",AuditLogValue);
		if(showModifyLink)
		{
			screenLabels.put("reporter.common.SAVE",mappingInfo.getTextDescription("reporter.common.SAVE"));
			screenLabels.put("reporter.common.VIEW",mappingInfo.getTextDescription("reporter.common.VIEW"));
		}
		else
		{
			screenLabels.put("reporter.common.SAVE",mappingInfo.getTextDescription("reporter.common.SAVE"));
		}
		String QueryString ;
		if(isViaResizePopUp!=null && isViaResizePopUp.equals("true"))
		{
			QueryString =(String)ErUtils.prepareQueryString(schreqMap);
		}
		else
		{
			 QueryString =(String)ErUtils.prepareQueryString(request.getParameterMap());
		}
		String comeFrom=request.getParameter("come_from");
		// Back Button - Start
		ArrayList listbackvar = new  ArrayList();
		if(QueryString!=null)
		{
			if(comeFrom!=null && comeFrom.equalsIgnoreCase("ViewSchedule"))
			{
				
				session.setAttribute("reportLastAccessedURL","../servlet/com.eg.ErSchedulerC?"+QueryString);
				listbackvar.add("/reporter/ErViewSchedule.jsp?");
				listbackvar.add(QueryString);
				String backadded = erhelputils.getBackID();
				backreqMap = erhelputils.setBackQueryMap(backreqMap,backadded,listbackvar);
				session.setAttribute("backQuery",backreqMap);
			}
		}
		 JSONArray sBookletInfo = null;
		 JSONObject tmpObj = null;
         String isNew = "false";
		 ErScheduleBookletBean sbBean = new ErScheduleBookletBean();
		 String userIDSBooklet = ((ErUserData) session.getAttribute("UBean")).getUserId();
         ErScheduleBookletBean[] sbBeanArray = sbBean.getScheduleBookletInfo(userIDSBooklet);
		 sBookletInfo = new JSONArray();
		 
		 tmpObj = new JSONObject();
		 tmpObj.put("displayField",mappingInfo.getTextDescription("reporter.common.New Booklet"));
		 tmpObj.put("valueField", "0");
		 sBookletInfo.add(tmpObj);
		String bookletID = null;
		if(task!=null)
		{
			bookletID = task.sBookletID;
		}
		if(sbBeanArray!=null && sbBeanArray.length>0)
		{
			for(int i=0;i<sbBeanArray.length;i++)
			{
				ErScheduleBookletBean sbArray =  sbBeanArray[i];
				tmpObj = new JSONObject();
				tmpObj.put("displayField",sbArray.scheduleBookletName);
				tmpObj.put("valueField", sbArray.scheduleBookletID);
				sBookletInfo.add(tmpObj);
			}
	   }
	   else
	   {
		 isNew = "true";
	   }
		/*if(sBookletInfo!= null)
		{
			tmpObj = new JSONObject();
			tmpObj.put("displayField",mappingInfo.getTextDescription("reporter.common.New Booklet"));
			tmpObj.put("valueField", "0");
			sBookletInfo.add(tmpObj);
		}*/
		json.put("tableContent",tableContent);
		json.put("pageParams",pageParams);
		json.put("hiddenParams",hiddenParams);
		json.put("screenLabels",screenLabels);
		json.put("mailFreqJSON",mailFreqJSON);
		json.put("mailOnJSON",mailOnJSON);
		json.put("mailOnJSON1",mailOnJSON1);
		json.put("scheduleTypeJson",scheduleTypeJson);
		json.put("scheduleMailFormatJson",scheduleMailFormatJson);
		json.put("scheduleMailreceiveTypeJson",scheduleMailreceiveTypeJson);
		json.put("hrsComboJSON",hrsComboJSON);
		json.put("minsComboJSON",minsComboJSON);
		json.put("sBookletInfoJSON",sBookletInfo);
		if(bookletID!=null && bookletID.trim().length()>0)
		{
			json.put("isBooklet",true);
		}
		else
		{
			json.put("isBooklet",false);
		}
		//Back Button - End
		response.getWriter().write(json.toString());
		session.removeAttribute("schedulePageReqAttrs");
	}
	catch(Exception e)
	{
		e.printStackTrace();
	}
%>
<%!
	public boolean isCSVEnabledForReport(Map sch_details)
	{
		boolean isCSVFormatEnabled = false;
		String er_type = "";
		String er_reportType = "";
		String strSubtype = "";
		String er_rtype = "";
		try
		{
			er_type = (String)sch_details.get("er_type");
		}
		catch(ClassCastException e)
		{
			er_type=((String[])sch_details.get("er_type"))[0];
		}
		try
		{
			er_reportType = (String)sch_details.get("er_reportType");
		}
		catch(ClassCastException e)
		{
			er_reportType=((String[])sch_details.get("er_reportType"))[0];
		}
		try
		{
			strSubtype=(String)sch_details.get("er_trgttype");
		}
		catch(ClassCastException e)
		{

			strSubtype=((String[])sch_details.get("er_trgttype"))[0];
		}
		try
		{
			er_rtype =(String)sch_details.get("er_rtype");
		}
		catch(ClassCastException e)
		{
			if(((String[])sch_details.get("er_rtype"))[0]!=null )
				er_rtype =((String[])sch_details.get("er_rtype"))[0];
		}
		String isJSerrorReport="";
		try
		{
			isJSerrorReport =(String)sch_details.get("isJSerrorReport");
		}
		catch(ClassCastException e)
		{
			if(((String[])sch_details.get("isJSerrorReport"))[0]!=null )
				isJSerrorReport =((String[])sch_details.get("isJSerrorReport"))[0];
		}
		if(isJSerrorReport!=null && isJSerrorReport.equalsIgnoreCase("true"))
			isCSVFormatEnabled=false;
		else if(strSubtype!=null && (strSubtype.equalsIgnoreCase("Hit Count Report") || strSubtype.equalsIgnoreCase("Comparison")))
			isCSVFormatEnabled=false;
		else if(strSubtype!=null && (strSubtype.equals("User Report") || strSubtype.equals("Alarm History Report") ||  strSubtype.equals("Unknown History Report") ||  strSubtype.equals("Server Report") ||  strSubtype.equals("Aggregation Report") ||  strSubtype.equals("PrinterMgt") || strSubtype.equals("Consolidated Report") ||strSubtype.equals("VmGuestStatus_Report")||strSubtype.equals("VM Right Sizing")||strSubtype.equals("VMReport_esxStoreReport")|| strSubtype.equals("Virtual Capacity")|| strSubtype.equals("Cumulation") || strSubtype.startsWith("Logon Failure") || strSubtype.startsWith("VM Unregistered Machine") || strSubtype.equals("Citrix Machine Report") || strSubtype.equals("ApplicationCrashFault")))
			 isCSVFormatEnabled = true;
		else if (er_rtype!=null && (er_rtype.equalsIgnoreCase("SnapShot") || er_rtype.equalsIgnoreCase("WyseReport")))
			isCSVFormatEnabled = true;
		else if(er_type!=null && er_type.equalsIgnoreCase("No"))
			isCSVFormatEnabled = true;
		else if (er_reportType!=null && er_reportType.equalsIgnoreCase("data"))
			isCSVFormatEnabled = true;
		else if (er_rtype!=null && er_rtype.equalsIgnoreCase("Comparison"))
		{
			if(strSubtype!=null && (strSubtype.equalsIgnoreCase("Tests")||strSubtype.equalsIgnoreCase("Components")))
				isCSVFormatEnabled = true;
		}
		else if(er_rtype != null && er_rtype.equalsIgnoreCase("Builder"))
			isCSVFormatEnabled = true;
		else if(er_rtype != null && er_rtype.equalsIgnoreCase("VMAppVolume") && strSubtype != null && (strSubtype.equalsIgnoreCase("appStackDetails") || strSubtype.equalsIgnoreCase("userDetails"))){
			isCSVFormatEnabled = true;
		}else if(er_rtype!=null && (er_rtype.equalsIgnoreCase("Capacity+Planning") || er_rtype.equalsIgnoreCase("Capacity Planning")) && strSubtype!=null && strSubtype.equalsIgnoreCase("Overview"))
			isCSVFormatEnabled = true;
		if(strSubtype!=null && strSubtype.equals("VmGuestStatus_Report"))
		{
			if(er_rtype!=null && er_rtype.equals("Yes"))
			{
				isCSVFormatEnabled=false;
			}
		}
		return isCSVFormatEnabled;
	}
%>
