<!DOCTYPE html>
<%
/*******************************************************************************
*	File name		:	ErMeasure.jsp
*	Purpose			:	This page Handles a single Line chart
*	Version			:	Reporter 1.0
*	Creation Date	:	29/01/2003 - (dd/mm/yyyy)
*	Author			:	Krishnakumar.C
*	Last Modified	:
							7/12/05 - Citrix Report Changes-09/08/2004  M.Saravanan
							bug fixed-02/08/2004  M.Saravanan
							Table border changed & Mail Feature added-30/07/2004  M.Saravanan
							Descriptor alignment changed---20/07/2004  M.Saravanan
							TimeLine Selection added,Icon Added
							22/05/2004 - solomon - enhanced to support filtering infos.
							7/1/2004	 - Solomon //javascript:saveMe() function is changed
*							22/10/2003  Karthick -Snap shot specific changes
*							21/02/2003	Arun	Add PDF-saving support
*							17/07/2003	Gopi/Karthick Comparison feature specific changes

*******************************************************************************/
%>

<%@ include file="ErTracker.jsp" %>
<%@ page import = "java.util.*" %>
<%@ page import = "java.text.SimpleDateFormat" %>
<%@ page import = "egurkha.reporter.*" %>
<%@ page import = "com.eg.EgDateInfo"%>
<%@ page import = "com.eg.EgTablesInfo" %>
<%@ page import = "com.eg.IniFile" %>
<%@ page import = "com.eg.EgInstallInfo" %>
<%@ page import = "com.eg.EgURLEncoder" %>
<%@ page import = "com.eg.EgURLDecoder"%>
<%@ page import = "com.eg.EgExternalInfo" %>
<%@ page import = "com.eg.EgSpecsInfo" %>
<%@ page import = "com.eg.ErDbServer" %>
<%@ page import = "com.eg.EgMappingInfo" %>
<%@ page import = "egurkha.TestBean" %>
<%@ page import = "java.net.URLEncoder" %>
<%@ page import = "java.net.URLDecoder" %>
<%@ page import = "egurkha.reporter.ErReportHelper" %>
<%@ page import = "com.eg.EgThresholdInfo" %>
<%@ page import = "com.egurkha.util.StringUtils" %>
<%@ page import = "com.egurkha.util.DateTimeTokenizer" %>
<%@ page import = "com.eg.EgDbInfo" %>
<%@ page import = "com.egurkha.util.DateUtil" %>
<%@ page import = "com.eg.EgConfigInfo"%>
<%@ page import = "net.sf.json.*"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>

<jsp:useBean id="dd" scope="page" class="com.egurkha.monitor.EgDiagnosisBean" />
<%@ page import = "com.egurkha.ini.IniUI" %>
<%
try
{
//	pageContext.forward("/final/reporter/ErMeasureJSON.jsp");

	JSONObject rootJson = new JSONObject();
	JSONObject labelObj = new JSONObject();
	String queryString = ErUtils.prepareQueryString(request.getParameterMap());
	String st_componentNew = request.getParameter("er_component");
	request.setCharacterEncoding("UTF-8");
	com.egurkha.ini.IniUI ui = (com.egurkha.ini.IniUI)com.egurkha.ini.IniUI.getInstance();
	UserRegistry mregistry = UserRegistry.getInstance();
	User muser = mregistry.getUser(session.getId());
	String thisLanguage = ui.getDefaultLanguage();
	EgDbInfo dbInfo=new EgDbInfo("manager");
	String pdfPrint = request.getParameter("pdfPrint");
	String drillDown = request.getParameter("drillDown");
	String drilldownenabled = request.getParameter("drilldownenabled");
	IniFile egFormat = new IniFile(EgInstallInfo.getInstallDir()+ "/manager/config/eg_format.ini");
	String mngrIProc = new IniFile(new EgConfigInfo("manager").getDbFile()).getValue("DB_PROPERTIES","ManagerUrl");
	if (muser!=null)
	{
		String userLang = muser.getLanguage();
		if (userLang!=null && !userLang.equalsIgnoreCase("NULL"))
		{
			thisLanguage=userLang;
		}
	}
	String sample = request.getParameter("sample");
	if(sample == null)
	{
		sample = "no";
	}
	ArrayList singleColors = new ArrayList();
	ArrayList singleSelection = new ArrayList();
	Map reqMap = request.getParameterMap();
	Hashtable erComparisonMap = new Hashtable(reqMap);
	ErReqData erd = new ErReqData(request);
	boolean showLegendAsHtml = true;
	if(erd.s_gtype !=null && erd.s_gtype.equalsIgnoreCase("Comparison"))
	{
		ErComparisonBean erc = new ErComparisonBean();
		erc.initRequest(request);
 		erc.processData();
		singleColors = erc.singleColors;
		singleSelection = erc.singleSelection;
	}
	else if(erd.s_gtype != null && erd.s_gtype.equalsIgnoreCase("Measure"))
	{
		ErMicroTime ermicro = new ErMicroTime();
		ermicro.initRequest(request);
		ermicro.initRequest(erComparisonMap);
		ermicro.processData();
		singleColors = ermicro.singleColors;
		singleSelection = ermicro.singleSelection;
		showLegendAsHtml = ermicro.IsShowLegendAsHtml();
	}
	else if(erd.s_gtype !=null && (erd.s_gtype.equalsIgnoreCase("interSnap")||erd.s_gtype.equalsIgnoreCase("intrasnap")||erd.s_gtype.equalsIgnoreCase("Citrix")))
	{
		ErSnapshot ersnap = new ErSnapshot();
		ersnap.initRequest(request);
 		ersnap.initRequest(erComparisonMap);
		//ersnap.processData("");
		ersnap.snapShotProcessGraph();
		singleColors = ersnap.singleColors;
		singleSelection = ersnap.singleSelection;

	}
	EgMappingInfo mappingInfo=new EgMappingInfo(thisLanguage);
	TestBean testBean = new TestBean();
	EgExternalInfo extInfo=new EgExternalInfo("Manager");
	ErInfo erInfo=new ErInfo();
	int count = 0;
	double d_min = 0;
	double d_max = Double.MAX_VALUE;
	int maxInfo = (new ErReportHelper()).getMaxInfos("INFOS","MaxInfos");
	boolean showFilter = false;
	String strCommonMax = request.getParameter("er_commonMax");
	String strCommonMaxRangeValue = request.getParameter("er_commonMaxRange");
	String strAutoCommonMax = request.getParameter("er_AutoCommonMax");

	String s_filter = request.getParameter("er_filter");
	if(s_filter == null || s_filter.equals("")) s_filter = "INFO";

	String s_min ="";
	String s_max ="";

	if ("RANGE".equalsIgnoreCase(s_filter))
	{
		s_min = request.getParameter("er_range_min");
		s_max = request.getParameter("er_range_max");
	}

	String s_priority = request.getParameter("er_priority");
	EgSpecsInfo eSpec = new EgSpecsInfo("manager");
	EgInstallInfo installInfo = new EgInstallInfo();
	EgTablesInfo tablesInfo = new EgTablesInfo("manager");
	ErUtils erUtils = new ErUtils();
	ErReportHelper er_rpthelper = new ErReportHelper();
	String s_qry_string = request.getQueryString();
	String info=request.getParameter("er_info_list");
	int i_serv_port = request.getServerPort();
	String s_serv_name = installInfo.getUrlPrefix()+"//" +request.getServerName();
	String s_serv_pdf = installInfo.getUrlPrefix()+"//" +eSpec.getEGServer() + ":" + i_serv_port;

	String uiFile = "eg_ui.ini";
	String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile egUI = new IniFile(s_iniFile_dir + uiFile);
	String currentDateFormat = egUI.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
	EgDateInfo egDt = new EgDateInfo();

	String[] options = {"Any","10 mins","15 mins","30 mins","45 mins","1 hour", "2 hours", "3 hours", "6 hours", "12 hours", "18 hours", "1 day", "2 days", "3 days", "4 days", "5 days", "6 days"};

	String s_st_time = request.getParameter("startdate");
	String s_en_time = request.getParameter("enddate");
	String s_st_hr = request.getParameter("starthr");
	String s_en_hr = request.getParameter("endhr");
	String startMin = request.getParameter("startmin");
	String endMin = request.getParameter("endmin");
	String er_timeline=request.getParameter("er_timeline");
	String trendenable=request.getParameter("er_trend");
	String s_trenddata=request.getParameter("er_trenddata");
	String strStartTime = s_st_time+" "+s_st_hr+":"+startMin+":00";
	String strEndTime = s_en_time+" "+s_en_hr+":"+endMin+":00";
	if(s_trenddata==null)
		s_trenddata="No";


	String disable="";
	String dispDate = null;
	String comFormat = null;
	String startDateTime="";
	String endDateTime="";
	String port ="";

	if(er_timeline!=null)
		er_timeline=URLDecoder.decode(er_timeline);
	if(er_timeline==null)
	{
		er_timeline="1 Day";
	}
	String[] opt=new String[21];
	String gtype=request.getParameter("er_gtype");
	String snaptim=request.getParameter("snaptime");
	String period=request.getParameter("er_period");
	String er_time=request.getParameter("er_time");
	String isOnlyVMAssigned=request.getParameter("isOnlyVMAssigned");
	String isFromAlarmHistory=request.getParameter("isFromAlarmHistory");
	String strScreenWidth = request.getParameter("screenWidth");
	int screenWidth = 990;
	try{
		screenWidth = Integer.parseInt(strScreenWidth);
	}
	catch(Exception e)
		{screenWidth = 990;}
	
	if(isOnlyVMAssigned==null || isOnlyVMAssigned.equals(""))
		isOnlyVMAssigned="false";
	if(isFromAlarmHistory==null || isFromAlarmHistory.equals(""))
		isFromAlarmHistory="false";
	if(period==null ||er_time==null)
	{
		period="";
		er_time="";
	}
	if("Summary".equalsIgnoreCase(gtype))
	{
		if("M".equalsIgnoreCase(request.getParameter("er_period")))
		{
			opt=new String[]{"Any","3 months","6 months","9 months","12 months"};
		}
		else
		{
			opt=new String[]{"Any","1 day", "2 days", "3 days", "4 days", "5 days", "6 days","1 week","2 weeks","3 weeks","4 weeks","1 month"};
		}

	}
	else
	{
		if("intrasnap".equalsIgnoreCase(gtype)&& snaptim!=null && snaptim.equals("Yes"))
		{
			opt=new String[]{"Any","10 mins","15 mins","30 mins","45 mins","1 hour", "3 hours", "6 hours", "9 hours", "12 hours", "15 hours", "18 hours", "21 hours","1 day", "2 days", "3 days", "4 days", "5 days", "6 days","1 week","2 weeks","3 weeks","4 weeks","1 month"};
		}
		else
		{
			if(s_trenddata.equals("Yes"))
			{
				opt=new String[]{"Any","1 day", "2 days", "3 days", "4 days", "5 days", "6 days","1 week","2 weeks","3 weeks","4 weeks","1 month"};
			}
			else
			{
				opt=new String[]{"Any","1 hour", "3 hours", "6 hours", "9 hours", "12 hours", "15 hours", "18 hours", "21 hours","1 day", "2 days", "3 days", "4 days", "5 days", "6 days","1 week","2 weeks","3 weeks","4 weeks","1 month"};
			}
		}
	}
	List alist = Arrays.asList(opt);
	String loginName = muser.getLoginID();
	String strUsrTimeline = er_rpthelper.getUserTimeline(loginName);
	int len;
	if(strUsrTimeline != null && !strUsrTimeline.equals("") && !strUsrTimeline.equalsIgnoreCase("-1"))
	{
		len = alist.indexOf(strUsrTimeline)+1;
	}
	else
	{
		len = opt.length;
	}

	if(er_timeline!=null&&!er_timeline.equals("Any"))
	{
		disable ="disabled";
	}

	long msecsPerHour = (long) 1000 * 60 * 60;
	int blankSpaceIndex =0;
	long val=0;
	String unit="";
	if(er_timeline!=null&&!er_timeline.equals("Any"))
	{
		blankSpaceIndex = er_timeline.indexOf(DateTimeTokenizer.BLANK_SPACE);
		val= Integer.parseInt(er_timeline.substring(0, blankSpaceIndex));
		unit = er_timeline.substring(blankSpaceIndex+1).toLowerCase();
	}
	if(er_timeline!=null&&!er_timeline.equals("Any")&& gtype!=null && !gtype.equals("Summary"))
	{
		if(blankSpaceIndex > 0)
		{
			SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy HH:mm");
			java.util.Date today = egDt.egetRealDate();
			endDateTime = sdf.format(today);

			if(s_trenddata!=null && s_trenddata.equals("No") && !"Summary".equalsIgnoreCase(gtype))
			{
				endDateTime = sdf.format(today);
			}
			else
			{
				endDateTime = sdf.format(today);
			}
			if(unit.startsWith("mi"))
			{
				val *= (60);
			}
			else if (unit.startsWith("h"))
			{//hours
				val *= 3600;
			}
			else if (unit.startsWith("d"))
			{//days
				val *= (24 * 3600);
			}
			else if (unit.startsWith("w"))
			{//weeks
				val *= (7 * 24 * 3600);
			}
			else if (unit.startsWith("mo"))
			{//months
				if(s_trenddata != null && s_trenddata.equals("No"))
				{
					java.util.Date dt_temp = new java.util.Date(egDt.egetUTCDate());
					Calendar cal_temp = new GregorianCalendar();
					cal_temp.setTime(dt_temp);
					//cal_temp.add(Calendar.DATE,-1);
					cal_temp.add(Calendar.HOUR_OF_DAY,0);
					java.util.Date dt_temp1 = cal_temp.getTime();
					long l_temp = dt_temp1.getTime();
					int totalDays = 24*(ErUtils.getMaxDaysInMonth());
					startDateTime = egDt.egetDate(l_temp -(long)( (val*totalDays * msecsPerHour)));
					startDateTime = DateUtil.changeDateFormat(startDateTime,"dd/MM/yyyy HH:mm","MM/dd/yyyy HH:mm");
				}
				else
				{
					java.util.Date dt_temp = new java.util.Date(endDateTime);
					Calendar cal_temp = new GregorianCalendar();
					cal_temp.setTime(dt_temp);
					cal_temp.add(Calendar.HOUR_OF_DAY,0);
					java.util.Date dt_temp1 = cal_temp.getTime();
					long l_temp = dt_temp1.getTime();
					int  totalDays=24*(ErUtils.getMaxDaysInMonth());
					startDateTime = egDt.egetDate(l_temp -(long)( (val*totalDays * msecsPerHour)));
					startDateTime = DateUtil.changeDateFormat(startDateTime,"dd/MM/yyyy HH:mm","MM/dd/yyyy HH:mm");
				}
			}
			if (unit!= null && !unit.startsWith("mo"))
			{
				java.util.Date start = new java.util.Date();
				start.setTime(today.getTime() - (val * 1000));
				startDateTime = sdf.format(start);
			}
		}
		if ((startDateTime != null) && (endDateTime != null))
		{
			int shr = Integer.parseInt(startDateTime.substring(startDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE)+1, startDateTime.indexOf(":")));
			int en_hr = Integer.parseInt(endDateTime.substring(endDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE)+1, endDateTime.indexOf(":")));
			s_en_time=endDateTime.substring(0, endDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE));
			s_st_time=startDateTime.substring(0, startDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE));
			startMin = String.valueOf(startDateTime.substring(startDateTime.indexOf(":")+1));
			endMin = String.valueOf(endDateTime.substring(endDateTime.indexOf(":")+1));

			if(s_trenddata!=null)
			{
				if(s_trenddata.trim().equals("Yes")|| gtype.equalsIgnoreCase("Summary"))
				{
					s_st_hr  = String.valueOf(0);
					s_en_hr  = String.valueOf(0);
					startMin = "00";
					endMin   = "00";
				}
			}
		}
	}
	else if(er_timeline!=null&&!er_timeline.equals("Any")&&gtype!=null &&gtype.equals("Summary"))
	{
		if (unit.startsWith("d"))
		{
			val= 24*val;
		}
		if (unit.startsWith("w"))
		{
			val=168*val;
		}
		if (unit.startsWith("mo"))
		{
			SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy HH:mm");
			java.util.Date thisDay = egDt.egetRealDate();
			String endDatTime = sdf.format(thisDay);
			val = (ErUtils.getTotalDays(endDatTime,val))*24;
		}
		erd.s_end_time = egDt.egetDate(egDt.egetUTCDate());
		if(erd.s_period.equalsIgnoreCase("H"))
		{
			erd.s_start_time = egDt.egetDate(egDt.egetUTCDate() - ((long)((long)val * (long)msecsPerHour)));
			erd.s_start_time = (erd.s_start_time.substring(0, erd.s_start_time.indexOf(":"))) + ":00:00";
			erd.s_end_time = (erd.s_end_time.substring(0, erd.s_end_time.indexOf(":"))) + ":00:00";
			long i_timeline = 0;
			if(er_time !=null){
				i_timeline = val;
			}

			if((i_timeline < 24)){
				erd.s_sthr = erd.s_start_time.substring(erd.s_start_time.indexOf(" ")+1,erd.s_start_time.indexOf(":"));
				erd.s_endhr = erd.s_end_time.substring(erd.s_end_time.indexOf(" ")+1,erd.s_end_time.indexOf(":"));
			}else
			{
				long l_temp = (long)((long)egDt.egetUTCDate(erd.s_start_time)+(long)(24l * (long)msecsPerHour));
				erd.s_start_time = (erd.s_start_time.substring(0, erd.s_start_time.indexOf(" "))) + " 00:00:00";
				erd.s_end_time = (erd.s_end_time.substring(0, erd.s_end_time.indexOf(" "))) + " 00:00:00";
				s_st_hr = "0";
				s_en_hr = "0";
			}
		}
		else if(erd.s_period.equalsIgnoreCase("D"))
		{
			erd.s_start_time = egDt.egetDate(egDt.egetUTCDate() - ((long)((long)val * (long)msecsPerHour)));
			erd.s_end_time = egDt.egetDate(egDt.egetUTCDate());
			erd.s_start_time = (erd.s_start_time.substring(0,
			erd.s_start_time.indexOf(" "))) + " 00:00:00";
			erd.s_end_time = (erd.s_end_time.substring(0, erd.s_end_time.indexOf(" "))) + " 00:00:00";
			s_st_hr = "0";
			s_en_hr = "0";
		}
		else if(erd.s_period.equalsIgnoreCase("M"))
		{
			erd.s_start_time = egDt.egetDate(egDt.egetUTCDate() - ((long)((long)val * (long)msecsPerHour)));
			erd.s_start_time = (erd.s_start_time.substring(0, erd.s_start_time.indexOf(" "))) + " 00:00:00";
			long l_st = egDt.egetUTCDate(erd.s_start_time);
			long l_end = egDt.egetUTCDate(erd.s_end_time);
			erd.s_end_time = erd.s_end_time = egDt.egetDate(egDt.egetUTCDate());
			erd.s_end_time = (erd.s_end_time.substring(0, erd.s_end_time.indexOf(" "))) + " 00:00:00";
			erd.s_sthr="0";
			erd.s_endhr="0";
			erd.s_startmin="0";
			erd.s_endmin="0";
		}
		s_st_time = erd.s_start_time.substring(0,erd.s_start_time.indexOf(" "));
		s_en_time = erd.s_end_time.substring(0,erd.s_end_time.indexOf(" "));
		s_st_time = DateUtil.changeDateFormat(s_st_time,"dd/MM/yyyy","MM/dd/yyyy");
		s_en_time = DateUtil.changeDateFormat(s_en_time,"dd/MM/yyyy","MM/dd/yyyy");
		s_st_hr = "0";
		s_en_hr = "0";
		startMin= "0";
		endMin  = "0";
	}


	if(er_timeline!=null&&er_timeline.equals("Any"))
	{
		String StrDate="";
		try
		{
			java.text.SimpleDateFormat df=new java.text.SimpleDateFormat("MM/dd/yyyy k 'at' hh:mm");
			StrDate =df.format(new java.util.Date());
		}
		catch(Exception ee)
		{
			System.out.println("Exception is"+ee);
		}
		String SDate =StrDate.substring(0,StrDate.indexOf(" "));
		String shour =StrDate.substring(StrDate.indexOf(" "),StrDate.lastIndexOf(""));
		shour = shour.substring(0,3);
		if(s_st_time==null)
		{
			s_st_time=SDate;
		}
		if(s_en_time==null)
		{
			s_en_time=SDate;
		}
		if(s_st_hr==null)
		{
			shour =shour.trim();
			int starthr = Integer.parseInt(shour);
			starthr = starthr-1;
			s_st_hr=String.valueOf(starthr);
		}
		if(s_en_hr==null)
		{
			shour =shour.trim();
			s_en_hr =shour;
		}
		if(gtype.trim().equalsIgnoreCase("intrasnap"))
		{
			if(startMin==null)
				startMin = StrDate.substring(StrDate.indexOf(":")+1);
			if(endMin==null)
				endMin = StrDate.substring(StrDate.indexOf(":")+1);
		}
		else
		{
			startMin = "00";
			endMin   = "00";
		}
	}


	String s_control_servlet = "/final/servlet/com.eg.";
	String compType = "";
	String er_info = "";
	Enumeration ew=request.getParameterNames();
	StringBuffer sb=new StringBuffer();
	String site=request.getParameter("er_site");

	/*try
	{
		while(ew.hasMoreElements())
		{
			String name=ew.nextElement().toString();
			sb.append(name).append("=").append(request.getParameter(name)).append("&");
		}
	}catch(Exception e)
	{
		e.printStackTrace();
	}*/

		String qs=ErUtils.prepareQueryString(request.getParameterMap());
		System.out.println("qs:mb:"+qs);
		StringTokenizer strtokk = new StringTokenizer(qs,"&");
		String reportFor=null;
		while(strtokk.hasMoreTokens())
		{
				String param = strtokk.nextToken();
				if(param.indexOf("=")>-1)
				{
					String reqparam =param.substring(0,param.indexOf("="));
					String value = param.substring(param.indexOf("=")+1,param.length());
					sb.append(reqparam).append("=").append(value).append("&");
					if(reqparam!=null&& reqparam.equalsIgnoreCase("reportFor"))
						reportFor=value;

				}
		}

	String s_timeline=erd.s_timeline;
	int timeline=0;
	if((erd.s_gtype != null && erd.s_gtype.equalsIgnoreCase("Measure")|| erd.s_gtype.equalsIgnoreCase("Trend"))|| erd.s_gtype !=null && erd.s_gtype.equalsIgnoreCase("Comparison"))
	{

		if (reportFor!=null && reportFor.equalsIgnoreCase("CompareGraph"))
			s_qry_string = s_control_servlet + "ErCompareServersC?er_filter=" + s_filter+"&" + sb;
		else if (erd.s_gtype.equalsIgnoreCase("Measure"))
			s_qry_string = s_control_servlet +"ErMicroTimeC?er_filter=" + s_filter+"&"+sb;
		else if(erd.s_gtype.equalsIgnoreCase("Trend"))
			s_qry_string = s_control_servlet +"ErTrendC?er_filter=" + s_filter+"&"+sb;
		else if (erd.s_gtype.equalsIgnoreCase("Comparison"))
			s_qry_string = s_control_servlet + "ErCompareServersC?er_filter=" + s_filter+"&" + sb;

		if (erd.s_gtype.equalsIgnoreCase("Comparison"))
		{
			s_qry_string +="&er_commonMax="+strCommonMax+"&er_commonMaxRange="+strCommonMaxRangeValue+"&er_AutoCommonMax="+strAutoCommonMax; 
		}

		String trgttype = request.getParameter("er_trgttype");
		boolean showTop = true;
		String st_day="";
		String end_day="";
		if(trgttype!=null && trgttype.equals("CitrixUser"))
			showTop= false;
		if(showTop)
		{
			EgDbAdapterR egDb = ErDbServer.getObject();
			EgSpecsInfo specsInfo = new EgSpecsInfo("manager");
			boolean portReleventForTest = specsInfo.isPortRelevantForTest(erd.s_test);
			boolean siteReleventForTest = specsInfo.isSiteRelevantForTest(erd.s_test);
			if(er_timeline!=null&&!er_timeline.equals("Any"))
			{
				st_day=DateUtil.changeDateFormat(s_st_time,"MM/dd/yyyy","dd/MM/yyyy");
				end_day=DateUtil.changeDateFormat(s_en_time,"MM/dd/yyyy","dd/MM/yyyy");
			}
			else
			{
				st_day=DateUtil.changeDateFormat(s_st_time,currentDateFormat,"dd/MM/yyyy");
				end_day=DateUtil.changeDateFormat(s_en_time,currentDateFormat,"dd/MM/yyyy");
			}
			erd.range_stdate=st_day+" "+s_st_hr+ ":00:00";
			erd.range_enddate=end_day+" "+s_en_hr+ ":00:00";
			strStartTime = st_day+" "+s_st_hr+ ":00:00";
			strEndTime = end_day+" "+s_en_hr+ ":00:00";
			try
			{
				egDb.set_Connection();
				if (erd.s_tbound.equalsIgnoreCase("Fixed") || erd.s_tbound.equalsIgnoreCase("Any") && erd.s_stdate!=null && erd.s_enddate!=null)
				{
					egDb.dbsel(egDb.buildInfoDetails(erd,portReleventForTest,siteReleventForTest));
					if(egDb.rs.next())
					{
						count = egDb.rs.getInt(1);
						d_min = egDb.rs.getDouble(2);
						d_max = egDb.rs.getDouble(3);
					}
				}
			}catch(Exception e){
				System.out.println("Info "+e);
			}
			egDb.release_Connection(false);
			ErDbServer.releaseObject(egDb);
			showFilter = Math.min(5,maxInfo)<count;
			if (s_priority == null || s_priority.equals(""))
			{
				if(maxInfo < count)
				{
					//s_priority="TOP-" + maxInfo;
					EgThresholdInfo threshInfo = new EgThresholdInfo("manager");
					port = portReleventForTest?erd.s_port:"NULL";
					if(erd.s_dataFrom!=null && erd.s_dataFrom.equalsIgnoreCase("Service"))
					{
						//EgDbInfo dbInfo=new EgDbInfo("manager");
						String temp_measure=dbInfo.getMeasureForColumn(erd.s_test,erd.s_disp_meas);
						if(temp_measure!=null && !temp_measure.equals(""))
							erd.s_disp_meas=temp_measure;
					}
					String s_thresh[]= threshInfo.getThresholdAttributes(erd.s_test,erd.s_disp_meas,erd.s_host,port + (erd.s_info!=null && !erd.s_info.equals("")?":" + erd.s_info:""));
					s_priority = "TOP-" + maxInfo;
					if(!s_thresh[1].equals("-1") && s_thresh[2].equals("-1"))
						s_priority = "LAST-" + maxInfo;
				}
				else
				{
					s_priority = "ALL";
				}
			}

			if("RANGE".equalsIgnoreCase(request.getParameter("er_filter")))
			{
				s_qry_string += "&er_range_min=" + s_min + "&er_range_max=" + s_max;
			}
			else
			{
				s_qry_string += "&er_priority=" + s_priority;
			}
		}
	}
	else if(erd.s_gtype != null && erd.s_gtype.equalsIgnoreCase("Summary"))
	{
		s_qry_string = s_control_servlet + "ErSummaryC?" + sb;


	}
	else if(erd.s_gtype != null && erd.s_gtype.equalsIgnoreCase("intrasnap"))
	{
		if (s_priority == null || s_priority.equals(""))
		{
			EgSpecsInfo specsInfo = new EgSpecsInfo("manager");
			boolean portReleventForTest = specsInfo.isPortRelevantForTest(erd.s_test);
			if(maxInfo < count)
			{
				//s_priority="TOP-" + maxInfo;
				EgThresholdInfo threshInfo = new EgThresholdInfo("manager");
				port = portReleventForTest?erd.s_port:"NULL";
				if(erd.s_dataFrom!=null && erd.s_dataFrom.equalsIgnoreCase("Service"))
				{
					//EgDbInfo dbInfo=new EgDbInfo("manager");
					String temp_measure=dbInfo.getMeasureForColumn(erd.s_test,erd.s_disp_meas);
					if(temp_measure!=null && !temp_measure.equals(""))
						erd.s_disp_meas=temp_measure;
				}
				String s_thresh[]= threshInfo.getThresholdAttributes(erd.s_test,erd.s_disp_meas,erd.s_host,port + (erd.s_info!=null && !erd.s_info.equals("")?":" + erd.s_info:""));
				s_priority = "TOP-" + maxInfo;
				if(!s_thresh[1].equals("-1") && s_thresh[2].equals("-1"))
					s_priority = "LAST-" + maxInfo;
			}
			else
			{
				s_priority = "ALL";
			}
		}
	}

	/*	if(erd.s_gtype !=null && erd.s_gtype.equalsIgnoreCase("Comparison")){
		s_qry_string = s_control_servlet + "ErCompareServersC?" + sb;
	}*/

	if(erd.s_gtype !=null && (erd.s_gtype.equalsIgnoreCase("interSnap")||erd.s_gtype.equalsIgnoreCase("intrasnap")||erd.s_gtype.equalsIgnoreCase("Citrix")))
	{
		s_qry_string = s_control_servlet + "ErSnapshotC?" + sb;

	}
	Vector v_qry_string = new Vector();
	Vector v_pdf_qry = new Vector();

	String st_component = erd.s_component;
	String st_comp ="";
	String st_comptype ="";
	if(st_component!=null && st_component.indexOf(":")>-1)
	{
		st_comp = st_component.substring(0,st_component.lastIndexOf(":"));
		if(st_comp.indexOf(":NULL") >-1) {
			st_comp = st_comp.substring(0,st_comp.indexOf(":"));
		}
		st_comptype = st_component.substring(st_component.lastIndexOf(":")+1);
		st_component = st_comp+":"+mappingInfo.getComponentTypeDescription(st_comptype);
	}
	if(st_component == null)
	{
		st_component = request.getParameter("er_component");
	}
	String s_mes_unit = "";
	if(erd.s_test != null && erd.s_disp_meas != null)
	{
		if (erd.s_test.endsWith("_trend"))
		{
			erd.s_test=erd.s_test.substring(0,erd.s_test.lastIndexOf("_"));
			erd.s_measure=erd.s_measure.substring(0,erd.s_measure.lastIndexOf("_"));
		}
		s_mes_unit = tablesInfo.getUnitForMeasure(erd.s_test,erd.s_disp_meas);
	}
	if(erd.s_gtype!=null && erd.s_gtype.equalsIgnoreCase("Comparison"))
	{
		if(request.getParameter("er_nick")!= null && request.getParameter("er_nick").length()>0 && !request.getParameter("er_nick").equalsIgnoreCase("null"))
		{
			v_qry_string.add(request.getParameter("er_nick"));
			v_pdf_qry.add(request.getParameter("er_nick"));
		}
		else if(erd.s_component!=null)
		{
			v_qry_string.add(erd.s_component);
			v_pdf_qry.add(st_component);
		}
	}
	else
	{
		v_qry_string.add(erd.s_test + "/" + erd.s_disp_meas + " (" + s_mes_unit + ")");
		v_pdf_qry.add(mappingInfo.getTestDescription(erd.s_test) + "/" + mappingInfo.getMeasureDescription(erd.s_test,erd.s_disp_meas) + " (" + s_mes_unit + ")");
	}
	//s_qry_string += "&er_priority=" + s_priority;
	v_qry_string.add(s_qry_string);
	//v_pdf_qry.add(s_serv_pdf + s_qry_string+"&option=graph&er_legendPosition=right");
	String fontStyleDbl = "";
	String fontStyleDblSingl = "";
	if((dbInfo.doubleByteEnabled || !thisuser.getLanguage().equals("en_US")) && !(pdfPrint !=null && pdfPrint.equalsIgnoreCase("yes") || (sample != null && !sample.equalsIgnoreCase("yes") && drilldownenabled !=null && drilldownenabled.equalsIgnoreCase("yes"))))
	{
		fontStyleDbl = " multi_font";
		fontStyleDblSingl = "multi_font";
	}
	else
	{
		fontStyleDbl = "";
		fontStyleDblSingl = "";
	}
%>
<!Doctype html>
<head>
<%
		if(pdfPrint !=null && pdfPrint.equalsIgnoreCase("yes"))
		{
%>
		<title> &nbsp; <egui:intnl text="reporter.common.Reporter"/> &nbsp; - &nbsp;<egui:intnl text="reporter.common.Measure "/> &nbsp; </title>
<%
		}
		else
		{
%>
		<title>eG Reporter</title>
<%
		}
%>

<meta name="Author" content="">
<meta  charset="UTF-8">

<link rel="stylesheet" type="text/css" href="/final/styles/eGLightTheme.css" />
<link rel="stylesheet" type="text/css" href="/final/styles/eGLightThemeIcons.css" />
<link rel="stylesheet" type="text/css" href="../../final/reporter/styles/printpagestyle.css" />
<script src="/final/scripts/DD_roundies_0.0.2a-min.js"  type='text/javascript'></script>


<style type="text/css" media="print">
#printbt{ display:none}
</style>

<script language="JavaScript1.2" src="../reporter/scripts/er_imagesLite.js"></script>
<script language="JavaScript1.2" src="../reporter/scripts/er_date.js"></script>

<script language="JavaScript1.2" src="../reporter/scripts/er_validate.js"></script>
<script language="JavaScript1.2" src="../scripts/<%=script_src%>"></script>
<script language=javascript>

function openDDWin(qryString)
{
	//if(window.ddwin==null || ddwin.closed)
	ddwin = window.open(qryString,"<%=session.getId()%>DDWindow","width=1012,height=603,left=0,top=105,scrollbars=1,scrollbars=yes,resizable");
	ddwin.focus()
}
function showData(qryString)
{
	var opt="<%=request.getParameter("option")%>";
	qryString=qryString.replace("option="+opt,"option=data");

	if(!window.datawin)
	{
		datawin = window.open(qryString,"DataWindow","width=950,height=584,left=0,top=85,scrollbars=1,scrollbars=yes,resizable");
	}
	else
	{
		if(!datawin.closed)
		{
			datawin.focus();
		}
		else
		{
			datawin = window.open(qryString,"DataWindow","width=950,height=584,left=0,top=85,scrollbars=1,scrollbars=yes,resizable");
		}
	}
}
function printGraph(qryString)
{
	var controller=qryString.substring(qryString.indexOf("servlet/com.eg."),qryString.indexOf("?"));

	qryString=qryString.replace(controller,"reporter/ErMeasure.jsp");
	qryString += "&pdfPrint=yes";

	if(!window.printwin)
	{
		printwin = window.open(qryString,"PrintWindow","width=950,height=584,left=0,top=85,scrollbars=1,scrollbars=yes,resizable");
	}
	else
	{
		if(!printwin.closed)
		{
			printwin.focus();
		}
		else
		{

			printwin = window.open(qryString,"PrintWindow","width=950,height=584,left=0,top=85,scrollbars=1,scrollbars=yes,resizable");
		}
	}

}
function saveMe(qryString)
{
<%
	session.setAttribute("DRILLDOWN_PDF_URL", mngrIProc+"/final/reporter/ErMeasure.jsp");
%>

	var controller=qryString.substring(qryString.indexOf("servlet/com.eg."),qryString.indexOf("?"));

	qryString=qryString.replace(controller,"reporter/ErHtmlToSavePdf.jsp");

	if(!window.printwin)
	{
		printwin = window.open(qryString+"&sample=yes&drillSes=yes&","SaveWindow","width=400,height=150,left=300,top=200,scrollbars=no,resizable=no");
	}
	else
	{
			printwin = window.open(qryString+"&sample=yes&drillSes=yes&","SaveWindow","width=400,height=150,left=300,top=200,scrollbars=no,resizable=no");
	}

}
function sendMail()
{
	mailwin=window.open("../reporter/ErSendMail.jsp?keyPrefix=enlarged&DrillDown=yes","MailWindow","width=800,height=300,top=200,scrollbars=yes,resizable=no");
}
function closeWin()
{
	if(window.datawin !=null)
	{
		datawin.close();
	}
	if(window.ddWin !=null)
	{
		ddWin.close();
	}
	if(window.mailwin !=null)
	{
		mailwin.close();
	}
	if(window.ddwin!=null && !ddwin.closed)
		ddwin.close();

}
/*
function saveMe()
{
	var blankPage = "";
	if(location.protocol=="https:") blankPage="/final/blank.html";
	var win =window.open(blankPage,"SaveWindow","width=400,height=150,left=300,top=200,scrollbars=no,resizable=no");
	win.document.write("<html>");
	win.document.write("<title>Downloading</title>");
	win.document.write("<frameset rows= '0%,0%,*' frameborter='NO' border='0' framespacing='0'>");
	win.document.write("<frame src='/final/servlet/com.eg.SaveToPDF?keyPrefix=enlarged' frameborder=0 noresize scrolling=no name='Data'>");
	win.document.write("<frame src='/final/reporter/ErSaveStatus.jsp' frameborder=0 noresize scrolling=auto>");
	win.document.write("<frame src='" + blankPage + "' frameborder=0 noresize scrolling=auto name='statusPanel'>");
	win.document.write("</frameset>");
	win.document.write("</html>");
	win.frames[2].document.open("text/html","replace");
	win.frames[2].document.write('<html><head><egui:skin ui="reporter"/></head><body class="cellbglight"><br><br><h4 align="center" style="font-family: Verdana,Arial; font-size: 15px; color: #000000;"><img src="/final/reporter/images/load_round.gif" alt="<egui:intnl text="reporter.common.DOWNLOADING"/>" title="<egui:intnl text="reporter.common.DOWNLOADING"/>"><br><br>Downloading! Please wait...</h4></body></html>');
	win.frames[2].document.close();
}
*/
function chooseFilter()
{
	<%
		if(showFilter)
		{
	%>
			var thisForm = document.forms[0];
			var flag = thisForm.er_filter[0].checked;
			thisForm.er_priority.disabled = !flag;
			thisForm.er_range_min.disabled = flag;
			thisForm.er_range_max.disabled = flag;
			if (thisForm.er_filter[1].checked)
			{
				if(!checkblank(thisForm.er_range_min)) thisForm.er_range_min.value = <%=d_min%>
				if(!checkblank(thisForm.er_range_max)) thisForm.er_range_max.value = <%=d_max%>
			}else
			{
				thisForm.er_range_min.value ="";
				thisForm.er_range_max.value ="";
			}
			call();
	<%
		}else
		{
	%>
			call();
	<%
		}
	%>
}
function goTo(op)
{
	var flag=true;
	var startMin="";
	var endMin="";
	var bool="";
	var thisForm=document.forms[0];
	action="../reporter/ErMeasure.jsp?screenWidth="+old_width;
	thisForm.startdate.value=thisForm.er_stdate.value;
	thisForm.enddate.value=thisForm.er_enddate.value;
	thisForm.starthr.value=thisForm.er_sthr.options[thisForm.er_sthr.selectedIndex].value;
	thisForm.endhr.value=thisForm.er_endhr.options[thisForm.er_endhr.selectedIndex].value;
	if(thisForm.er_startmin!=null && thisForm.er_endmin!=null)
	{
		thisForm.startmin.value=thisForm.er_startmin.options[thisForm.er_startmin.selectedIndex].value;
		thisForm.endmin.value=thisForm.er_endmin.options[thisForm.er_endmin.selectedIndex].value;
		startMin=thisForm.startmin;
		endMin=thisForm.endmin;
	}
	else if ("Trend"=="<%=request.getParameter("er_gtype")%>")
	{
		thisForm.startmin.value=0;
		thisForm.endmin.value=0;
	}

	var time =thisForm.er_timeline.options[thisForm.er_timeline.selectedIndex].value;
	var starttime = formatDate(new Date(getDateFromFormat(thisForm.er_stdate.value,'<%=currentDateFormat%>')),"MM/dd/yyyy");
	var  endtime = formatDate(new Date(getDateFromFormat(thisForm.er_enddate.value,'<%=currentDateFormat%>')),"MM/dd/yyyy");
	var startHr =thisForm.starthr;
	var endHr =thisForm.endhr;



	if(op=='jsp')
	{
		thisForm.er_timeline_change.value		="yes";
	}

	if("SnapShot"=="<%=request.getParameter("er_rtype")%>")
	{
		thisForm.er_gtype.value  = "intrasnap";
		thisForm.er_rtype.value  = "<%=request.getParameter("er_rtype")%>";
		thisForm.option.value    = "<%=request.getParameter("option")%>";
		//thisForm.er_info_list.value="<%=request.getParameter("er_info_list")%>";
	}
	else if("server"=="<%=request.getParameter("er_rtype")%>")
	{
		thisForm.er_gtype.value     = "intrasnap";
		thisForm.er_rtype.value     = "<%=request.getParameter("er_rtype")%>";
		thisForm.option.value       = "<%=request.getParameter("option")%>";
		thisForm.er_info_list.value = "<%=request.getParameter("er_info_list")%>";
	}
	else if("Comparison"=="<%=request.getParameter("er_gtype")%>")
	{
		thisForm.er_gtype.value      = "<%=request.getParameter("er_gtype")%>";
		thisForm.er_nick.value       = "<%=request.getParameter("er_nick")%>";
		thisForm.er_graphtype.value  = "<%=request.getParameter("er_graphtype")%>";
		thisForm.er_chartcolor.value = "<%=request.getParameter("er_chartcolor")%>";
		thisForm.option.value        = "<%=request.getParameter("option")%>";
		//thisForm.er_info_list.value= "<%=request.getParameter("er_info_list")%>";
		thisForm.er_trenddata.value  = "<%=request.getParameter("er_trenddata")%>";
	}
	else if("Measure"=="<%=request.getParameter("er_gtype")%>" && "CitrixUser" == "<%=request.getParameter("er_trgttype")%>")
	{
		thisForm.select_farm.value = "<%=request.getParameter("select_farm")%>";
		thisForm.er_user.value     = "<%=request.getParameter("er_user")%>";
		thisForm.option.value      = "graph";
		thisForm.er_excwe.value    = "<%=request.getParameter("er_excwe")%>";
		thisForm.er_rtype.value    = "<%=request.getParameter("er_rtype")%>";
		thisForm.er_gtype.value    = "<%=request.getParameter("er_gtype")%>";
		thisForm.timefrom.value    = "<%=request.getParameter("timefrom")%>";
		thisForm.timeto.value      = "<%=request.getParameter("timeto")%>";
		thisForm.minfrom.value     = "<%=request.getParameter("minfrom")%>";
		thisForm.minto.value       = "<%=request.getParameter("minto")%>";
		thisForm.er_trgttype.value = "<%=request.getParameter("er_trgttype")%>";
		thisForm.er_compType.value = "<%=request.getParameter("er_compType")%>";
		thisForm.er_muser.value    = "<%=request.getParameter("er_tuser")%>";
	}
	else
	{
		thisForm.er_gtype.value = "<%=request.getParameter("er_gtype")%>";
		thisForm.er_rtype.value = "<%=request.getParameter("er_rtype")%>";
		if("Summary"=="<%=request.getParameter("er_gtype")%>")
		{
			thisForm.option.value ="graph";
		}
		else
		{
			thisForm.option.value      = "<%=request.getParameter("option")%>";
			thisForm.er_trenddata.value= "<%=request.getParameter("er_trenddata")%>";
		}
	}
	if(thisForm.info_list!=undefined)
	{
	var tmp =thisForm.info_list.options[thisForm.info_list.selectedIndex].value;
	thisForm.er_info_list.value = tmp;
	}
	thisForm.er_period.value    = "<%=request.getParameter("er_period")%>";
	thisForm.enlarged.value     = "<%=request.getParameter("enlarged")%>";
	thisForm.currTime.value     = "<%=request.getParameter("currTime")%>";
	thisForm.er_test.value      = "<%=request.getParameter("er_test")%>";
	thisForm.er_disp_meas.value = "<%=request.getParameter("er_disp_meas")%>";
	thisForm.er_measure.value   = "<%=request.getParameter("er_measure")%>";
	thisForm.er_component.value = "<%=request.getParameter("er_component")%>";
	thisForm.er_site.value      = "<%=request.getParameter("er_site")%>";
	var msmthost='<%=request.getParameter("er_msmthost")%>';
	if(msmthost !="null")
	{
		thisForm.er_msmthost.value  = "<%=request.getParameter("er_msmthost")%>";
	}
	else
	{
		thisForm.er_msmthost.value  = "";
	}
	if(time.indexOf("min")>-1 || thisForm.er_gtype.value == 'intersnap' || thisForm.er_gtype.value =='intrasnap' ){
		bool=validateDate(starttime,endtime,startHr,endHr,startMin,endMin);
	}else{
		bool=checktime(starttime,endtime,startHr,endHr);
	}
	if(bool)
	{
		var timeVal = true;
		timeVal = getTimeForuser(thisForm);
		if(timeVal)
		{
			document.forms[0].submit();
		}
		else
		{
			return;
		}
		thisForm.action =action;
		thisForm.submit();
		thisForm.sub.value='<egui:intnl text="reporter.common.Loading"/>'+"...";
		thisForm.sub.disabled=true;
	}
	else
	{
		alert('<egui:intnl text="reporter.common.From date should not be greater than To date"/>');
	}
}

function go2()
{
	var flag=true;
	with(document.forms[0])
	{
		//if('<%=s_filter%>'=='RANGE')
		if(document.forms[0].er_filter!=null)
		{
			if(er_filter[1].checked )
			{
				if(!checkblank(er_range_min)) er_range_min.value = <%=d_min%>
				if(!checkblank(er_range_max)) er_range_max.value = <%=d_max%>

				if(!checknumber("",er_range_min) || !checknumber("",er_range_max))
				{
					alert('<egui:intnl text="reporter.common.Minimum & Maximum Range should have numeric values"/>');
					return;
				}
				var min = parseFloat(er_range_min.value);
				var max = parseFloat(er_range_max.value);
				if(min > max)
				{
					alert('<egui:intnl text="reporter.common.Maximum range should be greater than minimum range"/>');
					return;
				}
				else if((min < <%=d_min%> && max < <%=d_min%>) || (min > <%=d_max%> && max > <%=d_max%>))
				{
					alert('<egui:intnl text="reporter.common.Your selection is out of range"/>');
					return;
				}
			}
		}

		var thisForm=document.forms[0];
		/*var opt = thisForm.er_tbound[0].checked;
		/*if(flag==true && opt==false)
		{
			flag=datevalidate(thisForm);
			flag=datevalidate(thisForm, false);
		}*/
		thisForm.action="../reporter/ErMeasure.jsp?screenWidth="+old_width;

		if("SnapShot"=="<%=request.getParameter("er_rtype")%>")
		{
			thisForm.er_gtype.value     = "intrasnap";
			thisForm.er_rtype.value     = "<%=request.getParameter("er_rtype")%>";
			thisForm.option.value       = "<%=request.getParameter("option")%>";
			thisForm.er_info_list.value = "<%=request.getParameter("er_info_list")%>";
		}else if("server"=="<%=request.getParameter("er_rtype")%>")
		{
			thisForm.er_gtype.value     = "intrasnap";
			thisForm.er_rtype.value     = "<%=request.getParameter("er_rtype")%>";
			thisForm.option.value       = "<%=request.getParameter("option")%>";
			thisForm.er_info_list.value = "<%=request.getParameter("er_info_list")%>";
		}
		else if("Comparison"=="<%=request.getParameter("er_gtype")%>")
		{
			thisForm.er_gtype.value     = "<%=request.getParameter("er_gtype")%>";
			thisForm.er_nick.value      = "<%=request.getParameter("er_nick")%>";
			thisForm.er_graphtype.value = "<%=request.getParameter("er_graphtype")%>";
			thisForm.er_chartcolor.value= "<%=request.getParameter("er_chartcolor")%>";
			thisForm.option.value       = "<%=request.getParameter("option")%>";
			thisForm.er_trenddata.value = "<%=request.getParameter("er_trenddata")%>";
			//thisForm.er_info_list.value= "<%=request.getParameter("er_info_list")%>";
		}
		else
		{
			thisForm.er_gtype.value      = "<%=request.getParameter("er_gtype")%>";
			thisForm.er_rtype.value      = "<%=request.getParameter("er_rtype")%>";
			//thisForm.er_info_list.value= "<%=request.getParameter("er_info_list")%>";
			if("Summary"=="<%=request.getParameter("er_gtype")%>")
			{
				thisForm.option.value  ="graph";
			}
			else
			{
				thisForm.option.value       = "<%=request.getParameter("option")%>";
				thisForm.er_trenddata.value = "<%=request.getParameter("er_trenddata")%>";
			}
		}
		thisForm.er_period.value    = "<%=request.getParameter("er_period")%>";
		thisForm.enlarged.value     = "<%=request.getParameter("enlarged")%>";
		thisForm.currTime.value     =  "<%=request.getParameter("currTime")%>";
		thisForm.er_test.value      = "<%=request.getParameter("er_test")%>";
		thisForm.er_disp_meas.value = "<%=request.getParameter("er_disp_meas")%>";
		thisForm.er_measure.value   = "<%=request.getParameter("er_measure")%>";
		thisForm.er_component.value = "<%=request.getParameter("er_component")%>";
		thisForm.er_site.value      = "<%=request.getParameter("er_site")%>";
		thisForm.er_msmthost.value  = "<%=request.getParameter("er_msmthost")%>";
		thisForm.startdate.value=thisForm.er_stdate.value;
		thisForm.enddate.value=thisForm.er_enddate.value;
		thisForm.starthr.value      = thisForm.er_sthr.value;
		thisForm.endhr.value        = thisForm.er_endhr.value;
		if("Trend"=="<%=request.getParameter("er_gtype")%>")
		{
			thisForm.startmin.value     = 0;
			thisForm.endmin.value       = 0;
		}
		//thisForm.er_info_list.value="<%=request.getParameter("er_info_list")%>";

		if(flag)
		{
			thisForm.submit();
			thisForm.sub.value="Loading...";
			thisForm.sub.disabled=true;
		}
	}
}
<%=count%>
var remoteURL = "/final/servlet/com.eg.ErRemoteScriptingServlet";
function  timeSelect(comptype)
{
	var thisForm=document.ErMeasure;
	var time =thisForm.er_timeline.options[thisForm.er_timeline.selectedIndex].value;
	var starttime = thisForm.er_stdate.value;
	var starthr =thisForm.er_sthr.options[thisForm.er_sthr.selectedIndex].value;
	var endtime = thisForm.er_enddate.value;
	var endhr =thisForm.er_endhr.options[thisForm.er_endhr.selectedIndex].value;
	var period='<%=period%>';
	var er_time='<%=er_time%>';
	var format='<%=currentDateFormat%>';

	if(time=="Any")
	{
		thisForm.er_stdate.disabled=false;
		thisForm.er_enddate.disabled=false;
		thisForm.er_sthr.disabled=false;
		thisForm.er_endhr.disabled=false;


		if(thisForm.er_startmin!=null && thisForm.er_endmin!=null)
		{
			thisForm.er_endmin.disabled=false;
			thisForm.er_startmin.disabled=false;
			thisForm.startmin.value='00';
			thisForm.endmin.value='00';
		}
		else
		{
			thisForm.startmin.value='00';
			thisForm.endmin.value='00';
		}

		document.getElementById("disableFrom").style.visibility='visible';
		document.getElementById("disableTo").style.visibility='visible';
		document.getElementById("disableFrom").style.display='block';
		document.getElementById("disableTo").style.display='block';

		document.getElementById("enableFrom").style.visibility='hidden';
		document.getElementById("enableTo").style.visibility='hidden';
		document.getElementById("enableFrom").style.display='none';
		document.getElementById("enableTo").style.display='none';

	}
	else
	{
		if(period =="")
		{
			if("Summary"=='<%=gtype%>' || '<%=s_trenddata%>'=='Yes')
			{
				jsrsExecute(remoteURL,setTime,"getTrendTime",new Array(time,starttime,endtime,starthr,endhr,format));
			}
			else
			{
				jsrsExecute(remoteURL,setTime,"getTime",new Array(time,starttime,endtime,starthr,endhr,format));
			}
		}
		else
		{
			jsrsExecute(remoteURL,setTime,"getTimeForSummary",new Array(time,starttime,endtime,starthr,endhr,format,period,er_time));
		}
	}
}

function setTime(timeVal)
{
	var format='<%=currentDateFormatForJS%>';
	var thisForm=document.ErMeasure;
	var time =thisForm.er_timeline.options[thisForm.er_timeline.selectedIndex].value;
	var arrOptions = timeVal.split('\t');
	thisForm.er_stdate.value = formatDate(new Date(getDateFromFormat(arrOptions[0],"MM/dd/yyyy")),format);
	thisForm.er_enddate.value = formatDate(new Date(getDateFromFormat(arrOptions[1],"MM/dd/yyyy")),format);
	//thisForm.er_stdate.value=arrOptions[0];
	//thisForm.er_enddate.value=arrOptions[1];
	thisForm.er_sthr.value=arrOptions[2];
	thisForm.er_endhr.value=arrOptions[3];

	if(thisForm.er_startmin!=null && thisForm.er_endmin!=null)
	{
		thisForm.er_startmin.value=arrOptions[4];
		thisForm.er_endmin.value=arrOptions[5];
	}
	else
	{
		thisForm.startmin.value=0;
		thisForm.endmin.value=0;
	}
	thisForm.startdate.value=arrOptions[0];
	thisForm.enddate.value=arrOptions[1];
	thisForm.starthr.value=arrOptions[2];
	thisForm.endhr.value=arrOptions[3];
	thisForm.startmin.value=arrOptions[4];
	thisForm.endmin.value=arrOptions[5];


	document.getElementById("disableFrom").style.visibility='hidden';
	document.getElementById("disableTo").style.visibility='hidden';

	document.getElementById("disableFrom").style.display='none';
	document.getElementById("disableTo").style.display='none';
	document.getElementById("enableFrom").style.visibility='visible';
	document.getElementById("enableTo").style.visibility='visible';
	document.getElementById("enableFrom").style.display='block';
	document.getElementById("enableTo").style.display='block';

	thisForm.er_stdate.disabled=true;
	thisForm.er_enddate.disabled=true;
	thisForm.er_sthr.disabled=true;
	thisForm.er_endhr.disabled=true;
	if(thisForm.er_startmin!=null && thisForm.er_endmin!=null)
	{
		thisForm.er_endmin.disabled=true;
		thisForm.er_startmin.disabled=true;
	}
}

function call()
{
		var time='<%=er_timeline%>';
		if(time!=null &&  time!="Any")
		{
			document.getElementById("disableFrom").style.visibility='hidden';
			document.getElementById("disableTo").style.visibility='hidden';
			document.getElementById("enableFrom").style.visibility='visible';
			document.getElementById("enableTo").style.visibility='visible';
			document.getElementById("disableFrom").style.display='none';
			document.getElementById("disableTo").style.display='none';
			document.getElementById("enableFrom").style.display='block';
			document.getElementById("enableTo").style.display='block';
		}
		else
		{

			document.getElementById("disableFrom").style.visibility='visible';
			document.getElementById("disableTo").style.visibility='visible';
			document.getElementById("enableFrom").style.visibility='hidden';
			document.getElementById("enableTo").style.visibility='hidden';
			document.getElementById("disableFrom").style.display='block';
			document.getElementById("disableTo").style.display='block';
			document.getElementById("enableFrom").style.display='none';
			document.getElementById("enableTo").style.display='none';
		}
}

documentView ={
		getObject: function()
		{
			if(typeof( window.innerWidth) == 'number')
			{//Firefox
				this.height = window.innerHeight;
				this.width = window.innerWidth-10;
				this.fireFox = true;
			}
			else if( document.documentElement && ( document.documentElement.clientWidth
				|| document.documentElement.clientHeight ))
			{//IE 6 + in 'standards compliant mode'
				this.height = document.documentElement.clientHeight;
				this.width = document.documentElement.clientWidth;
				this.ie = true;
			}
			else if(document.body && document.body.clientHeight)
			{ //IE 4 compatible
				this.height = document.body.clientHeight;
				this.width = document.body.clientWidth;
				this.ie = true;
			}

			this.screenHeight=window.screen.availHeight;
			this.screenWidth=window.screen.availWidth;
			return this;
		},
		getScreenHeight: function()
		{
			return this.getObject().screenHeight;
		},
		getScreenWidth: function()
		{
			return this.getObject().screenWidth;
		},
		getHeight: function()
		{
			return this.getObject().height;
		},
		getWidth: function()
		{
			return this.getObject().width;
		},
		isIE: function()
		{
				return this.getObject().ie;
		},
		isFireFox: function()
		{
				return this.getObject().fireFox;
		}
	};

var old_width=0;


function bigScreenPage()
{
	if(old_width==0)
	{
		old_width=1000;
	}

	var selectWidth1Obj = document.getElementById('selectWidth1');
	if(selectWidth1Obj!=null && selectWidth1Obj!=undefined)
	{
		var selectWidth = selectWidth1Obj.style.width;
		
		if(selectWidth!=null && selectWidth!=undefined)
		{
		
			var newSelectWidth=parseInt((parseInt(selectWidth)/old_width) * documentView.getWidth());
			selectWidth1Obj.style.width=(newSelectWidth)+"px";
		}
	}
	old_width=documentView.getWidth();
}

	function check()
	{
		bigScreenPage();
		<%
			if(showFilter)
			{
		%>
				go2()
		<%
			}
			else
			{
		%>
				goTo('submit')
		<%
			}
		%>

	}
	window.onresize=check;

</script>
<script	language="javascript" src="../reporter/scripts/jsrsClient.js"></script>
</head>
<body marginwidth="20" marginheight="20" bgcolor="#FFFFFF" onUnLoad="closeWin()" <%=!"yes".equalsIgnoreCase(request.getParameter("print")) ? " onLoad = 'javascript:chooseFilter();bigScreenPage();' " : " onLoad = 'javascript:bigScreenPage();'"%>>
<%
	JSONArray hiddenArr = new JSONArray();

	JSONObject hiddenObj = new JSONObject();
	hiddenObj.put("er_timeline_change", "");
	hiddenArr.add( hiddenObj);

	hiddenObj = new JSONObject();
	hiddenObj.put("er_gtype", "");
	hiddenArr.add( hiddenObj);

	hiddenObj = new JSONObject();
	hiddenObj.put("er_rtype", "");
	hiddenArr.add( hiddenObj);

	hiddenObj = new JSONObject();
	hiddenObj.put("er_period", "");
	hiddenArr.add( hiddenObj);
if(isFromAlarmHistory!=null && (isFromAlarmHistory.equalsIgnoreCase("true") || isFromAlarmHistory.equalsIgnoreCase("Yes"))&& request.getParameter("info_list")!=null)
{
info=request.getParameter("info_list");
}
if(info != null)
{
	hiddenObj = new JSONObject();
	hiddenObj.put("er_info_list", info);
	hiddenArr.add( hiddenObj);
}
	hiddenObj = new JSONObject();
	hiddenObj.put("enlarged", "");
	hiddenArr.add( hiddenObj);

	hiddenObj = new JSONObject();
	hiddenObj.put("er_chartcolor", "");
	hiddenArr.add( hiddenObj);

	hiddenObj = new JSONObject();
	hiddenObj.put("er_graphtype", "");
	hiddenArr.add( hiddenObj);

	hiddenObj = new JSONObject();
	hiddenObj.put("er_test", "");
	hiddenArr.add( hiddenObj);

	hiddenObj = new JSONObject();
	hiddenObj.put("er_disp_meas", "");
	hiddenArr.add( hiddenObj);

	hiddenObj = new JSONObject();
	hiddenObj.put("er_measure", "");
	hiddenArr.add( hiddenObj);

	hiddenObj = new JSONObject();
	hiddenObj.put("er_component", "");
	hiddenArr.add( hiddenObj);

	hiddenObj = new JSONObject();
	hiddenObj.put("er_nick", "");
	hiddenArr.add( hiddenObj);

	hiddenObj = new JSONObject();
	hiddenObj.put("option", "");
	hiddenArr.add( hiddenObj);

	hiddenObj = new JSONObject();
	hiddenObj.put("er_site", "");
	hiddenArr.add( hiddenObj);

	hiddenObj = new JSONObject();
	hiddenObj.put("select_farm", "");
	hiddenArr.add( hiddenObj);

	hiddenObj = new JSONObject();
	hiddenObj.put("snaptime", request.getParameter("snaptime"));
	hiddenArr.add( hiddenObj);

	hiddenObj = new JSONObject();
	hiddenObj.put("er_graph", request.getParameter("er_graph"));
	hiddenArr.add( hiddenObj);

	hiddenObj = new JSONObject();
	hiddenObj.put("er_trenddata", "");
	hiddenArr.add( hiddenObj);

	hiddenObj = new JSONObject();
	hiddenObj.put("er_dataFrom", request.getParameter("er_dataFrom"));
	hiddenArr.add( hiddenObj);

	hiddenObj = new JSONObject();
	hiddenObj.put("er_service", request.getParameter("er_service"));
	hiddenArr.add( hiddenObj);

	hiddenObj = new JSONObject();
	hiddenObj.put("drilldownenabled", request.getParameter("drilldownenabled"));
	hiddenArr.add( hiddenObj);

	hiddenObj = new JSONObject();
	hiddenObj.put("er_user", "");
	hiddenArr.add( hiddenObj);

	hiddenObj = new JSONObject();
	hiddenObj.put("er_excwe", "");
	hiddenArr.add( hiddenObj);

	hiddenObj = new JSONObject();
	hiddenObj.put("timefrom", "");
	hiddenArr.add( hiddenObj);

	hiddenObj = new JSONObject();
	hiddenObj.put("timeto", "");
	hiddenArr.add( hiddenObj);

	hiddenObj = new JSONObject();
	hiddenObj.put("minfrom", "");
	hiddenArr.add( hiddenObj);

	hiddenObj = new JSONObject();
	hiddenObj.put("minto", "");
	hiddenArr.add( hiddenObj);

	hiddenObj = new JSONObject();
	hiddenObj.put("er_trgttype", "");
	hiddenArr.add( hiddenObj);

	hiddenObj = new JSONObject();
	hiddenObj.put("er_compType", "");
	hiddenArr.add( hiddenObj);

	hiddenObj = new JSONObject();
	hiddenObj.put("currTime", "");
	hiddenArr.add( hiddenObj);

	hiddenObj = new JSONObject();
	hiddenObj.put("er_muser", "");
	hiddenArr.add( hiddenObj);

	hiddenObj = new JSONObject();
	hiddenObj.put("inidate", currentDateFormat);
	hiddenArr.add( hiddenObj);

	hiddenObj = new JSONObject();
	hiddenObj.put("userID", request.getParameter("userID"));
	hiddenArr.add( hiddenObj);

	hiddenObj = new JSONObject();
	hiddenObj.put("er_commonMax", strCommonMax);
	hiddenArr.add( hiddenObj);

	hiddenObj = new JSONObject();
	hiddenObj.put("er_commonMaxRange", strCommonMaxRangeValue);
	hiddenArr.add( hiddenObj);

	hiddenObj = new JSONObject();
	hiddenObj.put("er_AutoCommonMax", strAutoCommonMax);
	hiddenArr.add( hiddenObj);

	hiddenObj = new JSONObject();
	hiddenObj.put("er_usertimeline", strUsrTimeline);
	hiddenArr.add( hiddenObj);

	hiddenObj = new JSONObject();
	hiddenObj.put("getMaxDaysInMonth", String.valueOf(ErUtils.getMaxDaysInMonth()));
	hiddenArr.add( hiddenObj);

	hiddenObj = new JSONObject();
	hiddenObj.put("er_msmthost", "");
	hiddenArr.add( hiddenObj);

	hiddenObj = new JSONObject();
	hiddenObj.put("reportName", "ErMeasure");
	hiddenArr.add( hiddenObj);

	hiddenObj = new JSONObject();
	hiddenObj.put("isOnlyVMAssigned", isOnlyVMAssigned);
	hiddenArr.add( hiddenObj);

	hiddenObj = new JSONObject();
	hiddenObj.put("select_vm", request.getParameter("select_vm"));
	hiddenArr.add( hiddenObj);

	hiddenObj = new JSONObject();
	hiddenObj.put("isFromAlarmHistory", isFromAlarmHistory);
	hiddenArr.add( hiddenObj);
%>
<%
	String strer_info= request.getParameter("er_infos");
if(strer_info != null)
	{
		hiddenObj = new JSONObject();
		hiddenObj.put("er_infos", strer_info);
		hiddenArr.add( hiddenObj);
	}
%>
<%	

	String strLogCls = "printHeaderBoxLogo";
	if(!(pdfPrint !=null && pdfPrint.equalsIgnoreCase("yes") || (sample != null && !sample.equalsIgnoreCase("yes") && drilldownenabled !=null && drilldownenabled.equalsIgnoreCase("yes"))))
	{
		strLogCls = "printPdfHeaderBoxLogo";
	}else
		strLogCls = "printHeaderBoxLogo";
	if(pdfPrint !=null && pdfPrint.equalsIgnoreCase("yes"))
	{
%>
		<div class="<%=strLogCls%>" style="padding:10px"><img src="<%=imageName%>" border="0" /></div>
<%
	}
	else
	{
%>
		<div class="<%=strLogCls%>"><img src="<%=imageName%>" border="0" /></div>
<%
	}
	String s_qryString = "";
	String Qstring="";
	for(int j=0;j < v_qry_string.size();j=j+2)
	{
		s_qryString = (String)v_qry_string.get(j+1);
		if(s_qryString!=null)
		{
			StringTokenizer strtok = new StringTokenizer(s_qryString,"&");
			while(strtok.hasMoreTokens())
			{
				String param = strtok.nextToken();
				//param=java.net.URLDecoder.decode(param);
				if(param.indexOf("=")>-1)
				{
					String reqparam =param.substring(0,param.indexOf("="));
					String value = param.substring(param.indexOf("=")+1,param.length());
					if(reqparam.equals("er_component"))
					{
						value=request.getParameter("er_component");
					}
					if(request.getParameter("er_graphtype") != null && request.getParameter("er_graphtype").equalsIgnoreCase("single"))
					{
						if(reqparam!=null && reqparam.equalsIgnoreCase("er_width"))
							value="450";
						if(reqparam!=null && reqparam.equalsIgnoreCase("er_height"))
							value="200";
					}
					if(request.getParameter("er_gtype") != null && (request.getParameter("er_gtype").equalsIgnoreCase("Summary") || request.getParameter("er_gtype").equalsIgnoreCase("Measure")))
					{
						if(reqparam!=null && reqparam.equalsIgnoreCase("er_width"))
//							value="450";
						continue;
						if(reqparam!=null && reqparam.equalsIgnoreCase("er_height"))
//							value="350";
						continue;
						
					}
					if(reqparam.equals("info_list"))
						continue;

					if(reqparam.equals("er_info_list") || reqparam.equals("select_vm") )
					{
						value=request.getParameter(reqparam);
						if( value != null)
						{
							try {
								if(value.indexOf("+")>-1){
								value=StringUtils.replace(value,"+","|plus|");
							} if (value.indexOf("&")>-1){
								value=StringUtils.replace(value,"&","|amp|");
							} if (value.indexOf("%")>-1){
								value=StringUtils.replace(value,"%","|pct|");
							} if (value.indexOf("#")>-1){
								value=StringUtils.replace(value,"#","|hash|");
							}
 								value = java.net.URLDecoder.decode(value);
							} catch (Exception e1) {e1.printStackTrace();}
						}
					}
						Qstring=Qstring+reqparam+"="+EgURLEncoder.encode(value,"UTF-8")+"&";
				}else
					Qstring=Qstring+param+"&";
			}
		}
		v_pdf_qry.add(s_serv_pdf+Qstring+"&option=graph&er_legendPosition=right");
%>

	<div class="printHeaderBox">
<%
		String isKpiHealthReport=request.getParameter("isKpiHealthReport");
		if(erd.s_gtype != null && erd.s_gtype.equalsIgnoreCase("Comparison"))
		{
			labelObj.put("reporter.common.reportfor" ,mappingInfo.getTextDescription("reporter.common.report for"));


%>
			<div class="printHeaderBoxTitle"><%=erd.s_gtype%>&nbsp;<egui:intnl text="reporter.common.report for"/>&nbsp;<%=st_component%></div>
<%
		}
		else if(erd.s_gtype != null && (erd.s_gtype.equalsIgnoreCase("interSnap")||erd.s_gtype.equalsIgnoreCase("intrasnap")))
		{

			String trgttype=request.getParameter("er_trgttype");
			if(isKpiHealthReport != null && isKpiHealthReport.equalsIgnoreCase("true")){
				String hasMultipleHosts=request.getParameter("hasMultipleHosts");
				String er_hostNames=request.getParameter("er_hostNames");
				if(hasMultipleHosts != null && hasMultipleHosts.equalsIgnoreCase("true") && er_hostNames != null && !er_hostNames.equalsIgnoreCase(""))
					er_hostNames=StringUtils.replace(er_hostNames,"|",", ");
				else
					er_hostNames=st_component;
				labelObj.put("reporter.common.KPI Health Report for" ,mappingInfo.getTextDescription("reporter.common.KPI Health Report for"));
%>
						<div class="printHeaderBoxTitle"><egui:intnl text="reporter.common.KPI Health Report for"/>&nbsp;<%=er_hostNames%></div>
<%
			}
			else if (trgttype==null)
			{
				labelObj.put("reporter.common.Snapshot Report for" ,mappingInfo.getTextDescription("reporter.common.Snapshot Report for"));

%>
						<div class="printHeaderBoxTitle"><egui:intnl text="reporter.common.Snapshot Report for"/>&nbsp;<%=st_component%></div>
<%
			}
			else
			{
				if(isOnlyVMAssigned!=null && isOnlyVMAssigned.equalsIgnoreCase("true"))
				{
					labelObj.put("reporter.common.Report for VM" ,mappingInfo.getTextDescription("reporter.common.Report for VM"));
%>
						<div class="printHeaderBoxTitle"><egui:intnl text="reporter.common.Report for VM:"/>&nbsp;<%=info%></div>
<%
				}
				else
				{
					labelObj.put("reporter.common.Server Report for" ,mappingInfo.getTextDescription("reporter.common.Server Report for"));
%>
						<div class="printHeaderBoxTitle"><egui:intnl text="reporter.common.Server Report for"/>&nbsp;<%=st_component%></div>
<%
				}
			}
		}//new code for snapshot
		else if ("Micro".equalsIgnoreCase(request.getParameter("er_rtype")) && "CitrixUser".equalsIgnoreCase(request.getParameter("er_trgttype")))
		{
			compType = request.getParameter("er_compType");
			er_info = request.getParameter("er_user");
			if(er_info == null)
			{
				er_info = request.getParameter("er_tuser");
			}
			labelObj.put("reporter.common.Citrix Farm User Report" ,mappingInfo.getTextDescription("reporter.common.Citrix Farm User Report"));
%>
						<div class="printHeaderBoxTitle"><egui:intnl text="reporter.common.Citrix Farm User Report - "/><%=request.getParameter("er_component")%></div>
<%
		}
		else if("User Report".equalsIgnoreCase(request.getParameter("er_trgttype")))
		{
			labelObj.put("reporter.common.CitrixUserReport" ,mappingInfo.getTextDescription("reporter.common.Citrix User Report - Farm -")+" "+request.getParameter("select_farm")+" "+mappingInfo.getTextDescription("reporter.measure.User")+" - "+request.getParameter("er_user"));
%>
						<div class="printHeaderBoxTitle"><egui:intnl text="reporter.common.Citrix User Report - Farm -"/> <%=request.getParameter("select_farm")%>&nbsp; <egui:intnl text="reporter.measure.User"/> - <%=request.getParameter("er_user")%></div>
<%
		}
		else
		{
					labelObj.put("reporter.common.Operation reports" ,mappingInfo.getTextDescription("reporter.common.Operation reports")+" "+mappingInfo.getTextDescription("reporter.common."+erd.s_rtype)+" "+request.getParameter("er_component"));
%>
						<div class="printHeaderBoxTitle"><egui:intnl text="reporter.common.Operation Reports"/>&nbsp;-&nbsp;<egui:intnl text='<%="reporter.common."+erd.s_rtype%>'/>&nbsp;-&nbsp;<%= request.getParameter("er_component")%></div>
<%
		}
		if(!"yes".equalsIgnoreCase(request.getParameter("print")))
		{
			if(!("yes".equalsIgnoreCase(request.getParameter("er_timeline_change"))))
			{
				rootJson.put("saveurl", Qstring+"&print=yes&is_pdf=yes");
%>
						<!-- SAVE button added after this-->
						<div class="printHeaderBoxPrintIcon" style="float:left"><img class="iconPrinter mouse" src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" border="0" alt='<egui:intnl text="reporter.common.SAVE"/>' title='<egui:intnl text="reporter.common.SAVE"/>' onClick="javascript:saveMe('<%=Qstring%>&print=yes&is_pdf=yes');"/></div>
<%
			}
			else
			{
%>
						<div class="printHeaderBoxPrintIcon" style="float:left">
							<table  border="0" cellspacing="0" cellpadding="0">
								<tr>
									<td>Need to Check<img ID="mouse_dis" src="../reporter/images/<%=reporter_Skin%>/disable-save.gif" border="0" ></img></td>
									<td>Need to Check<img ID="mouse_dis" src="../reporter/images/<%=reporter_Skin%>/disable-print.gif" border="0" ></img></td>
									<td>Need to Check<img id="mouse_dis" src="../reporter/images/<%=reporter_Skin%>/disable-mail.gif" border="0" ></img></td>
									<td>Need to Check<img ID="mouse_dis" src="../reporter/images/<%=reporter_Skin%>/disable-print.gif" border="0"></img></td>
									<td>Need to Check<img id="mouse_dis" src="../reporter/images/<%=reporter_Skin%>/disable-mail.gif"  border="0"></img></td>
								</tr>
							</table>
						</div>
<%
			}
		}
		if(erd.s_gtype !=null)
		{
			if("yes".equalsIgnoreCase(request.getParameter("print")))
			{
				//String pdfPrint = request.getParameter("pdfPrint");
				if(pdfPrint !=null && pdfPrint.equalsIgnoreCase("yes"))
				{
%>
						<div class="printHeaderBoxPrintIcon" style="float:left"><img class="iconPrinter mouse" src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" border="0"  onClick="javascript:print()" alt='<egui:intnl text="reporter.common.PRINT"/>' title='<egui:intnl text="reporter.common.PRINT"/>'/></div>
<%
					}
			}
			else
			{
				if(!("yes".equalsIgnoreCase(request.getParameter("er_timeline_change"))))
				{
					rootJson.put("printurl", Qstring+"&print=yes&is_pdf=yes");
					rootJson.put("mailurl", "../reporter/ErSendMail.jsp?keyPrefix=enlarged&DrillDown=yes");
					rootJson.put("dataurl", Qstring+"&option=data");
%>
						<div class="printHeaderBoxPrintIcon" style="float:left">
							<table  border="0" cellspacing="0" cellpadding="0">
								<tr>
									<td><img class="mouse" src="../reporter/images/<%=reporter_Skin%>/print.gif"  border="0"alt='<egui:intnl text="reporter.common.PRINT"/>' title='<egui:intnl text="reporter.common.PRINT"/>' onClick="javascript:printGraph('<%=Qstring%>print=yes');"></img></td>
									<td><img class="mouse" src="../reporter/images/<%=reporter_Skin%>/mail.gif"  border="0" alt='<egui:intnl text="reporter.common.MAIL"/>' title='<egui:intnl text="reporter.common.MAIL"/>' onClick="javascript:sendMail()"></img></td>
									<td><img class="mouse" src="../reporter/images/<%=reporter_Skin%>/data.gif" border="0" alt='<egui:intnl text="reporter.common.DATA"/>' title='<egui:intnl text="reporter.common.DATA"/>' onClick="javascript:showData('<%=Qstring%>&option=data');"></img></td>
								</tr>
							</table>
						</div>
<%

					String s_test=erd.s_test;
					String s_measure =erd.s_disp_meas;
					if(erd.s_dataFrom!=null && erd.s_dataFrom.equalsIgnoreCase("Service"))
					{
						//EgDbInfo dbInfo=new EgDbInfo("manager");
						s_measure=dbInfo.getMeasureForColumn(s_test,s_measure);
					}
					if(!("Summary".equalsIgnoreCase(erd.s_gtype)) && testBean.isDdEnabled(s_test,s_measure))
					{
						String s_site = erd.s_site;
						if (s_site ==null || s_site.length()==0 || s_site.equals("null") || s_site.equals("NONE") )
							s_site ="NULL";
						String s_component = erd.s_component;
						String s_info =request.getParameter("er_info_list");
						if(s_info!=null && !s_info.equals(""))
							s_info=EgURLEncoder.encode(s_info,"UTF-8");
						if (s_info==null || s_info.equals("")|| s_info.equals("null"))
						{
							Vector v_infos=erInfo.getInfosForTest(s_site,s_test,s_component,strStartTime,strEndTime,s_measure,"",s_trenddata,s_priority,maxInfo);
							if (v_infos!=null && v_infos.size()>0)
							{
								for (int m=0;m<v_infos.size();m++)
								{
									String s1=(String)v_infos.get(m);
									if (m==0)
									{
										s_info=s1.substring(s1.indexOf("+"));
									}else
									{
										s_info+="|"+s1.substring(s1.indexOf("+"));
								}
							}
						}
					}

					boolean isSnapshot =(erd.s_gtype !=null && (erd.s_gtype.equalsIgnoreCase("interSnap")||erd.s_gtype.equalsIgnoreCase("intrasnap")));

					if(isSnapshot && (s_info==null || s_info.length()==0))
						s_info = "|";

					if(s_info!=null && s_info.length()>0 && !s_info.equals("null"))
					{
						if(s_info.indexOf("|")>-1)
						{
							s_info=s_info.substring(0,s_info.indexOf("|"));
						}
						if(s_info.length()>0 && s_info.charAt(0)=='+')
							if(s_info.length() > 1 )
							{
								s_info = s_info.substring(1);
							}
							else
							{
								s_info="";
							}
							s_info = (erd.s_info==null?"":erd.s_info) + "*" +s_info;
						}else
						{
							StringTokenizer st=new StringTokenizer(s_component,":");
							if (st.countTokens()>3)
							{
								st.nextToken();
								st.nextToken();
								s_info=st.nextToken()+"*";
							}else
								s_info="*";
						}

						String s_sdate=erd.s_stdate;
						String s_shr=erd.s_sthr;
						String s_edate=erd.s_enddate;
						String s_ehr=erd.s_endhr;
						String  tmpComp=s_component;
						String strTempCompType = "";
						if (tmpComp!=null && tmpComp.indexOf(":")>-1)
							tmpComp = s_component.substring(0,s_component.indexOf(":"));
						//modified on 16/11/07 stalin to display DD page
						if (s_component!=null && s_component.lastIndexOf(":")>-1)
							strTempCompType = s_component.substring(s_component.lastIndexOf(":")+1);

						if(s_component.indexOf(":") > 0 && s_component.lastIndexOf(":") > 0)
						{
							int firstIndex = s_component.indexOf(":");
							port = s_component.substring(firstIndex+1, s_component.indexOf(":",firstIndex+1));
						}
						if(s_component.indexOf(":") > 0)
						{
							s_component = s_component.substring(0,s_component.indexOf(":"));
						}
						if(port == null || port.equals(""))
						{
							port = "NULL";
						}
						String s_infovalue="";
						String servertype=request.getParameter("er_trgttype");
						if(servertype!=null && servertype.trim().equalsIgnoreCase("Server Report"))
							s_infovalue=s_info;
						else
							s_infovalue=EgURLDecoder.decode(s_info,"UTF-8");
						String mhost="";
						if(eSpec.isExternalTest(s_test,strTempCompType))//to ensure whether mgmt_host coming with info or not
						{
							if (s_infovalue!=null && s_infovalue.lastIndexOf("(") >-1 && s_infovalue.lastIndexOf(")") >-1 )
							{
								mhost=s_infovalue.substring(s_infovalue.lastIndexOf("(")+1,s_infovalue.lastIndexOf(")"));
								s_infovalue=s_infovalue.substring(0,s_infovalue.lastIndexOf("("));
							} 
						}
						if(request.getParameter("er_option")!=null)
						{
							String er_opt=request.getParameter("er_option");
							if(er_opt.equalsIgnoreCase("Segment") || er_opt.equalsIgnoreCase("Zone") )
								s_site="";
						}
						if(s_test.equalsIgnoreCase("JvmThreadTest"))
						{
							String strComponent = erd.s_component;
							Vector v_infos = erInfo.getMsmtHostForGraph(s_site,s_test,strComponent);
							if(v_infos!=null && v_infos.size() >0 )
								mhost = (String)v_infos.get(0);
						}
 						if(s_infovalue.indexOf("\\")>-1)
						{
							s_infovalue = StringUtils.replace(s_infovalue,"\\","\\\\");
						}	
						String tempTimeline = "Any";
						String dd_url = "/final/monitor/EventsGraph.jsp?pageToShow=diagnosis&url=EgDiagnosis.jsp?site="+s_site+"&host="+EgURLEncoder.encode(s_component,"UTF-8")+"&port="+port+"&test="+s_test+"&info="+s_infovalue+"&msmt_host="+mhost+"&from=0&measure="+s_measure+"&firsttime=true&flag=0 &starttime="+request.getParameter("startdate")+"&endtime="+request.getParameter("enddate")+"&starthr="+s_shr+"&endhr="+ s_ehr+"&startmin="+request.getParameter("startmin")+"&endmin="+request.getParameter("endmin")+"&fromPage=alarm&comeFrom=Reporter&newWindow=true&timeline="+tempTimeline+"&inidate="+request.getParameter("inidate")+"&comptype="+strTempCompType+"&isVM="+isOnlyVMAssigned;
						rootJson.put("dd_url", dd_url);

						StringBuffer key = new StringBuffer(32);
						key.append(s_test);
						key.append(":");
						key.append(s_measure);
						String tm = key.toString();
						String disInfo = egFormat.getValue("Tests_For_DDWithoutInfos",tm);
						if(disInfo!=null && disInfo.equalsIgnoreCase("Yes"))
						{
							s_infovalue = "+";
						}
						else
						{
							if(s_infovalue!=null)
							{
								if(s_infovalue.indexOf("+")>-1)
								{
									s_infovalue=com.egurkha.util.StringUtils.replace(s_infovalue,"+","|plus|");
								}
								if(s_infovalue.indexOf("&")>-1)
								{
									s_infovalue=com.egurkha.util.StringUtils.replace(s_infovalue,"&","|amp|");
								}
								if(s_infovalue.indexOf("%")>-1)
								{
									s_infovalue=com.egurkha.util.StringUtils.replace(s_infovalue,"%","|pct|");
								}
								if(s_infovalue.indexOf("#")>-1)
								{
									s_infovalue=com.egurkha.util.StringUtils.replace(s_infovalue,"#","|hash|");
								}
								if(s_infovalue.indexOf("*")>-1)
								{
									int numChar=s_infovalue.length();
									char[] charArray=new char[numChar];
									s_infovalue.getChars(0, numChar, charArray,0);
									for(int i=0;i<charArray.length;i++)
									{
										if(charArray[i]=='*')
										{
											charArray[i]='+';
											break;
										}
									}
									s_infovalue = new String(charArray);
								}
							}
						}
						if(dd.ShowDDData(s_site,s_component,s_test,s_measure,s_infovalue,mhost))
						{
%>
						<div class="printHeaderBoxPrintIcon" style="float:left"><img class="mouse"  src="../reporter/images/<%=reporter_Skin%>/diagnosis.gif"  border="0" alt='<egui:intnl text="reporter.common.Detailed Diagnosis"/>' title='<egui:intnl text="reporter.common.Detailed Diagnosis"/>' onClick="javascript:openDDWin('<%=dd_url%>');"/></div>
<%
						}
						else
						{
%>
											&nbsp;
<%
						}
					}
				}
				else
				{
%>
						<div class="printHeaderBoxPrintIcon" style="float:left"><img ID="mouse_dis" src="../reporter/images/<%=reporter_Skin%>/disable-data.gif" border="0"></img></div>
<%
				}
			}
		}
%>
</div>
<div class="printOuterBoxNoBorder"> 
<%
		String tgttype=request.getParameter("er_trgttype");
		if(erd.s_rtype!=null && erd.s_rtype.equalsIgnoreCase("Micro") && tgttype!=null && tgttype.equalsIgnoreCase("CitrixUser"))
		{
%>
		<div class="printSelectionFields">Farm&nbsp-&nbsp; <%=request.getParameter("select_farm")%>&nbsp;User - 
<%
			String temp_user = request.getParameter("er_user");
			if(temp_user == null)
			{
				temp_user = request.getParameter("er_tuser");
			}
%>
			<span class="bold"><%=temp_user%></span></div>
<%
		}
		else if(!(erd.s_gtype!=null && erd.s_gtype.equalsIgnoreCase("comparison")) )
		{
			String trgttyppe=request.getParameter("er_trgttype");
			labelObj.put("reporter.common.Report Type", mappingInfo.getTextDescription("reporter.common.Report Type"));
			String strReportType = erd.s_gtype;
			if(isKpiHealthReport != null && isKpiHealthReport.equalsIgnoreCase("true"))
				strReportType = "Kpi Health Component";
			else if(strReportType!=null && strReportType.equalsIgnoreCase("intrasnap"))
					strReportType = "Snapshot Component";
			if(trgttyppe==null || trgttyppe.equals(""))
			{
				if("yes".equalsIgnoreCase(request.getParameter("print")))
				{
%>
			<div class="printSelectionFields"><egui:intnl text="reporter.common.Report Type"/> : 
				<span class="bold"><egui:intnl text='<%="reporter.common."+strReportType%>'/></span>
			</div>
<%
				}
			}
			else
			{
				if("yes".equalsIgnoreCase(request.getParameter("print")))
				{
					String reporttype="";
					String servertype=request.getParameter("er_trgttype");
					if(servertype!=null &&   servertype.trim().equalsIgnoreCase("Server Report"))
						reporttype="Consolidated";
					else if(gtype.equalsIgnoreCase("Measure")|| gtype.equalsIgnoreCase("Trend"))
						reporttype="Operation Measure";
					else if(gtype.equalsIgnoreCase("Summary"))
						reporttype="Operation Summary";
					else
					reporttype="Citrix";
					if(isOnlyVMAssigned==null || isOnlyVMAssigned.equalsIgnoreCase("false"))
					{
						labelObj.put("reporter.common.Report Type", mappingInfo.getTextDescription("reporter.common.Report Type"));
%>
			<div class="printSelectionFields"><egui:intnl text="reporter.common.Report Type"/> : 
				<span class="bold"><%=reporttype%></span>
			</div>
<%
					}
				}
			}
		}
		if("yes".equalsIgnoreCase(request.getParameter("print")))
		{
			String d1="";
			String d2="";
			String startdate = request.getParameter("startdate");
			String enddate  = request.getParameter("enddate");
			String starthr  = request.getParameter("starthr");
			String endhr    = request.getParameter("endhr");
			String startmin = request.getParameter("startmin");
			String endmin   = request.getParameter("endmin");
			startdate = startdate==null ? "" : URLDecoder.decode(startdate);
			enddate = enddate==null ? " " : URLDecoder.decode(enddate);
			/*d1 = startdate + " " + starthr + ":" + startmin + " hrs";
			d2 = enddate + " " + endhr + ":" + endmin + " hrs";*/


			// by karthikeyan
		
	String strStartTimee = startdate+" "+starthr+":"+startmin+":00";
	String strEndTimee = enddate+" "+endhr+":"+endmin+":00";
	ErUserData userData = new ErUserData(erd.userId,false);
	com.egurkha.User usr = userData.usr;
	String dateToConvertStart = DateUtil.changeDateFormat(strStartTimee,"MM/dd/yyyy HH:mm:ss",currentDateFormat+" HH:mm:ss");
	EgTimeZoneConverter timeZoneConverterStart = new EgTimeZoneConverter(dateToConvertStart,usr);

	String startDateForDisplay = (String) timeZoneConverterStart.getDate(false);
	String startHourForDisplay = timeZoneConverterStart.getHour();
	String startMinForDisplay = timeZoneConverterStart.getMinute();
	String dateToConvertEnd = DateUtil.changeDateFormat(strEndTimee,"MM/dd/yyyy HH:mm:ss",currentDateFormat+" HH:mm:ss");
	EgTimeZoneConverter timeZoneConverterEnd = new EgTimeZoneConverter(dateToConvertEnd,usr);
	String endDateForDisplay = (String) timeZoneConverterEnd.getDate(false);
	String endHourForDisplay = timeZoneConverterEnd.getHour();
	String endMinForDisplay = timeZoneConverterEnd.getMinute();

	d1 = startDateForDisplay + " " + startHourForDisplay + ":" + startMinForDisplay + " hrs";
	d2 = endDateForDisplay + " " + endHourForDisplay + ":" + endMinForDisplay + " hrs";
			//

			labelObj.put("reporter.common.Start Date", mappingInfo.getTextDescription("reporter.common.Start Date"));
			labelObj.put("reporter.common.End Date", mappingInfo.getTextDescription("reporter.common.End Date"));
%>
			<div class="printSelectionFields">Timeline - <span class="bold"><%=d1%> to <%=d2%></span></div>
<%
		}
%>
</div>
<%
		String trgttype = request.getParameter("er_trgttype");
		if (trgttype == null)
		{
			String pdfThresh="margin-top:2px;";
			if(pdfPrint != null && pdfPrint.equalsIgnoreCase("yes"))
				pdfThresh="";
%>
<table cellspacing="0" cellpadding="0" width="100%" border="0" valign="top">
		<tr>
			<td align="right" style="padding: 0px 0px 5px 0px;">
				<div style="display:flex;float:right;">
					<div style="float:left;<%=pdfThresh%>"><svg height="10" width="10"><circle cx="4" cy="6" r="4" fill="#7c7e1d" stoke-width="0" /></svg></div>
					<div style="float:left;margin-right:10px;margin-left:3px;">Max Critical</div>
					<div style="float:left;<%=pdfThresh%>"><svg height="10" width="10"><circle cx="4" cy="6" r="4" fill="#a2a51f" stoke-width="0" /></svg></div>
					<div style="float:left;margin-right:10px;margin-left:3px;">Max Major</div>
					<div style="float:left;<%=pdfThresh%>"><svg height="10" width="10"><circle cx="4" cy="6" r="4" fill="#ced059" stoke-width="0" /></svg></div>
					<div style="float:left;margin-right:10px;margin-left:3px;">Max Minor</div>
					<div style="float:left;<%=pdfThresh%>"><svg height="10" width="10"><circle cx="4" cy="6" r="4" fill="#f28a16" stoke-width="0" /></svg></div>
					<div style="float:left;margin-right:10px;margin-left:3px;">Min Critical</div>
					<div style="float:left;<%=pdfThresh%>"><svg height="10" width="10"><circle cx="4" cy="6" r="4" fill="#f5ba79" stoke-width="0" /></svg></div>
					<div style="float:left;margin-right:10px;margin-left:3px;">Min Major</div>
					<div style="float:left;<%=pdfThresh%>"><svg height="10" width="10"><circle cx="4" cy="6" r="4" fill="#f8d3bb" stoke-width="0" /></svg></div>
					<div style="float:left;margin-right:10px;margin-left:3px;">Min Minor</div>
				</div>
			</td>
		</tr>
	</table>
<%
		}
%>
<div class="printOuterBox">					
<%
		if( showFilter && !"yes".equalsIgnoreCase(request.getParameter("print")))
		{
			labelObj.put("reporter.common.Descriptor", mappingInfo.getTextDescription("reporter.common.Descriptor"));
%>
			<table align="center"  cellspacing="0" cellpadding="0" width="100%" border="0" >
				<tr>
					<td id="tablebg2" width="100%" align="center" >
						<div style="border:0px solid red;margin:auto;display:inline-block">
							<div style="float:left;padding:4px">
								<input type="radio" name="er_filter" value = "INFO" <%=!s_filter.equalsIgnoreCase("RANGE")?" CHECKED ":""%> onClick="javascript:chooseFilter()">
							</div>
							<div style="float:left;padding:4px">
								<span class="<%=fontStyleDblSingl%>"><b><egui:intnl text="reporter.common.Descriptor"/> : </b></span>
							</div>
							<div style="float:left;padding:4px">
								<select style="width: 100px;" name="er_priority">
<%
			JSONArray topArr = new JSONArray();
			int k = 1;
			for(;k<=10; k++)
			{
				JSONObject topObj = new JSONObject();
				topObj.put("displayField", mappingInfo.getTextDescription("reporter.common.TOP")+" - "+k);
				topObj.put("valueField", "TOP-"+k);
				topArr.add(topObj);
				if(count-1<k)break;
%>
									<option value="TOP-<%=k%>" <%=(s_priority.equalsIgnoreCase("TOP-"+k)?" SELECTED ": "") %>> <egui:intnl text="reporter.common.TOP"/> - <%=k%>
<%
			}
			if(maxInfo >10 && maxInfo < count && s_priority.startsWith("TOP"))
			{
				JSONObject topnObj = new JSONObject();
				topnObj.put("displayField", mappingInfo.getTextDescription("reporter.common.TOP")+" - "+maxInfo);
				topnObj.put("valueField", s_priority);
				topArr.add(topnObj);
				rootJson.put("topcomboselected", s_priority);

%>
									<option value="<%=s_priority%>" <%=(s_priority.equalsIgnoreCase("TOP-" + maxInfo)?" SELECTED ": "") %>><egui:intnl text="reporter.common.TOP"/> - <%=maxInfo%>
<%
			}
			JSONObject allObj = new JSONObject();
			allObj.put("displayField", mappingInfo.getTextDescription("reporter.common.ALL"));
			allObj.put("valueField", "ALL");
			topArr.add(allObj);
			if ( s_priority.equalsIgnoreCase("ALL") )
			{
				rootJson.put("topcomboselected", "ALL");
			}
%>
									<option value="ALL" <%=(s_priority.equalsIgnoreCase("ALL")?" SELECTED ": "") %>> <egui:intnl text="reporter.common.ALL"/>
<%
			if(maxInfo >10 && maxInfo < count && s_priority.startsWith("LAST"))
			{
				rootJson.put("topcomboselected", s_priority);
				JSONObject lastObj = new JSONObject();
				lastObj.put("displayField", mappingInfo.getTextDescription("reporter.common.LAST")+" - "+maxInfo);
				lastObj.put("valueField", s_priority);
				topArr.add(lastObj);

				if ( s_priority.equalsIgnoreCase("LAST-" + maxInfo) )
				{
					rootJson.put("topcomboselected", s_priority);
				}
				
%>
									<option value="<%=s_priority%>" <%=(s_priority.equalsIgnoreCase("LAST-" + maxInfo)?" SELECTED ": "") %>> <egui:intnl text="reporter.common.LAST"/> - <%=maxInfo%>
<%
			}
			for(k--;k>0; k--)
			{
				JSONObject lastObj = new JSONObject();
				lastObj.put("displayField", mappingInfo.getTextDescription("reporter.common.LAST")+" - "+k);
				lastObj.put("valueField", "LAST-"+k);
				topArr.add(lastObj);

				if ( s_priority.equalsIgnoreCase("LAST-"+k) )
				{
					rootJson.put("topcomboselected", "LAST-"+k);
				}
%>
									<option value="LAST-<%=k%>" <%=(s_priority.equalsIgnoreCase("LAST-"+k)?" SELECTED ": "") %>> <egui:intnl text="reporter.common.LAST"/> - <%=k%>
<%
			}
			rootJson.put("topcombo", topArr);
			labelObj.put("reporter.common.Range", mappingInfo.getTextDescription("reporter.common.Range"));
			if ( s_filter.equalsIgnoreCase("RANGE") )
			{
				rootJson.put("er_filter_radio_checked","checked");
			}
			else
			{
				rootJson.put("er_filter_radio_checked","");
			}

%>
								</select>
							</div>
							<div style="float:left;padding:4px;width:20px">&nbsp;</div>
							<div style="float:left;padding:4px">
									<input type="radio" name="er_filter" value = "RANGE" <%=s_filter.equalsIgnoreCase("RANGE")?" CHECKED ":""%> onClick="javascript:chooseFilter()">
							</div>

							<div style="float:left;padding:4px"><b><egui:intnl text="reporter.common.Range"/> :</b>
							</div>
<%
			rootJson.put("er_range_min", s_min);
%>
							<div style="float:left;padding:4px">
								<input type="textbox" style="width:80" name="er_range_min" value="<%=s_min%>">
							</div>

							<div style="float:left;padding:4px;width:20px">&nbsp;</div>
<%
			labelObj.put("reporter.common.To", mappingInfo.getTextDescription("reporter.common.To"));
			rootJson.put("er_range_max", s_max);
%>
							<div style="float:left;padding:4px;"><b>&nbsp;<egui:intnl text="reporter.common.To"/> </b></div>
							<div style="float:left;padding:4px">
									<input type="textbox" style="width:80" name="er_range_max" value="<%=s_max%>">
							</div>
							<div style="float:left;padding:4px;width:20px">&nbsp;</div>
						</div>
					</td>
				</tr>
			</table>
<%
		}
		if(!"yes".equalsIgnoreCase(request.getParameter("print")))
		{
%>
<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0"><br>
	<tr>
		<td id="tablebg2" class="cellbgapplet" nowrap align="left" width="100%">
<%
			if(erd.s_gtype !=null && (erd.s_gtype.equalsIgnoreCase("interSnap")||erd.s_gtype.equalsIgnoreCase("intrasnap")||erd.s_gtype.equalsIgnoreCase("Citrix")))
			{
				if (erd.s_startmin!=null && !erd.s_startmin.equals("") && Integer.parseInt(erd.s_startmin)<10 && erd.s_startmin.length()==2)
					erd.s_startmin=erd.s_startmin.substring(1);
				if (erd.s_endmin!=null && !erd.s_endmin.equals("") && Integer.parseInt(erd.s_endmin)<10 && erd.s_endmin.length()==2)
					erd.s_endmin=erd.s_endmin.substring(1);
				Vector vec_infos=erInfo.getInfosForTest(erd.s_site,erd.s_test,erd.s_component);
%>
			<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0">
<%
																		if(isFromAlarmHistory!=null && (isFromAlarmHistory.equalsIgnoreCase("true") || isFromAlarmHistory.equalsIgnoreCase("Yes")) && vec_infos!=null && vec_infos.size()>0)
																		{
				labelObj.put("reporter.common.Descriptor", mappingInfo.getTextDescription("reporter.common.Descriptor"));
%>
				<tr>
					<td id="tablebg2" class="blackcontent" height="24"  nowrap  width="110px" align="right"><span class="<%=fontStyleDblSingl%>"> <b><egui:intnl text="reporter.common.Descriptor"/></b> &nbsp;&nbsp;&nbsp;</span></td>
					<td id="tablebg2" width="10px"><b>:</b></td>
					<td class="tablebg2" style="padding:0px" height="26" >
					<select name="info_list" style="width:250px;">
<%
																				JSONArray descArr = new JSONArray();
																				for(int i=0;vec_infos.size()>i;i++)
																				{	
																					JSONObject descObj = new JSONObject();
																					String str_selected="";
																					String tmp_info=(String)vec_infos.get(i);
																					if(tmp_info.indexOf("+")>-1 && tmp_info.indexOf("+")==0)
																						tmp_info=tmp_info.substring(1);
																					if(tmp_info.equals(info))
																					{
																						str_selected="selected";
																						rootJson.put("descriptorcomboselected", tmp_info);
																					}
																					descObj.put("displayField", tmp_info);
																					descObj.put("valueField", tmp_info);
																					descArr.add(descObj);
%>
						<option value="<%=tmp_info%>" <%=str_selected%> ><%=tmp_info%></option>
<%
																				}
																				rootJson.put("descriptorcombo", descArr);
%>
					</select>
					</td>
				</tr>
<%
																		}
%>
				<tr>
					<td colspan="3" id="cellbglight" >&nbsp;</td>
				</tr>

				<tr>
					<td id="tablebg2" class="blackcontent"  nowrap align="center" width="100%" colspan="3">
						<div style="border:0px solid red;margin:auto;display:inline-block">
<%
				labelObj.put("reporter.common.Timeline", mappingInfo.getTextDescription("reporter.common.Timeline"));
%>
							<div style="float:left;padding:4px" class="<%=fontStyleDblSingl%>"><b> <egui:intnl text="reporter.common.Timeline"/>:</b></div>

							<div style="float:left;padding:4px">
								<select name="er_timeline"  size="1" style="width:90px;" onChange="javascript:timeSelect('-1')">
<%
				JSONArray timeArr = new JSONArray();
				for(int e_ctr=0; e_ctr < len;e_ctr++)
				{
					JSONObject timeObj = new JSONObject();
					timeObj.put("displayField", mappingInfo.getTextDescription("reporter.measure."+er_timeline));
					timeObj.put("valueField", er_timeline);
					timeArr.add(timeObj);

					if(er_timeline!=null&&er_timeline.equals((String)opt[e_ctr]))
					{
						rootJson.put("timelinecomboselected", er_timeline);
								out.println("<option value='" + er_timeline + "' selected>" +mappingInfo.getTextDescription("reporter.measure."+er_timeline)+ "</option>");
					}
					else
					{
								out.println("<option value='" + opt[e_ctr] + "'>" + mappingInfo.getTextDescription("reporter.measure."+opt[e_ctr])  + "</option>");
					}
				}
				rootJson.put("timelinecombo", timeArr);
%>
							</select>
						</div>
					<div style="float:left;width:20px">&nbsp;</div>

					<div style="float:left;border:0px solid blue">
						<div id="enableFrom" style="float:left;border:0px solid #000000;padding:4px" >
<%
				labelObj.put("reporter.common.From", mappingInfo.getTextDescription("reporter.common.From"));
%>
							<table border="0" cellpadding="0" cellspacing="0"><tr><td> <egui:intnl text="reporter.common.From"/></td><td><img src="/final/reporter/images/calendar.gif" border="0" align="center"></td></tr> </table>
						</div>

						<div id="disableFrom" style="float:left;visibility:hidden;border:0px solid #000000;padding:4px"><a id="mousehand" href="javascript:void(0)" onClick="checkwindow1(document.ErMeasure.er_stdate,event);" style="text-decoration:none" >
							<table border="0" cellpadding="0" cellspacing="0"><tr><td><egui:intnl text="reporter.common.From"/></td><td><img src="/final/reporter/images/calendar.gif" border="0" align="center"></td></tr> </table></a>
						</div>
<%
			if(er_timeline!=null&&!er_timeline.equals("Any"))
			{
				if(DateUtil.isDate(s_st_time,"MM/dd/yyyy"))
				{
					comFormat = "MM/dd/yyyy";
				}
				else
				{
					comFormat = currentDateFormat;
				}
				dispDate = DateUtil.changeDateFormat(s_st_time,comFormat,currentDateFormat);
			}
			else
			{
				dispDate = s_st_time;
			}
			rootJson.put("er_stdate", dispDate);
			labelObj.put("reporter.common.Hr", mappingInfo.getTextDescription("reporter.common.Hr"));
%>
						</div>
						<div style="float:left;padding:3px;border:0px solid yellow">
										<input type="text" name="er_stdate" onfocus="this.blur()" style="text-align: center;" maxlength="12" size="13" value="<%=dispDate%>" readonly <%=disable%>>
						</div>

						<div style="float:left;padding:5px 0px 5px 5px"> <egui:intnl text="reporter.common.Hr"/></div>

						<div style="float:left;padding:4px">
							<select name="er_sthr" <%=disable%>>
<%
				JSONArray stHrArr = new JSONArray();
				for(int s_ctr=0; s_ctr < 24 ;s_ctr++)
				{
					JSONObject stHrObj = new JSONObject();
					stHrObj.put("displayField", stHrObj);
					stHrObj.put("valueField", stHrObj);
					stHrArr.add(stHrObj);
					s_st_hr = s_st_hr.trim();

					if(s_st_hr!=null&&s_ctr == Integer.parseInt(s_st_hr))
					{
						rootJson.put("sthrcomboselected", s_st_hr);
								out.println("<option value='" + s_ctr + "' selected>" + s_ctr + "</option>");
					}else{
								out.println("<option value='" + s_ctr + "'>" + s_ctr + "</option>");
							}
				}
				rootJson.put("sthrcombo", stHrArr);
%>
							</select>
						</div>
						<div style="float:left;padding:4px">
							<select name="er_startmin" <%=disable%>>
<%
				JSONArray stMinArr = new JSONArray();
				for(int s_ctr=0; s_ctr < 60 ;s_ctr++)
				{
					JSONObject stMinObj = new JSONObject();
					startMin = startMin.trim();
					String stmin=s_ctr+"";
					if(s_trenddata!=null && !s_trenddata.equalsIgnoreCase("Yes"))
					{
						if (s_ctr<10)
							stmin="0"+s_ctr;
					}
					stMinObj.put("displayField", stmin);
					stMinObj.put("valueField", stmin);
					stMinArr.add(stMinObj);
					if(startMin!=null && s_ctr == Integer.parseInt(startMin))
					{
						rootJson.put("stmincomboselected", stmin);
								out.println("<option value='" + stmin + "' selected>" + stmin + "</option>");
					}else{

								out.println("<option value='" + stmin + "'>" + stmin + "</option>");
							}
				}
				rootJson.put("stmincombo", stMinArr);
%>
							</select>
						</div>
						<div style="float:left;padding:2px;width:20px">&nbsp; </div>

						<div style="float:left;border:0px solid blue">
							<div id="enableTo" style="float:left;border:0px solid #000000;padding:4px" >
								<table border="0" cellpadding="0" cellspacing="0"><tr><td><egui:intnl text="reporter.common.To"/></td><td ><img src="/final/reporter/images/calendar.gif" border="0" align="center"></td></tr> </table>
							</div>

							<div id="disableTo" style="float:left;visibility:hidden;display:none;padding:4px"><a  id="mousehand" href="javascript: void (0)" onClick="checkwindow1(document.ErMeasure.er_enddate,event);" style="text-decoration:none">
								<table border="0" cellpadding="0" cellspacing="0" ><tr><td ><egui:intnl text="reporter.common.To"/></td><td><img src="/final/reporter/images/calendar.gif" border="0" align="center"></td></tr> </table></a>
							</div>

<%
			if(er_timeline!=null&&!er_timeline.equals("Any"))
			{
				if(DateUtil.isDate(s_en_time,"MM/dd/yyyy"))
				{
					comFormat = "MM/dd/yyyy";
				}
				else
				{
					comFormat = currentDateFormat;
				}
				dispDate = DateUtil.changeDateFormat(s_en_time,comFormat,currentDateFormat);
			}
			else
			{
				dispDate = s_en_time;
			}
			rootJson.put("er_enddate",dispDate);
%>
						</div>


						<div style="float:left;padding:3px"><input type="text" name="er_enddate" onfocus="this.blur()" style="text-align: center;" maxlength="12" size="13" value="<%=dispDate%>" readonly <%=disable%>></div>

						<div style="float:left;padding:5px 0px 5px 5px"> <egui:intnl text="reporter.common.Hr"/></div>


						<div style="float:left;padding:4px"> 
							<select name="er_endhr" <%=disable%>>
<%
				JSONArray endArr = new JSONArray();
				for(int e_ctr=0; e_ctr < 24 ;e_ctr++)
				{
					JSONObject endObj = new JSONObject();
					endObj.put("displayField", String.valueOf(e_ctr));
					endObj.put("valueField", String.valueOf(e_ctr));
					s_en_hr=s_en_hr.trim();
					if(s_en_hr!=null&&e_ctr == Integer.parseInt(s_en_hr))
					{
						rootJson.put("er_endhr_selected", s_en_hr);
								out.println("<option value='" + e_ctr + "' selected>" + e_ctr + "</option>");
					}
					else
					{
								out.println("<option value='" + e_ctr + "'>" + e_ctr + "</option>");
					}
					endArr.add(endObj);
				}
				rootJson.put("er_endhr",endArr);
	%>
							</select>
						</div>

						<div style="float:left;padding:4px">
							<select name="er_endmin" <%=disable%>>
<%
				JSONArray endMinArr = new JSONArray();
				for(int s_ctr=0; s_ctr < 60 ;s_ctr++)
				{
					endMin = endMin.trim();
					String emin=s_ctr+"";
					if(s_trenddata!=null && !s_trenddata.equalsIgnoreCase("Yes"))
					{
						if (s_ctr<10)
							emin="0"+s_ctr;
					}
					JSONObject endMinObj = new JSONObject();
					endMinObj.put("displayField", emin);
					endMinObj.put("valueField", emin);
					if(endMin!=null&&s_ctr == Integer.parseInt(endMin))
					{
						rootJson.put("er_endmin_selected", endMin);
								out.println("<option value='" + emin + "' selected>" + emin + "</option>");
					}
					else
					{
								out.println("<option value='" + emin + "'>" + emin + "</option>");
					}
					endMinArr.add(endMinObj);
				}
				rootJson.put("er_endmin", endMinArr);
%>
							</select>
						</div>

						<div style="float:left;padding:2px;width:20px">&nbsp; </div>

						<div style="float:left;padding:4px"> <b><egui:intnl text="reporter.common.Graph"/>&nbsp;:</b></div>

						<div style="float:left;padding:4px"> 
							<select name="er_mode"  style="width: 50;"  class="list" onChange="javascript:go2();">
<%
				JSONArray modeArr = new JSONArray();
				JSONObject modeObj = new JSONObject();
				modeObj.put("displayField", mappingInfo.getTextDescription("reporter.common.2D"));
				modeObj.put("valueField", "2D");
				modeArr.add(modeObj);

				modeObj = new JSONObject();
				modeObj.put("displayField", mappingInfo.getTextDescription("reporter.common.3D"));
				modeObj.put("valueField", "3D");
				modeArr.add(modeObj);

				rootJson.put("mode", modeArr);
				String mode = request.getParameter("er_mode");
				boolean use3DGraphs = ui.use3DGraphs(IniUI.REPORTER);
				String select2d="";
				String select3d="";
				if(mode!=null&&!mode.equals(""))
				{
					if(mode.equals("2D"))
						select2d="selected";
					if(mode.equals("3D"))
						select3d="selected";
				}
				else
				{

					if(use3DGraphs)
						select3d="selected";
					else
						select2d="selected";
				}
				if ( select3d.equalsIgnoreCase("selected") )
				{
					rootJson.put("modeselected", "3D");
				}
				else if ( select2d.equalsIgnoreCase("selected") )
				{
					rootJson.put("modeselected", "2D");
				}
%>
								<option value="2D" <%=select2d%>><egui:intnl text="reporter.common.2D"/></option>
								<option value="3D" <%=select3d%>><egui:intnl text="reporter.common.3D"/></option>
							</select>
						</div>
					</td>
				</tr>
			</table>
<%
			}
			else
			{
%>
			<table align="center" cellspacing="0" cellpadding="2"   border="0" width="100%">
				<tr>
					<td id="tablebg2" class="blackcontent"  nowrap align="center" width="100%" colspan="3">
						<div style="border:0px solid red;margin:auto;display:inline-block">
						
							<div style="float:left;padding:4px"><b> <egui:intnl text="reporter.common.Timeline"/>: </b></div>

							<div style="float:left;padding:4px">
								<select name="er_timeline"  size="1" style="width:90px;" onChange="javascript:timeSelect('-1')">
<%
				JSONArray timeArr = new JSONArray();
				for(int e_ctr=0; e_ctr < len;e_ctr++)
				{
					JSONObject timeObj = new JSONObject();
					timeObj.put("displayField", mappingInfo.getTextDescription("reporter.measure."+er_timeline));
					timeObj.put("valueField", er_timeline);
					if(er_timeline!=null&&er_timeline.equals((String)opt[e_ctr]))
					{
						rootJson.put("timelinecomboselected", er_timeline);
									out.println("<option value='" + er_timeline + "' selected>" +mappingInfo.getTextDescription("reporter.measure."+er_timeline)+ "</option>");
					}else
					{
									out.println("<option value='" + opt[e_ctr] + "'>" + mappingInfo.getTextDescription("reporter.measure."+opt[e_ctr])  + "</option>");
					}
					timeArr.add(timeObj);
				}
				rootJson.put("timelinecombo", timeArr);
				labelObj.put("reporter.common.From", mappingInfo.getTextDescription("reporter.common.From"));
%>
								</select>
							</div>

							<div style="float:left;width:20px">&nbsp;</div>

							<div style="float:left;border:0px solid blue">
								<div id="enableFrom" style="float:left;border:0px solid #000000;padding:4px" >
									<table border="0" cellpadding="0" cellspacing="0"><tr><td> <egui:intnl text="reporter.common.From"/></td><td><img src="/final/reporter/images/calendar.gif" border="0" align="center"></td></tr> </table>
								</div>

								<div id="disableFrom" style="float:left;visibility:hidden;border:0px solid #000000;padding:4px"><a id="mousehand" href="javascript:void(0)" onClick="checkwindow1(document.ErMeasure.er_stdate,event);" style="text-decoration:none" >
									<table border="0" cellpadding="0" cellspacing="0"><tr><td><egui:intnl text="reporter.common.From"/></td><td><img src="/final/reporter/images/calendar.gif" border="0" align="center"></td></tr> </table></a>
								</div>
<%
			if(er_timeline!=null&&!er_timeline.equals("Any"))
			{
				if(DateUtil.isDate(s_st_time,"MM/dd/yyyy"))
				{
					comFormat = "MM/dd/yyyy";
				}
				else
				{
					comFormat = currentDateFormat;
				}
				dispDate = DateUtil.changeDateFormat(s_st_time,comFormat,currentDateFormat);
			}
			else
			{
				dispDate = s_st_time;
			}
			rootJson.put("er_stdate", dispDate);
			labelObj.put("reporter.common.Hr", mappingInfo.getTextDescription("reporter.common.Hr"));
%>
							</div>
							<div style="float:left;padding:3px;border:0px solid yellow">
								<input type="text" name="er_stdate" onfocus="this.blur()" style="text-align: center;" maxlength="12" size="14" value="<%=dispDate%>" readonly <%=disable%>>
							</div>

							<div style="float:left;padding:5px 0px 5px 5px"> <egui:intnl text="reporter.common.Hr"/></div>

							<div style="float:left;padding:4px">
								<select name="er_sthr" <%=disable%>>
<%
				JSONArray stHrArr = new JSONArray();
				for(int s_ctr=0; s_ctr < 24 ;s_ctr++)
				{
					s_st_hr = s_st_hr.trim();
					JSONObject stHrObj = new JSONObject();
					stHrObj.put("displayField", String.valueOf(s_ctr));
					stHrObj.put("valueField", String.valueOf(s_ctr));
					if(s_st_hr!=null&&s_ctr == Integer.parseInt(s_st_hr))
					{
						rootJson.put("sthrcomboselected", s_st_hr);
									out.println("<option value='" + s_ctr + "' selected>" + s_ctr + "</option>");
					}
					else
					{
									out.println("<option value='" + s_ctr + "'>" + s_ctr + "</option>");
					}
					stHrArr.add(stHrObj);
				}
				rootJson.put("sthrcombo", stHrArr);
				labelObj.put("reporter.common.To", mappingInfo.getTextDescription("reporter.common.To"));
%>
								</select>
							</div>
							<div style="float:left;padding:2px;width:20px">&nbsp; </div>

							<div style="float:left;border:0px solid blue">
								<div id="enableTo" style="float:left;border:0px solid #000000;padding:4px" >
									<table border="0" cellpadding="0" cellspacing="0"><tr><td><egui:intnl text="reporter.common.To"/></td><td ><img src="/final/reporter/images/calendar.gif" border="0" align="center"></td></tr> </table>
								</div>

								<div id="disableTo" style="float:left;visibility:hidden;display:none;padding:4px"><a  id="mousehand" href="javascript: void (0)" onClick="checkwindow1(document.ErMeasure.er_enddate,event);" style="text-decoration:none">
									<table border="0" cellpadding="0" cellspacing="0" ><tr><td ><egui:intnl text="reporter.common.To"/></td><td><img src="/final/reporter/images/calendar.gif" border="0" align="center"></td></tr> </table></a>
								</div>
<%
			if(er_timeline!=null&&!er_timeline.equals("Any"))
			{
				if(DateUtil.isDate(s_en_time,"MM/dd/yyyy"))
				{
					comFormat = "MM/dd/yyyy";
				}
				else
				{
					comFormat = currentDateFormat;
				}
				dispDate = DateUtil.changeDateFormat(s_en_time,comFormat,currentDateFormat);
			}
			else
			{
				dispDate = s_en_time;
			}
			rootJson.put("er_enddate", dispDate);
%>
							</div>

							<div style="float:left;padding:3px"> <input type="text" name="er_enddate" onfocus="this.blur()" style="text-align: center;" maxlength="12" size="14" value="<%=dispDate%>" readonly <%=disable%>></div>

							<div style="float:left;padding:5px 0px 5px 5px"> <egui:intnl text="reporter.common.Hr"/></div>


							<div style="float:left;padding:4px"> 
								<select name="er_endhr" <%=disable%>>
<%
				JSONArray endHrArr = new JSONArray();
				for(int e_ctr=0; e_ctr < 24 ;e_ctr++)
				{
					s_en_hr=s_en_hr.trim();
					JSONObject endHrObj = new JSONObject();
					endHrObj.put("displayField", String.valueOf(e_ctr));
					endHrObj.put("valueField", String.valueOf(e_ctr));
					if(s_en_hr!=null&&e_ctr == Integer.parseInt(s_en_hr))
					{
						rootJson.put("endhrcomboselected", s_en_hr);
									out.println("<option value='" + e_ctr + "' selected>" + e_ctr + "</option>");
					}else
					{
									out.println("<option value='" + e_ctr + "'>" + e_ctr + "</option>");
					}
					endHrArr.add(endHrObj);
				}
				rootJson.put("endhrcombo", endHrArr);
				labelObj.put("reporter.common.Graph", mappingInfo.getTextDescription("reporter.common.Graph"));
%>
								</select>
							</div>

							<div style="float:left;padding:2px;width:20px">&nbsp; </div>

							<div style="float:left;padding:4px"> <b><egui:intnl text="reporter.common.Graph"/>&nbsp;:</b></div>

							<div style="float:left;padding:4px"> 
								<select name="er_mode" width="50" style="width: 50;"  class="list" onChange="javascript:goTo('submit');">
<%
				String mode = request.getParameter("er_mode");
				boolean use3DGraphs = ui.use3DGraphs(IniUI.MONITOR);
				String select2d="";
				String select3d="";
				JSONArray modeArr = new JSONArray();
				JSONObject modeObj = new JSONObject();
				modeObj.put("displayField", mappingInfo.getTextDescription("reporter.common.2D"));
				modeObj.put("valueField", "2D");
				modeArr.add(modeObj);

				modeObj = new JSONObject();
				modeObj.put("displayField", mappingInfo.getTextDescription("reporter.common.3D"));
				modeObj.put("valueField", "3D");
				modeArr.add(modeObj);

				rootJson.put("mode", modeArr);
				if(mode!=null&&!mode.equals(""))
				{
					if(mode.equals("2D"))
						select2d="selected";
					if(mode.equals("3D"))
						select3d="selected";
				}
				else
				{
					if(use3DGraphs)
						select3d="selected";
					else
						select2d="selected";
				}
				if ( select3d.equalsIgnoreCase("selected") )
				{
					rootJson.put("modeselected", "3D");
				}
				else if ( select2d.equalsIgnoreCase("selected") )
				{
					rootJson.put("modeselected", "2D");
				}
%>
									<option value="2D" <%=select2d%>><egui:intnl text="reporter.common.2D"/></option>
									<option value="3D" <%=select3d%>><egui:intnl text="reporter.common.3D"/></option>
								</select>
							</div>
						</div>
					</td>
				</tr>
			</table>
<%
			}
%>
		</td>
	</tr>
	<tr>
		<td >&nbsp;</td>
	</tr>
	<tr>
		<td align="center">
			<table align="center" id="tablebg2" class="blackcontent" cellspacing="0" cellpadding="0" width="100%" border="0">
				<tr nowrap >
					<td align="center">
<%
			if(showFilter)
			{
%>
						<input type="button" name="sub" value='<egui:intnl text="reporter.measure.SUBMIT"/>' onClick='javascript:go2();' id="er_submit" style="height: 23px;">&nbsp;&nbsp;
<%
			}else
			{
%>
						<input type="button" name="sub" value='<egui:intnl text="reporter.measure.SUBMIT"/>' onClick='javascript:goTo("submit");' id="er_submit" style="height: 23px;">&nbsp;&nbsp;
<%
			}
%>
					</td>
				</tr>
			</table><br>
		</td>
	</tr>
</table>
<%
		}

String strImgWidth="800";
String strGraphWidth="650";
String strImgHeight="400";
String strGraphHeight="400";
if(gtype !=null && gtype.equalsIgnoreCase("Summary"))
	strImgHeight="300";
if(screenWidth>1200)
{
	try{
		strImgWidth = (Integer.parseInt(strImgWidth))+"";
		strImgHeight = (Integer.parseInt(strImgHeight))+"";

	}catch(Exception e){}
	try{
		strGraphWidth = (Integer.parseInt(strGraphWidth)+300)+"";
		strGraphHeight = (Integer.parseInt(strGraphHeight)+100)+"";

	}catch(Exception e){}
}	
		if(!("yes".equalsIgnoreCase(request.getParameter("er_timeline_change"))))
		{
%>

		<div class="printOuterBoxHeader">
<%
			String strTodispLay ="";
			String stokstrok=(String)v_qry_string.get(j);
			if(stokstrok.indexOf("/")>-1)
			{
				String s_distest= stokstrok.substring(0,stokstrok.indexOf("/"));
				String s_dismeas=stokstrok.substring(stokstrok.indexOf("/")+1);
				String struni="";	if(s_dismeas.indexOf("(")>-1)
				{
					struni=s_dismeas.substring(s_dismeas.indexOf("("));	s_dismeas=s_dismeas.substring(0,s_dismeas.indexOf("("));
				}
				rootJson.put("test", mappingInfo.getTestDescription(s_distest));
				rootJson.put("measure", mappingInfo.getMeasureDescription(s_distest, s_dismeas.trim()));

%>
			<egui:intnl test="<%=s_distest%>"/>/
			<egui:intnl measure='<%=s_distest+":"+s_dismeas.trim()%>'/>
																				<%=struni%>
<%
																				strTodispLay =mappingInfo.getTestDescription(s_distest) + "/" + mappingInfo.getMeasureDescription(s_distest,s_dismeas) +" " + struni ;
			}
			else if(stokstrok.indexOf(":")>-1)
			{
				if(stokstrok.indexOf("NULL:")>-1)
				{
					rootJson.put("type", mappingInfo.getComponentTypeDescription(stokstrok.substring(stokstrok.lastIndexOf(":")+1)));
					//s_component.substring(0,s_component.lastIndexOf(":NULL"))+s_component.substring(s_component.lastIndexOf(":"));
%>
																				<%=stokstrok.substring(0,stokstrok.lastIndexOf("NULL:"))%>
																				<!-- <%//=s_component.substring(0,s_component.lastIndexOf(":"))%> -->
			<egui:intnl type='<%=stokstrok.substring(stokstrok.lastIndexOf(":")+1)%>'/>
<%
																				strTodispLay =stokstrok.substring(0,stokstrok.lastIndexOf("NULL:"))+mappingInfo.getComponentTypeDescription(stokstrok.substring(stokstrok.lastIndexOf(":")+1));
				}else
				{
																				strTodispLay =stokstrok.substring(0,stokstrok.lastIndexOf(":"))+mappingInfo.getComponentTypeDescription(stokstrok.substring(stokstrok.lastIndexOf(":")+1));
					rootJson.put("type", mappingInfo.getComponentTypeDescription(stokstrok.substring(stokstrok.lastIndexOf(":")+1)));
%>
																				<%= stokstrok.substring(0,stokstrok.lastIndexOf(":")) %>:
			<egui:intnl type='<%=stokstrok.substring(stokstrok.lastIndexOf(":")+1)%>'/>
<%
				}
			}else
			{
																					strTodispLay =mappingInfo.getTextDescription("reporter.measure."+stokstrok);
				labelObj.put("reporter.common."+stokstrok, mappingInfo.getTextDescription(stokstrok));
%>
			<egui:intnl text='<%="reporter.common."+stokstrok%>'/>
<%
			}
%>
		</div>
		
<table cellspacing="0" cellpadding="0" border="0" class="printTable" width="100%">
	<tr>
		<td align="center" width="100%"  height="auto" valign="top">
<%
																String printOption = request.getParameter("print");
																if(!(gtype !=null && gtype.equalsIgnoreCase("Summary")) || (printOption != null && printOption.equalsIgnoreCase("yes")))
																{
%>

			<div style="width:100%;overflow:auto;padding:0px"  height="auto"><img src="<%=Qstring%>&er_width=<%=strImgWidth%>&er_height=<%=strImgHeight%>&option=graph&er_legendPosition=right" border="0" hspace="0" vspace="5" alt="<%=v_qry_string.get(j)%>" 	title="<%=strTodispLay%>" height="auto" /><div>
<%
																}
																else
																{
																	Map requestMap = new HashMap(request.getParameterMap());
																	if (requestMap.containsKey("drilldownenabled")) {
																		requestMap.remove("drilldownenabled");
																	}
																	if (requestMap.containsKey("er_width")) {
																		requestMap.remove("er_width");
																	}
																	if (requestMap.containsKey("er_height")) {
																		requestMap.remove("er_height");
																	}
																	String qstring = ErUtils.prepareQueryString(requestMap);
																	qstring = "/final/servlet/com.eg.ErSummaryC?"+qstring;
				rootJson.put("chartURL", qstring+"&er_width="+strGraphWidth+"&er_height="+strImgHeight+"&er_align=center&option=graph&er_view=APPLET");
%>

			<iframe src="<%=qstring+"&er_width="+strGraphWidth+"&er_height="+strImgHeight+"&er_align=center"%>&option=graph&er_view=APPLET" align="center" scrolling="no" style="width:100%;height:<%=strGraphHeight%>;border:0;" frameborder="0" vspace="0" hspace="0" marginwidth="0" marginheight="0"></iframe>
<%
																}
%>

		</td>
	</tr>
</table>
<%
	com.eg.EgReportInfo reportinfo = new com.eg.EgReportInfo("manager");
	String strselectioncount = reportinfo.getValue("MISC","RightDisplaySelectioncount");
	int selectioncount=10;
	if(strselectioncount !=null && !strselectioncount.equals(""))
	{
		try
		{
			selectioncount = Integer.parseInt(strselectioncount);
		}
		catch (Exception e)
		{
			selectioncount = 10;
		}
	}
 	if (singleSelection != null && singleSelection.size() >selectioncount && showLegendAsHtml && false)
	{
%>
	<!--GRAPH IMAGE CONTAINER STARTS HERE(singleselection=>gtype(single or multiple))-->
<table width="100%" border="0" cellspacing="0" cellpadding="0">
<%
			int count1=0;
			for (int k=0; k <singleSelection.size();k++)
			{
				String st_key = (String)singleColors.get(k);
				String value = (String)singleSelection.get(k);
				if(st_key != null && st_key.indexOf("#") > -1)
				{
					st_key = st_key.substring(1,st_key.length());
				}
				//vec.add("http://192.168.10.48:7777/final/servlet/com.eg.ErImageDrawC?req="+st_key);
				//vec.add(value);
			if(k%2 ==0)
			{
		%>
	<tr> 
		<td width="5%"align="right" id="cellbgwhite">&nbsp;<img src="/final/servlet/com.eg.ErImageDrawC?req=<%=st_key%>"/></td>
		<td width="45%" align="left" nowrap id="cellbgwhite"><span class="<%=fontStyleDblSingl%>">&nbsp;&nbsp;<%=value%></span></td>
						
		<%
			}
			else if(k%2 !=0)
			{
		 %>
		<td width="5%"align="right" id="cellbgwhite">&nbsp;<img src="/final/servlet/com.eg.ErImageDrawC?req=<%=st_key%>"/></td>
		<td width="45%" align="left" nowrap id="cellbgwhite"><span class="<%=fontStyleDblSingl%>">&nbsp;&nbsp;<%=value%></span></td>
	</tr>

		 <%
			}
			else
			{
		 %>
		<td width="5%"align="right" id="cellbgwhite">&nbsp;<img src="/final/servlet/com.eg.ErImageDrawC?req=<%=st_key%>"/></td>
		<td width="95%" align="left" nowrap id="cellbgwhite"><span class="<%=fontStyleDblSingl%>">&nbsp;&nbsp;<%=value%></span></td>

		 <%
			}
			}
			if(singleSelection.size()%2 !=0)
			{
		 %>
		<td width="50%"align="right" id="cellbgwhite" colspan="2">&nbsp;</td>
	</tr>
		<%
			}
%>
	<tr>
		<td width="100%"align="right" id="cellbgwhite" colspan="4">&nbsp;</td>
	</tr>
</table>
<br/>
<%
		}
	}
	else
	{
%>
<div class="claerDiv"> &nbsp;</div>
<%
		}
%>
</div>
<%
		rootJson.put("REPORT_PARAM", request.getQueryString());
		rootJson.put("REPORT_DATA", v_pdf_qry);
		HashMap param =new HashMap();
		param.put("REPORT_PARAM",ErUtils.parseQueryString(ErUtils.prepareQueryString(request.getParameterMap())));
		param.put("REPORT_DATA",v_pdf_qry);
		session.setAttribute("enlargedparameters", param);
	}
%>
<input type="hidden" name="startdate" value="<%=s_st_time%>">
<input type="hidden" name="enddate" value="<%=s_en_time%>">
<input type="hidden" name="starthr" value="<%=s_st_hr%>">
<input type="hidden" name="endhr" value="<%=s_en_hr%>">
<input type="hidden" name="startmin" value="<%=startMin%>">
<input type="hidden" name="endmin" value="<%=endMin%>">
<%

		hiddenObj = new JSONObject();
		hiddenObj.put("startdate", s_st_time);
		hiddenArr.add( hiddenObj);

		hiddenObj = new JSONObject();
		hiddenObj.put("enddate", s_en_time);
		hiddenArr.add( hiddenObj);

		hiddenObj = new JSONObject();
		hiddenObj.put("starthr", s_st_hr);
		hiddenArr.add( hiddenObj);

		hiddenObj = new JSONObject();
		hiddenObj.put("endhr", s_en_hr);
		hiddenArr.add( hiddenObj);

		hiddenObj = new JSONObject();
		hiddenObj.put("startmin", startMin);
		hiddenArr.add( hiddenObj);

		hiddenObj = new JSONObject();
		hiddenObj.put("endmin", endMin);
		hiddenArr.add( hiddenObj);

%>
<%
	session.setAttribute("DrillDownPage","yes");
	String qryValue = Qstring.substring(Qstring.indexOf("?")+1,Qstring.length());
	String dataProcess =  mngrIProc+ "/final/reporter/ErMeasure.jsp"+";jsessionid="+ session.getId()+"?"+qryValue+"&print=yes&sample=yes&drillSes=yes&";
	session.setAttribute("DRILLDOWN_MAIL_URL",dataProcess);
	rootJson.put("DRILLDOWN_MAIL_URL",dataProcess);
	rootJson.put("screenLabels", labelObj);
	if(pdfPrint != null && pdfPrint.equalsIgnoreCase("yes"))
	{
%>
		<div class="printFooterText"><%=strPrintFooterText%></div>
<%
	}
}
catch(Throwable e)
{
	System.err.println("[Exception] "+e);
	e.printStackTrace();
}
%>
</body>
</html>