<%
	/************************************************************************************************
	 *	File				: ErLogonFailureJSON.jsp
	 *	Version				: 7.0
	 *	Author				: Ganesh P
	 *	Creation Date		: 15/Nov/2017
	 *
	 *************************************************************************************************/
%>
<%@ include file="ErReporterTracker.jsp"%>

<%@ page import="com.eg.EgReportInfo"%>
<%@ page import="com.eg.EgMappingInfo"%>
<%@ page import="com.egurkha.User"%>
<%@ page import="com.egurkha.UserRegistry"%>
<%@ page import="egurkha.reporter.ErBackgroundReportGenerator"%>
<%@ page import="egurkha.reporter.LogonFailureBean"%>
<%@ page import="egurkha.reporter.EventLogBroken"%>
<%@ page import="egurkha.reporter.ErEsxVMutils"%>
<%@ page import="com.eg.EgSpecsInfo"%>
<%@ page import="egurkha.reporter.ErUtils"%>
<%@ page import="com.egurkha.util.StringUtils"%>
<%@ page import="com.egurkha.util.DateUtil"%>
<%@ page import="com.egurkha.util.DateTimeTokenizer"%>	
<%@ page import="com.eg.EgDateInfo"%>
<%@ page import="com.eg.EgConfigInfo"%>
<%@ page import="java.text.SimpleDateFormat"%>
<%@ page import="java.text.ParseException"%>

<%@ page import="java.util.List"%>
<%@ page import="java.util.Set"%>
<%@ page import="java.util.Map"%>
<%@ page import="java.util.Iterator"%>
<%@ page import = "net.sf.json.*" %>


<%@ page import="java.util.Vector"%>
<%@ page import="java.util.Hashtable"%>
<%@ page import="java.util.ArrayList"%>
<%@ page import="java.util.HashMap"%>
<%@ page import="java.util.Collections"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%
	try
	{
		response.setContentType("application/json;charset=UTF-8");
		Map allData = (Map)request.getAttribute("allData");
		EgReportInfo reportInfo= new EgReportInfo("manager");
		User this_user= UserRegistry.getInstance().getUser(session.getId());
		String thisUserLang= this_user.getLanguage();
		String loginid= this_user.getLoginID();
		ErComponentsUtils compUtils = new ErComponentsUtils(loginid);
		EgMappingInfo intlmap= new EgMappingInfo(thisUserLang);
		ErUserData erUser=new ErUserData(loginid,false);
		IniUI ui= IniUI.getInstance();
		

		JSONObject rootJson=  new JSONObject();
		JSONObject selectedField=new JSONObject();
		JSONObject screenLableJSON=new JSONObject();
		String lblAnalysisBy = intlmap.getTextDescription("reporter.common.Analyze by");
		String lblCompType = intlmap.getTextDescription("reporter.common.Component Type");
		String lblComponent = intlmap.getTextDescription("reporter.common.Component");
		
		screenLableJSON.put("lblAnalysisBy", lblAnalysisBy);
		screenLableJSON.put("lblCompType", lblCompType);
		screenLableJSON.put("lblComponent", lblComponent);
		rootJson.put("screenLabel", screenLableJSON);
		String er_timeline= request.getParameter("er_timeline");
		String s_st_time= request.getParameter("startdate");
		String s_en_time= request.getParameter("enddate");
		String s_st_hr= request.getParameter("starthr");
		String s_en_hr= request.getParameter("endhr");
		String startmin = request.getParameter("startmin");
		String endmin = request.getParameter("endmin");
		String strmin = startmin;
		String enmin = endmin;
		String currentDateFormat = strUserDateFormat;

		String inifile = "eg_report.ini";
		String inifileDir = EgInstallInfo.getInstallDir()+"/manager/config/";
		IniFile inifiles = new IniFile(inifileDir+inifile);
		String Days = inifiles.getValue("EXCLUDE_WEEKEND","Days");
		String er_view=request.getParameter("er_view");
		String analysisBy=request.getParameter("analysisBy");
		String er_subZone=request.getParameter("er_subZone");
		String method=request.getParameter("method");
		String mngrIProc= new IniFile(new EgConfigInfo("manager").getDbFile()).getValue("DB_PROPERTIES","ManagerUrl");
		String reportType=request.getParameter("reportType");
		if(allData==null || allData.size()==0)
		{
			String dispDate= null;
			String comFormat= null;	
			String reportIniStr = "";
			String reportTitle=" ";				
			String noFailMSG ="";
			String limitforbg= reportInfo.getValue("BACKGROUND_PROCESS","MinDurationForReport");
			int maxDays= ErUtils.getMaxDaysInMonth();			 			
		    EgSpecsInfo specsInfo = new EgSpecsInfo("manager");			
			String compType[]=request.getParameterValues("er_compType");
			String components[]=request.getParameterValues("er_Component");
			List v_components = compUtils.getAllUserComponents1();
			List useSupportCompTypeList=new ArrayList();
			String CtxZoneComponents=inifiles.getValue("MISC","CtxZoneComponents");
			String supportedComponents=request.getParameter("supportedComponents");			
			List CtxZoneComponentsList=null;
			if(CtxZoneComponents != null && CtxZoneComponents.trim() != "" && CtxZoneComponents.length() > 2)
				CtxZoneComponentsList=Arrays.asList(CtxZoneComponents.split(","));
			boolean allCompTypeSupport=true;
			if(supportedComponents != null && supportedComponents.equalsIgnoreCase("citrix"))
			{
				allCompTypeSupport=false;
			}
			System.out.println("v_components-->"+v_components);
			if(reportType.equals("Logon Failure"))
			{
				reportIniStr = "Application_Logon_Failure_Report";	
				String testName = reportInfo.getValue(reportIniStr,"testName");
				for(int v=0;v<v_components.size();v++)
				{
					String eachComp=(String)v_components.get(v);
					if(eachComp != null && eachComp.indexOf(":") != -1)
					{
						eachComp=eachComp.substring(eachComp.lastIndexOf(":")+1,eachComp.length());
						//boolean status = specsInfo.isTestRelevantForServer(eachComp,"SecurityLogTest");
						boolean status = specsInfo.isTestRelevantForServer(eachComp,testName);
						System.out.println("status-->"+status+"  eachComp-->"+eachComp);
						if(status)
						{
							/*if(!allCompTypeSupport && CtxZoneComponentsList != null && CtxZoneComponentsList.contains(eachComp))
							{
								if(!useSupportCompTypeList.contains(eachComp))
									useSupportCompTypeList.add(eachComp);
							}
							else if(allCompTypeSupport && CtxZoneComponentsList != null && !CtxZoneComponentsList.contains(eachComp))
							{
								if(!useSupportCompTypeList.contains(eachComp))
									useSupportCompTypeList.add(eachComp);
							}*/
							if(!useSupportCompTypeList.contains(eachComp))
								useSupportCompTypeList.add(eachComp);
						 }
					}
				}
			}
			else if(reportType.equals("VMUnregistered"))
			{
				reportIniStr = "Application_Event_Log_Report";				
				String componentStr = reportInfo.getValue(reportIniStr,"Components");
				StringTokenizer stToken = new StringTokenizer(componentStr,",");
			    while (stToken.hasMoreTokens())
				{
					String component = stToken.nextToken();
					if(!useSupportCompTypeList.contains(component))
						useSupportCompTypeList.add(component);
				}
			}	
			reportTitle = reportInfo.getValue(reportIniStr,"reportTitle");				
			noFailMSG = reportInfo.getValue(reportIniStr,"msg_no_error");
			rootJson.put("reportTitle",reportTitle);
			System.out.println("useSupportCompTypeList-->"+useSupportCompTypeList);
			//..
			JSONArray tempArry=new JSONArray();;
			JSONObject tempObj=null;
			ArrayList aListSupportedComponentType=new ArrayList();
			if(compType != null && compType.length > 0)
			{
				for(int c=0;c<compType.length;c++)
				{
					String eachCompType=(String)compType[c];
					if(eachCompType != null)
					{
						if(eachCompType.equalsIgnoreCase("all"))
							aListSupportedComponentType.addAll(useSupportCompTypeList);
						else
							aListSupportedComponentType.add(eachCompType);
					}
				}
			}
			else
			{
				aListSupportedComponentType.addAll(useSupportCompTypeList);
			}
			ErEsxVMutils erEsxUtils= new ErEsxVMutils();
			List v_option = new ArrayList();
			Hashtable htAllGroups = new Hashtable();
			htAllGroups = erEsxUtils.getGroups(null, aListSupportedComponentType, this_user, loginid, "Yes", true);
			ArrayList aListOption = erEsxUtils.getOptions(htAllGroups);
			if (aListOption != null && aListOption.size() > 0)
			{
				v_option.addAll(aListOption);
			}
		
			if(analysisBy == null)
			{
				analysisBy="Component";
			}
			if (v_option != null && v_option.size() > 0)
			{
				selectedField.put("selectedAnalysisBy",analysisBy);
				for (int i = 0; i < v_option.size(); i++) 
				{
					tempObj = new JSONObject();
					tempObj.put("displayField",intlmap.getTextDescription("reporter.common." + v_option.get(i)));
					tempObj.put("valueField", v_option.get(i));
					tempArry.add(tempObj);
				}
			} 
			else
			{
				tempObj = new JSONObject();
				tempObj.put("displayField", intlmap.getTextDescription("reporter.common.Not Applicable"));
				tempObj.put("valueField", "-1");
				tempArry.add(tempObj);
			}
			rootJson.put("analysisBy",tempArry);		
			if(method == null)
			{
				method="init";
			}
			String er_site = request.getParameter("er_site");
			List v_site=new ArrayList();
			Vector v_zone = new Vector();
			Vector v_componentType = new Vector();	
			List aListComponentTemp=null;
			if(analysisBy != null)
			{
				v_site = erEsxUtils.getGroupsName(htAllGroups,analysisBy);
				if(v_site!=null )
					Collections.sort(v_site,String.CASE_INSENSITIVE_ORDER);
				if(analysisBy.equals("Segment") || analysisBy.equals("Service") || analysisBy.equals("Zone"))
				{
					if(er_site==null && v_site!=null && v_site.size()>0)
					{
						er_site=(String)v_site.get(0);
					}
					aListComponentTemp = erEsxUtils.getComponentForGroup(htAllGroups,analysisBy,er_site);
					rootJson.put("siteCombo",getJSONComboFromList(v_site,"",intlmap));
					selectedField.put("selectedSiteCombo",er_site);
					List subZoneList=new ArrayList();
					subZoneList.add("Yes");
					subZoneList.add("No");
					rootJson.put("subZoneCombo",getJSONComboFromList(subZoneList,"",intlmap));
					if(er_subZone == null)
					{
						er_subZone="Yes";
					}
					selectedField.put("selectedSubZone",er_subZone);
				}
				else if(analysisBy.equals("Component"))
				{
					aListComponentTemp = erEsxUtils.getComponentForGroup(htAllGroups,analysisBy,null);
				}			
			}
			//..
			
			List componentList=new ArrayList();
			JSONArray selectedComponentTypes=new JSONArray();
			if(aListComponentTemp != null && aListComponentTemp.size() > 0)
			{
				List componentTypeList=new ArrayList();
				tempArry=new JSONArray();
				tempObj = new JSONObject();
				tempObj.put("displayField",intlmap.getTextDescription("reporter.common.Please choose a Component Type"));
				tempObj.put("valueField", "-1");
				tempArry.add(tempObj);
				if(analysisBy.equals("Segment") || analysisBy.equals("Service") || analysisBy.equals("Zone"))
				{
					for(int c=0;c<aListComponentTemp.size();c++)
					{
						String comp=(String)aListComponentTemp.get(c);
						if(comp != null && comp.indexOf(":") != -1)
						{
							String compTypeStr=comp.substring(comp.lastIndexOf(":")+1);
							if(!componentTypeList.contains(compTypeStr))
							{
								componentTypeList.add(compTypeStr);
							}
							
						}
					}
				}
				else if(analysisBy.equals("Component"))
				{
					for(int n=0;n<useSupportCompTypeList.size();n++)
					{
						String comp = (String)useSupportCompTypeList.get(n);
						if(!componentTypeList.contains(comp))
						{
							componentTypeList.add(comp);
						}					
					}
				}
				for(int k=0;k<componentTypeList.size();k++)
				{
					String compTypeStr=(String)componentTypeList.get(k);
					tempObj = new JSONObject();
					tempObj.put("displayField",intlmap.getComponentTypeDescription(compTypeStr));
					tempObj.put("valueField", compTypeStr);
					tempArry.add(tempObj);
				}
				if(compType==null && componentTypeList!=null && componentTypeList.size()>0)
				{
					selectedComponentTypes.add(componentTypeList.get(0));
					selectedField.put("selectedComponentTypes",selectedComponentTypes);
				}
				else if(compType != null)
				{
					for(int c=0;c<compType.length;c++)
					{
						String eachSelectedCompType=(String)compType[c];
						selectedComponentTypes.add(eachSelectedCompType);
					}
					selectedField.put("selectedComponentTypes",selectedComponentTypes);
				}
				rootJson.put("compTypeCombo",tempArry);
				
				for(int c=0;c<aListComponentTemp.size();c++)
				{
					String comp=(String)aListComponentTemp.get(c);
					if(comp != null && comp.indexOf(":") != -1)
					{
						String compTypeStr=comp.substring(comp.lastIndexOf(":")+1);
						if(selectedComponentTypes.contains(compTypeStr))
						{
							if(!componentList.contains(comp))
							{
								componentList.add(comp);
							}
						}
					}
				}
			}
			JSONArray selectedComponents=new JSONArray();
			tempArry=new JSONArray();
			boolean singleCompType=false;
			if(selectedComponentTypes.size() ==1)
			{
				String tempCompType=(String)selectedComponentTypes.get(0);
				if(tempCompType != null && !tempCompType.equalsIgnoreCase("all"))
				{
					singleCompType=true;
				}
			}
			if(componentList.size() > 0)
			{
				if(componentList.size() > 1)
				{
					tempObj = new JSONObject();
					tempObj.put("displayField","All");
					tempObj.put("valueField","All");
					tempArry.add(tempObj);
				}
				for(int c=0;c<componentList.size();c++)
				{
					String eachCompstr=(String)componentList.get(c);
					String tempComp=eachCompstr;
					String cType=eachCompstr.substring(eachCompstr.lastIndexOf(":")+1);
					cType=intlmap.getComponentTypeDescription(cType);
					String portNo=eachCompstr.substring(eachCompstr.indexOf(":")+1,eachCompstr.lastIndexOf(":"));
					if(portNo.equalsIgnoreCase("null"))
					{
						eachCompstr=eachCompstr.substring(0,eachCompstr.indexOf(":"))+":"+cType;
					}
					if(singleCompType)
					{
						eachCompstr=eachCompstr.substring(0,eachCompstr.lastIndexOf(":"));
					}
					tempObj = new JSONObject();
					tempObj.put("displayField",eachCompstr);
					tempObj.put("valueField",tempComp);
					tempArry.add(tempObj);
				}
				if(components != null && components.length>0)
				{
					for(int c=0;c<components.length;c++)
					{
						String selComp=(String)components[c];
						selectedComponents.add(selComp);
					}
					
				}
				else
				{
					String fistComp=(String)componentList.get(0);
					selectedComponents.add(fistComp);
				}
				selectedField.put("selectedComponents",selectedComponents);
			}
			else
			{
				tempObj = new JSONObject();
				tempObj.put("displayField",intlmap.getTextDescription("reporter.common.Not Applicable"));
				tempObj.put("valueField", "-1");
				tempArry.add(tempObj);
			}
			rootJson.put("componentCombo",tempArry);
			rootJson.put("groupList",tempArry);
			//timeline
			if (er_timeline == null || er_timeline.equals(" ")) 
			{
				er_timeline = "1 day";
			}
			EgDateInfo egDt = new EgDateInfo();
			long msecsPerHour = (long) 1000 * 60 * 60;
			String[] options = { "Any", "1 hour", "3 hours", "6 hours", "9 hours", "12 hours", "15 hours","18 hours", "21 hours", "1 day", "2 days", "3 days", "4 days", "5 days", "6 days", "1 week","2 weeks", "3 weeks", "4 weeks", "1 month", "2 months", "3 months" };
			String startDateTime = "";
			String endDateTime = "";
			if (er_timeline != null && !er_timeline.equals("Any")) 
			{
				int blankSpaceIndex = er_timeline.indexOf(DateTimeTokenizer.BLANK_SPACE);
				if (blankSpaceIndex > 0) 
				{
					SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy HH:mm");
					java.util.Date today = egDt.egetRealDate();
					endDateTime = sdf.format(today);
					long value = Integer.parseInt(er_timeline.substring(0, blankSpaceIndex));
					String unit = er_timeline.substring(blankSpaceIndex + 1).toLowerCase();
					if (unit.startsWith("h"))
					{//hours
						value *= 3600;
					} 
					else if (unit.startsWith("d"))
					{//days
						value *= (24 * 3600);
					} 
					else if (unit.startsWith("w")) 
					{//weeks
						value *= (7 * 24 * 3600);
					} 
					else if (unit.startsWith("mo")) 
					{//months
						java.util.Date dt_temp = new java.util.Date(egDt.egetUTCDate());
						Calendar cal_temp = new GregorianCalendar();
						cal_temp.setTime(dt_temp);
						cal_temp.add(Calendar.HOUR_OF_DAY, 0);
						java.util.Date dt_temp1 = cal_temp.getTime();
						long l_temp = dt_temp1.getTime();
						int totalDays = 24 * (maxDays);
						startDateTime = egDt.egetDate(l_temp - (long) ((value * totalDays * msecsPerHour)));
						startDateTime = DateUtil.changeDateFormat(startDateTime, "dd/MM/yyyy HH:mm","MM/dd/yyyy HH:mm");
					}
					if (unit != null && !unit.startsWith("mo"))
					{
						java.util.Date start = egDt.egetRealDate();
						start.setTime(today.getTime() - (value * 1000));
						startDateTime = sdf.format(start);
					}

					if ((startDateTime != null) && (endDateTime != null)) 
					{
						int shr = Integer.parseInt(startDateTime.substring(startDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE) + 1,startDateTime.indexOf(":")));
						strmin = startDateTime.substring(startDateTime.indexOf(":") + 1);
						int en_hr = Integer.parseInt(endDateTime.substring(endDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE) + 1, endDateTime.indexOf(":")));
						enmin = endDateTime.substring(endDateTime.indexOf(":") + 1);
						s_en_time = endDateTime.substring(0, endDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE));
						s_st_time = startDateTime.substring(0, startDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE));
						s_st_hr = String.valueOf(shr);
						s_en_hr = String.valueOf(en_hr);
					}
				}
			}
			String disable = "";
			if (er_timeline != null && !er_timeline.equals("Any"))
			{
				disable = "disabled";
			}
			if (er_timeline != null && er_timeline.equals("Any")) 
			{
				String StrDate = "";
				try 
				{
					java.text.SimpleDateFormat df = new java.text.SimpleDateFormat("MM/dd/yyyy k 'at' hh:mm");
					StrDate = df.format(egDt.egetRealDate());
				} 
				catch (Exception ee)
				{
					System.out.println("Exception is"+ee);
				}
				String SDate = StrDate.substring(0, StrDate.indexOf(" "));
				String shour = StrDate.substring(StrDate.indexOf(" "), StrDate.lastIndexOf(""));
				shour = shour.substring(0, 3);
				if (s_st_time == null)
				{
					s_st_time = SDate;
				}
				if (s_en_time == null)
				{
					s_en_time = SDate;
				}
				if (s_st_hr == null)
				{
					shour = shour.trim();
					int starthr = Integer.parseInt(shour);
					starthr = starthr - 1;
					s_st_hr = String.valueOf(starthr);
				}
				if (s_en_hr == null)
				{
					shour = shour.trim();
					s_en_hr = shour;
				}
				strmin = "00";
				enmin = "00";
			}
			String hourFrom = "";
			String minFrom = "";
			String hourTo = "";
			String minTo = "";
			String fromTime = reportInfo.getTimeFrame("Application_Crash_Fault_Report","FROM");
			String toTime = reportInfo.getTimeFrame("Application_Crash_Fault_Report","TO");
			StringTokenizer	st = new StringTokenizer(fromTime,":");
			if(st.hasMoreTokens())
			{
				hourFrom = st.nextToken();
				minFrom = st.nextToken();
			}
			st = new StringTokenizer(toTime,":");
			if(st.hasMoreTokens())
			{
				hourTo = st.nextToken();
				minTo = st.nextToken();
			}
			String hourFromUI= request.getParameter("hourFromUI");
			String minFromUI= request.getParameter("minFromUI");
			String hourToUI= request.getParameter("hourToUI");
			String minToUI= request.getParameter("minToUI");
			String exclweekUI= request.getParameter("exclweek");
			String reportGenerationType = request.getParameter("repGenType");
			if(hourFromUI == null) hourFromUI = hourFrom;
			if(minFromUI== null) minFromUI= minFrom;
			if(hourToUI== null) hourToUI= hourTo;
			if(minToUI== null) minToUI= minTo;
			if(exclweekUI== null) 
				exclweekUI= "No";
			if (reportGenerationType==null) 
				reportGenerationType = "foreground";
			rootJson.put("sHrForSetting",hourFromUI);
			rootJson.put("sMinForSetting",minFromUI);
			rootJson.put("eHourForSetting",hourToUI);
			rootJson.put("eMinForSetting",minToUI);
			rootJson.put("sExclweekUI",exclweekUI);
			rootJson.put("sRepGenType",reportGenerationType);
			JSONArray exclweekArray  =  new JSONArray();
			JSONObject tmpobj=new JSONObject();
			tmpobj.put("displayField",intlmap.getTextDescription("reporter.common.Yes")+" ("+Days+") ");
			tmpobj.put("valueField", "Yes");
			exclweekArray.add(tmpobj);
			tmpobj = new JSONObject();
			tmpobj.put("displayField",intlmap.getTextDescription("reporter.common.No"));
			tmpobj.put("valueField", "No");
			exclweekArray.add(tmpobj);
			rootJson.put("excludeWeekCombo",exclweekArray);
			rootJson.put("excludeMessage",intlmap.getTextDescription("reporter.common.Excludes")+" "+Days);
			JSONArray reportGenerationComboArray =  new JSONArray();
			tmpobj=new JSONObject();
			tmpobj.put("displayField", strforeground);
			tmpobj.put("valueField", "foreground");
			reportGenerationComboArray.add(tmpobj);
			tmpobj=new JSONObject();
			tmpobj.put("displayField", strbackground);
			tmpobj.put("valueField", "background");
			reportGenerationComboArray.add(tmpobj);
			tmpobj=new JSONObject();
			tmpobj.put("displayField", intlmap.getTextDescription("reporter.common.Background Save - CSV"));
			tmpobj.put("valueField", "background-csv");
			reportGenerationComboArray.add(tmpobj);
			rootJson.put("reportGenerationCombo",reportGenerationComboArray);
			%>
					<%@  include file="ErTimeFormatJSON.jsp"%>
			<%
			rootJson.put("timelineCombo", timelineComboArray);
			rootJson.put("selectedTimeline", er_timeline);
			rootJson.put("startDate", startDateJSON);
			rootJson.put("endDate", endDateJSON);
			rootJson.put("startHour", startHourJSON);
			rootJson.put("endHour", endHourJSON);
			rootJson.put("startmin", startMin);
			rootJson.put("endmin", endMin);
			rootJson.put("inidate",currentDateFormat);

			rootJson.put("startDateForDisplay",startDateForDisplay);
			rootJson.put("startHourForDisplay",startHourForDisplay);
			rootJson.put("startMinForDisplay",startMinForDisplay);
			rootJson.put("endDateForDisplay",endDateForDisplay);
			rootJson.put("endHourForDisplay",endHourForDisplay);
			rootJson.put("endMinForDisplay",endMinForDisplay);

			String userStDateTime  = startDateForDisplay+" "+startHourForDisplay+":"+startMinForDisplay+" hrs";
			String userEndDateTime = endDateForDisplay+" "+endHourForDisplay+":"+endMinForDisplay+" hrs";
			rootJson.put("userStDateTime",userStDateTime);
			rootJson.put("userEndDateTime",userEndDateTime);
			rootJson.put("loginid", loginid);
			rootJson.put("limitforbg", limitforbg);
			rootJson.put("maxDays", maxDays);
			rootJson.put("noFailMSG", noFailMSG);
			rootJson.put("selectedField",selectedField);
			//
			HashMap backreqMap  = (HashMap)session.getAttribute("backQuery");
			String backQnumber  = request.getParameter("backQnumber");
			String servlet2     = request.getParameter("backServletName");
			String bggroundStr  = (String)request.getAttribute("bggroundStr");
			String status       = (String)request.getAttribute("status");
			String queryString =(String)ErUtils.prepareQueryString(request.getParameterMap());
			ErHelperUtils erhelputils = null;
			if( servlet2!=null && !servlet2.equals(""))
				erhelputils = new ErHelperUtils(backreqMap,backQnumber,servlet2);
			else
				erhelputils = new ErHelperUtils(backreqMap,backQnumber);
			boolean enableBack =erhelputils.isBackButtonEnable();
			String backButtonEnable = request.getParameter("back");
			if(backButtonEnable != null && backButtonEnable.equalsIgnoreCase("True"))
			{
				status = (String)request.getParameter("status");
				bggroundStr = (String)request.getParameter("bggroundStr");
			}
			ArrayList listbackvar = new  ArrayList();
			if(request.getParameter("isSubmit")!=null)
			{
				listbackvar.add("ErLogonFailure.jsp");
				if(er_view != null && er_view.equalsIgnoreCase("submit"))
					listbackvar.add("status="+status+"&isSubmit=true&bggroundStr="+bggroundStr+"&"+queryString);
				else
					listbackvar.add("status="+status+"&bggroundStr="+bggroundStr+"&"+queryString);
				session.setAttribute("favSchBackDisplay","Yes");
			}
			else
			{
				listbackvar.add("ErLogonFailure.jsp");
				if(er_view != null && er_view.equalsIgnoreCase("submit"))
					listbackvar.add(queryString+"&isSubmit=true");
				else
					listbackvar.add(queryString);
				session.setAttribute("favSchBackDisplay","No");
			}
			if(request.getParameter("enableBack")==null)
			{
				if(request.getParameter("isSubmit")!=null)
					session.setAttribute("reportLastAccessedURL","/final/reporter/ErLogonFailure.jsp?isSubmit=true&"+queryString);
				else
					session.setAttribute("reportLastAccessedURL","/final/reporter/ErLogonFailure.jsp?&"+queryString);
			}
			String backadded = erhelputils.getBackID();
			backreqMap = erhelputils.setBackQueryMap(backreqMap,backadded,listbackvar);
			session.setAttribute("backQuery",backreqMap);
			if(backreqMap != null && backreqMap.size() >0 && "true".equalsIgnoreCase(request.getParameter("enableBack")))
			{
				rootJson.put("ID","backQnumber="+erhelputils.getBackID()+"&"+erhelputils.getQueryString());
			}
		}
		else
		{
			HashMap backreqMap= (HashMap)session.getAttribute("backQuery");
			String backQnumber= request.getParameter("backQnumber");
			String servlet2= request.getParameter("backServletName");
			String bggroundStr= (String)request.getAttribute("bggroundStr");
			String status= (String)request.getAttribute("status");
			Map data= request.getParameterMap();
			String modifiedFormat = currentDateFormat;
			if (modifiedFormat.startsWith("yy") || modifiedFormat.startsWith("YY")|| modifiedFormat.startsWith("yyyy")||modifiedFormat.startsWith("YYYY"))
			{
				modifiedFormat=modifiedFormat.substring(modifiedFormat.lastIndexOf("y")+2,modifiedFormat.length());
			}
			else if (modifiedFormat.endsWith("yy") || modifiedFormat.endsWith("YY")|| modifiedFormat.endsWith("yyyy")||modifiedFormat.endsWith("YYYY"))
			{
				modifiedFormat=modifiedFormat.substring(0,modifiedFormat.indexOf("y")-1);
				if(modifiedFormat.endsWith(","))
				{
					modifiedFormat=modifiedFormat.substring(0,modifiedFormat.indexOf(",")-1);
				}
			}
			JSONArray failJsonArr = null;
			JSONArray allFailGridArr = new JSONArray();
			JSONObject userViewColumn = new JSONObject();
			JSONArray userViewSubColumnArray = new JSONArray();
			String hideDesign = (String)allData.get("hideDesign");
			boolean isData = (Boolean)allData.get("isData");
			rootJson.put("isData", isData);
			if(reportType.equals("Logon Failure"))
			{
				List<LogonFailureBean> failList = (List)allData.get("allDataList");				
				if(hideDesign.equalsIgnoreCase("No"))
				{
					int failureAllCount = failList.size();
					ErUtils erUtils = new ErUtils();
					JSONObject overViewJsonObj = null;
					if(failureAllCount > 0)
					{
						JSONArray overViewJsonArray = (JSONArray)allData.get("overDataMap");
						rootJson.put("failureOverView", overViewJsonArray);				
						JSONObject pieChartObj = (JSONObject)allData.get("pieChartObj");
						rootJson.put("donutChartFailure",pieChartObj);

					}
					//JSONObject userGraphObj = getGrpahJsonObj(userFailDetailMap, "#69c7b3", true);	
					JSONObject userGraphObj = (JSONObject)allData.get("userGraphObj");
					rootJson.put("userGraphObj", userGraphObj);
					JSONObject serverGraphObj = (JSONObject)allData.get("targetHostGraphObj");			
					rootJson.put("serverGraphObj", serverGraphObj);
					
					JSONObject clientIpGraphObj = (JSONObject)allData.get("clientIpGraphObj");	
					rootJson.put("clientIpGraphObj", clientIpGraphObj);
					JSONObject timeGraphObj = (JSONObject)allData.get("timeGraphObj");	
					rootJson.put("timeGraphObj", timeGraphObj);
				}
				for(int j=0; j<failList.size(); j++)
				{
					LogonFailureBean bean = (LogonFailureBean)failList.get(j);					
					//Over All Grid Start
					failJsonArr = new JSONArray();
					String failReason = bean.getFailureReason();
					failJsonArr.add(bean.getAccountDomain());failJsonArr.add(bean.getAccountName());
					failJsonArr.add(bean.getTargetHost());failJsonArr.add(bean.getSourceNetworkAddress());
					failJsonArr.add(bean.getEventDate());failJsonArr.add(failReason);				
					failJsonArr.add(bean.getLogonProcess());failJsonArr.add(bean.getAuthenticationPackage());
					failJsonArr.add(bean.getCallerProcessName());
					allFailGridArr.add(failJsonArr);
				}
				userViewSubColumnArray.add("Domain");userViewSubColumnArray.add("Account Name");
				userViewSubColumnArray.add("Server");userViewSubColumnArray.add("Client IP");
				userViewSubColumnArray.add("Failure Date");userViewSubColumnArray.add("Failure Reason");
				userViewSubColumnArray.add("Logon Process");userViewSubColumnArray.add("Authentication <br>Package");
				userViewSubColumnArray.add("Process Name");
				userViewColumn.put("userViewSubColumn", userViewSubColumnArray);
				rootJson.put("gridTitle", "Logon Failure Details");
			}
			else if(reportType.equals("VMUnregistered"))
			{
				int eventSize = 0;
				JSONObject heading = new JSONObject();
				heading.put("server", "Server");
				heading.put("pool", "Unique Pool");
				heading.put("machine", "Unregister Machines");
				JSONArray headingArray = new JSONArray();
				headingArray.add(heading);
				//userViewColumn.put("userViewSubColumn", userViewSubColumnArray);	
				int allPoolCount = (Integer)allData.get("poolCount");
				int allMachineCount = (Integer)allData.get("machineCount");
				Map<String, List<EventLogBroken>> serverDetailMap = (Map)allData.get("gridDataMap");			
				JSONArray eventDataArray = new JSONArray();
				int idCount = 0;
				for(String server : serverDetailMap.keySet())
				{
					Map<String, Integer> poolMap = new HashMap<String, Integer>();
					Map<String, Integer> machineMap = new HashMap<String, Integer>();
					JSONObject eventDataObject = new JSONObject();
					List<EventLogBroken> eventBeanList = serverDetailMap.get(server);
					String eventDetailTable = "<div class='newTable' ><table width='98%' style='margin:10px 10px 10px 10px; ' id='data"+idCount+"'><thead><tr><th>POOL</th><th>DESKTOP ID</th><th>EVENT DATE</th><th>USER</th><th>SESSION TYPE</th><th>AGENT ERROR CODE</th><th>NODE</th><th>SOURCE</th></tr></thead><tbody>";
					idCount++;
					for(int i=0; i<eventBeanList.size(); i++)
					{
						EventLogBroken bean = (EventLogBroken)eventBeanList.get(i);
						String pool = bean.getPool();
						String machineId = bean.getMachineId();
						String agentErrCode = bean.getaAentErrorCode();
						if(agentErrCode.equals("-"))
							agentErrCode = "<center>"+agentErrCode+"</center>";
						int count = 0;
						if(poolMap.containsKey(pool))
						{
							count = poolMap.get(pool) + 1;						
						}
						else
						{
							count++;
						}
						poolMap.put(pool,count);
						count = 0;
						if(machineMap.containsKey(machineId))
						{
							count = machineMap.get(machineId) + 1;
						}
						else
						{
							count++;
						}
						machineMap.put(machineId, count);

						eventDetailTable += "<tr><td>"+pool+"</td><td>"+bean.getDesktopId()+"</td><td>"+bean.getEventDate()+"</td><td>"+bean.getUserDisplayName()+"</td><td>"+bean.getSessionType()+"</td><td>"+agentErrCode+"</td><td>"+bean.getNode()+"</td><td><div style='width: 100px; word-wrap: break-word; overflow-x:auto;'>"+bean.getSource()+"</div></td></tr>";
					}					
					eventDetailTable +="</tbody></table></div>";
					int poolCount =  poolMap.size();
					int machineCount = machineMap.size();
					eventDataObject.put("server", server);
					eventDataObject.put("pool", poolCount);
					eventDataObject.put("machine", machineCount);
					eventDataObject.put("detailsData", eventDetailTable);
					eventDataArray.add(eventDataObject);
				}

				rootJson.put("poolCount", allPoolCount);
				rootJson.put("machineCount", allMachineCount);
				rootJson.put("eventData", eventDataArray);
				rootJson.put("heading", heading);
			}
						
			rootJson.put("hideDesign", hideDesign);
			JSONObject timeGraphObj = (JSONObject)allData.get("otheInfo");	
			rootJson.put("OTHER_INFO", timeGraphObj);
						
			
			rootJson.put("allFailGridData", allFailGridArr);
			rootJson.put("userDetailCol", userViewColumn);

			// Grid With in Table End	
			
			String queryString =(String)ErUtils.prepareQueryString(request.getParameterMap());
			String Qstring="";
			if(queryString!=null)
			{
				StringTokenizer strtok = new StringTokenizer(queryString,"&");
				while(strtok.hasMoreTokens())
				{
					String param = strtok.nextToken();
					int ind = param.indexOf("=");
					String reqparam = param.substring(0,ind);
					String value= param.substring(ind+1);
					value= com.eg.EgURLEncoder.encode(value, "UTF-8");
					Qstring=Qstring+reqparam+"="+value+"&";
				}
			}
			ErHelperUtils erhelputils = null;
			if( servlet2!=null && !servlet2.equals(""))
				erhelputils = new ErHelperUtils(backreqMap,backQnumber,servlet2);
			else
				erhelputils = new ErHelperUtils(backreqMap,backQnumber);
			boolean enableBack =erhelputils.isBackButtonEnable();

			String backButtonEnable = request.getParameter("back");
			if(backButtonEnable != null && backButtonEnable.equalsIgnoreCase("True"))
			{
				status = (String)request.getParameter("status");
				bggroundStr = (String)request.getParameter("bggroundStr");
			}
			ArrayList listbackvar = new  ArrayList();
			if(request.getParameter("isSubmit")!=null)
			{
				listbackvar.add("ErLogonFailure.jsp");
				if(er_view != null && er_view.equalsIgnoreCase("submit"))
					listbackvar.add("status="+status+"&isSubmit=true&bggroundStr="+bggroundStr+"&"+Qstring);
				else
					listbackvar.add("status="+status+"&bggroundStr="+bggroundStr+"&"+Qstring);
				session.setAttribute("favSchBackDisplay","Yes");
			}
			else
			{
				listbackvar.add("ErLogonFailure.jsp");
				if(er_view != null && er_view.equalsIgnoreCase("submit"))
					listbackvar.add(Qstring+"&isSubmit=true");
				else
					listbackvar.add(Qstring);
				session.setAttribute("favSchBackDisplay","No");
			}
			if(request.getParameter("enableBack")==null)
			{
				session.setAttribute("reportLastAccessedURL","/final/reporter/ErLogonFailure.jsp?isSubmit=true&"+Qstring);
			}
			String backadded = erhelputils.getBackID();
			backreqMap = erhelputils.setBackQueryMap(backreqMap,backadded,listbackvar);
			System.out.println("backreqMap-->"+backreqMap);
			session.setAttribute("backQuery",backreqMap);
			if(backreqMap != null && backreqMap.size() >0 && "true".equalsIgnoreCase(request.getParameter("enableBack")))
			{
				rootJson.put("ID","backQnumber="+erhelputils.getBackID()+"&"+erhelputils.getQueryString());
			}
		}
		String reportTypeEncode = com.eg.EgURLEncoder.encode(reportType, "UTF-8");
		session.setAttribute("PDF_URL", mngrIProc+"/final/reporter/ErLogonFailurePrint.jsp");
		session.setAttribute("MAIL_URL",mngrIProc+"/final/reporter/ErLogonFailurePrint.jsp;jsessionid="+ session.getId()+"?reportType="+reportTypeEncode);
		
		HashMap paramval =new HashMap();
		paramval.put("filename","userlogonsummarycc");
		session.setAttribute("parameters", paramval);

		StringTokenizer st1;
		String Hourfrom = "";
		String Minfrom = "";
		String Hourto= "";
		String Minto= "";
		String fromTime= "";
		String toTime= "";
		String comFormat = null;
		String  pdfStartDate = s_st_time+" "+s_st_hr+":"+strmin;
		String  pdfEndDate   = s_en_time+" "+s_en_hr+":"+enmin;
		String dispDate = null;
		if(s_st_time!=null)
		{
			if(DateUtil.isDate(s_st_time,"MM/dd/yyyy"))
			{
				comFormat = "MM/dd/yyyy";
			}
			else
			{
				comFormat = currentDateFormat;
			}
			dispDate = 	DateUtil.changeDateFormat(s_st_time,comFormat,currentDateFormat);
			EgTimeZoneConverter usrStartDateTime = new EgTimeZoneConverter(dispDate+" "+s_en_hr+":"+enmin, this_user);
			pdfStartDate = usrStartDateTime.getDateTime();
		}
		if(s_en_time!=null)
		{
			if(DateUtil.isDate(s_en_time,"MM/dd/yyyy"))
			{
				comFormat = "MM/dd/yyyy";
			}
			else
			{
				comFormat = currentDateFormat;
			}
			dispDate = 	DateUtil.changeDateFormat(s_en_time,comFormat,currentDateFormat);
			EgTimeZoneConverter usrEndDateTime = new EgTimeZoneConverter(dispDate+" "+s_en_hr+":"+enmin,this_user);
			pdfEndDate = usrEndDateTime.getDateTime();
		}	
		String pdfTime = "From "+pdfStartDate+" hrs "+" "+" To "+pdfEndDate+" hrs";
		fromTime = reportInfo.getTimeFrame("Application_Crash_Fault_Report","FROM");
		toTime = reportInfo.getTimeFrame("Application_Crash_Fault_Report","TO");
		st1 = new StringTokenizer(fromTime,":");
		if(st1.hasMoreTokens())
		{
			Hourfrom = st1.nextToken();
			Minfrom = st1.nextToken();
		}
		st1=new StringTokenizer(toTime,":");
		if(st1.hasMoreTokens())
		{
			Hourto = st1.nextToken();
			Minto = st1.nextToken();
		}
		String hourFromUI= request.getParameter("hourFromUI");
		String minFromUI= request.getParameter("minFromUI");
		String hourToUI= request.getParameter("hourToUI");
		String minToUI= request.getParameter("minToUI");
		String exclweekUI= request.getParameter("exclweek");
		if(hourFromUI == null) hourFromUI = Hourfrom;
		if(minFromUI== null) minFromUI= Minfrom;
		if(hourToUI== null) hourToUI= Hourto;
		if(minToUI== null) minToUI= Minto;
		if(exclweekUI== null) 
			exclweekUI= "No";
		ErReportHelper helper = new ErReportHelper();

		if ("Yes".equalsIgnoreCase(exclweekUI))
		{
			exclweekUI = (helper.getExcludeWeekends("EXCLUDE_WEEKEND", "Days") == null) ? "Saturday,Sunday" : helper.getExcludeWeekends("EXCLUDE_WEEKEND", "Days");
		}
		else 
		{
			exclweekUI = "No";
		}
		JSONObject selectionDetails =  new JSONObject();
		//
		String comType = (String)request.getParameter("er_compType");
		
		selectionDetails.put(intlmap.getTextDescription("reporter.common.Report By"),analysisBy);
		if(comType!=null)
			selectionDetails.put(intlmap.getTextDescription("reporter.common.Component Type"),intlmap.getComponentTypeDescription(comType));
		selectionDetails.put(intlmap.getTextDescription("reporter.common.Time Period "),hourFromUI+":"+minFromUI+" <b>"+intlmap.getTextDescription("reporter.common.to")+" </b>"+hourToUI+":"+minToUI);
		selectionDetails.put((String)intlmap.getTextDescription("reporter.common.TimeLine"),pdfStartDate+" "+intlmap.getTextDescription("reporter.common.hrs")+" <b>  "+intlmap.getTextDescription("reporter.common.to")+" </b>"+pdfEndDate+" "+intlmap.getTextDescription("reporter.common.hrs"));
		selectionDetails.put(intlmap.getTextDescription("reporter.common.Exclude weekends"),exclweekUI);

		rootJson.put("selectionDetails",selectionDetails);
		out.println(rootJson.toString());
	}
	catch(Exception e)
	{
		e.printStackTrace();
	}
%>
<%!
public synchronized JSONArray getJSONComboFromList(List list,String infoVal,EgMappingInfo intlmap)
{
	JSONArray arr=new JSONArray();
	JSONObject obj=null;
	if(list !=null && list.size()>0)
	{
		for (int i=0;i<list.size();i++)
		{
			String text=(String)list.get(i);
			obj=new JSONObject();
			if(text.equals("--Default--"))
				obj.put("displayField",intlmap.getTextDescription("reporter.common."+text));
			else
			obj.put("displayField",text);
			obj.put("valueField",text);
			arr.add(obj);
		}
	}
	else
	{
		obj=new JSONObject();
		obj.put("displayField",intlmap.getTextDescription("reporter.common.Not Applicable"));
		obj.put("valueField","-1");
		arr.add(obj);
	}
	return arr;
}


private JSONObject getGrpahJsonObj(Map<String, ArrayList<LogonFailureBean>> map, String color, boolean isXaxis)
{
		Map<String, Integer> graphMap = new HashMap();
		int chartHeight = 0;
		String chartType ="";
		for(String key : map.keySet())
		{				
			graphMap.put(key, ((List)map.get(key)).size());
		}
		List<Map.Entry<String, Integer>> list = new LinkedList<Map.Entry<String, Integer>>(graphMap.entrySet());
		Collections.sort(list, new Comparator<Map.Entry<String, Integer>>() {
			public int compare(Map.Entry<String, Integer> o1, Map.Entry<String, Integer> o2) {
				return (o1.getValue()).compareTo(o2.getValue());
			}
		});
		Map<String, Integer> sortedMap = new LinkedHashMap<String, Integer>();
		/*for (Map.Entry<String, Integer> entry : list) {
			sortedMap.put(entry.getKey(), entry.getValue());
		}*/
		int size = list.size() - 1;
		if(size>10)
		{	int loopCount = size-10;
			for(int i=size; i>loopCount; i--)
			{
				Map.Entry<String, Integer> entry = list.get(i);
				sortedMap.put(entry.getKey(), entry.getValue());
			}
		}
		else 
		{
			int j = 0;
			if(size==10)
				j = 1;
			for(int i=size; i>=j; i--)
			{
				Map.Entry<String, Integer> entry = list.get(i);
				sortedMap.put(entry.getKey(), entry.getValue());
			}
		}		


		JSONArray userArray = new JSONArray();
		JSONArray tmpArray = new JSONArray();
		JSONObject tmpObj =  null;
		for(String key : sortedMap.keySet())
		{
			userArray.add(key);
			tmpObj = new JSONObject();
			tmpObj.put("y", sortedMap.get(key));
			tmpArray.add(tmpObj);
		}
		tmpObj = new JSONObject();
		tmpObj.put("data", tmpArray);
		tmpObj.put("color", color);
		tmpObj.put("name", "Number of Failure");
		tmpArray = new JSONArray();
		tmpArray.add(tmpObj);
		
		JSONObject graphJsonObj = new JSONObject();
		graphJsonObj.put("DataSet", tmpArray);
		graphJsonObj.put("LegendPosition", "right");
		graphJsonObj.put("legend", "true");
		graphJsonObj.put("xAxisLabelText", "");
		graphJsonObj.put("inside", true);
		graphJsonObj.put("title","");
		if(isXaxis)
		{
			chartHeight = 150;
			chartType = "bar";
		}
		else
		{
			graphJsonObj.put("yValue",50);
			chartHeight = 300;
			chartType = "column";
		}
		graphJsonObj.put("chartHeight",chartHeight);
		graphJsonObj.put("chartType",chartType);
		graphJsonObj.put("yAxisLabel","");
		graphJsonObj.put("chartWidth",600);
		graphJsonObj.put("allowMarginTop","yes");
		graphJsonObj.put("marginTop",30);
		graphJsonObj.put("isDataLabelEnabled",true);
		graphJsonObj.put("chartSubType","stacked");
		graphJsonObj.put("xAxisLabel", userArray);			
		return graphJsonObj;
}

%>