<!DOCTYPE html>

<%
/*****************************************************************************
*	File name		: ErCrashFaultPrint.jsp
*	Purpose			: This page Handles Print Application Crash Fault Report
*	Version			: Reporter 6.2
********************************************************************************/
%>
<%@ include file="ErTracker.jsp"%>
<%@ page import="egurkha.reporter.*"%>
<%@ page import="java.util.*"%>
<%@ page import = "net.sf.json.*" %>
<%@ page import="com.eg.*"%>
<%@ page import="com.eg.EgDbInfo"%>
<%@ page import="com.eg.IniFile"%>
<%@ page import="com.eg.EgDateInfo"%>
<%@ page import="java.text.Format.*"%>
<%@ page import="java.text.DateFormat.*"%>
<%@ page import="java.text.*"%>
<%@ page import="com.eg.EgReportInfo"%>
<%@ page import="com.eg.EgMappingInfo"%>
<%@ page import="com.eg.EgTablesInfo"%>
<%@ page import="com.egurkha.util.DateUtil"%>
<%@ page import="com.egurkha.util.*"%>
<%@ page import="com.egurkha.util.DateTimeTokenizer"%>
<%@ page import="com.eg.EgURLDecoder"%>
<%@ page import="com.eg.EgDbInfo"%>
<%@ page import="com.eg.EgConfigInfo"%>
<%@ page import="java.io.*"%>
<%@ page import="com.egurkha.util.StringUtils"%>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>

<%
try
{
	String pdfPrint = request.getParameter("pdfPrint");
	EgReportInfo reportInfo = new EgReportInfo("manager");
	String strManagerURL = request.getScheme()+"://"+request.getServerName()+":"+ request.getServerPort();
	String controllerURL = strManagerURL+"/final/servlet/com.eg.ErCrashFaultReportC;jsessionid=" + session.getId() + "?";
	EgMappingInfo intlmp = new EgMappingInfo(thisuser.getLanguage());
	Map selectParams =  (Map)session.getAttribute("selectionDetail");
	String analysisBy = (String)selectParams.get("analysisBy");
	String er_compType[] = (String[])selectParams.get("er_compType");
	String er_Component[] = (String[])selectParams.get("er_Component");
	String startDate = (String)selectParams.get("startdate");
	String endDate = (String)selectParams.get("enddate");
	String starthr = (String)selectParams.get("starthr");
	String endhr = (String)selectParams.get("endhr");
	String startmin = (String)selectParams.get("startmin");
	String endmin = (String)selectParams.get("endmin");
	String weekends = (String)selectParams.get("weekends");
	String timeFrom = (String)selectParams.get("timeFrom");
	String timeTo   = (String)selectParams.get("toTime");
	String uid = request.getParameter("uid");
	String currentDateFormat = strUserDateFormat;
	String Days="Saturday,Sunday";
	if("00:00:00".equals(timeFrom))
	{
		timeFrom  = timeFrom.substring(0,timeFrom.lastIndexOf(":"));
		timeTo    = timeTo.substring(0,timeTo.lastIndexOf(":"));
	}
	String dispStart = startDate + " " + starthr  + ":" + startmin  ;
	String dispEnd   = endDate + " " + endhr + ":" + endmin ;
	Map allData = (Map)session.getAttribute("allData");
	String titleToDisplay=reportInfo.getValue("Application_Crash_Fault_Report","reportTitle");
	if(titleToDisplay == "")
		titleToDisplay="Application Crash/Fault Report";
	String fileName=titleToDisplay;
	HashMap paramVal =new HashMap();
	paramVal.put("fileName",fileName);
	session.setAttribute("parameters", paramVal);
	%>
	<html>
		<head>	
		<%
			if(pdfPrint !=null && pdfPrint.equalsIgnoreCase("yes"))
			{
				%>

				<title>&nbsp; <egui:intnl text="reporter.common.Reporter" />
				&nbsp; &nbsp;-PDR- &nbsp;</title>
				<%
			}
			else
			{
				%>
					<title>eG Reporter</title>
				<%
			}
	%>
	<meta http-equiv="refresh">
	<link rel="stylesheet" type="text/css" href="../../final/styles/eGLightThemeIcons.css" />
	<link rel="stylesheet" type="text/css" href="../../final/reporter/styles/printpagestyle.css" />
	<style>
		@media print {body {-webkit-print-color-adjust: exact;}}
	</style>
	</head>
	<body marginwidth="20" marginheight="20" bgcolor="#FFFFFF">
	<%
	String strLogCls = "printHeaderBoxLogo";
	if(pdfPrint !=null && pdfPrint.equalsIgnoreCase("yes"))
	{
		strLogCls = "printHeaderBoxLogo";
	}
	else
		strLogCls = "printPdfHeaderBoxLogo";

	if(pdfPrint !=null && pdfPrint.equalsIgnoreCase("yes"))
	{
	%>
		<div class="<%=strLogCls%>" style="padding-top:10px"><img src="<%=imageName%>" border="0" /></div>
	<%
	}
	else
	{
	%>
		<div class="<%=strLogCls%>"><img src="<%=imageName%>" border="0" /></div>
	<%
	}
	%>
	<div class="printHeaderBox">
	<%
	if (!StringUtils.isNull(titleToDisplay))
	{
		%>
		<div class="printHeaderBoxTitle"><%= titleToDisplay %></div>
		<%
	}
	else
	{
		%>
		<div class="printHeaderBoxTitle"><egui:intnl text="reporter.common.Application Crash/Fault Report) " /></div>
		<%
	}
	
	if(pdfPrint !=null && pdfPrint.equalsIgnoreCase("yes"))
	{
	%>
		<div class="printHeaderBoxPrintIcon"><img class="iconPrinter mouse"  id="pri ntbt" src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" border="0" onClick="javascript:window.print()" alt='<egui:intnl text="reporter.common.PRINT"/>' title='<egui:intnl text="reporter.common.PRINT"/>'/></div>
	<%
	}
	%>
	</div>
	<div class="printOuterBoxNoBorder"> 
	<%
	if(analysisBy != null)
	{
		%>
		<div class="printSelectionFields"><egui:intnl text="reporter.common.Analyzed by"/>:<span class="bold"><%=analysisBy%></span></div>
		<%
	}
	if(weekends != null)
	{
		%>
		<div class="printSelectionFields"><egui:intnl text="reporter.common.Exclude Weekends"/>:<span class="bold"><%=weekends%></span></div>
		<%
	}
	if(dispStart != null)
	{
		%>
		<div class="printSelectionFields"><egui:intnl text="reporter.common.Start Date" />: <span class="bold"><%=dispStart%></span></div>
		<%
	}
	if(dispEnd != null)
	{
		%>
		<div class="printSelectionFields"><egui:intnl text="reporter.common.End Date" />: <span class="bold"><%=dispEnd%></span></div>
		<%
	}
	if(timeFrom != null)
	{
		%>
		<div class="printSelectionFields"><egui:intnl text="reporter.common.Time Period"/>: <span class="bold"><%=timeFrom%>&nbsp;   <egui:intnl text="reporter.common.to "/>&nbsp; <%=timeTo%></span></div>
		<%
	}
	%>	
	</div>
	<%
	String urlValue=null;
	boolean isData=false;
	if(allData != null && allData.get("isData") != null)
	{
		isData=(Boolean)allData.get("isData");
	}
	if(isData)
	{
		String uniqueApplicationCount=(String)allData.get("uniqueApplicationCount");
		String uniqueServerCount=(String)allData.get("uniqueServerCount");
		String totalFailCount=(String)allData.get("totalFailCount");
		JSONArray donutChartAppCrshHangDataSet=(JSONArray)allData.get("donutChartAppCrshHangDataSet");
		%>
		<div class="clearDiv"></div>
		<div class="printOuterBox" style="margin-top:10px">
			<div class="printOuterBoxHeader">Overview</div>
			<table valign="middle" width="100%" cellpadding="0px" cellspacing="0px" >
				<tbody>
					<tr>
						<td align="center" width="22%">
							<table cellpadding="0px" cellspacing="0px">
								<tbody>
									<tr> 
										<td align="right"><div class="iconAppTotalFailures"></div></td>
										<td style="padding:5px 5px 5px 10px"><span class="newFont_bold28"><%=totalFailCount%></span></td>
									</tr>
									<tr>
										<!--<td>&nbsp;</td>-->
										<td align="center" style="padding:7px" colspan="2"><span class="newFont_normal13">Total Failures</span></td>
									</tr>
								</tbody>
							</table>
						</td>

						<td align="center" width="22%">
							<table cellpadding="0px" cellspacing="0px">
								<tbody>
									<tr> 
										<td align="right"><div class="iconApplications"></div></td>
										<td style="padding:5px 5px 5px 10px"><span class="newFont_bold28"><%=uniqueApplicationCount%></span></td>
									</tr>
									<tr>
										<!--<td>&nbsp;</td>-->
										<td align="center" style="padding:7px" colspan="2"><span class="newFont_normal13">Applications with Failures</span></td>
									</tr>
								</tbody>
							</table>
						</td>

						<td align="center" width="22%">
							<table cellpadding="0px" cellspacing="0px">
								<tbody>
									<tr> 
										<td align="right"><div class="iconServerGray"></div></td>
										<td style="padding:5px 5px 5px 10px"><span class="newFont_bold28"><%=uniqueServerCount%></span></td>
									</tr>
									<tr>
										<!--<td>&nbsp;</td>-->
										<td align="center" style="padding:7px" colspan="2"><span class="newFont_normal13">Servers with Failures</span></td>
									</tr>
								</tbody>
							</table>
						</td>
						<td>
							<div>
								<table align="center">
									<tbody>
										<tr>
											<td>
												<div align="center" style="position:relative; width:100px; height:100px">
													<img width="100%" height="100%" src="<%=controllerURL+"&er_view=print&width=110&height=110&chartFor=donut"%>">
												</div>
											</td>
											<td align="left">
												<table align="center" cellpadding="0" cellspacing="0" border="0">
													<tbody>
														<%
														for(int d=0;d<donutChartAppCrshHangDataSet.size();d++)
														{
															JSONObject eachData=(JSONObject)donutChartAppCrshHangDataSet.get(d);
															String color=(String)eachData.get("color");
															String name=(String)eachData.get("name");
															if(name != null && name.equalsIgnoreCase("Recent application crashes"))
															{
																name="Number of Crashes";
															}
															else if(name != null && name.equalsIgnoreCase("Recent application hangs"))
															{
																name="Number of Hangs";
															}
															%>
															<tr>
																<td>
																	<svg height="10" width="10">
																	  <circle cx="5" cy="5" r="4" fill="<%=color%>" />
																	</svg>
																</td>
																<td nowrap="" align="left" style="padding:5px 20px 5px 5px;float:left" class="newFont_normal11"><%=name%></td>
																<td nowrap="" align="left" style="" class="newFont_normal11"><%=eachData.get("y")%></td>
															</tr>
															<%
														}
														%>														
													</tbody>
												</table>
											</td>
										</tr>
									</tbody>
								</table>
							</div>
						</td>
					</tr>
				</tbody>
			</table>
		</div>


		<div class="clearDiv"></div>
		<table width="100%">
			<tr>
				<td width="50%" style="padding:10px 10px 10px 0px">
					<div class="printOuterBox">
						<div class="printOuterBoxHeader">Top 10 Applications With Most Number Of Failures</div>
						<div style="width:100%;overflow:auto;padding:10px">
							<img src="<%=controllerURL+"&er_view=print&width=400&height=300&chartFor=topNApp"%>"/>
						</div>
					</div>
				</td>
				<td width="50%" style="padding:0px 0px 0px 0px">
					<div class="printOuterBox">
						<div class="printOuterBoxHeader">Top 10 Servers With Most Number Of Failures</div>
						<div style="width:100%;overflow:auto;padding:10px">
							<img src="<%=controllerURL+"&er_view=print&width=400&height=300&chartFor=topNServer"%>"/>
						</div>
					</div>
				</td>
			</tr>
		</table>
		<div class="clearDiv"></div>
		<table width="100%">
			<tr>
				<td width="100%" style="padding:0px 0px 10px 0px">
					<div class="printOuterBox">
						<div class="printOuterBoxHeader">Analysis of Application Crashes / Hangs</div>
						<div style="width:100%;overflow:auto;padding:10px">
							<img src="<%=controllerURL+"&er_view=print&width=900&height=300&chartFor=crashTime"%>"/>
						</div>
					</div>
				</td>
			</tr>
		</table>
		<div class="clearDiv"></div>
			<div class="printOuterBox">
					<div class="printOuterBoxHeader" >Details of Application Failures</div>
					<div class="newTable">
					<%
						out.println("<table  align='center'  width='100%' cellpadding='0' cellspacing='0'>");
						out.println("<colgroup><col width='70%'><col width='10%'><col width='10%'><col width='10%'></colgroup>");
						out.println("<thead>");
						out.println("<tr>");
						out.println("<th align='left'>Application</th>");
						out.println("<th align='left'>Number of Crashes</th>");
						out.println("<th align='left'>Number of Hangs</th>");
						out.println("<th align='left'>Total</th>");
						out.println("</tr>");
						out.println("</thead>");
						out.println("<tbody>");
						List appDetailsList=(List)allData.get("appDetailsList");
						StringBuffer detailData=null;
						for(int i=0;i<appDetailsList.size();i++)
						{
							detailData=new StringBuffer();
							out.println("<tr>");
							Map.Entry appDetail=(Map.Entry)appDetailsList.get(i);
							String appName=(String)appDetail.getKey();
							List appDetailList=(List)appDetail.getValue();
							out.println("<td>"+appName+"</td>");
						
							detailData.append("<tr>");
							detailData.append("<td align='right' colspan='4' style='padding:10px 10px 10px 10px'>");
							detailData.append("<div class='newTable'>");
							detailData.append("<table  align='center'  width='100%' cellpadding='0' cellspacing='0'>");//
							detailData.append("<colgroup><col width='20%'><col width='10%'><col width='5%'><col width='10%'><col width='10%'><col width='10%'><col width='35%'></colgroup>");
							detailData.append("<thead><tr>");
							List subHeader=Arrays.asList("appName,component,appVersion,measure,faultTime,modName,appPath".split(","));
							for(int s=0;s<subHeader.size();s++)
							{
								String key=(String)subHeader.get(s);
								if(key.equalsIgnoreCase("appName"))
									continue;
								if(key.equalsIgnoreCase("measure"))
									key="Problem";
								else if(key.equalsIgnoreCase("faultTime"))
									key="Problem Time";
								else if(key.equalsIgnoreCase("appPath"))
									key="Path";
								else if(key.equalsIgnoreCase("appVersion"))
									key="Version";
								else if(key.equalsIgnoreCase("modName"))
									key="Module Name";
						
								detailData.append("<th align='left'>"+key+"</th>");
							}
							detailData.append("</tr></thead>");
							detailData.append("<tbody>");
							int crashCount=0;
							int hangCount=0;
							for(int j=0;j<appDetailList.size();j++)
							{
								Map appObj=(Map)appDetailList.get(j);
								detailData.append("<tr>");							   
								for(int s=0;s<subHeader.size();s++)
								{								
									String eachInfo=(String)subHeader.get(s);
									if(eachInfo.equalsIgnoreCase("appName"))
										continue;
									String value=(String)appObj.get(eachInfo);
									if(eachInfo.equalsIgnoreCase("measure"))
									{
										if(value.equalsIgnoreCase("Crashed_appevt_count"))
										{
											value="Crash";
											crashCount++;
										}
										else if(value.equalsIgnoreCase("Hang_count"))
										{
											value="Hang";
											hangCount++;
										}
									}
									detailData.append("<td style='word-break:break-all; word-wrap:break-word;'>"+value+"</td>");
								}
								detailData.append("</tr>");
							}
							detailData.append("</tbody>");
							detailData.append("</table>");
							detailData.append("</div>");
							detailData.append("</td>");
							detailData.append("</tr>");
							out.println("<td>"+crashCount+"</td>");
							out.println("<td>"+hangCount+"</td>");
							out.println("<td>"+appDetailList.size()+"</td>");
							out.println("</tr>");
							out.println(detailData);
							
						}					
						out.println("</tbody>");
					%>
					</div>
			</div>
		<%
	}
	else
	{
		%>
		<div class="printOuterBox">
			<div class="printOuterBoxHeader">Overview</div>
			<div style="width:100%;overflow:auto;padding:10px">
			<%
				out.println("<table width='100%' height='100%'><tbody><tr><td align='center' valign='middle' class='font_normal12'><div class='iconExclamation'></div>No failures occurred</td></tr></tbody></table>");
			%>
			</div>
		</div>
		<%
	}
}
catch(Exception e)
{
	e.printStackTrace();
}
%>