<%
/*******************************************************************************
*	File name		:	ErCapacitySummaryReport.jsp
*	Purpose			:	Displays the Citrix capacity summary report
*	Version			:	6.2
*	Author			:	S.Ezhilarasi
*	Creation Date	:	26/jul/2017 
*******************************************************************************/
%>
<%@ include file = "ErTracker.jsp" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ taglib prefix = "egui" uri = "../WEB-INF/eg-taglib.tld" %>

<html>
	<head>
		<title><egui:intnl text="reporter.common.eG Reporter"/> </title>
		<egui:skin ui="reporter"/>
		<meta charset="utf-8">
		<link rel="stylesheet" href="/final/styles/jscrollpane/jquery.jscrollpane.css"/>
		<script src="/final/jquery/jquery.js"></script>
		<script src="/final/styles/jscrollpane/jquery.jscrollpane.js" ></script>
		<script src="/final/styles/jscrollpane/jquery.mousewheel.js" ></script>
		<script src="/final/styles/jscrollpane/mwheelIntent.js" ></script>
		<script src="/final/reporter/scripts/eg_DateUtil.js"></script>
		<script src="/final/reporter/scripts/er_validator.js"></script>
		<script src="../scripts/<%=script_src%>"></script>
		<script type="text/javascript" src="/final/Highcharts/js/highstock.js"></script>
		<script type="text/javascript" src="/final/Highcharts/js/modules/exporting.js"></script>
		<script src="../reporter/scripts/ErHighChart.js"></script>
		<script src="../reporter/scripts/ErHighChartBarBuilder.js"></script>
		<script src="../reporter/scripts/ErHighChartColumns.js"></script>
		<style>
		.gridSkin .x-grid-row .x-grid-cell
		{
			vertical-align:middle;
		}
		</style>

		<%
			String currentDateFormat = strUserDateFormat;
			String isSubmit = (request.getParameter("isSubmit")!=null) ? request.getParameter("isSubmit") : "";
			String favoriteID =  request.getParameter("FavoriteId"); 
			String scheduleID =  request.getParameter("schedule_id"); 
			String isModifyFavorite =  request.getParameter("fromFavoriteModify");
			String isModifySchedule =  request.getParameter("fromScheduleModify");
			if(scheduleID!=null && !scheduleID.equalsIgnoreCase("undefined"))
			{
				isModifyFavorite = "No";
			}
			String erFavorite =  request.getParameter("er_favorite");
			String queryStr = (String)ErUtils.prepareQueryString(request.getParameterMap());	
			String compTypeMultiSelect = iniFile.getValue("Citrix_Capacity_Planning_Summary_Report","compTypeMultiSelect");
			boolean enableMultiCompType=false;
			if(compTypeMultiSelect != "" && compTypeMultiSelect != null && compTypeMultiSelect.equalsIgnoreCase("yes"))
			{
				enableMultiCompType=true;
			}
			String isEnableBack =  ("true".equalsIgnoreCase(request.getParameter("enableBack")))? "true" : "false";
			ErUtils erUtils = new ErUtils();
		%>
		<script>
			var mgrDateFormat = getExtjsDateFormat('<%=currentDateFormat%>');
			var appConstants = new Object();
			appConstants.forGrdReportConfirmMsg = 'Foreground report generation will take some time Do you want to proceed?';
			appConstants.erUtils = null;
			appConstants.defaultLoadData = null;
			appConstants.LoadingMask = null;
			appConstants.appController = null;
			appConstants.appObj = null;
			appConstants.favoriteID ='<%=favoriteID%>';
			appConstants.scheduleID ='<%=scheduleID%>';
			appConstants.isModifyFavorite = '<%=isModifyFavorite%>';
			appConstants.isModifySchedule = '<%=isModifySchedule%>';
			appConstants.erFavorite = '<%=erFavorite%>';
			appConstants.isSubmit = '<%=isSubmit%>'
			appConstants.isEnableBack = true;
			appConstants.isShowSubmitBtn = true;
			appConstants.enableMultiCompType = <%=enableMultiCompType%>;
			appConstants.queryStr = '<%=queryStr.replace("\\","\\\\")%>';
			if((appConstants.isModifyFavorite.toUpperCase() == 'YES') || (appConstants.isModifySchedule.toUpperCase() == 'YES'))
			{
				appConstants.isShowSubmitBtn = false;
			}
			if('true'=='<%=isEnableBack.toLowerCase()%>')
			{
				appConstants.isEnableBack = false;
			}
			function reportForHighChart(id,detailData)
			{
				var chartData = {};
				chartData = jQuery.extend(true, {}, getHighChartsBarInstance(id,"",""), chartData);
				chartData.setData(detailData,'<%=currentDateFormat%>','');
				chartData.drawChart();		
			}
		</script>
		<egui:loadApp baseDir="/final/reporter/scripts" appName="CitrixCapacitySummaryApp" appFile="app.js"/>
	<script>
	Ext.onReady(function(){
		Ext.Ajax.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};
		Ext.data.Connection.prototype.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};
		Ext.data.ScriptTagProxy.prototype.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};
	});
	</script>
	</head>
</html>