<%
/**
 * ========================================================================================================
 * Prepare User Billing Report - Print Data
 *
 * @File name      : ErBillingPrintReport.jsp
 * @Version        : eG V5.0.x
 * @Author         : Sakthivel.p
 * @Creation Date  : Feb 24 2009
 * @Since          : JDK1.3.1
 * @Last Modified  : Jun 17 2009 - Monthl Billing Report
 *
 * ========================================================================================================
 */
%>

<%@ include file = "ErTracker.jsp" %>
<%@ page import = "com.eg.EgDbInfo" %>
<%@ page import = "com.eg.EgReportInfo" %>
<%@ page import = "com.eg.EgInstallInfo" %>
<%@ page import = "com.eg.IniFile" %>
<%@ page import = "java.util.*" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld"%>

<%
try
{
	EgDbInfo dbInfo = new EgDbInfo("manager");
	EgReportInfo reportInfo = new EgReportInfo("manager");
	String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";

	String er_timeline    = request.getParameter("er_timeline");
	String dateFormat     = request.getParameter("er_month");
	String startDate      = request.getParameter("startdate");
	String endDate        = request.getParameter("enddate");
	String excludeweekend = request.getParameter("er_excwe");
	String pdfPrint = request.getParameter("ispdf");

	Hashtable BillingAppDataMap = (Hashtable) session.getAttribute("BillingReportAppData");
	Hashtable BillingFarmDataMap = (Hashtable) session.getAttribute("BillingReportFarmData");
	Hashtable usersSortMap = (Hashtable) session.getAttribute("sortByUserType");

	/** WyseTest_ex Test in Enabled for Billing Report Yes or No */
	IniFile serviceIniFile = new IniFile( s_iniFile_dir + "eg_services.ini");
	String wyseTestEnabled = serviceIniFile.getValue("MISC_ARGS","WyseTestForBilling");

	String endHr = " 00:00:00";
	if(dateFormat!=null && !dateFormat.equals("Any")) {
		endHr = " 23:59:59";
	}
%>

<!DOCTYPE HTML>
<meta name="Author" content="">
<meta charset="UTF-8">
<%
	if(pdfPrint !=null && pdfPrint.equalsIgnoreCase("yes"))
	{
%>
<title> <egui:intnl text="reporter.common.eG Billing Reporter"/></title>
<%
	}
%>
<HEAD>
<!-- <link rel='stylesheet' href="../reporter/eg_styles/repstyle_purple.css"> -->
<egui:skin ui="reporter"/>
<script language="JavaScript1.2" src="../scripts/<%=script_src%>"></script>

<link rel="stylesheet" type="text/css" href="/final/reporter/styles/printpagestyle.css" />
<link rel="stylesheet" href="../styles/eGLightThemeIcons.css" />
</HEAD>
<BODY leftmargin="0" topmargin="0" marginwidth="0" marginheight="0" bgcolor="#FFFFFF">
<br>
<TABLE align="center" cellspacing="0" cellpadding="0" border="0" width="95%">
	<tr>
		<td align="center" valign="top">
	<%
	if(pdfPrint !=null && pdfPrint.equalsIgnoreCase("yes"))
	{
	%>
			<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" class="borderLine">
				<tr>
					<th class="header" id="cellborder1" width="100%" align="left" height="22">&nbsp;&nbsp;&nbsp;<egui:intnl text="reporter.thin.USER BILLING REPORT"/></th>
					<th width="40" height="22" valign="top" id="traycorner">
						<img src="../reporter/images/spacer.gif" border="0" width="38" height="22">
					</th>
					<td height="22" id="trayborder" class="white_bg">
						<table border="0" width="100%" cellpadding="0" cellspacing="0">
							<tr>
								<td style="border-bottom:1px;padding-bottom:5px;" height="22" class="cellbgdark" valign="bottom" > <img class="iconPrinter mouse" src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw=="  border="0" alt="PRINT" align=right onClick="window.print();">  </td>
							</tr>
						</table>
					</td>
				</tr>
			</table>
	<%

	}
	else
	{
	%>
<%
		if(pdfPrint ==null || !pdfPrint.equalsIgnoreCase("yes"))
	{
%>
<table cellpadding="0" cellspacing="2" border="0" width="80%" align="center">
	<tr>
		<td class="cellbgwhite"><img src="<%=imageName%>" border="0" /></td>
	</tr>
</table>
<%
	}
%>
	<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0">
					<tr>
						<th class="header" id="cellborder1" width="100%" align="left" height="22">&nbsp;&nbsp;<egui:intnl text="reporter.thin.USER BILLING REPORT"/></th>
						<th width="40" height="22" valign="top" id="traycorner"></th>
						<td height="22" id="trayborder" class="white_bg">
							<table border="0" width="100%" cellpadding="0" cellspacing="0">
								<tr>
									<td></td>
								</tr>
							</table>
						</td>
					</tr>
				</table>
	<%
		}
		%>
		</td>
	</tr>
	<tr>
		<td align="center" id="cellbglight" class="cellborder" valign="top" height="100%">
			<table cellspacing="0" cellpadding="0" width="98%" border="0" height="100%">
				<tr>
					<td align="center">
						<br>
						<table id="tableborder" align="center" width="95%" cellspacing="0" cellpadding="4" border="0" style="border-color:#d2d2d2;border-style:solid;border-width:0px 0px 1px 0px;font-size:13px">
							<tr>
				<td class="cellbg" width="100%" nowrap align ="center"> &nbsp; &nbsp;&nbsp;<b><span class="subheader"><egui:intnl text="reporter.common.Start Date"/></span></b>&nbsp;:&nbsp;<span class="subheader1"> <%=startDate+" 00:00:00"%>&nbsp; &nbsp;&nbsp;</span><b><span class="subheader"><egui:intnl text="reporter.common.End Date"/></span></b>&nbsp;:&nbsp;<span class="subheader1"> <%=endDate+endHr%></span> </td>
							</tr>
						</table>

<%
	if(excludeweekend!=null && excludeweekend.equals("Yes"))
	{
		String Days = reportInfo.getExcludeWeekend("CITRIX_USER_REPORT");
%>
						<br>
						<table id="tableborder" align="center" width="95%" cellspacing="0" cellpadding="4" border="0">
							<tr>
								<td class="cellbg" ID="er_submit" width="100%" nowrap align ="center"> &nbsp; &nbsp;&nbsp;<egui:intnl text="reporter.common.Exclude Weekend"/>&nbsp;:&nbsp;<%=Days%>
							</tr>
						</table>
						<br>
<%
	}
%>
						<table border="0" cellspacing="0" cellpadding="0">
							<tr>
								<td id="blankspace" height="10">&nbsp;</td>
							</tr>
						</table>
<%
	if(BillingAppDataMap!=null)
	{
		boolean isWyseEnable = false;
		String tbwidth = "90%";
		String titlewidth = "68%";
		StringTokenizer tknVal = null;

		if(wyseTestEnabled!=null && !wyseTestEnabled.equals("") && wyseTestEnabled.equalsIgnoreCase("TRUE"))
		{
			isWyseEnable = true;
			tbwidth = "97%";
			titlewidth = "92%";
		}

		if(BillingAppDataMap.size() > 0 && !BillingAppDataMap.isEmpty())
		{
			Iterator itmap = (new TreeMap(BillingAppDataMap)).keySet().iterator();
			while(itmap.hasNext())
			{
				String s_compType = (String)itmap.next();
%>
						<TABLE align="center" width="<%=tbwidth%>" cellspacing="0" cellpadding="4"  id="tableborder">
							<tr>
								<th class="cellbgdark" width="<%=titlewidth%>" NOWRAP align="center" colspan="10" style="font-size:13px;background:#d2d2d2;border:#d2d2d2 1px solid;border-width:1px 1px 0px 1px">
									<table align="center" width="95%" cellspacing="0" cellpadding="4" border="0" >
										<tr>
											<td class="whitecontent" width="100%" NOWRAP align="center" colspan="20">
											<b><egui:intnl text="reporter.billing.Billing Report for"/>&nbsp; <egui:intnl type="<%=s_compType%>"/></b></td>
											
										</tr>
									</table>
								</th>
							</tr>
							<tr >
								<td   class="tdborder" id="er_submit" width="5%" wrap align="center"><b><egui:intnl text="reporter.billing.Serial No"/></b></td>
								<td   class="tdborder" id="er_submit" width="11%" wrap align="center"><b><egui:intnl text="reporter.billing.User"/></b></td>
								<td   class="tdborder" id="er_submit" width="8%" wrap align="center"><b><egui:intnl text="reporter.billing.Full Time"/></b></td>
								<td   class="tdborder" id="er_submit" width="35%" wrap colspan="3" border="5" align="center"><b><egui:intnl text="reporter.billing.Signature App Usage"/></b></td>
								<td   class="tdborder" id="er_submit" width="30%" wrap align="center" border = ""><b><egui:intnl text="reporter.billing.Total Connection Time"/></b></td>
<%
				if(isWyseEnable)
				{
%>
								<td   class="tdborder" id="er_submit" width="11%" wrap align="center"><b><egui:intnl text="reporter.billing.Wyse Connection"/></b></td>
								<td   class="tdborder" id="er_submit" width="11%" wrap align="center"><b><egui:intnl text="reporter.billing.Non Wyse Connection"/></b></td>
								<td   class="tdborder" id="er_submit" width="20%" wrap align="center"><b><egui:intnl text="reporter.billing.Primary Connection Type"/></b></td>
<%
				}
%>
							</tr>
							<tr align="center">
								<td   class="tdborder" id="er_submit" wrap align="center"></td>
								<td   class="tdborder" id="er_submit" wrap align="center"></td>
								<td   class="tdborder" id="er_submit" wrap align="center"></td>
								<td   class="tdborder" id="er_submit" wrap align="center" width="14%"><b><egui:intnl text="reporter.billing.Application Name"/></b></td>
								<td   class="tdborder" id="er_submit" wrap align="center" width="10%"><b><egui:intnl text="reporter.billing.Avg Hrs/Day"/></b></td>
								<td   class="tdborder" id="er_submit" wrap align="center" width="8%"><b><egui:intnl text="reporter.billing.Total Hrs"/></b></td>
								<td   class="tdborder" id="er_submit" wrap align="center"><b>(<egui:intnl text="reporter.common.Hrs"/>)</b></td>
<%
				if(isWyseEnable)
				{
%>
								<td   class="tdborder" id="er_submit" wrap align="center"><b>(%)</b></td>
								<td   class="tdborder" id="er_submit" wrap align="center"><b>(%)</b></td>
								<td   class="tdborder" id="er_submit" wrap align="center"></td>
<%
				}
%>
							</tr>
<%
				int sn=1;
				TreeMap billingValues =(TreeMap)BillingAppDataMap.get(s_compType);
				List usersMap = (List) usersSortMap.get(s_compType);
				for(int y=0; y < usersMap.size(); y++)
				{
					String s_user = (String)usersMap.get(y);
					TreeMap userAppData = (TreeMap)billingValues.get(s_user);
					ArrayList user_allData = new ArrayList();
					boolean farmPresent = true;
					for(Iterator itrApp = userAppData.keySet().iterator(); itrApp.hasNext();)
					{
						String user_type = (String)itrApp.next();
						user_allData.addAll((ArrayList)userAppData.get(user_type));
					}
					int rowspan = user_allData.size();
%>
							<tr>
								<td rowspan="<%=rowspan%>"  class="tdborder" class="blackcontent" align="center"><%=sn++%></td>
								<td rowspan="<%=rowspan%>"  class="tdborder" class="blackcontent" align="center"><%=s_user%></td>
<%
					List mapKeys = new ArrayList(userAppData.keySet());
					Collections.reverse(mapKeys); 
					for(int i=0; i< mapKeys.size();i++) 
					{
						String userType = (String)mapKeys.get(i);
						ArrayList userAppHrs = (ArrayList)userAppData.get(userType);
%>
								<td rowspan="<%=userAppHrs.size()%>"  class="tdborder" class="blackcontent" align="center"><%=userType%></td>
<%
						for(int z=0 ; z < userAppHrs.size(); z++)
						{
							ArrayList signAppDataList = (ArrayList)userAppHrs.get(z);
							for(int m=0; m < signAppDataList.size(); m = m+4)
							{
								String s_app = (String)signAppDataList.get(m);
								String s_usrType = (String)signAppDataList.get(m+1);
								Double d_avgAppHrs = (Double)signAppDataList.get(m+2);
								Double d_totalAppHrs = (Double)signAppDataList.get(m+3);

								if(s_usrType!=null && s_usrType.equals("Yes"))
								{
%>
								<td  class="tdborder" class="blackcontent" nowrap>
									<table cellspacing="0" cellpadding="0" width="100%" height="20" >
										<tr>
											<td width="100%" align="center"><%=s_app%></td><td><img src="../reporter/images/icon_f.gif" align="right"/></td>
										</tr>
									</table>
								</td>
<%
								}
								else if(s_usrType.equals("No"))
								{
%>
								<td  class="tdborder" class="blackcontent" nowrap>
									<table cellspacing="0" cellpadding="0" width="100%" height="20" border="0">
										<tr>
											<td width="100%" align="left"><%=s_app%></td><td nowrap><img src="../reporter/images/icon_p.gif" align="right" /></td>
										</tr>
									</table>
								</td>
<%
								}
								String s_avgAppHrs = dbInfo.formatValue(d_avgAppHrs.doubleValue());
								String s_totalAppHrs = dbInfo.formatValue(d_totalAppHrs.doubleValue());
%>
								<td  class="tdborder" class="blackcontent" align="center"><%=s_avgAppHrs%></td>
								<td  class="tdborder" class="blackcontent" align="center"><%=s_totalAppHrs%></td>
<%
							}
							if(BillingFarmDataMap!=null && !BillingFarmDataMap.isEmpty())
							{
								if(farmPresent)
								{
									TreeMap usrAppFarmsData = (TreeMap)BillingFarmDataMap.get(s_compType);
									String FarmHrs = (String)usrAppFarmsData.get(s_user);
									tknVal = new StringTokenizer(FarmHrs,"#");
									while(tknVal.hasMoreTokens())
									{
%>
								<td rowspan="<%=rowspan%>"  class="tdborder" class="blackcontent" align="center"><%=tknVal.nextToken()%></td>
<%
									}
								}
								farmPresent=false;
							}
%>
							</tr>
<%
						}
					}
				}
%>
						<br>
						</TABLE>
						<br>
						<br>
<%
			}
		}else
		{
%>
			<TABLE align="center" width="95%" cellspacing="0" cellpadding="4" border="0" id="tableborder">
				<tr>
					<td id="er_submit" NOWRAP align="center" width="95%"><egui:intnl text="reporter.common.No measures available for the current selection"/></td>
				</tr>
			</TABLE><br>
<%
		}
	}else
	{
%>
			<TABLE align="center" width="95%" cellspacing="0" cellpadding="4" border="0" id="tableborder">
				<tr>
					<td id="er_submit" NOWRAP align="center" width="95%"><egui:intnl text="reporter.common.No measures available for the current selection"/></td>
				</tr>
			</TABLE><br>
<%
	}
%>
					</td>
				</tr>
			</table><br>
		</td>
	</tr>
</TABLE>
<%
	//For Setting the PDf File Name
	HashMap paramVal =new HashMap();
	paramVal.put("fileName","USER_BILLING_REPORT");
	session.setAttribute("parameters", paramVal);
}
catch(Exception BE)
{
	BE.printStackTrace();
}
%>
</BODY>
</HTML>

<%@ include file="ErRemoveUser.jsp"%>

