<%
/************************************************************************************************
* File				:	ErActiveIdleUserReportJson.jsp
* Purpose			:	Displays the configured measures and its details for the Citrix Applications
* Creation			:	Vengatesan R at 11/1/2017
*
*************************************************************************************************/
%>

<%@ page import = "egurkha.reporter.*" %>
<%@ page import = "java.util.*" %>
<%@ page import = "java.text.SimpleDateFormat" %>
<%@ page import = "egurkha.*" %>
<%@ page import = "com.eg.EgDbInfo" %>
<%@ page import ="com.eg.EgInstallInfo"%>
<%@ page import ="com.eg.IniFile"%>
<%@ page import="com.egurkha.ini.*" %>
<%@ page import="com.eg.EgDateInfo" %>
<%@ page import="com.eg.EgGroupInfo" %>
<%@ page import="com.eg.EgReportInfo" %>
<%@ page import = "com.egurkha.*" %>
<%@ page import = "java.net.*" %>
<%@ page import="com.eg.EgThresholdInfo" %>
<%@ page import="com.eg.EgTablesInfo" %>
<%@ page import="com.eg.EgMappingInfo" %>
<%@ page import = "com.eg.EgURLEncoder" %>
<%@ page import = "com.egurkha.util.DateTimeTokenizer" %>
<%@ page import = "com.egurkha.util.DateUtil" %>
<%@ page import = "com.egurkha.util.StringUtils" %>
<%@ page import = "java.text.*" %>
<%@ page import="net.sf.json.*" %>
<%@ page import = "com.eg.EgConfigInfo"%>
<%@ include file = "ErReporterTracker.jsp" %>


<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%
try
{
	JSONObject combo=new JSONObject();
	JSONObject urlFields=new JSONObject();
	JSONObject labelFields=new JSONObject();
    JSONObject hiddenFields = new JSONObject();
	JSONObject selectedFields = new JSONObject();
	JSONObject selectionDetails = new JSONObject();
	JSONObject data = new JSONObject();
	JSONObject graph = new JSONObject();
	JSONObject iterateJObject;
	JSONArray iterateJArray;
	JSONArray selectedComboJArray=null;
 	JSONObject activeIdleObj=new JSONObject();
	JSONObject loopJsonObj = new JSONObject();

	String bggroundStr = (String)request.getAttribute("bggroundStr");
	String status = (String)request.getAttribute("status");

	String strTestt="";
	//Back Button - Start

	HashMap backreqMap = (HashMap)session.getAttribute("backQuery");
	String backQnumber = request.getParameter("backQnumber");
	String servlet2 = request.getParameter("backServletName");
	String reqFromFavorite = request.getParameter("fromFavorite");
	String favorite_id = request.getParameter("FavoriteId");
	ErHelperUtils erhelputils = null;
	ErEsxVMutils erEsxUtils = new ErEsxVMutils();
	if( servlet2!=null && !servlet2.equals(""))
		erhelputils = new ErHelperUtils(backreqMap,backQnumber,servlet2);
	else
		erhelputils = new ErHelperUtils(backreqMap,backQnumber);

	boolean enableBack=erhelputils.isBackButtonEnable();
	String backButtonEnable = request.getParameter("back");
	activeIdleObj.put("ID","backQnumber="+erhelputils.getBackID()+"&"+erhelputils.getQueryString());
	if(backButtonEnable != null && backButtonEnable.equalsIgnoreCase("True"))
	{
		status = (String)request.getParameter("status");
		request.setAttribute("htdata",null);
		request.setAttribute("app_topusers",null);
		request.setAttribute("appChartData",null);
		bggroundStr = (String)request.getParameter("bggroundStr");
	}
	//Back Button - End
	String mngrIProc = new IniFile(new EgConfigInfo("manager").getDbFile()).getValue("DB_PROPERTIES","ManagerUrl");
	List lst = new LinkedList();
	Vector v_measure_csv = new Vector();
	List list_data = new LinkedList();

	IniUI ui = IniUI.getInstance();
	EgDateInfo egDt = new EgDateInfo();
	String Hourfrom="";
	String Minfrom="";
	String Hourto="";
	String Minto="";
	String fromTime,toTime;
	String variable;
	String s_QSGraph="";
	StringTokenizer st;

	EgMappingInfo intlmap=new EgMappingInfo(thisuser.getLanguage());
	ErComponentsUtils compUtils = new ErComponentsUtils(thisuser.getLoginID());
	ErUtils erUtils = new ErUtils();
	ErInfo erInfo = new ErInfo();
	EgReportInfo reportInfo=new EgReportInfo("manager");
	String confrimation = reportInfo.getValue("BACKGROUND_PROCESS","NeedConfirmation");
	String strbgrepportName = reportInfo.getValue("BACKGROUND_PROCESS","EnableBackgroundReport");
	String limitforbg = reportInfo.getValue("BACKGROUND_PROCESS","MinDurationForReport");
	EgThresholdInfo hreshholdInfo = new EgThresholdInfo("manager");
	EgTablesInfo tablesInfo = new EgTablesInfo("manager");
	EgDbInfo dbInfo = new EgDbInfo("manager");
	int pageWith=1024;
	
	Hashtable htt=new Hashtable();
	htt=(Hashtable)request.getAttribute("htdata");
	Vector v_components = compUtils.getAllUserComponents1();
	Vector v_component = new Vector();
	ArrayList v_Workgroupcomponents = new ArrayList();
	String user_selected = "";
	Vector v_temp = new Vector();
	Vector defComps = new Vector();
	Vector colZoneComps = new Vector();
	Vector v_comptype=new Vector();
	ArrayList aListCompType = new ArrayList();
	Vector v_tmp = new Vector();
	Vector v_infos=null;
	ArrayList aListworkGrp = new ArrayList();
	Vector v_comp_popup = new Vector();
	Vector v_comp_popup_disp = new Vector();

	String er_option =request.getParameter("er_option");
	String er_site = request.getParameter("er_site");
	String s_compType = request.getParameter("er_compType");
	String er_info = request.getParameter("er_info");
	String[] er_component = request.getParameterValues("er_component");
	String headerKeyName="";
	if(er_option!=null && !er_option.equalsIgnoreCase("Component"))
	{
		headerKeyName=intlmap.getTextDescription("reporter.common."+er_option)+" : "+er_site;
	}
	else
	{
		headerKeyName=intlmap.getTextDescription("reporter.common."+er_option);
		if(s_compType!=null)
		{
			headerKeyName+=" : "+intlmap.getComponentTypeDescription(s_compType);
		}
	}
	
	String installDir = EgInstallInfo.getInstallDir();
	IniFile inifile = new IniFile(installDir +"/manager/config/eg_report.ini");
	String sub = "MISC";
	String var = "CtxServer";
	String values = inifile.getValue(sub,var);
	String s_component = "";
	String s_qryString	="";
	String timeline =request.getParameter("er_timeline");
	String testmes = request.getParameter("select_testmes");
	String rtype =request.getParameter("er_type");
	String reqFromSchedule = request.getParameter("fromSchedule");
	String schedule_id = request.getParameter("schedule_id");
	String isSubmit = request.getParameter("isSubmit");
	ArrayList aListSupportedComponentType = reportInfo.getComponentsList("ACTIVEIDLE_USERS",false);

	boolean termpresent=false;
	Vector v_testmes = new Vector();
	HashMap htHeading = new HashMap();
	ArrayList aList1 = new ArrayList();
	ArrayList aList2 = new ArrayList();
	ArrayList aList3 = new ArrayList();


	Hashtable ht_data = (Hashtable)request.getAttribute("Report_data");
	Vector app_data = (Vector)request.getAttribute("App_data");
	ArrayList app_topusers = (ArrayList)request.getAttribute("app_topusers");
	Vector v_qry_string = (Vector)request.getAttribute("appChartData");
	Vector pdfQuery = (Vector)request.getAttribute("appPdfData");
	String backQS = (String)session.getAttribute("topBackQuery");
	String backQSserver = (String)session.getAttribute("topBackQuery_server");
	
	session.setAttribute("ApplicationReport",app_data);
	session.setAttribute("appForPrint",app_topusers);
	session.removeAttribute("topBackQuery");
	session.removeAttribute("backQSserver");

	HashMap Report_data=null;
	Hashtable h_data = new Hashtable();
	Hashtable h_rep = new Hashtable();
	Vector v_data1 = new Vector();
	Vector  v_add = new Vector();
	Vector v_sort=new Vector();

	String s_variable="";
	StringTokenizer tok1=null;
	String type="";
	String mes="";
	
	String s_sort=request.getParameter("er_sortby");
	String tbound = request.getParameter("er_tbound");
	String cTime = request.getParameter("currTime");

	String key="";
	ErReqData erd = new ErReqData(request);
	EgDateInfo egDate = new EgDateInfo();
	String stdate="";
	String enddate="";
	String sthr="";
	String endhr="";
	String sthr1 = "";
	String endhr1 = "";
	long msecsPerHour = (long) 1000 * 60 * 60;

	fromTime = reportInfo.getTimeFrame("ACTIVEIDLE_USERS","FROM");
	toTime = reportInfo.getTimeFrame("ACTIVEIDLE_USERS","TO");

	st = new StringTokenizer(fromTime,":");
	if(st.hasMoreTokens())
	{
		Hourfrom = st.nextToken();
		Minfrom = st.nextToken();
	}
	st=new StringTokenizer(toTime,":");
	if(st.hasMoreTokens())
	{
		Hourto = st.nextToken();
		Minto = st.nextToken();
	}
	String Days = reportInfo.getExcludeWeekend("ACTIVEIDLE_USERS");
	Vector v_time=new Vector();
	v_time.add("00");
	v_time.add("01");
	v_time.add("02");
	v_time.add("03");
	v_time.add("04");
	v_time.add("05");
	v_time.add("06");
	v_time.add("07");
	v_time.add("08");
	v_time.add("09");
	v_time.add("10");
	v_time.add("11");
	v_time.add("12");
	v_time.add("13");
	v_time.add("14");
	v_time.add("15");
	v_time.add("16");
	v_time.add("17");
	v_time.add("18");
	v_time.add("19");
	v_time.add("20");
	v_time.add("21");
	v_time.add("22");
	v_time.add("23");

	Vector v_min=new Vector();
	v_min.add("00");
	v_min.add("05");
	v_min.add("10");
	v_min.add("15");
	v_min.add("20");
	v_min.add("30");
	v_min.add("35");
	v_min.add("40");
	v_min.add("45");
	v_min.add("50");
	v_min.add("55");
	v_min.add("59");

	String timefrom2=request.getParameter("timefrom");
	String minfrom2=request.getParameter("minfrom");
	String timeto2=request.getParameter("timeto");
	String minto2=request.getParameter("minto");

	if (timefrom2!=null)
		Hourfrom=timefrom2;
	if (minfrom2!=null)
		Minfrom=minfrom2;
	if (timeto2!=null)
		Hourto=timeto2;
	if (minto2!=null)
		Minto=minto2;

	boolean hasVMs = false;
	boolean hasOnlyVMs = false;
	List a_userVMs = new LinkedList();
	List a_userVMs_temp = thisuser.getAlluserDesktopVms();
	if(a_userVMs_temp!=null && a_userVMs_temp.size() > 0)
	{
		for(int i=0;i<a_userVMs_temp.size();i++)
		{
			String VM = (String)a_userVMs_temp.get(i);
			if(VM!=null && VM.indexOf("_on_")>-1)
			{
				VM = VM.substring(VM.indexOf("_on_")+4);
			}
			if(!a_userVMs.contains(VM))
			{
				a_userVMs.add(VM);
			}
		}
		hasVMs = true;
	}
	//-Report By Combo
	if(er_option == null || (er_option!=null && er_option.isEmpty()) || er_option.equalsIgnoreCase("null"))
	{
		 er_option = "Component";
	}
	//  for - reports by segment,Service default loading setup

	User this_user = UserRegistry.getInstance().getUser(session.getId());
	String loginid = this_user.getLoginID();
	List v_option = new ArrayList();
	List v_site = new ArrayList();
	Hashtable htAllGroups=erEsxUtils.getGroups(null,aListSupportedComponentType, thisuser, loginid, "Yes",true);
	ArrayList aListOption = erEsxUtils.getOptions(htAllGroups);
	v_site = erEsxUtils.getGroupsName(htAllGroups,er_option);
	ArrayList aListComponentTemp = null;
	if(!er_option.equalsIgnoreCase("Component"))
	{
		if(er_site==null || er_site.trim().equals(""))
		{
			er_site = (String)v_site.get(0);
		}
		aListComponentTemp = erEsxUtils.getComponentForGroup(htAllGroups,er_option,er_site);
	}
	else
	{
		aListComponentTemp = erEsxUtils.getComponentForGroup(htAllGroups,er_option,null);
	}
	if(hasVMs && (aListComponentTemp==null || aListComponentTemp.size()==0))
	{
		hasOnlyVMs = true;
	}
	if(hasOnlyVMs)
	{
		v_option.add("Component");
	}
	else if(aListOption!=null && aListOption.size()>0)
	{
		v_option.addAll(aListOption);
	}
	JSONArray arr = new JSONArray();
	JSONObject obj1=null;
	if(v_option!=null && v_option.size()>0)
	{
		selectedFields.put("selectedAnalysisByCombo",er_option);
		for(int i=0; i<v_option.size(); i++)
		{
			obj1 = new JSONObject();
			obj1.put("displayField", intlmap.getTextDescription("reporter.common."+v_option.get(i)));
			obj1.put("valueField",v_option.get(i));
			arr.add(obj1);
		}
	}
	else
	{
		obj1 = new JSONObject();
		obj1.put("displayField", intlmap.getTextDescription("reporter.common.Not Applicable"));
		obj1.put("valueField","-1");
		arr.add(obj1);
	}
	combo.put("analysisByCombo",arr);

	if(er_option!=null && !er_option.equalsIgnoreCase("Component"))
	{
		v_site = erEsxUtils.getGroupsName(htAllGroups,er_option);
		if(er_site.equalsIgnoreCase("--Default--"))
		{
			selectionDetails.put(intlmap.getTextDescription("reporter.thin."+er_option),intlmap.getTextDescription("reporter.common.--Default--"));
		}
		else
		{
			selectionDetails.put(intlmap.getTextDescription("reporter.thin."+er_option),er_site);
		}
		combo.put("siteCombo",getJSONComboFromList(v_site,"",intlmap));
		selectedFields.put("selectedSiteCombo",er_site);
	}
	if(hasVMs)
	{
		if(aListComponentTemp==null)
		{
			aListComponentTemp = new ArrayList();
		}
		for(int i=0;i<a_userVMs.size();i++)
		{
			String comps = (String)a_userVMs.get(i);
			ArrayList hosts = (ArrayList)thisuser.getVMHostHistory(comps);
			if(hosts!=null && hosts.size()>0)
			{
				for(int j=0;j<hosts.size();j++)
				{
					String hostName = (String)hosts.get(j);
					if(!aListComponentTemp.contains(hostName))
					{
						aListComponentTemp.add(hostName);
					}
				}
			}
		}
	}
	if(er_info!=null)
	{
		selectedFields.put("selectedVm",er_info);
	}
	else
	{
		selectedFields.put("selectedVm","*");
	}
	ArrayList selectedCompList = new ArrayList();
	if(er_component!=null)
	{
		selectedCompList.addAll(Arrays.asList(er_component));
	}
	String showVirtualDesktop = reportInfo.getValue("ACTIVEIDLE_USERS","ShowVirtualDesktop");
	if(aListComponentTemp!=null && aListComponentTemp.size()>0)
	{
		Collections.sort(aListComponentTemp);
		for(int i=0;i<aListComponentTemp.size();i++)
		{
			String hostName = (String)aListComponentTemp.get(i);
			String compType = hostName.substring(hostName.lastIndexOf(":")+1);
			compType = intlmap.getComponentTypeDescription(compType);
			String compName = hostName.substring(0,hostName.lastIndexOf(":")-1);
			if(!v_comptype.contains(compType))
			{
				v_comptype.add(compType);
			}
		}
		if(v_comptype.size()>0)
		{
			Collections.sort(v_comptype);
			if(hasVMs)
			{
				if(hasOnlyVMs)
				{
					v_comptype = new Vector();
				}
				v_comptype.add(intlmap.getComponentTypeDescription("Virtual_Machine"));
			}
			if(s_compType==null || s_compType.equals(""))
			{
				s_compType = intlmap.getReverseComponentTypeDescription((String)v_comptype.get(0));
			}
			arr = new JSONArray();
			for(int i=0;i<v_comptype.size();i++)
			{
				obj1 = new JSONObject();
				obj1.put("displayField",v_comptype.get(i));
				obj1.put("valueField",intlmap.getReverseComponentTypeDescription((String)v_comptype.get(i)));
				arr.add(obj1);
			}
			if(!hasVMs)
			{
				/*obj1 = new JSONObject();
				if(showVirtualDesktop!=null && showVirtualDesktop.equalsIgnoreCase("true"))
				{
					obj1.put("displayField", intlmap.getComponentTypeDescription("Virtual_Machine"));
				}
				else
				{
					obj1.put("displayField", intlmap.getTextDescription("reporter.common.All Component Types"));
				}
				obj1.put("valueField","all");
				arr.add(obj1);*/
				if(showVirtualDesktop!=null && showVirtualDesktop.equalsIgnoreCase("true"))
				{
					obj1 = new JSONObject();
					obj1.put("displayField", intlmap.getComponentTypeDescription("Virtual_Machine"));
					obj1.put("valueField","all");
					arr.add(obj1);
				}
			}
			combo.put("componentTypeCombo",arr);
			if(s_compType.equalsIgnoreCase("all"))
			{
				selectionDetails.put(intlmap.getTextDescription("reporter.common.Component Type"),intlmap.getComponentTypeDescription("Virtual_Machine"));
			}
			else
			{
				selectionDetails.put(intlmap.getTextDescription("reporter.common.Component Type"),intlmap.getComponentTypeDescription(s_compType));
			}
			selectedFields.put("componentTypeSelected",s_compType);
		}
		arr = new JSONArray();
		obj1 = new JSONObject();
		obj1.put("displayField", intlmap.getTextDescription("reporter.common.All Components"));
		obj1.put("valueField","all");
		arr.add(obj1);
		ArrayList userCompList = new ArrayList();
		for(int i=0;i<aListComponentTemp.size();i++)
		{
			String hostName = (String)aListComponentTemp.get(i);
			String compType = hostName.substring(hostName.lastIndexOf(":")+1);
			String compName = hostName.substring(0,hostName.lastIndexOf(":"));
			if(compName.endsWith(":NULL"))
			{
				compName = compName.substring(0,compName.indexOf(":"));
			}
			if(s_compType.equalsIgnoreCase(compType) || s_compType.equalsIgnoreCase("all") || s_compType.equalsIgnoreCase("Virtual_Machine"))
			{
				obj1 = new JSONObject();
				obj1.put("displayField",compName);
				obj1.put("valueField",hostName);
				arr.add(obj1);
				userCompList.add(hostName);
			}
		}
		selectedCompList.retainAll(userCompList); // this for backward compability
		if(selectedCompList.size()==0)
		{
			selectedCompList.add("all");
		}
		selectedFields.put("componentSelected",selectedCompList);
		combo.put("componentCombo",arr);
	}
	else
	{
		arr = new JSONArray();
		obj1 = new JSONObject();
		obj1.put("displayField",intlmap.getTextDescription("reporter.common.Not Applicable"));
		obj1.put("valueField", "-1");
		combo.put("componentTypeCombo",arr);
		selectedFields.put("componentTypeSelected","-1");

		arr = new JSONArray();
		obj1 = new JSONObject();
		obj1.put("displayField",intlmap.getTextDescription("reporter.common.Not Applicable"));
		obj1.put("valueField", "-1");
		combo.put("componentCombo",arr);
		selectedFields.put("componentSelected","-1");
	}
	String idleTimeLimitStr = request.getParameter("idleTimeLimit");
	if(idleTimeLimitStr==null || idleTimeLimitStr.trim().equals(""))
	{
		idleTimeLimitStr = reportInfo.getValue("ACTIVEIDLE_USERS","idleTimeLimit");
	}
	if(idleTimeLimitStr==null || idleTimeLimitStr.trim().equals(""))
	{
		idleTimeLimitStr = "20";
	}
	selectedFields.put("idleTimeLimit",idleTimeLimitStr);
	String uiFile = "eg_ui.ini";
	String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile egUI = new IniFile(s_iniFile_dir + uiFile);
	String currentDateFormat = strUserDateFormat;//egUI.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");

	String starttimeformat="";
	String endtimeformat="";
	String dispDate = null;
	String comFormat = null;
	String  s_st_time   = request.getParameter("startdate");
	String s_en_time    = request.getParameter("enddate");
	String s_st_hr      = request.getParameter("starthr");
	String s_en_hr      = request.getParameter("endhr");
	String strmin       = request.getParameter("startmin");
	String enmin        = request.getParameter("endmin");
	String  er_timeline = request.getParameter("er_timeline");
	String start_date   = request.getParameter("startdate");
	String end_date     = request.getParameter("enddate");

	String  pdfStartDate = s_st_time+" "+s_st_hr+":"+strmin;
	String  pdfEndDate   = s_en_time+" "+s_en_hr+":"+enmin;
	String pdfTime = "From "+pdfStartDate+" hrs "+" "+" To "+pdfEndDate+" hrs";

	Vector applnPdfData = new Vector();
	applnPdfData = (Vector)request.getAttribute("applnPdfData");
	pdfTime = "ActiveIdle Users "+pdfTime;

	if(applnPdfData!=null && !applnPdfData.isEmpty())
	{
		Vector forTime = (Vector)applnPdfData.get(1);
		forTime.removeElementAt(0);
		forTime.insertElementAt(pdfTime,0);
		applnPdfData.removeElementAt(1);
		applnPdfData.insertElementAt(forTime,1);
	}
	if(er_timeline==null  || er_timeline.equals(" "))
	{
		er_timeline="1 day";
	}
	//Date calculation according to time select
	String[] options = {"Any","1 hour", "3 hours", "6 hours", "9 hours", "12 hours", "15 hours", "18 hours", "21 hours","1 day", "2 days", "3 days", "4 days", "5 days", "6 days","1 week","2 weeks","3 weeks","4 weeks","1 month","2 months","3 months"};
	String startDateTime="";
	String endDateTime="";
	if(er_timeline!=null&&!er_timeline.equals("Any"))
	{
		int blankSpaceIndex = er_timeline.indexOf(DateTimeTokenizer.BLANK_SPACE);
		if (blankSpaceIndex > 0)
		{
			SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy HH:mm");
			java.util.Date today =egDt.egetRealDate();
			endDateTime = sdf.format(today);
			long value = Integer.parseInt(er_timeline.substring(0, blankSpaceIndex));
			String unit = er_timeline.substring(blankSpaceIndex+1).toLowerCase();
			if (unit.startsWith("h"))
			{//hours
				value *= 3600;
			}
			else if (unit.startsWith("d"))
			{//days
				value *= (24 * 3600);
			}
			else if (unit.startsWith("w"))
			{//weeks
				value *= (7 * 24 * 3600);
			}
			else if (unit.startsWith("mo"))
			{//months
				java.util.Date dt_temp = new java.util.Date(egDt.egetUTCDate());
				Calendar cal_temp = new GregorianCalendar();
				cal_temp.setTime(dt_temp);
				//cal_temp.add(Calendar.DATE,-1);
				cal_temp.add(Calendar.HOUR_OF_DAY,0);
				java.util.Date dt_temp1 = cal_temp.getTime();
				long l_temp = dt_temp1.getTime();
				int  totalDays=24*(ErUtils.getMaxDaysInMonth());
				startDateTime = egDt.egetDate(l_temp -(long)( (value*totalDays * msecsPerHour)));
				startDateTime = DateUtil.changeDateFormat(startDateTime,
				"dd/MM/yyyy HH:mm","MM/dd/yyyy HH:mm");
			}
			if (unit!=null&&!unit.startsWith("mo"))
			{
				java.util.Date start = egDt.egetRealDate();
				start.setTime(today.getTime() - (value * 1000));
				startDateTime = sdf.format(start);
			}
		}
		if ((startDateTime != null) && (endDateTime != null))
		{
			int shr = Integer.parseInt(startDateTime.substring(startDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE)+1, startDateTime.indexOf(":")));
			strmin=startDateTime.substring(startDateTime.indexOf(":")+1);
			int en_hr = Integer.parseInt(endDateTime.substring(endDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE)+1, endDateTime.indexOf(":")));
			enmin=endDateTime.substring(endDateTime.indexOf(":")+1);
			s_en_time=endDateTime.substring(0, endDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE));
			s_st_time=startDateTime.substring(0, startDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE));
			s_st_hr = String.valueOf(shr);
			s_en_hr = String.valueOf(en_hr);
		}
	}
	String disable="";
	if(er_timeline!=null&&!er_timeline.equals("Any"))
	{
		disable ="disabled";
	}
	if(er_timeline!=null&&er_timeline.equals("Any"))
	{
		String StrDate="";
		try
		{
			java.text.SimpleDateFormat df=new java.text.SimpleDateFormat("MM/dd/yyyy k 'at' hh:mm");
			StrDate =df.format(egDt.egetRealDate());
		}
		catch(Exception ee)
		{
			////System.out.println("Exception is"+ee);
		}
		String SDate =StrDate.substring(0,StrDate.indexOf(" "));
		String shour =StrDate.substring(StrDate.indexOf(" "),StrDate.lastIndexOf(""));
		shour = shour.substring(0,3);
		if(s_st_time==null)
		{
			s_st_time=SDate;
		}
		if(s_en_time==null)
		{
			s_en_time=SDate;
		}
		if(s_st_hr==null)
		{
			shour =shour.trim();
			int starthr = Integer.parseInt(shour);
			starthr = starthr-1;
			s_st_hr=String.valueOf(starthr);
		}
		if(s_en_hr==null)
		{
			shour =shour.trim();
			s_en_hr =shour;
		}
		strmin="00";
		enmin="00";
	}
	String strServergroupQs = "";
	if(er_component!=null && er_component.length>0)
	{
		for (int i=0;i<er_component.length;i++)
		{
			try{
				strServergroupQs += "&er_component="+EgURLEncoder.encode(er_component[i],"UTF-8");
				String strComp = er_component[i];
				if(strComp!=null && strComp.lastIndexOf(":")>-1)
					strComp = strComp.substring(0,strComp.lastIndexOf(":"));
			}catch(Exception e){}
		}
	}
	session.setAttribute("PDF_URL", mngrIProc+"/final/reporter/ErActiveIdleUserReportPrint.jsp");
	urlFields.put("PDF_URL",mngrIProc+"/final/reporter/ErActiveIdleUserReportPrint.jsp");

	String excludeweekend=request.getParameter("er_excwe");
	if (excludeweekend==null ||	excludeweekend.equals(""))
		excludeweekend="No";

	hiddenFields.put("option","Citrix");
	hiddenFields.put("inidate",currentDateFormat);
	hiddenFields.put("currTime","");
	hiddenFields.put("er_rtype","ActiveIdle_Users");
	hiddenFields.put("er_trgttype","ActiveIdle Users");
	hiddenFields.put("er_gtype","Citrix");
	hiddenFields.put("pdfTime",pdfTime);
	hiddenFields.put("uid",EgURLEncoder.encode(loginid,"UTF-8"));
	hiddenFields.put("userID",EgURLEncoder.encode(loginid,"UTF-8"));
	hiddenFields.put("eruserid",EgURLEncoder.encode(loginid,"UTF-8"));
	hiddenFields.put("er_trenddata","No");
	hiddenFields.put("servers",request.getParameter("servers"));
	hiddenFields.put("er_check",request.getParameter("er_check"));
	hiddenFields.put("schedule_id",schedule_id);
	hiddenFields.put("er_ViewName","ErActiveIdleUserReport.jsp");
	hiddenFields.put("getMaxDaysInMonth",ErUtils.getMaxDaysInMonth());
	hiddenFields.put("forwardto","ErActiveIdleUserReportJson");
	hiddenFields.put("er_bgreportfrom","ActiveIdle_Users");
	hiddenFields.put("bgenabled",strbgrepportName);
	hiddenFields.put("limitforbg",limitforbg);
	hiddenFields.put("savereport","save");
	hiddenFields.put("servletName","com.eg.ErActiveIdleUserReportC");
	hiddenFields.put("pageWidthProces","1024");
	if(reqFromFavorite!=null)
	{
		hiddenFields.put("fromFavorite",reqFromFavorite);
	}
	else
	{
		hiddenFields.put("fromFavorite","null");
	}
	if(reqFromSchedule!=null)
	{
		hiddenFields.put("fromSchedule",reqFromSchedule);
	}
	else
	{
		hiddenFields.put("fromSchedule","null");
	}
	hiddenFields.put("FavoriteId",favorite_id);
	hiddenFields.put("opt","chart");

	String fromFavSch = request.getParameter("fromFavSch");
	if(backreqMap != null && backreqMap.size() > 0 &&  enableBack && request.getParameter("enableBack")!=null && request.getParameter("enableBack").equalsIgnoreCase("true") && (fromFavSch!=null && fromFavSch.equalsIgnoreCase("true")))
	{
		hiddenFields.put("ID","backQnumber="+erhelputils.getBackID()+"&"+erhelputils.getQueryString());
	}
	if(s_compType!=null)
	{
		lst.add(intlmap.getTextDescription("reporter.common.Active Idle Users")+" for "+headerKeyName);
		lst.add(intlmap.getTextDescription("reporter.thin.Component Type")+" : "+intlmap.getComponentTypeDescription(s_compType));
	}

	labelFields.put("siteComboLabel",intlmap.getTextDescription("reporter.common."+er_option));
	labelFields.put("componentTypeLabel",intlmap.getTextDescription("reporter.thin.Component Type"));
	labelFields.put("reportTypeLabel",intlmap.getTextDescription("monitor.common.Analyze By"));
	labelFields.put("infoTypeLabel",intlmap.getTextDescription("reporter.thin.Applications/Desktops"));
	labelFields.put("componentLabel",intlmap.getTextDescription("reporter.thin.Components"));
	labelFields.put("idleTimeLimitLabel",intlmap.getTextDescription("reporter.thin.High Idle Time Limit")+" (%)");
		
	iterateJArray=new JSONArray();
	iterateJObject=new JSONObject();
	iterateJObject.put("displayField",intlmap.getTextDescription("reporter.common.Yes")+" ("+Days+") ");
	iterateJObject.put("valueField","Yes");
	iterateJArray.add(iterateJObject);
	iterateJObject=new JSONObject();
	iterateJObject.put("displayField",intlmap.getTextDescription("reporter.common.No"));
	iterateJObject.put("valueField","No");
	iterateJArray.add(iterateJObject);
	combo.put("excludeWeekendsCombo",iterateJArray);
	labelFields.put("excludeWeekendsLabel",intlmap.getTextDescription("reporter.thin.Exclude weekends"));
	labelFields.put("excludeDaysLabel",intlmap.getTextDescription("reporter.thin.Excludes")+" "+Days);
	if(excludeweekend.equalsIgnoreCase("Yes") )
	{
		selectedFields.put("excludeWeekendsSelected","Yes");
		lst.add('"'+intlmap.getTextDescription("reporter.common.Time period")+":"+intlmap.getTextDescription("reporter.common.From")+" "+request.getParameter("timefrom")+":"+request.getParameter("minfrom")+intlmap.getTextDescription("reporter.common.Hrs")+" "+intlmap.getTextDescription("reporter.common.To")+" "+request.getParameter("timeto")+":"+request.getParameter("minto")+intlmap.getTextDescription("reporter.common.Hrs")+'"'+","+'"'+	intlmap.getTextDescription("reporter.common.Exclude weekends")+":"+Days+'"');
	}
	else
	{
		selectedFields.put("excludeWeekendsSelected","No");
		lst.add(intlmap.getTextDescription("reporter.common.Time period")+":"+intlmap.getTextDescription("reporter.common.From")+" "+request.getParameter("timefrom")+":"+request.getParameter("minfrom")+intlmap.getTextDescription("reporter.common.Hrs")+" "+intlmap.getTextDescription("reporter.common.To")+" "+request.getParameter("timeto")+":"+request.getParameter("minto")+intlmap.getTextDescription("reporter.common.Hrs"));
	}
	
	if(er_component!=null && er_component.length==1)
	{
		String comp_name = (String)er_component[0];
		if(comp_name!=null && comp_name.indexOf(":")>-1)
		{
			comp_name = comp_name.substring(0,comp_name.indexOf(":"));
		}
		if(comp_name.equalsIgnoreCase("all"))
		{
			comp_name = intlmap.getTextDescription("reporter.common.All Components");
		}
		selectionDetails.put(intlmap.getTextDescription("reporter.common.Components"),comp_name);
	}
 
	selectedFields.put("selectedTimeFrom",Hourfrom);
	selectedFields.put("selectedMinsFrom",Minfrom);
	selectedFields.put("selectedTimeTo",Hourto);
	selectedFields.put("selectedMinsTo",Minto);
%>
	<%@  include file ="ErTimeFormatJSON.jsp"%>
<%
	String sdate = request.getParameter("startdate");	
	String edate = request.getParameter("enddate");	
	String shr = request.getParameter("starthr");	
	String ehr = request.getParameter("endhr");	
	String smin = request.getParameter("startmin");	
	String emin = request.getParameter("endmin");
	
	starttimeformat = sdate+ " " +shr+":"+smin+" "+"Hrs ";
	
	endtimeformat   = edate+ " " +ehr+":"+emin+" Hrs ";
	//Time zone conversion 
	
	pdfStartDate=startDateForDisplay+" "+startHourForDisplay+":"+startMinForDisplay;
	pdfEndDate = endDateForDisplay+" "+endHourForDisplay+":"+endMinForDisplay;
		


	Vector dvec = new Vector();
	String stimefmt = "Start Date : "+pdfStartDate;
	String etimefmt = "End Date : "+pdfEndDate;

	String ssd=stimefmt+"  "+etimefmt;

	lst.add('"'+ssd+'"');

	
	hiddenFields.put("userTimeline",strUsrTimeline);
	combo.put("timelineCombo",timelineComboArray);
	selectedFields.put("selectedTimeline",er_timeline);
	selectedFields.put("startDate",startDateJSON);
	selectedFields.put("endDate",endDateJSON);
	selectedFields.put("startHour",startHourJSON);
	selectedFields.put("endHour",endHourJSON);
	selectedFields.put("startmin",startMin);
	selectedFields.put("endmin",endMin);
	selectedFields.put("selectedGraphMode",selectedGraphMode);

	//User TimeZone changes
	selectedFields.put("startDateForDisplay",startDateForDisplay);
	selectedFields.put("startHourForDisplay",startHourForDisplay);
	selectedFields.put("startMinForDisplay",startMinForDisplay);
	selectedFields.put("endDateForDisplay",endDateForDisplay);
	selectedFields.put("endHourForDisplay",endHourForDisplay);
	selectedFields.put("endMinForDisplay",endMinForDisplay);
	
	//selectionDetails.put(intlmap.getTextDescription("reporter.common.Time Period"),Hourfrom+":"+Minfrom+"<span class='font_bold'>  "+intlmap.getTextDescription("reporter.common.to")+" </span> "+Hourto+":"+Minto);
		
	selectionDetails.put((String)intlmap.getTextDescription("reporter.common.Timeline"),pdfStartDate+" "+intlmap.getTextDescription("reporter.common.hrs")+" <span class='font_bold'>"+intlmap.getTextDescription("reporter.common.to")+"</span> "+pdfEndDate+" "+intlmap.getTextDescription("reporter.common.hrs"));
 	
	String er_reportgenration = request.getParameter("er_reportgenration");
	String er_background ="";
	String er_foreground ="";
	if (er_reportgenration != null && er_reportgenration.equals("background"))
	{
		selectedFields.put("reportGenerationSelected","background");
		er_background = "selected";
		er_foreground = "";
	}
		else if(er_reportgenration != null && er_reportgenration.equals("background-csv"))
	{
		selectedFields.put("reportGenerationSelected","background-csv");
		er_background = "selected";
		er_foreground = "";
	}
	else
	{
		selectedFields.put("reportGenerationSelected","foreground");
		er_background = "";
		er_foreground = "selected";
	}
	String bg_reportname = request.getParameter("bg_reportname");
	if(bg_reportname == null)
	{
		bg_reportname = "";
	}
	String reportgenColspan = "5";
	if(rtype != null && rtype.equalsIgnoreCase("No"))
	{
		if(er_reportgenration != null && er_reportgenration.equals("background"))
			reportgenColspan = "2";
		else
			reportgenColspan = "3";
	}
	if(strbgrepportName != null && strbgrepportName.equalsIgnoreCase("Yes"))
	{
		labelFields.put("reportGenerationLabel",intlmap.getTextDescription("reporter.consolidated.Report Generation"));
		labelFields.put("reportNameLabel",intlmap.getTextDescription("reporter.consolidated.Report Name"));
		iterateJArray=new JSONArray();
		iterateJObject=new JSONObject();
		iterateJObject.put("displayField",strbackground);
		iterateJObject.put("valueField","background");
		iterateJArray.add(iterateJObject);

		iterateJObject=new JSONObject();
		iterateJObject.put("displayField","Background Save - CSV");
		iterateJObject.put("valueField","background-csv");
		iterateJArray.add(iterateJObject);

		iterateJObject=new JSONObject();
		iterateJObject.put("displayField",strforeground);
		iterateJObject.put("valueField","foreground");
		iterateJArray.add(iterateJObject);
		combo.put("reportGenerationCombo",iterateJArray);

		if (er_reportgenration != null && (er_reportgenration.equals("background")||er_reportgenration.equalsIgnoreCase("background-csv")))
		{
			selectedFields.put("reportNameSelected",bg_reportname);
		}
		
	}
		if((reqFromSchedule!=null && reqFromSchedule.equalsIgnoreCase("Yes")) || (reqFromFavorite!=null && reqFromFavorite.equalsIgnoreCase("Yes")))
		{
			labelFields.put("saveButton",intlmap.getTextDescription("reporter.common.SAVE"));
			String fromReq = "schedule";
			if(reqFromFavorite!=null && reqFromFavorite.equalsIgnoreCase("Yes"))
				fromReq = "favorite";
		}
		else
		{
			labelFields.put("submitButton",intlmap.getTextDescription("reporter.common.SUBMIT"));
		}

		if(bggroundStr != null && !bggroundStr.equals(""))
		{
			String strreportName ="ActiveIdle_Users";
			if(status != null && (status.equalsIgnoreCase("duplicate") || status.equalsIgnoreCase("exceedLimit")))
			{
				strreportName ="All Report Types";
				//labelFields.put("bgStatus","success");
			}
			if(status !=null && status.equalsIgnoreCase("success"))
				labelFields.put("bgStatus","success");
			else if(status !=null && status.equalsIgnoreCase("duplicate"))
				labelFields.put("bgStatus","duplicate");
			if(strreportName!=null && strreportName.indexOf(" ") > -1)
			{
				strreportName = com.eg.EgURLEncoder.encode(strreportName, "UTF-8");
			}
			if(status != null && !status.equalsIgnoreCase("exceedLimit"))
			{
				labelFields.put("bgResponseText",erbgreport.getlangsupportedString(bggroundStr,bgString,urs));
			}
			else
			{
				labelFields.put("bgResponseText",bggroundStr);
			}
			urlFields.put("bgUrl","/final/servlet/com.eg.ErStartBackGroundReportC?back=true&er_bgreportfrom="+strreportName+"&userID="+com.eg.EgURLEncoder.encode(urs, "UTF-8")+"&savereport=search&er_filterby=Report_Name&forwardto=ErBackGoundProcess");
			labelFields.put("bgAnchor",intlmap.getTextDescription("reporter.common.Click here to see a list of generated and processing reports"));
			
		}
		HashMap resultMap = (HashMap)session.getAttribute("ACTIVEIDLE_USER_RESULT");
		if(resultMap!=null && resultMap.size()>0)
		{
			String NO_DATA = (String)resultMap.get("NO_DATA");
			if(NO_DATA!=null && NO_DATA.equalsIgnoreCase("yes"))
			{
				data.put("noMeasures",intlmap.getTextDescription("reporter.common.No measures available for the current selection"));
				lst.add(intlmap.getTextDescription("reporter.common.No measures available for the current selection"));
			}
			else
			{
				String uniqueUserCountStr = (String)resultMap.get("uniqueUserCount");
				String totalSessionStr = (String)resultMap.get("totalSession");
				String highIdleSessionCountStr = (String)resultMap.get("highIdleSessionCount");
				String graphMaxValueStr = (String)resultMap.get("graphMaxValue");
				String highIdleUserCountStr = (String)resultMap.get("highIdleUserCount");
				String totalIdlePerStr = (String)resultMap.get("totalIdlePer");
				ArrayList gridDataList = (ArrayList)resultMap.get("gridMap");
				ArrayList gridDataList_user = (ArrayList)resultMap.get("gridMap_user");
				String measures = reportInfo.getValue("ACTIVEIDLE_USERS",s_compType+":testMeasure");
				boolean haveGuestName = true;
				measures = measures.toLowerCase();
				if(measures!=null && measures.indexOf("guestname")==-1)
				{
					haveGuestName = false;
				}
				
				double totalIdlePer = getDoubleValue(totalIdlePerStr);
				double graphMaxValue = getDoubleValue(graphMaxValueStr);

				// Summary data start
				JSONObject summaryObj = new JSONObject();
				summaryObj.put("UNIQUE_USER",uniqueUserCountStr);
				summaryObj.put("TOTAL_SESSION",totalSessionStr);
				summaryObj.put("HIGH_IDLE_SESSION",highIdleSessionCountStr);
				summaryObj.put("HIGH_IDLE_USER",highIdleUserCountStr);
				data.put("SUMMARY",summaryObj);
				double yForActive = 100-totalIdlePer;
				double yForIdle = totalIdlePer;

				// pie Chart start here
				JSONObject pieObj = new JSONObject();
				JSONArray pieDataSetAry = new JSONArray();
				JSONObject pieDataObj = new JSONObject();
				JSONArray pieDataAry = new JSONArray();
				
				JSONObject dataObj = new JSONObject();
				dataObj.put("color","#69c7b3");
				dataObj.put("name","Active Time");
				dataObj.put("y",yForActive);
				pieDataAry.add(dataObj);
				
				dataObj = new JSONObject();
				dataObj.put("color","#f49242");
				dataObj.put("name","Idle Time");
				dataObj.put("y",yForIdle);
				pieDataAry.add(dataObj);
				
				pieDataObj.put("data",pieDataAry);
				pieDataSetAry.add(pieDataObj);

				pieObj.put("TITLE","");
				pieObj.put("formatForLegendOnlyPercentage",true);
				pieObj.put("chartHeight",300);
				pieObj.put("chartWidth",300);
				pieObj.put("chartType","pie");
				pieObj.put("colorMode",true);
				pieObj.put("isDataLabelEnabled",true);
				pieObj.put("legend",true);
				pieObj.put("DataSet",pieDataSetAry);
				data.put("pieObj",pieObj);

				// bar chart start here
				Collections.sort(gridDataList_user, new Comparator()
				{
					public int compare(Object o1, Object o2)
					{
						HashMap map1 = (HashMap)o1;
						HashMap map2 = (HashMap)o2;
						String srt1 = (String)map1.get("IDLE_TIME");
						String srt2 = (String)map2.get("IDLE_TIME");
						if(srt1.equals("-"))
							srt1 = "0";
						if(srt2.equals("-"))
							srt2 = "0";
						if(new Double(srt1)>new Double(srt2))
							return -1;
						else if(new Double(srt1)<new Double(srt2))
							return 1;
						else
							return 0;
					}
				});
				JSONObject barObj = new JSONObject();
				JSONArray barDataSetAry = new JSONArray();
				JSONArray xAxisLabelAry = new JSONArray();

				int maxUser = 10;
				if(gridDataList_user.size()<10)
				{
					maxUser = gridDataList_user.size();
				}
				JSONArray idleAry = new JSONArray();
				JSONArray activeAry = new JSONArray();
				for(int i=0;i<gridDataList.size();i++)
				{
					HashMap returnDataMap = (HashMap)gridDataList.get(i);
					list_data.add(returnDataMap.get("USERNAME"));
					if(haveGuestName)
					{
						list_data.add(returnDataMap.get("GUESTNAME"));
					}
					list_data.add(returnDataMap.get("TOTAL_SESSION"));
					list_data.add(returnDataMap.get("HIGHIDLESESSION"));
					list_data.add(returnDataMap.get("DURATIONUI"));
					list_data.add(returnDataMap.get("ACTIVETIMEUI"));
					list_data.add(returnDataMap.get("IDLE_TIMEUI"));
					list_data.add(returnDataMap.get("PCT_IDLE_TIME"));
				}
				for(int i=0;i<maxUser;i++)
				{
					HashMap returnDataMap = (HashMap)gridDataList_user.get(i);
					xAxisLabelAry.add((String)returnDataMap.get("USERNAME"));
					dataObj = new JSONObject();
					double dataVal = getDoubleValue((String)returnDataMap.get("ACTIVETIME"));
					String dataStr = erUtils.roundOffDigit(dataVal,2);
					double yVal = getDoubleValue(dataStr);
					dataObj.put("y",yVal);
					if((graphMaxValue/3.5)>yVal)
					{
						JSONObject datalabels = new JSONObject();
						datalabels.put("enabled",false);
						dataObj.put("dataLabels",datalabels);
					}
					activeAry.add(dataObj);

					dataObj = new JSONObject();
					dataVal = getDoubleValue((String)returnDataMap.get("IDLE_TIME"));
					dataStr = erUtils.roundOffDigit(dataVal,2);
					yVal = getDoubleValue(dataStr);
					dataObj.put("y",yVal);
					if((graphMaxValue/3.5)>yVal)
					{
						JSONObject datalabels = new JSONObject();
						datalabels.put("enabled",false);
						dataObj.put("dataLabels",datalabels);
					}
					idleAry.add(dataObj);
				}
				JSONObject barDataObj = new JSONObject();
				barDataObj.put("data",activeAry);
				barDataObj.put("color","#69c7b3");
				barDataObj.put("name","Active Time");
				barDataObj.put("showInLegend",true);
				barDataSetAry.add(barDataObj);

				barDataObj = new JSONObject();
				barDataObj.put("data",idleAry);
				barDataObj.put("color","#f49242");
				barDataObj.put("name","Idle Time");
				barDataObj.put("showInLegend",true);
				barDataSetAry.add(barDataObj);

				barObj.put("chartHeight",300);
				barObj.put("chartWidth",450);
				barObj.put("chartSubType","stacked");
				barObj.put("chartType","bar");
				barObj.put("inside",true);
				barObj.put("legend",true);
				barObj.put("title","");
				barObj.put("xAxisLabel",xAxisLabelAry);
				barObj.put("yAxisLabel","Mins");
				barObj.put("DataSet",barDataSetAry);
				barObj.put("marginbottom","null");
				barObj.put("isActiveIdle",true);
				data.put("barObj",barObj);
				
				// grid data start here
				Collections.sort(gridDataList, new Comparator()
				{
					public int compare(Object o1, Object o2)
					{
						HashMap map1 = (HashMap)o1;
						HashMap map2 = (HashMap)o2;
						String srt1 = (String)map1.get("IDLE_TIME");
						String srt2 = (String)map2.get("IDLE_TIME");
						if(srt1.equals("-"))
							srt1 = "0";
						if(srt2.equals("-"))
							srt2 = "0";

						if(new Double(srt1)>new Double(srt2))
							return -1;
						else if(new Double(srt1)<new Double(srt2))
							return 1;
						else
							return 0;
					}
				});
				JSONObject gridObj = new JSONObject();
				JSONObject gridCol = new JSONObject();
				gridCol.put("ICON","&nbsp;");
				gridCol.put("USERNAME",intlmap.getTextDescription("reporter.common.User Name"));
				if(haveGuestName)
				{
					gridCol.put("GUESTNAME",intlmap.getTextDescription("reporter.common.Guest Name"));
				}
				gridCol.put("TOTAL_SESSION",intlmap.getTextDescription("reporter.common.Total Sessions"));
				gridCol.put("HIGHIDLESESSION",intlmap.getTextDescription("reporter.common.Sessions With High Idle Time"));
				gridCol.put("DURATIONUI",intlmap.getTextDescription("reporter.common.Total Duration"));
				gridCol.put("ACTIVETIMEUI",intlmap.getTextDescription("reporter.common.Active Time"));
				gridCol.put("IDLE_TIMEUI",intlmap.getTextDescription("reporter.common.Idle Time"));
				gridCol.put("PCT_IDLE_TIME",intlmap.getTextDescription("reporter.common.Idle Time")+" (%)");

				v_measure_csv.add(intlmap.getTextDescription("reporter.common.User Name"));
				if(haveGuestName)
				{
					v_measure_csv.add(intlmap.getTextDescription("reporter.common.Guest Name"));
				}
				v_measure_csv.add(intlmap.getTextDescription("reporter.common.Total Sessions"));
				v_measure_csv.add(intlmap.getTextDescription("reporter.common.Sessions With High Idle Time"));
				v_measure_csv.add(intlmap.getTextDescription("reporter.common.Total Duration"));
				v_measure_csv.add(intlmap.getTextDescription("reporter.common.Active Time"));
				v_measure_csv.add(intlmap.getTextDescription("reporter.common.Idle Time"));
				v_measure_csv.add(intlmap.getTextDescription("reporter.common.Idle Time")+" (%)");

				gridObj.put("gridCol",gridCol);
				gridObj.put("gridData",gridDataList);
				data.put("gridObj",gridObj);
			}
		}
		else
		{
			data.put("noMeasures",intlmap.getTextDescription("reporter.common.No measures available for the current selection"));
			lst.add(intlmap.getTextDescription("reporter.common.No measures available for the current selection"));
			// no measure functionality
		}

		Hashtable h_tabrc = new Hashtable();	//SubTable Data
		Hashtable h_tab = new Hashtable();	//SubTitle with SubTable Data
		String s_title = "";

		h_tabrc.put(v_measure_csv,list_data);
		h_tab.put(s_title,h_tabrc);
		lst.add(h_tab);
		if(lst!= null && !lst.isEmpty())
		{
			session.setAttribute("list",lst);
		}

		activeIdleObj.put("data",data);
		activeIdleObj.put("selectionDetails",selectionDetails);
		Map parameters = new HashMap();
		parameters= request.getParameterMap();
		String queryString =(String)ErUtils.prepareQueryString(request.getParameterMap());
		String Qstring="";
		String lastAccessQstring="";
		if(queryString!=null)
		{
			StringTokenizer strtok = new StringTokenizer(queryString,"&");
			while(strtok.hasMoreTokens())
			{
				String param = strtok.nextToken();
				int ind = param.indexOf("=");
				if (ind < 0)
					continue;
				String reqparam =param.substring(0,ind);
				String value = param.substring(ind+1);
				if(reqparam!=null&&reqparam.equals("userID"))
				{
					value=com.eg.EgURLEncoder.encode(value, "UTF-8");
				}
				 if(reqparam!=null&&reqparam.equals("uid"))
				{
					value=com.eg.EgURLEncoder.encode(value, "UTF-8");
				}
				if(reqparam!=null&&reqparam.equals("er_user"))
				{
					value=com.eg.EgURLEncoder.encode(value, "UTF-8");
				}
				 if(reqparam!=null && ( reqparam.equals("startdate") || reqparam.equals("enddate") || reqparam.equals("inidate") || reqparam.equals("pdfTime") || reqparam.equals("select_testmes") || reqparam.equals("er_workgrpname") || reqparam.equals("er_trgttype") || reqparam.equals("limitforbg") || reqparam.equals("er_timeline") || reqparam.equals("er_usertimeline")  || reqparam.equals("limitforbg") || reqparam.equals("limitforbg")|| reqparam.equals("er_info")) )
				{
					value=com.eg.EgURLEncoder.encode(value, "UTF-8");
				}
				
				lastAccessQstring=lastAccessQstring+reqparam+"="+value+"&";
						
				if(reqparam!=null&&reqparam.equals("er_component"))
				{
					continue;
				}
				 if(reqparam!=null&&reqparam.equals("er_user"))
				{
					//continue;
				}

			//
				Qstring=Qstring+reqparam+"="+value+"&";
			}
			Qstring=Qstring;
		}
		Qstring+="&pageWidthProces="+pageWith;
		String dataProcess = mngrIProc+"/final/reporter/ErActiveIdleUserReportPrint.jsp;jsessionid="+ session.getId()+"?"+Qstring;

			session.setAttribute("MAIL_URL",dataProcess);
				HashMap hmQry = ErUtils.parseQueryString(Qstring);
				String targetType = "";
				if(hmQry != null && hmQry.get("er_trgttype") instanceof String)
				{
					targetType = (String)hmQry.get("er_trgttype");
				}
				else if(hmQry != null && hmQry.get("er_trgttype") instanceof String[])
				{
					targetType = ((String[])hmQry.get("er_trgttype"))[0];
				}
				if (targetType != null && targetType.equalsIgnoreCase("ActiveIdle+Users"))
				{
					hmQry.remove("er_component");
				}
				String qString = ErUtils.prepareQueryString(hmQry);
				urlFields.put("saveQueryString",qString);
		//
		ArrayList listbackvar = new  ArrayList();
		if(request.getParameter("isSubmit")!=null)
		{
			session.setAttribute("reportLastAccessedURL","/final/reporter/ErActiveIdleUserReport.jsp?"+lastAccessQstring);
			listbackvar.add("/servlet/com.eg.ErActiveIdleUserReportC?");
			listbackvar.add("status="+status+"&bggroundStr="+bggroundStr+"&"+queryString);
			session.setAttribute("favSchBackDisplay","Yes");
		}
		else
		{
			session.setAttribute("reportLastAccessedURL","/final/reporter/ErActiveIdleUserReport.jsp?"+lastAccessQstring);
			listbackvar.add("ErActiveIdleUserReport.jsp");
			listbackvar.add(queryString);
			session.setAttribute("favSchBackDisplay","No");
		}
		session.setAttribute("reportLastAccessedURL","/final/reporter/ErActiveIdleUserReport.jsp?"+lastAccessQstring);
		String backadded = erhelputils.getBackID();
		backreqMap = erhelputils.setBackQueryMap(backreqMap,backadded,listbackvar);
		session.setAttribute("backQuery",backreqMap);

		//Back button - End




		activeIdleObj.put("selectedFields",selectedFields);
		activeIdleObj.put("hiddenFields",hiddenFields);
		activeIdleObj.put("combo",combo);
		activeIdleObj.put("labelFields",labelFields);
		activeIdleObj.put("urlFields",urlFields);
		
		out.println(activeIdleObj.toString());
}
catch(Throwable t)
{
	t.printStackTrace();
}

	//For Setting the PDf File Name
	HashMap paramVal =new HashMap();
	paramVal.put("fileName","ActiveIdle_Users");
	session.setAttribute("parameters", paramVal);
%>
<%!
public synchronized JSONArray getJSONComboFromList(List list,String infoVal,EgMappingInfo intlmap)
 {
	JSONArray arr=new JSONArray();
	JSONObject obj=null;
	if(list !=null && list.size()>0)
	{
		
		for (int i=0;i<list.size();i++)
		{
			String text=(String)list.get(i);
			obj=new JSONObject();
			obj.put("displayField",text);
			obj.put("valueField",text);
			arr.add(obj);
		}	
	}else{
	obj=new JSONObject();
	obj.put("displayField",intlmap.getTextDescription("reporter.common.Not Applicable"));
	obj.put("valueField","-1");
	arr.add(obj);
	}
	return arr;
 }
 %>

 <%!
   
    public  String customReplaceAll(String source,String toReplace,String replacement) {
        int idx = source.lastIndexOf(toReplace);
        if (idx != -1) {
            StringBuffer ret = new StringBuffer(source);
            ret.replace(idx, idx + toReplace.length(), replacement);
            while ((idx = source.lastIndexOf(toReplace, idx - 1)) != -1) {
                ret.replace(idx, idx + toReplace.length(), replacement);
            }
            source = ret.toString();
        }
        return source;
    }
    public  double getDoubleValue(String inputStr)
	{
        double returnVal = 0;
		try
		{
			returnVal = Double.parseDouble(inputStr);
		}
		catch(Exception e)
		{}
        return returnVal;
    }
%>