<%
/********************************************************************************************************
*	Name			:	zoneComponent.jsp
*	Purpose			:	This jsp is used to Display System Tab in zoneDashboard and display 						Measures Value configured for componentType in each Zones
*	Version			:	5.4
*	CreationDate	:	nov 29 2011
*	Author			:	S.Saravanan
*******************************************************************************************************/
%>
<%@ include file = "EgMonitorTracker.jsp" %>
<%@ page errorPage = "EgProbsM.jsp" %>
<%@ taglib prefix = "egui" uri = "../WEB-INF/eg-taglib.tld"%>
<%@ page import = "com.egurkha.ini.IniUI"%>
<%@ page import = "com.egurkha.*"%>
<%@ page import = "com.eg.*"%>
<%@ page import = "com.egurkha.util.*" %>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page import = "com.egurkha.monitor.VmDashboardHelper"%>
<%@ page import = "com.egurkha.monitor.ServicesDashboardBean"%>
<%@ page import = "com.egurkha.User"%>
<%@ page import = "com.egurkha.UserRegistry"%>
<%@ page import = "java.text.DecimalFormat"%> 
<%@ page import = "java.util.Enumeration"%>
<%@ page import="com.eg.EgURLEncoder" %>
<%@ page import="net.sf.json.*"%>
<%@page import = "java.util.*"%>
<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page import = "com.eg.supermanager.*" %>
<%@ page import = "com.eg.EgInstallInfo" %>
<%@ page import = "com.eg.EgURLEncoder" %>
<%@ page import="com.egurkha.admin.EgMaintenanceUtility"%>
<%@ page import = "com.eg.EgConfigChangeThread"%>
<%@ page import = "com.eg.EgAggregateInfo" %>
<%@ page import="com.fasterxml.jackson.databind.ObjectMapper"%>
<%@ page import="com.fasterxml.jackson.databind.node.ArrayNode"%>
<%@ page import="com.fasterxml.jackson.databind.node.ObjectNode"%>
<%@ page import="com.fasterxml.jackson.databind.JsonNode"%>
<%
	if(EgInstallInfo.isSuperManager)
	{
		String currentSession = session.getId();
		if(EgSMDBHelper.paramsOfJSP.containsKey(currentSession))
		{
			EgSMDBHelper.paramsOfJSP.remove(currentSession);
		}
		String selected_Param=request.getParameter("selectedParam");
		if(selected_Param != null && (selected_Param=selected_Param.trim()).length()>0)
		{
			ArrayList managerIDs = EgElementInfo.getInstance().getManagerIDs("zone",selected_Param);
			if(managerIDs != null && !managerIDs.isEmpty())
			{
				SmSessionData smsData = new SmSessionData(currentSession,managerIDs);
				EgThreadLocal egtl = new EgThreadLocal();
				egtl.set(smsData);
				new SMDateTimeConverter(managerIDs);				
			}
		}
	}
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader ("Expires", -1);
	response.setContentType("application/json");
	request.setCharacterEncoding("UTF-8");

	String smeasure="";
	String stest="";
	String key = "";
	String compType = "";
	String compName = "";
	String compState = "";
	String dispComp = "";
	String url = "";
	String site = "";
	String sdispName="";
	String testMeasure[] = null;
	String measureValue="";
	String dbMeasure = "";
	int colCount = 0;
	boolean cell_color=false;
	String compTest="";
	String compMeasure="";
	String CompDispName="";
	String widthOfTheHead="";
	String dbMeasureName="";
	String displayUnit="";
	String unitMeasure="";
	String Measureurl = "";
	String hostNameToken[]=null;
	String hostName = "";
	String hostPort  = "";
	String msmtHost = "";
	String db_Measureandtest="";
	Enumeration e = null;
	EgDbInfo dbInfo = new EgDbInfo("manager");
	EgTablesInfo tablesInfo = new EgTablesInfo("manager");
	EgExternalInfo egExternalInfo=new EgExternalInfo("manager");
	EgSpecsInfo specsInfo = new EgSpecsInfo("manager");
	EgAggregateInfo aggregateInfo = new EgAggregateInfo("manager");
	EgDateInfo dateInfo=new EgDateInfo();
	EgMaintenanceInfo egM=new EgMaintenanceInfo("manager");
	EgMaintenanceUtility maintenanceUtil=new EgMaintenanceUtility();

	UserRegistry registry = UserRegistry.getInstance();
	User user = registry.getUser(session.getId());
	String uiFile = "eg_ui.ini";
	String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile egUI = new IniFile(s_iniFile_dir + uiFile);
	com.eg.IniFile egDashConfig = new com.eg.IniFile(s_iniFile_dir+"eg_dashboardConfig.ini");
	
	com.eg.IniFile enduserIni = new com.eg.IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_endUserDetails.ini", false);
	String endUserIniEntry[]=enduserIni.getVariables("USER_TYPE_COMPONENTS");
	String skipUserTypeEntry[]=enduserIni.getVariables("SKIP_USERTYPE_UED_MENU");
	List skipUserTypeList = null;
	if(skipUserTypeEntry!=null && skipUserTypeEntry.length>0)
		skipUserTypeList = Arrays.asList(skipUserTypeEntry);
	Hashtable endUserLinkHash = new Hashtable();
	if(endUserIniEntry != null && endUserIniEntry.length > 0){
		for(int k=0;k<endUserIniEntry.length;k++){
			String el = endUserIniEntry[k];
			//if(el == null || el.trim().length() == 0 || el.equalsIgnoreCase("Terminal") )
			if(el == null || el.trim().length() == 0 || el.startsWith("App") || el.startsWith("CitrixXenVDI") || el.startsWith("VDIESX") || (skipUserTypeList!=null && skipUserTypeList.contains(el)))
				continue;
			String elLits = (String)enduserIni.getValue("USER_TYPE_COMPONENTS",el);
			ArrayList tmpMeasureList = new ArrayList(); 
			tmpMeasureList = StringUtils.egTokenizer(elLits,",",true,false,true);//param 3-->includeEmpty,4-->unique,5-->trim
			if(tmpMeasureList!=null && tmpMeasureList.size()>0){
				for(int l=0;l<tmpMeasureList.size();l++)
					endUserLinkHash.put((String)tmpMeasureList.get(l),el);
			}
			
		}
	}

	EgName nameObj1 = null;
	ServicesDashboardBean serviceBean = new ServicesDashboardBean();
	String subj="TREE_APPLICATION";

	String currenthost=request.getParameter("appCurrentHost");
	String selectedParam=request.getParameter("selectedParam");
	String treeTitle = request.getParameter("treeTitle");
	treeTitle=(treeTitle==null)?"":treeTitle;
	String selectedNode = request.getParameter("selectedNode");

	String measure_sort=request.getParameter("appcolumn");
	measure_sort=(measure_sort==null)?"":measure_sort;
	String sort_type=request.getParameter("appsortOrder");
	sort_type=(sort_type==null)?"":sort_type;
	String imageId=request.getParameter("appimgId");
	//String aggregateTab = request.getParameter("aggregateTab");
	String parentZone=request.getParameter("parentZone");
	String fromHomepage=request.getParameter("fromHomepage");
	fromHomepage=(fromHomepage==null)?"":fromHomepage;
	String csrfToken = request.getParameter("com.eg.CSRF_NONCE");
	csrfToken = (csrfToken==null||csrfToken.trim().length()==0)?"":csrfToken;

	if(imageId==null)
	{
		imageId="";
	}
	
	IniUI iniUI = IniUI.getInstance();
	String thisLanguage = iniUI.getDefaultLanguage();
	//EgMappingInfo mappingInfo = new EgMappingInfo(thisLanguage);
	String userId = "";
	if (user!=null)
	{
		String userLang = user.getLanguage();
		if (userLang!=null && !userLang.equalsIgnoreCase("NULL"))
		{
			thisLanguage=userLang;
		}
		userId = user.getLoginID();
	}
	boolean isUserLanguageEnglish=true;
	if(thisLanguage!=null && !thisLanguage.equals("en_US"))
	{
		isUserLanguageEnglish=false;
	}

	boolean userViolated = false;
	ArrayList userBasedCompTypeList = new ArrayList(); 
	if(userId !=null && userId.trim().length()>0)
	{
		com.eg.GroupCertValidator licenseChecker = new com.eg.GroupCertValidator(userId);
		userViolated = licenseChecker.checkForUserViolation(userId);
		if(userViolated)
		{
			com.eg.EgUsersInfo usersInfo = new com.eg.EgUsersInfo();
			userBasedCompTypeList = (ArrayList)usersInfo.getAllUserBasedCompTypes();
		}
	}

	int headerLength=18;
	ArrayList compType_list=new ArrayList();
	String imgsrc="";

	ObjectMapper mapper = new ObjectMapper();
	ObjectNode json  = mapper.createObjectNode();
	ArrayNode  columns = mapper.createArrayNode();
	ArrayNode  measures = mapper.createArrayNode();
	ObjectNode selectFieldData  = mapper.createObjectNode();
	ArrayNode  selectOptions = mapper.createArrayNode();
	ObjectNode sortByMainOptions  = mapper.createObjectNode();
	ArrayNode  sortByOptions = mapper.createArrayNode();
	ObjectNode pageParams = mapper.createObjectNode();
	pageParams.put("fromPageView", "zoneComponent");

	//request.setAttribute("jsonObject",json);
	//request.setAttribute("category","zone");
	//request.setAttribute("itemName",selectedParam);

	ArrayList aggregateArrayZone = aggregateInfo.getAggregateComponentsOfElement("zone",selectedParam);
	if(aggregateArrayZone != null && aggregateArrayZone.size() > 0)
	{
		json.put("aggregateTab","true");
	}
	else
	{
		json.put("aggregateTab","false");
	}

	%>
		<%//@ include file="aggregateTabHandler.jsp" %>
	<%
	
	EgList applicationComponent =null;
	applicationComponent = serviceBean.getComponentsForZone(treeTitle,selectedParam,"");
	EgUserRole userRole = user.getUserRole();
	boolean hasConfigSupport = userRole.hasAnyConfigRole(EgUserPermission.CONFIG);
	Hashtable ht_changeHash = EgConfigChangeThread.ht_changeHash;
	
	//EgList applicationComponent = serviceBean.getComponentsForSelection(treeTitle,selectedParam,"");
	EgList componentList=new EgList();//1

	EgList temp_applicationComponent=new EgList();
	if(applicationComponent!=null && applicationComponent.size()>0 && userBasedCompTypeList!=null && userBasedCompTypeList.size()>0)
	{
		for(int k=0;k<applicationComponent.size();k++)
		{
			EgComponent component = (EgComponent)applicationComponent.get(k);
			String tem_compType = component.getType();
			if(userBasedCompTypeList!=null && userBasedCompTypeList.size()>0 && userBasedCompTypeList.contains(tem_compType))
				continue;
			temp_applicationComponent.add(component);
		}

		applicationComponent=new EgList();
		if(temp_applicationComponent!=null && temp_applicationComponent.size()>0)
		{
			for(int k=0;k<temp_applicationComponent.size();k++)
			{
				EgComponent component = (EgComponent)temp_applicationComponent.get(k);
				applicationComponent.add(component);
			}
		}
	}

	String excludedCompType=egDashConfig.getValue("EXCLUDED_TYPES_IN_METRICS_VIEW","Types");
	ArrayList excludedCompTypeList=new ArrayList(); 
	if(excludedCompType!=null && excludedCompType.trim().length()>0)
	{
		StringTokenizer tokenComp=new StringTokenizer(excludedCompType,",");
		if(tokenComp!=null)
		{
			while(tokenComp.hasMoreTokens())
			{
				String com_Type=(String)tokenComp.nextToken();
				excludedCompTypeList.add(com_Type);
			}
		}
	}

	temp_applicationComponent=new EgList();
	if(applicationComponent!=null && applicationComponent.size()>0 && excludedCompTypeList!=null && excludedCompTypeList.size()>0)
	{
		for(int k=0;k<applicationComponent.size();k++)
		{
			EgComponent component = (EgComponent)applicationComponent.get(k);
			String tem_compType = component.getType();
			if(excludedCompTypeList!=null && excludedCompTypeList.size()>0 && !excludedCompTypeList.contains(tem_compType))
			{
				temp_applicationComponent.add(component);
			}
		}

		applicationComponent=new EgList();
		if(temp_applicationComponent!=null && temp_applicationComponent.size()>0)
		{
			for(int k=0;k<temp_applicationComponent.size();k++)
			{
				EgComponent component = (EgComponent)temp_applicationComponent.get(k);
				applicationComponent.add(component);
			}
		}
	}

if(applicationComponent!=null && applicationComponent.size() > 0 )
{
	for(int c = 0; c < applicationComponent.size(); c++)
	{
		EgComponent component = (EgComponent)applicationComponent.get(c);
		String componentTypeVal = component.getType();
		if(currenthost==null || currenthost.equalsIgnoreCase("null") || currenthost.length()<1)
		{
			//if current host is null means get the first comp in the list 
			//currenthost=disp_compName; 
			currenthost=componentTypeVal; 
		}
		if(componentTypeVal.equalsIgnoreCase(currenthost))
		{
			componentList.add(component);//2
		}
		if(!compType_list.contains(componentTypeVal))
		{
			compType_list.add(componentTypeVal);
		}
		//Collections.sort(compType_list);
	}
}

ArrayList tempCompList=new ArrayList();
for(int k=0;k<compType_list.size();k++)
{
	String tempComp=(String)compType_list.get(k);
	if(tempComp!=null)
	{
		tempCompList.add(tempComp);
		tempCompList.add(mappingInfo.getComponentTypeDescription(tempComp));
	}
}
Hashtable measureData = serviceBean.getTestMeasureData(componentList,subj,currenthost);
Hashtable temp_Table = serviceBean.getApplicationTestMeasureList(subj,currenthost);

Hashtable measureList =new Hashtable();
ArrayList keyList=new ArrayList();
Enumeration enumer; 
if(temp_Table!=null && temp_Table.size()>0)
{
	enumer = temp_Table.keys(); 
	while(enumer.hasMoreElements())
	{
		keyList=(ArrayList)enumer.nextElement();
		measureList=(Hashtable)temp_Table.get(keyList);
	}
}
	
TreeMap treeMap = new TreeMap(); 
ArrayList comp_value=new ArrayList();
Enumeration hash_key=null;

EgList compList=new EgList();
EgList tempList=new EgList();
List comNameSort=new ArrayList();
if(measure_sort!=null && !measure_sort.equalsIgnoreCase("undefined") && !measure_sort.equalsIgnoreCase("") && !measure_sort.equalsIgnoreCase("null") && !measure_sort.equalsIgnoreCase("-2"))
{
	hash_key=measureData.keys();
	ArrayList noMeasureComp=new ArrayList();
	while(hash_key.hasMoreElements())
	{
		String measure_key=(String)hash_key.nextElement();
		if(measure_key!=null && measure_key.length()>0)
		{
			StringTokenizer st = new StringTokenizer(measure_key, "^"); 
			while(st.hasMoreTokens())
			{ 
				String comp = st.nextToken(); 
				String measure = st.nextToken();
				boolean dup_val=false;
				ArrayList temp=new ArrayList();
				if(measure.equalsIgnoreCase(measure_sort))
				{
					String measure_value=(String)measureData.get(measure_key);//get value from measure data 
					if(measure_value!=null && measure_value.equalsIgnoreCase("-"))
					{
						measure_value="0.0";
						noMeasureComp.add(comp);
					}
					Float temp_data = new Float(Float.parseFloat(measure_value));
					if(treeMap!=null && treeMap.size()>0)
					{
						ArrayList temp1=new ArrayList();
						dup_val=treeMap.containsKey(temp_data);
						//if the value is duplicated, add the comp in arrayList for particular Component
						if(dup_val)
						{
							Object ob=treeMap.get(temp_data);
							if(ob instanceof String)
							{
								temp1.add((String)ob);
							}
							else if(ob instanceof ArrayList)
							{
								temp1=(ArrayList)ob;
							}
							if(temp1!=null && temp1.size()>0)
							{
								for(int k=0;k<temp1.size();k++)
								{
									temp.add(temp1.get(k));
								}
							}
							temp.add(comp);
							treeMap.put(temp_data,temp);
						}
					}
					if(dup_val==false)
					{
						treeMap.put(temp_data,comp);
					}
				}
			}
		}
	}
	Collections.sort(noMeasureComp);
	if(treeMap!=null && treeMap.size()>0)
	{
		Set set = treeMap.entrySet(); //itreate and get add the value in list from treeset
		// Get an iterator 
		Iterator itr = set.iterator(); 
		// Display elements 
		while(itr.hasNext()) 
		{ 
			Map.Entry me = (Map.Entry)itr.next(); 
			Object comp_obj=me.getValue();
			if(comp_obj instanceof String)
			{
				if(!noMeasureComp.contains(comp_obj))
				{
					comp_value.add(comp_obj);
				}
			}
			else if(comp_obj instanceof ArrayList)
			{
				ArrayList al=new ArrayList();//if treemap contain component in arraylist itrate and add in another list 
				al=(ArrayList)comp_obj;
				for(int k=0;k<al.size();k++)
				{
					if(!noMeasureComp.contains(al.get(k)))
						comp_value.add(al.get(k));
				}
			}
		}
		//Add the no measure component after the sorting
		for(int j=0;j<noMeasureComp.size();j++)
		{
			comp_value.add(noMeasureComp.get(j));
		}

		//reverse the component in reverse, to sort in decending order
		if(sort_type.equalsIgnoreCase("DESC") || sort_type.equalsIgnoreCase("descending"))
		{
			ArrayList tempList2=new ArrayList();
			for(int k=comp_value.size()-1;k>=0;k--)//for desc
			{
				String temp3=(String)comp_value.get(k);
				if(noMeasureComp!=null && !noMeasureComp.contains(temp3))
					tempList2.add(temp3);
			}
			//after reverse the component list ,add the no mesure comp at the last
			for(int j=0;j<noMeasureComp.size();j++)
			{
				tempList2.add(noMeasureComp.get(j));
			}
			comp_value=tempList2;
			tempList2=null;

		}
		for(int j=0;j<comp_value.size();j++)
		{
			String comp_value_temp=(String)comp_value.get(j);
			for(int k=0;k<componentList.size();k++)
			{
				EgComponent comp = (EgComponent)componentList.get(k);
				String compName1 = comp.getName();
				StringTokenizer str = new StringTokenizer(compName1, ":"); 
				while(str.hasMoreTokens())
				{ 
					String list_name = str.nextToken(); 
					if(list_name.equalsIgnoreCase(comp_value_temp))
					{
						if(!compList.contains(comp))
						{
							compList.add(comp);
						}
						if(tempList.contains(comp))
						{
							tempList.remove(comp);
						}
					}
					else if(!tempList.contains(comp) && !compList.contains(comp))
					{
						tempList.add(comp);
					}
				}
			}
		}
		 //EgList tempList1=new EgList();
		componentList=null;
		componentList=new EgList();
		for(int k=0;k<compList.size();k++)
		{
			EgComponent comp_tem= (EgComponent)compList.get(k);
			componentList.add(comp_tem);
		}
		for(int k=0;k<tempList.size();k++)
		{
			EgComponent comp_tem= (EgComponent)tempList.get(k);
			componentList.add(comp_tem);
		}
		/*
		//reverse the component componentList in reverse to sort in decending order
		if(sort_type.equalsIgnoreCase("descending"))
		{
			for(int k=componentList.size()-1;k>=0;k--)//for desc
			{
				//EgComponent comp_tem= (EgComponent)tempList.get(k);
				tempList1.add(componentList.get(k));
			}
			componentList=tempList1;
		}
		*/
	}
}
if(measure_sort!=null && measure_sort.equalsIgnoreCase("-2") )
	{
		if (componentList != null && componentList.size() > 0)
		{
			for(int k=0;k<componentList.size();k++)
			{
				EgComponent comp = (EgComponent)componentList.get(k);
				String compNameStr = comp.getName();
				comNameSort.add(compNameStr);
				comNameSort.add((EgComponent)comp);
				if (comNameSort != null && comNameSort.size() > 0)
				{
					EgSorter esort = new EgSorter(comNameSort, 2);
					comNameSort = esort.sort(1, "String", "asc");
				}
			}
		}
		componentList=null;
		componentList=new EgList();
		if (comNameSort != null && comNameSort.size() > 0)
		{
			for (int i = 0; i < comNameSort.size(); i += 2)
			{
				String compNameLi = (String) comNameSort.get(i);
				EgComponent comObject = (EgComponent) comNameSort.get(i + 1);
				componentList.add(comObject);
			}
		}
	}
	selectFieldData.put("selectFieldLabel",mappingInfo.getTextDescription("monitor.common.Type"));
	
	ArrayList sortedCompType=new ArrayList();
	if(tempCompList!=null && tempCompList.size()>0)
	{
		EgSorter esort=new EgSorter(tempCompList,2);
		sortedCompType=(ArrayList)esort.sort(2,"String","asc");
	}

	if(sortedCompType!=null && sortedCompType.size()>0)
	{
		for(int k=0;k<sortedCompType.size();k+=2)
		{
			String comp_temp=(String)sortedCompType.get(k);
			//String temp=(String)sortedComp.get(k);
			String compDispName=(String)sortedCompType.get(k+1);

			ObjectNode option  = mapper.createObjectNode();
			option.put("value",comp_temp);
			option.put("name",compDispName);
			selectOptions.add(option);
			
			if(currenthost.equalsIgnoreCase(comp_temp))
			{
				selectFieldData.put("selectedValue",comp_temp);
				
			}
		}
		selectFieldData.put("selectOptions",selectOptions);
	}
	else
	{
		ObjectNode option  = mapper.createObjectNode();
		option.put("value","-1");
		option.put("name","Not Applicable!");
		selectOptions.add(option);
		selectFieldData.put("selectedValue","-1");
		selectFieldData.put("selectOptions",selectOptions);
	}
	
	//String disp_info=egUI.getValue("TREE_SYSTEM_SETTINGS","DisplayAllComp");
	String disp_info=egDashConfig.getValue("TREE_SYSTEM_SETTINGS","DisplayAllComp");
	if(disp_info.equalsIgnoreCase("no"))
	{
		//To remove the component which has no measure
		if(componentList!=null && componentList.size() > 0)
		{
			if(measureData!=null)
			{
				//EgList tempcomponentList=componentList;
				int measure_len=measureList.size();
				for(int k = 0; k< componentList.size(); k++)
				{
					int count_mes=0;
					EgComponent component = (EgComponent)componentList.get(k);
					String dispCom = component.getDisplayName();
					//int colCnt = 0;
					String s_test="";
					String s_measure="";
					//Iterator iterator3 = measureList.keySet().iterator();
					for(int i=0;i<keyList.size();i++)
					{
						String key_measure = (String)keyList.get(i);
						String unit_Measure = (String)measureList.get(key_measure);
						String []test_Meas = StringUtils.getTokens(key_measure,":");

						if(test_Meas!=null)
						{
							s_test = test_Meas[0];
							s_measure = test_Meas[1];
						}
						String db_Measure =  dbInfo.getColumnForMeasure(s_test,s_measure);
						if(db_Measure!=null && !db_Measure.equals(""))
							s_measure = db_Measure;
						if(s_measure!=null)
						{
							s_measure=s_test+":"+s_measure;
						}
						if(dispCom.indexOf(":") > -1)
							dispCom = dispCom.substring(0,dispCom.indexOf(":"));
						String measure_Value = (String)measureData.get(dispCom +"^"+s_measure);
						if(measure_Value== null)
						{
							measure_Value="-";
						}
						if(measure_Value.equalsIgnoreCase("-"))
						{
							count_mes++;
						}
						//colCnt++;
					}
					//if total no of measure equal to tot no of empty measure means remove the comp....
					if(count_mes==measure_len)
					{
						componentList.remove(k);
						k--;
					}
				}
			}
		}
	}

	int pages=0;
	int recount=0;
	int pagesizec=0;
	int pageSize = 0;
	String Default_Pagesize=egDashConfig.getValue("TREE_SYSTEM_SETTINGS","Default_Pagesize");
	Default_Pagesize=(Default_Pagesize==null || Default_Pagesize.trim().length()==0)?"10":Default_Pagesize;
	pageSize=Integer.parseInt(Default_Pagesize.trim());

	ObjectNode countJson= mapper.createObjectNode();
	recount=componentList.size();
	pagesizec=recount/pageSize;

	//System.out.println("recount--->>>"+recount);
	//System.out.println("pagesizec--->>>"+pagesizec);
	int tem = recount;
	int mod = tem%pageSize;
	if(mod > 0)
		pagesizec=pagesizec+1;

	System.out.println("pagesizec-mod-->>>"+pagesizec);
	countJson.put("recount",recount);
	countJson.put("pagesizec",pageSize);
	countJson.put("totalPages",pagesizec);
	if(pagesizec<=1)
		countJson.put("isHidePaging",new Boolean(true));
	else
		countJson.put("isHidePaging",new Boolean(false));

	String pageNoReq = request.getParameter("pageNo");
	if(pageNoReq==null || pageNoReq.trim().length()==0 || pageNoReq.equalsIgnoreCase("null"))
		pageNoReq="1";
	int pageStartIndex = 0;
	int pageEndIndex = pageSize;
	int pageNum = 1;
	try
	{
		pageNum = Integer.parseInt(pageNoReq.trim());
		pageNum = (pageNum == 0 )?1:pageNum;
		if(pageNum==1)
		{
			pageStartIndex=0;
			//pageEndIndex = pageStartIndex+(pageSize-1);//10+10-1
			pageEndIndex = pageSize+pageStartIndex;
		}
		else 
		{
			//pageStartIndex=((pageNum-1)*pageSize);//2-1*10
			//pageEndIndex = pageStartIndex+(pageSize-1);//10+10-1
			pageStartIndex = (pageNum*pageSize)-pageSize;
			pageEndIndex = pageSize+pageStartIndex;
		}
	}
	catch(Exception ee)
	{
		ee.printStackTrace();
		pageNum=1;
	}

		//System.out.println("pageStartIndex-mod-->>>"+pageStartIndex);
		//System.out.println("pageEndIndex-mod-->>>"+pageEndIndex);
		//System.out.println("measureList--->>>"+measureList);

System.out.println("measureList -> "+measureList);
	if(measureList!=null && measureList.size()>0)
	{
		if(componentList !=null && componentList.size() > 0)
		{
			ObjectNode columnObj  = mapper.createObjectNode();
			columnObj.put("text",mappingInfo.getTextDescription("monitor.common.Components"));
			String SortForCompName="-2";
			if(measure_sort!=null && measure_sort.equalsIgnoreCase("-1"))
				SortForCompName="-2";
			else if(measure_sort!=null && measure_sort.equalsIgnoreCase("-2"))
				SortForCompName="-1";
			columnObj.put("SortForCompName",SortForCompName);
			String SortTypeForCompName="ASC";
			if(sort_type!=null && sort_type.equalsIgnoreCase("DESC"))
			{
				SortTypeForCompName="ASC";
			}
			else if(sort_type!=null && sort_type.equalsIgnoreCase("ASC"))
			{
				SortTypeForCompName="DESC";
			}
			columnObj.put("SortTypeForCompName",SortTypeForCompName);
			columns.add(columnObj);
			
			if(sort_type!=null && sort_type.length()>0)
			{
				if(sort_type.equalsIgnoreCase("ascending"))
				{
					imgsrc="/final/monitor/eg_images/arrow_up_black_small.gif";
				}
				else if(sort_type.equalsIgnoreCase("descending"))
				{
					imgsrc="/final/monitor/eg_images/arrow_down_black_small.gif";
				}
			}
			sortByMainOptions.put("sortByLabel",mappingInfo.getTextDescription("monitor.common.Sort By"));
			ObjectNode Sortbytypeoption  = mapper.createObjectNode();
			Sortbytypeoption.put("value","-1");
			Sortbytypeoption.put("name",mappingInfo.getTextDescription("monitor.common.---State---"));
			sortByOptions.add(Sortbytypeoption);
			Sortbytypeoption  = mapper.createObjectNode();
			Sortbytypeoption.put("value","-2");
			Sortbytypeoption.put("name",mappingInfo.getTextDescription("monitor.common.---Component---"));
			sortByOptions.add(Sortbytypeoption);
			if(measure_sort!=null && measure_sort.equalsIgnoreCase("-2"))
				sortByMainOptions.put("sortBySelectedMeasure","-2");
			else if(measure_sort==null)
				sortByMainOptions.put("sortBySelectedMeasure","-1");

			if(measureList!=null && measureList.size() > 0)
			{
				int k=1;
				//Iterator iterator1 = measureList.keySet().iterator();
				String keyVal="";
				for(int i=0;i<keyList.size();i++)
				{
					keyVal = (String)keyList.get(i);
					String testMeas[] = StringUtils.getTokens(keyVal,":");
					if(testMeas!=null)
					{
						compTest = testMeas[0];
						compMeasure = testMeas[1];
						CompDispName = testMeas[2];
					}
					String db_Measure =  dbInfo.getColumnForMeasure(compTest,compMeasure);
					db_Measureandtest=compTest+":"+db_Measure;
					if(measure_sort!=null && measure_sort.trim().length()>0 && measure_sort.equals(db_Measureandtest))
					{
						sortByMainOptions.put("sortBySelectedMeasure",db_Measureandtest);
					}
					Sortbytypeoption  = mapper.createObjectNode();
					Sortbytypeoption.put("value",db_Measureandtest);
					Sortbytypeoption.put("name",CompDispName);
					sortByOptions.add(Sortbytypeoption);

					widthOfTheHead="80";
					dbMeasureName =  dbInfo.getColumnForMeasure(compTest,compMeasure);
					if(dbMeasureName.length()==0)
					{
						dbMeasureName=compMeasure;
					}
					if(dbMeasureName!=null)
					{
						dbMeasureName=compTest+":"+dbMeasureName;
					}
					String imgeId="sortImg"+k;
					if(imageId.equalsIgnoreCase(imgeId))
					{
						columnObj  = mapper.createObjectNode();
						//columnObj.put("text",CompDispName);
						columnObj.put("text",mappingInfo.getTextDescription("monitor.common."+CompDispName));
						columns.add(columnObj);
					}
					else
					{
						columnObj  = mapper.createObjectNode();
						//columnObj.put("text",CompDispName);
						columnObj.put("text",mappingInfo.getTextDescription("monitor.common."+CompDispName));
						columns.add(columnObj);
					}
					k++;
				}
				//Iterator iterator2 = measureList.keySet().iterator();
				for(int i=0;i<keyList.size();i++)
				{
					key = (String)keyList.get(i);
					StringTokenizer tok = new StringTokenizer(key,":");
					int s=0;
					String s_measureFun=null;
					String temp_arr[]=new String[4];
					while (tok.hasMoreTokens())
					{
						temp_arr[s]=tok.nextToken();
						s++;
					}
					if(s==4)
					{
						String s_test=temp_arr[0];
						String s_measure=temp_arr[1];
						try
						{
							String specify_info=egDashConfig.getValue("TREE_SYSTEM_INFO",s_test);
							if(specify_info!=null && specify_info.trim().length()>0)
							{
								s_measureFun=null;
							}
							else
							{
								s_measureFun=temp_arr[3];
							}
						}
						catch(Exception eee)
						{
							eee.printStackTrace();
							s_measureFun=null;
						}
						if(s_measureFun!=null && (s_measureFun.equalsIgnoreCase("Average") || s_measureFun.equalsIgnoreCase("Avg")))
						{
							s_measureFun = "Avg";
						}
						unitMeasure = tablesInfo.getUnitForMeasure(s_test,s_measure);
						//tablesInfo=null;
					}
					else
					{
						//s_measureFun = "Avg";
						unitMeasure = (String)measureList.get(key);
					}
					
					//displayUnit = "&nbsp;"+unitMeasure;
					if(s_measureFun!=null && s_measureFun.trim().length()>0)
					{
						displayUnit = ""+mappingInfo.getTextDescription("monitor.common."+s_measureFun)+" ("+unitMeasure+")";
					}
					else
					{
						if(unitMeasure!=null && unitMeasure.trim().length()>1)
							displayUnit = "("+mappingInfo.getTextDescription("monitor.common."+unitMeasure)+")";
						else
							displayUnit = "("+unitMeasure+")";
					}

					widthOfTheHead="80";
					if(unitMeasure.equals("%"))
					{
						//displayUnit = unitMeasure;
						widthOfTheHead="100";
					}
					else if(unitMeasure.equals("MB"))
					{
						if(s_measureFun!=null && s_measureFun.trim().length()>0)
						{
							displayUnit = ""+mappingInfo.getTextDescription("monitor.common."+s_measureFun)+" ("+mappingInfo.getTextDescription("monitor.VirtualDashboard.GB")+")";
						}
						else
						{
							displayUnit = "("+mappingInfo.getTextDescription("monitor.VirtualDashboard.GB")+")";
						}
					}

					//columns.getJSONObject(i+1).put("unit",displayUnit);

					ObjectNode tmp_objNode= (ObjectNode)columns.get(i+1);
					tmp_objNode.put("unit",displayUnit);
				}
			}
			int measure_header_len=-1;
			if(componentList!=null && componentList.size() > 0 )
			{
				String currdate = dateInfo.egetDate(false);
				int componentList_count=0;
				if(componentList.size()>=pageEndIndex)
				{
					componentList_count=pageEndIndex;
				}
				else if(componentList.size()<pageEndIndex)
				{
					//componentList_count=componentList.size();
					componentList_count=componentList.size();
				}
				for(int c = pageStartIndex; c < componentList_count; c++)
				{
					ObjectNode measure  = mapper.createObjectNode();
					EgComponent component = (EgComponent)componentList.get(c);
					compType = component.getType();
					compName = component.getName();
					compState = (component.getState()).getName();
					dispComp = component.getDisplayName();
					if(selectedNode!=null && selectedNode.indexOf("(")>-1)
					{
						site = selectedNode.substring(0,selectedNode.indexOf("("));
					}
					else
						site = "NULL";

					String trgthost=component.getName();
					if(trgthost!=null && trgthost.indexOf(":")>-1)
						trgthost=trgthost.substring(0,trgthost.indexOf(":"));
					trgthost=trgthost+":NULL";

					String serverName=component.getName();
					String sid="";
					StringTokenizer tokServer=new StringTokenizer(serverName,":");
					int tokens=tokServer.countTokens();
					String sname=tokServer.nextToken();
					String portno=tokServer.nextToken();
					if(tokens==3)
						sid=tokServer.nextToken();
					boolean isHostMaintenance=egM.isItMaintenanceTime(currdate,sname,"","",true);
					boolean isComponentMaintenance=egM.isItMaintenanceTime(currdate,sname,portno,sid,true);
					List  maintenaceTimePeriod=new ArrayList();
					List tempMaintenanceList=null;
					if(isHostMaintenance)
					{
						tempMaintenanceList=egM.getMaintenancePeriods(sname,"","",true);
						if(tempMaintenanceList!=null && tempMaintenanceList.size()>0)
							maintenaceTimePeriod.addAll(tempMaintenanceList);
						tempMaintenanceList=egM.getUnplannedMaintenancePeriods(sname,"","",true);
						if(tempMaintenanceList!=null && tempMaintenanceList.size()>0)
							maintenaceTimePeriod.addAll(tempMaintenanceList);
					}
					if(isComponentMaintenance)
					{
						tempMaintenanceList=egM.getMaintenancePeriods(sname,portno,sid,true);
						if(tempMaintenanceList!=null && tempMaintenanceList.size()>0)
						{
							maintenaceTimePeriod.addAll(tempMaintenanceList);
						}
						tempMaintenanceList=egM.getUnplannedMaintenancePeriods(sname,portno,sid,true);
						if(tempMaintenanceList!=null && tempMaintenanceList.size()>0)
							maintenaceTimePeriod.addAll(tempMaintenanceList);
					}
					int noOfLines=maintenaceTimePeriod.size();
					String maintenaceTimePeriodStr=maintenanceUtil.convertMaintenacevectorToString(maintenaceTimePeriod,user);

					boolean configChanged = ((ht_changeHash.containsKey(component.getName()) || ht_changeHash.containsKey(trgthost)) &&EgInstallInfo.isConfigSupported && hasConfigSupport);
					boolean isTestRelevantForServer = false;
					if(configChanged)
					{
						ArrayList temp_list=(ArrayList) ht_changeHash.get(component.getName());
						if(temp_list==null || temp_list.size()==0)
							temp_list= (ArrayList) ht_changeHash.get(trgthost);
						if(temp_list!=null && temp_list.size()>0)
						{
							for(int k=0;k<temp_list.size();k++)
							{
								String temp_test_name=(String)temp_list.get(k);
								if(temp_test_name!=null && temp_test_name.trim().length()>0)
								{
									isTestRelevantForServer = specsInfo.isTestRelevantForServer(component.getType(),temp_test_name);
								}
								if(isTestRelevantForServer)
									break;
							}
							
							if(isTestRelevantForServer)
								configChanged=true;
							else
								configChanged=false;
						}
						else
							configChanged=false;
					}
					ArrayList aggregateArrayZC = aggregateInfo.getAggregateComponentsOfElement("zone",selectedParam);

					boolean aggregateTab =false;
					if(aggregateArrayZC != null && aggregateArrayZC.size() > 0)
						aggregateTab = true;
					

					url = "/final/servlet/com.eg.EgDashboardController?from=list&site="+EgURLEncoder.encode(site,"UTF-8")+"&qctr=0&comptype="+compType+ "&host="+EgURLEncoder.encode(compName,"UTF-8")+"&tab=LayerModel&toDashBoardLayer=true&treeTitle=zone&selectNode=Zone$cap$"+selectedParam+"&selectedParam="+selectedParam+"&currentTab=components&appCurrentHost=null&fromHomepage="+fromHomepage+"&treeOpen=false&openNode=null&aggregateTab="+aggregateTab+"&zoneComponent=true&parentZone="+parentZone;
					if(csrfToken!=null && csrfToken.trim().length()>0 && !csrfToken.equalsIgnoreCase("null"))
						url = url + "&com.eg.CSRF_NONCE="+csrfToken;

					String trBackground="eg_lightlight";
					if(c%2==0)
					{
						trBackground="eg_whitebg";
					}
					measure.put("systemIconClass","state_"+component.getState().getName());
					//measure.put("systemIconTitle",component.getState().getName());
					measure.put("systemIconTitle",mappingInfo.getLabelDescription(component.getState().getName()));
					measure.put("layerModelUrl",url);
					measure.put("systemTitle",dispComp);
					//measure.put("system",StringUtils.egSubString(dispComp,isUserLanguageEnglish,headerLength,15));
					measure.put("system",dispComp);
					
					if(endUserLinkHash != null && endUserLinkHash.containsKey(compType)){
						String getUserType = (String)endUserLinkHash.get(compType);
						String temp_comp_name  = dispComp;
						if(dispComp.indexOf(":") == -1)
							temp_comp_name += ":NULL";
						String end_url="/final/monitor/endUserDashboard.jsp?fromMetricView=true&fromctx=true&access=allusers&userType="+getUserType+"&fromMenu=true&vdiType="+compType+":"+temp_comp_name;
						end_url = end_url+"&currentTab=components&appCurrentHost=null&treeOpen=false&openNode=null"+"&fromHomepage="+fromHomepage+"&aggregateTab="+aggregateTab+"&selectNode=Zone$cap$"+selectedParam+"&selectedParam="+selectedParam+"&zoneComponent=true&parentZone="+parentZone;

						if(csrfToken!=null && csrfToken.trim().length()>0 && !csrfToken.equalsIgnoreCase("null"))
								end_url = end_url + "&com.eg.CSRF_NONCE="+csrfToken;
						measure.put("endUserUrl",end_url);
						if(getUserType.equalsIgnoreCase("VDI"))
							measure.put("endUserText","VM Details");
						else
							measure.put("endUserText","User Details");
					}

					if(isHostMaintenance || isComponentMaintenance)
					{
						measure.put("MaintenanceTime",maintenaceTimePeriodStr);
						measure.put("NoOfLines",noOfLines);
					}
					
					if(configChanged)//  Configuraion Image changes 111
					{
						measure.put("configChange",component.getName()+":"+component.getType());
					}

					colCount = 0;
					//Iterator iterator4 = measureList.keySet().iterator();
					for(int i=0;i<keyList.size();i++)
					{
						key = (String)keyList.get(i);
						StringTokenizer tok = new StringTokenizer(key,":");
						int s=0;
						String s_measureFun=null;
						String temp_arr[]=new String[4];
						while (tok.hasMoreTokens())
						{
							temp_arr[s]=tok.nextToken();
							s++;
						}
						if(s==4)
						{
							String s_test=temp_arr[0];
							String s_measure=temp_arr[1];
							s_measureFun=temp_arr[3];
							//unitMeasure = tablesInfo.getUnitForMeasure(s_test,s_measure);
							if(s_measureFun!=null && (s_measureFun.equals("Average") || s_measureFun.equals("Avg")))
							{
								unitMeasure = tablesInfo.getUnitForMeasure(s_test,s_measure);
								if(unitMeasure!=null && unitMeasure.equals("%"))
								{
									unitMeasure="%";
								}
								else
								{
									unitMeasure=s_measureFun;
								}
							}
							else if(s_measureFun!=null && (s_measureFun.equalsIgnoreCase("Sum") || s_measureFun.equalsIgnoreCase("Max") || s_measureFun.equalsIgnoreCase("Min")))
							{
								unitMeasure = s_measureFun;
							}
							else
							{
								unitMeasure = tablesInfo.getUnitForMeasure(s_test,s_measure);
							}
							//tablesInfo=null;
						}
						else
						{
							unitMeasure = (String)measureList.get(key);
						}

						testMeasure = StringUtils.getTokens(key,":");
						String org_mea="";
						if(testMeasure!=null)
						{
							stest = testMeasure[0];
							smeasure = testMeasure[1];
							org_mea = smeasure;
							sdispName = testMeasure[2];
						}
						dbMeasure =  dbInfo.getColumnForMeasure(stest,smeasure);
						if(dbMeasure!=null && !dbMeasure.equals(""))
							smeasure = dbMeasure;
						if(smeasure!=null)
						{
							smeasure=stest+":"+smeasure;
						}
						if(dispComp.indexOf(":") > -1)
							dispComp = dispComp.substring(0,dispComp.indexOf(":"));
						HashSet Info=(HashSet)measureData.get(dispComp +"^"+smeasure+":INFO");
						measureValue = (String)measureData.get(dispComp +"^"+smeasure);
						if(measureValue == null)
						{
							measureValue = "-";
						}
						DecimalFormat df= new DecimalFormat("#0.00");
						double measure_val=0;
						if(measureValue!=null && !measureValue.equalsIgnoreCase("-"))
						{
							if(measureValue!=null && (measureValue.indexOf("Yr")> -1 || measureValue.indexOf("Mth")> -1 || measureValue.indexOf("Day")> -1 ||  measureValue.indexOf("Hr")> -1 || measureValue.indexOf("Min")> -1 || measureValue.indexOf("Sec")> -1 ))
							{
								measureValue=measureValue;
								int tmp_measure_header_len=0;
								if(measureValue.indexOf("Yr")> -1)
								{
									tmp_measure_header_len=(measureValue.length()*11);
								}
								else if(measureValue.indexOf("Mth")> -1)
								{
									tmp_measure_header_len=(measureValue.length()*10);
								}
								else
								{
									tmp_measure_header_len=(measureValue.length()*9);
								}
								
								if(tmp_measure_header_len>measure_header_len)
									measure_header_len=tmp_measure_header_len;
							}
							else
							{
								measure_val= Double.parseDouble(measureValue);
								measureValue=df.format(measure_val);
								String temp=measureValue.substring(measureValue.indexOf(".")+1,measureValue.length());

								if(temp.equals("00"))
								{
									measureValue=measureValue.substring(0,measureValue.indexOf("."));
								}
							}
						}
						if(measureValue!=null && (measureValue.equalsIgnoreCase("0.0") || measureValue.equalsIgnoreCase("0.00")))
						{
							measureValue="0";
						}
						String testToUtl="";
						hostNameToken=StringUtils.getTokens(compName,":");
						if(hostNameToken!=null && hostNameToken.length>0)
						{
							hostName = hostNameToken[0];
							hostPort = hostNameToken[1];
						}

						boolean portReleventForTest = specsInfo.isPortRelevantForTest(stest);
						String compNameToUrl=compName;
						if(!portReleventForTest)
						{
							hostPort="NULL";
							//compNameToUrl=hostName+":NULL";
						}
						ArrayList layersForComp = tablesInfo.getLayersForComponent(compType);
						List agents=egExternalInfo.getAgentsFor(stest,compType,hostName);
						if(agents!=null && agents.size()>0)
							msmtHost=(String)agents.get(0);
						else
							msmtHost=hostName;
						String Layer_name_str=tablesInfo.getLayerForTest(stest);
						String layerName="HOST";
						if(Layer_name_str!=null && Layer_name_str.trim().length()>0)
						{
							StringTokenizer tokenLayer=new StringTokenizer(Layer_name_str,",");
							if(tokenLayer!=null)
							{
								while(tokenLayer.hasMoreTokens())
								{
									String l_name=(String)tokenLayer.nextToken();
									if(l_name!=null)
									{
										if(layersForComp!=null && layersForComp.contains(l_name))
										{
											if(tablesInfo.isMeasureInLayer(stest,org_mea,l_name))
											{
												layerName=l_name;
												break;
											}
										}
									}
								}
							}
						}
						
						if(Info!=null && Info.size()==1)
						{
							String infoFirst=Info.iterator().next().toString();
							if(infoFirst!=null && infoFirst.trim().length()>0 && (!infoFirst.startsWith("+")) && infoFirst.endsWith("+"))
							{
								testToUtl=stest+"-+";
							}
							else if(infoFirst!=null && infoFirst.trim().length()>0 && (!infoFirst.startsWith("+")) && (!infoFirst.endsWith("+")))
							{
								testToUtl=stest+"-"+infoFirst.substring(infoFirst.indexOf("+"));
							}
							else if(infoFirst!=null && infoFirst.trim().length()>0)
							{
								testToUtl=stest+"-"+infoFirst;
							}
							else
							{
								testToUtl=stest+"-+";
							}

							Measureurl="/final/monitor/EgSiteInfraView.jsp?qctr=2&fromalarm=&host="+EgURLEncoder.encode(compNameToUrl,"UTF-8")+"&layer="+EgURLEncoder.encode(layerName,"UTF-8")+"&site="+site+"&msmt_host="+EgURLEncoder.encode(msmtHost,"UTF-8")+"&test="+EgURLEncoder.encode(testToUtl,"UTF-8")+"&comptype="+EgURLEncoder.encode(compType,"UTF-8")+"&tstate="+compState+"&newWindow=false&prevPage=MainDashBoard&treeTitle=zone&selectNode=Zone$cap$"+selectedParam+"&selectedParam="+selectedParam+"&currentTab=components&appCurrentHost=null&fromHomepage="+fromHomepage+"&treeOpen=false&openNode=null&aggregateTab="+aggregateTab+"&zoneComponent=true&parentZone="+parentZone;
							
						}
						else if(Info!=null && Info.size()>1)
						{
							testToUtl="null-+";
							Measureurl="/final/monitor/EgSiteInfraView.jsp?qctr=1&fromalarm=&host="+EgURLEncoder.encode(compNameToUrl,"UTF-8")+"&layer="+EgURLEncoder.encode(layerName,"UTF-8")+"&site="+site+"&msmt_host="+EgURLEncoder.encode(msmtHost,"UTF-8")+"&test="+EgURLEncoder.encode(testToUtl,"UTf-8")+"&comptype="+EgURLEncoder.encode(compType,"UTF-8")+"&tstate="+compState+"&newWindow=false&prevPage=MainDashBoard&treeTitle=zone&selectNode=Zone$cap$"+selectedParam+"&selectedParam="+selectedParam+"&currentTab=components&appCurrentHost=null&fromHomepage="+fromHomepage+"&treeOpen=false&openNode=null&aggregateTab="+aggregateTab+"&zoneComponent=true&parentZone="+parentZone;
							
						}
						else
						{
							testToUtl="null-+";
							Measureurl="/final/monitor/EgSiteInfraView.jsp?qctr=1&fromalarm=&host="+EgURLEncoder.encode(compNameToUrl,"UTF-8")+"&layer="+EgURLEncoder.encode(layerName,"UTF-8")+"&site="+site+"&msmt_host="+EgURLEncoder.encode(msmtHost,"UTF-8")+"&test="+EgURLEncoder.encode(testToUtl,"UTF-8")+"&comptype="+EgURLEncoder.encode(compType,"UTF-8")+"&tstate="+compState+"&newWindow=false&prevPage=MainDashBoard&treeTitle=zone&selectNode=Zone$cap$"+selectedParam+"&selectedParam="+selectedParam+"&currentTab=components&appCurrentHost=null&fromHomepage="+fromHomepage+"&treeOpen=false&openNode=null&aggregateTab="+aggregateTab+"&zoneComponent=true&parentZone="+parentZone;
							
						}
						String columnWith="180";
						String testName=stest.toLowerCase();
						if(testName!=null && testName.indexOf("uptime")>-1)
						{
							columnWith=String.valueOf(measure_header_len);
							//columns.getJSONObject(i+1).put("columnWith", columnWith);
							ObjectNode tmp_objNode= (ObjectNode)columns.get(i+1);
							tmp_objNode.put("columnWith",columnWith);
						}

						ObjectNode tmp_objNode2= (ObjectNode)columns.get(i+1);
						tmp_objNode2.put("textType","asFloat");
						tmp_objNode2.put("dataIndex",i+"MeasureValue");
						tmp_objNode2.put("measureOrgName",smeasure);

						//columns.getJSONObject(i+1).put("textType","asFloat");
						//columns.getJSONObject(i+1).put("dataIndex",i+"MeasureValue");
						//columns.getJSONObject(i+1).put("measureOrgName",smeasure);
						String sortty="DESC";
						if(sort_type!=null && sort_type.equalsIgnoreCase("DESC"))
						{
							sortty="ASC";
						}
						else if(sort_type!=null && sort_type.equalsIgnoreCase("ASC"))
						{
							sortty="DESC";
						}
						//columns.getJSONObject(i+1).put("sortType",sortty);
						tmp_objNode2.put("sortType",sortty);
						measure.put(i+"MeasureValue",measureValue);

						if(measureValue!=null && !measureValue.equals("-"))
						{
							if(unitMeasure.equals("%"))
							{
								int columnWidth = 100;
								Long tempValue=new Long(Math.round(Double.parseDouble(measureValue)));
								long fillColorValue=tempValue.longValue();
								long tempValue2 = (fillColorValue*100)/columnWidth;
								measure.put(i+"MeasureValueWidth",String.valueOf(tempValue2));
							}
							if(csrfToken!=null && csrfToken.trim().length()>0 && !csrfToken.equalsIgnoreCase("null"))
								Measureurl = Measureurl + "&com.eg.CSRF_NONCE="+csrfToken;
							measure.put(i+"MeasureValueUrl",Measureurl);
						}
						colCount++;
					}
					measures.add(measure);
				}
			}
		}
		ObjectNode labelObj= mapper.createObjectNode();
		labelObj.put("monitor.zoneDashboard.noDataMsg",mappingInfo.getTextDescription("monitor.common.No Data found"));
		labelObj.put("monitor.zoneDashboard.systemTitle",mappingInfo.getTextDescription("monitor.zoneDashboard.Key Performance Indicators for zone")+" : "+selectedParam);
		json.put("columns",columns);
		json.put("measures",measures);
		json.put("screenLabels",labelObj);
		json.put("pageParams", pageParams);
		sortByMainOptions.put("sortByOptions",sortByOptions);
		json.put("sortByMainOptions",sortByMainOptions);
		json.put("selectFieldData",selectFieldData);
		json.put("countJson",countJson);
		System.out.println("json -> "+json);
		response.getWriter().write(json.toString());
	}else{
		if(componentList !=null && componentList.size() > 0)
		{
			ObjectNode columnObj  = mapper.createObjectNode();
			columnObj.put("text",mappingInfo.getTextDescription("monitor.common.Components"));
			String SortForCompName="-2";
			if(measure_sort!=null && measure_sort.equalsIgnoreCase("-1"))
				SortForCompName="-2";
			else if(measure_sort!=null && measure_sort.equalsIgnoreCase("-2"))
				SortForCompName="-1";
			columnObj.put("SortForCompName",SortForCompName);
			String SortTypeForCompName="ASC";
			if(sort_type!=null && sort_type.equalsIgnoreCase("DESC"))
			{
				SortTypeForCompName="ASC";
			}
			else if(sort_type!=null && sort_type.equalsIgnoreCase("ASC"))
			{
				SortTypeForCompName="DESC";
			}
			columnObj.put("SortTypeForCompName",SortTypeForCompName);
			columns.add(columnObj);
			columnObj  = mapper.createObjectNode();
			columnObj.put("text","");
			columnObj.put("unit","");
			columnObj.put("dataIndex","0MeasureValue");
			columns.add(columnObj);
			String currdate = dateInfo.egetDate(false);
			for(int c = 0; c < componentList.size(); c++)
			{
				ObjectNode measure  = mapper.createObjectNode();
				if(selectedNode!=null && selectedNode.indexOf("(")>-1)
					site = selectedNode.substring(0,selectedNode.indexOf("("));
				else
					site = "NULL";
				ArrayList aggregateArrayZC = aggregateInfo.getAggregateComponentsOfElement("zone",selectedParam);
				boolean aggregateTab =false;
				if(aggregateArrayZC != null && aggregateArrayZC.size() > 0)
					aggregateTab = true;
				EgComponent component = (EgComponent)componentList.get(c);
				compType = component.getType();
				compName = component.getName();
				dispComp = component.getDisplayName();
				measure.put("systemIconClass","state_"+component.getState().getName());
				measure.put("systemIconTitle",mappingInfo.getLabelDescription(component.getState().getName()));
				url = "/final/servlet/com.eg.EgDashboardController?from=list&site="+EgURLEncoder.encode(site,"UTF-8")+"&qctr=0&comptype="+compType+ "&host="+EgURLEncoder.encode(compName,"UTF-8")+"&tab=LayerModel&toDashBoardLayer=true&treeTitle=zone&selectNode=Zone$cap$"+selectedParam+"&selectedParam="+selectedParam+"&currentTab=components&appCurrentHost=null&fromHomepage="+fromHomepage+"&treeOpen=false&openNode=null&aggregateTab="+aggregateTab+"&zoneComponent=true&parentZone="+parentZone;
					if(csrfToken!=null && csrfToken.trim().length()>0 && !csrfToken.equalsIgnoreCase("null"))
						url = url + "&com.eg.CSRF_NONCE="+csrfToken;
				measure.put("layerModelUrl",url);
				measure.put("systemTitle",dispComp);
				measure.put("system",dispComp);
				measure.put("0MeasureValue","No metrics configured");
				measures.add(measure);
			}
			json.put("columns",columns);
			json.put("pageParams", pageParams);
			json.put("measures",measures);
		}
		else
			json.put("error",mappingInfo.getTextDescription("monitor.common.No metrics configured"));

		ObjectNode labelObj= mapper.createObjectNode();
		labelObj.put("monitor.zoneDashboard.systemTitle",mappingInfo.getTextDescription("monitor.zoneDashboard.Key Performance Indicators for zone")+" : "+selectedParam);
		json.put("screenLabels",labelObj);
		json.put("selectFieldData",selectFieldData);
		json.put("countJson",countJson);
		
		response.getWriter().write(json.toString());
	}
try
{
	String qString=request.getQueryString();
	if(qString!=null)
	{
		//qString+="&showDashboard='1'";
		if(qString.indexOf("action")>-1)
		{
			session.setAttribute("monitorLastSession","/final/monitor/zoneDash.jsp?monCmd=zoneList&currentTab=components&from=MainDashboard&"+qString);
		}
		else
		{
			session.setAttribute("monitorLastSession","/final/monitor/zoneDash.jsp?monCmd=zoneList&currentTab=components&from=MainDashboard&refresh=true&action=zone&"+qString);
		}
	}
	else
	{
		session.setAttribute("monitorLastSession","/final/monitor/zoneDash.jsp?monCmd=zoneList&from=MainDashboard&showDashboard='1'");
	}
}
catch(Exception exp)
{
	System.out.println("Exception in zonesDashboard Component..");
	exp.printStackTrace();
}
%>
