<%
/**********************************************************
*	Name				:	segmentTree.jsp
*	Purpose				:	Tree for segment Dashboard
*	Version				:	5.6
*	Author				:	S.Saravanan 
*	Creation Date		:	Feb 20,2012
**********************************************************/
%>
<%@ include file = "EgMonitorTracker.jsp" %>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld"%>
<%@page import="com.egurkha.monitor.*"%>
<%@page import="java.util.*"%>
<%@page import="java.lang.StringBuffer"%>
<%@ page import = "com.egurkha.ini.IniUI" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page import="net.sf.json.*"%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json");
	String treeTitle = request.getParameter("treeTitle");
	String str = request.getParameter("str");
	String node = request.getParameter("node");
	String closeSameLevelStr = request.getParameter("closeSameLevel");
	if(treeTitle == null)
		treeTitle = "Tree";
	boolean closeSameLevel = false;
	if("true".equalsIgnoreCase(closeSameLevelStr))
	{
		closeSameLevel = true;
	}
	if(str == null)
		str = "";
	String nodeURLParams = request.getParameter("nodeURLParams");
	if(str.equalsIgnoreCase("sessionID"))
	{
		str = session.getId();
	}
	IniUI ui = (IniUI) IniUI.getInstance();
	String refreshTime = ui.getRefreshTime("EgDashboard");

	Hashtable treeTable = new Hashtable();
	String className = request.getParameter("tree");
	String width = request.getParameter("width");
	SegmentTree treeObj = getTreeInstance(className, node);

	JSONObject json = treeObj.getTreeJson(str);
	
	response.getWriter().write(json.toString());
%>
<%!
	public SegmentTree getTreeInstance(String className, String nodeName)
	{
		SegmentTree treeObj;
		LayerModelTree lTree;
		SegmentTreeModel segmentTree;
		try
		{
	 		Class invoker = Class.forName("com.egurkha.monitor." + className);
			Object invokerIns =invoker.newInstance();
			if(className.equals("LayerModelTree"))
			{
				if(nodeName != null && !nodeName.equals(""))
				{
					lTree = (LayerModelTree)invokerIns;
					lTree.setSelectedNode(nodeName);
				}
			}
			if(className.equals("SegmentTreeModel"))
			{
				if(nodeName != null && !nodeName.equals(""))
				{
					segmentTree = (SegmentTreeModel)invokerIns;
					segmentTree.setSelectedNode(nodeName);
				}
			}
			treeObj = (SegmentTree)invokerIns;
		}
		catch (java.lang.ClassNotFoundException c)
		{
			c.printStackTrace();
			return null;
		}
		catch (java.lang.InstantiationException c)
		{
			c.printStackTrace();
			return null;
		}
		catch (java.lang.IllegalAccessException c)
		{
			c.printStackTrace();
			return null;
		}
		return treeObj;
	}
%>
