<%
/********************************************************************************************************
*	Name			:	segmentComponent.jsp
*	Purpose			:	This jsp is used to Display System Tab in segmentDashboard and display 						Measures Value configured for component in each segments
*	Version			:	5.4
*	CreationDate	:	nov 29 2011
*	Author			:	SriDevi Gururajan and S.Saravanan
*******************************************************************************************************/
%>
<%@ include file = "EgMonitorTracker.jsp" %>
<%@ page errorPage = "EgProbsM.jsp" %>
<%@ taglib prefix = "egui" uri = "../WEB-INF/eg-taglib.tld"%>
<%@ page import = "com.egurkha.ini.IniUI"%>
<%@ page import = "com.egurkha.*"%>
<%@ page import = "com.egurkha.util.*"%>
<%@ page import = "com.eg.*"%>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page import = "com.egurkha.monitor.VmDashboardHelper"%>
<%@ page import = "com.egurkha.monitor.ServicesDashboardBean"%>
<%@ page import = "com.egurkha.User"%>
<%@ page import = "com.egurkha.UserRegistry"%>
<%@ page import = "java.util.Enumeration"%>
<%@ page import = "java.util.*"%>
<%@ page import = "java.text.DecimalFormat"%>
<%@ page import = "net.sf.json.*"%>
<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page import = "com.eg.supermanager.*" %>
<%@ page import = "com.eg.EgInstallInfo" %>
<%@ page import = "com.eg.EgURLEncoder" %>
<%@ page import="com.egurkha.admin.EgMaintenanceUtility"%>
<%@ page import = "com.eg.EgConfigChangeThread"%>
<%
	if(EgInstallInfo.isSuperManager)
	{
		String currentSession = session.getId();
		String select_Node=request.getParameter("selectedParam");
		if(select_Node != null && (select_Node=select_Node.trim()).length()>0)
		{
			String current_thread_name = Thread.currentThread().getName();
			ArrayList managerIDs = EgElementInfo.getInstance().getManagerIDs("segment",select_Node);
			if(managerIDs != null && !managerIDs.isEmpty())
			{
				SmSessionData smsData = new SmSessionData(currentSession,managerIDs);
				EgThreadLocal egtl = new EgThreadLocal();
				egtl.set(smsData);
				new SMDateTimeConverter(managerIDs);				
			}
		}
	}
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader ("Expires", -1);
	response.setContentType("application/json");
	request.setCharacterEncoding("UTF-8");

	int c = 0;
	int colCount = 0;
	boolean cell_color=false;
	String key = "";
	String stest = "";
	String smeasure = "";
	String sdispName = "";
	String unitMeasure = "";
	String displayUnit = "";
	String dbMeasure = "";
	String measureValue = "";
	String compType = "";
	String compName = "";
	String compState = "";
	String dispComp = "";
	String url = "";
	String site = "";
	String testMeas[] = null;
	String widthOfTheHead="";
	String Measureurl = "";
	String hostNameToken[]=null;
	String hostName = "";
	String hostPort  = "";
	String msmtHost = "";
	String db_Measureandtest="";

	EgTablesInfo tablesInfo = new EgTablesInfo("manager");
	EgDbInfo dbInfo = new EgDbInfo("manager");
	EgSpecsInfo specsInfo = new EgSpecsInfo("manager");
	EgExternalInfo egExternalInfo=new EgExternalInfo("manager");

	EgDateInfo dateInfo=new EgDateInfo();
	EgMaintenanceInfo egM=new EgMaintenanceInfo("manager");
	EgMaintenanceUtility maintenanceUtil=new EgMaintenanceUtility();

	IniUI iniUI = IniUI.getInstance();
	String thisLanguage = iniUI.getDefaultLanguage();
	//EgMappingInfo mappingInfo = new EgMappingInfo(thisLanguage);
	UserRegistry registry = UserRegistry.getInstance();
	User user = registry.getUser(session.getId());
	String uiFile = "eg_ui.ini";
	String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile egUI = new IniFile(s_iniFile_dir + uiFile);
	com.eg.IniFile egDashConfig = new com.eg.IniFile(s_iniFile_dir+"eg_dashboardConfig.ini");

	
	if (user!=null)
	{
		String userLang = user.getLanguage();
		if (userLang!=null && !userLang.equalsIgnoreCase("NULL"))
		{
			thisLanguage=userLang;
		}
	}
	boolean isUserLanguageEnglish=true;
	if(thisLanguage!=null && !thisLanguage.equals("en_US"))
	{
		isUserLanguageEnglish=false;
	}
	int headerLength=18;
	String selectedNode = request.getParameter("selectedParam");

	String priority = request.getParameter("priority");
	String treeTitle = request.getParameter("treeTitle");
	treeTitle=(treeTitle==null)?"":treeTitle;
	String measure_sort=request.getParameter("appcolumn");
	measure_sort=(measure_sort==null)?"":measure_sort;
	String sort_type=request.getParameter("appsortOrder");
	sort_type=(sort_type==null)?"":sort_type;
	String imageId=request.getParameter("imgId");
	String aggregateTab = request.getParameter("aggregateTab");
	String fromHomepage=request.getParameter("fromHomepage");

	String parentZone = request.getParameter("parentZone");
	parentZone=(parentZone==null)?"":parentZone;

	String iszoneName = request.getParameter("iszoneName");
	iszoneName=(iszoneName==null)?"":iszoneName;

	String isFromZone = request.getParameter("isFromZone");
	isFromZone=(isFromZone==null)?"":isFromZone;
	fromHomepage=(fromHomepage==null)?"":fromHomepage;
	String csrfToken = request.getParameter("com.eg.CSRF_NONCE");
	csrfToken = (csrfToken==null||csrfToken.trim().length()==0)?"":csrfToken;

	//String limit=request.getParameter("limit");
	if(imageId==null)
	{
		imageId="";
	}
	String selectedTab = "System";
	priority=(priority==null)?"":priority;
	ServicesDashboardBean serviceBean = new ServicesDashboardBean();
	EgList compList=new EgList();
	EgDiscInfo discInfo = new EgDiscInfo("manager");

	JSONObject json  = new JSONObject();
	JSONArray  columns = new JSONArray();
	JSONArray  measures = new JSONArray();
	JSONObject pageParams = new JSONObject();
	pageParams.put("fromPageView", "segmentSystem");

	request.setAttribute("jsonObject",json);
	request.setAttribute("category","segment");
	request.setAttribute("itemName",selectedNode);

	%>
		<%@ include file="aggregateTabHandler.jsp" %>
	<%
	
	/*
	Get the components under the service
	*/
	EgUserRole userRole = user.getUserRole();
	boolean hasConfigSupport = userRole.hasAnyConfigRole(EgUserPermission.CONFIG);
	Hashtable ht_changeHash = EgConfigChangeThread.ht_changeHash;
	EgList componentList =null;
	componentList = serviceBean.getComponentsForSegment(treeTitle,selectedNode,"");

	String selectedSystemCompType = request.getParameter("appCurrentHost");
	String realselectedSystemCompType= (selectedSystemCompType!= null && selectedSystemCompType.trim().length()>0 )?selectedSystemCompType:"";
	if(selectedSystemCompType == null || selectedSystemCompType.trim().length()==0 || selectedSystemCompType.equalsIgnoreCase("NULL"))
	{
		selectedSystemCompType = "TreeSystem";
	}

	Hashtable temp_Table = serviceBean.getTestMeasureList(false,selectedSystemCompType);
	Hashtable measureList =new Hashtable();
	ArrayList keyList=new ArrayList();
	Enumeration enumer; 
	if(temp_Table!=null && temp_Table.size()>0)
	{
		enumer = temp_Table.keys();
		while(enumer.hasMoreElements())
		{
			keyList=(ArrayList)enumer.nextElement();
			measureList=(Hashtable)temp_Table.get(keyList);
		}
	}
	//Ini entry based System View changed - code start 	

	JSONObject selectFieldData  = new JSONObject();
	JSONArray  selectOptions = new JSONArray();
	JSONObject sortByMainOptions  = new JSONObject();
	JSONArray  sortByOptions = new JSONArray();

	if(componentList!=null && componentList.size()>0)
	{
		String systemCompType[] = egDashConfig.getVariables("TREE_SYSTEM");
		String excludedCompType=egDashConfig.getValue("EXCLUDED_TYPES_IN_SYSTEMS_VIEW","Types");
		ArrayList excludedCompTypeList=new ArrayList(); 
		if(excludedCompType!=null && excludedCompType.trim().length()>0)
		{
			StringTokenizer tokenComp=new StringTokenizer(excludedCompType,",");
			if(tokenComp!=null)
			{
				while(tokenComp.hasMoreTokens())
				{
					String com_Type=(String)tokenComp.nextToken();
					excludedCompTypeList.add(com_Type);
				}
			}
		}
		ArrayList comtypeIniVar = new ArrayList(Arrays.asList(systemCompType));
		String systemrealCompType = "";
		HashSet cmpSet = new HashSet(); 
		for(int d=0;d<componentList.size();d++)
		{
			EgComponent component = (EgComponent)componentList.get(d);
			String compTyp=component.getType();
			cmpSet.add(compTyp);
			if(systemrealCompType.length() == 0 && !excludedCompTypeList.contains(compTyp))
				systemrealCompType = compTyp;
		}
		ArrayList sortedCompType=new ArrayList();
		Hashtable compTypHash=new Hashtable();
		if(comtypeIniVar != null && comtypeIniVar.size()>0)
		{
			for(int k=0;k<comtypeIniVar.size();k++)
			{
				String cmptypStr =(String)comtypeIniVar.get(k);
				if(cmptypStr.equalsIgnoreCase("TreeSystem"))//TreeSystem
				{
					sortedCompType.add("Common Systems");
					compTypHash.put("Common Systems",cmptypStr);
				}
				else
				{
					if(cmpSet!= null && cmpSet.contains(cmptypStr))
					{
						String dispCmpTypStr = mappingInfo.getComponentTypeDescription(cmptypStr);
						sortedCompType.add(dispCmpTypStr);
						compTypHash.put(dispCmpTypStr,cmptypStr);
					}
				}
				
			}
		}

		if(sortedCompType != null && ((sortedCompType.size()==1 && !sortedCompType.contains("Common Systems")) || sortedCompType.size()>1))
		{
			 if(realselectedSystemCompType.trim().length() == 0 && systemrealCompType.trim().length()>0)
					selectedSystemCompType = systemrealCompType;
			selectFieldData.put("selectFieldLabel",mappingInfo.getTextDescription("monitor.common.Type"));
			if(sortedCompType!=null && sortedCompType.size()>1)
			{
				EgSorter esort=new EgSorter(sortedCompType,1);
				sortedCompType=(ArrayList)esort.sort(1,"String","asc");
			}

			if(sortedCompType!=null && sortedCompType.size()>0 && compTypHash != null && compTypHash.size()>0)
			{
				for(int j=0;j<sortedCompType.size();j++)
				{
					String compDispName = (String)sortedCompType.get(j);
					if(compTypHash.containsKey(compDispName))
					{
						String comp_temp = (String)compTypHash.get(compDispName);
						JSONObject option  = new JSONObject();
						option.put("value",comp_temp);
						if(compDispName.equalsIgnoreCase("Common Systems"))
							option.put("name",mappingInfo.getTextDescription("monitor.common.Common Systems"));
						else
							option.put("name",compDispName);
						selectOptions.add(option);	
					}
				}
				selectFieldData.put("selectOptions",selectOptions);
				selectFieldData.put("selectedValue",selectedSystemCompType);
				
			}
			else
			{
				JSONObject option  = new JSONObject();
				option.put("value", "-1");
				option.put("name", mappingInfo.getTextDescription("monitor.common.Not Available"));
				selectOptions.add(option);

				selectFieldData.put("selectedValue","-1");
			}

			if(selectedSystemCompType !=null && selectedSystemCompType.trim().length()>0 && selectedSystemCompType.equalsIgnoreCase("TreeSystem") && comtypeIniVar.contains(selectedSystemCompType))
			{
				EgList tem_ComptypeList = new EgList();
				comtypeIniVar.remove(selectedSystemCompType);
				for(int i=0;i<componentList.size();i++)
				{
					EgComponent component = (EgComponent)componentList.get(i);
					String compType1=component.getType();
					if(!comtypeIniVar.contains(compType1) && !compType1.trim().startsWith("Agg_"))
					{
						if(tem_ComptypeList.size() == 0 || !tem_ComptypeList.contains(component))
							tem_ComptypeList.add(component);
					}				
				}
				componentList = new EgList();
				componentList.addAll(tem_ComptypeList);
			}
			else if(selectedSystemCompType !=null && selectedSystemCompType.trim().length()>0 &&  comtypeIniVar.contains(selectedSystemCompType))
			{
				EgList tem_ComptypeList = new EgList();

				int sizeOfCompList = componentList.size();
				for(int i=0;i<sizeOfCompList;i++)
				{
					EgComponent component = (EgComponent)componentList.get(i);
					String compType1=component.getType();
				
					if(compType1.equalsIgnoreCase(selectedSystemCompType))
					{
						if(tem_ComptypeList.size() == 0 || !tem_ComptypeList.contains(component))
							tem_ComptypeList.add(component);
					}								
				}	
				componentList = new EgList();
				componentList.addAll(tem_ComptypeList);
			}	
		}
	}
	if(selectFieldData!= null && selectFieldData.size() > 0)
	{
		json.put("selectFieldData",selectFieldData);
	}
	if(componentList!=null && componentList.size() > 0)
	{
		List comNameSort=new ArrayList();

		Hashtable measureData = serviceBean.getTestMeasureData(componentList,selectedSystemCompType,false);

		if(measure_sort!=null && !measure_sort.equalsIgnoreCase("undefined") && !measure_sort.equalsIgnoreCase("") && !measure_sort.equalsIgnoreCase("null") && !measure_sort.equalsIgnoreCase("-2"))
		{
			EgList tempList=new EgList();
			ArrayList comp_value=new ArrayList();
			Enumeration hash_key=null;
			hash_key=measureData.keys();
			TreeMap treeMap = new TreeMap(); 
			ArrayList noMeasureComp=new ArrayList();
			while(hash_key.hasMoreElements())
			{
				String measure_key=(String)hash_key.nextElement();
				if(measure_key!=null && measure_key.length()>0)
				{
					StringTokenizer st = new StringTokenizer(measure_key, "^"); 
					while(st.hasMoreTokens())
					{ 
						String comp = st.nextToken(); 
						String measure = st.nextToken();
						boolean dup_val=false;
						ArrayList temp=new ArrayList();
						if(measure.equalsIgnoreCase(measure_sort))
						{
							String measure_value=(String)measureData.get(measure_key);//get value from measure data 
							if(measure_value!=null && measure_value.equalsIgnoreCase("-"))
							{
								measure_value="0.0";
								noMeasureComp.add(comp);
							}
							Float temp_data = new Float(Float.parseFloat(measure_value));
							if(treeMap!=null && treeMap.size()>0)
							{
								ArrayList temp1=new ArrayList();
								dup_val=treeMap.containsKey(temp_data);
								//if the value is duplicated, add the comp in arrayList for particular Component
								if(dup_val)
								{
									Object ob=treeMap.get(temp_data);
									if(ob instanceof String)
									{
										temp1.add((String)ob);
									}
									else if(ob instanceof ArrayList)
									{
										temp1=(ArrayList)ob;
									}
									if(temp1!=null && temp1.size()>0)
									{
										for(int k=0;k<temp1.size();k++)
										{
											temp.add(temp1.get(k));
										}
									}
									temp.add(comp);
									treeMap.put(temp_data,temp);
								}
							}
							if(dup_val==false)
							{
								treeMap.put(temp_data,comp);
							}
						}
					}
				}
			}
			hash_key=null;
			Collections.sort(noMeasureComp);
			Set set = treeMap.entrySet(); //itreate and get add the value in list from treeset
			// Get an iterator 
			Iterator itr = set.iterator(); 
				// Display elements 
			while(itr.hasNext()) 
			{ 
				Map.Entry me = (Map.Entry)itr.next(); 
				Object comp_obj=me.getValue();
				if(comp_obj instanceof String)
				{
					if(!noMeasureComp.contains(comp_obj))
					{
						comp_value.add(comp_obj);
					}
				}
				else if(comp_obj instanceof ArrayList)
				{
					ArrayList al=new ArrayList();//if treemap contain component in arraylist itrate and add in another list 
					al=(ArrayList)comp_obj;
					for(int k=0;k<al.size();k++)
					{
						if(!noMeasureComp.contains(al.get(k)))
							comp_value.add(al.get(k));
					}
				}
			}

			//Add the no measure component after the sorting
			for(int j=0;j<noMeasureComp.size();j++)
			{
				comp_value.add(noMeasureComp.get(j));
			}

			//reverse the component in reverse, to sort in decending order
			if(sort_type.equalsIgnoreCase("DESC") || sort_type.equalsIgnoreCase("descending"))
			{
				ArrayList tempList2=new ArrayList();
				for(int k=comp_value.size()-1;k>=0;k--)//for desc
				{
					String temp3=(String)comp_value.get(k);
					if(noMeasureComp!=null && !noMeasureComp.contains(temp3))
						tempList2.add(temp3);
				}
				//after reverse the component list ,add the no mesure comp at the last
				for(int j=0;j<noMeasureComp.size();j++)
				{
					tempList2.add(noMeasureComp.get(j));
				}
				comp_value=tempList2;
				tempList2=null;
			}
			for(int j=0;j<comp_value.size();j++)
			{
				String comp_value_temp=(String)comp_value.get(j);
				for(int k=0;k<componentList.size();k++)
				{
					EgComponent comp = (EgComponent)componentList.get(k);
					String compName1 = comp.getName();
					StringTokenizer str = new StringTokenizer(compName1, ":"); 
					while(str.hasMoreTokens())
					{ 
						String list_name = str.nextToken(); 
						if(list_name.equalsIgnoreCase(comp_value_temp))
						{
							if(!compList.contains(comp))
							{
								compList.add(comp);
							}
							if(tempList.contains(comp))
							{
								tempList.remove(comp);
							}
						}
						else if(!tempList.contains(comp) && !compList.contains(comp))
						{
							tempList.add(comp);
						}
						
					}
				}
			}
			//EgList tempList1=new EgList();
			componentList=null;
			componentList=new EgList();
			for(int k=0;k<compList.size();k++)
			{
				EgComponent comp_tem= (EgComponent)compList.get(k);
				componentList.add(comp_tem);
			}
			for(int k=0;k<tempList.size();k++)
			{
				EgComponent comp_tem= (EgComponent)tempList.get(k);
				componentList.add(comp_tem);
			}
			/*
			if(sort_type.equalsIgnoreCase("descending"))
			{
				for(int k=componentList.size()-1;k>=0;k--)//for desc
				{
					//EgComponent comp_tem= (EgComponent)tempList.get(k);
					tempList1.add(componentList.get(k));
				}
				componentList=tempList1;
			}
			*/
			tempList=null;
			comp_value=null;
			treeMap=null;
			noMeasureComp=null;
		}
		if(measure_sort!=null && measure_sort.equalsIgnoreCase("-2") )
		{
			if (componentList != null && componentList.size() > 0)
			{
				for(int k=0;k<componentList.size();k++)
				{
					EgComponent comp = (EgComponent)componentList.get(k);
					String compNameStr = comp.getName();
					comNameSort.add(compNameStr);
					comNameSort.add((EgComponent)comp);
					if (comNameSort != null && comNameSort.size() > 0)
					{
						EgSorter esort = new EgSorter(comNameSort, 2);
						comNameSort = esort.sort(1, "String", "asc");
					}
				}
			}
			componentList=null;
			componentList=new EgList();
			if (comNameSort != null && comNameSort.size() > 0)
			{
				for (int i = 0; i < comNameSort.size(); i += 2)
				{
					String compNameLi = (String) comNameSort.get(i);
					EgComponent comObject = (EgComponent) comNameSort.get(i + 1);
					componentList.add(comObject);
				}
			}
		}
		/*
		int compSize=componentList.size();
		if(limit!=null && limit.length()>0)
		{
			if(!limit.equalsIgnoreCase("All"))
			{
				int limitValue=Integer.parseInt(limit);
				for(int k=compSize-1;k>=limitValue;k--)
				{
					componentList.remove(k);
				}
			}
		}
		*/
		String imgsrc="";
		//EgList egList1=new EgList();
		//VmDashboardHelper vmDashHelper=new VmDashboardHelper(user);
		//egList1=vmDashHelper.getSortedList(componentList,measureData,"virtual","FREE_SYS_PAGE_TABLE","desc");

		//String disp_info=egUI.getValue("TREE_SYSTEM_SETTINGS","DisplayAllComp");
		String disp_info=egDashConfig.getValue("TREE_SYSTEM_SETTINGS","DisplayAllComp");
		if(disp_info.equalsIgnoreCase("no"))
		{
			//remove the component which has no measure
			if(componentList!=null && componentList.size() > 0)
			{
				if(measureData!=null)
				{
					EgList tempcomponentList=componentList;
					int measure_len=measureList.size();
					for(int k = 0; k< tempcomponentList.size(); k++)
					{
						int count_mes=0;
						EgComponent component = (EgComponent)tempcomponentList.get(k);
						String dispCom = component.getDisplayName();
						//int colCnt = 0;
						String s_test="";
						String s_measure="";
						//Enumeration en = measureList.keys();
						for(int i=0;i<keyList.size();i++)
						{
							String key_measure =(String )keyList.get(i);
							String unit_Measure = (String)measureList.get(key_measure);
							String []test_Meas = StringUtils.getTokens(key_measure,":");
							if(test_Meas!=null)
							{
								s_test = test_Meas[0];
								s_measure = test_Meas[1];
							}
							String db_Measure =  dbInfo.getColumnForMeasure(s_test,s_measure);
							if(db_Measure!=null && !db_Measure.equals(""))
								s_measure = db_Measure;
							if(s_measure!=null)
							{
								s_measure=s_test+":"+s_measure;
							}
							if(dispCom.indexOf(":") > -1)
								dispCom = dispCom.substring(0,dispCom.indexOf(":"));
							String measure_Value = (String)measureData.get(dispCom +"^"+s_measure);
							if(measure_Value== null)
							{
								measure_Value="-";
							}
							if(measure_Value.equalsIgnoreCase("-"))
							{
								count_mes++;
							}
							//colCnt++;
						}
						//if total no of measure equal to tot no of empty measure means remove the comp....
						if(count_mes==measure_len)
						{
							componentList.remove(k);
							k--;
						}
					}
				}
			}
		}
		int pages=0;
		int recount=0;
		int pagesizec=0;
		int pageSize = 0;
		String Default_Pagesize=egDashConfig.getValue("TREE_SYSTEM_SETTINGS","Default_Pagesize");
		Default_Pagesize=(Default_Pagesize==null || Default_Pagesize.trim().length()==0)?"10":Default_Pagesize;
		pageSize=Integer.parseInt(Default_Pagesize.trim());

		//String test_measure=egUI.getValue("TREE_SYSTEM","TreeSystem");
		String test_measure=egDashConfig.getValue("TREE_SYSTEM","TreeSystem");
		String tokens[] = StringUtils.getTokens(test_measure,",");
		boolean isTestRelevantForServer=false;
		
		if(componentList!=null && componentList.size() > 0 && tokens.length > 0)
		{
			for(int s=0;s<componentList.size();s++)
			{
				EgComponent component = (EgComponent)componentList.get(s);
				String compType1=component.getType();
				int v=0;
				ArrayList al=new ArrayList();
				for(int m=0;m<tokens.length;m++)
				{
					String temp=tokens[m];
					String tokens1[] = StringUtils.getTokens(temp,":");
					String testName=tokens1[0];
					if(al!=null && !al.contains(testName))
					{
						al.add(testName);//dont remove this list
						isTestRelevantForServer = specsInfo.isTestRelevantForServer(compType1,testName);
						if(isTestRelevantForServer)
						{
							v++;
						}
					}
				}
				if(v<1)
				{
					componentList.remove(s);
					s--;
				}
			}
		}
		if(componentList !=null && componentList.size() > 0 && measureList!=null && measureList.size()>0)
		{
			JSONObject columnObj  = new JSONObject();
			JSONObject countJson= new JSONObject();
			columnObj.put("text",mappingInfo.getTextDescription("monitor.common.Systems"));
			String SortForCompName="-2";
			if(measure_sort!=null && measure_sort.equalsIgnoreCase("-1"))
				SortForCompName="-2";
			else if(measure_sort!=null && measure_sort.equalsIgnoreCase("-2"))
				SortForCompName="-1";
			columnObj.put("SortForCompName",SortForCompName);
			String SortTypeForCompName="ASC";
			if(sort_type!=null && sort_type.equalsIgnoreCase("DESC"))
			{
				SortTypeForCompName="ASC";
			}
			else if(sort_type!=null && sort_type.equalsIgnoreCase("ASC"))
			{
				SortTypeForCompName="DESC";
			}
			columnObj.put("SortTypeForCompName",SortTypeForCompName);

			columns.add(columnObj);

			if(sort_type!=null && sort_type.length()>0)
			{
				if(sort_type.equalsIgnoreCase("ascending"))
				{
					imgsrc="/final/monitor/eg_images/arrow_up_black_small.gif";
				}
				else if(sort_type.equalsIgnoreCase("descending"))
				{
					imgsrc="/final/monitor/eg_images/arrow_down_black_small.gif";
				}
			}
			sortByMainOptions.put("sortByLabel",mappingInfo.getTextDescription("monitor.common.Sort By"));
			JSONObject Sortbytypeoption  = new JSONObject();
			Sortbytypeoption.put("value","-1");
			Sortbytypeoption.put("name",mappingInfo.getTextDescription("monitor.common.---State---"));
			sortByOptions.add(Sortbytypeoption);
			Sortbytypeoption  = new JSONObject();
			Sortbytypeoption.put("value","-2");
			Sortbytypeoption.put("name",mappingInfo.getTextDescription("monitor.common.---Component---"));
			sortByOptions.add(Sortbytypeoption);
			if(measure_sort!=null && measure_sort.equalsIgnoreCase("-2"))
				sortByMainOptions.put("sortBySelectedMeasure","-2");
			else if(measure_sort==null)
				sortByMainOptions.put("sortBySelectedMeasure","-1");
			if(measureList!=null && measureList.size() > 0)
			{
				int k=1;
				for(int i=0;i<keyList.size();i++)
				{
					key = (String)keyList.get(i);
					testMeas = StringUtils.getTokens(key,":");
					if(testMeas!=null)
					{
						stest = testMeas[0];
						smeasure = testMeas[1];
						sdispName = testMeas[2];
					}
					String db_Measure =  dbInfo.getColumnForMeasure(stest,smeasure);
					db_Measureandtest=stest+":"+db_Measure;
					if(measure_sort!=null && measure_sort.trim().length()>0 && measure_sort.equals(db_Measureandtest))
					{
						sortByMainOptions.put("sortBySelectedMeasure",db_Measureandtest);
					}
					Sortbytypeoption  = new JSONObject();
					Sortbytypeoption.put("value",db_Measureandtest);
					Sortbytypeoption.put("name",sdispName);
					sortByOptions.add(Sortbytypeoption);
					widthOfTheHead="80";
					dbMeasure =  dbInfo.getColumnForMeasure(stest,smeasure);
					if(dbMeasure!=null)
					{
						dbMeasure=stest+":"+dbMeasure;
					}
					String imgeId="sortImg"+k;
					//check image name and current image id name
					if(imageId.equalsIgnoreCase(imgeId))
					{
						columnObj  = new JSONObject();
						columnObj.put("text",mappingInfo.getTextDescription("monitor.common."+sdispName));
						columns.add(columnObj);
						
					}
					else
					{
						columnObj  = new JSONObject();
						columnObj.put("text",mappingInfo.getTextDescription("monitor.common."+sdispName));
						columns.add(columnObj);
					}
					k++;
				}
				
				for(int i=0;i<keyList.size();i++)
				{
					key = (String)keyList.get(i);
					StringTokenizer tok = new StringTokenizer(key,":");
					int s=0;
					String s_measureFun=null;
					String temp_arr[]=new String[4];
					while (tok.hasMoreTokens())
					{
						temp_arr[s]=tok.nextToken();
						s++;
					}
					if(s==4)
					{
						String s_test=temp_arr[0];
						String s_measure=temp_arr[1];
						try
						{
							String specify_info=egDashConfig.getValue("TREE_SYSTEM_INFO",s_test);
							if(specify_info!=null && specify_info.trim().length()>0)
							{
								s_measureFun=null;
							}
							else
							{
								s_measureFun=temp_arr[3];
							}
						}
						catch(Exception eee)
						{
							eee.printStackTrace();
							s_measureFun=null;
						}
						if(s_measureFun!=null && (s_measureFun.equalsIgnoreCase("Average") || s_measureFun.equalsIgnoreCase("Avg")))
						{
							s_measureFun = "Avg";
						}
						unitMeasure = tablesInfo.getUnitForMeasure(s_test,s_measure);
						//tablesInfo=null;
					}
					else
					{
						//s_measureFun="Avg";
						unitMeasure = (String)measureList.get(key);
					}

					//displayUnit = unitMeasure;
					if(s_measureFun!=null && s_measureFun.trim().length()>0)
					{
						if(unitMeasure!=null && unitMeasure.trim().length()>1 && !unitMeasure.equals("%"))
							displayUnit = ""+mappingInfo.getTextDescription("monitor.common."+s_measureFun)+" ("+mappingInfo.getTextDescription("monitor.common."+unitMeasure)+")";
						else
							displayUnit = ""+mappingInfo.getTextDescription("monitor.common."+s_measureFun)+" ("+unitMeasure+")";
					}
					else
					{
						if(unitMeasure!=null && unitMeasure.trim().length()>1 && !unitMeasure.equals("%"))
							displayUnit = "("+mappingInfo.getTextDescription("monitor.common."+unitMeasure)+")";
						else
							displayUnit = "("+unitMeasure+")";
					}

					widthOfTheHead="80";
					if(unitMeasure.equals("%"))
						widthOfTheHead="100";
					if(unitMeasure.equals("MB"))
					{
						if(s_measureFun!=null && s_measureFun.trim().length()>0)
						{
							displayUnit = ""+s_measureFun+" ("+mappingInfo.getTextDescription("monitor.VirtualDashboard.GB")+")";
						}
						else
						{
							displayUnit = "("+mappingInfo.getTextDescription("monitor.VirtualDashboard.GB")+")";
						}
					}

					columns.getJSONObject(i+1).put("unit",displayUnit);
					columns.getJSONObject(i+1).put("textType","asFloat");
				}
			}
			int measure_header_len=-1;
			if(componentList!=null && componentList.size() > 0 )
			{
				//Display Components
				String currdate = dateInfo.egetDate(false);

				recount=componentList.size();
				pagesizec=recount/pageSize;
				int tem = recount;
				int mod = tem%pageSize;
				if(mod > 0)
					pagesizec=pagesizec+1;
				countJson.put("recount",recount);
				countJson.put("pagesizec",pageSize);
				countJson.put("totalPages",pagesizec);
				if(pagesizec<=1)
					countJson.put("isHidePaging",new Boolean(true));
				else
					countJson.put("isHidePaging",new Boolean(false));

				String pageNoReq = request.getParameter("pageNo");
				if(pageNoReq==null || pageNoReq.trim().length()==0 || pageNoReq.equalsIgnoreCase("null"))
					pageNoReq="1";
				int pageStartIndex = 0;
				int pageEndIndex = pageSize;
				int pageNum = 1;
				try
				{
					pageNum = Integer.parseInt(pageNoReq.trim());
					pageNum = (pageNum == 0 )?1:pageNum;
					if(pageNum==1)
					{
						pageStartIndex=0;
						//pageEndIndex = pageStartIndex+(pageSize-1);//10+10-1
						pageEndIndex = pageSize+pageStartIndex;
					}
					else 
					{
						//pageStartIndex=((pageNum-1)*pageSize);//2-1*10
						//pageEndIndex = pageStartIndex+(pageSize-1);//10+10-1
						pageStartIndex = (pageNum*pageSize)-pageSize;
						pageEndIndex = pageSize+pageStartIndex;
					}
				}
				catch(Exception ee)
				{
					ee.printStackTrace();
					pageNum=1;
				}
				int componentList_count=0;
				if(componentList.size()>=pageEndIndex)
				{
					componentList_count=pageEndIndex;
				}
				else if(componentList.size()<pageEndIndex)
				{
					//componentList_count=componentList.size();
					componentList_count=componentList.size();
				}
				if(componentList.size()>=pageEndIndex)
				{
					componentList_count=pageEndIndex;
				}
				else if(componentList.size()<pageEndIndex)
				{
					//componentList_count=componentList.size();
					componentList_count=componentList.size();
				}
				for(c = pageStartIndex; c < componentList_count; c++)
				{
					JSONObject measure  = new JSONObject();
					EgComponent component = (EgComponent)componentList.get(c);
					compType = component.getType();
					compName = component.getName();
					compState = (component.getState()).getName();

					dispComp = component.getDisplayName();
					if(selectedNode!=null && selectedNode.indexOf("(")>-1)
					{
						site = selectedNode.substring(0,selectedNode.indexOf("("));
					}
					else
						site = "NULL";

					String trgthost=component.getName();
					if(trgthost!=null && trgthost.indexOf(":")>-1)
						trgthost=trgthost.substring(0,trgthost.indexOf(":"));
					trgthost=trgthost+":NULL";

					String serverName=component.getName();
					String sid="";
					StringTokenizer tokServer=new StringTokenizer(serverName,":");
					int serTokens=tokServer.countTokens();
					String sname=tokServer.nextToken();
					String portno=tokServer.nextToken();
					if(serTokens==3)
						sid=tokServer.nextToken();
					boolean isHostMaintenance=egM.isItMaintenanceTime(currdate,sname,"","",true);
					boolean isComponentMaintenance=egM.isItMaintenanceTime(currdate,sname,portno,sid,true);
					List  maintenaceTimePeriod=new ArrayList();
					List tempMaintenanceList=null;

					if(isHostMaintenance)
					{
						tempMaintenanceList=egM.getMaintenancePeriods(sname,"","",true);
						if(tempMaintenanceList!=null && tempMaintenanceList.size()>0)
							maintenaceTimePeriod.addAll(tempMaintenanceList);
						tempMaintenanceList=egM.getUnplannedMaintenancePeriods(sname,"","",true);
						if(tempMaintenanceList!=null && tempMaintenanceList.size()>0)
							maintenaceTimePeriod.addAll(tempMaintenanceList);
					}
					if(isComponentMaintenance)
					{
						tempMaintenanceList=egM.getMaintenancePeriods(sname,portno,sid,true);
						if(tempMaintenanceList!=null && tempMaintenanceList.size()>0)
						{
							maintenaceTimePeriod.addAll(tempMaintenanceList);
						}
						tempMaintenanceList=egM.getUnplannedMaintenancePeriods(sname,portno,sid,true);
						if(tempMaintenanceList!=null && tempMaintenanceList.size()>0)
							maintenaceTimePeriod.addAll(tempMaintenanceList);
					}
					int noOfLines=maintenaceTimePeriod.size();
					String maintenaceTimePeriodStr=maintenanceUtil.convertMaintenacevectorToString(maintenaceTimePeriod,user);

					boolean configChanged = ((ht_changeHash.containsKey(component.getName()) || ht_changeHash.containsKey(trgthost)) &&EgInstallInfo.isConfigSupported && hasConfigSupport);
					boolean isTestRelevantForServerInner = false;
					if(configChanged)
					{
						ArrayList temp_list=(ArrayList) ht_changeHash.get(component.getName());
						if(temp_list==null || temp_list.size()==0)
							temp_list= (ArrayList) ht_changeHash.get(trgthost);

						if(temp_list!=null && temp_list.size()>0)
						{
							for(int k=0;k<temp_list.size();k++)
							{
								String temp_test_name=(String)temp_list.get(k);
								if(temp_test_name!=null && temp_test_name.trim().length()>0)
								{
									isTestRelevantForServerInner = specsInfo.isTestRelevantForServer(component.getType(),temp_test_name);
								}
								if(isTestRelevantForServerInner)
									break;
							}
							
							if(isTestRelevantForServerInner)
								configChanged=true;
							else
								configChanged=false;
						}
						else
							configChanged=false;
					}

					url = "/final/servlet/com.eg.EgDashboardController?from=list&site="+EgURLEncoder.encode(site,"UTF-8")+"&qctr=0&comptype="+compType+ "&host="+EgURLEncoder.encode(compName,"UTF-8")+"&tab=LayerModel&toDashBoardLayer=true&treeTitle=segment&selectNode=Segment$cap$"+selectedNode+"&selectedParam="+selectedNode+"&currentTab=system&aggregateTab="+aggregateTab+"&fromHomepage="+fromHomepage+"&iszoneName="+iszoneName+"&parentZone="+parentZone+"&isFromZone="+isFromZone+"&selectedSystemCompType="+selectedSystemCompType; 
					if(csrfToken!=null && csrfToken.trim().length()>0 && !csrfToken.equalsIgnoreCase("null"))
						url = url + "&com.eg.CSRF_NONCE="+csrfToken;
					
					String trBackground="eg_lightlight";
					if(c%2==0)
					{
						trBackground="eg_whitebg";
					}

					measure.put("systemIconClass","state_"+component.getState().getName());
					//measure.put("systemIconTitle",component.getState().getName());
					measure.put("systemIconTitle",mappingInfo.getLabelDescription(component.getState().getName()));
					measure.put("layerModelUrl",url);
					measure.put("systemTitle",mappingInfo.getTextDescription("monitor.segmentDashboard."+dispComp));
					//measure.put("system",StringUtils.egSubString(dispComp,isUserLanguageEnglish,headerLength,10));
					measure.put("system",dispComp);

					if(isHostMaintenance || isComponentMaintenance)
					{
						measure.put("MaintenanceTime",maintenaceTimePeriodStr);
						measure.put("NoOfLines",noOfLines);
					}

					/*if(configChanged)//  Configuraion Image changes 111
					{
						measure.put("configChange",component.getName()+":"+component.getType());
					}*/

					colCount = 0;
					for(int i=0;i<keyList.size();i++)
					{
					//e = measureList.keys();
					//while(colCount < measureList.size())
					//{
						key = (String)keyList.get(i);

						StringTokenizer tok = new StringTokenizer(key,":");
						int s=0;
						String s_measureFun=null;
						String temp_arr[]=new String[4];
						while (tok.hasMoreTokens())
						{
							temp_arr[s]=tok.nextToken();
							s++;
						}
						if(s==4)
						{
							String s_test=temp_arr[0];
							String s_measure=temp_arr[1];
							s_measureFun=temp_arr[3];
							//unitMeasure = tablesInfo.getUnitForMeasure(s_test,s_measure);
							if(s_measureFun!=null && (s_measureFun.equals("Average") || s_measureFun.equals("Avg")))
							{
								unitMeasure = tablesInfo.getUnitForMeasure(s_test,s_measure);
								if(unitMeasure!=null && unitMeasure.equals("%"))
								{
									unitMeasure="%";
								}
								else
								{
									unitMeasure=mappingInfo.getTextDescription("monitor.common."+s_measureFun);
								}
							}
							else if(s_measureFun!=null && (s_measureFun.equalsIgnoreCase("Sum") || s_measureFun.equalsIgnoreCase("Max") || s_measureFun.equalsIgnoreCase("Min")))
							{
								unitMeasure = mappingInfo.getTextDescription("monitor.common."+s_measureFun);
							}
							else
							{
								unitMeasure = tablesInfo.getUnitForMeasure(s_test,s_measure);
							}
							//tablesInfo=null;
						}
						else
						{
							unitMeasure = (String)measureList.get(key);
							unitMeasure = mappingInfo.getTextDescription("monitor.common."+unitMeasure);
						}

						testMeas = StringUtils.getTokens(key,":");
						String org_mea="";
						if(testMeas!=null)
						{
							stest = testMeas[0];
							smeasure = testMeas[1];
							org_mea = smeasure;
							sdispName = testMeas[2];
						}
						dbMeasure =  dbInfo.getColumnForMeasure(stest,smeasure);
						if(dbMeasure!=null && !dbMeasure.equals(""))
							smeasure = dbMeasure;
						if(smeasure!=null)
						{
							smeasure=stest+":"+smeasure;
						}
						if(dispComp.indexOf(":") > -1)
							dispComp = dispComp.substring(0,dispComp.indexOf(":"));
						HashSet Info=(HashSet)measureData.get(dispComp +"^"+smeasure+":INFO");
						measureValue = (String)measureData.get(dispComp +"^"+smeasure);
						if(measureValue == null)
						{
							measureValue = "-";
						}
						DecimalFormat df= new DecimalFormat("#0.00");
						double measure_val=0;
						if(measureValue!=null && !measureValue.equalsIgnoreCase("-"))
						{
							if(measureValue!=null && (measureValue.indexOf("Yr")> -1 || measureValue.indexOf("Mth")> -1 || measureValue.indexOf("Day")> -1 ||  measureValue.indexOf("Hr")> -1 || measureValue.indexOf("Min")> -1 || measureValue.indexOf("Sec")> -1 ))
							{
								measureValue=measureValue;
								int tmp_measure_header_len=0;
								if(measureValue.indexOf("Yr")> -1)
								{
									tmp_measure_header_len=(measureValue.length()*11);
								}
								else if(measureValue.indexOf("Mth")> -1)
								{
									tmp_measure_header_len=(measureValue.length()*10);
								}
								else
								{
									tmp_measure_header_len=(measureValue.length()*9);
								}
								
								if(tmp_measure_header_len>measure_header_len)
									measure_header_len=tmp_measure_header_len;
							}
							else
							{
								measure_val= Double.parseDouble(measureValue);
								measureValue=df.format(measure_val);
								String temp=measureValue.substring(measureValue.indexOf(".")+1,measureValue.length());
								if(temp.equals("00"))
								{
									measureValue=measureValue.substring(0,measureValue.indexOf("."));
								}
							}
						}
						if(measureValue!=null && (measureValue.equalsIgnoreCase("0.0") || measureValue.equalsIgnoreCase("0.00")))
						{
							measureValue="0";
						}

						String testToUtl="";
						hostNameToken=StringUtils.getTokens(compName,":");
						if(hostNameToken!=null && hostNameToken.length>0)
						{
							hostName = hostNameToken[0];
							hostPort = hostNameToken[1];
						}

						boolean portReleventForTest = specsInfo.isPortRelevantForTest(stest);
						String compNameToUrl=compName;
						if(!portReleventForTest)
						{
							hostPort="NULL";
							//compNameToUrl=hostName+":NULL";
						}
						ArrayList layersForComp = tablesInfo.getLayersForComponent(compType);
						List agents=egExternalInfo.getAgentsFor(stest,compType,hostName);
						if(agents!=null && agents.size()>0)
							msmtHost=(String)agents.get(0);
						else
							msmtHost=hostName;
						String Layer_name_str=tablesInfo.getLayerForTest(stest);
						String layerName="HOST";
						if(Layer_name_str!=null && Layer_name_str.trim().length()>0)
						{
							StringTokenizer tokenLayer=new StringTokenizer(Layer_name_str,",");
							if(tokenLayer!=null)
							{
								while(tokenLayer.hasMoreTokens())
								{
									String l_name=(String)tokenLayer.nextToken();
									if(l_name!=null)
									{
										if(layersForComp!=null && layersForComp.contains(l_name))
										{
											if(tablesInfo.isMeasureInLayer(stest,org_mea,l_name))
											{
												layerName=l_name;
												break;
											}
										}
									}
								}
							}
						}
						
						if(Info!=null && Info.size()==1)
						{
							String infoFirst=Info.iterator().next().toString();
							if(infoFirst!=null && infoFirst.trim().length()>0 && (!infoFirst.startsWith("+")) && infoFirst.endsWith("+"))
							{
								testToUtl=stest+"-+";
							}
							else if(infoFirst!=null && infoFirst.trim().length()>0 && (!infoFirst.startsWith("+")) && (!infoFirst.endsWith("+")))
							{
								testToUtl=stest+"-"+infoFirst.substring(infoFirst.indexOf("+"));
							}
							else if(infoFirst!=null && infoFirst.trim().length()>0)
							{
								testToUtl=stest+"-"+infoFirst;
							}
							else
							{
								testToUtl=stest+"-+";
							}

							Measureurl="/final/monitor/EgSiteInfraView.jsp?qctr=2&fromalarm=&host="+EgURLEncoder.encode(compNameToUrl,"UTF-8")+"&layer="+EgURLEncoder.encode(layerName,"UTF-8")+"&site="+site+"&msmt_host="+EgURLEncoder.encode(msmtHost,"UTF-8")+"&test="+EgURLEncoder.encode(testToUtl,"UTF-8")+"&comptype="+EgURLEncoder.encode(compType,"UTF-8")+"&tstate="+compState+"&newWindow=false&prevPage=MainDashBoard&treeTitle=segment&selectNode=Segment$cap$"+selectedNode+"&selectedParam="+selectedNode+"&currentTab=system&aggregateTab="+aggregateTab+"&fromHomepage="+fromHomepage+"&iszoneName="+iszoneName+"&parentZone="+parentZone+"&isFromZone="+isFromZone+"&selectedSystemCompType="+selectedSystemCompType;
							
						}
						else if(Info!=null && Info.size()>1)
						{
							testToUtl="null-+";
							Measureurl="/final/monitor/EgSiteInfraView.jsp?qctr=1&fromalarm=&host="+EgURLEncoder.encode(compNameToUrl,"UTF-8")+"&layer="+EgURLEncoder.encode(layerName,"UTF-8")+"&site="+site+"&msmt_host="+EgURLEncoder.encode(msmtHost,"UTF-8")+"&test="+EgURLEncoder.encode(testToUtl,"UTf-8")+"&comptype="+EgURLEncoder.encode(compType,"UTF-8")+"&tstate="+compState+"&newWindow=false&prevPage=MainDashBoard&treeTitle=segment&selectNode=Segment$cap$"+selectedNode+"&selectedParam="+selectedNode+"&currentTab=system&aggregateTab="+aggregateTab+"&fromHomepage="+fromHomepage+"&iszoneName="+iszoneName+"&parentZone="+parentZone+"&isFromZone="+isFromZone+"&selectedSystemCompType="+selectedSystemCompType;
							
						}
						else
						{
							testToUtl="null-+";
							Measureurl="/final/monitor/EgSiteInfraView.jsp?qctr=1&fromalarm=&host="+EgURLEncoder.encode(compNameToUrl,"UTF-8")+"&layer="+EgURLEncoder.encode(layerName,"UTF-8")+"&site="+site+"&msmt_host="+EgURLEncoder.encode(msmtHost,"UTF-8")+"&test="+EgURLEncoder.encode(testToUtl,"UTF-8")+"&comptype="+EgURLEncoder.encode(compType,"UTF-8")+"&tstate="+compState+"&newWindow=false&prevPage=MainDashBoard&treeTitle=segment&selectNode=Segment$cap$"+selectedNode+"&selectedParam="+selectedNode+"&currentTab=system&aggregateTab="+aggregateTab+"&fromHomepage="+fromHomepage+"&iszoneName="+iszoneName+"&parentZone="+parentZone+"&isFromZone="+isFromZone+"&selectedSystemCompType="+selectedSystemCompType;
							
						}

						String columnWith="180";
						String testName=stest.toLowerCase();
						if(testName!=null && testName.indexOf("uptime")>-1)
						{
							columnWith=String.valueOf(measure_header_len);
							columns.getJSONObject(i+1).put("columnWith", columnWith);
						}
						columns.getJSONObject(i+1).put("textType", "asFloat");
						columns.getJSONObject(i+1).put("dataIndex",i+"MeasureValue");
						columns.getJSONObject(i+1).put("measureOrgName",smeasure);
						String sortty="DESC";
						if(sort_type!=null && sort_type.equalsIgnoreCase("DESC"))
						{
							sortty="ASC";
						}
						else if(sort_type!=null && sort_type.equalsIgnoreCase("ASC"))
						{
							sortty="DESC";
						}
						columns.getJSONObject(i+1).put("sortType",sortty);
						measure.put(i+"MeasureValue",measureValue);
						
						if(measureValue!=null && !measureValue.equals("-"))
						{
							if(unitMeasure.equals("%"))
							{
								int columnWidth = 100;
								Long temp_measure_value=new Long(Math.round(Double.parseDouble(measureValue)));
								long fillColorValue=temp_measure_value.longValue();
								long value1 = (fillColorValue*100)/columnWidth;
								measure.put(i+"MeasureValueWidth",String.valueOf(value1));
							}
							if(csrfToken!=null && csrfToken.trim().length()>0 && !csrfToken.equalsIgnoreCase("null"))
								Measureurl = Measureurl + "&com.eg.CSRF_NONCE="+csrfToken;
							measure.put(i+"MeasureValueUrl",Measureurl);
						}
						colCount++;
					}
					measures.add(measure);
				}
			}
			JSONObject labelObj= new JSONObject();
			labelObj.put("monitor.serviceDashboard.noDataMsg",mappingInfo.getTextDescription("monitor.common.No Data found"));
			labelObj.put("monitor.serviceDashboard.systemTitle",mappingInfo.getTextDescription("monitor.serviceDashboard.Key Performance Indicators for segment")+" : "+selectedNode);
			json.put("columns",columns);
			json.put("measures",measures);
			sortByMainOptions.put("sortByOptions",sortByOptions);
			json.put("sortByMainOptions",sortByMainOptions);
			json.put("pageParams",pageParams);
			json.put("countJson",countJson);
			json.put("screenLabels",labelObj);
		}
		else
		{
			JSONObject labelObj= new JSONObject();
			labelObj.put("monitor.serviceDashboard.systemTitle",mappingInfo.getTextDescription("monitor.serviceDashboard.Key Performance Indicators for segment")+" : "+selectedNode);
			
			json.put("screenLabels",labelObj);
			json.put("error",mappingInfo.getTextDescription("monitor.common.No Data found"));	
		}
		response.getWriter().write(json.toString());
	}
	else
	{
		JSONObject labelObj= new JSONObject();
		labelObj.put("monitor.serviceDashboard.systemTitle",mappingInfo.getTextDescription("monitor.serviceDashboard.Key Performance Indicators for segment")+" : "+selectedNode);
		
		json.put("screenLabels",labelObj);
		json.put("error",mappingInfo.getTextDescription("monitor.common.No Data found"));
		response.getWriter().write(json.toString());
	}
try
{
	String qString=request.getQueryString();

	if(qString!=null)
	{
		if(qString.indexOf("action")>-1)
		{
			session.setAttribute("monitorLastSession","/final/servlet/com.eg.EgMonitorController?monCmd=segmentList&currentTab=system&from=MainDashboard&"+qString);
		}
		else
		{
			session.setAttribute("monitorLastSession","/final/servlet/com.eg.EgMonitorController?monCmd=segmentList&currentTab=system&from=MainDashboard&refresh=true&action=segment&"+qString);
		}
	}
	else
	{
		session.setAttribute("monitorLastSession","/final/servlet/com.eg.EgMonitorController?monCmd=segmentList&from=MainDashboard");
	}
	
}
catch(Exception e)
{
	System.out.println("Exception in segmentDashboard System ..");
	e.printStackTrace();
}
%>