
<!--
***************************************************************************************
*	File name		: endUserDashboard.jsp
*	Purpose			: This is the main page for End User Dashboard
*	Version			: eG 5.6.5 and Above
*	Creation Date	: 30/01/2014
*	Authtor			: Saravanan . A
*	Design			: Jaiwin
******************************************************************************************/
-->
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ page errorPage = "EgProbsM.jsp"%>
<%@ page import = "com.eg.EgMappingInfo"%>
<%@ page import = "com.eg.IniFile"%>
<%@ page import = "com.eg.EgInstallInfo"%>
<%@ page import = "com.eg.EgDbInfo"%>
<%@ page import = "com.eg.EgURLEncoder" %>
<%@ page import = "com.egurkha.monitor.*" %>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page import = "java.util.*" %>
<%@ page import = "com.egurkha.*"%>
<%@ page import = "egurkha.reporter.ErUtils"%>
<%@ page import = "com.eg.*"%>
<%@ page import = "egurkha.reporter.ErUserData"%>
<%@ page import = "com.egurkha.ini.IniUI"%>
<%@ page import = "com.egurkha.monitor.VmDashboardHelper"%>
<%@ page import = "java.text.*" %>
<%@ page import = "java.math.*" %>
<%@ page import="net.sf.json.*"%>
<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page autoFlush="true" buffer="1094kb"%>
<%@ page import = "com.eg.supermanager.*" %>
<%@ page import="egurkha.config.EcUtils"%>
<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader ("Expires", -1);
	request.setCharacterEncoding("UTF-8");

	session.setAttribute("Page_IdentifierM", request.getRequestURI());
%>

<%
try
{
	String strCsrfToken = "";
	String strEncodedUrl = response.encodeURL(((HttpServletRequest)pageContext.getRequest()).getRequestURI());
	if(strEncodedUrl != null)
	{
		int idx_A = strEncodedUrl.indexOf("?");
		if(idx_A != -1)
		{
			String queryString = strEncodedUrl.substring(idx_A+1);
			HashMap hashMapParameters = EcUtils.parseQueryString(queryString);
			if(hashMapParameters != null && hashMapParameters.containsKey("com.eg.CSRF_NONCE"))
			{
				strCsrfToken = (String)hashMapParameters.get("com.eg.CSRF_NONCE");
			}
		}
	}
	String t_qry=request.getQueryString();
	if(t_qry != null && t_qry.trim().length() > 0)
	{
		if(t_qry.indexOf("&com.eg.CSRF_NONCE") != -1)
		{
			t_qry = t_qry.substring(0,t_qry.indexOf("&com.eg.CSRF_NONCE"));
		}
	}
	
	/* This is for SuperManager - starts */
	if(com.eg.EgInstallInfo.isSuperManager)
	{
		ArrayList managerIds = null;
		String currentSession = session.getId();
		if(EgManagersInfo.sessionManagerMap.containsKey(currentSession))
		{
			managerIds = (ArrayList)EgManagersInfo.sessionManagerMap.get(currentSession);
		}
		if(managerIds == null || managerIds.isEmpty())
		{
			EgManagersInfo mgrsInfo = EgManagersInfo.getInstance();
			if(!mgrsInfo.getReportingManagers().isEmpty())
			{
				managerIds = new ArrayList(mgrsInfo.getReportingManagers().keySet());
			}
		}
		if(managerIds != null && !managerIds.isEmpty())
		{
			SmSessionData smsData = new SmSessionData(currentSession,managerIds);
			EgThreadLocal egtl = new EgThreadLocal();
			egtl.set(smsData);
		}
	}
	/* This is for SuperManager - ends */
	UserRegistry registry = UserRegistry.getInstance();
	User user = null; //registry.getUser(session.getId());

	boolean isFromMenu=false;
	String fromMenuStr = request.getParameter("fromMenu");
	if(fromMenuStr!=null && (fromMenuStr.equalsIgnoreCase("true") || fromMenuStr.equalsIgnoreCase("yes")))
	{
		isFromMenu=true;
	}

	boolean isFromXenVdiFlag=false;
	String isFromXenVdi = request.getParameter("isFromXenVdi");
	if(isFromXenVdi!=null && (isFromXenVdi.equalsIgnoreCase("true") || isFromXenVdi.equalsIgnoreCase("yes")))
	{
		isFromXenVdiFlag=true;
	}

	String showKeyUserStr = request.getParameter("showKeyUser");
	boolean showKeyUser=false;
	if(showKeyUserStr!=null && (showKeyUserStr.equalsIgnoreCase("true") || showKeyUserStr.equalsIgnoreCase("yes")))
	{
		showKeyUser=true;
	}

	String updateUserAssociateStr = request.getParameter("updateUserAssociate");
	boolean updateUserAssociateFlag=false;
	if(showKeyUser && updateUserAssociateStr!=null && (updateUserAssociateStr.equalsIgnoreCase("true") || updateUserAssociateStr.equalsIgnoreCase("yes")))
	{
		updateUserAssociateFlag=true;
	}
	boolean isFromGeo=false;
	String fromGeoStr = request.getParameter("fromGeo");
	if(fromGeoStr!=null && (fromGeoStr.equalsIgnoreCase("true") || fromGeoStr.equalsIgnoreCase("yes")))
	{
		isFromGeo=true;
	}

	String iniName = null,user_name = null,isUserBased = null,dashboard_name = null,view_name = null,time_line = null,geoInfo = null,usercountval=null,selectedTest=null,selectedMeasure=null;
	if(isFromGeo){
		iniName = request.getParameter("iniName");
		user_name = request.getParameter("user_name");
		isUserBased = request.getParameter("isUserBased");
		dashboard_name = request.getParameter("dashboard_name");
		view_name = request.getParameter("view_name");
		time_line = request.getParameter("time_line");
		geoInfo = request.getParameter("ginfo");
		usercountval = request.getParameter("usercountval");
		selectedTest = request.getParameter("selectedTest");
		selectedTest=(selectedTest==null)?"":selectedTest;
		selectedMeasure = request.getParameter("selectedMeasure");
		selectedMeasure=(selectedMeasure==null)?"":selectedMeasure;
	}else{
		iniName = request.getParameter("iniName");
		user_name = request.getParameter("user_name");
		isUserBased = request.getParameter("isUserBased");
		view_name = request.getParameter("view_name");
		selectedTest = request.getParameter("selectedTest");
		selectedTest=(selectedTest==null)?"":selectedTest;
		selectedMeasure = request.getParameter("selectedMeasure");
		selectedMeasure=(selectedMeasure==null)?"":selectedMeasure;
	}
	if(isFromMenu || isFromGeo)
	{
		user = registry.getUser(session.getId(),true);
	}
	else
	{
		user = registry.getUser(session.getId());
	}

	EgUserRole userRole = null;
	boolean isAllCompAccess=false;
	boolean isManagerLogin=false;
	String userName = "admin";
	String desktopName = request.getParameter("username");
	desktopName=com.egurkha.util.StringUtils.decodeSecurityChar(desktopName);
	String currColumnType = request.getParameter("columnType");
	String currColdispName = request.getParameter("columnDispName");
	String aduserFilter = request.getParameter("aduserFilter");
	String fromctx = request.getParameter("fromctx");
	String fromMetricView = request.getParameter("fromMetricView");
	String comptype = request.getParameter("comptype");
	String treeTitle = request.getParameter("treeTitle");
	String componentNameSearch = request.getParameter("componentNameSearch");
	String fromPageView = request.getParameter("fromPageView");
	String selectedState = request.getParameter("selectedState");
	String viewPageTitle = request.getParameter("viewPageTitle");
	String action = request.getParameter("action");
	String fromHomepage = request.getParameter("fromHomepage");
	String isfromCitrix = request.getParameter("isfromCitrix");
	String isfromRum = request.getParameter("isfromRum");
	String isFromZone = request.getParameter("isFromZone");
	String iszoneName = request.getParameter("iszoneName");
	String parentZone = request.getParameter("parentZone");
	String appliesTo = request.getParameter("appliesTo");
	String fromServiceHomePage = request.getParameter("fromServiceHomePage");
	String fromSerComboChange = request.getParameter("fromSerComboChange");
	String filterByFlag = request.getParameter("filterByFlag");
	String filterByParamFlag = request.getParameter("filterByParamFlag");

	String selectedRum = request.getParameter("selectedRum");
	String isFromServiceMenu = request.getParameter("isFromServiceMenu");
	String isFromZoneMain = request.getParameter("isFromZoneMain");
	String isFromZoneMenu = request.getParameter("isFromZoneMenu");
	String isFromServiceGroup = request.getParameter("isFromServiceGroup");
	String serviceComponent = request.getParameter("serviceComponent");

	String filterName = request.getParameter("filterName");

	String overviewType = request.getParameter("overviewType");
	String uedOverviewType = request.getParameter("uedOverviewType");

	boolean isFromHost = false;
	if(fromctx!=null && !fromctx.equalsIgnoreCase("NULL") && fromctx.trim().length()>0)
		isFromHost = true;

	String filterParam="";

	String filterFlag = request.getParameter("filterFlag");
	String filterBy = request.getParameter("filterBy");
	String detail = request.getParameter("detail");
	String compCombo = request.getParameter("compCombo");
	String searchFilter = request.getParameter("searchFilter");
	String nextSearch = request.getParameter("nextSearch");
	String nextSubSearch = request.getParameter("nextSubSearch");
	String fromf5 = request.getParameter("fromf5");
	String priorityFilter = request.getParameter("priorityFilter");
	if(filterFlag != null && filterFlag.equalsIgnoreCase("true")){
		filterParam ="&filterFlag=true";
		filterParam+="&detail="+detail;
		filterParam+="&compCombo="+compCombo;
		filterParam+="&filterBy="+filterBy;
		filterParam+="&searchFilter="+searchFilter;
		filterParam+="&nextSearch="+nextSearch;
		filterParam+="&nextSubSearch="+nextSubSearch;
		filterParam+="&fromf5="+fromf5;
		filterParam+="&priorityFilter="+priorityFilter;
	}
	else if(filterBy != null && filterBy.trim().length() > 0)
	{
		filterParam ="&filterFlag=true";
		filterParam+="&filterBy="+filterBy;
	}

	desktopName=(desktopName==null)?"":desktopName;

	String installdir = EgInstallInfo.getInstallDir();
	IniFile in = new IniFile(installdir+"/manager/config/eg_endUserDetails.ini");

	String strEGManagerUser=in.getValue("END_USER_DASHBOARD_SETTINGS","eGManagerUser");
	strEGManagerUser=(strEGManagerUser==null || strEGManagerUser.trim().length()==0)?"false":strEGManagerUser;
	boolean isEGManagerUser = strEGManagerUser.equalsIgnoreCase("true")?true:false;

	String uedExternalAccess = in.getValue("END_USER_DASHBOARD_SETTINGS","EndUserDashboardExternalAccess");
	uedExternalAccess=(uedExternalAccess==null || uedExternalAccess.trim().length()==0)?"false":uedExternalAccess.toLowerCase();

	boolean isUEDExternalAccess=false;
	if(uedExternalAccess!=null && (uedExternalAccess.equalsIgnoreCase("yes") || uedExternalAccess.equalsIgnoreCase("true")))
		isUEDExternalAccess=true;

	if(user==null && (!isFromMenu || !isFromGeo))
	{
		String login_user = "";
		if(isEGManagerUser)
			login_user = request.getParameter("user");

		userName=(login_user==null || login_user.trim().length()==0)?"admin":login_user;
		ErUserData userData = new ErUserData(userName,false);
		if(userData==null)
		{
			userName="admin";
			userData = new ErUserData(userName,false);
			user = userData.usr;
		}
		else if(userData!=null)
		{
			user = userData.usr;
		}

		if(user!=null)
		{
			userRole = user.getUserRole();
			isAllCompAccess = userRole.hasAllComponentAccess();
		}

		isManagerLogin = false;
	}
	else if(user!=null)
	{
		userName = user.getLoginID();
		userRole = user.getUserRole();
		isAllCompAccess = userRole.hasAllComponentAccess();
		isManagerLogin = true;
	}

	IniUI iniUI = IniUI.getInstance();

	EgTablesInfo tablesInfo = new EgTablesInfo("manager");
	EgExternalInfo egExternalInfo=new EgExternalInfo("manager");
	String thisLanguage = iniUI.getDefaultLanguage();
	if (user!=null)
	{
		user.setUserLanguageAndSkins();
		String userLang = user.getLanguage();
		if (userLang!=null && !userLang.equalsIgnoreCase("NULL"))
		{
			thisLanguage=userLang;
		}
	}
	String userType = request.getParameter("userType");
	if(userType==null || userType.trim().length()==0)
		userType = request.getParameter("usertype");
	userType = (userType==null || userType.equalsIgnoreCase(""))?"VDI":userType;

	String script_src="script_item_"+thisLanguage+".js";
	EgMappingInfo mappingInfo = new EgMappingInfo(thisLanguage);

	String access = request.getParameter("access");
	if(access==null)
		access = request.getParameter("Access");
	access=(access==null || access.trim().length()==0)?"":access;

	if(desktopName!=null && desktopName.trim().length()>0 && (access==null || access.trim().length()==0))
		access="allusers";

	EgList vdiDesktopsList= new EgList();
	Hashtable finalDesktopVmsHash=new Hashtable();
	if((isUEDExternalAccess || ((isFromMenu || isFromGeo) && isManagerLogin)) && ((access!=null && access.equalsIgnoreCase("allusers")) || (desktopName!=null && desktopName.trim().length()>0)))
	{
		VmDashboardHelper vmDashHelper=new VmDashboardHelper(user);

		String desktopUserName = request.getParameter("username");
		desktopUserName=com.egurkha.util.StringUtils.decodeSecurityChar(desktopUserName);
		String searchString = (desktopUserName!=null && !desktopUserName.equalsIgnoreCase("") && desktopUserName.length()>0)?desktopUserName:request.getParameter("searchString");
		searchString=(searchString==null || searchString.trim().length()==0)?"":searchString;

		String en_searchString =com.egurkha.util.StringUtils.encodeSecurityChar(searchString);

		String priority = request.getParameter("priority");
		priority=(priority==null || priority.trim().length()==0)?"5":priority;

		String vdiType = request.getParameter("vdiType");
		vdiType=(vdiType==null || vdiType.trim().length()==0)?"":vdiType;

		if(desktopUserName!=null && desktopUserName.trim().length()>0)
		{
			Hashtable finalEndUserDatas = (Hashtable)vmDashHelper.getEndUserDatas(userType);
			Hashtable infoResHash = new Hashtable();
			if(finalEndUserDatas!=null && finalEndUserDatas.size()>0)
			{
				infoResHash = (Hashtable)finalEndUserDatas.get("users");
			}

			if(infoResHash!=null && infoResHash.size()>0)
			{
				finalDesktopVmsHash = (Hashtable)vmDashHelper.getLatestUserDesktopForEUD(searchString,userType,vdiType,infoResHash,isFromHost);
			}
			else
			{
				finalDesktopVmsHash = (Hashtable)vmDashHelper.getLatestUserDesktopForEUD(searchString,userType,vdiType,null,isFromHost);
			}
		}

		if(finalDesktopVmsHash!=null && finalDesktopVmsHash.size()>0)
		{
			vdiDesktopsList = (EgList)finalDesktopVmsHash.get("EgList");
		}
	
		if(desktopUserName!=null && !desktopUserName.equalsIgnoreCase("") && desktopUserName.length()>0 && vdiDesktopsList.size()>0)
		{
			EgService tempServ = (EgService)vdiDesktopsList.get(0);
			String tempDesktopComponent = tempServ.getName();
			String tempDesktopState = tempServ.getState().getName();
			String tempDesktopName = "";
			String tempComp = "";
			String tempCompValue = "";
			String tempCompName = "";
			String tempCompNameWithOutPort = "";

			if(tempDesktopComponent!=null && tempDesktopComponent.indexOf("^")>-1){
				tempDesktopName = tempDesktopComponent.substring(0,tempDesktopComponent.indexOf("^"));
				tempComp = tempDesktopComponent.substring(tempDesktopComponent.indexOf("^")+1);
			}

			if(tempComp!=null && tempComp.indexOf(":")>-1){
				tempCompValue = tempComp.substring(0,tempComp.indexOf(":"));
				tempCompName = tempComp.substring(tempComp.indexOf(":")+1);
			}

			if(tempCompName!=null && tempCompName.indexOf(":")>-1){
				tempCompNameWithOutPort = tempCompName.substring(0,tempCompName.indexOf(":"));
			}
			String tempMsmtHost = "";
			String ctype_layer=in.getValue("USER_DESKTOP_LAYERS",tempCompValue);
			ctype_layer=(ctype_layer==null || ctype_layer.trim().length()==0)?"VIRTUAL_DESKTOP":ctype_layer;
			ArrayList arr = tablesInfo.getTestsForLayer(ctype_layer);
			if(arr!=null && arr.size()>0)
			{
				boolean flag=true;
				for (int t=0;t<arr.size();t++)
				{
					String insideviewTest=(String) arr.get(t);
					if(insideviewTest!=null && insideviewTest.trim().length()>0)
					{
						List tempAgents=egExternalInfo.getAgentsFor(insideviewTest.trim(),tempCompValue,tempCompNameWithOutPort);

						if(tempAgents!=null && tempAgents.size()>0)
						{
							tempMsmtHost=(String)tempAgents.get(0);
							flag=false;
							break;
						}
					}
				}

				if(flag)
					tempMsmtHost=tempCompNameWithOutPort;
			}
			else
				tempMsmtHost=tempCompNameWithOutPort;

			String temp_url_desktopName=com.egurkha.util.StringUtils.replace(tempDesktopName, "\\", "\\");
			String url = "endUserDashboardDetailsData.jsp?comp="+EgURLEncoder.encode(tempCompName,"UTf-8")+"&comptype="+tempCompValue+"&info=*"+EgURLEncoder.encode(temp_url_desktopName,"UTF-8")+"&compName="+EgURLEncoder.encode(tempCompName+":"+tempCompValue,"UTF-8")+"&componentName="+EgURLEncoder.encode(tempCompNameWithOutPort,"UTF-8")+"&msmt_host="+EgURLEncoder.encode(tempMsmtHost,"UTF-8")+"&user="+EgURLEncoder.encode(userName,"UTF-8")+"&searchString="+EgURLEncoder.encode(en_searchString,"UTF-8")+"&priority="+priority+"&vdiType="+vdiType+"&userType="+userType+"&enableBackButton=false&directEndDetail=true";
			
			url = url + "&filterName="+filterName;
			if(fromMenuStr!=null && fromMenuStr.trim().length()>0)
			{
				url=url+"&fromMenu="+fromMenuStr;
			}

			if(showKeyUser && showKeyUserStr!=null && showKeyUserStr.trim().length()>0)
			{
				url=url+"&showKeyUser="+showKeyUserStr;
			}
			
			if(updateUserAssociateFlag)
			{
				url=url+"&updateUserAssociate=true";
			}

			if(fromGeoStr!=null && fromGeoStr.trim().length()>0)
			{
				url=url+"&fromGeo="+fromGeoStr+"&iniName="+iniName+"&user_name="+user_name+"&isUserBased="+isUserBased+"&dashboard_name="+dashboard_name+"&view_name="+view_name+"&time_line="+EgURLEncoder.encode(time_line,"UTf-8")+"&ginfo="+EgURLEncoder.encode(geoInfo,"UTf-8")+"&usercountval="+usercountval+"&selectedTest="+EgURLEncoder.encode(selectedTest,"UTf-8")+"&selectedMeasure="+EgURLEncoder.encode(selectedMeasure,"UTf-8");
			}
			else{
				url=url+"&iniName="+iniName+"&user_name="+user_name+"&isUserBased="+isUserBased+"&dashboard_name="+dashboard_name+"&view_name="+view_name+"&selectedTest="+EgURLEncoder.encode(selectedTest,"UTf-8")+"&selectedMeasure="+EgURLEncoder.encode(selectedMeasure,"UTf-8");
			}
			if(currColumnType!=null && !currColumnType.equalsIgnoreCase("NULL") && currColumnType.trim().length()>0)
			{
				url = url + "&columnType="+currColumnType;
			}
			if(currColdispName!=null && !currColdispName.equalsIgnoreCase("NULL") && currColdispName.trim().length()>0)
			{
				url = url + "&columnDispName="+currColdispName;
			}
			if(aduserFilter!=null && !aduserFilter.equalsIgnoreCase("NULL") && aduserFilter.trim().length()>0)
			{
				url = url + "&aduserFilter="+aduserFilter;
			}

			if(fromctx!=null && !fromctx.equalsIgnoreCase("NULL") && fromctx.trim().length()>0)
			{
				url = url + "&fromctx="+fromctx;
			}
			
			if(fromMetricView!=null && !fromMetricView.equalsIgnoreCase("NULL") && fromMetricView.trim().length()>0)
			{
				url = url + "&fromMetricView="+fromMetricView;
				url = url + "&comptype="+comptype;
				url = url + "&treeTitle="+treeTitle;
				url = url + "&componentNameSearch="+componentNameSearch;
				url = url + "&fromPageView="+fromPageView;
				url = url + "&selectedState="+selectedState;
				url = url + "&viewPageTitle="+viewPageTitle;
				url = url + "&action="+action;
				url = url + "&fromHomepage="+fromHomepage;
				url = url + "&isfromCitrix="+isfromCitrix;
				url = url + "&isfromRum="+isfromRum;
				url = url + "&isFromZone="+isFromZone;
				url = url + "&iszoneName="+iszoneName;
				url = url + "&parentZone="+parentZone;
				url = url + "&appliesTo="+appliesTo;
				url = url + "&fromSerComboChange="+fromSerComboChange;
				url = url + "&fromServiceHomePage="+fromServiceHomePage;
				url = url + "&filterByFlag="+filterByFlag;
				url = url + "&filterByParamFlag="+filterByParamFlag;
				url = url + "&filterName="+filterName;
				
				url = url + "&filterBy="+filterBy;
				
			}
			
			if(filterParam != null && filterParam.trim().length() > 0)
				url = url +filterParam;
			if(strCsrfToken != null && strCsrfToken.trim().length()>0 && !strCsrfToken.equalsIgnoreCase("null"))
				url = url + "&com.eg.CSRF_NONCE="+strCsrfToken;
%>
			<jsp:forward page="<%=url%>" />
<%
		}
		else if(desktopUserName!=null && desktopUserName.trim().length()>0 && (vdiDesktopsList==null || vdiDesktopsList.size()==0))
		{
			String url = "endUserDashboardDetailsData.jsp?comp=&comptype=&info=*"+EgURLEncoder.encode(desktopUserName,"UTF-8")+"&compName=&componentName=&msmt_host=&user="+EgURLEncoder.encode(userName,"UTF-8")+"&searchString="+en_searchString+"&priority="+priority+"&vdiType="+vdiType+"&userType="+userType+"&enableBackButton=false&directEndDetail=true";
			url = url + "&filterName="+filterName;
			if(fromMenuStr!=null && fromMenuStr.trim().length()>0)
			{
				url=url+"&fromMenu="+fromMenuStr;
			}

			if(showKeyUser && showKeyUserStr!=null && showKeyUserStr.trim().length()>0)
			{
				url=url+"&showKeyUser="+showKeyUserStr;
			}

			if(updateUserAssociateFlag)
			{
				url=url+"&updateUserAssociate=true";
			}

			if(fromGeoStr!=null && fromGeoStr.trim().length()>0)
			{
				url=url+"&fromGeo="+fromGeoStr+"&iniName="+iniName+"&user_name="+user_name+"&isUserBased="+isUserBased+"&dashboard_name="+dashboard_name+"&view_name="+view_name+"&time_line="+EgURLEncoder.encode(time_line,"UTf-8")+"&ginfo="+EgURLEncoder.encode(geoInfo,"UTf-8")+"&usercountval="+usercountval+"&selectedTest="+EgURLEncoder.encode(selectedTest,"UTf-8")+"&selectedMeasure="+EgURLEncoder.encode(selectedMeasure,"UTf-8");
			}
			else				
			{
				url=url+"&iniName="+iniName+"&user_name="+user_name+"&isUserBased="+isUserBased+"&dashboard_name="+dashboard_name+"&view_name="+view_name+"&selectedTest="+EgURLEncoder.encode(selectedTest,"UTf-8")+"&selectedMeasure="+EgURLEncoder.encode(selectedMeasure,"UTf-8");
			}
			if(currColumnType!=null && !currColumnType.equalsIgnoreCase("NULL") && currColumnType.trim().length()>0)
			{
				url = url + "&columnType="+currColumnType;
			}
			if(currColdispName!=null && !currColdispName.equalsIgnoreCase("NULL") && currColdispName.trim().length()>0)
			{
				url = url + "&columnDispName="+currColdispName;
			}
			if(aduserFilter!=null && !aduserFilter.equalsIgnoreCase("NULL") && aduserFilter.trim().length()>0)
			{
				url = url + "&aduserFilter="+aduserFilter;
			}

			if(fromctx!=null && !fromctx.equalsIgnoreCase("NULL") && fromctx.trim().length()>0)
			{
				url = url + "&fromctx="+fromctx;
			}
			if(fromMetricView!=null && !fromMetricView.equalsIgnoreCase("NULL") && fromMetricView.trim().length()>0)
			{
				url = url + "&fromMetricView="+fromMetricView;
				url = url + "&comptype="+comptype;
				url = url + "&treeTitle="+treeTitle;
				url = url + "&componentNameSearch="+componentNameSearch;
				url = url + "&fromPageView="+fromPageView;
				url = url + "&selectedState="+selectedState;
				url = url + "&viewPageTitle="+viewPageTitle;
				url = url + "&action="+action;
				url = url + "&fromHomepage="+fromHomepage;
				url = url + "&isfromCitrix="+isfromCitrix;
				url = url + "&isfromRum="+isfromRum;
				url = url + "&isFromZone="+isFromZone;
				url = url + "&iszoneName="+iszoneName;
				url = url + "&parentZone="+parentZone;
				url = url + "&appliesTo="+appliesTo;
				url = url + "&fromSerComboChange="+fromSerComboChange;
				url = url + "&fromServiceHomePage="+fromServiceHomePage;
				url = url + "&filterByFlag="+filterByFlag;
				url = url + "&filterByParamFlag="+filterByParamFlag;
			}
			if(filterParam != null && filterParam.trim().length() > 0)
				url = url +filterParam;
			if(strCsrfToken != null && strCsrfToken.trim().length()>0 && !strCsrfToken.equalsIgnoreCase("null"))
				url = url + "&com.eg.CSRF_NONCE="+strCsrfToken;
%>
			<jsp:forward page="<%=url%>" />
<%
		}
		else
		{
			//String qry=request.getQueryString();
			String qry=t_qry;
			if(qry!=null && qry.length()>0)
			{
				qry=com.egurkha.util.StringUtils.replace(qry, "\\", "\\\\");
				String url="endUserDashboardMain.jsp?"+qry;
				if(currColumnType!=null && !currColumnType.equalsIgnoreCase("NULL") && currColumnType.trim().length()>0)
				{
					url = url + "&columnType="+currColumnType;
				}
				if(currColdispName!=null && !currColdispName.equalsIgnoreCase("NULL") && currColdispName.trim().length()>0)
				{
					url = url + "&columnDispName="+currColdispName;
				}
				if(aduserFilter!=null && !aduserFilter.equalsIgnoreCase("NULL") && aduserFilter.trim().length()>0)
				{
					url = url + "&aduserFilter="+aduserFilter;
				}

				if(fromctx!=null && !fromctx.equalsIgnoreCase("NULL") && fromctx.trim().length()>0)
				{
					url = url + "&fromctx="+fromctx;
				}

				if(fromMetricView!=null && !fromMetricView.equalsIgnoreCase("NULL") && fromMetricView.trim().length()>0)
				{
					url = url + "&fromMetricView="+fromMetricView;
					url = url + "&comptype="+comptype;
					url = url + "&treeTitle="+treeTitle;
					url = url + "&componentNameSearch="+componentNameSearch;
					url = url + "&fromPageView="+fromPageView;
					url = url + "&selectedState="+selectedState;
					url = url + "&viewPageTitle="+viewPageTitle;
					url = url + "&action="+action;
					url = url + "&fromHomepage="+fromHomepage;
					url = url + "&isfromCitrix="+isfromCitrix;
					url = url + "&isfromRum="+isfromRum;
					url = url + "&isFromZone="+isFromZone;
					url = url + "&iszoneName="+iszoneName;
				
					url = url + "&isFromZoneMenu="+isFromZoneMenu;
					
					url = url + "&parentZone="+parentZone;
					url = url + "&appliesTo="+appliesTo;
					url = url + "&fromSerComboChange="+fromSerComboChange;
					url = url + "&fromServiceHomePage="+fromServiceHomePage;
					url = url + "&filterByFlag="+filterByFlag;
					url = url + "&filterByParamFlag="+filterByParamFlag;
					url = url +"&iniName="+iniName;
					url = url +"&user_name="+user_name;
					url = url +"&isUserBased="+isUserBased;
					url = url +"&dashboard_name="+dashboard_name;
					url = url +"&view_name="+view_name+"&selectedTest="+EgURLEncoder.encode(selectedTest,"UTf-8")+"&selectedMeasure="+EgURLEncoder.encode(selectedMeasure,"UTf-8");
				}
				url = url +"&isFromXenVdi="+isFromXenVdiFlag;
				url = url +"&overviewType="+overviewType;
				//if(filterParam != null && filterParam.trim().length() > 0)
				//	url = url +filterParam;
				if(strCsrfToken != null && strCsrfToken.trim().length()>0 && !strCsrfToken.equalsIgnoreCase("null"))
					url = url + "&com.eg.CSRF_NONCE="+strCsrfToken;
%>
				<jsp:forward page="<%=url%>" />
<%
			}
		}
	}
	else
	{
%>
<!DOCTYPE html>
<html class="content-frame">
<meta charset="utf-8" http-equiv="X-UA-Compatible" content="IE=8,9,10" >
<egui:skin ui="monitor"/>
<head>
		<link rel="stylesheet" href="/final/resources/css/ext-eg.css" />
		<script language = "JavaScript1.2" src = "/final/scripts/<%=script_src%>"></script>
		<!-- <script src="/final/jquery/jquery.js"></script> -->
		<script src="/final/jquery/highchart_export.js"></script>
		<script language = "JavaScript1.2" src = "/final/monitor/eg_scripts/dashboardutils.js"></script>
		<link rel="stylesheet" type="text/css" href="/final/styles/gridster/css/jquery.gridster.css"><!-- Added -->
		<link rel="stylesheet" type="text/css" href="/final/styles/gridster/css/demo.css"><!-- Added -->
		<link rel="stylesheet" type="text/css" href="/final/styles/gridster/css/digitalfont/stylesheet.css"><!-- Added -->
		<script type="text/javascript" src="/final/jquery/jquery.scrollTo.js"></script> <!--Added -->
		<script type="text/javascript" src="/final/jquery/jquery.gridster.js"></script><!-- Added -->
	</head>
	<body class="content-frame"><div class="content-frame" style="border:0px solid red;" id="endUserDashboardDiv">
		<table border="0" width="100%" height="100%" bordercolor="green">
			<tr>
				<th align="left" style="color:#c6c6c6;text-align:left;padding-left:15px;border-bottom:1px solid #1c1c1c;font-size:13px;" width="100%" height="30px;">
					<egui:intnl text='monitor.endUserDashboard.User Experience Overview'/>
				</th>
			</tr>
			<tr>
				<td align="center" class="commonErrorMsgText" style="color:#c6c6c6;" width="100%" height="100%">
					<img src = "/final/images/spacer.gif" class="iconInformation" align = "center" border = "0"  vspace = "10"/>
					<br><egui:intnl text='monitor.endUserDashboard.UnAuthorised Access'/>&nbsp;!
				</td>
			</tr>
		</table>
	</div>
</body>
</html>
<%
	}
}
catch(Throwable th)
{
	System.out.println("---endUserDashboard.jsp exception-----");
	th.printStackTrace();
}
%>
