Ext.define('microsoftDashboard.view.microsoftTeams.UsersDevicesPage', {
    extend: 'Ext.panel.Panel',
	alias: 'widget.MS_Teams_Dashboard.usersdevicespage',
	ui:'eg-panel',
    border: false,
    autoScroll: false,
    scroll: false,
    layout: {
        type: 'vbox',
        align: 'stretch'
    },
	requires:[
		'microsoftDashboard.view.ChartParentPanel'	
	],
	items:[],
	updatePage:function(jsonData)
	{
		Ext.getCmp('eo_header_id').setTitle('<span style="float:left;">'+jsonData[6].users_devices_view_header+'</span><span style="display:'+jsonData[jsonData.length-1].layerUrlDisplay+';margin-top:-3px;margin-left:5px;float:left" class="iconRumToLayermodel handSymbol" data-qclass="yellowTip" data-qtip="Layer Model" href="javascript:void(0);" onclick="javascript:DashboardToLayers(\''+jsonData[jsonData.length-1].layerUrl+'\');"></span>');
		var textData = jsonData[0].UserDevicesView_first_block[0].TextBlock1;
		for(var y=0;y<textData.length;y++)
		{
			Ext.getCmp(textData[y].measure+""+y).getStore().loadRawData(textData[y]);
		}

		Ext.getCmp('statusIncidents').getStore().loadRawData(jsonData[0].UserDevicesView_first_block[0].TextBlock2);
		
		Ext.getCmp('deviceUsage').updatePanel(jsonData);
		Ext.getCmp('deviceUsageTrend').updatePanel(jsonData);

		Ext.getCmp('multgrp_activity1').updateChart(jsonData[2].UserDevicesView_third_block);
		Ext.getCmp('multgrp_activity2').updateChart(jsonData[3].UserDevicesView_fourth_block);
		Ext.getCmp('multgrp_activity3').updateChart(jsonData[4].UserDevicesView_fifth_block);
		Ext.getCmp('multgrp_activity4').updateChart(jsonData[5].UserDevicesView_sixth_block);
		
	},
	listeners:
	{
		afterrender:function(e)
		{
			var memain = this;
			memain.add({
				xtype:'header',
				height:25,
				margin:'0 0 5 0',
				id:'eo_header_id',
				title:'<span style="float:left;">'+memain.data[6].users_devices_view_header+'</span><span style="display:'+memain.data[memain.data.length-1].layerUrlDisplay+';margin-top:-3px;margin-left:5px;float:left" class="iconRumToLayermodel handSymbol" data-qclass="yellowTip" data-qtip="Layer Model" href="javascript:void(0);" onclick="javascript:DashboardToLayers(\''+memain.data[memain.data.length-1].layerUrl+'\');"></span>'
			});

			memain.add({
				xtype:'container',
				ui:'eg-container',
				height:95,
				margin:'0 1 1 0',
				layout:{
					type:'hbox',
					align:'stretch'
				},
				listeners:
				{
					afterrender:function(e)
					{
						var me = this;
						var firstBlockArray = memain.data[0].UserDevicesView_first_block[0].TextBlock1;
						for(var t=0;t<firstBlockArray.length;t++)
						{
							me.add({
								xtype:'dataview',
								cls:'dividerGradient',
								ui:'uniqueSessions',
								id:firstBlockArray[t].measure+""+t,
								minWidth:190,
								flex:1,
								store: Ext.create('Ext.data.Store', {
									fields: [{ name:'iconCls', type:'string' },{ name:'backgroundCls', type:'string' },{ name:'value', type:'string' },{ name:'valueText', type:'string'},{ name:'valueStatus', type:'string'},{ name:'layerLink',type:'string'},{ name:'stateValue', type:'string'}],
									autoLoad:true,
									data:firstBlockArray[t]
								}),
								tpl:new Ext.XTemplate(
									'<div class="widgetholders" style="height:100%;width:100%;margin:0px;display:flex;">',
										'<tpl for=".">',
												'<tpl if="xindex === 1">',
													'<tpl if="layerLink!=&quot;&quot;">',
														'<div onClick="javascript:layerModelLinks(\'{layerLink}\')" style="position:relative;flex:1;text-align:center;cursor:pointer;" class="{backgroundCls}">',
													'<tpl else>',
														'<div style="position:relative;flex:1;text-align:center;" class="{backgroundCls}">',
													'</tpl>',
												'<tpl elseif="xindex === 2">',
													'<div style="position:relative;flex:1;text-align:center;" class="{backgroundCls}">',
												'<tpl else>',
													'<div style="position:relative;flex:1;text-align:center;" class="{backgroundCls} ms-separator">',
												'</tpl>',
												'<div class="d_m_t25">',
													'<div style="display:inline-block;">',
														'<tpl if="stateValue">',
															'<img src="/final/images/clear.png" class="stateIcon22_{stateValue}" style="float:left;margin-right:8px;margin-top:3px;">',
														'<tpl else>',
															'<img src="/final/images/clear.png" class="{iconCls}" style="float:left;margin-right:8px">',
														'</tpl>',
														'<span class="f24-normal">{value}',
															'<span class="f19-normal"></span>',
														'</span>',
													'</div>',
													'<tpl if="backgroundCls==&quot;&quot;">',
														'<div style="width:80%;margin:10px auto auto auto;" class="f12-normal">{valueText}</div>',
													'<tpl else>',
														'<div style="width:80%;margin:10px auto auto auto;color:white;" class="f12-normal">{valueStatus}</div>',
													'</tpl>',
												'</div>',
											'</div>',
										'</tpl>',
									'</div>'
								)
							});
						}
					}
				}
			});

			memain.add({
				xtype:'container',
				margin:'10 0 10 0',
				layout:'column',
				manageOverflow:2,
				items:[],
				listeners:
				{
					afterrender:function(e)
					{
						var me = this;
						me.add({
							xtype:'panel',
							margin:'0 10 1 0',
							ui: 'eg-x-panel',
							cls:'ovFlowVisiblePanel',
							height:570,
							columnWidth:.2,
							items:[{
								xtype:'dataview',	
								margin:'0 20 0 20',
								id:'statusIncidents',
								store: Ext.create('Ext.data.Store', {
									fields: [{ name:'iconCls', type:'string' },{ name:'backgroundCls', type:'string' },{ name:'value', type:'string' },{ name:'valueText', type:'string'},{ name:'valueStatus', type:'string'},{ name:'header', type:'string'},{ name:'layerLink',type:'string'},{ name:'layerURL',type:'string'},{ name:'valueComment', type:'string'},{ name:'stateValue', type:'string'}],
									autoLoad:true,
									data:memain.data[0].UserDevicesView_first_block[0].TextBlock2									
								}), 
								tpl: new Ext.XTemplate(
									'<div  style="height:100%;width:100%;display:grid;grid-template-columns:repeat(1, 1fr);grid-template-rows: repeat(5, 1fr);">',
										'<tpl for=".">',
											'<tpl if="backgroundCls==&quot;&quot;">',
												'<tpl if="valueText == \'Total Activities\'">',
													'<div onClick="javascript:gotoSpecPage(\'usage\',\'MS_SPOnline_Dashboard\')"class="borderBottomCls" style="position:relative;text-align:center;cursor:pointer">',
												'<tpl else>',
													'<tpl if="layerLink!=&quot;&quot;">',
															'<div onClick="javascript:layerModelLinks(\'{layerLink}\')" class="borderBottomCls" style="position:relative;text-align:center;cursor:pointer;padding: 0 55px;">',
													'<tpl else>',
														'<tpl if="layerURL!=&quot;&quot;">',
															'<div onClick="javascript:gotoLayerModelLinksPage(\'{layerURL}\')" class="borderBottomCls" style="position:relative;text-align:center;cursor:pointer;padding: 0 55px;">',
														'<tpl else>',
															'<tpl if="valueText==\'Events\'">',
																'<div onClick="javascript:gotoSpecPage(\'All_Events\',\'365AlarmDetailsDashboard\')" class="borderBottomCls" style="cursor:pointer;position:relative;text-align:center;">',
															'<tpl else>',
																'<tpl if="valueText==\'Team Chats\'">',
																	'<div onClick="javascript:scrollAnimation(\'multgrp_activity1\')" class="borderBottomCls" style="position:relative;text-align:center;cursor:pointer;">',
																'<tpl elseif="valueText==\'Private Chats\'">',
																	'<div onClick="javascript:scrollAnimation(\'multgrp_activity2\')" class="borderBottomCls" style="position:relative;text-align:center;cursor:pointer;">',
																'<tpl elseif="valueText==\'Calls\'">',
																	'<div onClick="javascript:scrollAnimation(\'multgrp_activity3\')" class="borderBottomCls" style="position:relative;text-align:center;cursor:pointer;">',
																'<tpl elseif="valueText==\'Meetings\'">',
																	'<div onClick="javascript:scrollAnimation(\'multgrp_activity4\')" class="borderBottomCls" style="position:relative;text-align:center;cursor:pointer;">',
																'<tpl else>',
																	'<div class="borderBottomCls" style="position:relative;text-align:center;">',
																'</tpl>',
																//'<div class="borderBottomCls" style="position:relative;text-align:center;">',
															'</tpl>',															
														'</tpl>',
													'</tpl>',
												'</tpl>',
											'<tpl else>',
												'<tpl if="layerLink!=&quot;&quot;">',
													'<div onClick="javascript:layerModelLinks(\'{layerLink}\')"  class="{backgroundCls} whiteText" style="position:relative;text-align:center;cursor:pointer">',
												'<tpl else>',
													'<div class="{backgroundCls} whiteText" style="position:relative;text-align:center;">',
												'</tpl>',
											'</tpl>',
											'<div style="margin-top:15%;display:inline-block;text-align: center;">',
												'<div style="display:inline-block;">',
														'<tpl if="stateValue">',
															'<img src="/final/images/clear.png" class="stateIcon22_{stateValue}" style="float:left;margin-right:8px;margin-top:3px;">',
														'<tpl else>',
															'<img src="/final/images/clear.png" class="{iconCls}" style="float:left;margin-top:3px;margin-right:8px">',
														'</tpl>',														
														'<tpl if="error">',
															'<span class="f24-normal">-',
														'<tpl else>',
															'<tpl if="value">',
																'<span class="f24-normal">{value}',
															'</tpl>',
														'</tpl>',
															'<span class="f19-normal"></span>',
														'</span>',
													'</div>',
													'<div class="crl"></div>',
														'<tpl if="iconCls!=&quot;&quot;">',
															'<tpl if="backgroundCls==&quot;&quot;">',
																'<tpl if="valueComment">',
																	'<span class="f12-normal">{valueText}</span>',
																	'<span class="f12-normal">{valueStatus}<br/><span style="font-size:9px">{valueComment}</span></span>',
																'<tpl else>',
																	'<span class="f12-normal">{valueText}</span>',
																'</tpl>',
															'<tpl else>',
																'<tpl if="valueComment">',
																	'<span style="color:white;padding-top:1px;display:block;" class="f12-normal">{valueStatus}<br/><span style="font-size:9px">{valueComment}</span></span>',
																'<tpl else>',
																	'<span style="color:white;padding-top:1px;display:block;" class="f12-normal">{valueStatus}</span>',
																'</tpl>',
															'</tpl>',
														'<tpl else>',
															'<div style="width: 100%;display: flow-root;margin: auto;" class="f24-normal">-</div>',
														'</tpl>',
												'</div>',
											'</div>',
										'</tpl>',
									'</div>'
								)
							}]
						},
						{
							xtype:'container',
							margin:0,
							height:570,
							margin:0,
							columnWidth:.8,
							layout:{
								type:'vbox',
								align:'stretch'
							},
							items:[],
							listeners:
							{
								afterrender:function()
								{
									var me = this;
									me.add({
										xtype:'panel',
										margin:'0 1 10 0',
										ui: 'eg-x-panel',
										title:memain.data[1].UserDevicesView_second_block[0]["title"],
										cls:'ovFlowVisiblePanel',
										bodyPadding:'0 13 7 13',
										flex:1,
										items:[],
										id:'deviceUsage',
										tools:[{
											xtype:'label',
											cls:'font_bold9 grayColor',
											id:'deviceUsageTools',
											style:{"white-space":"nowrap"},
											text: memain.data[1].UserDevicesView_second_block[0].chartHistory
										}],
										updatePanel:function(data)
										{
											var me = this;
											var chartData = data[1].UserDevicesView_second_block[0];
											Ext.getCmp("deviceUsageTools").setText(chartData.chartHistory);
											var checkData = noDataComputefunction(chartData);
												if(!checkData)
												{
													try{
														var barChart = {};
														barChart = jQuery.extend(true, {}, createBarforCtx('',null,null), barChart);
														me.setTitle(chartData["title"]);
														chartData["title"] = "";
														chartData["marginTop"] = 0;
														barChart.setData(chartData,'','','bar');
														jsonData = barChart.highchart;
														$('#'+me.body.id).highcharts(jsonData);
													}catch(eo){
														me.update('<div style="height:100%;width:100%;display:table"><div class="msgFont" style="display:table-cell;vertical-align:middle"> <div class="iconInformation" style="margin:0px auto"></div><div style="text-align:center">No Data Found!</div></div></div>');
													}
												}
											else
												{
													me.update('<div style="height:100%;width:100%;display:table"><div class="msgFont" style="display:table-cell;vertical-align:middle"> <div class="iconInformation" style="margin:0px auto"></div><div style="text-align:center">No Data Found!</div></div></div>');
												}
										},
										listeners:
										{
											boxready:function(e)
											{
												var me = this;
												var chartData = memain.data[1].UserDevicesView_second_block[0];
												var checkData = noDataComputefunction(chartData);
												if(!checkData)
												{
													try{
														var barChart = {};
														barChart = jQuery.extend(true, {}, createBarforCtx('',null,null), barChart);
														chartData["title"] = "";
														chartData["marginTop"] = 0;
														barChart.setData(chartData,'','','bar');
														jsonData = barChart.highchart;
														$('#'+me.body.id).highcharts(jsonData);
													}catch(eo){
														me.update('<div style="height:100%;width:100%;display:table"><div class="msgFont" style="display:table-cell;vertical-align:middle"> <div class="iconInformation" style="margin:0px auto"></div><div style="text-align:center">No Data Found!</div></div></div>');
													}
												}
												else
												{
													me.update('<div style="height:100%;width:100%;display:table"><div class="msgFont" style="display:table-cell;vertical-align:middle"> <div class="iconInformation" style="margin:0px auto"></div><div style="text-align:center">No Data Found!</div></div></div>');
												}
											}
										}
									},{
										xtype:'panel',
										margin:'0 1 1 0',
										ui: 'eg-x-panel',
										cls:'ovFlowVisiblePanel',
										id:'deviceUsageTrend',
										bodyPadding:'0 13 7 13',
										flex:1,
										items:[],
										title:memain.data[1].UserDevicesView_second_block[1]["title"],
										tools:[{
											xtype:'label',
											cls:'font_bold9 grayColor',
											id:'deviceUsageTrendTools',
											style:{"white-space":"nowrap"},
											text: memain.data[1].UserDevicesView_second_block[1].chartHistory
										}],
										updatePanel:function(data)
										{
											var me = this;
											var jsonData = "";
											var chartData = data[1].UserDevicesView_second_block[1];
											var checkData = noDataComputefunction(chartData);
											if(!checkData)
											{
												me.setTitle(data[1].UserDevicesView_second_block[1].title);
												Ext.getCmp("deviceUsageTrendTools").setText(chartData.chartHistory);
												try{
													var chartData = data[1].UserDevicesView_second_block[1];
													var lineChart = {};
													lineChart = jQuery.extend(true, {}, createCombinationChart(me.id,null,null), lineChart);
													chartData["title"] = "";
													lineChart.setData(chartData,'','','line');
													jsonData = lineChart.highchart;
												}
												catch(eo)
												{													
												}
												if(chartData['DataSet'] != undefined || chartData['data'] != undefined)
													$('#'+me.id+'-body').highcharts(jsonData);	
											}
											else
											{
												me.update('<div style="height:100%;width:100%;display:table"><div class="msgFont" style="display:table-cell;vertical-align:middle"> <div class="iconInformation" style="margin:0px auto"></div><div style="text-align:center">No Data Found!</div></div></div>');
											}
										},
										listeners:
										{
											boxready:function(e)
											{
												var me = this;
												var jsonData = "";
												var chartData = memain.data[1].UserDevicesView_second_block[1];
												var checkData = noDataComputefunction(chartData);
												if(!checkData)
												{
													try{
														var chartData = memain.data[1].UserDevicesView_second_block[1];
														var lineChart = {};
														lineChart = jQuery.extend(true, {}, createCombinationChart(me.id,null,null), lineChart);
														chartData["title"] = "";
														lineChart.setData(chartData,'','','line');
														jsonData = lineChart.highchart;
													}
													catch(eo)
													{														
													}
													if(chartData['DataSet'] != undefined || chartData['data'] != undefined)
														$('#'+me.id+'-body').highcharts(jsonData);	
												}
												else
												{
													me.update('<div style="height:100%;width:100%;display:table"><div class="msgFont" style="display:table-cell;vertical-align:middle"> <div class="iconInformation" style="margin:0px auto"></div><div style="text-align:center">No Data Found!</div></div></div>');
												}
											}
										}
									});
								}
							}
						});
					}
				}
			});		
			
			memain.add({
				xtype:'panel',
				id:'res_acc_pan_id',
				ui:'eg-accordion-panel',
				padding:0,
				margin:'0 0 0 0',
				//fill:true,
				flex:2,
				layout: {
					type: 'accordion',
					animate: true,
					multi: true,				
				},
				items:[{
					title:memain.data[7].UserDevicesView_third_block_header,
					width:'100%',
					layout:{type:'anchor',anchor:'50%'},
					margin:'0 2 10 0',
					bodyPadding:'0 20 20 20',
					collapsed :false,
					items:[{
						xtype:'chartparentpanel',
						id:'multgrp_activity1',
						//bodyPadding:'0 1'
						//margin:'0 0 0 12',
						bodyPadding:'0 0 0 0',
						style:{'left':'-12px'},
						ifRes:true,
						data:memain.data[2].UserDevicesView_third_block,
						orgData:memain.data[2].UserDevicesView_third_block,
						flex:1						
					}],
					listeners: {
						afterlayout: function() {
							var res_chartObj = Ext.getCmp('multgrp_activity1');
							
							if(!Ext.isEmpty(res_chartObj) && !Ext.isEmpty(res_chartObj.data) && res_chartObj.data!=undefined)
							{
								for (var i= 0; i <  res_chartObj.data.length;i++ )
								{
									var topUserJsonDataObj=null;
									try
									{
										topUserJsonDataObj=res_chartObj.data[i];
									}
									catch (ee)
									{
										topUserJsonDataObj=res_chartObj.data[i];
									}

									if(topUserJsonDataObj == undefined || topUserJsonDataObj == null)
										continue;

									//var chartObj_id = 'chartParent_multgrp_activity_'+res_chartObj.orgData[i].chartCId+'_'+i;
									var chartObj_id = '';
									if(topUserJsonDataObj.chartCId != undefined && topUserJsonDataObj.chartCId != null)
										chartObj_id = 'chartParent_multgrp_activity1_'+topUserJsonDataObj.chartCId+'_'+i;
									else
										chartObj_id = 'chartParent_multgrp_activity1_'+i;
								
									if(chartObj_id.indexOf("(") != -1)
										chartObj_id = chartObj_id.replace("(","LB")

									if(chartObj_id.indexOf(")") != -1)
										chartObj_id = chartObj_id.replace(")","RB")
									
									if(!Ext.isEmpty(Ext.getCmp(chartObj_id)))
									{
										$('#'+chartObj_id+'-body').width('100%');
										var skinBorder=( (strSkin=='Dark' || strSkin=='dark') )?'#525252':'#f2f2f2';
										if(i%2 == 0)
										{
											Ext.getCmp(chartObj_id).getEl().dom.style.borderRight="1px solid "+skinBorder;
										}
										else
										{
											Ext.getCmp(chartObj_id).getEl().dom.style.borderRight="0px solid "+skinBorder;
										}
											

										if((res_chartObj.data.length-2)>i)
											Ext.getCmp(chartObj_id).getEl().dom.style.borderBottom="1px solid "+skinBorder;
										else
											Ext.getCmp(chartObj_id).getEl().dom.style.borderBottom="0px solid "+skinBorder;
									}
								}
							}
						},
						expand: function() 
						{						
							var res_chartObj = Ext.getCmp('multgrp_activity1');
							
							if(!Ext.isEmpty(res_chartObj) && !Ext.isEmpty(res_chartObj.data) && res_chartObj.data!=undefined)
							{							
								for (var i= 0; i <  res_chartObj.data.length;i++ )
								{
									var topUserJsonDataObj=null;
									try
									{
										topUserJsonDataObj=res_chartObj.data[i];
									}
									catch (ee)
									{
										topUserJsonDataObj=res_chartObj.data[i];
									}

									if(topUserJsonDataObj == undefined || topUserJsonDataObj == null)
										continue;
									
									if(topUserJsonDataObj.chartCId != undefined && topUserJsonDataObj.chartCId != null)
										chartObj_id = 'chartParent_multgrp_activity1_'+topUserJsonDataObj.chartCId+'_'+i;
									else
										chartObj_id = 'chartParent_multgrp_activity1_'+i;

									if(chartObj_id.indexOf("(") != -1)
										chartObj_id = chartObj_id.replace("(","LB")

									if(chartObj_id.indexOf(")") != -1)
										chartObj_id = chartObj_id.replace(")","RB")
									
									if(!Ext.isEmpty(Ext.getCmp(chartObj_id)))
										Ext.getCmp(chartObj_id).updateChart(chartObj_id+'-body',topUserJsonDataObj,'Line');									
								}
							}
						}
					}
				},{
					title:memain.data[8].UserDevicesView_fourth_block_header,
					width:'100%',
					layout:{type:'anchor',anchor:'50%'},
					margin:'0 2 10 0',
					bodyPadding:'0 20 20 20',
					collapsed :false,
					items:[{
						xtype:'chartparentpanel',
						id:'multgrp_activity2',
						//bodyPadding:'0 1'
						//margin:'0 0 0 12',
						bodyPadding:'0 0 0 0',
						style:{'left':'-12px'},
						ifRes:true,
						data:memain.data[3].UserDevicesView_fourth_block,
						orgData:memain.data[3].UserDevicesView_fourth_block,
						flex:1						
					}],
					listeners: {
						afterlayout: function() {
							var res_chartObj = Ext.getCmp('multgrp_activity2');
							
							if(!Ext.isEmpty(res_chartObj) && !Ext.isEmpty(res_chartObj.data) && res_chartObj.data!=undefined)
							{
								for (var i= 0; i <  res_chartObj.data.length;i++ )
								{
									var topUserJsonDataObj=null;
									try
									{
										topUserJsonDataObj=res_chartObj.data[i];
									}
									catch (ee)
									{
										topUserJsonDataObj=res_chartObj.data[i];
									}

									if(topUserJsonDataObj == undefined || topUserJsonDataObj == null)
										continue;

									//var chartObj_id = 'chartParent_multgrp_activity_'+res_chartObj.orgData[i].chartCId+'_'+i;
									var chartObj_id = '';
									if(topUserJsonDataObj.chartCId != undefined && topUserJsonDataObj.chartCId != null)
										chartObj_id = 'chartParent_multgrp_activity2_'+topUserJsonDataObj.chartCId+'_'+i;
									else
										chartObj_id = 'chartParent_multgrp_activity2_'+i;

									if(chartObj_id.indexOf("(") != -1)
										chartObj_id = chartObj_id.replace("(","LB")

									if(chartObj_id.indexOf(")") != -1)
										chartObj_id = chartObj_id.replace(")","RB")

									if(!Ext.isEmpty(Ext.getCmp(chartObj_id)))
									{
										$('#'+chartObj_id+'-body').width('100%');
										var skinBorder=( (strSkin=='Dark' || strSkin=='dark') )?'#525252':'#f2f2f2';
										if(i%2 == 0)
										{
											Ext.getCmp(chartObj_id).getEl().dom.style.borderRight="1px solid "+skinBorder;
										}
										else
										{
											Ext.getCmp(chartObj_id).getEl().dom.style.borderRight="0px solid "+skinBorder;
										}
											

										if((res_chartObj.data.length-2)>i)
											Ext.getCmp(chartObj_id).getEl().dom.style.borderBottom="1px solid "+skinBorder;
										else
											Ext.getCmp(chartObj_id).getEl().dom.style.borderBottom="0px solid "+skinBorder;
									}
								}
							}
						},
						expand: function() 
						{						
							var res_chartObj = Ext.getCmp('multgrp_activity2');
							
							if(!Ext.isEmpty(res_chartObj) && !Ext.isEmpty(res_chartObj.data) && res_chartObj.data!=undefined)
							{							
								for (var i= 0; i <  res_chartObj.data.length;i++ )
								{
									var topUserJsonDataObj=null;
									try
									{
										topUserJsonDataObj=res_chartObj.data[i];
									}
									catch (ee)
									{
										topUserJsonDataObj=res_chartObj.data[i];
									}

									if(topUserJsonDataObj == undefined || topUserJsonDataObj == null)
										continue;
									
									if(topUserJsonDataObj.chartCId != undefined && topUserJsonDataObj.chartCId != null)
										chartObj_id = 'chartParent_multgrp_activity2_'+topUserJsonDataObj.chartCId+'_'+i;
									else
										chartObj_id = 'chartParent_multgrp_activity2_'+i;

									if(chartObj_id.indexOf("(") != -1)
										chartObj_id = chartObj_id.replace("(","LB")

									if(chartObj_id.indexOf(")") != -1)
										chartObj_id = chartObj_id.replace(")","RB")
									
									if(!Ext.isEmpty(Ext.getCmp(chartObj_id)))
										Ext.getCmp(chartObj_id).updateChart(chartObj_id+'-body',topUserJsonDataObj,'Line');									
								}
							}
						}
					}
				},{
					title:memain.data[9].UserDevicesView_fifth_block_header,
					width:'100%',
					layout:{type:'anchor',anchor:'50%'},
					margin:'0 2 10 0',
					bodyPadding:'0 20 20 20',
					collapsed :false,
					items:[{
						xtype:'chartparentpanel',
						id:'multgrp_activity3',
						//bodyPadding:'0 1'
						//margin:'0 0 0 12',
						bodyPadding:'0 0 0 0',
						style:{'left':'-12px'},
						ifRes:true,
						data:memain.data[4].UserDevicesView_fifth_block,
						orgData:memain.data[4].UserDevicesView_fifth_block,
						flex:1						
					}],
					listeners: {
						afterlayout: function() {
							var res_chartObj = Ext.getCmp('multgrp_activity3');
							
							if(!Ext.isEmpty(res_chartObj) && !Ext.isEmpty(res_chartObj.data) && res_chartObj.data!=undefined)
							{
								for (var i= 0; i <  res_chartObj.data.length;i++ )
								{
									var topUserJsonDataObj=null;
									try
									{
										topUserJsonDataObj=res_chartObj.data[i];
									}
									catch (ee)
									{
										topUserJsonDataObj=res_chartObj.data[i];
									}

									if(topUserJsonDataObj == undefined || topUserJsonDataObj == null)
										continue;

									//var chartObj_id = 'chartParent_multgrp_activity_'+res_chartObj.orgData[i].chartCId+'_'+i;
									var chartObj_id = '';
									if(topUserJsonDataObj.chartCId != undefined && topUserJsonDataObj.chartCId != null)
										chartObj_id = 'chartParent_multgrp_activity3_'+topUserJsonDataObj.chartCId+'_'+i;
									else
										chartObj_id = 'chartParent_multgrp_activity3_'+i;

									if(chartObj_id.indexOf("(") != -1)
										chartObj_id = chartObj_id.replace("(","LB")

									if(chartObj_id.indexOf(")") != -1)
										chartObj_id = chartObj_id.replace(")","RB")

									if(!Ext.isEmpty(Ext.getCmp(chartObj_id)))
									{
										$('#'+chartObj_id+'-body').width('100%');
										var skinBorder=( (strSkin=='Dark' || strSkin=='dark') )?'#525252':'#f2f2f2';
										if(i%2 == 0)
										{
											Ext.getCmp(chartObj_id).getEl().dom.style.borderRight="1px solid "+skinBorder;
										}
										else
										{
											Ext.getCmp(chartObj_id).getEl().dom.style.borderRight="0px solid "+skinBorder;
										}
											

										if((res_chartObj.data.length-2)>i)
											Ext.getCmp(chartObj_id).getEl().dom.style.borderBottom="1px solid "+skinBorder;
										else
											Ext.getCmp(chartObj_id).getEl().dom.style.borderBottom="0px solid "+skinBorder;
									}
								}
							}
						},
						expand: function() 
						{						
							var res_chartObj = Ext.getCmp('multgrp_activity3');
							
							if(!Ext.isEmpty(res_chartObj) && !Ext.isEmpty(res_chartObj.data) && res_chartObj.data!=undefined)
							{							
								for (var i= 0; i <  res_chartObj.data.length;i++ )
								{
									var topUserJsonDataObj=null;
									try
									{
										topUserJsonDataObj=res_chartObj.data[i];
									}
									catch (ee)
									{
										topUserJsonDataObj=res_chartObj.data[i];
									}

									if(topUserJsonDataObj == undefined || topUserJsonDataObj == null)
										continue;
									
									if(topUserJsonDataObj.chartCId != undefined && topUserJsonDataObj.chartCId != null)
										chartObj_id = 'chartParent_multgrp_activity3_'+topUserJsonDataObj.chartCId+'_'+i;
									else
										chartObj_id = 'chartParent_multgrp_activity3_'+i;

									if(chartObj_id.indexOf("(") != -1)
										chartObj_id = chartObj_id.replace("(","LB")

									if(chartObj_id.indexOf(")") != -1)
										chartObj_id = chartObj_id.replace(")","RB")
									
									if(!Ext.isEmpty(Ext.getCmp(chartObj_id)))
										Ext.getCmp(chartObj_id).updateChart(chartObj_id+'-body',topUserJsonDataObj,'Line');									
								}
							}
						}
					}
				},{
					title:memain.data[10].UserDevicesView_sixth_block_header,
					width:'100%',
					layout:{type:'anchor',anchor:'50%'},
					margin:'0 2 10 0',
					bodyPadding:'0 20 20 20',
					collapsed :false,
					items:[{
						xtype:'chartparentpanel',
						id:'multgrp_activity4',
						//bodyPadding:'0 1'
						//margin:'0 0 0 12',
						bodyPadding:'0 0 0 0',
						style:{'left':'-12px'},
						ifRes:true,
						data:memain.data[5].UserDevicesView_sixth_block,
						orgData:memain.data[5].UserDevicesView_sixth_block,
						flex:1						
					}],
					listeners: {
						afterlayout: function() {
							var res_chartObj = Ext.getCmp('multgrp_activity4');
							
							if(!Ext.isEmpty(res_chartObj) && !Ext.isEmpty(res_chartObj.data) && res_chartObj.data!=undefined)
							{
								for (var i= 0; i <  res_chartObj.data.length;i++ )
								{
									var topUserJsonDataObj=null;
									try
									{
										topUserJsonDataObj=res_chartObj.data[i];
									}
									catch (ee)
									{
										topUserJsonDataObj=res_chartObj.data[i];
									}

									if(topUserJsonDataObj == undefined || topUserJsonDataObj == null)
										continue;

									//var chartObj_id = 'chartParent_multgrp_activity_'+res_chartObj.orgData[i].chartCId+'_'+i;
									var chartObj_id = '';
									if(topUserJsonDataObj.chartCId != undefined && topUserJsonDataObj.chartCId != null)
										chartObj_id = 'chartParent_multgrp_activity4_'+topUserJsonDataObj.chartCId+'_'+i;
									else
										chartObj_id = 'chartParent_multgrp_activity4_'+i;

									if(chartObj_id.indexOf("(") != -1)
										chartObj_id = chartObj_id.replace("(","LB")

									if(chartObj_id.indexOf(")") != -1)
										chartObj_id = chartObj_id.replace(")","RB")

									if(!Ext.isEmpty(Ext.getCmp(chartObj_id)))
									{
										$('#'+chartObj_id+'-body').width('100%');
										var skinBorder=( (strSkin=='Dark' || strSkin=='dark') )?'#525252':'#f2f2f2';
										if(i%2 == 0)
										{
											Ext.getCmp(chartObj_id).getEl().dom.style.borderRight="1px solid "+skinBorder;
										}
										else
										{
											Ext.getCmp(chartObj_id).getEl().dom.style.borderRight="0px solid "+skinBorder;
										}
											

										if((res_chartObj.data.length-2)>i)
											Ext.getCmp(chartObj_id).getEl().dom.style.borderBottom="1px solid "+skinBorder;
										else
											Ext.getCmp(chartObj_id).getEl().dom.style.borderBottom="0px solid "+skinBorder;
									}
								}
							}
						},
						expand: function() 
						{						
							var res_chartObj = Ext.getCmp('multgrp_activity4');
							
							if(!Ext.isEmpty(res_chartObj) && !Ext.isEmpty(res_chartObj.data) && res_chartObj.data!=undefined)
							{							
								for (var i= 0; i <  res_chartObj.data.length;i++ )
								{
									var topUserJsonDataObj=null;
									try
									{
										topUserJsonDataObj=res_chartObj.data[i];
									}
									catch (ee)
									{
										topUserJsonDataObj=res_chartObj.data[i];
									}

									if(topUserJsonDataObj == undefined || topUserJsonDataObj == null)
										continue;
									
									if(topUserJsonDataObj.chartCId != undefined && topUserJsonDataObj.chartCId != null)
										chartObj_id = 'chartParent_multgrp_activity4_'+topUserJsonDataObj.chartCId+'_'+i;
									else
										chartObj_id = 'chartParent_multgrp_activity4_'+i;

									if(chartObj_id.indexOf("(") != -1)
										chartObj_id = chartObj_id.replace("(","LB")

									if(chartObj_id.indexOf(")") != -1)
										chartObj_id = chartObj_id.replace(")","RB")
									
									if(!Ext.isEmpty(Ext.getCmp(chartObj_id)))
										Ext.getCmp(chartObj_id).updateChart(chartObj_id+'-body',topUserJsonDataObj,'Line');									
								}
							}
						}
					}
				}]
			});
		}
	}
});