Ext.define('microsoftDashboard.view.microsoftTeams.ServiceHealthPage', {
    extend: 'Ext.panel.Panel',
	alias: 'widget.MS_Teams_Dashboard.servicehealthpage',
	ui:'eg-panel',
    border: false,
    autoScroll: false,
    scroll: false,
    layout: {
        type: 'vbox',
        align: 'stretch'
    },
	flex:1,
	items:[],
	updatePage:function(jsonData)
	{
		Ext.getCmp('eo_header_id').setTitle('<span style="float:left;">'+jsonData[2].Service_health_view_header+'</span><span style="display:'+jsonData[jsonData.length-1].layerUrlDisplay+';margin-top:-3px;margin-left:5px;float:left" class="iconRumToLayermodel handSymbol" data-qclass="yellowTip" data-qtip="Layer Model" href="javascript:void(0);" onclick="javascript:DashboardToLayers(\''+jsonData[jsonData.length-1].layerUrl+'\');"></span>');
		var textData = jsonData[0].HealthView_first_block;
		for(var y=0;y<textData.length;y++)
		{
			Ext.getCmp(textData[y].measure+""+y).getStore().loadRawData(textData[y]);
		}

		Ext.getCmp('activitiesStatus').updateChart(jsonData[1].HealthView_second_block);
		
	},
	listeners:
	{
		afterrender:function(e)
		{
			var memain = this;
			memain.add({
				xtype:'header',
				height:25,
				margin:'0 0 5 0',
				id:'eo_header_id',
				title:'<span style="float:left;">'+memain.data[2].Service_health_view_header+'</span><span style="display:'+memain.data[memain.data.length-1].layerUrlDisplay+';margin-top:-3px;margin-left:5px;float:left" class="iconRumToLayermodel handSymbol" data-qclass="yellowTip" data-qtip="Layer Model" href="javascript:void(0);" onclick="javascript:DashboardToLayers(\''+memain.data[memain.data.length-1].layerUrl+'\');"></span>'
			});
			memain.add({
				xtype:'container',
				ui:'eg-container',
				height:95,
				margin:'0 1 1 0',
				layout:{
					type:'hbox',
					align:'stretch'
				},
				listeners:
				{
					afterrender:function(e)
					{
						var me = this;
						var firstBlockArray = memain.data[0].HealthView_first_block;
						for(var t=0;t<firstBlockArray.length;t++)
						{
							me.add({
								xtype:'dataview',
								cls:'dividerGradient',
								ui:'uniqueSessions',
								id:firstBlockArray[t].measure+""+t,
								minWidth:190,
								flex:1,
								store: Ext.create('Ext.data.Store', {
									fields: [{ name:'iconCls', type:'string' },{ name:'backgroundCls', type:'string' },{ name:'value', type:'string' },{ name:'valueText', type:'string'},{ name:'valueStatus', type:'string'},{ name:'layerLink',type:'string'},{ name:'stateValue', type:'string'}],
									autoLoad:true,
									data:firstBlockArray[t]
								}),
								tpl:new Ext.XTemplate(
									'<div class="widgetholders" style="height:100%;width:100%;margin:0px;display:flex;">',
										'<tpl for=".">',
												'<tpl if="xindex === 1">',
													'<tpl if="layerLink!=&quot;&quot;">',
														'<div onClick="javascript:layerModelLinks(\'{layerLink}\')" style="position:relative;flex:1;text-align:center;cursor:pointer;" class="{backgroundCls}">',
													'<tpl else>',
														'<tpl if="valueText==\'Events\'">',
															'<div onClick="javascript:gotoSpecPage(\'All_Events\',\'365AlarmDetailsDashboard\')" style="cursor:pointer;position:relative;flex:1;text-align:center;" class="{backgroundCls} ms-separator">',
														'<tpl else>',
															'<tpl if="valueText==\'Connection Status\'">',
																'<div onClick="javascript:scrollAnimation(\'chartParent_activitiesStatus_0\')" style="position:relative;flex:1;text-align:center;cursor:pointer;" class="{backgroundCls}">',
															'<tpl elseif="valueText==\'Time Taken to Connect (sec)\'">',
																'<div onClick="javascript:scrollAnimation(\'chartParent_activitiesStatus_1\')" style="position:relative;flex:1;text-align:center;cursor:pointer;" class="{backgroundCls}">',
															'<tpl else>',
																'<div style="position:relative;flex:1;text-align:center;" class="{backgroundCls} ms-separator">',
															'</tpl>',
														'</tpl>',														
													'</tpl>',
												'<tpl elseif="xindex === 2">',
													'<div style="position:relative;flex:1;text-align:center;" class="{backgroundCls}">',
												'<tpl else>',
													'<tpl if="valueText==\'Connection Status\'">',
														'<div onClick="javascript:scrollAnimation(\'chartParent_activitiesStatus_0\')" style="position:relative;flex:1;text-align:center;cursor:pointer;" class="{backgroundCls}">',
													'<tpl elseif="valueText==\'Time Taken to Connect (sec)\'">',
														'<div onClick="javascript:scrollAnimation(\'chartParent_activitiesStatus_1\')" style="position:relative;flex:1;text-align:center;cursor:pointer;" class="{backgroundCls}">',
													'<tpl else>',
														'<div style="position:relative;flex:1;text-align:center;" class="{backgroundCls} ms-separator">',
													'</tpl>',													
												'</tpl>',
												'<div class="d_m_t25">',
													'<div style="display:inline-block;">',
														'<tpl if="stateValue">',
															'<img src="/final/images/clear.png" class="stateIcon22_{stateValue}" style="float:left;margin-right:8px;margin-top:3px;">',
														'<tpl else>',
															'<img src="/final/images/clear.png" class="{iconCls}" style="float:left;margin-right:8px">',
														'</tpl>',
														'<span class="f24-normal">{value}',
															'<span class="f19-normal"></span>',
														'</span>',
													'</div>',
													'<tpl if="backgroundCls==&quot;&quot;">',
														'<div style="width:80%;margin:10px auto auto auto;" class="f12-normal">{valueText}</div>',
													'<tpl else>',
														'<div style="width:80%;margin:10px auto auto auto;color:white;" class="f12-normal">{valueStatus}</div>',
													'</tpl>',
												'</div>',
											'</div>',
										'</tpl>',
									'</div>'
								)
							});
						}
					}
				}
			});
			memain.add({
				xtype:'container',
				padding:0,
				id:'geoBarIns',
				bodyPadding:0,
				margin:'8 0 0 0',
				flex:1,
				layout: {
					type: 'card',
					reserveScrollbar: true 
				},
				items:[{
					xtype:'chartparentpanel',
					margin:0,
					id:'activitiesStatus',
					data:memain.data[1].HealthView_second_block,
					orgData:memain.data[1].HealthView_second_block,
					flex:1						
				}]
			});
		}
	}
});