Ext.define('microsoftDashboard.view.microsoftTeams.CallSummaryPage', {
    extend: 'Ext.panel.Panel',
	alias: 'widget.MS_Teams_Dashboard.callsummarypage',
	ui:'eg-panel',
	border: false,
    autoScroll: false,
    scroll: false,
    layout: {
        type: 'vbox',
        align: 'stretch'
    },
	flex:1,
	requires:[
		'microsoftDashboard.view.CommonGrid'	
	],
	items:[],
	updatePage:function(jsonData)
	{
		var poorAppDataChaeck = jsonData[2].CallQualityView_third_block;
		for(var i=0;i<poorAppDataChaeck.length;i++)
		{
			if(poorAppDataChaeck[i].title.startsWith("Poor"))
			{
				if(!Ext.isEmpty(poorAppDataChaeck[0]) && poorAppDataChaeck[0].hasOwnProperty("DataSet"))
					Ext.getCmp('chartParent_poorApp_'+i).show();
				else
					Ext.getCmp('chartParent_poorApp_'+i).hide();
			}
		}
		if(!Ext.isEmpty(poorAppDataChaeck[0]) && poorAppDataChaeck[0].hasOwnProperty("DataSet"))
			Ext.getCmp('res_acc_pan_id').show();
		else
			Ext.getCmp('res_acc_pan_id').hide();

		Ext.getCmp('lusage_header_id').setTitle('<span style="float:left;">'+jsonData[4].call_quality_view_header+'</span><span style="display:'+jsonData[jsonData.length-1].layerUrlDisplay+';margin-top:-3px;margin-left:5px;float:left" class="iconRumToLayermodel handSymbol" data-qclass="yellowTip" data-qtip="Layer Model" href="javascript:void(0);" onclick="javascript:DashboardToLayers(\''+jsonData[jsonData.length-1].layerUrl+'\');"></span>');	
		var textData = jsonData[0].CallQualityView_first_block;
		for(var y=0;y<textData.length;y++)
		{
			Ext.getCmp(textData[y].measure+""+y).getStore().loadRawData(textData[y]);
		}
		Ext.getCmp('streamDist').updatePanel(jsonData);
		Ext.getCmp('mailRecievers').updatePanel(jsonData);
		Ext.getCmp('fieldCalls').updatePanel(jsonData);

		Ext.getCmp('poorApp').updateChart(jsonData[2].CallQualityView_third_block);

		Ext.getCmp('topTenGrid1').setTitle(jsonData[3].CallQualityView_fourth_block[0].title);
		Ext.getCmp('topTenGridId1').loadData(jsonData[3].CallQualityView_fourth_block[0]);

		Ext.getCmp('topTenGrid2').setTitle(jsonData[3].CallQualityView_fourth_block[1].title);
		Ext.getCmp('topTenGridId2').loadData(jsonData[3].CallQualityView_fourth_block[1]);

		Ext.getCmp('topTenGrid3').setTitle(jsonData[3].CallQualityView_fourth_block[2].title);
		Ext.getCmp('topTenGridId3').loadData(jsonData[3].CallQualityView_fourth_block[2]);

		Ext.getCmp('topTenGrid4').setTitle(jsonData[3].CallQualityView_fourth_block[3].title);
		Ext.getCmp('topTenGridId4').loadData(jsonData[3].CallQualityView_fourth_block[3]);
	},
	listeners:
	{
		afterrender:function(e)
		{
			var memain = this;
			memain.add({
				xtype:'header',
				height:25,
				margin:'0 0 5 0',
				id:'lusage_header_id',
				title:'<span style="float:left;">'+memain.data[4].call_quality_view_header+'</span><span style="display:'+memain.data[memain.data.length-1].layerUrlDisplay+';margin-top:-3px;margin-left:5px;float:left" class="iconRumToLayermodel handSymbol" data-qclass="yellowTip" data-qtip="Layer Model" href="javascript:void(0);" onclick="javascript:DashboardToLayers(\''+memain.data[memain.data.length-1].layerUrl+'\');"></span>'					
			});

			memain.add({
				xtype:'container',
				ui:'eg-container',
				height:95,
				margin:'0 1 1 0',
				layout:{
					type:'hbox',
					align:'stretch'
				},
				listeners:
				{
					afterrender:function(e)
					{
						var me = this;
						var firstBlockArray = memain.data[0].CallQualityView_first_block;
						for(var t=0;t<firstBlockArray.length;t++)
						{
							me.add({
								xtype:'dataview',
								cls:'dividerGradient',
								ui:'uniqueSessions',
								id:firstBlockArray[t].measure+""+t,
								minWidth:190,
								flex:1,
								store: Ext.create('Ext.data.Store', {
									fields: [{ name:'iconCls', type:'string' },{ name:'backgroundCls', type:'string' },{ name:'value', type:'string' },{ name:'valueText', type:'string'},{ name:'valueStatus', type:'string'},{ name:'layerLink',type:'string'},{ name:'stateValue', type:'string'}],
									autoLoad:true,
									data:firstBlockArray[t]
								}),
								tpl:new Ext.XTemplate(
									'<div class="widgetholders" style="height:100%;width:100%;margin:0px;display:flex;">',
										'<tpl for=".">',
												'<tpl if="xindex === 1">',
													'<tpl if="layerLink!=&quot;&quot;">',
														'<div onClick="javascript:layerModelLinks(\'{layerLink}\')" style="position:relative;flex:1;text-align:center;cursor:pointer;" class="{backgroundCls}">',
													'<tpl else>',
														'<tpl if="valueText==\'Total Streams (Number)\'">',
															'<div onClick="javascript:scrollAnimation(\'streamDist\')" style="position:relative;flex:1;text-align:center;cursor:pointer;" class="{backgroundCls}">',
														'<tpl else>',
															'<div style="position:relative;flex:1;text-align:center;" class="{backgroundCls}">',
														'</tpl>',
													'</tpl>',
												'<tpl elseif="xindex === 2">',
													'<div style="position:relative;flex:1;text-align:center;" class="{backgroundCls}">',
												'<tpl else>',
													'<div style="position:relative;flex:1;text-align:center;" class="{backgroundCls} ms-separator">',
												'</tpl>',
												'<div class="d_m_t25">',
													'<div style="display:inline-block;">',
														'<tpl if="stateValue">',
															'<img src="/final/images/clear.png" class="stateIcon22_{stateValue}" style="float:left;margin-right:8px;margin-top:3px;">',
														'<tpl else>',
															'<img src="/final/images/clear.png" class="{iconCls}" style="float:left;margin-right:8px">',
														'</tpl>',
														'<span class="f24-normal">{value}',
															'<span class="f19-normal"></span>',
														'</span>',
													'</div>',
													'<tpl if="backgroundCls==&quot;&quot;">',
														'<div style="width:80%;margin:10px auto auto auto;" class="f12-normal">{valueText}</div>',
													'<tpl else>',
														'<div style="width:80%;margin:10px auto auto auto;color:white;" class="f12-normal">{valueStatus}</div>',
													'</tpl>',
												'</div>',
											'</div>',
										'</tpl>',
									'</div>'
								)
							});
						}
					}
				}
			});

			memain.add({
				xtype:'container',
				//ui:'eg-container',
				layout:'column',
				margin:'10 0 10 0',
				listeners:
				{
					afterrender:function(e)
					{
						var me = this;
						me.add({
							xtype:'panel',
							ui: 'eg-x-panel',
							margin:'0 10 0 0',
							height:225,
							id:'streamDist',
							columnWidth:.32,
							tools:[{
								xtype:'label',
								cls:'font_bold9 grayColor',
								id:'streamDistTools',
								style:{"white-space":"nowrap"},
								text: memain.data[1].CallQualityView_second_block[0].chartHistory
							}],
							updatePanel:function(data)
							{
								this.setTitle(data[1].CallQualityView_second_block[0].title);
								Ext.getCmp("streamDistTools").setText(data[1].CallQualityView_second_block[0].chartHistory);
								Ext.getCmp('streamDistView').getStore().loadRawData(data[1].CallQualityView_second_block[0]);
								Ext.getCmp('streamDistView').updateView(data[1].CallQualityView_second_block[0]);
							},
							listeners:
							{
								afterrender:function()
								{
									var me = this;
									me.setTitle(memain.data[1].CallQualityView_second_block[0].title);
									me.add({
										xtype:'dataview',
										id:'streamDistView',
										layout:{type:'vbox',pack:'center'},
										store: Ext.create('Ext.data.Store', {
											 fields: [{ name:'state', type:'string' },{ name:'name', type:'string' },{ name:'title', type:'string' },{ name:'noData', type:'boolean' },{ name:'value', type:'number' },{ name:'valueText', type:'string' },{ name:'sessions' },{ name:'data' },{name:'graphID', type:'string' },{name:'DataSet'},{name:'Mails'},{ name:'layerLink',type:'string'}],
											autoLoad:true,
											data:memain.data[1].CallQualityView_second_block[0]
										}),
										tpl: new Ext.XTemplate(
											'<tpl for=".">',
											'<div class="widgetholders" style="height:100%;margin-top:0px;border:0px solid red !important">',				
												'<div class="b_box1" style="margin:auto;width:100%;height:100%;display:inline-flex;">',
												  /*'<div class="f14-bold"><img style="vertical-align:sub" src="/final/images/clear.png" class="stateIconRumAppFlow{state}" /> <span></ span></div>',*/
													 '<div style="display:flex; margin:auto auto;height:100%;width:100%;"><div  style=" height:100%;margin:auto 0px auto auto;width:100%;" id="'+me.id+'_bgDonut" ></div>',
													 '<div style="margin:auto auto auto 0px;width:100%;height:100%;display:flex;overflow:auto">',
													 '<div style="margin:auto auto auto 0px;">',
															'<tpl for="DataSet">',
																'<tpl for="data">',
																 '<tpl if="color !=&quot;'+strSkinclr+'&quot;">',
																	'<tpl if="layerLink!=&quot;&quot;">',
																		'<div style="padding:0px 0px 10px 0px !important;cursor:pointer" class="widgetholders {handSymbol}" onClick="javascript:layerModelLinks(\'{layerLink}\')"><div style="display:table-cell;margin-top:-10px;margin-right:5px;"><div class="msChartLegend" style="position:relative;top:-1px;background:{color}"></div></div><div  style="display:table-cell;" class="f11-normal">{name}&nbsp;({value})</div></div>',
																	'<tpl else>',
																		'<div style="padding:0px 0px 10px 0px !important;" class="widgetholders {handSymbol}" ><div style="display:table-cell;margin-top:-10px;margin-right:5px;"><div class="msChartLegend" style="position:relative;top:-1px;background:{color}"></div></div><div  style="display:table-cell;" class="f11-normal">{name}&nbsp;({value})</div></div>',
																	'</tpl>',
																 '</tpl>',
																'</tpl>',
															'</tpl>',
														//'</table>',
														'</div>',
													'</div>',											
												'</div></div>',
											'</tpl>',
											'</div>'
										),
										updateView:function(viewData)
										{
											var checkData = noDataComputefunction(viewData);
											var allMeasureTotal='';
												if(!checkData)
												{
													try
													{
														var pieChart = {};
														var chartData = viewData;
														var dontCheck = true;
														chartData['outersize']='100%';
														chartData['innersize']='30%';
														chartData['showLegend']=false;
														allMeasureTotal=chartData["allMeasureTotal"];
														chartData['title']="";
														try
														{
															var seriesData = chartData.DataSet[0].data;
															var allZero = 0;
															for(var z=0;z<seriesData.length;z++)
															{
																allZero += seriesData[z].y;
															}
															if(allZero == 0)
																chartData.DataSet[0].data[seriesData.length] = {name:"-", color: "#cdcdcd", y:100, value: "-"};
														}
														catch (e)
														{
														}
														pieChart = jQuery.extend(true, {}, getDonutChartsInstance1(this.id,null,null), pieChart);
														pieChart.setData(chartData,'','','bgdonut');
														jsonData = pieChart.highchart;													
													}
													catch (er)
													{														
													}
													
													$('#'+me.id+"_bgDonut").highcharts(jsonData);
													/*$('#'+me.id+"_bgDonut").highcharts(jsonData,
														function(chart) { 
														 var textX = chart.plotLeft + (chart.series[0].center[0]);
															var textY = chart.plotTop  + (chart.series[0].center[1]);
															var span = '<span id="'+me.id+'pieChartInfoText" style="position:absolute; text-align:center;font-family:Roboto;font-size:22px;">'+allMeasureTotal+'</span>';
															$("#"+me.id+"addText").append(span);
															span = $('#'+me.id+'pieChartInfoText');
															span.css('left', textX + (span.width() * -0.5));
															span.css('top', textY + (span.height() * -0.5));
													});*/
												}
												else
												{
													this.update('<div style="height:100%;width:100%;display:table"><div class="msgFont" style="display:table-cell;vertical-align:middle"> <div class="iconInformation" style="margin:0px auto"></div><div style="text-align:center">No Data Found!</div></div></div>');
												}
										},
										listeners:{
											viewready:function(){
												var chartData = memain.data[1].CallQualityView_second_block[0];
												var checkData = noDataComputefunction(chartData);
												var allMeasureTotal='';
												if(!checkData)
												{
													try
													{
														var pieChart = {};
														var dontCheck = true;
														chartData['outersize']='100%';
														chartData['innersize']='30%';
														chartData['showLegend']=false;
														allMeasureTotal=chartData["allMeasureTotal"];
														chartData['title']="";
														try
														{
															var seriesData = chartData.DataSet[0].data;
															var allZero = 0;
															for(var z=0;z<seriesData.length;z++)
															{
																allZero += seriesData[z].y;
															}
															if(allZero == 0)
																chartData.DataSet[0].data[seriesData.length] = {name:"-", color: "#cdcdcd", y:100, value: "-"};
														}
														catch (e)
														{
														}
														pieChart = jQuery.extend(true, {}, getDonutChartsInstance1(this.id,null,null), pieChart);
														pieChart.setData(chartData,'','','bgdonut');
														jsonData = pieChart.highchart;													
													}
													catch (er)
													{														
													}
													$('#'+me.id+"_bgDonut").highcharts(jsonData);
													/*$('#'+me.id+"_bgDonut").highcharts(jsonData,
														function(chart) { 
														 var textX = chart.plotLeft + (chart.series[0].center[0]);
															var textY = chart.plotTop  + (chart.series[0].center[1]);
															var span = '<span id="'+me.id+'pieChartInfoText" style="position:absolute; text-align:center;font-family:Roboto;font-size:22px;">'+allMeasureTotal+'</span>';
															$("#"+me.id+"addText").append(span);
															span = $('#'+me.id+'pieChartInfoText');
															span.css('left', textX + (span.width() * -0.5));
															span.css('top', textY + (span.height() * -0.5));
													});*/
												}
												else
												{
													this.update('<div style="height:100%;width:100%;display:table"><div class="msgFont" style="display:table-cell;vertical-align:middle"> <div class="iconInformation" style="margin:0px auto"></div><div style="text-align:center">No Data Found!</div></div></div>');
												}
											}
										},
									});
								}
							}
						},{
							xtype:'panel',
							columnWidth:.36,
							title:memain.data[1].CallQualityView_second_block[1].title,
							id:'mailRecievers',
							ui: 'eg-x-panel',
							height:225,
							margin:'0 10 0 0',
							bodyPadding:8,
							tools:[{
								xtype:'label',
								cls:'font_bold9 grayColor',
								id:'mailRecieversTools',
								style:{"white-space":"nowrap"},
								text: memain.data[1].CallQualityView_second_block[1].chartHistory
							}],
							updatePanel:function(data)
							{
								var me = this;
								Ext.getCmp("mailRecieversTools").setText(data[1].CallQualityView_second_block[1].chartHistory);
								var chartData = data[1].CallQualityView_second_block[1];
								var checkData = noDataComputefunction(chartData);
								if(!checkData)
								{
									try{
										var barChart = {};
										barChart = jQuery.extend(true, {}, createBarforCtx('',null,null), barChart);
										me.setTitle(chartData["title"]);
										chartData["title"] = "";
										chartData["marginTop"] = 0;
										chartData["setPointWidth"] = null;
										chartData["fromPage"] = "Microsoft";
										barChart.setData(chartData,'','','bar');
										var chartSeriesData = barChart.highchart;
										$('#'+me.body.id).highcharts(chartSeriesData);
									}catch(eo){
										me.update('<div style="height:100%;width:100%;display:table"><div class="msgFont" style="display:table-cell;vertical-align:middle"> <div class="iconInformation" style="margin:0px auto"></div><div style="text-align:center">No Data Found!</div></div></div>');
									}
								}
							else
								{
									this.update('<div style="height:100%;width:100%;display:table"><div class="msgFont" style="display:table-cell;vertical-align:middle"> <div class="iconInformation" style="margin:0px auto"></div><div style="text-align:center">No Data Found!</div></div></div>');
								}
							},
							listeners:
							{
								boxready:function(e)
								{
									var me = this;
									var chartData = memain.data[1].CallQualityView_second_block[1];
									var checkData = noDataComputefunction(chartData);
									if(!checkData)
									{
										try{
											var barChart = {};
											barChart = jQuery.extend(true, {}, createBarforCtx('',null,null), barChart);
											chartData["title"] = "";
											chartData["marginTop"] = 0;
											chartData["setPointWidth"] = null;
											chartData["fromPage"] = "Microsoft";
											barChart.setData(chartData,'','','bar');
											var chartSeriesData = barChart.highchart;
											$('#'+me.id+'-body').highcharts(chartSeriesData);
										}catch(eo){
											me.update('<div style="height:100%;width:100%;display:table"><div class="msgFont" style="display:table-cell;vertical-align:middle"> <div class="iconInformation" style="margin:0px auto"></div><div style="text-align:center">No Data Found!</div></div></div>');
										}
									}
									else
										{
											this.update('<div style="height:100%;width:100%;display:table"><div class="msgFont" style="display:table-cell;vertical-align:middle"> <div class="iconInformation" style="margin:0px auto"></div><div style="text-align:center">No Data Found!</div></div></div>');
										}
								}
							}
						},{
							xtype:'panel',
							ui: 'eg-x-panel',
							margin:'0 1 0 0',
							height:225,
							id:'fieldCalls',
							columnWidth:.32,
							tools:[{
								xtype:'label',
								cls:'font_bold9 grayColor',
								id:'fieldCallsTools',
								style:{"white-space":"nowrap"},
								text: memain.data[1].CallQualityView_second_block[2].chartHistory
							}],
							updatePanel:function(data)
							{
								this.setTitle(data[1].CallQualityView_second_block[2].title);
								Ext.getCmp("fieldCallsTools").setText(data[1].CallQualityView_second_block[2].chartHistory);
								Ext.getCmp('fieldCallsView').getStore().loadRawData(memain.data[1].CallQualityView_second_block[2]);
								Ext.getCmp('fieldCallsView').updateView(memain.data[1].CallQualityView_second_block[2]);
							},
							listeners:
							{
								afterrender:function()
								{
									var me = this;
									me.setTitle(memain.data[1].CallQualityView_second_block[2].title);
									me.add({
										xtype:'dataview',
										id:'fieldCallsView',
										layout:{type:'vbox',pack:'center'},
										store: Ext.create('Ext.data.Store', {
											 fields: [{ name:'state', type:'string' },{ name:'name', type:'string' },{ name:'title', type:'string' },{ name:'noData', type:'boolean' },{ name:'value', type:'number' },{ name:'valueText', type:'string' },{ name:'sessions' },{ name:'data' },{name:'graphID', type:'string' },{name:'data'},{name:'Mails'},{ name:'layerLink',type:'string'}],
											autoLoad:true,
											data:memain.data[1].CallQualityView_second_block[2]
										}),
										tpl: new Ext.XTemplate(
											'<tpl for=".">',
											'<div class="widgetholders" style="height:100%;margin-top:0px;border:0px solid red !important">',				
												'<div class="b_box1" style="margin:auto;width:100%;height:100%;display:inline-flex;">',
												 /* '<div class="f14-bold"><img style="vertical-align:sub" src="/final/images/clear.png" class="stateIconRumAppFlow{state}" /> <span></ span></div>',*/
													 '<div style="display:flex;width:100%;"><div  style=" height:100%;width:100%;margin:auto auto auto auto" id="'+me.id+'_bgDonut"></div>',
													 '<div style="margin:auto auto auto auto;height: 100%;width:100%;display:flex;overflow:auto">',
														 '<div style="margin:auto auto auto 0px;">',
															'<tpl for="data">',
															 '<tpl if="color !=&quot;'+strSkinclr+'&quot;">',
																'<tpl if="layerLink!=&quot;&quot;">',
																	'<div style="padding:0px 0px 10px 0px !important;cursor:pointer" class="widgetholders {handSymbol}" onClick="javascript:layerModelLinks(\'{layerLink}\')"><div style="display:table-cell;margin-top:-10px;margin-right:5px;"><div class="msChartLegend" style="position:relative;top:-1px;background:{color}"></div></div><div  style="display:table-cell;" class="f11-normal">{name}&nbsp;({value})</div></div>',
																'<tpl else>',
																	'<div style="padding:0px 0px 10px 0px !important;" class="widgetholders {handSymbol}" ><div style="display:table-cell;margin-top:-10px;margin-right:5px;"><div class="msChartLegend" style="position:relative;top:-1px;background:{color}"></div></div><div  style="display:table-cell;" class="f11-normal">{name}&nbsp;({value})</div></div>',
																'</tpl>',
															 '</tpl>',
															'</tpl>',
														'</div>',
													'</div>',											
												'</div></div>',
											'</tpl>',
											'</div>'
										),
										updateView:function(viewData)
										{
											var checkData = noDataComputefunction(viewData);
											var chartData = viewData;
											if(!checkData)
											{
												try
												{
													var pieChart = {};													
													chartData['outersize']='100%';
													chartData['innersize']='30%';
													chartData['showLegend']=false;
													chartData['title']="";
													try
													{
														var seriesData = chartData.data;
														var allZero = 0;
														for(var z=0;z<seriesData.length;z++)
														{
															allZero += seriesData[z].y;
														}
														if(allZero == 0)
															chartData.data[seriesData.length] = {name:"-", color: "#cdcdcd", y:100, value: "-"};

													chartData['DataSet']=[{"data":chartData['data']}];
												}
												catch (e)
												{
													chartData['DataSet']=[];
												}
												

													pieChart = jQuery.extend(true, {}, getDonutChartsInstance1(this.id,null,null), pieChart);
													pieChart.setData(chartData,'','','bgdonut');
													var chartSeriesData = pieChart.highchart;													
												}
												catch (er)
												{													
												}
												$('#'+me.id+"_bgDonut").highcharts(chartSeriesData);
											}
										else
											{
												if(chartData.hasOwnProperty("positiveMessage") && chartData["positiveMessage"].length > 0)
												{
													this.update('<div style="height:100%;width:100%;display:table"><div class="msgFont" style="display:table-cell;vertical-align:middle"> <div class="iconNoAlarms" style="margin:0px auto"></div><div style="text-align:center">'+chartData["positiveMessage"]+'</div></div></div>');
												}
												else
												{
													this.update('<div style="height:100%;width:100%;display:table"><div class="msgFont" style="display:table-cell;vertical-align:middle"> <div class="iconInformation" style="margin:0px auto"></div><div style="text-align:center">No Data Found!</div></div></div>');
												}
											}
										},
										listeners:{
											viewready:function(){
												var chartData = memain.data[1].CallQualityView_second_block[2];
												var checkData = noDataComputefunction(chartData);
												if(!checkData)
												{
													try
													{
														var pieChart = {};
														chartData['outersize']='100%';
														chartData['innersize']='30%';
														chartData['title']="";
														chartData['showLegend']=false;
														try
														{
															//var seriesData = chartData.DataSet[0].data;
															var seriesData = chartData.data;
															var allZero = 0;
															for(var z=0;z<seriesData.length;z++)
															{
																allZero += seriesData[z].y;
															}
															if(allZero == 0)
																chartData.data[seriesData.length] = {name:"-", color: "#cdcdcd", y:100, value: "-"};

															chartData['DataSet']=[{"data":chartData['data']}];
														}
														catch (e)
														{
															chartData['DataSet']=[];
														}													

														pieChart = jQuery.extend(true, {}, getDonutChartsInstance1(this.id,null,null), pieChart);
														pieChart.setData(chartData,'','','bgdonut');
														var chartSeriesData = pieChart.highchart;													
													}
													catch (er)
													{														
													}
													$('#'+me.id+"_bgDonut").highcharts(chartSeriesData);
												}
											else
												{
													if(chartData.hasOwnProperty("positiveMessage") && chartData["positiveMessage"].length > 0)
													{
														this.update('<div style="height:100%;width:100%;display:table"><div class="msgFont" style="display:table-cell;vertical-align:middle"> <div class="iconNoAlarms" style="margin:0px auto"></div><div style="text-align:center">'+chartData["positiveMessage"]+'</div></div></div>');
													}
													else
													{
														this.update('<div style="height:100%;width:100%;display:table"><div class="msgFont" style="display:table-cell;vertical-align:middle"> <div class="iconInformation" style="margin:0px auto"></div><div style="text-align:center">No Data Found!</div></div></div>');
													}
												}
											}
										},
									});
								}
							}
						});
					}
				}
			});
			
			memain.add({
				xtype:'container',
				padding:0,
				id:'geoBarIns',
				bodyPadding:0,
				margin:'0 0 0 0',
				flex:1,
				layout: {
					type: 'card',
					reserveScrollbar: true 
				},
				items:[{
					xtype:'chartparentpanel',
					margin:0,
					id:'poorApp',
					data:memain.data[2].CallQualityView_third_block,
					orgData:memain.data[2].CallQualityView_third_block,
					flex:1
				}]
			});	
			
			
			memain.add({
				xtype:'panel',
				id:'res_acc_pan_id',
				ui:'eg-accordion-panel groupedAccordian',
				padding:20,
				margin:'0 0 10 0',
				//fill:true,
				flex:2,
				layout: {
					type: 'accordion',
					animate: true,
					multi: true,				
				},
				items:[{
					title:memain.data[3].CallQualityView_fourth_block[0].title,
					width:'100%',
					layout:{type:'anchor',anchor:'50%'},
					margin:'0 2 0 0',
					id:'topTenGrid1',						
					collapsed :false,
					items:[{
						xtype:'panel',
						padding:'0 10 10 10',
						layout:'fit',
						height:200,
						margin:0,							
						items:[{
							xtype:'commongrid',
							width:'99%',
							id:'topTenGridId1',								
							data:memain.data[3].CallQualityView_fourth_block[0],
							orgData:memain.data[3].CallQualityView_fourth_block[0]
						}],
					listeners:
							{
							 afterrender:function()
							 {
								 try
								 {
									var gridDataLength=memain.data[3].CallQualityView_fourth_block[0].data.items.length;
									 if(gridDataLength<10 && gridDataLength>0)
									 {
										this.setHeight(68+(30*gridDataLength));
									 }
								 }
								 catch (e)
								 {
								 }
								 
							 }
							},
					}],
					listeners:{
						expand: function() 
						{
							var grid_obj = Ext.getCmp('topTenGridId1');
							grid_obj.loadData(grid_obj.orgData);	
						}
					}
				},{
					title:memain.data[3].CallQualityView_fourth_block[1].title,
					width:'100%',
					layout:{type:'anchor',anchor:'50%'},
					margin:'0 2 0 0',
					id:'topTenGrid2',
					collapsed :false,
					items:[{
						xtype:'panel',
						padding:'0 10 10 10',
						layout:'fit',
						height:200,
						margin:0,							
						items:[{
							xtype:'commongrid',
							width:'99%',
							id:'topTenGridId2',								
							data:memain.data[3].CallQualityView_fourth_block[1],
							orgData:memain.data[3].CallQualityView_fourth_block[1]
						}],
					listeners:
							{
							 afterrender:function()
							 {
								 try
								 {
									var gridDataLength=memain.data[3].CallQualityView_fourth_block[1].data.items.length;
									 if(gridDataLength<10 && gridDataLength>0)
									 {
										this.setHeight(68+(30*gridDataLength));
									 }
								 }
								 catch (e)
								 {
								 }
								 
							 }
							},
					}],
					listeners:{
						expand: function() 
						{
							var grid_obj = Ext.getCmp('topTenGridId2');
							grid_obj.loadData(grid_obj.orgData);	
						}
					}
				},{
					title:memain.data[3].CallQualityView_fourth_block[2].title,
					width:'100%',
					layout:{type:'anchor',anchor:'50%'},
					margin:'0 2 0 0',
					id:'topTenGrid3',
					collapsed :false,
					items:[{
						xtype:'panel',
						padding:'0 10 10 10',
						layout:'fit',
						height:200,
						margin:0,							
						items:[{
							xtype:'commongrid',
							width:'99%',
							id:'topTenGridId3',								
							data:memain.data[3].CallQualityView_fourth_block[2],
							orgData:memain.data[3].CallQualityView_fourth_block[2]
						}],
					listeners:
							{
							 afterrender:function()
							 {
								 try
								 {
									var gridDataLength=memain.data[3].CallQualityView_fourth_block[2].data.items.length;
									 if(gridDataLength<10 && gridDataLength>0)
									 {
										this.setHeight(68+(30*gridDataLength));
									 }
								 }
								 catch (e)
								 {
								 }
								 
							 }
							},
					}],
					listeners:{
						expand: function() 
						{
							var grid_obj = Ext.getCmp('topTenGridId3');
							grid_obj.loadData(grid_obj.orgData);	
						}
					}
				},
				{
					title:memain.data[3].CallQualityView_fourth_block[3].title,
					width:'100%',
					layout:{type:'anchor',anchor:'50%'},
					margin:'0 2 0 0',
					id:'topTenGrid4',
					collapsed :false,
					items:[{
						xtype:'panel',
						padding:'0 10 10 10',
						layout:'fit',
						height:200,
						margin:0,							
						items:[{
							xtype:'commongrid',
							width:'99%',
							id:'topTenGridId4',								
							data:memain.data[3].CallQualityView_fourth_block[3],
							orgData:memain.data[3].CallQualityView_fourth_block[3]
						}],
					listeners:
							{
							 afterrender:function()
							 {
								 try
								 {
									var gridDataLength=memain.data[3].CallQualityView_fourth_block[3].data.items.length;
									 if(gridDataLength<10 && gridDataLength>0)
									 {
										this.setHeight(68+(30*gridDataLength));
									 }
								 }
								 catch (e)
								 {
								 }
								 
							 }
							},
					}],
					listeners:{
						expand: function() 
						{
							var grid_obj = Ext.getCmp('topTenGridId4');
							grid_obj.loadData(grid_obj.orgData);	
						}
					}
				}]
			});	
			
			var poorAppDataChaeck = memain.data[2].CallQualityView_third_block;
			for(var i=0;i<poorAppDataChaeck.length;i++)
			{
				if(poorAppDataChaeck[i].title.startsWith("Poor"))
				{
					if(!Ext.isEmpty(poorAppDataChaeck[0]) && poorAppDataChaeck[0].hasOwnProperty("DataSet"))
						Ext.getCmp('chartParent_poorApp_'+i).show();
					else
						Ext.getCmp('chartParent_poorApp_'+i).hide();
				}
			}
			if(!Ext.isEmpty(poorAppDataChaeck[0]) && poorAppDataChaeck[0].hasOwnProperty("DataSet"))
				Ext.getCmp('res_acc_pan_id').show();
			else
				Ext.getCmp('res_acc_pan_id').hide();

		}
	}
});