//.stateSymbol_HIGH, .stateSymbol_INTERMEDIATE, .stateSymbol_LOW, .stateSymbol_UNKNOWN, .stateSymbol_GOOD, .stateSymbol_GRAY
//.state_HIGH, .state_INTERMEDIATE, .state_LOW, .state_UNKNOWN, .state_GOOD, .state_GRAY
var store = Ext.create('Ext.data.Store', {
    fields:[  'measState', 'measureDisplay', 'availabilityState','layerTesturl'], 
	autoLoad: true,
    proxy: {
       type: 'ajax',
		url: '/final/monitor/clusterDashboard.jsp?reqFrom=wmi&compType='+encodeURIComponent(compType)+'&compName='+encodeURIComponent(compName), 
        reader: {
            type: 'json',
            root : 'wmi.gridData'
        }
    }
});

store.on({
    load: function (store, records) {        
		if(records.length == 0){
			$('#clusterVMIGrid-body').css({'border-width':'0px'})
		}
		else{
			$('#clusterVMIGrid-body').css({'border-width':'1px'})
			}

		
    }
});
Ext.define('ClusterDashboard.view.ClusterVMIGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.clustervmigrid',
	hideHeaders:true,
	cls:'clusterGrid',
	id:'clusterVMIGrid',
	
	autoScroll :true,

    ui: 'newGridPanel sapPlatformGrid',
    store:store,
	emptyText:'<div style="height:147px;width:100%;display:table"><div  class="msgFont" style="display:table-cell;vertical-align:middle"><div class="iconInformation" style="margin:0px auto"></div><div style="text-align:center" class="newFont_normal11 emptyTxtClr">'+noMeasure+'</div></div></div>',
    columns: [
        { text: 'status', dataIndex: 'measState', maxWidth: 25,
			renderer:function(value,metaData,record,rowIndex,colIndex){		
				return '<img style="vertical-align:middle;display:inline-block;margin-top:-2px;" src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" class="state_'+value+'"/>';
		}			
	},	 
	{ text: 'measureDisplay', dataIndex: 'measureDisplay', flex:1,
			renderer:function(value,metaData,record,rowIndex,colIndex){
				var layerUrl = record.get('layerTesturl');
				return '<a  href=\'javascript:wayToLayerModel("'+layerUrl+'")\'><img src="../images/clear.png" class="state_{name} stateImg" />'+value;
		}			
	},
	{  text: 'availabilityState',  dataIndex: 'availabilityState', maxWidth: 35,
		renderer:function(value,metaData,record,rowIndex,colIndex){		
				return '<div ><img style="vertical-align:middle;display:inline-block;margin-right:0px;margin-top:-2px;" src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" class="'+value+'"/></div>';
		}
	}
    ],
	listeners : {
		viewready:function(){
				//alert(this.store.data.items.length)
		},
		afterrender : function(cmp) {
			var WMIstore = cmp.getStore();
			WMIstoreCount = WMIstore.data.items;
			WMIStoreLength = WMIstoreCount.length;
			
		}
	}
     
 });


