Ext.define('ClusterDashboard.view.ClusterNodes', {
    extend: 'Ext.view.View',
    alias: 'widget.clusternodes',
    initComponent: function() {
        var me = this;
        me.callParent();
    },
	flex:1,
    itemSelector: 'div.thumb-wrap',
    emptyText: 'No Data Available',
    tpl: new Ext.XTemplate(
        '<tpl for=".">',
        '<div  class="clusterBoxShadow">',
			 '<tpl if="dataAvailabel == false">',
					'<div class="newFont_bold14" style="position:relative; top: 0px; z-index:1; width: 100%;padding: 8px 10px;text-transform:uppercase;">{title}</div>',
					'<div style="height:198;width:100%;display:table">',
					'<div  class="msgFont" style="display:table-cell;vertical-align:middle">',
					'<div class="iconInformation" style="margin:0px auto"></div>',
					'<div style="text-align:center" class="newFont_normal11">'+noMeasure+'</div>',
					'</div></div>',
			 '<tpl else>',
			
					'<div class="newFont_bold14" style="position:relative; top: 0px; z-index:1; width: 100%;padding: 8px 10px;text-transform:uppercase;">{title}</div>',

					'<div style="">',

					'<div class="clusterflow_rum_graph" style="margin: -19px 0 0 0; height: 128px;"></div>',
					'</div>',
					'<div  class="b_box" style="width:100%;">{name}',
					'<ul style="padding:2px 10px 0px 10px; margin: 0px 0 0 0;height: 89px;overflow-y: scroll;" >',
					'<tpl for="legendDescription">',
					'<li  class="clusterListing" style="overflow: hidden;text-overflow: ellipsis;white-space: nowrap;"><span class="font_normal13;" style="line-height:28px;" data-qtip="{value}"  >',
					'<tpl if="name">',
						//'<a  href=\'javascript:wayToLayerModel("{layerTesturl}")\'><img src="../images/clear.png" class="state_{name} stateImg" />{value}</a></span>',//				
					
						'<tpl if="ddUrl">',
							'<a  href=\'javascript:loadPopup("{ddUrl}")\'><img src="../images/clear.png" class="stateImg" style="width:10px;height:10px;background:{name};"/>{value}</a></span>',
						'<tpl else>',
							'<a  href=\'javascript:wayToLayerModel("{layerTesturl}")\'><img src="../images/clear.png" class="stateImg" style="width:10px;height:10px;background:{name};"/>{value}</a></span>',
						'</tpl>',

					'<tpl else>',
						'{value}</span>',
					'</tpl>',
					'<tpl if="imgIcon">',
					'<span><img src= "../images/clear.png" class="clusterOwner stateImg"  style="margin:0 0 0 10px"/></span>',
					'</tpl>',
					'</li>',
					'</tpl>',
					'</ul>',

					'</div>',
			'</tpl>',
        '</div>',
        '</tpl>'
    ),
    chartView: function(data) {
        
        var me = this;
        var chartProp = {

            credits: {
                enabled: false
            },
            chart: {
                type: 'pie',
                backgroundColor: 'transparent',
                borderColor:strSkin=="Dark"?"#c3c3c3":"#cccccc",
                plotBackgroundColor: null,
                plotBorderWidth: 0,
                plotShadow: false
            },
            legend: {
                align: 'right',
                verticalAlign: 'middle',
                layout: 'vertical',
                itemDistance: 0,
                //width: '100px',
                x: 0,
                y: 12,
                symbolPadding: 0,
                symbolWidth: 0.1,
                symbolHeight: 0.1,
                symbolRadius: 0,
                useHTML: true,
                symbolWidth: 0,
				//height:20,
				itemMarginTop:2,
				itemMarginBottom:0,
				//lineHeight:0,
				//margin:0,
				navigation: {
					//activeColor: '#3E576F',
					animation: true,
					arrowSize: 9,
					//inactiveColor: '#CCC',
					style: {
						color : strSkin=="Dark"?"#c6c6c6":"#c3c3c3",
						fontWeight: 'bold',
						fontSize: '9px'
					}
				},
                labelFormatter: function() {

                     if (this.name.toLowerCase() == 'ONLINE' || this.name.toLowerCase() == 'up') {
                       return '<div style="width:85px;display:inline-block;margin: 0 0 4px 0;cursor:default"><p  style="display:inline-block;"><span style="display:inline-block;background-color:' + this.color + ';width:3px;height:34px;margin:0 9px 0px 0"></span><div style="display:inline-block;"><span class="font_normal10" style="position:absolute;top:-1px;height:10px;font-size:10px; font-weight:400; display:inline-block;">' + this.name + '</span><span style="font-family:Roboto;font-size:27px;line-height:1;font-weight:400;">' + this.y + '</span></div></p></div>';
					 //  return '<div style="width:85px;height:35px;display:inline-block;margin: 0 0 4px 0;border:1px solid #000">1</div>'
                    } else{
                       return '<div style="width:85px;display:inline-block;margin: 0 0 4px 0;cursor:default"><p  style="display:inline-block;"><span style="display:inline-block;background-color:' + this.color + ';width:3px;height:34px;margin:0 9px 0px 0"></span><div  style="display:inline-block;"><span class="font_normal10" style="position:absolute;top:-1px;height:10px;font-size:10px; font-weight:400; display:inline-block;">' + this.name + '</span><span style="font-family:Roboto;font-size:27px;line-height:1;font-weight:400;">' + this.y + '</span></div></p></div>';
						//  return '<div style="width:85px;height:35px;display:inline-block;margin: 0 0 4px 0;border:1px solid #000">2</div>'
                    }
                },
                itemStyle: {
                    color: '#000',
                    fontWeight: 'bold',
                    fontSize: '19px',
                    fontFamily: 'Roboto'
                },
				
            },
            plotOptions: {
			
                pie: {
                    size: 80,
                    borderColor: strSkin=="Dark"?"#404040":"#ffffff",
                    dataLabels: {
                        enabled: false,
                    },
					point:{
					   events : {
						legendItemClick: function(e){
							e.preventDefault();
						}
					   }
				   },
                   showInLegend: true
                }
            },
            title: {
                text: data.legendDataTotal,
                margin: 0,
                y: 10,
                x: -57,
                // align: 'right',
                verticalAlign: 'middle',
                style: {
                    color: strSkin=="Dark"?"#c6c6c6":"#000000",
                    fontSize: '32px',
                    fontFamily: 'Roboto',
                    fontWeight: 'normal',
                    lineHeight: '1em',
                },
            },
            series: [{
                type: 'pie',
                name: 'Browser share',
                innerSize: '90%',
                states: {
                    hover: {
                        enabled: false
                    }
                },
                data: data.legendData
            }],
            exporting: {
                enabled: false
            },
            tooltip: {
                enabled: false
            },
        }
        return chartProp;
    },
    updateChart: function(data) {
		
        var me = this;
        if (!Ext.isEmpty($('#appflow_rum_graph'))) {
            var chartData = me.chartView(data); 
            $('#' + me.id + ' .clusterflow_rum_graph').highcharts(chartData);
        };
    },
    listeners: {
        viewready: function(cmp) {
            var me = this;            
            var chartData = cmp.chartView(me.store.data.items[0].data);
            $('#' + me.id + ' .clusterflow_rum_graph').highcharts(chartData);


        },
        resize: function(cmp) {
            var me = this;
            var chartData = cmp.chartView(me.store.data.items[0].data);
            $('#' + me.id + ' .clusterflow_rum_graph').highcharts(chartData);
        }
    }
});