

var store = Ext.create('Ext.data.Store', {
    storeId:'clusterNetworkStore',
    fields:['interface', 'clusterNetwork', 'status','ip'],
	//autoLoad: true,
   /* data:{'network':[
        { 'interface': 'Dev-Ethernet1',  "clusterNetwork":"Cluster_net1",  "status":"UP", "ip":"192.168.10.5" },
        { 'interface': 'Dev-Ethernet2',  "clusterNetwork":"Cluster_net3",  "status":"UP",  "ip":"192.138.10.4" },
    ]},*/
	//data: [],
    proxy: {
        type: 'ajax',
		url: '/final/monitor/clusterDashboard.jsp?reqFrom=network&compType='+encodeURIComponent(compType)+'&compName='+encodeURIComponent(compName), 
        reader: {
            type: 'json',
            root : 'network.gridData'
        },

		
    }
});
store.on({    
   // params:{'filter': value},
	load: function (store, records) {
		if(records.length == 0){			
			$('clusterNetworkGrid-body').css({'border-width':'0px'})
		}
		else{			
			$('clusterNetworkGrid-body').css({'border-width':'1px'})
			}

		
    }
    
});
Ext.define('ClusterDashboard.view.ClusterNetworkGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.clusternetworkgrid',
    layout : {
		type :'vbox',
		align: 'stretch'
	},
	flex:1,
	margin: '20 37 20 37',
    frame:false,
	autoScroll:true,
    ui: 'newGridPanel sapPlatformGrid medium',
	cls:'medium',
    store:store,
	emptyText:'<div style="height:72px;width:100%;display:table"><div  class="msgFont" style="display:table-cell;vertical-align:middle"><div class="iconInformation" style="margin:0px auto"></div><div class="newFont_normal11 emptyTxtClr" style="text-align:center">'+noMeasure+'</div></div></div>',
    columns: [
        { text: 'Interface',  dataIndex: 'interface', minWidth: 205, flex:1},
        { text: 'cluster network', dataIndex: 'clusterNetwork', minWidth: 205},
        { text: 'status', dataIndex: 'status', minWidth: 205,
				renderer: function(value, metaData, record, row, col, store, gridView){
				
				if(value!=null)
				{
					if(value === "Up")
					{					
						return '<img style="vertical-align:middle;display:inline-block;margin-right:5px;margin-top:-2px;" src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" class="iconNetworkInterfaceAvailable"/>'+value;
					}
					else
					{
						return '<img style="vertical-align:middle;display:inline-block;margin-right:5px;margin-top:-2px;" src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" class="iconNetworkInterfaceUnavailable"/>'+value;
					}
				}
			}	
		},
		{ text: 'IP Address', dataIndex: 'ip', flex: 1  }
    ],
    id : 'clusterNetworkGrid',
	listeners : {
		viewready : function(c){			
			//var thisWind = new Ext.LoadMask(c.getEl(), {
		//	msg: "Loading .."
		//});
		//thisWind.show();
		}
	}
 });

